C
C
C MAKSIM1.FOR ... Code for MAKSIM
C ================================
C DECIDE
C DELCOL
C DELROW
C FILEIT
C GLOBAL
C RESCOL
C RESROW
C
C
C
C--------------------------------------------------------------------------------
C
      SUBROUTINE DECIDE (ISEND, JCOLS, JROWS, NCOLS, NROWS,
     +                   COLIN, ROWIN)
C
C Decide next course of action
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN)    :: NCOLS, NROWS
      INTEGER, INTENT (OUT)   :: JCOLS, JROWS
      INTEGER, INTENT (INOUT) :: ISEND
      LOGICAL, INTENT (IN)    :: COLIN(NCOLS), ROWIN(NROWS)
C
C Locals
C      
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 7, IXL = 4, IYL = 4, LSHADE = 1, NSTART = 8)
      INTEGER    NUMBLD(30), NUMPOS(20)
      INTEGER    I, J
      CHARACTER (LEN = 12) I12(4), FORM12
      CHARACTER  TEXT(30)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    FULL_MENU, FULL
      PARAMETER (FULL_MENU = .FALSE.)
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_BOT = .FALSE., TAB_MID = .FALSE., TAB_TOP = .TRUE.)
      LOGICAL    ABORT, FIRST, REPEET, YES
      PARAMETER (FIRST = .FALSE.)
      EXTERNAL   FORM12
      EXTERNAL   LBOX01, YESNO2, PUTADV
      EXTERNAL   ADVISE
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
      JCOLS = 0
      JROWS = 0
      DO I = 1, NCOLS
         IF (COLIN(I)) JCOLS = JCOLS + 1
      ENDDO
      DO I = 1, NROWS
         IF (ROWIN(I)) JROWS = JROWS + 1
      ENDDO
      NUMBLD(1) = 4
      NUMBLD(3) = 1
      NUMBLD(4) = 1
      NUMBLD(5) = 1
      NUMBLD(6) = 1
      REPEET = .TRUE.
      
      DO WHILE (REPEET)
         I12(1) = FORM12(NCOLS)
         I12(2) = FORM12(JCOLS)
         I12(3) = FORM12(NROWS)
         I12(4) = FORM12(JROWS)
         FULL = FULL_MENU
         IF (FULL) THEN
            ISEND = 8
            NUMOPT = 12
            WRITE (TEXT,100) I12(1), I12(2), I12(3), I12(4)
         ELSE
            ISEND = 4
            NUMOPT = 8 
            WRITE (TEXT,200) I12(1), I12(2), I12(3), I12(4)  
         ENDIF     
         NTEXT = NSTART + NUMOPT - 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, ISEND, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                TAB_BOT, TAB_MID, TAB_TOP)
         IF (.NOT.FULL) THEN
            IF (ISEND.EQ.2) THEN
               ISEND = 3
            ELSEIF (ISEND.EQ.3) THEN
               ISEND = 6
            ELSEIF (ISEND.EQ.4) THEN
               ISEND = 8
            ELSEIF (ISEND.GE.5) THEN
               ISEND = ISEND + 4
            ENDIF             
         ENDIF  
         REPEET = .FALSE.
         IF (ISEND.EQ.1 .AND. JCOLS.EQ.NCOLS) THEN
            CALL PUTADV ('All columns are currently included')
            IF (FULL) REPEET = .TRUE.
         ELSEIF (ISEND.EQ.2 .AND. JCOLS.EQ.0) THEN
            CALL PUTADV ('All columns are currently excluded')
            IF (FULL) REPEET = .TRUE.
         ELSEIF (ISEND.EQ.3 .AND. JROWS.EQ.NROWS) THEN
            CALL PUTADV ('All rows are currently included')
            IF (FULL) REPEET = .TRUE.
         ELSEIF (ISEND.EQ.4 .AND. JROWS.EQ.0) THEN
            CALL PUTADV ('All rows are currently excluded')
            IF (FULL) REPEET = .TRUE.
         ELSEIF (ISEND.EQ.7 .OR. ISEND.EQ.8 .OR. ISEND.EQ.10) THEN
            IF (JROWS.EQ.0) THEN
               CALL PUTADV ('No rows are currently selected in')
               REPEET = .TRUE.
            ENDIF
            IF (JCOLS.EQ.0) THEN
               CALL PUTADV ('No columns are currently selected in')
               REPEET = .TRUE.
            ENDIF
         ELSEIF (ISEND.EQ.11) THEN
            CALL ADVISE (I, J,
     +                   BLANK,
     +                   ABORT, FIRST)
            REPEET = .TRUE.
         ELSEIF (ISEND.EQ.12) THEN
            YES = .FALSE.
            CALL YESNO2 (ICOLOR, IXL, IYL,
     +'This action will lose all your editing ... Are you sure ?', YES)
            IF (.NOT.YES) REPEET = .TRUE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Editing the data table'
     +/
     +/'Number of columns in total matrix =',1X,A
     +/'Number of columns now selected in =',1X,A
     +/'Number of rows in total matrix =',1X,A
     +/'Number of rows now selected in =',1X,A
     +/
     +/'Columns: include/restore variables'
     +/'Columns: exclude/suppress variables'
     +/'Rows: include/restore cases'
     +/'Rows: exclude/suppress cases'
     +/'View table for total matrix'
     +/'Scroll through total matrix'
     +/'View table for edited matrix'
     +/'Scroll through edited matrix'
     +/'Global editing options'
     +/'Write edited matrix to file (Save As... a Simfit file)'
     +/'Help'
     +/'Quit  ...  Exit current data set')
  200 FORMAT (
     + 'Editing the data table'
     +/
     +/'Number of columns in total matrix =',1X,A
     +/'Number of columns now selected in =',1X,A
     +/'Number of rows in total matrix =',1X,A
     +/'Number of rows now selected in =',1X,A
     +/
     +/'Suppress/restore: columns (variables)'
     +/'Suppress/restore: rows (cases)'
     +/'View: total matrix'
     +/'View: edited matrix'
     +/'Global editing options'
     +/'Write edited matrix to file (Save As... a Simfit file)'
     +/'Help'
     +/'Quit  ...  Exit current data set')     
      END
C
C---------------------------------------------------------------------------------
C
      SUBROUTINE DELCOL (NCOLS,
     +                   COL_LABELS,     
     +                   COLIN)
C
C Delete a column
C
      IMPLICIT   NONE
C
C Arguments
C
      
      INTEGER,             INTENT (IN)    :: NCOLS
      CHARACTER (LEN = *), INTENT (IN)    :: COL_LABELS(NCOLS)
      LOGICAL,             INTENT (INOUT) :: COLIN(NCOLS)
C
C Locals
C      
      INTEGER    I
      CHARACTER  TITLE*40
      PARAMETER (TITLE = 'Check the columns to be EXCLUDED')
      EXTERNAL   CHKBOX
      DO I = 1, NCOLS
         COLIN(I) = .NOT.COLIN(I)
      ENDDO 
      CALL CHKBOX (NCOLS,
     +             COL_LABELS, TITLE,
     +             COLIN)
      DO I = 1, NCOLS
         COLIN(I) = .NOT.COLIN(I)
      ENDDO          
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE DELROW (NCOLS, NFIELD, NRMAX, NROWS, 
     +                   MATRIX, ROW_LABELS, STRNG,
     +                   ROWIN)
C
C Delete rows
C
      IMPLICIT   NONE
C
C Arguments
C  
      INTEGER,             INTENT (IN)    :: NCOLS, NRMAX, NROWS    
      INTEGER,             INTENT (IN)    :: NFIELD(NCOLS)
      CHARACTER (LEN = *), INTENT (IN)    :: MATRIX(NRMAX), 
     +                                       ROW_LABELS(NROWS)      
      CHARACTER (LEN = *), INTENT (OUT)   :: STRNG
      LOGICAL,             INTENT (INOUT) :: ROWIN(NROWS)
C
C Locals
C      
      INTEGER    N0
      PARAMETER (N0 = 0)
      INTEGER    I, IADD1, ICOL, IOS, ISTART, ISTOP, IWIDE
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 7, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 5,
     +           NSTART = 15, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    LEN200
      DOUBLE PRECISION XBOT, XMID, XTOP
      CHARACTER  STRCPY*1024, TEXT(NTEXT)*(100)
      CHARACTER  TITLE*40
      PARAMETER (TITLE = 'Check the rows to be EXCLUDED')
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_BOT = .FALSE., TAB_MID = .FALSE.,
     +           TAB_TOP = .FALSE.)
      EXTERNAL   GETJM1, PUTADV, PUTWAR, GETRG2, GETTXT, LBOX01,
     +           TRIML1, LEN200, CHKBOX
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
   20 CONTINUE
      NUMDEC = NUMOPT
      WRITE (TEXT,100)
      NUMBLD(1) = 4
      NUMBLD(12) = 1
      NUMBLD(13) = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             TAB_BOT, TAB_MID, TAB_TOP)
      IF (NUMDEC.EQ.1) THEN
         DO I = 1, NROWS
            ROWIN(I) = .NOT.ROWIN(I)
         ENDDO
         CALL CHKBOX (NROWS,
     +                ROW_LABELS, TITLE,
     +                ROWIN)
         DO I = 1, NROWS
            ROWIN(I) = .NOT.ROWIN(I)
         ENDDO               
         RETURN
      ELSEIF (NUMDEC.EQ.2) THEN
         ICOL = N0
         CALL GETJM1 (N0, ICOL, NCOLS,
     +       'Number of the column to be selected on (0 = no action)')
         IF (ICOL.EQ.N0) GOTO 20
         CALL GETTXT (
     +'Symbol to search for in this column (e.g. 1.5, male, 0, etc.)',
     +                 STRNG)
         CALL TRIML1 (STRNG)
         IWIDE = NFIELD(ICOL)
         IF (LEN200(STRNG).GT.IWIDE) THEN
            CALL PUTADV (
     +'Symbol provided is wider than width of the column selected')
            GOTO 20
         ENDIF
      ELSEIF (NUMDEC.EQ.3 .OR. NUMDEC.EQ.4) THEN
         ICOL = N0
         CALL GETJM1 (N0, ICOL, NCOLS,
     +       'Number of the column to be selected on (0 = no action)')
         IF (ICOL.EQ.N0) GOTO 20
         CALL GETRG2 (XBOT, XTOP,
     +               'Lowest-value, Highest-value required')
      ELSEIF (NUMDEC.EQ.5) THEN
         RETURN
      ENDIF
      ISTOP = - 1
      DO I = 1, ICOL
         ISTART = ISTOP + 2
         ISTOP = ISTART + NFIELD(I) - 1
      ENDDO
      IF (NUMDEC.EQ.3 .OR. NUMDEC.EQ.4) THEN
         IWIDE = NFIELD(ICOL)
         IADD1 = 0
         DO I = 1, NROWS
            IADD1 = IADD1 + 1
            IF (ROWIN(I)) THEN
               STRNG(1:IWIDE) = MATRIX(I)(ISTART:ISTOP)
               READ(STRNG(1:IWIDE),*,END=40,ERR=40,IOSTAT=IOS) XMID
            ENDIF
         ENDDO
      ENDIF
      IADD1 = 0
      DO I = 1, NROWS
         IF (ROWIN(I)) THEN
            IF (NUMDEC.EQ.2) THEN
               STRCPY = MATRIX(I)(ISTART:ISTOP)
               CALL TRIML1 (STRCPY)
               IF (STRCPY(1:IWIDE).EQ.STRNG(1:IWIDE)) THEN
                   ROWIN(I) = .FALSE.
                   IADD1 = IADD1 + 1
               ENDIF
            ELSEIF (NUMDEC.EQ.3) THEN
               STRNG(1:IWIDE) = MATRIX(I)(ISTART:ISTOP)
               READ(STRNG(1:IWIDE),*,END=40,ERR=40,IOSTAT=IOS) XMID
               IF (XMID.GE.XBOT .AND. XMID.LE.XTOP) THEN
                  ROWIN(I) = .FALSE.
                  IADD1 = IADD1 + 1
               ENDIF
            ELSEIF (NUMDEC.EQ.4) THEN
               STRNG(1:IWIDE) = MATRIX(I)(ISTART:ISTOP)
               READ(STRNG(1:IWIDE),*,END=40,ERR=40,IOSTAT=IOS) XMID
               IF (XMID.LE.XBOT .OR. XMID.GE.XTOP) THEN
                  ROWIN(I) = .FALSE.
                  IADD1 = IADD1 + 1
               ENDIF
            ENDIF
         ENDIF
      ENDDO
      IF (IADD1.GT.0) THEN
         WRITE (STRNG,200) IADD1
         CALL PUTADV (STRNG)
      ELSE
         CALL PUTWAR ('No rows have been excluded by this option')
      ENDIF
      GOTO 20
   40 CONTINUE
      WRITE (STRNG,300) ICOL, IADD1
      CALL PUTADV (STRNG)
      GOTO 20
C
C Format statements
C      
  100 FORMAT (
     + 'Supressing rows'
     +/
     +/'There are several ways to exclude a chosen row, or set of rows.'
     +/'You can exclude rows from a check list with rows identified by'
     +/'the original column 1 cells. Otherwise you can specify a chosen'
     +/'column number and then suppress all rows with a defined symbol'
     +/'(for example: male, high, 1, 2, 3.26, overweight, etc.) in the'
     +/'chosen column. If all the column entries are numerical in your'
     +/'chosen column you can select on range (e.g. between 60 and 70,'
     +/'or less than 45 or greater than 57 [end-points included]).'
     +/
     +/'These options only suppress requested rows. They do not affect'
     +/'the status of rows that are not selected from these options.'
     +/
     +/'Exclude individual rows (by check list)'
     +/'Exclude rows with symbols (specify symbol)'
     +/'Exclude rows inside range (specify range)'
     +/'Exclude rows not in range (specify range)'
     +/'Cancel  ...  No change')
  200 FORMAT (
     +'Number of currently included rows excluded by this action =',I4)
  300 FORMAT ('Not-a-number encountered at column',I3,', row',I5)
      END
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE FILEIT (JCOLS, JROWS, NCOLS, NFIELD, NOUT, NRMAX,
     +                   NROWS,
     +                   FNAME, MATRIX, STRNG,
     +                   ABORT, COLIN, ROWIN, ROWNUM)
C
C ACTION : File selected matrix
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: JCOLS, JROWS, NCOLS, NOUT,
     +                                       NRMAX, NROWS
      INTEGER,             INTENT (IN)    :: NFIELD(NCOLS)
      CHARACTER (LEN = *), INTENT (IN)    :: MATRIX(NRMAX)
      CHARACTER (LEN = *), INTENT (OUT)   :: STRNG
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME
      LOGICAL,             INTENT (IN)    :: COLIN(NCOLS), ROWIN(NROWS)
      LOGICAL,             INTENT (OUT)   :: ABORT, ROWNUM(NROWS)
C
C Locals
C      
      INTEGER    I, IOS, J, JADD1, JADD2, KADD1, KADD2, NERR,
     +           NUMROW
      INTEGER    ICOLOR, IX, IY, LSHADE, NSTART, NTEXT, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, LSHADE = 0, NSTART =  8,
     +           NTEXT = 10, NUMOPT = 3)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION XTEMP
      CHARACTER (LEN = 12) I12(7), FORM12 
      CHARACTER  TITLE*80, TEXT(NTEXT)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ALLNUM
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_BOT = .FALSE., TAB_MID = .FALSE., TAB_TOP = .TRUE.)
      EXTERNAL   FORM12
      EXTERNAL   OFILES, GETTXT, PUTWAR, LBOX01, PUTADV
      INTRINSIC  NINT
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Initialise
C
      XTEMP = 0.0D+00!to silence NAGfor
      NERR = NINT(XTEMP)  
      NERR = 0
      NUMROW = 0
C
C Check if all numbers
C
      DO I = 1, NROWS
         ROWNUM(I) = .FALSE.
         IF (ROWIN(I)) THEN
            ALLNUM = .TRUE.
            JADD1 = 1
            JADD2 = 0
            DO J = 1, NCOLS
               JADD2 = JADD2 + NFIELD(J) + 1
               IF (COLIN(J)) THEN
                  STRNG(1:NFIELD(J)) = MATRIX(I)(JADD1:JADD2 - 1)
                  READ (STRNG(1:NFIELD(J)),*,IOSTAT=IOS) XTEMP
                  IF (IOS.NE.0) THEN
                     ALLNUM = .FALSE.
                     NERR = NERR + 1
                  ENDIF
               ENDIF
               JADD1 = JADD2 + 1
            ENDDO
            IF (ALLNUM) THEN
               NUMROW = NUMROW + 1
               ROWNUM(I) = .TRUE.
            ENDIF
         ENDIF
      ENDDO
      IF (NERR.NE.0) THEN
         WRITE (STRNG,100) NERR
         CALL PUTWAR (STRNG)
      ENDIF
      I12(1) = FORM12(NCOLS)
      I12(2) = FORM12(JCOLS)
      I12(3) = FORM12(NROWS)
      I12(4) = FORM12(JROWS)
      I12(5) = FORM12(NERR)
      I12(6) = FORM12(JROWS - NUMROW)
      I12(7) = FORM12(NUMROW)
C      WRITE (TEXT,200) NCOLS, JCOLS, NROWS, JROWS, NERR, JROWS - NUMROW,
C     +                 NUMROW
      WRITE (TEXT,200) (I12(I), I = 1, 7)
      NUMDEC = 2
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             TAB_BOT, TAB_MID, TAB_TOP)
      IF ((NUMDEC.EQ.1 .AND. JROWS.LT.1) .OR.
     +    (NUMDEC.EQ.2 .AND. NUMROW.LT.1)) THEN
         CALL PUTADV ('No valid rows are currently selected')
         RETURN
      ENDIF
      IF (NUMDEC.EQ.1 .AND. JROWS.GT.NUMROW) CALL PUTADV (
     +'Resulting non-numerical data file cannot be analysed by Simfit')
      IF (NUMDEC.LT.NUMOPT) THEN
         CLOSE (UNIT = NOUT)
         I = 1
         CALL OFILES (I, NOUT, FNAME, ABORT)
         IF (ABORT) THEN
            FNAME = BLANK
            CLOSE (UNIT = NOUT)
            RETURN
         ENDIF
         CALL GETTXT ('Title for the file', TITLE)
         WRITE (NOUT,300) TITLE
         IF (NUMDEC.EQ.1) THEN
            WRITE (NOUT,400) JROWS, JCOLS
            DO I = 1, NROWS
               IF (ROWIN(I)) THEN
                  STRNG = BLANK
                  JADD1 = 1
                  JADD2 = 0
                  KADD1 = 1
                  KADD2 = 0
                  DO J = 1, NCOLS
                     JADD2 = JADD2 + NFIELD(J) + 1
                     IF (COLIN(J)) THEN
                        KADD2 = KADD2 + NFIELD(J) + 1
                        STRNG(KADD1:KADD2) = MATRIX(I)(JADD1:JADD2)
                        KADD1 = KADD2 + 1
                     ENDIF
                     JADD1 = JADD2 + 1
                  ENDDO
                  WRITE (NOUT,300) STRNG
               ENDIF
            ENDDO
         ELSE
            WRITE (NOUT,400) NUMROW, JCOLS
            DO I = 1, NROWS
               IF (ROWNUM(I)) THEN
                  STRNG = BLANK
                  JADD1 = 1
                  JADD2 = 0
                  KADD1 = 1
                  KADD2 = 0
                  DO J = 1, NCOLS
                     JADD2 = JADD2 + NFIELD(J) + 1
                     IF (COLIN(J)) THEN
                        KADD2 = KADD2 + NFIELD(J) + 1
                        STRNG(KADD1:KADD2) = MATRIX(I)(JADD1:JADD2)
                        KADD1 = KADD2 + 1
                     ENDIF
                     JADD1 = JADD2 + 1
                  ENDDO
                  WRITE (NOUT,300) STRNG
               ENDIF
            ENDDO
         ENDIF
         WRITE (NOUT,500) 1
         WRITE (NOUT,300) 'Default line'
         CLOSE (UNIT = NOUT)
      ENDIF
  100 FORMAT (
     +'Selected matrix is not numerical. There are',I6,' non-numbers.')
  200 FORMAT (
     + 'Total number of columns =',1X,A
     +/'Number of columns selected =',1X,A
     +/'Total number of rows =',1X,A
     +/'Number of of rows selected =',1X,A
     +/'Number of non-numerical items =',1X,A
     +/'Number of non-numerical rows =',1X,A
     +/'Number of numerical rows =',1X,A
     +/'File all selected matrix'
     +/'File only numerical rows'
     +/'Cancel')
  300 FORMAT (A)
  400 FORMAT (2I6)
  500 FORMAT (I6)
      END
C
C--------------------------------------------------------------------------------------
C
      SUBROUTINE GLOBAL (NCOLS, NROWS,
     +                   COLIN, ROWIN)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN)    :: NCOLS, NROWS
      LOGICAL, INTENT (INOUT) :: COLIN(NCOLS), ROWIN(NROWS)
C
C Locals
C      
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 7, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 5,
     +           NSTART = 13, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    I
      CHARACTER  TEXT(NTEXT)*100
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .TRUE., HIGH = .TRUE.)
      EXTERNAL   LBOX01
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      NUMDEC = NUMOPT
      WRITE (TEXT,100)
      NUMBLD(1) = 4
      NUMBLD(3) = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (NUMDEC.EQ.1) THEN
         DO I = 1, NCOLS
            COLIN(I) = .FALSE.
         ENDDO
      ELSEIF (NUMDEC.EQ.2) THEN
         DO I = 1, NCOLS
            COLIN(I) = .TRUE.
         ENDDO
      ELSEIF (NUMDEC.EQ.3) THEN
         DO I = 1, NROWS
            ROWIN(I) = .FALSE.
         ENDDO
      ELSEIF (NUMDEC.EQ.4) THEN
         DO I = 1, NROWS
            ROWIN(I) = .TRUE.
         ENDDO
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Global options' 
     +/
     +/'These are dangerous options ... be careful to choose correctly.'
     +/
     +/'Sometimes it is best to start with a full data matrix and then'
     +/'proceed to suppress/restore selected rows and columns, but'
     +/'often you might prefer to start with an empty matrix, and then'
     +/'restore (i.e. include) selected rows and columns. You should'
     +/'only use these options at the start of an editing session.'
     +/'Note, however, that the total matrix is never discarded, until'
     +/'you decide to quit the editing session altogether.'
     +/
     +/'Columns: Exclude (i.e. suppress) all columns'
     +/'Columns: Include (i.e. restore) all columns'
     +/'Rows: Exclude (i.e. suppress) all rows'
     +/'Rows: Include (i.e. restore) all rows'
     +/'Cancel ... No changes')

      END
C
C------------------------------------------------------------
C
      SUBROUTINE RESCOL (NCOLS,
     +                   COL_LABELS, 
     +                   COLIN)
C
C Restore a column
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NCOLS
      CHARACTER (LEN = *), INTENT (IN)    :: COL_LABELS(NCOLS)
      LOGICAL,             INTENT (INOUT) :: COLIN(NCOLS)
C
C Locals
C      
      CHARACTER  TITLE*40
      PARAMETER (TITLE = 'Check the columns to be INCLUDED')
      EXTERNAL   CHKBOX
      CALL CHKBOX (NCOLS,
     +             COL_LABELS, TITLE,
     +             COLIN)
      END
C
C--------------------------------------------------------------------------
C
      SUBROUTINE RESROW (NCOLS, NFIELD, NRMAX, NROWS,
     +                   MATRIX, ROW_LABELS, STRNG,
     +                   ROWIN)
C
C Restore a row
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NCOLS, NRMAX, NROWS
      INTEGER,             INTENT (IN)    :: NFIELD(NCOLS)
      CHARACTER (LEN = *), INTENT (IN)    :: MATRIX(NRMAX),
     +                                       ROW_LABELS(NROWS)      
      CHARACTER (LEN = *), INTENT (OUT)   :: STRNG
      LOGICAL,             INTENT (INOUT) :: ROWIN(NROWS)
C
C Locals
C      
      INTEGER    N0
      PARAMETER (N0 = 0)
      INTEGER    I, IADD1, ICOL, IOS, ISTART, ISTOP, IWIDE
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 7, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 5,
     +           NSTART = 15, NTEXT = NUMOPT + NSTART - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    LEN200
      DOUBLE PRECISION XBOT, XMID, XTOP
      CHARACTER  STRCPY*1024, TEXT(NTEXT)*100
      CHARACTER  TITLE*40
      PARAMETER (TITLE = 'Check the rows to be INCLUDED')
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_BOT = .FALSE., TAB_MID = .FALSE.,
     +           TAB_TOP = .FALSE.)
      EXTERNAL   GETJM1, PUTADV, PUTWAR, GETRG2, GETTXT, LBOX01,
     +           TRIML1, LEN200, CHKBOX
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
   20 CONTINUE
      NUMDEC = NUMOPT
      WRITE (TEXT,100)
      NUMBLD(1) = 4
      NUMBLD(12) = 1
      NUMBLD(13) = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             TAB_BOT, TAB_MID, TAB_TOP)
      IF (NUMDEC.EQ.1) THEN
         CALL CHKBOX (NROWS,
     +                ROW_LABELS, TITLE,
     +                ROWIN)
         RETURN
      ELSEIF (NUMDEC.EQ.2) THEN
         ICOL = N0
         CALL GETJM1 (N0, ICOL, NCOLS,
     +       'Number of the column to be selected on (0 = no action)')
         IF (ICOL.EQ.N0) GOTO 20
         CALL GETTXT (
     +'Symbol to search for in this column (e.g. 1.5, male, 0, etc.)',
     +                 STRNG)
         CALL TRIML1 (STRNG)
         IWIDE = NFIELD(ICOL)
         IF (LEN200(STRNG).GT.IWIDE) THEN
            CALL PUTADV (
     +'Symbol provided is wider than width of the column selected')
            GOTO 20
         ENDIF
      ELSEIF (NUMDEC.EQ.3 .OR. NUMDEC.EQ.4) THEN
         ICOL = N0
         CALL GETJM1 (N0, ICOL, NCOLS,
     +       'Number of the column to be selected on (0 = no action)')
         IF (ICOL.EQ.N0) GOTO 20
         CALL GETRG2 (XBOT, XTOP,
     +               'Lowest-value, Highest-value required')
      ELSEIF (NUMDEC.EQ.5) THEN
         RETURN
      ENDIF
      ISTOP = - 1
      DO I = 1, ICOL
         ISTART = ISTOP + 2
         ISTOP = ISTART + NFIELD(I) - 1
      ENDDO
      IWIDE = NFIELD(ICOL)
      IADD1 = 0
      DO I = 1, NROWS
         IF (.NOT.ROWIN(I)) THEN
            IF (NUMDEC.EQ.2) THEN
               STRCPY = MATRIX(I)(ISTART:ISTOP)
               CALL TRIML1 (STRCPY)
               IF (STRCPY(1:IWIDE).EQ.STRNG(1:IWIDE)) THEN
                  ROWIN(I) = .TRUE.
                  IADD1 = IADD1 + 1
               ENDIF
            ELSEIF (NUMDEC.EQ.3) THEN
               STRNG(1:IWIDE) = MATRIX(I)(ISTART:ISTOP)
               READ(STRNG(1:IWIDE),*,END=40,ERR=40,IOSTAT=IOS) XMID
               IF (XMID.GE.XBOT .AND. XMID.LE.XTOP) THEN
                  ROWIN(I) = .TRUE.
                  IADD1 = IADD1 + 1
               ENDIF
            ELSEIF (NUMDEC.EQ.4) THEN
               STRNG(1:IWIDE) = MATRIX(I)(ISTART:ISTOP)
               READ(STRNG(1:IWIDE),*,END=40,ERR=40,IOSTAT=IOS) XMID
               IF (XMID.LE.XBOT .OR. XMID.GE.XTOP) THEN
                  ROWIN(I) = .TRUE.
                  IADD1 = IADD1 + 1
               ENDIF
            ENDIF
         ENDIF
   40    CONTINUE
      ENDDO
      IF (IADD1.GT.0) THEN
         WRITE (STRNG,200) IADD1
         CALL PUTADV (STRNG)
      ELSE
         CALL PUTWAR ('No rows have been included by this option')
      ENDIF
      GOTO 20
C
C Format statements
C      
  100 FORMAT (
     + 'Restoring rows'
     +/
     +/'There are several ways to include a chosen row, or set of rows.'
     +/'You can include rows from a check list with rows identified by'
     +/'the original column 1 cells. Otherwise you can specify a chosen'
     +/'column number, and then restore all rows with a defined symbol'
     +/'(for example: male, high, 1, 2, 3.26, overweight, etc.) in the'
     +/'chosen column. If all the column entries are numerical in your'
     +/'chosen column you can select on range (e.g. between 60 and 70,'
     +/'or less than 45 or greater than 57 [end-points included])'
     +/
     +/'These options only restore requested rows.  They do not affect'
     +/'the status of rows that are not selected from these options.'
     +/
     +/'Include individual rows (by check list)'
     +/'Include rows with symbols (specify symbol)'
     +/'Include rows inside range (specify range)'
     +/'Include rows not in range (specify range)'
     +/'Cancel  ...  No change')
  200 FORMAT (
     +'Number of currently excluded rows included by this action =',I4)
      END
C
C
