C
C This version of MMFIT requires the following source files:-
C ============================================================
C
C MMFIT1.FOR: ADVISE, DATAIN, DATFIT, DATOUT
C MMFIT2.FOR: DERIV1, DERIV2, DETAIL, FUNCT1, RANDOM, TESTQS, VMAXKM, ZMOD
C DLLCHK.FOR: consistency checker
C
C These must now be included
C ==========================
C
C     INCLUDE 'mmfit1.for', NOLIST
C     INCLUDE 'mmfit2.for', NOLIST
C     INCLUDE 'dllchk.for', NOLIST
C
C The MAIN program
C

C-----------------------------------------
C Start of Module to replace common blocks
C-----------------------------------------
      MODULE MODULE_MMFIT
      
      IMPLICIT NONE
         
      INTEGER    ITIME, MODE, NMAX, NPTS
      INTEGER    NFACT
      PARAMETER (NFACT = 12)
      DOUBLE PRECISION DOFDOM, FACT(12)
        
      DOUBLE PRECISION, ALLOCATABLE :: ERRY(:), THEORY(:), XVAL(:),
     +                                 YVAL(:)
      LOGICAL,          ALLOCATABLE :: EQSAV(:), EQUAL(:)
         
      END MODULE MODULE_MMFIT
C---------------------------------------
C End of module to replace common blocks
C---------------------------------------  

C
C The following parameters must be consistent
C      INTEGER    NN, NX
C      PARAMETER (NN = 6, NX = 2*NN)    
C where NN = maximum order, NFACT >= NX = maximum no. of parameters
C
      PROGRAM MAIN
C
C VERSION : details from SIMVER/DLLCHK
C FORTRAN : 95, Double precision
C INPUT   : File with TITLE, NPTS, X, Y, Standard error in Y
C           as prepared by programs MAKFIL, MAKDAT, ADDERR or EDITFL
C ACTION  : Best-fit multi Michaelis-Menten function.
C           Random search for starting values.
C           Optimisation using a quasi-Newton routine and F test.
C           X- and Y-data transformed to 'ORDER UNITY' internally.
C MODEL   : Y(X) = summation  V(I)*X/(K(I) + X)
C OUTPUT  : Weighted sums of squares, F statistics, parameters
C           and residuals as requested. All details written
C           to a data output file
C ADVICE  : Make sure that the standard error in Y > 0.0,
C           and X in increasing order
C           Set parameters : NF    = output unit
C                            NIN   = input unit
C                            NMAX  = maximum number of points
C                            NN    = maximum order
C                            NX    = no. of parameters (NX = 2*NN)
C                            NHESS = NX + 1 (Hessian to CV)
C AUTHOR  : W. G. Bardsley, 23/2/90
C           28/04/1991 Added SCREEN and GRFGK2/3
C           18/06/1992 GETNUM, GETCHR, ENDALL, REPEAT, GKSR01, GKST02, GKST03
C                      CHECKT, CHECKW, DIVIDE
C           09/01/1992 GET???, PUT??? routines and compressed
C           08/04/1993 Added GKST04 and diagonal 1 to correlation matrix
C           14/06/1993 RESFIL
C           06/03/1994 DBOS version 
C           20/02/1995 Version for Salamanca
C           27/10/1995 Streamlined dbos version and split source file
C           09/09/1997 win32 version .. QNFIT1/LBFGS replacing E04JAF
C                     COMMON block is needed to communicate with the model
C           21/03/1998 Added GOGOGO and NEW
C           07/08/1998 added dllchk
C           02/10/1998 FTN95 version ... re-dimensioned the arrays
C           14/12/1998 replaced TUTORS by TUTOR1
C           19/08/1999 revised control and removed GOTOs
C           11/09/1999 added calls to WINDOW
C           05/12/1999 increased dimension LW1
C           12/02/2000 introduced SIMVER (packaged up with DLLCHK.FOR)
C           13/08/2000 introduced MODE and the Isotope = hot/cold option
C           04/04/2001 revised
C           04/05/2001 added call to GDCON0 for deconvolutions
C           18/05/2001 added call to PCVTST
C           16/06/2001 added call to ARRPAR to rearrange parameters
C           30/07/2005 increased DVER to *30 and added to call to ADVISE
C           15/10/2007 revised for version 6 and added module_mmfit to replace common blocks
C           26/11/2013 increased NGRAF to 200 and introduced TABLE6 to display results
C

      USE MODULE_MMFIT
      
      IMPLICIT   NONE
      
      INTEGER    I, IOS, I_LENGTH, I_STATUS, ITEMP, J 
      INTEGER    N0, N1, N2, N10, NN, NX
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N10 = 10, NN = 6, NX = 2*NN)
      INTEGER    NF, NIN
      PARAMETER (NF = 4, NIN = 3)
      INTEGER    LIW, LW1, LW2, MVAL, NHESS
      PARAMETER (LIW = 3*NX,
     +           MVAL = 10,
     +           LW1 = 2*(2*MVAL*NX + 4*NX + 11*MVAL*MVAL + 8*MVAL),
     +           LW2 = 3*NX,
     +           NHESS = NX + 1)
      INTEGER    KLOG, LIW1, NGRAF
      PARAMETER (KLOG = 10, LIW1 = NX, NGRAF = 200)
      INTEGER    IERR, ISEND, NCOL, NROW
      INTEGER    ISTATE(NX), IW(LIW), IW1(LIW1), NBD(NX), NPAR(NN)
      INTEGER    MAXNUM, NBIG, NDOF, NRAND, NSMALL, NSTART, NSTOP,
     +           NUMBER
     
      DOUBLE PRECISION BL(NX), BU(NX), CORR(NX,NX), DIAGV(NX), ERR(NX),
     +                 G(NX), PAR(NX), STORES(NX), TL(NX), TPER(NX),
     +                 TU(NX), X(NX)
      DOUBLE PRECISION CV(NHESS,NHESS), HESSEX(NHESS,NHESS)
      DOUBLE PRECISION WSSQ(NN), W1(LW1), W2(LW2)
      DOUBLE PRECISION XGRAF(NGRAF)
      DOUBLE PRECISION OBJFUN, XM, YT
      DOUBLE PRECISION EPSI, RTOL, SIGMA
      DOUBLE PRECISION XVER, YVER
      
      DOUBLE PRECISION, ALLOCATABLE :: RESID(:), WRESID(:), XSAV(:),
     +                                 YSAV(:), ZSAV(:)
      DOUBLE PRECISION, ALLOCATABLE :: EE(:), XX(:), YY(:), ZZ(:)
      DOUBLE PRECISION, ALLOCATABLE :: FJACC(:,:)
      
      CHARACTER  FNAME1*1024, FNAME2*1024, TITLE*100
      CHARACTER  COMMAND*30, DVER*30, PVER*15
      PARAMETER (PVER = 'w_mmfit.exe')
      CHARACTER  BLANK*1, LETTER*1, PNAME*5
      PARAMETER (BLANK = ' ', PNAME = 'MMFIT')
      
      LOGICAL    DOIT, FIRST, NEW, REPEET
      LOGICAL    FREE(NX), ISTOP, NOUT(KLOG)
      LOGICAL    ABORT, ACTION, JUMP, SHOW

C
C NAG type external
C
      EXTERNAL G05CCF$
C
C Other externals 
C
      EXTERNAL  WINDOW
      EXTERNAL  ADVISE, DATAIN, DETAIL, RANDOM, DATFIT, DATOUT,
     +          GOGOGO, DLLCHK, SIMVER, M_FITONE
      INTRINSIC COMMAND_ARGUMENT_COUNT, GET_COMMAND_ARGUMENT
      INTRINSIC MAX

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE, 
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C
C
C First check the command line to initialise ISEND and JUMP
C
      ITEMP = COMMAND_ARGUMENT_COUNT()  
      IF (ITEMP.EQ.N1) THEN
         CALL GET_COMMAND_ARGUMENT (N1, COMMAND, I_LENGTH, I_STATUS)
         IF (I_LENGTH.GE.N1 .AND. I_STATUS.EQ.N0) THEN
C
C 29/10/2023
C Replaced non-integer characters by blanks to interpret '0' as 0 which causes trouble otherwise
C It appears that 'i' is passed by run_program and returned as such by command argument 
C retrieval and read accurately except for '0' which is not read as 0 even if the quotes are 
C removed. Is it being read as a C string terminator ? So 0 is changed to 11 to call sv_simstat. 
C         
            do i = 1, i_length
               letter = command(i:i)
               j = ichar(letter)
               if (j.lt.48 .or. j.gt.57) command(i:i) = blank
            enddo  
             
            READ (COMMAND,*,IOSTAT=IOS) I
             
            IF (IOS.EQ.N0) THEN
               IF (I.GE.N1 .AND. I.LE.N10) THEN
                  ITEMP = I
               ELSE
                  ITEMP = N0
               ENDIF
            ELSE
               ITEMP = N0
            ENDIF
         ELSE
            ITEMP = N0
         ENDIF      
      ENDIF
      IF (ITEMP.EQ.N0) THEN
         JUMP = .FALSE.
      ELSE
         JUMP = .TRUE.
      ENDIF
C
C Advise
C
      FIRST = .TRUE.
      IF (JUMP) THEN
         MODE = 1
         ISTOP = .FALSE.
      ELSE
         CALL ADVISE (MODE, 
     +                DVER,
     +                ISTOP, FIRST)
      ENDIF
      IF (ISTOP) THEN
         DOIT = .FALSE.
      ELSE
         NRAND = 1
         NSTART = N1
         NSTOP = N2
         DOIT = .TRUE.
C
C Initialise random number generator, filenames and NEW
C
         CALL G05CCF$
         NCOL = 0
         NROW = 0
         FNAME1 = BLANK
         FNAME2 = BLANK
         NEW = .TRUE.
C
C Initialise output types
C
C nout(1)  ... display analysis table
C nout(2)  ... display starting estimates
C nout(3)  ... display random search
C nout(4)  ... plot    best fit curves
C nout(5)  ... plot    residuals
C nout(6)  ... display residuals table
C nout(7)  ... file    residuals table
C nout(8)  ... high precision convergence test
C nout(9)  ... parameters and covariance matrix
C nout(10) ... graphical deconvolution
C
         NOUT(1) = .TRUE.
         NOUT(2) = .FALSE.
         NOUT(3) = .FALSE.
         NOUT(4) = .TRUE.
         NOUT(5) = .FALSE.
         NOUT(6) = .TRUE.
         NOUT(7) = .FALSE.
         NOUT(8) = .FALSE.
         NOUT(9) = .FALSE.
         NOUT(10) = .TRUE.
      ENDIF
C
C Main branch point to read in a data set and decide what to do
C
      IF (DOIT) THEN
         REPEET = .TRUE.
         DO WHILE (REPEET)
            IF (NEW) THEN
C
C Get a new data file
C              
               ISEND = MODE + 2
               CALL M_FITONE (ISEND, NCOL, NIN, NROW,
     +                        FNAME1, TITLE) 
               IF (NCOL.GE.2 .AND. NCOL.LE.3 .AND. NROW.GT.1) THEN
                  NPTS = NROW
                  NMAX = MAX(NPTS,NGRAF)
                  ISTOP = .FALSE.
                  NEW = .FALSE.
                  IERR = 0
                  IF (ALLOCATED(ERRY)) DEALLOCATE(ERRY, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(THEORY)) DEALLOCATE(THEORY, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(XVAL)) DEALLOCATE(XVAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(YVAL)) DEALLOCATE(YVAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(EQSAV)) DEALLOCATE(EQSAV, STAT = IERR)
                  IF (IERR.NE.0) EXIT 
                  IF (ALLOCATED(EQUAL)) DEALLOCATE(EQUAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT             
                  ALLOCATE(ERRY(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  ALLOCATE(THEORY(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(XVAL(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(YVAL(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(EQSAV(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT 
                  ALLOCATE(EQUAL(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT  

                  IF (ALLOCATED(RESID)) DEALLOCATE(RESID, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(WRESID)) DEALLOCATE(WRESID, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(XSAV)) DEALLOCATE(XSAV, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(YSAV)) DEALLOCATE(YSAV, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(ZSAV)) DEALLOCATE(ZSAV, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(EE)) DEALLOCATE(EE, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(XX)) DEALLOCATE(XX, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(YY)) DEALLOCATE(YY, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(ZZ)) DEALLOCATE(ZZ, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(FJACC)) DEALLOCATE(FJACC, STAT = IERR)
                  IF (IERR.NE.0) EXIT  

                  ALLOCATE(RESID(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(WRESID(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(XSAV(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(YSAV(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(ZSAV(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(EE(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(XX(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(YY(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(ZZ(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT 
                  ALLOCATE(FJACC(NMAX,NX), STAT = IERR)
                  IF (IERR.NE.0) EXIT   
               ELSE
                  ISTOP = .TRUE.
               ENDIF                      
            ENDIF  
            IF (.NOT.ISTOP) THEN
C
C Ininitalise the data
C              
               CALL DATAIN (MODE, NF, NIN, NMAX, NPTS,
     +                      EE, EPSI, ERRY, RTOL, XM, XVAL, XX, YT,
     +                      YVAL, YY,
     +                      FNAME1, FNAME2,
     +                      EQUAL, ISTOP, JUMP, NEW)
            ENDIF
            IF (ISTOP) THEN
               FNAME1 = BLANK
               DOIT = .FALSE.
            ELSE
               DOIT = .TRUE.
            ENDIF
            IF (DOIT) THEN
C
C Details of program operation
C              
              
               CALL DETAIL (KLOG, MAXNUM, NBIG, NN, NRAND, NSMALL,
     +                      NSTART, NSTOP,
     +                      SIGMA,
     +                      ISTOP, NOUT)
               IF (ISTOP) THEN
                  DOIT = .FALSE.
               ELSE
                  DOIT = .TRUE.
               ENDIF
            ENDIF
C
C Loop to fit models of order NSTART to NSTOP
C
            IF (DOIT) THEN
               DO ITIME = NSTART, NSTOP
C
C Random parameter starting estimates
C                 
                  CALL RANDOM (ISTATE, ITIME, KLOG, MAXNUM, MODE, NBIG,
     +                         NDOF, NF, NN, NPAR, NPTS, NRAND, NSMALL,
     +                         NUMBER, NX,
     +                         DOFDOM, FACT, SIGMA, STORES, WSSQ, X, XM,
     +                         YT,
     +                         ISTOP, NOUT)
C
C Curve fitting
C     
                  CALL DATFIT (ISTATE, ITIME, IW, KLOG, LIW, LW1, LW2,
     +                         MODE, NBD, NDOF, NF, NPAR, NPTS, NN, NX,
     +                         BL, BU, DOFDOM, EPSI, FACT, G, OBJFUN,
     +                         WSSQ, W1, W2, X, XM, YT,
     +                         ISTOP, NOUT)
C
C Output results
C     
                  CALL DATOUT (ISTATE, ITIME, IW1, KLOG, LIW1, LW2,
     +                         MODE, NDOF, NF, NGRAF, NHESS, NMAX, NN,
     +                         NPAR, NPTS, NSTART, NX,
     +                         CORR, CV, DIAGV, EE, ERR, ERRY, FACT,
     +                         FJACC, G, HESSEX, OBJFUN, PAR, RESID,
     +                         RTOL, THEORY, TL, TPER, TU, W2, WRESID,
     +                         WSSQ, X, XGRAF, XM, XSAV, XVAL, XX, YSAV,
     +                         YT, YVAL, YY, ZSAV, ZZ,
     +                         EQSAV, EQUAL, FREE, ISTOP, NOUT)
               ENDDO
            ENDIF
C
C Another go ?
C
            CALL GOGOGO (NF,
     +                   FNAME1, FNAME2, PNAME, 
     +                   ISTOP, NEW)
            IF (ISTOP) THEN
               REPEET = .FALSE.
            ELSE
               REPEET = .TRUE.
            ENDIF
         ENDDO
      ENDIF
C
C Terminate the program
C

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C
      CLOSE (UNIT = NF)
      END
C
C
