C
C MMFIT1.FOR: Include file for MMFIT.FOR
C ==========
C
C ADVISE
C DATAIN
C DATFIT
C DATOUT
C
C
      SUBROUTINE ADVISE (MODE, 
     +                   DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (INOUT) :: MODE
      CHARACTER (LEN = *), INTENT (IN)    :: DVER
      LOGICAL,             INTENT (IN)    :: FIRST
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 4)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_MMFIT
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Provide details',
     +'Substrate mode',
     +'Inhibitor mode',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_MMFIT ('mmfit')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            MODE = 1
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            MODE = 2
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.4) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `MMFIT'
     +/'        `      '
     +/'Action  `Best-fit Michaelis-Menten equation or sequence of'
     +/'        `sums of Michaelis-Menten functions by constrained'
     +/'        `weighted least squares regression (quasi Newton)'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF.PNG, and SVG'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
       END
C
C-------------------------------------------------------------------------
C
      SUBROUTINE DATAIN (MODE, NF, NIN, NMAX, NPTS,
     +                   EE, EPSI, ERRY, RTOL, XM, XVAL, XX, YT,
     +                   YVAL, YY,
     +                   FNAME1, FNAME2,
     +                   EQUAL, ISTOP, JUMP, NEW)
C
C Read X, Y, Error, NPTS, Calculate XT, YT, normalise data
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: MODE, NF, NIN, NMAX
      INTEGER,             INTENT (INOUT) :: NPTS
      DOUBLE PRECISION,    INTENT (OUT)   :: EPSI, RTOL
      DOUBLE PRECISION,    INTENT (OUT)   :: EE(NMAX), ERRY(NMAX), XM,
     +                                       XVAL(NMAX), XX(NMAX), YT,
     +                                       YVAL(NMAX), YY(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME1, FNAME2
      LOGICAL,             INTENT (IN)    :: JUMP, NEW
      LOGICAL,             INTENT (OUT)   :: EQUAL(NMAX), ISTOP
C
C Locals
C      
      INTEGER    I, ICOUNT
      
      DOUBLE PRECISION X02AJF$, X02AMF$
      DOUBLE PRECISION ZERO, FIVE, PNT85
      PARAMETER (ZERO = 0.0D+00, FIVE = 5.0D+00, PNT85 = 0.85D+00)
      CHARACTER (LEN = 100) LINE
      CHARACTER (LEN = 80 ) TFILE, TITLE, TRIM80
      EXTERNAL   X02AJF$, X02AMF$
      EXTERNAL   DATFIL, DATCHK, PUTFAT, RESFIL, DATSXY, TRIM80
      SAVE ICOUNT
      DATA ICOUNT / 0 /
C
C Assign EPSI and RTOL
C
      EPSI = X02AJF$()
      RTOL = 1.0D+09*X02AMF$()
C
C Read in and check data
C
      IF (NEW) THEN
         CLOSE (UNIT = NIN)
         CALL DATFIL (NIN, NMAX, NPTS,
     +                EE, XX, YY,
     +                FNAME1, TITLE, 
     +                ISTOP)
         CLOSE (UNIT = NIN)
         IF (ISTOP) RETURN
      ELSE
         CLOSE (UNIT = NIN)
         CALL DATSXY (NIN, NMAX, NPTS, 
     +                EE, XX, YY,
     +                FNAME1, TITLE,
     +                ISTOP)
         CLOSE (UNIT = NIN)
         IF (ISTOP) RETURN
      ENDIF
      CALL DATCHK (NPTS,
     +             EE, XX, YY,
     +             ISTOP)
      IF (ISTOP) RETURN
C
C Further checks on input data and calculate YT
C
      IF (NPTS.LT.3) THEN
         CALL PUTFAT ('Must have at least 3 x-values')
         ISTOP = .TRUE.
         RETURN
      ENDIF
      IF (MODE.EQ.1 .AND. YY(1).GT.YY(NPTS)) THEN
         CALL PUTFAT (
     +'In Normal mode y(i) must be an increasing function of x')
         ISTOP = .TRUE.
         RETURN
      ELSEIF (MODE.EQ.2 .AND. YY(1).LT.YY(NPTS)) THEN
         CALL PUTFAT (
     +'In Isotope mode y(i) must be a decreasing function of x')
         ISTOP = .TRUE.
         RETURN
      ENDIF
      YT = YY(1)
      DO I = 1, NPTS
         IF (XX(I).LT.ZERO .OR. YY(I).LT.ZERO) THEN
            WRITE (LINE,100) I
            CALL PUTFAT (LINE)
            ISTOP = .TRUE.
            RETURN
         ENDIF
         IF (YY(I).GT.YT) YT = YY(I)
      ENDDO
C
C Open output file for results and write out program declaration
C
      IF (ICOUNT.EQ.0) THEN
         CALL RESFIL (NF,
     +                FNAME2, 
     +                ISTOP)
         IF (ISTOP) RETURN
         IF (MODE.EQ.1) THEN
            IF (JUMP) THEN
               WRITE (NF,150)
            ELSE   
               WRITE (NF,200)
            ENDIF   
         ELSE
            WRITE (NF,300)
         ENDIF
      ENDIF
      ICOUNT = ICOUNT + 1
      TFILE = TRIM80(FNAME1)
      WRITE (NF,400) ICOUNT, TFILE, TITLE
C
C Transform EE, XX, YY to ERRY, XVAL, YVAL
C
      XM = XX(NPTS)/FIVE
      YT = YT/PNT85
      DO I = 1, NPTS
         ERRY(I) = EE(I)/YT
         XVAL(I) = XX(I)/XM
         YVAL(I) = YY(I)/YT
      ENDDO
C
C Check for replicates
C
      EQUAL(1) = .FALSE.
      DO I = 2, NPTS
         IF (XVAL(I).GT.XVAL(I - 1)) THEN
            EQUAL(I) = .FALSE.
         ELSE
            EQUAL(I) = .TRUE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT ('x or y < 0 at data point',I6,' ... Must be > 0')
  150 FORMAT (/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : SV_MMFIT'
     +/1X,'ACTION  : Fit sum of 1 to n Michaelis-Menten enzymes'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U. K.')
  200 FORMAT (/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : MMFIT'
     +/1X,'ACTION  : Fit sum of 1 to n Michaelis-Menten enzymes'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U. K.')
  300 FORMAT (/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : MMFIT'
     +/1X,'ACTION  : Fit sum of 1 to n Michaelis-Menten tranporters'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U. K.')
  400 FORMAT (/1X,'Analysis number',I4/1X,'==================='
     +/1X,'File name'/1X,A/1X,'Data title'/1X,A)
      END
C
C-------------------------------------------------------------------------
C
      SUBROUTINE DATFIT (ISTATE, ITIME, IW, KLOG, LIW, LW1, LW2, MODE,
     +                   NBD, NDOF, NF, NPAR, NPTS, NN, NX,
     +                   BL, BU, DOFDOM, EPSI, FACT, G, OBJFUN, WSSQ,
     +                   W1, W2, X, XM, YT,
     +                   ISTOP, NOUT)
C
C Curve fitting by the LBFGS quasi-Newton routine using QNFIT1
C FMIN prevents division by zero in re-scaling covariance matrix
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: KLOG, LIW, LW1, LW2, MODE, NN,
     +                                    NX
      INTEGER,          INTENT (IN)    :: ITIME, NDOF, NF, NPAR(NN),
     +                                    NPTS
      INTEGER,          INTENT (OUT)   :: ISTATE(NX), IW(LIW), NBD(NX) 
      DOUBLE PRECISION, INTENT (IN)    :: DOFDOM, EPSI, XM, YT
      DOUBLE PRECISION, INTENT (OUT)   :: BL(NX), BU(NX), G(NX), OBJFUN,
     +                                    W1(LW1), W2(LW2), X(NX)
      DOUBLE PRECISION, INTENT (INOUT) :: FACT(NX), WSSQ(NN)
      LOGICAL,          INTENT (IN)    :: ISTOP, NOUT(KLOG)
C
C Locals
C     
      INTEGER    I, IFAIL, N
      INTEGER    COLOUR
      DOUBLE PRECISION TEMP
      DOUBLE PRECISION ONE, FMIN
      PARAMETER (ONE = 1.0D+00, FMIN = 1.0D-10)
      DOUBLE PRECISION BLMIN, BUMAX
      PARAMETER (BLMIN = 1.0D-10, BUMAX = 1.0D+10)
      CHARACTER  LINE*80
      CHARACTER  K5*5, V5*5
      CHARACTER (LEN = 9) FORM09, WORD9 
      EXTERNAL   DERIV1, DERIV2, FUNCT1, QNFIT1, ZMOD
      EXTERNAL   CHECKW, PUTIFA, TABLE1, FORM09
      INTRINSIC  ABS
      IF (ISTOP) RETURN
C
C Set up ISTATE, N, BL, BU and X for input to E04JAF
C
      IF (MODE.EQ.1) THEN
         K5 = '  Km('
         V5 = 'Vmax('
      ELSE
         K5 = '   K('
         V5 = '   V('
      ENDIF
      N = NPAR(ITIME)
      WRITE (NF,100)
      DO I = 1, N
         NBD(I) = 1
         BL(I) = BLMIN
         BU(I) = BUMAX
         X(I) = ONE
         ISTATE(I) = 1
         IF (FACT(I).LT.FMIN) FACT(I) = FMIN
         IF (I.LE.ITIME) THEN
            TEMP = FACT(I)*YT
            WORD9 = FORM09(TEMP)
            WRITE (NF,200) V5, I, WORD9
         ELSE
            TEMP = FACT(I)*XM
            WORD9 = FORM09(TEMP)
            WRITE (NF,200) K5, I - ITIME, WORD9
          ENDIF
      ENDDO
C
C Display starting estimates
C
      IF (NOUT(2)) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         WRITE (LINE,100)
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
         COLOUR = 0
         DO I = 1, N
            IF (I.LE.ITIME) THEN
               TEMP = FACT(I)*YT
               WORD9 = FORM09(TEMP)
               WRITE (LINE,200) V5, I, WORD9
            ELSE
               TEMP = FACT(I)*XM
               WORD9 = FORM09(TEMP)
               WRITE (LINE,200) K5, I - ITIME, WORD9
            ENDIF
            CALL TABLE1 (COLOUR, LINE)
         ENDDO
         CALL TABLE1 (COLOUR, 'CLOSE')
      ENDIF
C
C Check parameters before entry to QNFIT1
C
      CALL CHECKW (NDOF,
     +             WSSQ(ITIME))
      WORD9 = FORM09(WSSQ(ITIME))
      WRITE (NF,300) WORD9
C
C Code to decide how to use QNFIT1 ... either approx/med or analytic/high
C
      IF (NOUT(8)) THEN
         CALL QNFIT1 (DERIV2, FUNCT1, IFAIL, IW, LIW, LW1, LW2, N,
     +                NBD, NF, NPTS,
     +                BL, BU, OBJFUN, G, W1, W2, X,
     +                'analytic', 'high')
      ELSE
         CALL QNFIT1 (DERIV1, FUNCT1, IFAIL, IW, LIW, LW1, LW2, N,
     +                NBD, NF, NPTS,
     +                BL, BU, OBJFUN, G, W1, W2, X,
     +                'approximate', 'medium')
      ENDIF
      WSSQ(ITIME) = DOFDOM*OBJFUN
      WORD9 = FORM09(WSSQ(ITIME))
      WRITE (NF,400) WORD9
      IF (IFAIL.NE.0 .AND. IFAIL.NE.1 .AND. IFAIL.NE.2)
     +    CALL PUTIFA (IFAIL, NF, 'QNFIT1/DATFIT')
C
C Check parameters and assign ISTATE
C
      CALL ZMOD(X)
      DO I = 1, N
         IF (ABS(X(I) - BL(I)).LE.EPSI) ISTATE(I) = - 2
         IF (ABS(X(I) - BU(I)).LE.EPSI) ISTATE(I) = - 1
      ENDDO
C
C Format statements
C      
  100 FORMAT (1X,'Parameter starting estimates')
  200 FORMAT (1X,A5,I1,') =',1X,A)
  300 FORMAT (1X,'Before curve-fitting WSSQ =',1X,A)
  400 FORMAT (1X,'After  curve-fitting WSSQ =',1X,A)
      END
C
C-------------------------------------------------------------------------
C
      SUBROUTINE DATOUT (ISTATE, ITIME, IW, KLOG, LIW, LW, MODE, NDOF,
     +                   NF, NGRAF, NHESS, NMAX, NN, NPAR, NPTS, NSTART,
     +                   NX,
     +                   CORR, CV, DIAGV, EE, ERR, ERRY, FACT, FJACC,
     +                   G, HESSEX, OBJFUN, PAR, RESID, RTOL, THEORY,
     +                   TL, TPER, TU, W, WRESID, WSSQ, X, XGRAF, XM,
     +                   XSAV, XVAL, XX, YSAV, YT, YVAL, YY, ZSAV, ZZ,
     +                   EQSAV, EQUAL, FREE, ISTOP, NOUT)
C
C Output written to screen and/or a file
C Parameter NGRAF sets number of best-fit points
C and YSAV saves previous best-fit points
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: KLOG, LIW, LW, MODE, NGRAF,
     +                                    NHESS, NMAX, NN, NX
      INTEGER,          INTENT (IN)    :: ITIME, NDOF, NF, NSTART
      INTEGER,          INTENT (IN)    :: NPAR(NN)
      INTEGER,          INTENT (INOUT) :: ISTATE(NX), IW(LIW), NPTS
      DOUBLE PRECISION, INTENT (IN)    :: FACT(NX), OBJFUN, 
     +                                    RTOL, XM, YT
      DOUBLE PRECISION, INTENT (IN)    :: EE(NMAX), XX(NMAX), YY(NMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: CORR(NX,NX), CV(NHESS,NHESS),
     +                                    DIAGV(NX), ERR(NX),
     +                                    FJACC(NMAX,NX), G(NX),
     +                                    HESSEX(NHESS,NHESS),
     +                                    PAR(NX), RESID(NMAX), TL(NX),
     +                                    TPER(NX), TU(NX),
     +                                    WRESID(NMAX), XGRAF(NGRAF) 
      DOUBLE PRECISION, INTENT (INOUT) :: ERRY(NMAX), THEORY(NMAX), 
     +                                    W(LW), WSSQ(NN), X(NX),
     +                                    XSAV(NMAX), XVAL(NMAX),  
     +                                    YSAV(NMAX), YVAL(NMAX),
     +                                    ZSAV(NMAX), ZZ(NMAX)
      LOGICAL,          INTENT (IN)    :: ISTOP, NOUT(KLOG)
      LOGICAL,          INTENT (INOUT) :: EQSAV(NMAX), EQUAL(NMAX)
      LOGICAL,          INTENT (OUT)   :: FREE(NX)
C
C Locals
C     
      INTEGER    L0, L1, L2, L3, L5
      PARAMETER (L0 = 0, L1 = 1, L2 = 2, L3 = 3, L5 = 5)
      INTEGER    I, IFAIL, J, MA, NA, NFREE, NSAV
      INTEGER    JCOLOR(50), NTEXT
      INTEGER    INDEXX(50), ISEND
      PARAMETER (ISEND = 1)
      DOUBLE PRECISION ZERO, ONE, TWO, TEN, PNT05, PNT975
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           TEN = 10.0D+00, PNT05 = 0.05D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION G01EBF$, G01FBF$
      DOUBLE PRECISION ALPHA, TSTAT
      DOUBLE PRECISION FKM, VMAX, XA, XFIRST, XLAST, YA
      DOUBLE PRECISION XTEMP1(L2), XTEMP2(L2), YTEMP1(L2), YTEMP2(L2)
      CHARACTER (LEN = 13) SHOWRJ, WORD13(4)
      CHARACTER (LEN = 9 ) FORM09, WORD9(2)
      CHARACTER  PTITLE*37, XTITLE*1, YTITLE*1
      CHARACTER  SYMBOL(20)*2, LINENN(50)*100, TYPE1(20)*20
      CHARACTER  LINE1*100, LINE2(2)*100, TEXT(50)*100
      CHARACTER  K3*3, V5*5
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .TRUE.)
      EXTERNAL   E_FORMATS
      EXTERNAL   FUNCT1
      EXTERNAL   G01EBF$, G01FBF$
      EXTERNAL   QNCOV1, PUTIFA, VMAXKM, GKSR01, ZMOD, FTESTS, DIVIDE,
     +           GKST04, TABLE6, GDCON0, PCVTST, ARRPAR
      EXTERNAL   FORM09, SHOWRJ
      INTRINSIC  ABS, SQRT, DBLE
      IF (ISTOP) RETURN
      E_NUMBERS = E_FORMATS()  
      WRITE (NF,100) ITIME, ITIME
C
C ==========================================================================
C Part 1: Calculate covariance matrix and parameter standard errors
C         At this stage ISTATE and all parameters are in the natural order
C         but parameters must be re-scaled to the original data scales
C ==========================================================================
C
      CALL QNCOV1 (FUNCT1,
     +             IW, ISTATE, NF, NFREE, NHESS, NMAX, NPAR(ITIME),
     +             NPTS, NX,
     +             CORR, CV, DIAGV, ERRY, FACT, FJACC, G, HESSEX,
     +             OBJFUN, W, X, XVAL, YVAL, THEORY,
     +             EQUAL, FREE)
      IFAIL = 1
      TSTAT = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
      CALL PUTIFA (IFAIL, NF, 'G01FBF/DATOUT')
      DO I = 1, ITIME
         IF (MODE.EQ.1) THEN
            PAR(I) = FACT(I)*X(I)*YT
            ERR(I) = SQRT(ABS(DIAGV(I)))*YT
         ELSE
            PAR(I) = FACT(I)*X(I)*XM*YT
            ERR(I) = SQRT(ABS(DIAGV(I)))*XM*YT
         ENDIF
         TL(I) = PAR(I) - TSTAT*ERR(I)
         TU(I) = PAR(I) + TSTAT*ERR(I)
         J = ITIME + I
         PAR(J) = FACT(J)*X(J)*XM
         ERR(J) = SQRT(ABS(DIAGV(J)))*XM
         TL(J) = PAR(J) - TSTAT*ERR(J)
         TU(J) = PAR(J) + TSTAT*ERR(J)
      ENDDO
C
C =========================================================================
C Part 2: Reconstitute the covariance matrix 
C         At this stage parameters are still in the natural order but they
C         have been re-scaled and so it is time to re-scalle the covariance
C         matrix
C =========================================================================
C
      DO I = 1, NPAR(ITIME)
C
C First the diagonals
C
         IF (I.LE.ITIME) THEN
            IF (MODE.EQ.1) THEN
               CV(I,I) = CV(I,I)*YT*YT
            ELSE
               CV(I,I) = CV(I,I)*XM*XM*YT*YT
            ENDIF
         ELSE
            CV(I,I) = CV(I,I)*XM*XM
         ENDIF
C
C Now the strict lower triangle
C
         IF (I.GT.1) THEN
            DO J = 1, I - 1
               IF (I.LE.ITIME) THEN
                  IF (MODE.EQ.1) THEN
                     CV(I,J) = CV(I,J)*YT
                  ELSE
                     CV(I,J) = CV(I,J)*XM*YT
                  ENDIF
               ELSE
                  CV(I,J) = CV(I,J)*XM
               ENDIF
               IF (J.LE.ITIME) THEN
                  IF (MODE.EQ.1) THEN
                     CV(I,J) = CV(I,J)*YT
                  ELSE
                     CV(I,J) = CV(I,J)*XM*YT
                  ENDIF
               ELSE
                  CV(I,J) = CV(I,J)*XM
               ENDIF
C
C Finally fill in the upper triangle
C
               CV(J,I) = CV(I,J)
            ENDDO
         ENDIF
      ENDDO
C
C =========================================================================
C Part 3: Start of code to rearrange parameters
C =========================================================================      
C
C Now we put the parameters into increasing order with respect to the V(i)
C amplitude parameters to faciltate testing for differences between estimates
C
      IF (ITIME.GT.1) THEN
         CALL ARRPAR (ISEND, INDEXX, ITIME, NHESS, NPAR(ITIME),
     +                CV, PAR, W)
         DO I = 1, NPAR(ITIME)
            W(I) = ERR(INDEXX(I))
         ENDDO
         DO I = 1, NPAR(ITIME)
            ERR(I) = W(I)
         ENDDO
         DO I = 1, NPAR(ITIME)
            W(I) = TL(INDEXX(I))
         ENDDO
         DO I = 1, NPAR(ITIME)
            TL(I) = W(I)
         ENDDO
         DO I = 1, NPAR(ITIME)
            W(I) = TU(INDEXX(I))
         ENDDO
         DO I = 1, NPAR(ITIME)
            TU(I) = W(I)
         ENDDO
C
C Re-define CORR in case the order has been changed but correct for parameters at
C lower limits (ISTATE(I) = -2) or upper limits (ISTATE(I) = -1) for which the
C approriate CV(I,J) values have been set to zero by the call to QNCOV1
C          
         DO I = 2, NPAR(ITIME)
            DO J = 1, I - 1
               IF (CV(I,I).GT.RTOL .AND. CV(J,J).GT.RTOL) THEN
                  CORR(I,J) = CV(I,J)/SQRT(CV(I,I)*CV(J,J))
               ELSE
                  CORR(I,J) = ZERO
               ENDIF  
               IF (CORR(I,J).LT.-ONE) THEN
                  CORR(I,J) = -ONE
               ELSEIF (CORR(I,J).GT.ONE) THEN
                  CORR(I,J) = ONE
               ENDIF           
               CORR(J,I) = CORR(I,J)
            ENDDO  
         ENDDO  
         DO I = 1, NPAR(ITIME)
            CORR(I,I) = ONE
         ENDDO   
C
C It is also necessary to re-order the ISTATE vector
C         
         DO I = 1, NPAR(ITIME)
            IW(I) = ISTATE(INDEXX(I))
         ENDDO  
         DO I = 1, NPAR(ITIME)
            ISTATE(I) = IW(I)
         ENDDO  
      ENDIF
C
C =========================================================================
C Part 4: End of code to rearrange parameters
C         Now output all results re-scaled and in the sorted order
C =========================================================================
C
      DO I = 1, 50
         JCOLOR(I) = 0
         TEXT(I) = BLANK
      ENDDO   
 
      DO I = 1, NPAR(ITIME)
         TPER(I) = ONE
         IF (ISTATE(I).GT.0) THEN
            TYPE1(I) = BLANK
            TPER(I) = ZERO
            IF (ERR(I).GT.RTOL) THEN
               IFAIL = 1
               ALPHA = ONE - G01EBF$('Lower-tail', ABS(PAR(I)/ERR(I)),
     +                                DBLE(NDOF), IFAIL)
               CALL PUTIFA (IFAIL, NF, 'G01EBF/DATOUT')
               TPER(I) = TWO*ALPHA
            ENDIF
         ELSEIF (ISTATE(I).EQ.0) THEN
            TYPE1(I) = '[Fixed]'
         ELSEIF (ISTATE(I).EQ.-1) THEN
            TYPE1(I) = '[Upper Limit]'
         ELSEIF (ISTATE(I).EQ.-2) THEN
            TYPE1(I) = '[Lower Limit]'
         ELSE
            TYPE1(I) = BLANK   
         ENDIF
         IF (TPER(I).GT.PNT05) THEN
            SYMBOL(I) = ' *'
         ELSE
            SYMBOL(I) = '  '
         ENDIF
      ENDDO
C
C Display best-fit parameters then calculate apparent VMAX and KM
C
      IF (MODE.EQ.1) THEN
         K3 = 'Km('
         V5 = 'Vmax('
      ELSE
         K3 = ' K('
         V5 = '   V('
      ENDIF
C
C Write to the results file
C      
      WRITE (NF,200)
      
     
      WRITE (LINE2,100) ITIME, ITIME
      NTEXT = 0
      DO I = 1, 2
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = LINE2(I)
      ENDDO   
      WRITE (LINE2,200)
      DO I = 1, 2
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = LINE2(I)
      ENDDO   
      JCOLOR(NTEXT) = 4
C
C Display tables
C      
      IF (E_NUMBERS) THEN
         WRITE (LINENN,300) (I, V5, I, PAR(I), ERR(I), TL(I), TU(I),
     +                       TPER(I), SYMBOL(I), TYPE1(I), I = 1, ITIME)  
         WRITE (NF,300) (I, V5, I, PAR(I), ERR(I), TL(I), TU(I),
     +                   TPER(I), SYMBOL(I), TYPE1(I), I = 1, ITIME)
      ELSE
         DO I = 1, ITIME
            WORD13(1) = SHOWRJ(PAR(I))
            WORD13(2) = SHOWRJ(ERR(I))
            WORD13(3) = SHOWRJ(TL(I))
            WORD13(4) = SHOWRJ(TU(I))
            WRITE (LINENN(I),350) I, V5, I, WORD13(1), WORD13(2), 
     +                            WORD13(3), WORD13(4),
     +                            TPER(I), SYMBOL(I), TYPE1(I) 
            WRITE (NF,350) I, V5, I, WORD13(1), WORD13(2), 
     +                     WORD13(3), WORD13(4),
     +                     TPER(I), SYMBOL(I), TYPE1(I)   
         ENDDO
      ENDIF                     
      DO I = 1, ITIME
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = LINENN(I)
      ENDDO
      IF (E_NUMBERS) THEN
         WRITE (LINENN,400) (ITIME + I, K3, I, PAR(ITIME + I),
     +                       ERR(ITIME + I),
     +                       TL(ITIME + I), TU(ITIME + I), 
     +                       TPER(ITIME + I),
     +                       SYMBOL(ITIME + I),
     +                       TYPE1(ITIME + I), I = 1, ITIME)
         WRITE (NF,400) (ITIME + I, K3, I, PAR(ITIME + I), 
     +                   ERR(ITIME + I), TL(ITIME + I), TU(ITIME + I),
     +                   TPER(ITIME + I), SYMBOL(ITIME + I),
     +                   TYPE1(ITIME + I), I = 1, ITIME)
      ELSE
         DO I = 1, ITIME
            WORD13(1) = SHOWRJ(PAR(ITIME + I))
            WORD13(2) = SHOWRJ(ERR(ITIME + I))
            WORD13(3) = SHOWRJ(TL(ITIME + I))
            WORD13(4) = SHOWRJ(TU(ITIME + I))
            WRITE (LINENN(I),450) ITIME + I, K3, I, WORD13(1),
     +                            WORD13(2), WORD13(3), WORD13(4),
     +                            TPER(ITIME + I),
     +                            SYMBOL(ITIME + I),
     +                            TYPE1(ITIME + I) 
            WRITE (NF,450) ITIME + I, K3, I, WORD13(1),
     +                     WORD13(2), WORD13(3), WORD13(4),
     +                     TPER(ITIME + I),
     +                     SYMBOL(ITIME + I),
     +                     TYPE1(ITIME + I) 
         ENDDO
      ENDIF     
      DO I = 1, ITIME
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = LINENN(I)
      ENDDO
      IF (ITIME.EQ.1) THEN
         VMAX = PAR(1)
         FKM = PAR(2)
      ELSE
         MA = ITIME
         NA = NPAR(ITIME)
         XA = XX(1)/TEN
         YA = TEN*XX(NPTS)
         CALL VMAXKM (MA, MODE, NA,
     +                FKM, PAR, VMAX, XA, YA)
         IF (E_NUMBERS) THEN
            WRITE (LINENN,500) VMAX, FKM
            WRITE (NF,500) VMAX, FKM
         ELSE
            WORD9(1) = FORM09(VMAX)
            WORD9(2) = FORM09(FKM)
            WRITE (LINENN(1),'(A)') BLANK
            WRITE (LINENN(2),525) WORD9(1)
            WRITE (LINENN(3),550) WORD9(2)
            WRITE (NF,'(A)') BLANK
            WRITE (NF,525) WORD9(1)
            WRITE (NF,550) WORD9(2)  
         ENDIF  
         DO I = 1, 3
            NTEXT = NTEXT + 1
            TEXT(NTEXT) = LINENN(I)
         ENDDO
         
      ENDIF
C
C Output correlation matrix
C
      IF (NFREE.GT.1) THEN
         IF (NOUT(1)) THEN
            WRITE (LINE2,600)
            DO I = 1, 2
               NTEXT = NTEXT + 1
               TEXT(NTEXT) = LINE2(I)
            ENDDO  
            JCOLOR(NTEXT) = 4 
         ENDIF
         WRITE (NF,600)
         DO I = 1, NPAR(ITIME)
             IF (NOUT(1)) THEN
                 WRITE (LINE1,700) (CORR(I,J), J = 1, I)
                 NTEXT = NTEXT + 1
                 TEXT(NTEXT) = LINE1
             ENDIF
             WRITE (NF,700) (CORR(I,J), J = 1, I)
         ENDDO
      ENDIF
      CALL TABLE6 (JCOLOR, NTEXT,
     +             TEXT)      
C
C ============================================================================
C Part 5: First call ZMOD to make sure THEORY is defined properly then set
C         ZZ = Best-fit curve in external coordinates and call GKSR01, FTESTS
C =============================================================================
C
      CALL ZMOD (X)
      DO I = 1, NPTS
         ZZ(I) = THEORY(I)*YT
      ENDDO
      CALL GKSR01 (NF, NPAR(ITIME), NPTS, 
     +             RESID, EE, ZZ, WRESID, XX, YY, 
     +             NOUT(7), SAVEIT, NOUT(5), NOUT(6), NOUT(1))
      IF (ITIME.GT.NSTART) THEN
         CALL FTESTS (NPAR(ITIME - 1), NPAR(ITIME), NF, NPTS,
     +                WSSQ(ITIME - 1), WSSQ(ITIME), 
     +                SAVEIT, NOUT(1))
      ENDIF
C
C Save data and construct best-fit curve then call to graphics if required
C
      IF (NOUT(4)) THEN
         DO I = 1, NPTS
            EQSAV(I) = EQUAL(I)
            XSAV(I) = XVAL(I)
            ZSAV(I) = THEORY(I)
         ENDDO
         EQUAL(1) = .FALSE.
         XFIRST = XVAL(1)
         XLAST = XVAL(NPTS)
         CALL DIVIDE (NGRAF,
     +                XGRAF, XFIRST, XLAST)
         DO I = 1, NGRAF
            EQUAL(I) = .FALSE.
            XVAL(I) = XGRAF(I)
         ENDDO
         NSAV = NPTS
         NPTS = NGRAF
         CALL ZMOD (X)
         NPTS = NSAV
         DO I = 1, NGRAF
            XVAL(I) = XVAL(I)*XM
            XGRAF(I) = XVAL(I)
            THEORY(I) = THEORY(I)*YT
         ENDDO
         DO I = 1, L2
            XTEMP1(I) = ONE
            XTEMP2(I) = ONE
            YTEMP1(I) = ONE
            YTEMP2(I) = ONE
         ENDDO
         XTITLE = 'x'
         YTITLE = 'y'
         IF (ITIME.EQ.NSTART) THEN
            PTITLE = 'Experimental Data and Best-Fit Curve'
            CALL GKST04 (L0, L1, L0, L0,
     +                   L5, L0, L0, L0,
     +                   NPTS, NGRAF, L2, L2,
     +                   VMAX,
     +                   XX, XVAL, XTEMP1, XTEMP2,
     +                   YY, THEORY, YTEMP1, YTEMP2,
     +                   PTITLE, XTITLE, YTITLE, 
     +                   SAVEIT, SAVEIT)
         ELSE
            PTITLE = 'Data, Best-Fit Curve and Previous Fit'
            CALL GKST04 (L0, L1, L3, L0, 
     +                   L5, L0, L0, L0,
     +                   NPTS, NGRAF, NGRAF, L2,
     +                   VMAX,
     +                   XX, XVAL, XGRAF, XTEMP1, 
     +                   YY, THEORY, YSAV, YTEMP1,
     +                   PTITLE, XTITLE, YTITLE,
     +                   SAVEIT, SAVEIT)
         ENDIF
C----------------------------------------------------------------------
C Start of graphical deconvolution (note new EXTERNAL subroutine GDCON0)
C 
         IF (NOUT(10)) THEN
            J = 2
            CALL GDCON0 (MODE, ITIME, J, NPAR(ITIME), NPTS, NGRAF,
     +                   PAR, XX, XVAL, YY, THEORY)
         ENDIF
C
C End of graphical deconvolution
C----------------------------------------------------------------------
C
C Save best-fit curve and restore data
C
         DO I = 1, NGRAF
            YSAV(I) = THEORY(I)
         ENDDO
         DO I = 1, NPTS
            EQUAL(I) = EQSAV(I)
            XVAL(I) = XSAV(I)
            THEORY(I) = ZSAV(I)
         ENDDO
      ENDIF
C
C Call PCVTST
C
      IF (NOUT(9)) THEN
         I = 1
         CALL PCVTST (I, NF, NPAR(ITIME), NPTS, NHESS,
     +                CV, PAR)
      ENDIF      
C
C Format statements
C      
  100 FORMAT (
     +/1X,'For best-fit',I2,':',I1,1X,'Michaelis-Menten function')
  200 FORMAT (/1X,
     +'No.  Parameter      Value        Std.Error     Lower95%cl   ',
     +'  Upper95%cl',4X,'p')
     
  300 FORMAT (1X,I2,3X,A5,I1,')',2X,1P,E13.5,2X,E13.5,2X,E13.5,
     +2X,E13.5,0P,F8.4,A2,1X,A)
  350 FORMAT (1X,I2,3X,A5,I1,')',2X,A13,2X,A13,2X,A13,
     +2X,A13,F8.4,A2,1X,A)
     
  400 FORMAT (1X,I2,5X,A3,I1,')',2X,1P,E13.5,2X,E13.5,2X,E13.5,
     +2X,E13.5,0P,F8.4,A2,1X,A)
  450 FORMAT (1X,I2,5X,A3,I1,')',2X,A13,2X,A13,2X,A13,
     +2X,A13,F8.4,A2,1X,A)   
     
  500 FORMAT (
     +/1X,'Predicted maximum rate ( apparent Vmax ) = ',1P,E13.5
     +/1X,'Predicted half satn. point (apparent Km) = ',   E13.5)
  525 FORMAT (
     +1X,'Predicted maximum rate ( apparent Vmax ) = ',A)
  550 FORMAT (   
     +1X,'Predicted half satn. point (apparent Km) = ',A)   
     
  600 FORMAT (/1X,'Parameter correlation matrix')
  700 FORMAT (12F7.4)
      END
C
C
