C
C MMFIT2.FOR: Include file for MMFIT.FOR
C ==========
C
C DERIV1
C DERIV2
C DETAIL
C FUNCT1
C RANDOM
C TESTQS
C VMAXKM
C ZMOD
C
C
      subroutine deriv1 (funct, n, g, w, x)
c
c action : finite difference approximation to derivatives using qngrd1
c          x is intent (inout) because it is perturbed/retored by qngrd1
c
      implicit   none
c
c arguments
c      
      integer,          intent (in)    :: n
      double precision, intent (inout) :: x(n)
      double precision, intent (out)   :: g(n), w(3*n)
c
c locals
c      
      integer    inform
      logical    tpoint
      parameter (tpoint = .false.)
      external   funct, qngrd1
      call qngrd1 (funct, inform, n, g, w, x, tpoint)
      end
C
C-----------------------------------------------------------------------
C F95 and FTN95 complain about FUNCT and W not being used
C The next line is a FTN95 comment embedded compiler directive
CFTN95$OPTIONS (SILENT)
C
      SUBROUTINE DERIV2 (FUNCT, N, G, W, P)
C
C ACTION : Exact derivatives for the Multi-Michaelis-Menten function
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 12/9/97
C          01/10/98 Used SILENT to stop FTN95 complaining about FUNCT
C          and W in the argument list
C
C          Note that: 1) the order of the model is equal to ITIME
C                     2) each parameter is multiplied by a scaling factor
C                     3) the objective function is WSSQ/NDOF not WSSQ
C                     4) the model is not protected against overflow since
C                        parameters can never be zero
C
      USE MODULE_MMFIT, ONLY : ITIME, MODE, NPTS, DOFDOM, ERRY, FACT, 
     +                         THEORY, XVAL, YVAL 

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      DOUBLE PRECISION, INTENT (IN)  :: P(N)
      DOUBLE PRECISION, INTENT (OUT) :: G(N), W(3*N)
C
C Locals
C      
      INTEGER    NN, NX
      PARAMETER (NN = 6, NX = 2*NN)
      INTEGER    I, J, K
      DOUBLE PRECISION A(NN), B(NN)
      DOUBLE PRECISION DENOM, DENOM2, PDERIV, T, TERM
      DOUBLE PRECISION ZERO, TWO
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00)
      EXTERNAL FUNCT
      W(1) = ZERO!to stop ftn95 complaining
C
C Initialise the parameters and gradient
C
      DO I = 1, ITIME
         J = ITIME + I
         A(I) = FACT(I)*P(I)
         B(I) = FACT(J)*P(J)
         G(I) = ZERO
         G(J) = ZERO
      ENDDO
C
C The main loop over each design point
C
      DO I = 1, NPTS
C
C Calculate TERM and T
C
         T = XVAL(I)
         TERM = (YVAL(I) - THEORY(I))/(ERRY(I)*ERRY(I))
         IF (MODE.EQ.1) TERM = T*TERM
C
C Calculate partial derivatives ... note the use of FACT
C
         DO J = 1, ITIME
            K = ITIME + J
            DENOM = B(J) + T
            DENOM2 = DENOM*DENOM
            PDERIV = FACT(J)*TERM/DENOM
            G(J) = G(J) + PDERIV
            PDERIV = - A(J)*FACT(K)*TERM/DENOM2
            G(K) = G(K) + PDERIV
         ENDDO
      ENDDO
C
C Finally correct for the pre-multiplier factor
C
      T = - TWO/DOFDOM
      DO I = 1, N
         G(I) = T*G(I)
      ENDDO
      END
C
C--------------------------------------------------------------------------
C
      SUBROUTINE DETAIL (KLOG, MAXNUM, NBIG, NN, NRAND, NSMALL, NSTART,
     +                   NSTOP,
     +                   SIGMA,
     +                   ISTOP, NOUT)
C
C Read orders, scaling, output, set types
C 14/08/2017 new version with nlog = 10 and calling w_get00x
C 05/02/2020 increased numopt from 23 to 24 and introduced new logical variable switch_off  
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: KLOG, NN
      INTEGER,          INTENT (INOUT) :: MAXNUM, NBIG, NRAND, NSMALL,
     +                                    NSTART, NSTOP
      DOUBLE PRECISION, INTENT (INOUT) :: SIGMA
      LOGICAL,          INTENT (INOUT) :: ISTOP, NOUT(KLOG)  
C
C locals
C        
     
      integer    numopt, numsta, numtxt, n1
      parameter (numopt = 24, numsta = 1, numtxt = numopt, n1 = 1)
      integer    i, icolor, ixl, iyl, j, kvalue(numopt), lshade,
     +           numbld(numopt), numpos(numopt), kvlim_1(numopt),
     +           kvlim_2(numopt)
      parameter (icolor = 7, ixl = 0, iyl = 0, lshade = 0)
      double precision xvalue(numopt) 
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 100) svalue(numopt), text_in(numopt)
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    repeet
      logical    abort, first
      logical    fixed, full, high
      parameter (fixed = .false., full = .true., high = .true.)
      logical    switch_off
      external   advise, get00x, putfat  
      intrinsic  max, min
      save       switch_off
      data       switch_off / .false. /
c
c check
c      
      if (switch_off) return
      if (klog.ne.10) then
         call putfat ('KLOG must be 10 in call to DETAIL')
         return
      endif
      if (nstart.lt.1 .or. nstart.gt.nstop .or. nstop.gt.nn) then 
         call putfat (
     +'Must have 1 =< NSTART =< NSTOP =< NN in call to DETAIL')
         return
      endif 
      if (nrand.lt.1 .or. nrand.gt.4) then
         call putfat ('Must have 1 =< NRAND =< 4 in call to DETAIL')
         return
      endif      
c
c initialise all local variables
c 
      do i = 1, numopt
         numbld(i) = 0
         numpos(i) = 0
         kvalue(i) = 0
         kvlim_1(i) = 0
         kvlim_2(i) = 0
         xvalue(i) = zero
         svalue(i) = blank
      enddo
      if (switch_off) kvalue(numopt - 1) = 1
c
c set parameters for nstart and nstop and default nrand
c      
      kvlim_1(2) = 1
      kvlim_2(2) = nn
      kvlim_1(3) = 1
      kvlim_2(3) = nn
      kvalue(2) = nstart
      kvalue(3) = nstop
      do i = 1, 4
         if (nrand.eq.i) kvalue(i + 5) = 1
      enddo
c
c create the text array
c      
      write (text_in,100) n1, nn
      numpos(1) = 8 
         numbld(1) = 1!blue text
      numpos(2) = 9
      numpos(3) = 9
      numpos(4) = 8
      numpos(5) = 8
         numbld(5) = 1!blue text
      numpos(6) = 6
      numpos(7) = 6 
      numpos(8) = 6
      numpos(9) = 6
      numpos(10) = 8
      numpos(11) = 8
         numbld(11) = 1!blue text
      numpos(12) = 4
      numpos(13) = 4
      numpos(14) = 4 
      numpos(15) = 4
      numpos(16) = 4
      numpos(17) = 4
      numpos(18) = 4
      numpos(19) = 4
      numpos(20) = 4
      numpos(21) = 4
      numpos(22) = 4
      numpos(23) = 4
      numpos(24) = 4
C
C set logical parameters
C nout(1)  ... display analysis table
C nout(2)  ... display starting estimates
C nout(3)  ... display random search
C nout(4)  ... plot    best fit curves
C nout(5)  ... plot    residuals
C nout(6)  ... display residuals table
C nout(7)  ... file    residuals table
C nout(8)  ... high precision convergence test
C nout(9)  ... parameters and covariance matrix
C nout(10) ... graphical deconvolution
C
      j = 11
      do i = 1, klog
         j = j + 1
         if (nout(i)) kvalue(j) = 1
      enddo  
c
c loop over the options
c      
      repeet = .true.
      do while (repeet)
         if (switch_off) then
            kvalue(numopt - 1) = 1
         else
            kvalue(numopt - 1) = 0
         endif      
         kvalue(numopt) = 0
         call get00x (icolor, ixl, iyl, kvalue, kvlim_1, kvlim_2, 
     +                lshade, numbld, numopt, numpos, numsta, numtxt,
     +                xvalue,
     +                svalue, text_in,
     +                fixed, full, high)
c
c define nstart, nstop
c     
         nstart = min(kvalue(2),kvalue(3))
         nstop = max(kvalue(2),kvalue(3))
c
c define nrand
c         
         j = 0
         do i = 6, 9
            j = j + 1
            if (kvalue(i).eq.1) then
               nrand = j
            endif
         enddo  
         IF (NRAND.EQ.1) THEN
            MAXNUM = 400
            NBIG = 10
            NSMALL = 1
            SIGMA = 0.5D+00
         ELSEIF (NRAND.EQ.2) THEN
            MAXNUM = 1000
            NBIG = 25
            NSMALL = 2
            SIGMA = 0.3D+00
         ELSEIF (NRAND.EQ.3) THEN
            MAXNUM = 2500
            NBIG = 50
            NSMALL = 4
            SIGMA = 0.125D+00  
         ENDIF 
c
c assign logical variables
c
         j = 11
         do i = 1, klog
            j = j + 1
            if (kvalue(j).eq.1) then
               nout(i) = .true.
            else
               nout(i) = .false.
            endif   
         enddo  
         if (kvalue(numopt - 1).eq.1) switch_off = .true.
c
c check if Advise or Quit have been chosen
c          
         if (kvalue(numopt - 2).eq.1) then
             first = .false.
             call advise (i, 
     +                    blank,
     +                    abort, first) 
             repeet = .true.
         elseif (kvalue(numopt).eq.1) then
            istop = .true.
            return    
         else
            repeet = .false.    
         endif  
      enddo   
c
c format statement
c   
  100 FORMAT (
     + 'Choose the sequence of Michaelis-Menten functions required' !1
     +/'Lowest order (>=',i2,')'                                    !2
     +/'Highest order (=<',i2,')'                                   !3
     +/                                                             !4
     +/'Choose the method to use for parameter starting estimates'  !5 
     +/'Short Random search'                                        !6
     +/'Medium Random search'                                       !7
     +/'Extensive Random search'                                    !8 
     +/'You input starting estimates'                               !9
     +/                                                             !10
     +/'Choose the procedures required for this analysis'           !11 
     +/'Display the goodness of fit analysis'                       !12
     +/'Display values of starting estimates'                       !13
     +/'Display details of any random search'                       !14
     +/'Plot the best fit curves and data'                          !15 
     +/'Provide options to plot residuals'                          !16
     +/'Display tables of (wtd.) residuals'                         !17
     +/'Write residuals to results log file'                        !18
     +/'Use analytic-gradient/high-precision'                       !19
     +/'Store/test parameters/covariance-matrix'                    !20
     +/'Display graphical deconvolution for order > 1'              !21 
     +/'Help'                                                       !22
     +/'Do not ask again this session'                              !23  
     +/'Quit ... Try other options')                                !24 
      END
C
C--------------------------------------------------------------
C
      SUBROUTINE FUNCT1 (N,
     +                   XC, FC)
C
C Evaluation of the weighted residual  if NPTS = 1
C Evaluation of the objective function if NPTS > 1
C

      USE MODULE_MMFIT, ONLY : NPTS, DOFDOM, ERRY, THEORY, YVAL
      
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      DOUBLE PRECISION, INTENT (IN)  :: XC(N)
      DOUBLE PRECISION, INTENT (OUT) :: FC
C
C Locals
C      
      INTEGER    I
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL ZMOD
      CALL ZMOD (XC)
      IF (NPTS.EQ.1) THEN
         FC = (YVAL(1) - THEORY(1))/ERRY(1)
      ELSE
         FC = ZERO
         DO I = 1, NPTS
            FC = FC + ((YVAL(I) - THEORY(I))/ERRY(I))**2
         ENDDO
         FC = FC/DOFDOM
      ENDIF
      END
C
C--------------------------------------------------------------------------
C
      SUBROUTINE RANDOM (ISTATE, ITIME, KLOG, MAXNUM, MODE, NBIG, NDOF,
     +                   NF, NN, NPAR, NPTS, NRAND, NSMALL, NUMBER, NX,
     +                   DOFDOM, FACT, SIGMA, STORES, WSSQ, X, XM, YT,
     +                   ISTOP, NOUT)
C
C Random search for starting estimates for scaling factors
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: KLOG, NN, NX
      INTEGER,          INTENT (IN)    :: ITIME, MODE, NF, NPTS
      INTEGER,          INTENT (INOUT) :: NPAR(NN)
      INTEGER,          INTENT (OUT)   :: ISTATE(NX), NDOF, NUMBER
      INTEGER,          INTENT (IN)    :: MAXNUM, NBIG, NRAND, NSMALL
      DOUBLE PRECISION, INTENT (IN)    :: XM, YT 
      DOUBLE PRECISION, INTENT (OUT)   :: DOFDOM, FACT(NX), X(NX)
      DOUBLE PRECISION, INTENT (INOUT) :: SIGMA, STORES(NX), WSSQ(NN)
      LOGICAL,          INTENT (IN)    :: NOUT(KLOG)
      LOGICAL,          INTENT (INOUT) :: ISTOP
C
C Locals
C     
      INTEGER    N2
      PARAMETER (N2 = 2)
      INTEGER    NEACH(N2)
      INTEGER    I, J, K, L, NLOOPS, NTYPES
      INTEGER    COLOUR
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, TEN, PNT1, PNT2
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, TEN = 10.0D+00, PNT1 = 0.1D+00,
     +           PNT2 = 0.2D+00)
      DOUBLE PRECISION A, B, BMA, DUMMY, F, FSUM, STDEV
      DOUBLE PRECISION G05CAF$, G05DDF$
      CHARACTER  LINE*100, SYMBOL(N2)*6
      LOGICAL    POSTIV(20)
      EXTERNAL   G05CAF$, G05DDF$
      EXTERNAL   PUTFAT, TESTQS, FUNCT1, XSTART, TABLE1
      INTRINSIC  DBLE
      IF (ISTOP) RETURN
C
C First set NPAR, NUMBER, NDOF, DOFDOM then ABORT if DOFDOM <= 0
C
      NPAR(ITIME) = 2*ITIME
      NUMBER = NPAR(ITIME)
      NDOF = NPTS - NUMBER
      DOFDOM = DBLE(NDOF)
      IF (NDOF.LE.0) THEN
         CALL PUTFAT ('Insufficient data ... Analysis terminated')
         ISTOP = .TRUE.
         RETURN
      ENDIF
C
C Now set the factors depending on ITIME
C
      DO I = 1, NUMBER
         ISTATE(I) = 1
         IF (I.LE.ITIME) THEN
            FACT(I) = ONE/DBLE(ITIME)
         ELSE
            FACT(I) = ONE
         ENDIF
         X(I) = ONE
      ENDDO
      IF (NRAND.LT.4) THEN
C
C Random search if NRAND < 4 (else manual input of starting estimates)
C
         IF (NOUT(3)) THEN
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
         ENDIF
         CALL FUNCT1 (NUMBER, X, F)
         L = 1
         CALL TESTQS (L, ITIME, KLOG, NF, NN, NPAR, NX,
     +                DOFDOM, F, FACT, STORES,
     +                NOUT)
         NLOOPS = NBIG*(2**NUMBER)
         IF (NLOOPS.GT.MAXNUM) NLOOPS = MAXNUM
         A = ONE
         B = ZERO
         STDEV = SIGMA
C
C First a blind random search from fixed starting point
C
         DO I = 1, NSMALL
            B = B + THREE
            BMA = B - A
            STDEV = TWO*STDEV
            DO J = 1, NLOOPS
C
C Assign Vmax(i)
C
               DO K = 1, ITIME
                  FACT(K) = A + BMA*G05CAF$(DUMMY)
               ENDDO
C
C Assign Km(i)
C
               DO K = ITIME + 1, NUMBER
                  FACT(K) = TEN**G05DDF$(ZERO, STDEV)
               ENDDO
C
C Normalise the Vmax(i)
C
               FSUM = ZERO
               IF (MODE.EQ.1) THEN
                  DO K = 1, ITIME
                     FSUM = FSUM + FACT(K)
                  ENDDO
               ELSE
                  DO K = 1, ITIME
                     FSUM = FSUM + FACT(K)/FACT(ITIME + K)
                  ENDDO
               ENDIF
               FSUM = FSUM*(TEN**G05DDF$(ZERO, PNT1))
               DO K = 1, ITIME
                  FACT(K) = FACT(K)/FSUM
               ENDDO
               CALL FUNCT1 (NUMBER, X, F)
               L = 2
               CALL TESTQS (L, ITIME, KLOG, NF, NN, NPAR, NX,
     +                      DOFDOM, F, FACT, STORES,
     +                      NOUT)
            ENDDO
            IF (NOUT(3)) THEN
               WRITE (LINE,200) I, STDEV
               COLOUR = 4
               CALL TABLE1 (COLOUR, LINE)
               WRITE (NF,200) I, STDEV
            ENDIF
         ENDDO
C
C Now an intelligent local random search from best-fit position
C
         DO I = 1, NLOOPS
            DO J = 1, ITIME
               FACT(J) = STORES(J)*(TEN**G05DDF$(ZERO, PNT1))
               K = ITIME + J
               FACT(K) = STORES(K)*(TEN**G05DDF$(ZERO, PNT2))
            ENDDO
            CALL FUNCT1 (NUMBER, X, F)
            L = 2
            CALL TESTQS (L, ITIME, KLOG, NF, NN, NPAR, NX,
     +                   DOFDOM, F, FACT, STORES, NOUT)
         ENDDO
         IF (NOUT(3)) THEN
            WRITE (LINE,300) PNT1, PNT2
            COLOUR = 4
            CALL TABLE1 (COLOUR, LINE)
            WRITE (NF,300) PNT1, PNT2
         ENDIF
         L = 3
         CALL TESTQS (L, ITIME, KLOG, NF, NN, NPAR, NX,
     +                DOFDOM, F, FACT, STORES,
     +                NOUT)
      ELSEIF (NRAND.EQ.4) THEN
C
C Input starting estimates if search is by-passed, i.e. NRAND = 4
C
         NTYPES = 2
         NEACH(1) = ITIME
         NEACH(2) = ITIME
         SYMBOL(1) = '  Vmax'
         SYMBOL(2) = '    Km'
         DO I = 1, NUMBER
            POSTIV(I) = .TRUE.
         ENDDO
         CALL XSTART (NUMBER, NTYPES, NEACH, 
     +                STORES,
     +                SYMBOL,
     +                POSTIV)
         DO I = 1, ITIME
            FACT(I) = STORES(I)/YT
            J = ITIME + I
            FACT(J) = STORES(J)/XM
         ENDDO
      ENDIF
C
C Call FUNCT1 to make sure WSSQ(ITIME) is defined
C
      CALL FUNCT1 (NUMBER, X, F)
      WSSQ(ITIME) = DOFDOM*F
C*100 FORMAT (1X,'Wait',3X,'...',3X,'Random search in progress')
  200 FORMAT (1X,'Search',I2,1X,'finished (Sigma =',F5.2,')')
  300 FORMAT (1X,'Local search over (Sigma =',F5.2,',',F5.2,')')
      END
C
C--------------------------------------------------------------------------
C
      SUBROUTINE TESTQS (ISEND, ITIME, KLOG, NF, NN, NPAR, NX,
     +                   DOFDOM, F, FACT, STORES,
     +                   NOUT)
C
C Examine WSSQ for improvement and store best-fit factors
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: KLOG, NN, NX
      INTEGER,          INTENT (IN)    :: ISEND, ITIME, NF, NPAR(NN)
      DOUBLE PRECISION, INTENT (IN)    :: DOFDOM, F
      DOUBLE PRECISION, INTENT (INOUT) :: FACT(NX), STORES(NX)
      LOGICAL,          INTENT (IN)    :: NOUT(KLOG)
C
C Locals
C      
      INTEGER    I, ICOUNT, J, JCOUNT
      INTEGER    COLOUR
      DOUBLE PRECISION QSAVE, TEMP, TESTQ
      CHARACTER  LINE*100, LINE6(6)*100
      CHARACTER (LEN = 9) FORM09, WORD9(2)
      EXTERNAL   TABLE1, FORM09
      SAVE       ICOUNT, JCOUNT, QSAVE, TESTQ
      DATA       ICOUNT, JCOUNT, QSAVE, TESTQ / 0, 0, 0.0D+00, 0.0D+00 /
      IF (ISEND.EQ.1) THEN
         ICOUNT = 0
         JCOUNT = 0
         QSAVE = DOFDOM*F
         IF (NOUT(3)) THEN
            COLOUR = 4
            WRITE (LINE,100) ITIME, ITIME
            CALL TABLE1 (COLOUR, LINE)
            WRITE (NF,100) ITIME, ITIME
         ENDIF
      ELSEIF (ISEND.EQ.2) THEN
         ICOUNT = ICOUNT + 1
         IF (F.GE.TESTQ) RETURN
         JCOUNT = JCOUNT + 1
      ENDIF
      IF (ISEND.EQ.1 .OR. ISEND.EQ.2) THEN
         TESTQ = F
         IF (NOUT(3)) THEN
            TEMP = DOFDOM*F
            WORD9(1) = FORM09(TEMP)
            WRITE (LINE,200) ICOUNT, WORD9(1)
            COLOUR = 0
            CALL TABLE1 (COLOUR, LINE)
            WRITE (NF,200) ICOUNT, WORD9(1)
         ENDIF
         DO J = 1, NPAR(ITIME)
            STORES(J) = FACT(J)
         ENDDO
      ELSEIF (ISEND.EQ.3) THEN
         DO J = 1, NPAR(ITIME)
            FACT(J) = STORES(J)
         ENDDO
         WORD9(1) = FORM09(QSAVE)
         TEMP = DOFDOM*TESTQ
         WORD9(2) = FORM09(TEMP)
         IF (NOUT(3)) THEN
            
            WRITE (LINE6,300) ITIME, ITIME, ICOUNT, JCOUNT, WORD9(1),
     +                        WORD9(2)
            DO I = 1, 5
               IF (I.EQ.2) THEN
                  COLOUR = 4
               ELSE
                  COLOUR = 0
               ENDIF
               LINE = LINE6(I)
               CALL TABLE1 (COLOUR, LINE)
            ENDDO
            CALL TABLE1 (COLOUR, 'CLOSE')
         ENDIF
         WRITE (NF,300) ITIME, ITIME, ICOUNT, JCOUNT, WORD9(1),
     +                  WORD9(2)
      ENDIF
C
C Format statements
C      
  100 FORMAT (1X,'Iteration    WSSQ (',I1,':',I1,')')
  200 FORMAT (1X,I8,5X,A)
  300 FORMAT (/1X,'For best random',I2,':',I1,1X,'search '
     +/1X,'Number of improvements in',I7,1X,'cycles =',I5
     +/1X,'WSSQ before search =',1X,A
     +/1X,'WSSQ after  search =',1X,A/)
      END
C
C--------------------------------------------------------------------------
C
      SUBROUTINE VMAXKM (M, MODE, N,
     +                   FKM, P, VMAX, X, Y)
C
C Predict asymptote and half saturation point
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: M, MODE, N
      DOUBLE PRECISION, INTENT (IN)  :: P(N), X, Y
      DOUBLE PRECISION, INTENT (OUT) :: FKM, VMAX
C
C Locals
C      
      INTEGER    I, IR, IND, IFAIL
      INTEGER    NF
      PARAMETER (NF = 4)
      DOUBLE PRECISION C(17), FX, TOLX, VOVER2, XX, YY
      EXTERNAL   C05AZF$
      EXTERNAL   PUTIFA
C
C Starting estimates
C
      VMAX = 0.0D+00
      IF (MODE.EQ.1) THEN
         DO I = 1, M
            VMAX = VMAX + P(I)
         ENDDO
      ELSE
         DO I = 1, M
            VMAX = VMAX + P(I)/P(I + M)
         ENDDO
      ENDIF
C
C Define KM if M = 1 o/w root finding if M > 1
C
      IF (M.EQ.1) THEN
         FKM = P(2)
         RETURN
      ELSE
         VOVER2 = VMAX/2.0D+00
         XX = X
         YY = Y
         TOLX = 1.0D-04
         IR = 0
         IND = 1
         IFAIL = 1
C
C LABEL 20: reverse communication point
C ========
C
   20    CONTINUE
         CALL C05AZF$(XX, YY, FX, TOLX, IR, C, IND, IFAIL)
         FKM = XX
         IF (IND.EQ.0) GOTO 40
         IF (IND.LT.2 .OR. IND.GT.4) GOTO 60
         FX = 0.0D+00
         IF (MODE.EQ.1) THEN
            DO I = 1, M
               FX = FX + P(I)*XX/(P(M + I) + XX)
            ENDDO
         ELSE
            DO I = 1, M
               FX = FX + P(I)/(P(M + I) + XX)
            ENDDO
         ENDIF
         FX = FX - VOVER2
         GOTO 20
C
C LABEL 40: IND = 0
C ========
C
   40    CONTINUE
      ENDIF
C
C LABEL 60: IND = 0, IND < 2 or IND > 4, check IFAIL
C ========
C
   60 CONTINUE
      CALL PUTIFA (IFAIL, NF, 'C05AZF/VMAXKM')
      END
C
C--------------------------------------------------------------------------
C
      SUBROUTINE ZMOD (P)
C
C Multi-Michaelis-Menten function
C

      USE MODULE_MMFIT, ONLY : ITIME, MODE, NPTS, FACT, THEORY, XVAL,
     +                         EQUAL
      
      IMPLICIT   NONE
C
C Argument
C      
      DOUBLE PRECISION, INTENT (IN) :: P(*)
C
C Locals
C      
      INTEGER    NN, NX
      PARAMETER (NN = 6, NX = 2*NN)
      INTEGER    I, J
      DOUBLE PRECISION A(NN), B(NN)
      DOUBLE PRECISION VSUM, T, TERM
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      DO I = 1, ITIME
         J = ITIME + I
         A(I) = FACT(I)*P(I)
         B(I) = FACT(J)*P(J)
      ENDDO
      IF (MODE.EQ.1) THEN
         DO I = 1, NPTS
            IF (EQUAL(I)) THEN
               THEORY(I) = THEORY(I - 1)
            ELSE
               VSUM = ZERO
               T = XVAL(I)
               DO J = 1, ITIME
                  TERM = A(J)*T/(B(J) + T)
                  VSUM = VSUM + TERM
               ENDDO
               THEORY(I) = VSUM
            ENDIF
         ENDDO
      ELSE
         DO I = 1, NPTS
            IF (EQUAL(I)) THEN
               THEORY(I) = THEORY(I - 1)
            ELSE
               VSUM = ZERO
               T = XVAL(I)
               DO J = 1, ITIME
                  TERM = A(J)/(B(J) + T)
                  VSUM = VSUM + TERM
               ENDDO
               THEORY(I) = VSUM
            ENDIF
         ENDDO
      ENDIF
      END
C
C
