C
C MAIN
C ADVISE
C ARGUIN
C CDFVAL
C DETAIL
C INVERT
C PARAMS
C
C     INCLUDE 'dllchk.for'
      PROGRAM MAIN
C
C VERSION : details from SIMVER/DLLCHK
C FORTRAN : 77, Double precision
C NAG     : G01FAF, G01FBF, G01FCF, G01FAF, G01DBF, G01DDF,
C           S15ABF, X01AAF, X02AMF
C INPUT   : Degrees of freedom, arguments, test statistics
C OUTPUT  : PDF, CDF, alpha, inverses for normal distribution
C           Maps X's onto uniform (0, 1) then performs Kolmogorov
C           Smirnov and chi-square tests (? cells) for normal distribution
C AUTHOR  : W. G. Bardsley, 14/08/90
C           07/07/1992 PDFCDF and substantial changes to DCTEST
C           14/03/1993 GET???, PUT??? and compressed
C           17/06/1993 RESFIL
C           10/08/1994 DBOS version
C           20/02/1995 Version for Salamanca
C           16/11/1995 Upgraded to nag mark 16
C           20/04/1997 win32 version...This only uses COMMON to communicate
C                      with CDF and PDF. N is used to indicate if parameters
C                      have been initialised.
C           07/08/1998 added dllchk
C           01/09/1998 added spower
C           14/12/1998 replaced TUTORS by TUTOR1
C           13/09/1999 added call to WINDOW
C           14/02/2000 added SIMVER
C           05/04/2001 revised
C           25/03/2003 revised DCTEST for Shapiro-Wilks NSWMAX
C           17/10/2003 added call to MVNOR1
C           01/08/2005 increased DVER to *30 and added to call to ADVISE
C           08/02/2006 removed C and D and added SUPPLY (in call to MVNOR1)
C           10/02/2006 added NEWDAT in call to MVNOR1
C           22/08/2007 revised for version 6
C           28/06/2022 added E_NUMBERS and E_FORMATS and extensive revision
C
      IMPLICIT   NONE
      INTEGER    NIN, NOUT4, N1
      PARAMETER (NIN = 3, NOUT4 = 4, N1 = 1)
      INTEGER    ISEND, JSEND, N, NOUT, N_Z
      INTEGER    NCOL_MVNOR, NROW_MVNOR
      DOUBLE PRECISION FACTOR, RTOL, XMU, XSIGMA, XVAR
      DOUBLE PRECISION X02AMF$
      DOUBLE PRECISION XVER, YVER
      DOUBLE PRECISION ONE, ZERO
      PARAMETER (ONE = 1.0D+00, ZERO = 0.0D+00)
      CHARACTER  FNAME*1024, PTITLE*70, TITLE*100
      CHARACTER  FNAME_MVNOR*1024, TITLE_MVNOR*80 
      CHARACTER  FNAME_Z*1024, TITLE_Z*80
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_normal.exe')
      CHARACTER  BLANK*1, PNAME*6
      PARAMETER (BLANK = ' ', PNAME = 'NORMAL')
      LOGICAL    ABORT, ACTION, AGAIN, FIRST, SHOW
      EXTERNAL   RESFIL, FNAMES, REVPRO, SPOWER, M_MATONE, M_VECONE
      EXTERNAL   ADVISE, DETAIL, ARGUIN, PDFVAL, CDFVAL, INVERT
      EXTERNAL   X02AMF$
      EXTERNAL   DLLCHK, WINDOW, SIMVER

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C Note ISEND = 2 since may be called from SIMSTAT which has already
C called WINDOW with ISEND = 1
C
      ISEND = 2
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER, 
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER, 
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C


      FIRST = .TRUE.
      CALL ADVISE (DVER,
     +             ABORT, FIRST)
      IF (ABORT) THEN
         AGAIN = .FALSE.
      ELSE
         FNAME = BLANK
         NOUT = NOUT4
         CALL RESFIL (NOUT,
     +                FNAME,
     +                ABORT)
         IF (ABORT) THEN
            AGAIN = .FALSE.
         ELSE
            AGAIN = .TRUE.
            WRITE (NOUT,100)
            RTOL = 1.0D+09*X02AMF$()
C
C First set N < 1 to make sure XMU and XSIGMA are initialised
C
            N = - N1
            FACTOR = ONE
            XMU = ZERO
            XSIGMA = ONE
            XVAR = ONE
            NCOL_MVNOR = - N1
            NROW_MVNOR = -N1
            FNAME_MVNOR = BLANK
            TITLE_MVNOR = BLANK
            N_Z = - N1
            FNAME_Z = BLANK
            TITLE_Z = BLANK
         ENDIF
      ENDIF
      DO WHILE (AGAIN)
         CALL DETAIL (ISEND, N, 
     +                XMU, XSIGMA, XVAR)
         IF (ISEND.EQ.1) THEN
C
C ISEND = 1: define mu and sigma
C           
            CALL ARGUIN (N, NOUT,
     +                   FACTOR, RTOL, XMU, XSIGMA, XVAR,  
     +                   PTITLE)
         ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: calculate pdf
C           
         
           CALL PDFVAL (N, NOUT, 
     +                  FACTOR, XMU, XSIGMA, XVAR)
         ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3: calculate cdf
C           
         
            CALL CDFVAL (N, NOUT, 
     +                  XMU, XSIGMA, XVAR)
         ELSEIF (ISEND.EQ.4) THEN
C
C ISEND = 4: calculate inverses
C           
         
            CALL INVERT (N, NOUT,
     +                  XMU, XSIGMA, XVAR)
         ELSEIF (ISEND.EQ.5) THEN
C
C ISEND = 5: test for normal distribution
C           
         
            JSEND = 4
            CALL M_VECONE (JSEND, NIN, NOUT, N_Z,
     +                     FNAME_Z, TITLE_Z)            
         ELSEIF (ISEND.EQ.6) THEN
C
C ISEND = 6: power and sample size
C           
         
            CALL SPOWER (NOUT)
         ELSEIF (ISEND.EQ.7) THEN
C
C ISEND = 7: multivariate normal calculations
C           
         
            JSEND = 7
            CALL M_MATONE (JSEND, NCOL_MVNOR, NIN, NOUT, NROW_MVNOR,
     +                     FNAME_MVNOR, TITLE_MVNOR)        
         ELSEIF (ISEND.EQ.8) THEN
C
C ISEND = 8: help
C           
         
            FIRST = .FALSE.
            CALL ADVISE (DVER,
     +                   ABORT, FIRST)
         ELSEIF (ISEND.EQ.9) THEN
C
C ISEND = 9: results
C           
         
            CALL REVPRO (NOUT)
         ELSE
C
C ISEND = 10: quit
C           
           
            AGAIN = .FALSE.
            CLOSE (UNIT = NOUT)
            ISEND = 2
            CALL FNAMES (ISEND,
     +                   FNAME)
         ENDIF
      ENDDO

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 2
      ACTION = .FALSE.
      CALL WINDOW (ISEND, 
     +             TITLE, 
     +             ACTION)
C
C======================================================================
C
      CLOSE (UNIT = NOUT4)
C
C Format statement
C
  100 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : NORMAL'
     +/1X,'ACTION  : Normal distribution'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (IN)  :: FIRST
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_NORMAL
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_NORMAL ('normal')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `NORMAL'
     +/'        `      '
     +/'Action  `Calculations with the normal distribution'
     +/'        `Calculate pdf/cdf/critical-values, test for'
     +/'        `normality, power/sample size calculations.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C-----------------------------------------------------------------
C
      SUBROUTINE ARGUIN (N, NOUT,  
     +                   FACTOR, RTOL, XMU, XSIGMA, XVAR, 
     +                   PTITLE)
C
C Enter MU and SIGMA then calculate constants
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (OUT)   :: N
      INTEGER,             INTENT (IN)    :: NOUT
      DOUBLE PRECISION,    INTENT (IN)    :: RTOL
      DOUBLE PRECISION,    INTENT (INOUT) :: FACTOR
      DOUBLE PRECISION,    INTENT (INOUT) :: XMU, XSIGMA, XVAR
      CHARACTER (LEN = *), INTENT (INOUT) :: PTITLE
C
C Local allocatable arrays
C      
      DOUBLE PRECISION, ALLOCATABLE :: XCDF(:), XPDF(:),
     +                                 YCDF(:), YPDF(:)
C
C Locals
C      
      INTEGER    IERR
      INTEGER    NCDF, NPAR, NPDF, NTYPE, N1
      PARAMETER (NCDF = 100, NPAR = 3, NPDF = 200, NTYPE = 1, N1 = 1)
      DOUBLE PRECISION DUMMY, PI, TEMP, XMAX, XMIN
      DOUBLE PRECISION PAR(NPAR)
      DOUBLE PRECISION ZERO, ONE, TWO, TEN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00, 
     +           TEN = 10.0D+00)
      DOUBLE PRECISION X01AAF$
      CHARACTER (LEN = 10) D10(2), FORMGR
      CHARACTER  XTITLE*1, YTITLE*17
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    AGAIN
      EXTERNAL   E_FORMATS, FORMGR
      EXTERNAL   X01AAF$
      EXTERNAL   GETD01, GETDGT, PUTADV, GETL01
      EXTERNAL   PDFCDF
      INTRINSIC  SQRT
      E_NUMBERS = E_FORMATS()
      N = N1
      CALL GETD01 (XMU, 'The mean required (mu)')
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         IF (XSIGMA.LT.RTOL) XSIGMA = ONE
         CALL GETDGT (XSIGMA, ZERO,
     +            'The standard deviation required (sigma > 0)')
         PI = X01AAF$(DUMMY)
         TEMP = SQRT(TWO*PI)*XSIGMA
         IF (TEMP.LE.RTOL) THEN
            CALL PUTADV ('Sigma is too small ... Try again')
            AGAIN = .TRUE.
         ELSE
            AGAIN = .FALSE.
         ENDIF
      ENDDO
      AGAIN = .TRUE.
      CALL GETL01 ('Plot pdf(x) and/or cdf(x) for this mu and sigma ?',
     +              AGAIN)  
      IF (.NOT.AGAIN) RETURN
      IERR = 0
      IF (ALLOCATED(XCDF)) DEALLOCATE(XCDF, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(YCDF)) DEALLOCATE(YCDF, STAT = IERR)
      IF (IERR.NE.0) RETURN      
      IF (ALLOCATED(XPDF)) DEALLOCATE(XPDF, STAT = IERR)
      IF (IERR.NE.0) RETURN  
      IF (ALLOCATED(YPDF)) DEALLOCATE(YPDF, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(XCDF(NCDF), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(YCDF(NCDF), STAT = IERR)
      IF (IERR.NE.0) RETURN    
      ALLOCATE(XPDF(NPDF), STAT = IERR)
      IF (IERR.NE.0) RETURN 
      ALLOCATE(YPDF(NPDF), STAT = IERR)
      IF (IERR.NE.0) RETURN
      FACTOR = ONE/TEMP
      XVAR = XSIGMA**2
      PAR(1) = XMU
      PAR(2) = XSIGMA
      PAR(3) = FACTOR
      IF (E_NUMBERS) THEN
         WRITE (PTITLE,100) XMU, XSIGMA
      ELSE
         D10(1) = FORMGR(XMU)
         D10(2) = FORMGR(XSIGMA)   
         WRITE (PTITLE,150) TRIM(D10(1)), TRIM(D10(2))
      ENDIF   
      XMAX = XMU + TEN*XSIGMA
      XMIN = XMU - TEN*XSIGMA
      XTITLE = 'x'
      YTITLE = 'cdf(x) and pdf(x)'
      CALL PDFCDF (NCDF, NOUT, NPAR, NPDF, NTYPE,
     +             PAR, XMIN, XCDF, XPDF, XMAX, YCDF, YPDF,
     +             PTITLE, XTITLE, YTITLE)
      DEALLOCATE(XCDF, STAT = IERR)
      DEALLOCATE(YCDF, STAT = IERR)
      DEALLOCATE(XPDF, STAT = IERR)
      DEALLOCATE(YPDF, STAT = IERR)
C
C Format statement
C      
  100 FORMAT ('Normal: mu=',1P,E9.2,', sigma=',1P,E8.2)
  150 FORMAT ('Normal: mu=',A,', sigma=',A)
      END
C
C--------------------------------------------------------------------
C
      SUBROUTINE CDFVAL (N, NOUT,
     +                   XMU, XSIGMA, XVAR)
C
C Evaluate CDF
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: N, NOUT
      DOUBLE PRECISION, INTENT (IN) :: XMU, XSIGMA, XVAR
C
C Locals
C      
      INTEGER    I, NXVALS
      INTEGER    NMAX, NMIN, N1
      PARAMETER (NMAX = 20, NMIN = 0, N1 = 1)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 9)
      INTEGER    NTEMP(3)
      DOUBLE PRECISION ALPHA, BETA, X
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION CDF_NORMAL
      DOUBLE PRECISION XTEMP(3)
      CHARACTER (LEN = 13) D13, SHOWRJ 
      CHARACTER (LEN = 90) LINE
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   PUTADV, GETJM1, TABLE4, MIDDLE, CDF_NORMAL
      EXTERNAL   PARAMS
      SAVE       NXVALS
      DATA       NXVALS / 1 /
      IF (N.LT.N1) THEN
         CALL PUTADV ('First choose option 1 to input mu and sigma')
         RETURN
      ENDIF
      CALL GETJM1 (NMIN, NXVALS, NMAX,
     +            'Number of cdf(x) values required (0 = Cancel)')
      IF (NXVALS.LT.N1) RETURN
      E_NUMBERS = E_FORMATS()  
      CALL PARAMS (NOUT,
     +             XMU, XSIGMA, XVAR)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,50)
      WRITE (NOUT,50)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      DO I = N1, NXVALS
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETR01')
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'x required for cdf(x)')
         X = XTEMP(N1)
         BETA = CDF_NORMAL (NOUT, 
     +                      X, XMU, XSIGMA)
         ALPHA = ONE - BETA
         CALL MIDDLE (ZERO, ALPHA, ONE)
         CALL MIDDLE (ZERO, BETA, ONE)
         IF (E_NUMBERS) THEN
            WRITE (LINE,100) X, BETA, ALPHA
            WRITE (NOUT,100) X, BETA, ALPHA
         ELSE
            D13 = SHOWRJ(X) 
            WRITE (LINE,150) D13, BETA, ALPHA
            WRITE (NOUT,150) D13, BETA, ALPHA 
         ENDIF  
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statement
C   
   50 FORMAT (13X,'x',8X,'cdf(x)',6X,'1-cdf(x)')   
  100 FORMAT (1X,1P,E13.5,5X,0P,F9.6,5X,F9.6)
  150 FORMAT (1X,A13,5X,F9.6,5X,F9.6)   
      END
C
C-----------------------------------------------------------------
C
      SUBROUTINE DETAIL (ISEND, N,
     +                   XMU, XSIGMA, XVAR)
C
C Decide option required
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (INOUT) :: ISEND
      INTEGER,          INTENT (IN)    :: N
      DOUBLE PRECISION, INTENT (IN)    :: XMU, XSIGMA, XVAR
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT, N1,
     +           N3, N4
      PARAMETER (ICOLOR = 9, IX = 12, IY = 8, LSHADE = 1, NUMOPT = 10,
     +           NSTART = 3 , NTEXT = 17, N1 = 1, N3 = 3, N4 = 4)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    I, ISAV
      CHARACTER (LEN = 13) D13(3), SHOWLJ
      CHARACTER  LINES(5)*100, TEXT(NTEXT)*100
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   LBOX01
      SAVE       ISAV
      DATA       ISAV   / 8 /
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      E_NUMBERS = E_FORMATS()
      WRITE (TEXT,100)
      IF (N.LT.N1) THEN
         WRITE (LINES,200)
      ELSE
         IF (E_NUMBERS) THEN
            WRITE (LINES,300) XMU, XSIGMA, XVAR
         ELSE
            D13(1) = SHOWLJ(XMU)    
            D13(2) = SHOWLJ(XSIGMA)
            D13(3) = SHOWLJ(XVAR)
            WRITE (LINES, 350) D13(1), D13(2), D13(3)
         ENDIF   
      ENDIF
      DO I = N1, N4
         TEXT(NTEXT - N4 + I) = LINES(I)
      ENDDO
      NUMBLD(N1) = N1
      NUMBLD(NTEXT - N3) = N1
      ISEND = ISAV
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, ISEND, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT, 
     +             BORDER, FLASH, HIGH)
      ISAV = ISEND
C
C Format statements
C      
  100 FORMAT (
     + 'Options available for program NORMAL'
     +/
     +/'Input: mu and sigma, plot pdf(x)/cdf(x)'
     +/'Input: x, calculate pdf(x)'
     +/'Input: x, calculate cdf(x)'
     +/'Input: alpha, calculate x'
     +/'Test if data are normally distributed'
     +/'Power and sample size calculations'
     +/'Multivariate normal calculations'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit program NORMAL'/////)
  200 FORMAT ('Choose option 1 to initialise mu and sigma'///)
  300 FORMAT ('Current fixed parameters are:'
     +/'mu =',1P,E11.3
     +/'sigma =',E10.3
     +/'sigma^2 =',E10.3)
  350 FORMAT ('Current fixed parameters are:'
     +/'mu =',1X,A
     +/'sigma =',1X,A
     +/'sigma^2 =',1X,A)     
      END
C
C-----------------------------------------------------------------
C
      SUBROUTINE INVERT (N, NOUT,
     +                   XMU, XSIGMA, XVAR)
C
C Invert normal distribution
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: N, NOUT
      DOUBLE PRECISION, INTENT (IN) :: XMU, XSIGMA, XVAR
C
C Locals
C      
      INTEGER    I, NXVALS
      INTEGER    NMIN, NMAX, N1, N2, N3
      PARAMETER (NMAX = 20, NMIN = 0, N1 = 1, N2 = 2, N3 = 3)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 9)
      INTEGER    NTEMP(3)
      DOUBLE PRECISION PCMAX, PCMIN
      PARAMETER (PCMAX = 99.99D+00, PCMIN = 0.01D+00)
      DOUBLE PRECISION ALPHA, BETA, CDFINV_NORMAL, PCENT, XVAL
      DOUBLE PRECISION XTEMP(3)
      DOUBLE PRECISION ONE, CENT
      PARAMETER (ONE = 1.0D+00, CENT = 100.0D+00)
      CHARACTER (LEN = 13) D13, SHOWRJ
      CHARACTER (LEN = 90) LINE
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   PUTADV, GETJM1, TABLE4, CDFINV_NORMAL
      EXTERNAL   PARAMS
      SAVE       NXVALS
      DATA       NXVALS / 1 /
      IF (N.LT.N1) THEN
         CALL PUTADV ('First choose option 1 to input mu and sigma')
         RETURN
      ENDIF
      E_NUMBERS = E_FORMATS()
      CALL GETJM1 (NMIN, NXVALS, NMAX,
     +            'Number of percentage points required (0 = Cancel)')
      IF (NXVALS.LT.N1) RETURN
      CALL PARAMS (NOUT, XMU, XSIGMA, XVAR)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,50)
      WRITE (NOUT,50)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      XTEMP(N1) = PCMIN
      XTEMP(N3) = PCMAX
      DO I = N1, NXVALS
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETRL1')
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP,
     +               'Percentage point (i.e. 100*alpha) required')
         PCENT = XTEMP(N2)
         ALPHA = PCENT/CENT
         BETA = ONE - ALPHA
         XVAL = CDFINV_NORMAL (NOUT, 
     +                         BETA, XMU, XSIGMA)
         IF (E_NUMBERS) THEN
            WRITE (LINE,100) XVAL, BETA, ALPHA
            WRITE (NOUT,100) XVAL, BETA, ALPHA
         ELSE
            D13 = SHOWRJ(XVAL)
            WRITE (LINE,150) D13, BETA, ALPHA
            WRITE (NOUT,150) D13, BETA, ALPHA
         ENDIF      
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statements
C      
   50 FORMAT (13X,'x',10X,'beta',9X,'alpha')   
  100 FORMAT (1X,1P,E13.5,5X,0P,F9.6,5X,F9.6)
  150 FORMAT (1X,A13,5X,F9.6,5X,F9.6)   
      END
C
C-----------------------------------------------------------------
C
      SUBROUTINE PARAMS (NOUT,
     +                   XMU, XSIGMA, XVAR)
C
C Output current parameters to file
C
      IMPLICIT NONE
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: XMU, XSIGMA, XVAR
      CHARACTER (LEN = 13) D13(3), SHOWLJ
      LOGICAL E_NUMBERS, E_FORMATS
      EXTERNAL E_FORMATS, SHOWLJ 
      E_NUMBERS = E_FORMATS()   
      IF (E_NUMBERS) THEN
         WRITE (NOUT,100) XMU, XSIGMA, XVAR
      ELSE
         D13(1) = SHOWLJ(XMU)
         D13(2) = SHOWLJ(XSIGMA)
         D13(3) = SHOWLJ(XVAR)
         WRITE (NOUT,150) TRIM(D13(1)), TRIM(D13(2)), D13(3)
      ENDIF      
  100 FORMAT (/1X,'Current parameters: mu =',1P,E11.3,
     +', sigma =',E10.3,', sigma^2 =',E10.3)
  150 FORMAT (/1X,'Current parameters: mu =',1X,A,
     +', sigma =',1X,A,', sigma^2 =',1X,A)     
      END
C
C--------------------------------------------------------------------
C
      SUBROUTINE PDFVAL (N, NOUT, 
     +                   FACTOR, XMU, XSIGMA, XVAR)
C
C Calculate PDF(X) given X
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: N, NOUT
      DOUBLE PRECISION, INTENT (IN) :: FACTOR, XMU, XSIGMA, XVAR
C
C Locals
C      
      INTEGER    I, NXVALS
      INTEGER    NMAX, NMIN, N1
      PARAMETER (NMAX = 20, NMIN = 0, N1 = 1)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 9)
      INTEGER    NTEMP(3)
      DOUBLE PRECISION PDF_NORMAL, VALUE, X
      DOUBLE PRECISION XTEMP(3)
      CHARACTER (LEN = 13) D13(2), SHOWRJ 
      CHARACTER (LEN = 90) LINE
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   PUTADV, GETJM1, TABLE4, PDF_NORMAL
      EXTERNAL   PARAMS
      SAVE       NXVALS
      DATA       NXVALS / 1 /
      IF (N.LT.N1) THEN
         CALL PUTADV ('First choose option 1 to input mu and sigma')
         RETURN
      ENDIF
      E_NUMBERS = E_FORMATS()
      CALL GETJM1 (NMIN, NXVALS, NMAX,
     +            'Number of pdf(x) values required (0 = Cancel)')
      IF (NXVALS.LT.N1) RETURN
      CALL PARAMS (NOUT,
     +             XMU, XSIGMA, XVAR)
C
C Open TABLE4, write out the header to LINE and NOUT then proceed to calculate  
C     
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,50)
      WRITE (NOUT,50)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      DO I = N1, NXVALS
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETR01')
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'x required for pdf(x)')
         X = XTEMP(N1)
         VALUE = PDF_NORMAL (X, FACTOR, XMU, XSIGMA)
         IF (E_NUMBERS) THEN 
            WRITE (LINE,100) X, VALUE
            WRITE (NOUT,100) X, VALUE
         ELSE
            D13(1) = SHOWRJ(X)
            D13(2) = SHOWRJ(VALUE)
            WRITE (LINE,150) D13(1), D13(2)
            WRITE (NOUT,150) D13(1), D13(2)
         ENDIF
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'CLOSE')
   50 FORMAT (13X,'x',9X,'pdf(x)')   
  100 FORMAT (1X,1P,E13.5,2X,E13.5)
  150 FORMAT (1X,A13,2X,A13)
      END
C
C
