C
C FTN95 version
C =============
C
C POLNOM.FOR: MAIN, ADVISE
C ===========
C
C Requires extra source code
C ==========================
C Originally all the code was in POLNOM but to allow access from
C LINFIT and SIMSTAT the subroutines were renamed and included in
C the SIMFIT DLL at 01/07/1999
C
C polnom1.ins: INVERT,  FPOLY,  FCN07,  FCN09,  FCN10,  SUB00
C              POLINV, POLFCN, POLF07, POLF09, POLF10, POL000
C              (Now collected into pol001.for in w_simfit.dll)
C polnom2.ins: SUB01,  SUB02,  SUB03,  SUB04,  SUB05
C              POL001, POL002, POL003, POL004, POL005
C              (Now collected into pol002 in w_simfit.dll) 
C polnom3.ins: SUB06,  SUB07,  SUB08 , SUB09,  SUB10
C              POL006, POL007, POL008, POL009, POL010
C              (Now collected into pol003 in w_simfit.dll) 
C
C
C MODE is used to control the polynomial fitting routines as follows:
C ====
C MODE = 1: linear/polynomial (NTYPE chosen, data input, ADVISE from POLNOM)
C MODE = 2: polynomial (NTYPE = 3, data input, ADVISE from POLNOM)
C MODE = 3: polynomial (NTYPE = 3, data supplied, ADVISE from SIMSTAT)
C MODE = 4: linear (NTYPE = 1 or 2, data supplied, ADVISE from LINFIT/SIMSTAT)
C
C NTYPE has this effect
C =====
C NTYPE = 1: simple line fitting
C NTYPE = 2: comprehensive line fitting
C NTYPE = 3: polynomial fitting
C
C Summary: MODE = 1 is reserved for the comprehensive version of POLNOM
C =======  MODE = 2 is the normal mode for POLNOM
C          MODE = 3 is for polynomial fitting from SIMSTAT
C          MODE = 4 is for linear fitting from LINFIT or SIMSTAT
C
C
C POL000 = SUB00 ... main driver
C POL001 = SUB01 ... read in the data
C POL002 = SUB02 ... transform the data
C POL003 = SUB03 ... fit the data
C POL004 = SUB04 ... statistics
C POL005 = SUB05 ... choose the degree
C POL006 = SUB06 ... covariance matrix
C POL007 = SUB07 ... evaluate y = f(x)
C POL008 = SUB08 ... calibrate x = g(y)
C POL009 = SUB09 ... solve f(x) - const = 0
C POL010 = SUB010... 95% confidence limits
C
C Now include the extra source code
C =================================
C
C     INCLUDE 'pol001.for', NOLIST
C     INCLUDE 'pol002.for', NOLIST
C     INCLUDE 'pol003.for', NOLIST
C     INCLUDE 'dllchk.for'
C
C
      PROGRAM MAIN
C
C VERSION : details from SIMVER/DLLCHK
C FORTRAN : 95, Double precision
C NAG       C02AGF, C05AZF, E02ADF, E02AKF, F01ABF, F04ASF, F04ATF,
C           G01EBF, G01EDF, G01ECF, G01FBF, X02AJF, X02AMF
C INPUT   : File with TITLE, NPTS, X, Y, Standard error in Y.
C           can also type in data directly
C OUTPUT  : Polynomials in Chebyshev representation up to degree 6,
C           F-statistics, F(X) given X, X given F(X), conf. limits.
C           Details can be written to a data output file
C AUTHOR  : W. G. Bardsley, 20/10/1986
C REVISED : 17/11/1988 Subroutine GRAPHS added and other small changes
C REVISED : 12/06/1990 PROBRS, INVERT and NAG substitutes FZ1CAF, FZ1CLF
C REVISED : 25/03/1991 DATTIN, DATCHK, RES001
C           29/04/1991 Added SCREEN and GRFGK3
C           30/05/1991 Added LINFIT
C           09/01/1992 Corrected ... IF (V(I,J).LT.0) V(I,J) = 0
C           22/04/1992 XFROMY and YFROMX and /LGLS/
C           22/06/1992 SYMBOL
C           21/01/1993 GET???, PUT??? and compressed
C           10/04/1993 GKST04
C           15/06/1993 RESFIL
C           12/03/1994 DBOS version
C           21/11/1995 Upgraded for nag mark 16
C           18/12/1996 Removed LINFIT
C           05/08/1997 win32 version .. changed NP to 10000, added ATEMP to
C                      INVERT to overcome LAPACK difference and saved all
C                      named common blocks
C           21/03/1998 Added GOGOGO and replaced LINFIT
C           07/08/1998 added dllchk
C           14/12/1998 replaced TUTORS by TUTOR1
C           22/01/1999 added NTYPE (1=LINE, 2=PLUS CORRELATION, 3=FULL)
C           18/04/1999 major revisions:-
C                      1) FZ1CAF and FZ1CLF transferred to w_maths.dll (as $.for routines)
C                      2) SUB00 created to act as driver
C                      3) All COMMON blocks removed
C                      4) Re-named all procedures to begin with POL to avoid possible
C                         ambiguities in the DLLs
C           04/07/1999 Added TITLE to argument list 
C           18/08/1999 revised control
C           13/09/1999 added call to WINDOW
C           14/02/2000 added SIMVER
C           05/04/2001 revised
C           01/08/2005 increased DVER to *30 and added to call to ADVISE
C           29/11/2007 introduced call to M_MATONE
C
      IMPLICIT   NONE
      INTEGER    JSEND, NIN, NOUT
      PARAMETER (JSEND = 23, NIN = 3, NOUT = 4)
      INTEGER    ISEND, NCSAV, NRSAV
      DOUBLE PRECISION XVER, YVER
      CHARACTER  DNAME*1024, FNAME*1024, TITLE*80
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_polnom.exe')
      CHARACTER  BLANK*1, PNAME*6
      PARAMETER (BLANK = ' ', PNAME = 'POLNOM')
      LOGICAL    ABORT, ACTION, ISTOP, NEW, SHOW
      EXTERNAL   ADVISE, M_MATONE, GOGOGO, RESFIL
      EXTERNAL   DLLCHK, WINDOW, SIMVER

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

C
C Initialise
C
      NCSAV = 0
      NRSAV = 0
      FNAME = BLANK
      TITLE = BLANK
C
C Advice
C
      CALL ADVISE (DVER,
     +             ISTOP)
      IF (.NOT.ISTOP) THEN
        CALL RESFIL (NOUT,
     +               FNAME,
     +               ISTOP)
        WRITE (NOUT,100)
      ENDIF   
C
C The main loop
C
      DO WHILE (.NOT.ISTOP)
         CALL M_MATONE (JSEND, NCSAV, NIN, NOUT, NRSAV,
     +                  DNAME, TITLE)      
         CALL GOGOGO (NOUT,
     +                DNAME, FNAME, PNAME,
     +                ISTOP, NEW)
      ENDDO

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C
      CLOSE (UNIT = NOUT)

  100 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : POLNOM'
     +/1X,'ACTION  : Fit polynomials for calibration/evaluation'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')

      END
C
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT, N3
      PARAMETER (ICOLOR = 3, NUMHDR = 13, N3 = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(N3)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(N3)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_POLNOM
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / N3*1 /
      OPTION(1) = 'Help           '
      OPTION(2) = 'Run the program'
      OPTION(3) = 'Quit  ...  Exit'
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (HEADER,100) DVER
         NUMOPT = N3
         ISEND = 1
         CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT,
     +                NUMPOS,
     +                HEADER, OPTION)
         IF (ISEND.EQ.1) THEN
            CALL HELP_POLNOM ('polnom')
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `POLNOM'
     +/'        `      '
     +/'Action  `Fit a straight line or sequence of polynomials of'
     +/'        `increasing degree (with confidence envelopes) for'
     +/'        `predicting x with 95% confidence limits given y.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C
