C
C
C QNFIT01.INS
C ===========
C These subroutines do not use MODULE_QNFIT
C
C Insert file for QNFIT containing subroutine ... DATAIN
C                                  subroutine ... DECIDE
C
C
      SUBROUTINE DATAIN (IRELAB, METH, MITER, MODEL, MTYPE, NIN, NOUT,
     +                   NP, NPAR1, NPTS, NVAR, NX, NZEROS,
     +                   BL1, BU1, DTOL, D02TOL, EPSI, ERROR, FVAL, S,
     +                   T, U, V, W, XVAL, X1, YVAL, ZVAL,
     +                   FNAME1, FNAME2, LABELS, OTYPE, RELABS, TITLE,
     +                   ABORT, DEQN, EQUAL, EXPERT, OLDMOD, SUPPLY,
     +                   USE_D02CJF, USE_D02EJF,
     +                   USE_E04JYF, USE_E04KZF, USE_E04UFF,
     +                   USE_JACOBIAN)
C
C ACTION : Read data from file, check, calculate EQUAL, NZEROS, set XVAL(NPTS+1)
C ADVICE : S, T, U, V, W are used to read in the total data set
C          This is then manipulated as required to suppress/restore data
C          Then NPTS is set and XVAL, FVAL, YVAL, ZVAL, ERROR etc.
C          EPSI is used to decide EQUAL for replicates and it should be
C          set equal to RTOL or similar in the calling program
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          18/08/1998 now sets FNAME1 = BLANK if exit requested
C          05/03/1999 added option for MULTI function mode
C          10/05/2004 extensive editing and added LABELS and CHKBOX
C          18/11/2009 extensive editing
C          21/01/2010 added SUPPLY_DAT for call to DAT5IN 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NIN, NOUT, NP, NX
      INTEGER,             INTENT (INOUT) :: IRELAB, METH, MITER, MODEL,
     +                                       MTYPE, NPAR1, NPTS, NVAR, 
     +                                       NZEROS
      DOUBLE PRECISION,    INTENT (IN)    :: EPSI 
      DOUBLE PRECISION,    INTENT (INOUT) :: DTOL, D02TOL 
      DOUBLE PRECISION,    INTENT (INOUT) :: BL1(NX), BU1(NX), 
     +                                       ERROR(NP), FVAL(NP)
      DOUBLE PRECISION,    INTENT (INOUT) :: S(NP), T(NP), U(NP), V(NP),
     +                                       W(NP)
      DOUBLE PRECISION,    INTENT (INOUT) :: XVAL(NP), X1(NX), YVAL(NP),
     +                                       ZVAL(NP)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME1, FNAME2, LABELS(NP),
     +                                       OTYPE, RELABS, TITLE
      LOGICAL,             INTENT (INOUT) :: ABORT, DEQN, EQUAL(NP),
     +                                       EXPERT, OLDMOD, SUPPLY,
     +                                       USE_D02CJF,
     +                                       USE_D02EJF,  
     +                                       USE_E04JYF, 
     +                                       USE_E04KZF,
     +                                       USE_E04UFF,
     +                                       USE_JACOBIAN 
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N13, N17,
     +           N18, N30
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N7 = 7, N8 = 8, N9 = 9, N10 = 10, N13 = 13, 
     +           N17 = 17, N18 = 18, N30 = 30)
      INTEGER    I, IOS, J, K, NCOL, NDATA, NDEC, NMSAV, NVSAV
      INTEGER    COLOUR, KCOLOR
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (IX = 4, IY = 4, LSHADE = 1)
      INTEGER    NUMBLD(N30), NUMPOS(N10)
      INTEGER    NUMCOL, NUMROW
      PARAMETER (NUMCOL = 2, NUMROW = 0)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 13) D13(5), SHOWRJ 
      CHARACTER (LEN = 12) I12(3), FORM12
      CHARACTER  CIPHER*8, LOGO1*80, LOGO2*80
      CHARACTER  LINE*100, TEXT(N30)*100
      CHARACTER  COPY1*80, COPY2*80, TRIM40*40, TRIM80*80
      CHARACTER  BLANK*1, DOTS*4
      PARAMETER (BLANK = ' ', DOTS = ',...')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    CHKDAT, CHECKD, FIRST, FIRST1, NEWFIL
      LOGICAL    QNLGLS, SHOWIT, SUBSET
      LOGICAL    BORDER, FLASH, HIGH 
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    SUPPLY_DAT, USE_QNLGLS
      PARAMETER (SUPPLY_DAT = .TRUE., USE_QNLGLS = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWRJ
      EXTERNAL   ADVISE, QNCFIG, QNEDIT, MULT1A, QNLGLS, QNDAT5
      EXTERNAL   RESFIL, DAT5IN, DATCHK, PUTADV, GETIM1,
     +           YESNO1, YESNO2, LBOX01, PATCH1, TABLE5, CHKBOX, TRIM40,
     +           TRIM80, EOFEXP
      EXTERNAL   QNFIT_REQUIRED 
      INTRINSIC  ABS, TRIM
      SAVE       NDATA, NMSAV, NVSAV
      SAVE       CHKDAT, CHECKD, FIRST, NEWFIL
      DATA       FIRST, CHECKD, NEWFIL / .TRUE. , .FALSE., .TRUE. /
      DATA       NDATA / 0 /
      DATA       NUMBLD / N30*0 /
      DATA       NUMPOS / N10*1 /
      E_NUMBERS = E_FORMATS()
C
C First time initialise and open output file if required
C
      IF (FIRST) THEN
         FIRST = .FALSE.
         DEQN = .FALSE.
         SUPPLY = .FALSE.
         MTYPE = N1
         NMSAV = - N1
         NVSAV = - N1
         CALL RESFIL (NOUT, 
     +                FNAME2,
     +                ABORT)
         IF (ABORT) THEN
            FNAME2 = BLANK
         ELSE   
            WRITE (NOUT,100)  
         ENDIF   
         SHOWIT = USE_QNLGLS  
         IF (SHOWIT) THEN
            CHKDAT = QNLGLS (N17)
         ELSE     
            WRITE (TEXT,200)
            LINE = 'Check new data sets ? (usually yes)'
            CHKDAT = .TRUE.
            ICOLOR = 9
            NTEXT = 15
            CALL YESNO1 (ICOLOR, IX, IY, LSHADE, NUMCOL, NUMROW,
     +                   NTEXT,
     +                   LINE, TEXT,
     +                   BORDER, FLASH, HIGH, CHKDAT)
         ENDIF
      ELSE
         CHKDAT = QNLGLS (N17)   
      ENDIF
C
C********************
C LABEL 20: main loop
C********************
C
   20 CONTINUE
C
C Set LOGO1 and LOGO2 then request model type
C
      IF (FNAME2.EQ.BLANK) THEN
         LOGO1 = '**Results are not being saved in a file**'
         NUMBLD(20) = N1
      ELSE
         LOGO1 = 'Results are saved in '//TRIM40(FNAME2)
         NUMBLD(20) = N0
      ENDIF
      IF (CHKDAT .OR. DEQN) THEN
         LOGO2 = 'Files are being checked for order'
         NUMBLD(21) = N0
      ELSE
         LOGO2 = '**Files are not being checked for order**'
         NUMBLD(21) = N1
      ENDIF
      WRITE (TEXT,300) LOGO1, LOGO2
      ICOLOR = 3
      NUMOPT = 10
      NSTART = 15
      NTEXT = NUMOPT + NSTART + 2
      NUMBLD(1) = N1
      NUMBLD(8) = N1
      NUMBLD(9) = N1
      NUMBLD(10) = N1
      NUMBLD(11) = N1
      NUMBLD(12) = N1
      NUMBLD(26) = N1
      NUMBLD(27) = N1
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, MTYPE, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      CALL QNFIT_REQUIRED (MTYPE)
      NUMBLD(1) = N0
      NUMBLD(8) = N0
      NUMBLD(9) = N0
      NUMBLD(10) = N0
      NUMBLD(11) = N0
      NUMBLD(12) = N0
      NUMBLD(26) = N0
      NUMBLD(27) = N0
      DEQN = .FALSE.
      SUPPLY = .FALSE.
      NVAR = MTYPE
      IF (MTYPE.EQ.N4) THEN
C
C Differential equation has been selected
C
         NVAR = N1
         DEQN = .TRUE.
      ELSEIF (MTYPE.EQ.N5) THEN
C
C Try to read in multifunction data with 1 variable
C
         CLOSE (UNIT = NIN)
         CALL MULT1A (NIN, NP, NPAR1, NPTS, NX,
     +                BL1, BU1, ERROR, FVAL, XVAL, X1,
     +                ABORT, EQUAL, EXPERT)
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            EXPERT = .FALSE.
            GOTO 20
         ELSE
            NVAR = N1
            DEQN = .FALSE.
            FNAME1 = 'Several data files'
            OLDMOD = .FALSE.
            TITLE = 'Multi function data'
            RETURN
         ENDIF
      ELSEIF (MTYPE.EQ.N6) THEN
C
C Try to read in multifunction data with > 1 variable
C
      
         CALL PUTADV ('Not available in this version')
         GOTO 20
      ELSEIF (MTYPE.EQ.N7) THEN
C
C Configure optimiser and ODE solver
C      
         CALL QNCFIG (IRELAB, METH, MITER,
     +                DTOL, D02TOL,
     +                OTYPE, RELABS,
     +                USE_D02CJF, USE_D02EJF,
     +                USE_E04JYF, USE_E04KZF, USE_E04UFF,
     +                USE_JACOBIAN)
         GOTO 20
         
      ELSEIF (MTYPE.EQ.N8) THEN
C
C Configure QNFIT options
C      
         SHOWIT = QNLGLS (N0)
         GOTO 20
      ELSEIF (MTYPE.EQ.N9) THEN
C
C Help
C      
         FIRST1 = .FALSE.
         CALL ADVISE (MTYPE,
     +                BLANK,
     +                ABORT, FIRST1)
         GOTO 20
      ELSEIF (MTYPE.EQ.N10) THEN
         FNAME1 = BLANK
         ABORT = .TRUE.
         RETURN
      ENDIF
C
C Open new file or use old file
C
      IF (NVAR.NE.NVSAV) NEWFIL = .TRUE.
      IF (.NOT.NEWFIL) THEN
         IF (NVAR.EQ.N1) THEN
            CALL QNEDIT (NOUT,
     +                   FNAME1, TITLE,
     +                   ABORT, CHKDAT, DEQN, NEWFIL)
            IF (ABORT) RETURN
         ELSE
            COPY1 = TRIM80(FNAME1)
            COPY2 = TRIM80(TITLE)
            WRITE (TEXT,400) COPY1, COPY2
            ICOLOR = 9
            NTEXT = 5
            LINE = 'Input new data file ?'
            NEWFIL = .FALSE.
            CALL YESNO1 (ICOLOR, IX, IY, LSHADE, NUMCOL, NUMROW,
     +                   NTEXT,
     +                   LINE, TEXT,
     +                   BORDER, FLASH, HIGH, NEWFIL)
         ENDIF
      ENDIF
C
C Read in a new data file
C
      IF (NEWFIL) THEN
         NCOL = NVAR + N2
         CLOSE (UNIT = NIN)
         CALL QNDAT5 (NIN, NPTS, NCOL,
     +                FNAME1, TITLE,
     +                ABORT)
         CLOSE (UNIT = NIN)
         IF (.NOT.ABORT) THEN       
            CALL DAT5IN (NIN, NP, NPTS, NCOL,
     +                   S, T, U, V, W,
     +                   FNAME1, TITLE,
     +                   ABORT, SUPPLY_DAT)
             CLOSE (UNIT = NIN) 
         ENDIF    
         IF (ABORT) THEN
            FNAME1 = BLANK
            GOTO 80
         ENDIF
         IF (CHKDAT .OR. DEQN) THEN
            IF (NVAR.EQ.N1) CALL DATCHK (NPTS, 
     +                                   U, S, T,
     +                                   ABORT)
         ENDIF
         IF (ABORT) THEN
            FNAME1 = BLANK
            CHECKD = .FALSE.
            GOTO 80
         ELSE
            CHECKD = .TRUE.
         ENDIF
C
C Call EOFEXP to see if the file has starting estimates appended
C         
         CALL EOFEXP (NPAR1, NX,
     +                BL1, X1, BU1,           
     +                FNAME1,
     +                ABORT) 
         SHOWIT = QNLGLS (N13)
         IF (.NOT.ABORT .AND. NPAR1.GT.0) THEN
C
C Expert mode parameters have been identified
C           
            EXPERT = .TRUE.
            IF (SHOWIT) THEN
               COLOUR = 15
               CALL TABLE5 (COLOUR, 'OPEN')
               WRITE (TEXT,600) NPAR1
               NTEXT = N1
               WRITE (LINE,700) NPAR1
               NTEXT = NTEXT + N1
               TEXT(NTEXT) = LINE
               NTEXT = NTEXT + N1
               TEXT(NTEXT) = BLANK
               WRITE (LINE,800)
               NTEXT = NTEXT + N1
               TEXT(NTEXT) = LINE
               DO I = N1, NTEXT
                  IF (I.EQ.N1 .OR. I.EQ.NTEXT) THEN
                     COLOUR = N4
                  ELSE
                     COLOUR = N0
                  ENDIF
                  CALL TABLE5 (COLOUR, TEXT(I))
               ENDDO
               COLOUR = N0
               DO I = N1, NPAR1
                  WRITE (LINE,900) I, BL1(I), X1(I), BU1(I)
                  CALL TABLE5 (COLOUR, LINE)
               ENDDO
               CALL TABLE5 (COLOUR, 'CLOSE')
            ENDIF   
         ELSE
C
C Attempt to read parameters from extra details
C           
            ABORT = .FALSE.
            WRITE (LINE,500)
            ICOLOR = 9
            EXPERT = .FALSE.
            CALL YESNO2 (ICOLOR, IX, IY, 
     +                   LINE,
     +                   EXPERT)
            IF (EXPERT) THEN
               OPEN (UNIT = NIN, FILE = FNAME1, IOSTAT=IOS)
               IF (IOS.NE.N0) GOTO 60  
               DO I = N1, NPTS + N2
                  READ (NIN,'(A)',END=60,ERR=60,IOSTAT=IOS) LINE
               ENDDO  
C
C Read the trailer in EXPERT mode
C
               IF (SHOWIT) THEN
                  COLOUR = 15
                  CALL TABLE5 (COLOUR, 'OPEN')
               ENDIF   
               J = N1
               READ (NIN,*,END=60,ERR=60,IOSTAT=IOS) K
               IF (E_NUMBERS) THEN
                  WRITE (TEXT,600) K
               ELSE
                  I12(1) = FORM12(K)
                  WRITE (TEXT,650) I12(1)
               ENDIF  
               NTEXT = N2
               IF (K.LT.N2 .OR. IOS.NE.N0) GOTO 60
               J = J + N1
               READ (NIN,*,END=60,ERR=60,IOSTAT=IOS) NPAR1
               IF (E_NUMBERS) THEN
                  WRITE (LINE,700) NPAR1
               ELSE
                  I12(1) = FORM12(NPAR1) 
                  WRITE (LINE,750) I12(1)
               ENDIF    
               NTEXT = NTEXT + N1
               TEXT(NTEXT) = LINE
               IF (NPAR1.LT.N0 .OR. NPAR1.GT.NX .OR. NPAR1.GT. (K-N1)
     +             .OR. IOS.NE.N0) GOTO 60
               NTEXT = NTEXT + N1
               TEXT(NTEXT) = BLANK
               WRITE (LINE,800)
               NTEXT = NTEXT + N1
               TEXT(NTEXT) = LINE
               IF (SHOWIT) THEN
                  DO I = N1, NTEXT
                     IF (I.EQ.N1 .OR. I.EQ.NTEXT) THEN
                        COLOUR = N4
                     ELSE
                        COLOUR = N0
                     ENDIF
                    CALL TABLE5 (COLOUR, TEXT(I))
                  ENDDO
                  COLOUR = N0
               ENDIF   
               DO I = N1, NPAR1
                  J = J + N1
                  READ (NIN,*,END=60,ERR=60,IOSTAT=IOS) BL1(I), X1(I),
     +                                                  BU1(I)
                  IF (BL1(I).GT.X1(I) .OR. X1(I).GT.BU1(I) .OR.
     +                IOS.NE.0) GOTO 60
                  IF (SHOWIT) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,900) I, BL1(I), X1(I), BU1(I)
                     ELSE
                        D13(1) = SHOWRJ(BL1(I))
                        D13(2) = SHOWRJ(X1(I))
                        D13(3) = SHOWRJ(BU1(I))
                        WRITE (LINE,950) I, D13(1), D13(2), D13(3) 
                     ENDIF  
                     CALL TABLE5 (COLOUR, LINE)
                  ENDIF   
               ENDDO
               IF (SHOWIT) CALL TABLE5 (COLOUR, 'CLOSE')
            ENDIF
         ENDIF
         CLOSE (UNIT = NIN)
         NVSAV = NVAR
         NEWFIL = .FALSE.
      ELSE
C
C Read in data from old file again for manipulation
C
         OPEN (UNIT = NIN, FILE = FNAME1, STATUS = 'OLD')
         READ (NIN,'(A)') TITLE
         READ (NIN,*) NPTS, NCOL
         IF (NVAR.EQ.1) THEN
            READ (NIN,*) (S(I), T(I), U(I), I = N1, NPTS)
         ELSEIF (NVAR.EQ.2) THEN
            READ (NIN,*) (S(I), T(I), U(I), V(I), I = N1, NPTS)
         ELSEIF (NVAR.EQ.3) THEN
            READ (NIN,*) (S(I), T(I), U(I), V(I), W(I), I = N1, NPTS)
         ENDIF
         CLOSE (UNIT = NIN)
         IF (DEQN .AND. .NOT.CHECKD) THEN
            CALL DATCHK (NPTS,
     +                   U, S, T,
     +                   ABORT)
            IF (ABORT) THEN
               FNAME1 = BLANK
               GOTO 80
            ELSE
               CHECKD = .TRUE.
            ENDIF
         ENDIF
         WRITE (LINE,'(A)') 'Data loaded from '//TRIM80(FNAME1)
         CALL PUTADV (LINE)
      ENDIF
      DO I = N1, NPTS
         EQUAL(I) = .TRUE.
      ENDDO
      NDATA = NDATA + N1
      WRITE (NOUT,'(A)') ' ***'
      WRITE (NOUT,1000) NDATA
C
C******************************************
C LABEL 40: Use all or a subset of the data
C******************************************
C
   40 CONTINUE
      SUBSET = QNLGLS (N18)
      IF (SUBSET) THEN
C
C Choose a sub-set of the data
C        
         J = N0
         DO I = N1, NPTS
            IF (EQUAL(I)) J = J + N1
         ENDDO
         IF (E_NUMBERS) THEN
            WRITE (TEXT,1100) NPTS, J
         ELSE
            I12(1) = FORM12(NPTS)
            I12(2) = FORM12(J)  
            WRITE (TEXT,1150) I12(1), I12(2) 
         ENDIF  
         ICOLOR = 3
         NUMOPT = 6
         NDEC = NUMOPT
         NSTART = 6
         NTEXT = NUMOPT + NSTART - 1
         NUMBLD(1) = N4
         NUMBLD(3) = N1
         NUMBLD(4) = N1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         NUMBLD(3) = N0
         NUMBLD(4) = N0
         IF (NDEC.EQ.N1) THEN
            DO I = N1, NPTS
               EQUAL(I) = .TRUE.
            ENDDO
            IF (E_NUMBERS) THEN
               WRITE (NOUT,1200) N1, NPTS
            ELSE
               I12(1) = FORM12(N1)
               I12(2) = FORM12(NPTS)
               WRITE (NOUT,1250) TRIM(I12(1)), I12(2)
            ENDIF  
            GOTO 40
         ELSEIF (NDEC.EQ.N2) THEN
            CALL GETIM1 (N1, J, NPTS, 
     +                  'Line number to start data suppression')
            CALL GETIM1 (J, K, NPTS, 
     +                  'Line number to stop  data suppression')
            DO I = J, K
               EQUAL(I) = .FALSE.
            ENDDO
            IF (E_NUMBERS) THEN
               WRITE (NOUT,1300) J, K
            ELSE
               I12(1) = FORM12(J)
               I12(2) = FORM12(K)
               WRITE (NOUT,1350) I12(1), I12(2)
            ENDIF  
            GOTO 40
         ELSEIF (NDEC.EQ.N3) THEN
            CALL GETIM1 (N1, J, NPTS,
     +                  'Line number to start data restoration')
            CALL GETIM1 ( J, K, NPTS,
     +                  'Line number to stop  data restoration')
            DO I = J, K
               EQUAL(I) = .TRUE.
            ENDDO
            IF (E_NUMBERS) THEN
               WRITE (NOUT,1200) J, K
            ELSE
               I12(1) = FORM12(J)
               I12(2) = FORM12(K) 
               WRITE (NOUT,1250) I12(1), I12(2)  
            ENDIF  
            GOTO 40
         ELSEIF (NDEC.EQ.N4) THEN
            LINE = 'Tick data items required for curve fitting'
            DO I = N1, NPTS
               WRITE (LABELS(I),'(I5,1PE11.3,A)') I, S(I), DOTS
            ENDDO
            CALL CHKBOX (NPTS,
     +                   LABELS, LINE,
     +                   EQUAL)
            GOTO 40
         ELSEIF (NDEC.EQ.N5) THEN
            IF (NPTS.GT.500) THEN
               CALL GETIM1 (N1, J, NPTS,
     +                      'Line number to start data display')
            ELSE
               J = N1
            ENDIF
            K = NPTS
            KCOLOR = 15
            CALL TABLE5 (KCOLOR, 'OPEN')
            IF (NVAR.EQ.1) THEN
               WRITE (LINE,1400)
            ELSEIF (NVAR.EQ.2) THEN
               WRITE (LINE,1500)
            ELSEIF (NVAR.EQ.3) THEN
               WRITE (LINE,1550)
            ENDIF
            KCOLOR = N4
            CALL TABLE5 (KCOLOR, LINE)
            KCOLOR = N0
            DO I = J, K
               IF (EQUAL(I)) THEN
                  CIPHER = BLANK
               ELSE
                  CIPHER = 'Excluded'
               ENDIF
               IF (NVAR.EQ.N1) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,1600) I, S(I), T(I), U(I),
     +                                 CIPHER
                  ELSE
                     D13(1) = SHOWRJ(S(I))
                     D13(2) = SHOWRJ(T(I))
                     D13(3) = SHOWRJ(U(I))
                     WRITE (LINE,1650) I, D13(1), D13(2), D13(3),
     +                                 CIPHER
                  ENDIF  
               ELSEIF (NVAR.EQ.N2) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,1700) I, S(I), T(I), U(I), V(I), 
     +                                 CIPHER
                  ELSE
                     D13(1) = SHOWRJ(S(I))
                     D13(2) = SHOWRJ(T(I))
                     D13(3) = SHOWRJ(U(I))
                     D13(4) = SHOWRJ(V(I)) 
                     WRITE (LINE,1725) I, D13(1), D13(2), D13(3),
     +                                 D13(4), CIPHER                     
                  ENDIF  
               ELSEIF (NVAR.EQ.N3) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,1750) I, S(I), T(I), U(I), V(I), W(I),
     +                                 CIPHER
                  ELSE
                     D13(1) = SHOWRJ(S(I))
                     D13(2) = SHOWRJ(T(I))
                     D13(3) = SHOWRJ(U(I))
                     D13(4) = SHOWRJ(V(I))
                     D13(5) = SHOWRJ(W(I))
                     WRITE (LINE,1775) I, D13(1), D13(2), D13(3),
     +                                 D13(4), D13(5), CIPHER
                  ENDIF  
               ENDIF
               CALL TABLE5 (KCOLOR, LINE)
            ENDDO
            CALL TABLE5 (KCOLOR, 'CLOSE')
            GOTO 40
         ENDIF
      ELSE 
C
C Use the whole data set
C          
         DO I = N1, NPTS
            EQUAL(I) = .TRUE.
         ENDDO   
      ENDIF   
C
C Calculate actual NPTS and data set before fitting
C
      J = NPTS
      NPTS = N0
      DO I = N1, J
         IF (EQUAL(I)) THEN
            NPTS = NPTS + N1
            IF (NVAR.EQ.1) THEN
               XVAL(NPTS) = S(I)
               FVAL(NPTS) = T(I)
               ERROR(NPTS) = U(I)
            ELSEIF (NVAR.EQ.2) THEN
               XVAL(NPTS) = S(I)
               YVAL(NPTS) = T(I)
               FVAL(NPTS) = U(I)
               ERROR(NPTS) = V(I)
            ELSEIF (NVAR.EQ.3) THEN
               XVAL(NPTS) = S(I)
               YVAL(NPTS) = T(I)
               ZVAL(NPTS) = U(I)
               FVAL(NPTS) = V(I)
               ERROR(NPTS) = W(I)
            ENDIF
         ENDIF
      ENDDO
         
C
C Set NZEROS in case DEQN = .TRUE. then set EQUAL if replicates are present
C
      NZEROS = N0
      IF (NVAR.EQ.N1) THEN
         DO I = N1, NPTS
            IF (ABS(XVAL(I)).LE.EPSI) NZEROS = NZEROS + N1
            EQUAL(I) = .FALSE.
            IF (I.GT.N1) THEN
               IF (ABS(XVAL(I) - XVAL(I-N1)).LE.EPSI) EQUAL(I) = .TRUE.
            ENDIF
            YVAL(I) = ZERO
            ZVAL(I) = ZERO
         ENDDO
         IF (DEQN) XVAL(NPTS + N1) = XVAL(NPTS) + ONE
      ELSEIF (NVAR.EQ.N2) THEN
         DO I = N1, NPTS
            EQUAL(I) = .FALSE.
            IF (I.GT.N1) THEN
               IF (ABS(XVAL(I) - XVAL(I-N1)).LE.EPSI .AND.
     +             ABS(YVAL(I) - YVAL(I-N1)).LE.EPSI) EQUAL(I) = .TRUE.
            ENDIF
            ZVAL(I) = ZERO
         ENDDO
      ELSEIF (NVAR.EQ.N3) THEN
         DO I = N1, NPTS
            EQUAL(I) = .FALSE.
            IF (I.GT.N1) THEN
               IF (ABS(XVAL(I) - XVAL(I-N1)).LE.EPSI .AND.
     +             ABS(YVAL(I) - YVAL(I-N1)).LE.EPSI .AND.
     +             ABS(ZVAL(I) - ZVAL(I-N1)).LE.EPSI) EQUAL(I) = .TRUE.
            ENDIF
         ENDDO
      ENDIF
C
C Use old model again if required then set NMSAV and return
C
      IF (MTYPE.EQ.NMSAV .AND. MODEL.GT.N0) THEN
         WRITE (LINE,1800)
         ICOLOR = 9
         OLDMOD = .TRUE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                OLDMOD)
      ELSE
         OLDMOD = .FALSE.
      ENDIF
      NMSAV = MTYPE
      RETURN
C
C***********************************************
C LABEL 60: Error reading EXPERT mode parameters
C***********************************************
C
   60 CONTINUE
      EXPERT = .FALSE.
      CLOSE (UNIT = NIN)
      IF (SHOWIT) THEN
         COLOUR = 15
         CALL TABLE5 (COLOUR, 'CLOSE')
      ENDIF   
      ABORT = .TRUE.
      CALL PUTADV ('Error reading Expert mode parameters')
      IF (E_NUMBERS) THEN
         WRITE (TEXT,1900) J, IOS, NX
      ELSE
         I12(1) = FORM12(J)
         I12(2) = FORM12(IOS)
         I12(3) = FORM12(NX)   
         WRITE (TEXT,1950) TRIM(I12(1)), I12(2), TRIM(I12(3))  
      ENDIF  
      ICOLOR = 9
      NTEXT = 13
      NUMBLD(1) = N1
      CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT,
     +             TEXT,
     +             BORDER)
      NUMBLD(1) = N0
C
C********************************
C LABEL 80: All other errors etc.
C********************************
C
   80 CONTINUE
      CLOSE (UNIT = NIN)
      CHECKD = .FALSE.
      NEWFIL = .FALSE.
      GOTO 20
C
C Format statements
C      
  100 FORMAT (
     +/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : QNFIT'
     +/1X,'ACTION  : Constrained wtd. nonlinear regression'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
  200 FORMAT (
     + 'Speeding up analysis or using data checking options'
     +/
     +/'It can be useful to check data sets before fitting'
     +/'to make sure the data are ordered for a correct run'
     +/'test, to warn you if data limits seem excessively'
     +/'big or small, or to alert you to any suspiciously'
     +/'extreme signal to noise ratios in your data.'
     +/'The program can analyse all new data files to make'
     +/'sure your data are consistent before fitting.'
     +/'Data files for diffn. eqn. fitting will always be'
     +/'checked since integration assumes increasing x.'
     +/
     +/'Experienced users of this program (QNFIT) may wish to'
     +/'switch off data checking to speed up program operation.'  
     +/)
  300 FORMAT (
     + 'Data files input and models chosen for fitting must be',
     +' consistent'
     +/
     +/'Use EXPERT mode format,e.g. for npts observations, n parameters'
     +/'x(1)    y(1)     s(1)'
     +/'...'
     +/'x(npts) y(npts) s(npts)'
     +/'m (Optional: number of lines following data so m = n + k + 2)'
     +/'begin{limits}'
     +/'Lower-limit(1)   Start-value(1)   Upper-limit(1)'
     +/'...'
     +/'Lower-limit(n)   Start-value(n)   Upper-limit(n)'
     +/'end{limits}' 
     +/'k (Optional: extra lines of text, e.g., see gauss3.tf1)'
     +/
     +/'Input data for: 1 function of 1 variable: u = f(x)'
     +/'Input data for: 1 function of 2 variables: v = g(x,y)'
     +/'Input data for: 1 function of 3 variables: w = h(x,y,z)'
     +/'Input data for: 1 differential equation: dy/dx = F(x,y)'
     +/'Input data for: n functions of 1 variable (n > 1)'
     +/'Input data for: n functions of m variables (m > 1) [NA]'
     +/'Configure: optimiser and ODE solver'
     +/'Configure: QNFIT options and procedures' 
     +/'Help'
     +/'Quit ... Exit program QNFIT'
     +/
     +/A
     +/A)
  400 FORMAT (
     + 'The current file is'
     +/A
     +/'The current data are'
     +/A
     +/)
  500 FORMAT ('Use the EXPERT mode ?')
  600 FORMAT (
     + 'Expert mode data from file'
     +/'Number of extra lines =',I4)
  650 FORMAT (
     + 'Expert mode data from file'
     +/'Number of extra lines =',1X,A)   
  700 FORMAT ('Number of starting estimates supplied =',I4)
  750 FORMAT ('Number of starting estimates supplied =',1X,A)
  800 FORMAT (
     +'Parameter  Lower limit',5X,'Start value',5X,'Upper limit')
  900 FORMAT (I3,2X,1P,3E16.3)
  950 FORMAT (I3,2X,3(3X,A13))
 1000 FORMAT (
     + 1X,'Analysis of data set number',I3
     +/1X,'------------------------------')
 1100 FORMAT (
     + 'Select the data to be used for fitting'
     +/
     +/'Number of lines in the full data set =',I6
     +/'Number of lines selected for fitting =',I6
     +/
     +/'Restore all the current data'
     +/'Suppress a contiguous block of data'
     +/'Restore a contiguous block of data'
     +/'Suppress/Restore individual items'
     +/'Display current selected data'
     +/'Fit the current selected data')
 1150 FORMAT (
     + 'Select the data to be used for fitting'
     +/
     +/'Number of lines in the full data set =',1X,A
     +/'Number of lines selected for fitting =',1X,A
     +/
     +/'Restore all the current data'
     +/'Suppress a contiguous block of data'
     +/'Restore a contiguous block of data'
     +/'Suppress/Restore individual items'
     +/'Display current selected data'
     +/'Fit the current selected data')     
 1200 FORMAT (1X,'Data restored from line',I6,1X,'to',I6)
 1250 FORMAT (1X,'Data restored from line',1X,A,1X,'to',1X,A)
 1300 FORMAT (1X,'Data suppressed from line',I6,1X,'to',I6)
 1350 FORMAT (1X,'Data suppressed from line',1X,A,1X,'to',1X,A) 
 1400 FORMAT (1X,'Line number   x',13X,'f(x)',10X,'s')
 1500 FORMAT (1X,'Line number   x',13X,'y',13X,'g(x,y)',5X,'s')
 1550 FORMAT (1X,'Line number   x',13X,'y',13X,'z',13X,'h(x,y,z)',
     +3X,'s')
 1600 FORMAT (I11,1P,3(1X,E13.5),2X,A)
 1650 FORMAT (I11,1P,3(1X,A13),2X,A)
 1700 FORMAT (I11,1P,4(1X,E13.5),2X,A)
 1725 FORMAT (I11,1P,4(1X,A13),2X,A) 
 1750 FORMAT (I11,1P,5(1X,E13.5),2X,A)
 1775 FORMAT (I11,1P,5(1X,A13),2X,A) 
 1800 FORMAT ('Use the same model ?')
 1900 FORMAT (
     + 'This file is not suitable for use in EXPERT mode'
     +/'line number `',I6,1X,'after data'
     +/'IOSTAT      `',I4
     +/
     +/'Advice    `EXPERT mode files must follow data with either'
     +/'          `a begin{limits} ... end{limits} section somewhere'
     +/'          `e.g. gauss3.tf1, or else extra lines as follows'
     +/'line 1    `an integer >= NPAR + 1'
     +/'line 2    `NPAR <=',I4,1X,'(number of parameters)'
     +/'line j    `lower limit, starting value, upper limit'
     +/'          `for 1 =< j =< NPAR where'
     +/'          `lower limit =< starting value =< upper limit'
     +/'          `e.g. test file gauss3.tf2')
 1950 FORMAT (
     + 'This file is not suitable for use in EXPERT mode'
     +/'line number `',1X,A,1X,'after data'
     +/'IOSTAT      `',1X,A
     +/
     +/'Advice    `EXPERT mode files must follow data with either'
     +/'          `a begin{limits} ... end{limits} section somewhere'
     +/'          `e.g. gauss3.tf1, or else extra lines as follows'
     +/'line 1    `an integer >= NPAR + 1'
     +/'line 2    `NPAR <=',1X,A,1X,'(number of parameters)'
     +/'line j    `lower limit, starting value, upper limit'
     +/'          `for 1 =< j =< NPAR where'
     +/'          `lower limit =< starting value =< upper limit'
     +/'          `e.g. test file gauss3.tf2')     
      END
C
c
c
      subroutine qnfit_required (isend)
c
c action: set mask for the main qnfitl menu demo files
c author: w.g.bardsley, university of manchester, u.k., 04/07/2020
c      
      implicit none
c
c argument
c      
      integer, intent (in) :: isend
c
c locals
c      
      integer i
      integer nmask
      parameter (nmask = 10)
      integer mask(nmask)
      logical required(nmask)
      logical store
      parameter (store = .true.)
      external x_putadv, query_files_required
c
c check isend
c      
      if (isend.lt.1 .or. isend.gt.10) then
         call x_putadv (
     +'ISEND out of range in call to QNFIT_REQUIRED')
         return
      endif   
      if (isend.gt.5) then
         do i = 1, nmask
            required(i) = .true.
         enddo
      else      
         do i = 1, nmask
            if (i.eq.isend) then
               required(i) = .true.
            else
               required(i) = .false.
            endif   
         enddo    
      endif
      do i = 1, nmask
         if (required(i)) then
            mask(i) = 1
         else
            mask(i) = 0
         endif  
      enddo
      call query_files_required (mask, nmask,
     +                           store)
      end
c
c          
      
C
C-----------------------------------------------------------------------
C
      SUBROUTINE DECIDE (IRELAB, ISEND, JSEND, METH, MITER, MODEL, NDOF,
     +                   NFIX, NMOD, NPAR, NPTS, NVAR, NX,
     +                   B, DTOL, D02TOL, RNDOF, RNMOD,
     +                   MODNAM, OTYPE, RELABS,
     +                   CONST, DEQN, STATS,
     +                   USE_D02CJF,
     +                   USE_D02EJF,
     +                   USE_E04JYF, 
     +                   USE_E04KZF,
     +                   USE_E04UFF,
     +                   USE_JACOBIAN)
C
C action: Decide mode of action
C         18/11/2009 extensive editing
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NVAR, NX
      INTEGER,             INTENT (IN)    :: ISEND 
      INTEGER,             INTENT (INOUT) :: IRELAB, JSEND, METH,
     +                                       MITER, MODEL, NDOF, NFIX,
     +                                       NMOD, NPAR, NPTS
      DOUBLE PRECISION,    INTENT (INOUT) :: DTOL, D02TOL
      DOUBLE PRECISION,    INTENT (INOUT) :: B(NX), RNDOF, RNMOD
      CHARACTER (LEN = *), INTENT (INOUT) :: MODNAM(4), OTYPE, RELABS
      LOGICAL,             INTENT (IN)    :: DEQN
      LOGICAL,             INTENT (INOUT) :: CONST, STATS, USE_E04JYF,
     +                                       USE_E04KZF, USE_E04UFF
      LOGICAL,             INTENT (INOUT) :: USE_D02CJF, USE_D02EJF,
     +                                       USE_JACOBIAN 
C
C Locals
C      
      INTEGER    N0, NTEST, N12
      PARAMETER (N0 = 0, NTEST = 6, N12 = 12)
      INTEGER    NUMOPT
      CHARACTER  TEXT(30)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, FIRST, REPEET
      LOGICAL    QNLGLS
      EXTERNAL   ADVISE
      EXTERNAL   IWARNU, PUTADV, LISTBX
      EXTERNAL   QNSUB1, QNSUB2, QNSUB3, QNSUBD, QNCFIG, QNLGLS
      IF (ISEND.EQ.1) THEN
C
C Choose a model else MODEL = - 1 from model subroutines
C
         REPEET = .TRUE.
         DO WHILE (REPEET)
            NMOD = 1
            IF (DEQN) THEN
               CALL QNSUBD (MODEL, NFIX, NMOD, NPAR, NX, 
     +                      B,
     +                      MODNAM,
     +                      CONST)
            ELSEIF (NVAR.EQ.1) THEN
               CALL QNSUB1 (MODEL, NFIX, NMOD, NPAR, NX,
     +                      B,
     +                      MODNAM,
     +                      CONST, DEQN)
            ELSEIF (NVAR.EQ.2) THEN
               CALL QNSUB2 (MODEL, NFIX, NMOD, NPAR, NX,
     +                      B,
     +                      MODNAM,
     +                      CONST)
            ELSEIF (NVAR.EQ.3) THEN
               CALL QNSUB3 (MODEL, NFIX, NMOD, NPAR, NX, 
     +                      B,
     +                      MODNAM,
     +                      CONST)
            ENDIF
            IF (MODEL.LT.1) RETURN
            IF (QNLGLS(N12)) THEN  
               CALL IWARNU (ISEND, NPAR, NTEST, 
     +                      ABORT)
            ELSE
               ABORT = .FALSE.
            ENDIF   
            IF (.NOT.ABORT) REPEET = .FALSE.
         ENDDO  
      ELSEIF (ISEND.EQ.2) THEN
C
C Set no. degrees of freedom if NPTS > no. free parameters
C
         IF (NPTS.GT.JSEND) THEN
            NDOF = NPTS - JSEND
            STATS = .TRUE.
         ELSE
            CALL PUTADV ('NPTS <= NPAR ... No covariance matrix')
            NDOF = 1
            STATS = .FALSE.
         ENDIF
         RNDOF = NDOF
         RNMOD = NMOD
      ELSEIF (ISEND.EQ.3) THEN
C
C Decisions to control program flow
C
         JSEND = 1
      ELSEIF (ISEND.EQ.4) THEN
C
C Return JSEND = 5 for all possible actions
C
          JSEND = 5
      ELSE
C
C Main decisions after curve fitting is finished, new data, etc.
C
         REPEET = .TRUE.
         DO WHILE (REPEET)
            WRITE (TEXT,100)
            JSEND = 15
            NUMOPT = 19
            CALL LISTBX (JSEND, NUMOPT, 
     +                   TEXT) 
C
C Adjust JSEND
C
            IF (JSEND.LE.6) THEN
               JSEND = JSEND + 4
            ELSEIF (JSEND.GE.7 .AND. JSEND.LE.10) THEN
               JSEND = JSEND - 6
            ENDIF      
C
C Check for impossible case
C         
            IF (JSEND.GE.6 .AND. JSEND.LE.10 .AND. NVAR.GT.1) THEN
               CALL PUTADV ('Only for functions of 1 variable')
               REPEET = .TRUE.
            ELSE
               REPEET = .FALSE.   
            ENDIF
C
C 1 to 13 ... Return for further action
C
            IF (JSEND.EQ.13) THEN
C
C 13 ... Configure optimiser and ODE solver
C
               CALL QNCFIG (IRELAB, METH, MITER,
     +                      DTOL, D02TOL,
     +                      OTYPE, RELABS,
     +                      USE_D02CJF, USE_D02EJF, 
     +                      USE_E04JYF, USE_E04KZF, USE_E04UFF,
     +                      USE_JACOBIAN)
               REPEET = .TRUE. 
            ELSEIF (JSEND.EQ.14) THEN
C
C 14 .. Configure program operation
C            
               REPEET = QNLGLS (N0)
               REPEET = .TRUE.   
            ELSEIF (JSEND.EQ.15) THEN
C
C 15 ... Advice
C
               FIRST = .FALSE.
               CALL ADVISE (JSEND,
     +                      BLANK,
     +                      ABORT, FIRST)
               REPEET = .TRUE.
            ELSEIF (JSEND.GT.13) THEN
C
C 16 ... Return to quit, etc.
C
               JSEND = JSEND - 3
               REPEET = .FALSE.
            ENDIF
         ENDDO
      ENDIF
C
C Format statements 
C      
  100 FORMAT (
     + 'Use best fit model`to plot WSSQ/NDOF surface/contours'
     +/'Use best fit model`to calculate area (AUC)'
     +/'Use best fit model`to calculate derivatives'
     +/'Use best fit model`for inverse prediction (calibration)'
     +/'Use best fit model`for function evaluation'
     +/'Use best fit model`to plot/extrapolate/deconvolute'
     +/'Fit again         `Input new model and/or new data'
     +/'Fit again         `Keep same data: Input new model'
     +/'Fit again         `Keep same data: Input new limits'
     +/'Fit again         `Keep same data: Input new weights'
     +/'Archive results   `WSSQ for retrospective F-tests'
     +/'Archive results   `Parameters to test for equality'
     +/'Configure         `Optimiser and ODE solver'
     +/'Configure         `QNFIT options and procedures' 
     +/'Help              `Display tutorial'
     +/'View              `Current results'
     +/'View              `Current data'
     +/'View              `Iteration details'
     +/'Quit ...          `Exit program QNFIT')
      END
C
C
