C
C 02/11/2016 Changes to OUTDAT and GOFFIT  
C            Edited the call to open and close TABLE1 at places identified by C***
C            This is intended so that the output of results should flow more continuosly
C            than previously. One problem is that intermediate windows can interrupt the
C            continuous scrolling, e.g. the call to CHECKW where users will have to drag 
C            the overwritten window out from under the table. 
C
C QNFIT02.INS
C ===========
C
C Only FUNCT1 uses MODULE_QNFIT
C
C This file contains:- subroutine ... DERIV2
C                      subroutine ... FUNCT1 (uses MODULE_QNFIT)
C                      subroutine ... FUNCT2 
C                      subroutine ... FUNCT3 
C                      subroutine ... GOFFIT
C                      subroutine ... OUTDAT
C
C----------------------------------------------------------------------
C

      subroutine deriv2 (funct, 
     +                   n,
     +                   g, w, x, 
     +                   free)
c
c action : finite difference approximation to derivatives using qngrd1
c
      implicit   none
c
c arguments
c      
      integer,          intent (in)    :: n
      double precision, intent (inout) :: g(n), w(3*n), x(n)
      logical,          intent (inout) :: free(n)
c
c locals
c      
      integer    inform
      logical    tpoint
      parameter (tpoint = .false.)
      external   funct, qngrd2
      call qngrd2 (funct,
     +             inform, n,
     +             g, w, x,
     +             free, tpoint)
      end
C
C----------------------------------------------------------------------
C
      SUBROUTINE FUNCT1 (N,
     +                   XC, FC)
C
C action: calculate wtd. resid. for VCOVAR if NPTS = 1, Objective fn. if NPTS > 1
C

      USE MODULE_QNFIT, ONLY : LWTYPE, NITER, NPTS,  
     +                         ERROR, FVAL, THEORY,
     +                         FACT, RNDOF,
     +                         RTOL

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N
      DOUBLE PRECISION, INTENT (IN)    :: XC(N)
      DOUBLE PRECISION, INTENT (OUT)   :: FC
C
C Locals
C      
      INTEGER    I, N2PRINT
      DOUBLE PRECISION SCALE1
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      LOGICAL    NORMAL, OP
      EXTERNAL   QMODEL
      INTRINSIC  ABS, SQRT
C
C Special action if LWTPE = 2 or 3
C
      NORMAL = .TRUE.
      IF (LWTYPE.EQ.2) THEN
         SCALE1 = ABS(FACT(1)*XC(1))
         IF (SCALE1.GT.RTOL) THEN
            SCALE1 = ONE/SCALE1
            NORMAL = .FALSE.
         ENDIF
      ELSEIF (LWTYPE.EQ.3) THEN
         SCALE1 = FACT(1)*XC(1)
         SCALE1 = ONE/(ONE + SCALE1**2)
         NORMAL = .FALSE.
      ENDIF
C
C Call QMODEL to define THEORY = calculated theoretical value
C
      CALL QMODEL (N,
     +             XC)
      IF (NORMAL) THEN
         IF (NPTS.EQ.1) THEN
C
C Get THEORY(1) for VCOVAR to calculate gradient/Jacobian
C
            FC = THEORY(1)/ERROR(1)
         ELSE
C
C Calculate objective function WSSQ/NDOF
C
            FC = ZERO
            DO I = 1, NPTS
               FC = FC + ((FVAL(I) - THEORY(I))/ERROR(I))**2
            ENDDO
            FC = FC/RNDOF
            INQUIRE (UNIT = NITER, OPENED = OP)
            IF (OP) THEN
               N2PRINT = MIN(19,N)
               WRITE (NITER,'(1P,20E18.10)')
     +               (XC(I), I = 1, N2PRINT), FC 
             ENDIF
         ENDIF
      ELSE
         IF (NPTS.EQ.1) THEN
C
C Get THEORY(1) for VCOVAR to calculate gradient/Jacobian using SCALE
C
            FC = SQRT(SCALE1)*(FVAL(1) - THEORY(1))/ERROR(1)
         ELSE
C
C Calculate objective function WSSQ/NDOF using SCALE
C
            FC = ZERO
            DO I = 1, NPTS
               FC = FC + ((FVAL(I) - THEORY(I))/ERROR(I))**2
            ENDDO
            FC = SCALE1*FC/RNDOF
         ENDIF
      ENDIF
      END
C
C----------------------------------------------------------------------
C
CFTN95$OPTIONS (SILENT)
      SUBROUTINE FUNCT2 (N, XC, FC, IUSER, USER)
C
C Calls FUNCT1 for use by E04JYF
C      
      IMPLICIT NONE
      INTEGER,          INTENT (IN)    :: N
      INTEGER,          INTENT (INOUT) :: IUSER(*)
      DOUBLE PRECISION, INTENT (IN)    :: XC(N)
      DOUBLE PRECISION, INTENT (INOUT) :: USER(*)
      DOUBLE PRECISION, INTENT (OUT)   :: FC
      EXTERNAL FUNCT1
      CALL FUNCT1 (N, 
     +             XC, FC)
      END
C
C----------------------------------------------------------------------
C
CFTN95$OPTIONS (SILENT)
      SUBROUTINE FUNCT3 (N, XC, FC, GC, IUSER, USER)

C
C Calls FUNCT1 for use by E04KZF
C      
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N
      INTEGER,          INTENT (INOUT) :: IUSER(*)
      DOUBLE PRECISION, INTENT (IN)    :: XC(N)
      DOUBLE PRECISION, INTENT (INOUT) :: USER(*)
      DOUBLE PRECISION, INTENT (OUT)   :: FC, GC(N)
C
C Locals
C      
      INTEGER    I 
      INTEGER    INFORM
      LOGICAL    TPOINT
      PARAMETER (TPOINT = .FALSE.)
      EXTERNAL   FUNCT1, QNGRD1
      CALL QNGRD1 (FUNCT1,
     +             INFORM, N,
     +             GC, USER, XC,
     +             TPOINT)     
      CALL FUNCT1 (N, 
     +             XC, FC)
      END      
C 
C----------------------------------------------------------------------
C
      SUBROUTINE GOFFIT (IFAIL, ISEND, ISTATE, MODEL, NDOF, NFILE,
     +                   NGRAF, NMOD, NOUT, NP, NPAR, NPTS, NVAR, NX,
     +                   NZEROS,
     +                   BL, BU, EPSI, ERROR, FACT, FVAL, PX, RTOL, S,
     +                   SIGMA, T, THEORY, TIME, U, V, W, WSSQ, X, XVAL,
     +                   YVAL, ZVAL,
     +                   FNAME1, FNAME2, TEXT,
     +                   CONST, DEQN, EQSAV, EQUAL, MULTI1, STATS,
     +                   USE_E04JYF, USE_E04KZF, USE_E04UFF)
C
C action: goodness of fit and graphics
C         18/11/2009 extensive editing
C
      IMPLICIT   NONE
C
C Arguments
C  
      INTEGER,             INTENT (IN)    :: ISEND, MODEL, NDOF, NFILE,
     +                                       NGRAF, NMOD, NOUT, NP, 
     +                                       NPAR, NVAR, NX   
      INTEGER,             INTENT (INOUT) :: IFAIL, NPTS, NZEROS
      INTEGER,             INTENT (INOUT) :: ISTATE(NX)
      DOUBLE PRECISION,    INTENT (IN)    :: EPSI, RTOL
      DOUBLE PRECISION,    INTENT (INOUT) :: BL(NX), BU(NX), ERROR(NP),
     +                                       FACT(NX), FVAL(NP), PX(NX),
     +                                       S(NP), SIGMA, T(NP),
     +                                       THEORY(NP), TIME, U(NP),
     +                                       V(NP), W(NP), WSSQ,
     +                                       X(NX), XVAL(NP), YVAL(NP),
     +                                       ZVAL(NP)      
      CHARACTER (LEN = *), INTENT (IN)    :: FNAME1, FNAME2
      CHARACTER (LEN = *), INTENT (INOUT) :: TEXT(20)
      LOGICAL,             INTENT (IN)    :: CONST, DEQN, MULTI1, STATS
      LOGICAL,             INTENT (INOUT) :: EQSAV(NP), EQUAL(NP)
      LOGICAL,             INTENT (IN)    :: USE_E04JYF, USE_E04KZF,
     +                                       USE_E04UFF  
C
C Locals
C      
      INTEGER    L0, L1
      PARAMETER (L0 = 0, L1 = 1)
      INTEGER    COLOUR, I, J, K, L, NSAV, NTEMP, NZSAV
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4)
      DOUBLE PRECISION ZERO, ONE, PNT01, PNT05
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, PNT01 = 0.01D+00,
     +           PNT05 = 0.05D+00)
      DOUBLE PRECISION SIGBOT, SIGMAX, SIGTOP
      PARAMETER (SIGBOT = 1.0D-06, SIGMAX = 1.0D+09, SIGTOP = 1.0D+06)
      DOUBLE PRECISION ALPHA, ASYMP, C, XMAX, XMIN
      DOUBLE PRECISION G01ECF$
      CHARACTER (LEN = 13) D13, SHOWLJ
      CHARACTER (LEN = 12) I12(2), FORM12
      CHARACTER  BLANK*1, NONE*46, WORD6*6
      PARAMETER (BLANK = ' ', NONE = ' ')
      CHARACTER  MESSAGE*46, PTITLE*23, XTITLE*1, YTITLE*1
      CHARACTER  LINE*100
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    FILE_1, FILE_2, FILE_3, GRAPH, OK, TABLE_1,
     +           TABLE_2
      LOGICAL    YES
      LOGICAL    QNLGLS
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   PUTIFA, TESTPS, DIVIDE, QMODEL, GKST04, GKSR02,
     +           PUTADV, TABLE1
      EXTERNAL   QNLGLS
      EXTERNAL   G01ECF$
      EXTERNAL   ZMCUTS
      INTRINSIC  ABS, DBLE, TRIM
      E_NUMBERS = E_FORMATS()
      IF (ISEND.EQ.1) THEN
C
C Tests before curve fitting
C
         IF (SIGMA.LT.SIGBOT) THEN
            MESSAGE = 'CAUTION : WSSQ/NDOF small on entry ... <1.0E-6'
         ELSEIF (SIGMA.GT.SIGMAX) THEN
            MESSAGE = '*FATAL* : WSSQ/NDOF too large  ... Try again ?'
         ELSEIF (SIGMA.GT.SIGTOP) THEN
            MESSAGE = 'WARNING : WSSQ/NDOF large on entry ... > 1.0E6'
         ELSE
            MESSAGE = NONE
         ENDIF
         IF (E_NUMBERS) THEN
            WRITE (LINE,100) WSSQ, MESSAGE
            WRITE (NOUT,100) WSSQ, MESSAGE
         ELSE
            D13 = SHOWLJ(WSSQ)
            WRITE (LINE,150) D13, MESSAGE
            WRITE (NOUT,150) D13, MESSAGE
         ENDIF  
         TEXT(17) = LINE
      ELSEIF (ISEND.EQ.2) THEN
C
C Tests after curve fitting
C
         IF (IFAIL.LT.0) THEN
            MESSAGE = '*FATAL* : Bad data in call to fitting routine'
         ELSEIF (IFAIL.EQ.0) THEN
C            NTEMP = 0
C            YES = QNLGLS (NTEMP)
            MESSAGE = NONE
         ELSEIF (IFAIL.EQ.2) THEN
            MESSAGE = '*FATAL* : Max. iterations used ... Try again ?'
         ELSE
            MESSAGE = 'WARNING : Minimum ill-defined  ... Try again ?'
         ENDIF
          IF (USE_E04JYF) THEN
            WORD6 = 'E04JYF'
         ELSEIF (USE_E04KZF) THEN
            WORD6 = 'E04KZF'
         ELSEIF (USE_E04UFF) THEN
            WORD6 = 'E04UFF'
         ELSE
            WORD6 = 'LBFGSB'
         ENDIF
         IF (E_NUMBERS) THEN            
            WRITE (LINE,200) WORD6, IFAIL, MESSAGE
            WRITE (NOUT,200) WORD6, IFAIL, MESSAGE
         ELSE
            I12(1) = FORM12(IFAIL)
            WRITE (LINE,250) WORD6, TRIM(I12(1)),  MESSAGE
            WRITE (NOUT,250) WORD6, TRIM(I12(1)),  MESSAGE
         ENDIF  
         TEXT(18) = LINE
         IF (SIGMA.LT.SIGBOT) THEN
            MESSAGE = 'CAUTION : WSSQ/NDOF small on exit ... < 1.0E-6'
         ELSEIF (SIGMA.GT.SIGMAX) THEN
            MESSAGE = '*FATAL* : WSSQ/NDOF too large  ... Try again ?'
         ELSEIF (SIGMA.GT.SIGTOP) THEN
            MESSAGE = 'WARNING : WSSQ/NDOF large on exit  ... > 1.0E6'
         ELSE
            MESSAGE = NONE
         ENDIF
         IF (E_NUMBERS) THEN 
            WRITE (LINE,300) WSSQ, MESSAGE
            WRITE (NOUT,300) WSSQ, MESSAGE
         ELSE
            D13 = SHOWLJ(WSSQ)
            WRITE (LINE,350) TRIM(D13), MESSAGE
            WRITE (NOUT,350) TRIM(D13), MESSAGE 
         ENDIF  
         TEXT(19) = LINE
         IF (STATS) THEN
            IFAIL = 1
            ALPHA = G01ECF$('Upper-tail', WSSQ, DBLE(NDOF), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01ECF/GOFFIT')
            IF (ALPHA.LT.PNT01) THEN
              MESSAGE = 'WARNING : Bad fit  ... WSSQ > 99% Chi-sq point'
            ELSEIF (ALPHA.LT.PNT05) THEN
              MESSAGE = 'CAUTION : Poor fit ... WSSQ > 95% Chi-sq point'
            ELSE
               MESSAGE = NONE
            ENDIF
            WRITE (LINE,400) ALPHA, MESSAGE
            WRITE (NOUT,400) ALPHA, MESSAGE
            J = 20
            TEXT(J) = LINE
         ELSE
            J = 19
         ENDIF
         NTEMP = 1
         YES = QNLGLS (NTEMP)
         IF (YES) THEN
C***        COLOUR = 15
C***        CALL TABLE1 (COLOUR, 'OPEN')
            DO I = 1, J
               IF (I.EQ.2 .OR. I.EQ.4 .OR. I.EQ.6 .OR. I.EQ.12) THEN
                  COLOUR = 4
               ELSE
                  COLOUR = 0
               ENDIF
               CALL TABLE1 (COLOUR, TEXT(I))
            ENDDO
            IF (E_NUMBERS) THEN
               WRITE (LINE,500) TIME
            ELSE
               D13 = SHOWLJ(TIME)
               WRITE (LINE,550) TRIM(D13)
            ENDIF       
            CALL TABLE1 (COLOUR, LINE)
C***        CALL TABLE1 (COLOUR, 'CLOSE')
         ENDIF 
         IF (E_NUMBERS) THEN  
            WRITE (NOUT,500) TIME
         ELSE
            D13 = SHOWLJ(TIME)
            WRITE (NOUT,550) TRIM(D13)
         ENDIF  
         NTEMP = 15
         YES = QNLGLS (NTEMP)
         OK = .TRUE.
         DO L = 1, NPAR
            I = 2
            J = L
            K = 1
            CALL TESTPS (I, ISTATE(J), J, K, 
     +                   BL(J), BU(J), EPSI, PX(J), RTOL, C, X(J),
     +                   LINE)
            IF (YES) THEN
               IF (K.EQ. - 1) THEN
                  IF (OK) THEN
                     COLOUR = 15
C***                 CALL TABLE1 (COLOUR, 'OPEN')
                     COLOUR = 0
                     OK = .FALSE.
                  ENDIF
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
            ENDIF   
         ENDDO
C***     IF (YES .AND. .NOT.OK) CALL TABLE1 (COLOUR, 'CLOSE')
C
C Graph of data and best fit curve if required then analysis of residuals
C
      ELSEIF (ISEND.EQ.3) THEN
         IF (NVAR.EQ.1 .AND. .NOT.MULTI1) THEN
            NTEMP = 3
            YES = QNLGLS (NTEMP)
            IF (YES) THEN
               XMAX = XVAL(1)
               XMIN = XMAX
               DO I = 1, NPTS
                  IF (XVAL(I).GT.XMAX) XMAX = XVAL(I)
                  IF (XVAL(I).LT.XMIN) XMIN = XVAL(I)
                  S(I) = XVAL(I)
                  T(I) = FVAL(I)
                  U(I) = THEORY(I)
                  V(I) = ERROR(I)
                  EQSAV(I) = EQUAL(I)
               ENDDO
               NSAV = NPTS
               NPTS = NGRAF
               DO I = 1, NGRAF
                  ERROR(I) = ONE
                  EQUAL(I) = .FALSE.
               ENDDO
               CALL DIVIDE (NGRAF, 
     +                      XVAL, XMIN, XMAX)
               IF (DEQN) THEN
                  EQUAL(NGRAF + 1) = .FALSE.
                  XVAL(NGRAF + 1) = XMAX + ONE
                  NZSAV = NZEROS
                  IF (ABS(XMIN).GT.ZERO) THEN
                     NZEROS = 0
                  ELSE
                     NZEROS = 1
                  ENDIF
               ENDIF
               CALL QMODEL (NPAR,
     +                      X)
               ASYMP = - ONE
               IF (.NOT.DEQN) THEN
                  IF (MODEL.EQ.2) THEN
                     ALPHA = FACT(2*NMOD)*X(2*NMOD)
                     IF (ABS(ALPHA).GT.RTOL) THEN
                       ASYMP = FACT(NMOD)*X(NMOD)/ALPHA
                        IF (ASYMP.GT.RTOL) THEN
                            IF (E_NUMBERS) THEN
                               WRITE (LINE,700) NMOD, 2*NMOD, ASYMP
                            ELSE
                               D13 = SHOWLJ(ASYMP)
                               WRITE (LINE,750) NMOD, 2*NMOD, D13
                            ENDIF
                         ENDIF     
                      ENDIF
                  ELSEIF (MODEL.EQ.3 .OR. MODEL.EQ.4) THEN
                     ASYMP = ZERO
                    DO I = 1, NMOD
                       ASYMP = ASYMP + FACT(I)*X(I)
                     ENDDO
                     IF (CONST)
     +                   ASYMP = ASYMP + FACT(2*NMOD + 1)*X(2*NMOD + 1)
                     IF (ASYMP.GT.RTOL) THEN
                        IF (E_NUMBERS) THEN
                           WRITE (LINE,800) 2*NMOD+1, NMOD, ASYMP
                        ELSE
                           D13 = SHOWLJ(ASYMP)
                           WRITE (LINE,850) 2*NMOD+1, NMOD, D13 
                        ENDIF   
                     ENDIF 
                  ELSEIF (MODEL.EQ.5 .OR. MODEL.EQ.6) THEN
                     ASYMP = FACT(NMOD + 1)*X(NMOD + 1)
                     IF (CONST)
     +                   ASYMP = ASYMP + FACT(NMOD + 2)*X(NMOD + 2)
                     IF (ASYMP.GT.RTOL) THEN
                         WRITE (LINE,900) NMOD + 1, NMOD + 2, ASYMP
                     ELSE
                        D13 = SHOWLJ(ASYMP) 
                        WRITE (LINE,950) NMOD + 1, NMOD + 2, D13
                     ENDIF
                  ENDIF
               ENDIF
               IF (ASYMP.GT.RTOL) CALL PUTADV (LINE)
               PTITLE = 'Data and best-fit curve'
               XTITLE = 'x'
               YTITLE = 'y'
               GRAPH = .TRUE.
               CALL GKST04 (L0, L1, L0, L0, 
     +                      L1, L0, L0, L0,
     +                      NSAV, NGRAF, NGRAF, NGRAF,
     +                      ASYMP,
     +                      S, XVAL, XVAL, XVAL,
     +                      T, THEORY, THEORY, THEORY,
     +                      PTITLE, XTITLE, YTITLE, 
     +                      GRAPH, GRAPH)
               NPTS = NSAV
               DO I = 1, NPTS
                  XVAL(I) = S(I)
                  FVAL(I) = T(I)
                  THEORY(I) = U(I)
                  ERROR(I) = V(I)
                  EQUAL(I) = EQSAV(I)
               ENDDO
               IF (DEQN) THEN
                  NZEROS = NZSAV
                  XVAL(NPTS + 1) = XVAL(NPTS) + ONE
               ENDIF
            ENDIF
         ELSEIF (NVAR.EQ.2) THEN
            CALL ZMCUTS (NGRAF, NP, NPAR, NPTS, NX,
     +                   EPSI, FVAL, S, T, THEORY, U, V, W, X, XVAL,
     +                   YVAL, ZVAL,
     +                   FNAME1,
     +                   EQSAV, EQUAL)
         ENDIF
      ELSE
         CALL QMODEL (NPAR,
     +                X)
         NTEMP = 7
         FILE_1 = QNLGLS (NTEMP)  !residuals to file
         NTEMP = 10
         FILE_2 = QNLGLS (NTEMP)  !analysis table to file
         NTEMP = 8
         FILE_3 = QNLGLS (NTEMP)  !Save As ... residuals
         NTEMP = 11
         GRAPH = QNLGLS (NTEMP)   !plot residuals
         NTEMP = 6
         TABLE_1 = QNLGLS (NTEMP) !display residuals 
         NTEMP = 9
         TABLE_2 = QNLGLS (NTEMP) !display analysis 
         IF (FNAME2.EQ.BLANK) THEN
            FILE_1 = .FALSE.
            FILE_2 = .FALSE.
         ENDIF   
         CALL GKSR02 (NOUT, NFILE, NPAR, NPTS, NVAR,
     +                FVAL, U, ERROR, THEORY, V, XVAL, YVAL, ZVAL,
     +                FILE_1, FILE_2, FILE_3, GRAPH, TABLE_1, TABLE_2)
      ENDIF
C
C Format statements
C      
  100 FORMAT (1X,'WSSQ before entry     =',1P,E13.5,3X,A)
  150 FORMAT (1X,'WSSQ before entry     =',1X,A13,3X,A) 
  200 FORMAT (1X,'IFAIL from',1X,A,'     =',I6,9X,A)
  250 FORMAT (1X,'IFAIL from',1X,A,'     =',1X,A,1X,9X,A)
  300 FORMAT (1X,'WSSQ from fitting     =',1P,E13.5,3X,A)
  350 FORMAT (1X,'WSSQ from fitting     =',1X,A,3X,A)
  400 FORMAT (1X,'P(chi-sq >= WSSQ)     =',F7.4,5X,A)
  500 FORMAT (1X,'Time taken to fit     =',1P,E13.5,' (secs cpu time)')
  550 FORMAT (1X,'Time taken to fit     =',1X,A,' (secs cpu time)')  
  700 FORMAT (
     +'Hill plot A = p(',I2,')/p(',I2,') i.e. ',1P,E13.5)
  750 FORMAT (
     +'Hill plot A = p(',I2,')/p(',I2,') i.e. ',1X,A)     
  800 FORMAT (
     +'Hill plot A = p(',I2,') + sum of p(i),(i=1 to',I2,
     + ') i.e.',1P,E13.5)
  850 FORMAT (
     +'Hill plot A = p(',I2,') + sum of p(i),(i=1 to',I2,
     + ') i.e.',1X,A)     
  900 FORMAT (
     +'Hill plot A = p(',I2,') + p(',I2,') i.e.',1P,E13.5)
  950 FORMAT (
     +'Hill plot A = p(',I2,') + p(',I2,') i.e.',1X,A)     
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE OUTDAT (IFAIL, INDEX, ISEND, ISTATE, MODEL, NDOF,
     +                   NFILE, NFIX, NFREE, NGRAF, NHESS, NMOD, NOUT,
     +                   NP, NPAR, NPTS, NUMPOS, NVAR, NX, NZEROS,
     +                   BL, BU, CORR, CV, DIAGV, EIGVAL, EPSI, ERR,
     +                   ERROR, FACT, FJACC, FVAL, G, HESSEX, HESSIN, P,
     +                   PAR, PX, RNDOF, RTOL, S, SIGMA, T, THEORY,
     +                   TIME, U, V, W, WSSQ, W2, X, XVAL, YVAL, ZVAL,
     +                   FNAME1, FNAME2, MODNAM, RECORD, SYMBOL, TITLE,
     +                   CONST, DEQN, EQSAV, EQUAL, FREE, MULTI1, STATS,
     +                   USE_D02CJF, USE_D02EJF, 
     +                   USE_E04JYF, USE_E04KZF, USE_E04UFF,
     +                   USE_JACOBIAN)
C
C action: output current results
C         18/11/2009 extensive editing
C         06/01/2016 decreased the 'OPEN' and 'CLOSE' calls to TABLE1 to get continuous scrolling output
C                    Note: the main 'OPEN' is now at lines 617-618 and the main 'CLOSE' is at line 810
C         11/11/2021 changed HESSIN(NX,NX) to HESSIN(NHESS,NHESS)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: MODEL, NDOF, NFILE, NGRAF,
     +                                       NHESS, NMOD, NOUT, NP,
     +                                       NPAR, NVAR, NX
      INTEGER,             INTENT (INOUT) :: IFAIL, ISEND,  NFIX, NFREE,
     +                                       NPTS, NUMPOS, NZEROS
      INTEGER,             INTENT (INOUT) :: INDEX(NX), ISTATE(NX)
      DOUBLE PRECISION,    INTENT (IN)    :: EPSI, RTOL
      DOUBLE PRECISION,    INTENT (INOUT) :: BL(NX), BU(NX),
     +                                       CORR(NHESS,NHESS),
     +                                       CV(NHESS,NHESS), DIAGV(NX),
     +                                       EIGVAL(NX), ERR(NX),
     +                                       ERROR(NP), FACT(NX),
     +                                       FJACC(NP,NX), FVAL(NP),
     +                                       G(NX),
     +                                       HESSEX(NHESS,NHESS),
     +                                       HESSIN(NHESS,NHESS), P(NX), 
     +                                       PAR(NX), PX(NX), RNDOF,
     +                                       S(NP), SIGMA,
     +                                       T(NP), THEORY(NP), TIME,
     +                                       U(NP), V(NP), W(NP), WSSQ,
     +                                       W2(3*NX), X(NX), XVAL(NP),
     +                                       YVAL(NP), ZVAL(NP)  
      CHARACTER (LEN = *), INTENT (IN)    :: FNAME1, FNAME2, MODNAM(4),
     +                                       TITLE    
      CHARACTER (LEN = *), INTENT (INOUT) :: RECORD(NX,NX), SYMBOL(NX) 
      LOGICAL,             INTENT (IN)    :: CONST, DEQN, MULTI1
      LOGICAL,             INTENT (INOUT) :: STATS
      LOGICAL,             INTENT (INOUT) :: EQSAV(NP), EQUAL(NP),
     +                                       FREE(NX)
      LOGICAL,             INTENT (IN)    :: USE_E04JYF, USE_E04KZF,
     +                                       USE_E04UFF
      LOGICAL,             INTENT (IN)    :: USE_D02CJF, USE_D02EJF,
     +                                       USE_JACOBIAN
C
C Locals
C     
      INTEGER    I, IOS, J, K, L, NFIXED, NTEMP
      INTEGER    ICOUNT
      INTEGER    ICOLOR, IXL, IYL
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4)
      INTEGER    COLOUR
      DOUBLE PRECISION T50, T90, T95, T99, TEMP
      DOUBLE PRECISION PNT75, PNT95, PNT975, PNT995, ZERO, ONE
      PARAMETER (PNT75 = 0.75D+00, PNT95 = 0.95D+00, PNT975 = 0.975D+00,
     +           PNT995 = 0.995D+00, ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION G01FBF$
      CHARACTER (LEN = 13) D13(5), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 12) I12(4), FORM12
      CHARACTER (LEN = 9 ) D9(2), SHOW09
      CHARACTER  LINE*120, TEXT(30)*100, WORD6*6, SOLVER*20
      CHARACTER  COPY1*80, COPY2*80, TRIM80*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ISTOP, OK, YES, YES_1, YES_2, YES_3, YES_4, YES_5
      LOGICAL    QNLGLS
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ, SHOWRJ, SHOW09
      EXTERNAL   GOFFIT, VCOVAR, TESTPS, QNGRD1, TABLE1, QNLGLS
      EXTERNAL   PUTIFA, TRIM80
      EXTERNAL   G01FBF$
      EXTERNAL   FUNCT1
      INTRINSIC  ABS, SQRT, DBLE
      SAVE ICOUNT, ISTOP, TEXT
      DATA ICOUNT / 0 /
      E_NUMBERS = E_FORMATS()
      IF (ISEND.EQ.1) THEN
C
C Details of model
C
         ICOUNT = ICOUNT + 1
         ISTOP = .FALSE.
         NFIXED = NDOF - NPTS + NPAR
         COPY1 = TRIM80(FNAME1)
         COPY2 = TRIM80(TITLE)
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100,IOSTAT=IOS)
     +                       COPY1, COPY2, (MODNAM(I), I = 1, 4),
     +                       ICOUNT, NPTS, NPAR, NFIXED, NDOF
            WRITE (NOUT,100,IOSTAT=IOS)
     +                       COPY1, COPY2, (MODNAM(I), I = 1, 4),
     +                       ICOUNT, NPTS, NPAR, NFIXED, NDOF
         ELSE
            I12(1) = FORM12(NPTS)
            I12(2) = FORM12(NPAR)
            I12(3) = FORM12(NFIXED)
            I12(4) = FORM12(NDOF)
            WRITE (TEXT,150,IOSTAT=IOS)
     +                      COPY1, COPY2, (MODNAM(I), I = 1, 4),
     +                       ICOUNT, I12(1), TRIM(I12(2)), TRIM(I12(3)), 
     +                       I12(4)
            WRITE (NOUT,150,IOSTAT=IOS)
     +                       COPY1, COPY2, (MODNAM(I), I = 1, 4),
     +                       ICOUNT, I12(1), TRIM(I12(2)), TRIM(I12(3)), 
     +                       I12(4)                        
         ENDIF  
         CALL GOFFIT (IFAIL, ISEND, ISTATE, MODEL, NDOF, NFILE, NGRAF,
     +                NMOD, NOUT, NP, NPAR, NPTS, NVAR, NX, NZEROS,
     +                BL, BU, EPSI, ERROR, FACT, FVAL, PX, RTOL, S,
     +                SIGMA, T, THEORY, TIME, U, V, W, WSSQ, X, XVAL,
     +                YVAL, ZVAL,
     +                FNAME1, FNAME2, TEXT,
     +                CONST, DEQN, EQSAV, EQUAL, MULTI1, STATS,
     +                USE_E04JYF, USE_E04KZF, USE_E04UFF)
         RETURN
      ELSEIF (ISEND.EQ.2) THEN
C
C Goodness of fit after curve fitting
C
         I = 15
         CALL TABLE1 (I, 'OPEN')
         CALL GOFFIT (IFAIL, ISEND, ISTATE, MODEL, NDOF, NFILE, NGRAF,
     +                NMOD, NOUT, NP, NPAR, NPTS, NVAR, NX, NZEROS,
     +                BL, BU, EPSI, ERROR, FACT, FVAL, PX, RTOL, S,
     +                SIGMA, T, THEORY, TIME, U, V, W, WSSQ, X, XVAL,
     +                YVAL, ZVAL,
     +                FNAME1, FNAME2, TEXT,
     +                CONST, DEQN, EQSAV, EQUAL, MULTI1, STATS,
     +                USE_E04JYF, USE_E04KZF, USE_E04UFF)

         RETURN
      ELSEIF (ISEND.EQ.3) THEN
C
C Dummy entry
C
         RETURN
      ELSEIF (ISEND.EQ.4) THEN
C
C Stop ?
C
         ISTOP = .TRUE.
      ENDIF
C
C Calculate the Variance/Covariance matrix
C
      ISEND = 1
      CALL VCOVAR (INDEX, ISEND, ISTATE, NFREE, NHESS, NOUT, NP, NPAR,
     +             NPTS, NUMPOS, NX, NZEROS,
     +             CORR, CV, DIAGV, EIGVAL, EPSI, ERROR, FACT, FJACC,
     +             FVAL, G, HESSEX, HESSIN, RNDOF, RTOL, SIGMA, THEORY,
     +             W2, X, XVAL, YVAL, ZVAL,
     +             RECORD,
     +             EQUAL, FREE, STATS)
C
C Parameter standard errors
C
      OK = .TRUE.
      DO L = 1, NPAR
         K = 1
         PAR(L) = FACT(L)*X(L)
         P(L) = ONE
         IF (STATS) THEN
            IF (ISTATE(L).GT.0) THEN
               ERR(L) = SQRT(ABS(DIAGV(L)))
               IF (ERR(L).GT.RTOL) THEN
                  P(L) = ABS(PAR(L)/ERR(L))
                  I = 3
                  J = L
                  K = NDOF
                  CALL TESTPS (I, ISTATE(J), J, K,
     +                         BL(J), BU(J), EPSI, PX(J), RTOL, P(J),
     +                         X(J),
     +                         LINE)
                  IF (K.EQ. - 1) THEN
                     IF (OK) THEN
C***                    COLOUR = 15
C***                    CALL TABLE1 (COLOUR, 'OPEN')
                        COLOUR = 0
                        OK = .FALSE.
                     ENDIF
                     CALL TABLE1 (COLOUR, LINE)
                  ENDIF
               ENDIF
            ELSE
               ERR(L) = ZERO
            ENDIF
         ENDIF
         IF (ISTATE(L).EQ.-2) THEN
            SYMBOL(L) = 'lower'
         ELSEIF (ISTATE(L).EQ.-1) THEN
            SYMBOL(L) = 'upper'   
         ELSEIF (ISTATE(L).EQ.0) THEN
            SYMBOL(L) = 'fixed'
         ELSEIF (ISTATE(L).LT.1 .OR. K.EQ. -1 .OR. .NOT.STATS) THEN
            SYMBOL(L) = '*****'
         ELSE
            SYMBOL(L) = '     '
         ENDIF
      ENDDO
C***  IF (.NOT.OK) CALL TABLE1 (COLOUR, 'CLOSE')
      YES = .TRUE.
C
C Output results
C
      NTEMP = 2
      YES = QNLGLS (NTEMP)
      IF (YES) THEN
C***     COLOUR = 15
C***     CALL TABLE1 (COLOUR, 'OPEN')
         COLOUR = 4
         IF (USE_E04JYF) THEN
            WORD6 = 'E04YJF'
         ELSEIF (USE_E04KZF) THEN
            WORD6 = 'E04KZF'
         ELSEIF (USE_E04UFF) THEN
            WORD6 = 'E04UFF'
         ELSE
            WORD6 = 'LBFGSB'
         ENDIF 
         IF (DEQN) THEN
            IF (USE_D02CJF) THEN
               SOLVER = '/D02CJF'
            ELSEIF (USE_D02EJF .AND. USE_JACOBIAN) THEN  
               SOLVER = '/D02EJF/J-explicit'
            ELSEIF (USE_D02EJF .AND. .NOT.USE_JACOBIAN) THEN     
               SOLVER = '/D02EJF/J-estimated'
            ELSE
               SOLVER = '/DVODE'
            ENDIF      
         ELSE
            SOLVER = BLANK
         ENDIF                
         WRITE (TEXT,200,IOSTAT=IOS) ICOUNT, WORD6//SOLVER
         WRITE (NOUT,200,IOSTAT=IOS) ICOUNT, WORD6//SOLVER
         DO I = 1, 2
            CALL TABLE1 (COLOUR, TEXT(I))
         ENDDO
         WRITE (TEXT,300,IOSTAT=IOS)
         WRITE (NOUT,300,IOSTAT=IOS)
         DO I = 1, 2
            CALL TABLE1 (COLOUR, TEXT(I))
         ENDDO
         COLOUR = 0
C
C t values to calculate parameter confidence limits
C
         IF (STATS) THEN
            K = 1
            T50 = G01FBF$('Lower-tail', PNT75, DBLE(NDOF), K)
            CALL PUTIFA (K, NOUT, 'G01FBF/OUTDAT')
            K = 1
            T90 = G01FBF$('lower-tail', PNT95, DBLE(NDOF), K)
            CALL PUTIFA (K, NOUT, 'G01FBF/OUTDAT')
            K = 1
            T95 = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), K)
            CALL PUTIFA (K, NOUT, 'G01FBF/OUTDAT')
            K = 1
            T99 = G01FBF$('Lower-tail', PNT995, DBLE(NDOF), K)
            CALL PUTIFA (K, NOUT, 'G01FBF/OUTDAT')
            DO I = 1, NPAR
               TEMP = FACT(I)*BL(I)
               D9(1) = SHOW09(TEMP)
               TEMP = FACT(I)*BU(I)
               D9(2) = SHOW09(TEMP)
               IF (FREE(I)) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,400,IOSTAT=IOS)
     +                                I, D9(1), D9(2),
     +                                PAR(I), ERR(I), 
     +                                PAR(I) - T95*ERR(I),
     +                                PAR(I) + T95*ERR(I),   
     +                                P(I), SYMBOL(I)
                  ELSE
                     D13(1) = SHOWRJ(PAR(I))
                     D13(2) = SHOWRJ(ERR(I))
                     TEMP = PAR(I) - T95*ERR(I)
                     D13(3) = SHOWRJ(TEMP)
                     TEMP = PAR(I) + T95*ERR(I)
                     D13(4) = SHOWRJ(TEMP)
                     WRITE (LINE,450,IOSTAT=IOS)
     +                                I, D9(1), D9(2),
     +                                D13(1), D13(2), D13(3), D13(4), 
     +                                P(I), SYMBOL(I)
                  ENDIF  
               ELSE
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,400,IOSTAT=IOS)
     +                             I, D9(1), D9(2),
     +                             PAR(I), ZERO, PAR(I), PAR(I), 
     +                             ZERO, SYMBOL(I)         
                  ELSE
                     D13(1) = SHOWRJ(PAR(I))
                     D13(2) = SHOWRJ(ZERO)
                     D13(3) = SHOWRJ(PAR(I))
                     D13(4) = SHOWRJ(PAR(I))
                     D13(5) = SHOWRJ(ZERO)
                     WRITE (LINE,450,IOSTAT=IOS)
     +                                I, D9(1), D9(2),
     +                                D13(1), D13(2), D13(3), D13(4),  
     +                                D13(5), SYMBOL(I)
                  ENDIF
               ENDIF 
               CALL TABLE1 (COLOUR, LINE)
               WRITE (NOUT,'(A)',IOSTAT=IOS) LINE                 
            ENDDO  
         ELSE
            DO I = 1, NPAR 
               TEMP = FACT(I)*BL(I)
               D9(1) = SHOW09(TEMP)
               TEMP = FACT(I)*BU(I)
               D9(2) = SHOW09(TEMP)
               IF (E_NUMBERS) THEN
                  WRITE (LINE,400,IOSTAT=IOS)
     +                             I, D9(1), D9(2),
     +                             PAR(I), ZERO, PAR(I), PAR(I), ZERO,
     +                             SYMBOL(I) 
               ELSE
                  D13(1) = SHOWRJ(PAR(I))
                  D13(2) = SHOWRJ(ZERO)
                  D13(3) = SHOWRJ(PAR(I))
                  D13(4) = SHOWRJ(PAR(I))
                  WRITE (LINE,450,IOSTAT=IOS)
     +                                I, D9(1), D9(2),
     +                                D13(1), D13(2), D13(3), D13(4), 
     +                                ZERO, SYMBOL(I) 
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
               WRITE (NOUT,'(A)',IOSTAT=IOS) LINE                 
            ENDDO   
         ENDIF
         IF (CONST) THEN
C
C Details about the constant term
C
            WRITE (LINE,600,IOSTAT=IOS) NPAR
            WRITE (NOUT,600,IOSTAT=IOS) NPAR
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
         IF (NFIX.EQ.1) THEN
C
C The constant term is fixed
C
            WRITE (LINE,700,IOSTAT=IOS) NPAR + 1
            WRITE (NOUT,700,IOSTAT=IOS) NPAR + 1
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
         IF (STATS) THEN
C
C The t-values
C
            WRITE (TEXT,800,IOSTAT=IOS) T50, T90, T95, T99
            WRITE (NOUT,800,IOSTAT=IOS) T50, T90, T95, T99
            DO I = 1, 2
               CALL TABLE1 (COLOUR, TEXT(I))
            ENDDO
         ENDIF
         CALL TABLE1 (COLOUR, 'CLOSE')
      ENDIF   
      IF (ISTOP) RETURN
C
C Further analysis  ... eigenvalues of Hessian, etc.
C
      ISEND = 2
      CALL VCOVAR (INDEX, ISEND, ISTATE, NFREE, NHESS, NOUT, NP, NPAR,
     +             NPTS, NUMPOS, NX, NZEROS,
     +             CORR, CV, DIAGV, EIGVAL, EPSI, ERROR, FACT, FJACC,
     +             FVAL, G, HESSEX, HESSIN, RNDOF, RTOL, SIGMA, THEORY,
     +             W2, X, XVAL, YVAL, ZVAL,
     +             RECORD,
     +             EQUAL, FREE, STATS)        
C
C Further analysis ... plots, etc.
C
      ISEND = 3
      CALL GOFFIT (IFAIL, ISEND, ISTATE, MODEL, NDOF, NFILE, NGRAF,
     +             NMOD, NOUT, NP, NPAR, NPTS, NVAR, NX, NZEROS,
     +             BL, BU, EPSI, ERROR, FACT, FVAL, PX, RTOL, S, SIGMA,
     +             T, THEORY, TIME, U, V, W, WSSQ, X, XVAL, YVAL, ZVAL,
     +             FNAME1, FNAME2, TEXT,
     +             CONST, DEQN, EQSAV, EQUAL, MULTI1, STATS,
     +             USE_E04JYF, USE_E04KZF, USE_E04UFF)
     
C
C Further analysis of residuals
C
      NTEMP = 6
      YES_1 = QNLGLS (NTEMP)
      NTEMP = 7
      YES_2 = QNLGLS (NTEMP)
      NTEMP = 8
      YES_3 = QNLGLS (NTEMP)
      NTEMP = 9
      YES_4 = QNLGLS (NTEMP)
      NTEMP = 10
      YES_5 = QNLGLS (NTEMP)
      IF (YES_1 .OR. YES_2 .OR. YES_3 .OR. YES_4 .OR. YES_5) THEN
         ISEND = 4
         CALL GOFFIT (IFAIL, ISEND, ISTATE, MODEL, NDOF, NFILE, NGRAF,
     +                NMOD, NOUT, NP, NPAR, NPTS, NVAR, NX, NZEROS,
     +                BL, BU, EPSI, ERROR, FACT, FVAL, PX, RTOL, S,
     +                SIGMA, T, THEORY, TIME, U, V, W, WSSQ, X, XVAL,
     +                YVAL, ZVAL,
     +                FNAME1, FNAME2, TEXT,
     +                CONST, DEQN, EQSAV, EQUAL, MULTI1, STATS,
     +                USE_E04JYF, USE_E04KZF, USE_E04UFF)
     
      ENDIF
C
C Format statements
C
  100 FORMAT (/1X,'Current file'/1X,A/1X,'Current data'/1X,A
     +/1X,'Current model'/1X,A/1X,A/1X,A/1X,A/
     +/1X,'Results from curve-fit number',I3
     +/
     +/1X,'Number of data points =',I6
     +/1X,'Number of parameters  =',I6,1X,
     +'(',I3,' currently fixed)'
     +/1X,'Degrees of freedom    =',I6)
  150 FORMAT (/1X,'Current file'/1X,A/1X,'Current data'/1X,A
     +/1X,'Current model'/1X,A/1X,A/1X,A/1X,A/
     +/1X,'Results from curve-fit number',I3
     +/
     +/1X,'Number of data points =',1X,A
     +/1X,'Number of parameters  =',1X,A,6X,
     +'(',A,1X,' currently fixed)'
     +/1X,'Degrees of freedom    =',1X,A)     
  200 FORMAT (
     +/1X,'Best-fit parameters for curve-fit',I3,1X,'using',1X,A)
  300 FORMAT (/'Number  Low-Limit High-Limit         Value',
     +'     Std.Error    Lower95%cl    Upper95%cl    p')    
  400 FORMAT (I6,2(2X,A9),4(1X,E13.5),0P,F8.4,A) 
  450 FORMAT (I6,2(2X,A9),4(1X,A13),F8.4,A) 
C  500 FORMAT (I3,1P,2E11.3,E13.5,45X,A)     
  600 FORMAT (5X,'parameter(',I2,') is the optional constant term')
  700 FORMAT (5X,'parameter(',I2,') is the excluded constant term')
  800 FORMAT (
     +1X,'For 50,90,95,99% con. lim. use [parameter value +/-',
     +' t(alpha/2)*std.err.]'
     +/1X,'t(.25) =',F6.3,', t(.05) =',F6.3,', t(.025) =',F6.3,
     +', t(.005) =',F6.3)
      END
C
C
