C
C
C QNFIT03.INS
C ===========
C These subroutines do not include MODULE_QNFIT except for QNCFIG
C
C This file contains:- subroutine ... PARAIN
C                      subroutine ... PSCALE
C                      subroutine ... QNCFIG uses MODULE_QNFIT
C                      subroutine ... QNEDIT
C
C----------------------------------------------------------------------
C
C
C original menu
c 1     + 'Proceed to curve-fitting',2X,A
c 2    +/'Unconstrained (not recommended)'
c 3    +/'Positive (not recommended)'
c 4    +/'Set all parameters/limits individually'
c 5    +/'Change some parameter/limits individually'
c 6    +/'Read parameters from data file (EXPERT mode)',1X,A
c 7    +/'Read parameters from a parameter/limits file'
c 8    +/'Write parameters to a parameter/limits file'
c 9    +/'Install a library parameter/limits file'
c 10    +/'Access a library parameter/limits file'
c 11   +/'Edit parameters/limits interactively'
c 12    +/'Display current parameters,limits,types',2X,A
c 13    +/'Overlay data and starting-estimate-curve'
c 14    +/'Help'
c  15   +/'Cancel')
c
c 04/05/2020 edited to remove the original options 4 and 5 an replace them by 11 then delete 11
c After testing the commented out code can safely be removed
c
C
C----------------------------------------------------------------------
C
      SUBROUTINE PARAIN (ISTART, ISTATE, NFREE, NPAR, NPAR1, NPMAX, 
     +                   NSMALL, NVAR, NX,
     +                   AMULT, BL, BL1, BL2, BU, BU1, BU2, EPSI, FACT,
     +                   RTOL,  PX, X, X1,
     +                   FSMALL, MODNAM, TSMALL,
     +                   ABORT, DEQN, EXPERT, M1DATA)
C
C ACTION : Set parameters and limits used in model
C          18/11/2009 extensive editing
C
C          ISTATE : 0 = FIXED
C                   1 = CONSTRAINED
C                   2 = POSITIVE
C                   3 = UNCONSTRAINED
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NPAR, NPMAX, NSMALL, NVAR,
     +                                       NX       
      INTEGER,             INTENT (INOUT) :: ISTATE(NX)
      INTEGER,             INTENT (INOUT) :: ISTART(NX)
      INTEGER,             INTENT (INOUT) :: NFREE, NPAR1
      DOUBLE PRECISION,    INTENT (IN)    :: EPSI, RTOL
      DOUBLE PRECISION,    INTENT (INOUT) :: AMULT(NPMAX), BL(NX),
     +                                       BU(NX), FACT(NX), PX(NX)
      DOUBLE PRECISION,    INTENT (INOUT) :: BL2(NX), BU2(NX), X(NX)
      DOUBLE PRECISION,    INTENT (INOUT) :: BL1(NX), BU1(NX), X1(NX) 
      CHARACTER (LEN = *), INTENT (IN)    :: MODNAM(24)     
      CHARACTER (LEN = *), INTENT (INOUT) :: FSMALL(NSMALL),
     +                                       TSMALL(NSMALL)
      LOGICAL,             INTENT (IN)    :: DEQN, EXPERT, M1DATA
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    NDEC, NREADY, NSET
      INTEGER    I, J, JSEND, K, L
      INTEGER    IX, IY, N1, N14
      PARAMETER (IX = 4, IY = 4, N1 = 1, N14 = 14)
      INTEGER    COLOUR
      INTEGER    ICOLOR, LSHADE, NUMOPT, NSTART, NTEXT
      INTEGER    NUMBLD(30), NUMPOS(20)
      INTEGER    NIN
      DOUBLE PRECISION ONE, TEN
      PARAMETER (ONE = 1.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION XBIG, XLIT, XTINY
      PARAMETER (XBIG = 1.0D+04, XLIT = - XBIG, XTINY = 1.0D-10)
      DOUBLE PRECISION T
      CHARACTER (LEN = 13) D13(3), SHOWRJ
      CHARACTER (LEN = 12) I12(3), FORM12 
      CHARACTER  MODE(3)*15, TYPE1(7)*15
      CHARACTER  TEMP(30)*100
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    OK, YES
      LOGICAL    BORDER, FRAME, FLASH, HIGH
      LOGICAL    QNLGLS
      PARAMETER (BORDER = .FALSE., FRAME = .TRUE., FLASH = .FALSE.,
     +           HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWRJ
      EXTERNAL   TESTPS, LBOX01, 
     +           TABLE1, TABLE3, GETNOU, PUTADV, PUTWAR,
     +           LMHEDI, PARLIM, QNLGLS, QNPLOT, MULT1D
      INTRINSIC  ABS, MAX, DBLE
      SAVE       NREADY
      DATA NREADY / 0 /
      DATA TYPE1  / '          fixed',
     +              '    constrained',
     +              '       positive',
     +              '  unconstrained',
     +              '  not available',
     +              ' ',
     +              '*** recommended' /
      DATA NUMBLD / 30*0 /
      DATA NUMPOS / 20*1 /
      E_NUMBERS = E_FORMATS()
C
C Start parameter initialisation
C
      ABORT = .FALSE.
      MODE(1) = TYPE1(5)
      MODE(2) = TYPE1(5)
      MODE(3) = TYPE1(5)
      IF (EXPERT) MODE(2) = TYPE1(7)
C
C Restore parameter limits in case a re-fit is required
C
      DO I = 1, NREADY
         BL(I) = BL2(I)
         BU(I) = BU2(I)
         ISTATE(I) = ISTART(I)
         PX(I) = FACT(I)*X(I)
         FACT(I) = ONE
         X(I) = PX(I)
      ENDDO
C
C Safeguard parameters outside the stored range
C
      DO I = NREADY + 1, NX
         ISTATE(I) = 3
         ISTART(I) = ISTATE(I)
         BL(I) = XLIT
         BU(I) = XBIG
         FACT(I) = ONE
         PX(I) = FACT(I)
         X(I) = PX(I)
      ENDDO
C
C Set flag for first option menu
C
      IF (EXPERT) THEN
         NDEC = 5
      ELSE
         NDEC = 4
      ENDIF
C
C Label 20: Main pivot point in subroutine ... Return here after each action
C =========
C
   20 CONTINUE
      ABORT = .FALSE.
      IF (NREADY.LT.NPAR) THEN
         IF (E_NUMBERS) THEN
            WRITE (TEMP,100) NREADY, NPAR, NPAR
         ELSE
            I12(1) = FORM12(NREADY)
            I12(2) = FORM12(NPAR)
            WRITE (TEMP,150) I12(1), I12(2), TRIM(I12(2)) 
         ENDIF  
         DO I = 1, 5
            TEXT(I) = TEMP(I)
         ENDDO
         IF (EXPERT) THEN
            NDEC = 5
         ELSE
            NDEC = 4
         ENDIF
      ELSE
         MODE(1) = TYPE1(6)
         MODE(3) = TYPE1(6)
         DO I = 1, 5
            TEXT(I) = BLANK
         ENDDO
      ENDIF
      WRITE (TEMP,200) (MODNAM(I), I = 1, 4)
      DO I = 1, 6
         TEXT(I + 5) = TEMP(I)
      ENDDO
      TEXT(12) = BLANK
      WRITE (TEMP,300) (MODE(I), I = 1, 3)
      DO I = 1, 13
         TEXT(I + 12) = TEMP(I)
      ENDDO
      ICOLOR = 9
      LSHADE = 1
      NUMBLD(4) = 1
      NUMBLD(5) = 1
      NUMBLD(7) = 1
      NUMOPT = 13
      NSTART = 13
      NTEXT = NUMOPT + NSTART - 1
C      M = NDEC
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NUMBLD(4) = 0
      NUMBLD(5) = 0
      NUMBLD(7) = 0
C
C Label 40: Entry point by-passing the menu ... NDEC must be set previously
C =========
C
   40 CONTINUE
      IF (NDEC.EQ.1) THEN
C
C Parameters are now set but first check if all are ready
C
         IF (NREADY.LT.NPAR) THEN
            NDEC = 4
            GOTO 20  
         ENDIF  
      ELSEIF (NDEC.EQ.2) THEN
C
C Unconstrained parameters
C
         IF (DEQN) CALL PUTWAR (
     +'This option is unlikely to succeed with differential eqns.')
         CALL PUTADV (
     +'This is a poor choice ... better to use a parameter/limits file')
         DO I = 1, NPAR
            ISTATE(I) = 3
            ISTART(I) = ISTATE(I)
            BL(I) = XLIT
            BU(I) = XBIG
            FACT(I) = ONE
            PX(I) = ONE + DBLE(I - N1)/TEN
            X(I)  = PX(I)
         ENDDO
         NREADY = NPAR
         NDEC = 12
         GOTO 20
      ELSEIF (NDEC.EQ.3) THEN
C
C Positive parameters
C
         IF (DEQN) CALL PUTWAR (
     +'This option is unlikely to succeed with differential eqns.')
         CALL PUTADV (
     +'This is a poor choice ... better to use a parameter/limits file')
         DO I = 1, NPAR
            ISTATE(I) = 2
            ISTART(I) = ISTATE(I)
            BL(I) = XTINY
            BU(I) = XBIG
            FACT(I) = ONE
            PX(I) = ONE + DBLE(I - N1)/TEN
            X(I)  = PX(I)
         ENDDO
         NREADY = NPAR
         NDEC = 12
         GOTO 20
      ELSEIF (NDEC.EQ.4) THEN
C
C Edit existing parameters
C
         NREADY = NPAR
         CALL LMHEDI (NREADY, 
     +                BL, PX, BU)
         OK = .TRUE.
         I = 1
         DO WHILE (OK .AND. I.LE.NREADY)
            IF (BL(I).GT.PX(I) .OR. PX(I).GT.BU(I)) THEN
               OK = .FALSE.
               WRITE (LINE,900) I
               CALL PUTADV (LINE)
            ELSE
               X(I) = PX(I)
               FACT(I) = ONE
C
C Re-define ISTATE
C
               IF (ABS(BU(I) - BL(I)).LE.RTOL) THEN
                  ISTATE(I) = 0
               ELSEIF (ABS(BU(I) - XBIG).LE.RTOL) THEN
                  IF (ABS(BL(I) - XTINY).LE.RTOL) THEN
                     ISTATE(I) = 2
                  ELSEIF (ABS(BL(I) - XLIT).LE.RTOL) THEN
                     ISTATE(I) = 3
                  ELSE
                     ISTATE(I) = 1
                  ENDIF
               ELSE
                  ISTATE(I) = 1
               ENDIF
               ISTART(I) = ISTATE(I)
            ENDIF
            I = I + 1
         ENDDO
         NDEC = 10
         GOTO 20     

      ELSEIF (NDEC.EQ.5) THEN
C
C Read parameters from EXPERT mode input file
C
         IF (.NOT.EXPERT) THEN
            NDEC = 4
            CALL PUTADV ('Option 5 only available in EXPERT mode')
            GOTO 20
         ENDIF
         YES = QNLGLS (N14)
         OK = .TRUE.
         DO L = 1, NPAR1
            BL(L) = BL1(L)
            BU(L) = BU1(L)
            FACT(L) = ONE
            PX(L) = X1(L)
            X(L)  = PX(L)
            I = 1
            J = L
            K = 1
            T = XBIG
            CALL TESTPS (I, ISTATE(J), J, K,
     +                   BL(J), BU(J), EPSI, PX(J), RTOL, T, X(J),
     +                   LINE)
            ISTART(L) = ISTATE(L)
            IF (YES) THEN
               IF (K.EQ. -1) THEN
                  IF (OK) THEN
                     COLOUR = 15
                     CALL TABLE1 (COLOUR, 'OPEN')
                     COLOUR = 0
                     OK = .FALSE.
                  ENDIF
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
            ENDIF
         ENDDO
         IF (YES .AND. .NOT.OK) CALL TABLE1 (COLOUR, 'CLOSE')
         MODE(2) = TYPE1(6)
         IF (NPAR1.LT.NPAR) THEN
            NREADY = NPAR1
            NDEC = 4
            GOTO 40
         ELSE
            NREADY = NPAR
            NDEC = 10
            GOTO 20
         ENDIF
      ELSEIF (NDEC.GE.6 .AND. NDEC.LE.9) THEN
C
C Read/write parameters and limits to/from a parameter file
C
         JSEND = NDEC - 5
         CALL GETNOU (NIN)
         CLOSE (UNIT = NIN)
         CALL PARLIM (JSEND, NIN, NPAR, NSET, NSMALL, NX,
     +                BL, BU, PX, 
     +                FSMALL, TSMALL,
     +                ABORT)
         CLOSE (UNIT = NIN)
         IF (.NOT.ABORT .AND. NSET.GT.0) THEN
            DO I = 1, NSET
               X(I) = PX(I)
               FACT(I) = ONE
               IF (ABS(BU(I) - BL(I)).LE.RTOL) THEN
                  ISTATE(I) = 0
               ELSE
                  ISTATE(I) = 1
               ENDIF
               ISTART(I) = ISTATE(I)
            ENDDO
            NREADY = MAX(NREADY,NSET)
            IF (NSET.GE.NPAR) THEN
               CALL PUTADV ('All parameters have been re-set')
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (LINE,800) NPAR, NSET
               ELSE
                  I12(1) = FORM12(NPAR)
                  I12(2) = FORM12(NSET)
                  WRITE (LINE,850) TRIM(I12(1)), I12(2) 
               ENDIF  
               CALL PUTADV (LINE)
            ENDIF
         ENDIF
         NDEC = 10
         GOTO 20
      ELSEIF (NDEC.EQ.10) THEN
C
C Display current parameters
C
         IF (NREADY.LT.NPAR) GOTO 20
         WRITE (TEMP,1000)
         IF (E_NUMBERS) THEN
            WRITE (TEXT,1100) (I, BL(I), PX(I), BU(I),
     +                         TYPE1(ISTATE(I) + 1), I = 1, NPAR)
         ELSE
            DO I = 1, NPAR
               D13(1) = SHOWRJ(BL(I))
               D13(2) = SHOWRJ(PX(I))
               D13(3) = SHOWRJ(BU(I)) 
               WRITE (TEXT(I),1150) I, D13(1), D13(2), D13(3),
     +                              TYPE1(ISTATE(I) + 1)
            ENDDO 
         ENDIF  
         ICOLOR = 7
         NTEXT = NPAR
         I = 1
         CALL TABLE3 (ICOLOR, NTEXT, I, TEXT, TEMP, FRAME)
         IF (NVAR.GT.1 .OR. M1DATA) THEN
            NDEC = 1
         ELSE   
            NDEC = 11
         ENDIF   
         GOTO 20
      ELSEIF (NDEC.EQ.11) THEN 
C
C Plot
C        
         IF (NREADY.LT.NPAR) GOTO 20
         IF (M1DATA) THEN 
C
C Define AMULT to plot multi-function data
C           
            DO I = 1, NPAR
               AMULT(I) = FACT(I)*X(I)
            ENDDO    
            CALL MULT1D           
         ELSE
            CALL QNPLOT
         ENDIF   
         NDEC = 1
         GOTO 20           
      ELSEIF (NDEC.EQ.12) THEN
C
C Help
C      
         JSEND = 5
         CALL PARLIM (JSEND, NIN, NPAR, NSET, NSMALL, NX,
     +                BL, BU, PX, 
     +                FSMALL, TSMALL,
     +                ABORT)
         NDEC = 10
         GOTO 20
      ELSEIF (NDEC.EQ.NUMOPT) THEN
C
C Cancel parameter menu
C
         ABORT = .TRUE.
      ENDIF
C
C Back to main program after seting NFREE and NREADY and saving BL and BU
C
      NFREE = 0
      DO I = 1, NPAR
         IF (ISTATE(I).GT.0) NFREE = NFREE + 1
      ENDDO
      NREADY = NPAR
      DO I = 1, NREADY
         BL2(I) = BL(I)
         BU2(I) = BU(I)
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Information'
     +/'Number of parameters initialised =',I3
     +/'Number of parameters in model =',I3
     +/'Edit the default parameters or choose another'
     +/'method to initialise the',I4,1X,'parameters')
  150 FORMAT (
     + 'Information'
     +/'Number of parameters initialised =',1X,A
     +/'Number of parameters in model =',1X,A
     +/'Edit the default parameters or choose another'
     +/'method to initialise the',1X,A,1X,'parameters')     
  200 FORMAT (
     +/'Current model'/A/A/A/A)
  300 FORMAT (
     + 'Proceed to curve-fitting',2X,A
     +/'Unconstrained (not recommended)'
     +/'Positive (not recommended)'
     +/'Edit parameters/limits interactively'
     +/'Read parameters from the data file (EXPERT mode)',1X,A
     +/'Read parameters from a parameter/limits file'
     +/'Write parameters to a parameter/limits file'
     +/'Install a library parameter/limits file'
     +/'Access a library parameter/limits file'
     +/'Display current parameters,limits,types',2X,A
     +/'Overlay data and starting-estimate-curve'
     +/'Help'
     +/'Quit ... Exit these options')
  800 FORMAT ('Number of parameters in model =',I4,', Number re-set =',
     +I4)
  850 FORMAT ('Number of parameters in model =',1X,A,1X,
     +', Number re-set =',1X,A)     
  900 FORMAT ('Parameter/limits incorrect ... Edit rejected at line',I4)
 1000 FORMAT ('Parameter',3X,'Lower-limit',5X,'Start-value',5X,
     +'Upper-limit',14X,'Type')
 1100 FORMAT (4X,I2,1P,3(E15.3),3X,A)
 1150 FORMAT (4X,I2,1X,3(3X,A13),3X,A)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE PSCALE (ISTATE, NPAR,
     +                   BL, BU, EPSI, FACT, PX, X)
C
C action: Scale parameters and limits
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NPAR
      INTEGER,          INTENT (IN)    :: ISTATE(NPAR)
      DOUBLE PRECISION, INTENT (IN)    :: EPSI
      DOUBLE PRECISION, INTENT (INOUT) :: BL(NPAR), BU(NPAR),
     +                                    FACT(NPAR), PX(NPAR),
     +                                    X(NPAR)
C
C Locals
C     
      INTEGER    I
      DOUBLE PRECISION ONE, XMAX
      PARAMETER (ONE = 1.0D+00, XMAX = 1.0D+08)
      DOUBLE PRECISION ABSMAX, ABSXI, FRACN
      CHARACTER  LINE*100
      EXTERNAL   PUTWAR
      INTRINSIC  ABS, SIGN, MAX
      DO I = 1, NPAR
         IF (ISTATE(I).GT.0) THEN
            ABSXI = ABS(X(I))
            IF (ABSXI.GT.EPSI) THEN
               FACT(I) = ABSXI
               BL(I) = BL(I)/ABSXI
               BU(I) = BU(I)/ABSXI
               IF (ISTATE(I).EQ.1) THEN
                  PX(I) = SIGN(ONE, X(I))
                  ABSMAX = MAX(ABS(BL(I)),ABS(BU(I)))
                  IF (ABSMAX.GT.XMAX) THEN
                     WRITE (LINE,100) I
                     CALL PUTWAR (LINE)
                     FRACN = XMAX/ABSMAX
                     BL(I) = BL(I)*FRACN
                     BU(I) = BU(I)*FRACN
                     FACT(I) = FACT(I)/FRACN
                     PX(I) = PX(I)*FRACN
                  ENDIF
               ELSEIF (ISTATE(I).EQ.2) THEN
                 PX(I) = ONE
               ELSE
                 PX(I) = SIGN(ONE, X(I))
               ENDIF
            ENDIF
            X(I) = PX(I)
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT ('Limits too wide to scale parameter',I3)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE QNCFIG (IRELAB, METH, MITER,
     +                   DTOL, D02TOL, 
     +                   OTYPE, RELABS,
     +                   USE_D02CJF, USE_D02EJF,
     +                   USE_E04JYF, USE_E04KZF, USE_E04UFF,
     +                   USE_JACOBIAN)

C
C ACTION : Configure QNFIT
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 11/10/97
C          23/11/2009 extensive revision 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (INOUT) :: IRELAB, METH, MITER
      DOUBLE PRECISION,    INTENT (INOUT) :: DTOL, D02TOL
      CHARACTER (LEN = *), INTENT (INOUT) :: OTYPE, RELABS
      LOGICAL,             INTENT (INOUT) :: USE_E04JYF, USE_E04KZF,
     +                                       USE_E04UFF  
      LOGICAL,             INTENT (INOUT) :: USE_D02CJF, USE_D02EJF,
     +                                       USE_JACOBIAN  
C
C Locals
C
      INTEGER    ISEND, N
      PARAMETER (ISEND = 0, N = 1)      
      INTEGER    ICOLOR, IX, IY, LSHADE, NSTART, NUMDEC, NUMOPT, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1)
      INTEGER    I, NUMBLD(20), NUMPOS(10)
      INTEGER    MARK
      DOUBLE PRECISION X1, X2, Y(N)
      PARAMETER (X1 = 0.0D+00, X2 = 1.0D+00)
      DOUBLE PRECISION DMAX, DMIN
      PARAMETER (DMAX = 1.0D-01, DMIN = 1.0D-08)
      CHARACTER  TEXT(30)*100, ODE*60, PREC*80
      CHARACTER  NAG*5, OPTIMISER*6, SOLVER*60, ETYPE*10
      LOGICAL    OK, REPEET
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   D02SOL
      EXTERNAL   LBOX01, GETDM1, DLLNAG, PUTADV
      DATA       NUMBLD /20*0 /
      DATA       NUMPOS / 10*1 /
C
C Check for NAG library
C      
      CALL DLLNAG (MARK,
     +             OK)
      IF (MARK.GE.20 .AND. OK) THEN
         NAG = '     '
      ELSE
         NAG = '[NAG]'  
         USE_D02CJF = .FALSE.
         USE_D02EJF = .FALSE. 
         USE_E04JYF = .FALSE.
         USE_E04KZF = .FALSE.
         USE_JACOBIAN = .TRUE.
      ENDIF   
C
C Main branch point .. return here after each decision
C 
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
        
         IF (RELABS.EQ.'M') THEN
            ETYPE = 'Mixed'
         ELSEIF (RELABS.EQ.'A') THEN
            ETYPE = 'Absolute'   
         ELSEIF (RELABS.EQ.'R') THEN
            ETYPE = 'Relative'
         ELSE
            ETYPE = 'Default'
         ENDIF      
    
         IF (METH.EQ.1)  THEN
            ODE = 'Adams method with no Jacobian'
         ELSEIF (METH.EQ.2) THEN
            IF (MITER.EQ.1) THEN
               ODE = 'BDF with analytic Jacobian'
            ELSEIF (MITER.EQ.2) THEN
               ODE = 'BDF with estimated Jacobian'
            ELSE
               ODE = 'Invalid value for MITER in QNCFIG'
            ENDIF
         ELSE
            ODE = 'Invalid value for METH in QNCFIG'
         ENDIF
         
         IF (IRELAB.EQ.0) THEN
            PREC = 'mixed error test'
         ELSEIF (IRELAB.EQ.1) THEN
            PREC = 'absolute error test'
         ELSEIF (IRELAB.EQ.2) THEN
            PREC = 'relative error test'
         ELSE
            PREC = 'Invalid value for IRELAB in QNCFIG'
         ENDIF
         
         IF (USE_E04JYF) THEN
            OPTIMISER = 'E04JYF'
         ELSEIF (USE_E04KZF) THEN
            OPTIMISER = 'E04KZF' 
         ELSEIF (USE_E04UFF) THEN
            OPTIMISER = 'E04UFF'     
         ELSE
            OPTIMISER = 'LBFGSB'   
         ENDIF

         IF (USE_D02CJF) THEN
            SOLVER = 'D02CJF'
         ELSEIF (USE_D02EJF .AND. USE_JACOBIAN) THEN
            SOLVER = 'D02EJF with explicit Jacobian'
         ELSEIF (USE_D02EJF .AND. .NOT.USE_JACOBIAN) THEN
            SOLVER = 'D02EJF with estimated Jacobian'
         ELSE   
           SOLVER = 'DVODE'    
         ENDIF
                  
         WRITE (TEXT,100) OTYPE, ODE, PREC, DTOL, D02TOL, ETYPE, 
     +                    OPTIMISER, SOLVER, NAG, NAG
         IF (MARK.GE.20 .AND. OK) THEN
C
C Full menu of all 18 items
C           
            NUMOPT = 7
            NSTART = 12
            NTEXT =  NUMOPT + NSTART - 1
         ELSE
C
C Suppress 6 NAG specific items
C           
            NUMOPT = 5
            NSTART = 8
            NTEXT = 0
            DO I = 1, 18
               IF (I.GE.7.AND.I.LE.10 .OR.
     +             I.GE.16.AND.I.LE.17) THEN
                   CONTINUE
               ELSE
                  NTEXT = NTEXT + 1
                  TEXT(NTEXT) = TEXT(I)
               ENDIF                         
            ENDDO   
         ENDIF     
         NUMDEC = NUMOPT
         NUMBLD(1) = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         IF (NUMDEC.EQ.1) THEN
C
C LBFGS precision
C        
            WRITE (TEXT,200)
            NUMOPT = 3
            NSTART = 9
            NTEXT = NUMOPT + NSTART - 1
            NUMDEC = 2
            NUMBLD(1) = 1
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                   NUMPOS, NSTART, NTEXT, 
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            NUMBLD(1) = 0
            IF (NUMDEC.EQ.1) THEN
               OTYPE = 'low'
            ELSEIF (NUMDEC.EQ.2) THEN
               OTYPE = 'medium'
            ELSE
               OTYPE = 'high'
            ENDIF
         ELSEIF (NUMDEC.EQ.2) THEN
C
C DVODE method
C      
            WRITE (TEXT,300)
            NUMOPT = 3
            NSTART = 9
            NTEXT = NUMOPT + NSTART - 1
            NUMDEC = 2
            NUMBLD(1) = 1
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                   NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            NUMBLD(1) = 1
            IF (NUMDEC.EQ.1) THEN
               METH = 1
               MITER = 0
            ELSEIF (NUMDEC.EQ.2) THEN
               METH = 2
               MITER = 1
            ELSE
               METH = 2
               MITER = 2
            ENDIF
         ELSEIF (NUMDEC.EQ.3) THEN
C
C DVODE Jacobian
C            
            WRITE (TEXT,400)
            NUMOPT = 3
            NSTART = 9
            NTEXT = NUMOPT + NSTART - 1
            NUMDEC = 1
            NUMBLD(1) = 1
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                   NUMPOS, NSTART, NTEXT, 
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            NUMBLD(1) = 0
            IRELAB = NUMDEC - 1
         ELSEIF (NUMDEC.EQ.4) THEN
C
C DVODE TOL
C      
            CALL GETDM1 (DMIN, DTOL, DMAX,
     +'TOL value required (usually between 1.0E-6 and 1.0E-2)')
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C
C Optimiser method
C      
            IF (MARK.GE.20 .AND. OK) THEN
               WRITE (TEXT,500)
               NUMOPT = 4
               NSTART = 8
               NTEXT = NUMOPT + NSTART - 1
               NUMDEC = 1
               NUMBLD(1) = 1 
               CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC,
     +                      NUMOPT, NUMPOS, NSTART, NTEXT, 
     +                      TEXT,
     +                      BORDER, FLASH, HIGH)
               NUMBLD(1) = 0
               USE_E04JYF = .FALSE.
               USE_E04KZF = .FALSE.
               USE_E04UFF = .FALSE.
               IF (NUMDEC.EQ.2) THEN
                  USE_E04JYF = .TRUE.
               ELSEIF (NUMDEC.EQ.3) THEN
                  USE_E04KZF = .TRUE.
               ELSEIF (NUMDEC.EQ.4) THEN
                  USE_E04UFF = .TRUE.    
               ENDIF      
            ELSE
               CALL PUTADV ('No valid NAG library DLLs')
            ENDIF 
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C ODE solver
C           
         
            IF (MARK.GE.20 .AND. OK) THEN
                CALL D02SOL (ISEND, N, 
     +                       D02TOL, X1, X2, Y,
     +                       RELABS,
     +                       USE_D02CJF, USE_D02EJF,
     +                       USE_JACOBIAN)                
            ELSE  
               CALL PUTADV ('No valid NAG library DLLs')
            ENDIF
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            REPEET = .FALSE.   
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'QNFIT optimiser and ODE solver parameters'
     +/
     +/'LBFGS optimiser precision:',1X,A
     +/'DVODE solver type:',1X,A
     +/'DVODE solver test:',1X,A
     +/'DVODE RTOL value:',1P,E10.3
     +/'D02CJF/EJF TOL value:',E10.3
     +/'D02CJF/EJF solver test:',1X,A
     +/'Current optimiser:',1X,A
     +/'Current ODE solver:',1X,A 
     +/
     +/'Change LBFGS optimiser precision'
     +/'Change DVODE solver type'
     +/'Change DVODE solver test'
     +/'Change DVODE TOL value'
     +/'Change optimiser',1X,A
     +/'Change ODE solver',1X,A    
     +/'Apply')
  200 FORMAT (
     + 'Setting the optimiser precision'
     +/
     +/'With very large or noisy data sets or ill-fitting models'
     +/'you might try low precision to accelerate convergence.'
     +/'High precision is for very accurate data with well fitting'
     +/'models. It may be no better than medium precision and may'
     +/'even lead to slow fitting and convergence problems.'
     +/
     +/'Low optimiser precision'
     +/'Medium optimiser precision'
     +/'High optimiser precision')
  300 FORMAT (
     + 'Choosing the ODE solver type'
     +/
     +/'The Adams method works well with most single equations, but'
     +/'occasionally the solution has different time phases when a'
     +/'BDF method will work better. If an estimated Jacobian works'
     +/'better than an analytic one there is an error in the analytic'
     +/'Jacobian. Investigate to find the best technique.'
     +/
     +/'Adams method with no Jacobian'
     +/'BDF with analytic Jacobian'
     +/'BDF with estimated Jacobian')
  400 FORMAT (
     + 'Choosing the ODE solver test parameter'
     +/
     +/'It is generally best to use a mixed error test when fitting'
     +/'differential equations. An absolute test can be used if the'
     +/'number of correct decimal places is important, or a relative'
     +/'test can be used if the number of significant digits is the'
     +/'main concern. Investigate to find the best technique.'
     +/
     +/'Mixed error test'
     +/'Absolute error test'
     +/'Relative error test')
  500 FORMAT (
     + 'Choosing the optimiser type'
     +/
     +/'The quasi-Newton optimiser LBFGSB should work well in most'
     +/'situations but, if you have the NAG library and convergence'
     +/'to a well defined minimum is not happening, you may wish to'
     +/'use one of the NAG E04 optimisers.'
     +/ 
     +/'LBFGSB ... default quasi-Newton method'    
     +/'E04JYF ... NAG quasi-Newton method'
     +/'E04KZF ... NAG modified Newton method'
     +/'E04UFF ... NAG sequential quadratic programmming')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE QNEDIT (NOUT,
     +                   FNAME1, TITLE, 
     +                   ABORT, CHKDAT, DEQN, NEWFIL)
C
C ACTION : Edit data files for QNFIT
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 22/3/98
C          15/12/2002 added call to EDFLXX
C          23/10/2016 extensive editing 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NOUT
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME1, TITLE
      LOGICAL,             INTENT (OUT)   :: ABORT, NEWFIL
      LOGICAL,             INTENT (IN)    :: CHKDAT, DEQN
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           N1, N2, N3, N4, N5, N6, N7, N20
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1,
     +           N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6, N7 = 7,
     +           N20 = 20)
      INTEGER    ISEND, ITYPE, NIN1, NOUT1
      PARAMETER (ISEND = 1)
      INTEGER    NUMBLD(N20), NUMPOS(N7)
      INTEGER    IOS, NTEXT
      INTEGER    ERROR_CODE
      CHARACTER (LEN = 1024) FILE, FILE1, FNAME(2)
      CHARACTER (LEN = 100 ) TEXT(30)
      CHARACTER (LEN = 80  ) CHOP80, TRIM80
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    ASKIF, EDIT, THERE
      PARAMETER (ASKIF = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01, VIEWER, LCASE1, EDFLXX, PUTADV, OFILES,
     +           DELEET, GETNOU, GETTMP, REVPRO, TRIM80, CHOP80
      EXTERNAL   RENAME
      DATA       NUMBLD / N20*0 /
      DATA       NUMPOS / N7*1 /
C
C Label 20: Main branch point
C =========
C
      EDIT = .FALSE.
   20 CONTINUE
      ABORT = .FALSE.
      NEWFIL = .FALSE.
C 1...
      NTEXT = N1
      TEXT(NTEXT) = 'Choose the next action required'
      NUMBLD(NTEXT) = N4
      
      NTEXT = NTEXT + N1
      TEXT(NTEXT) = BLANK
      
      NTEXT = NTEXT + N1 
      IF (EDIT) THEN
         TEXT(NTEXT) = 'Current edited data are contained in the file:'
      ELSE
         TEXT(NTEXT) = 'Current input data are contained in the file:'
      ENDIF
C 2...
      NTEXT = NTEXT + N1
      TEXT(NTEXT) = TRIM80(FNAME1)
      NUMBLD(NTEXT) = N1

      NTEXT = NTEXT + N1
      TEXT(NTEXT) = BLANK
C 3...
      NTEXT = NTEXT + N1
      IF (EDIT) THEN
         TEXT(NTEXT) = 'Title of the current edited data is:'
      ELSE   
         TEXT(NTEXT) = 'Title of the current data supplied is:'
      ENDIF   
C 4...
      NTEXT = NTEXT + N1
      TEXT(NTEXT) = CHOP80(TITLE)
      NUMBLD(NTEXT) = N1
      FILE = FNAME1
      CALL LCASE1 (FILE)
C 5...
      NTEXT = NTEXT + N1
      TEXT(NTEXT) = BLANK
      
      NTEXT = NTEXT + N1
      NSTART = NTEXT
      TEXT(NTEXT) = 'Input a new data file then fit the new data'
C 6...
      NTEXT = NTEXT + N1
      IF (EDIT) THEN
         TEXT(NTEXT) = 'Fit the current edited data'
      ELSE
         TEXT(NTEXT) = 'Fit the current un-edited data'
      ENDIF
C 7...
      NTEXT = NTEXT + N1
      IF (EDIT) THEN
         TEXT(NTEXT) = 'Continue editing the data'
      ELSE   
         TEXT(NTEXT) = 'Edit the current data'
      ENDIF   
C 8...
      NTEXT = NTEXT + N1
      TEXT(NTEXT) = 'View the current data'
      IF (EDIT) THEN
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = 'Save the edited data As ...'
         NUMOPT = 7
      ELSE
         NUMOPT = 6
      ENDIF
C 9...
      NTEXT = NTEXT + N1
      TEXT(NTEXT) = 'Results'
C 10..
      NTEXT = NTEXT + N1
      TEXT(NTEXT) = 'Quit  ...  Exit program QNFIT'
C
C All data has been assembled so throw up the menu
C
      NUMDEC = N4
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (NUMDEC.EQ.N1) THEN
C
C New data file
C
         ABORT = .FALSE.
         NEWFIL = .TRUE.
      ELSEIF (NUMDEC.EQ.N2) THEN
C
C Current data
C
         ABORT  = .FALSE.
         NEWFIL = .FALSE.
      ELSEIF (NUMDEC.EQ.N3) THEN
C
C Edit current data ... open a file FILE1 to hold data after editing
C
         FNAME(1) = FNAME1
         CALL GETTMP (IOS, FILE1)
         FNAME(2) = FILE1
         CALL GETNOU (NOUT1)
         OPEN (UNIT = NOUT1, FILE = FILE1)
         CALL GETNOU (NIN1)
         CLOSE (NIN1)
         CLOSE (NOUT1)
         IF (DEQN .OR. CHKDAT) THEN
            ITYPE = N2
         ELSE
            ITYPE = N3
         ENDIF
         CALL EDFLXX (ITYPE, NIN1, NOUT1,
     +                FNAME)
         FNAME1 = FNAME(2)
         EDIT = .TRUE.
         TITLE = 'Edited data'
         GOTO 20
      ELSEIF (NUMDEC.EQ.N4) THEN
         CALL VIEWER (ISEND,
     +                FNAME1, BLANK, BLANK)
         GOTO 20
      ELSEIF (EDIT) THEN
         IF (NUMDEC.EQ.N5) THEN
C
C Rename edited data
C
            CALL PUTADV ('Specify a new file name')
            CALL GETNOU (NOUT1)
            CLOSE (NOUT1)
            CALL OFILES (ISEND, NOUT1, 
     +                   FILE, 
     +                   ABORT)
            CLOSE (NOUT1)
            IF (.NOT.ABORT) THEN
               CALL DELEET (FILE,
     +                      ASKIF, THERE)
               IF (THERE) THEN
                  CALL PUTADV (
     +           'Change read-only status to over-write')
               ELSE
                  CALL RENAME (FNAME1, FILE, ERROR_CODE)
                  FNAME1 = FILE
               ENDIF
            ENDIF
            GOTO 20
         ELSEIF (NUMDEC.EQ.N6) THEN
C
C Review progress
C
            CALL REVPRO (NOUT)
            GOTO 20
         ELSE
C
C Quit
C
            ABORT = .TRUE.
         ENDIF
      ELSE
         IF (NUMDEC.EQ.N5) THEN
C
C Review
C
            CALL REVPRO (NOUT)
            GOTO 20
         ELSE
C
C Quit
C
            ABORT = .TRUE.
         ENDIF
      ENDIF
      END
C
C

