C
C
C QNFIT04.INS ... The models used by MAKDAT and QNFIT
C ===========
C 
C Data is communicated to the models using MODULE_QNFIT
C
C Note: this version is dimensioned for MODFNAM(24)*80 and it uses
C       KMAX_A, KMAX_F, KMAX_J and KMAX_Y to dimension call to QNUSER
C
C QMODEL
C QMODEX
C D02FCN
C D02JAC
C D02FCN_USE
C D02JAC_USE
C D02SOL
C
C Given parameters P(N) and NPTS these routines calculate THEORY(i)
C for i = 1, 2, ..., NPTS for simulation or fitting
C
C Models... QMODEL, QMODEX, DEQUSE, JACUSE, YDERIV and PEDERV
C
C 09/10/1997 win32 version using DVODE instead of D02EBF
C ======================================================
C         DVODE parameters are as follows:
C
C         IP and P communicate INTEGER and DBLE parameters to the model
C         IWORK(LIW) and RWORK(LRW) are used as local workspace by DVODE
C         Note that A = FACT*P is passed to the model not P
C         LIW >= NEQN + 30
C         LRW >= 22 + 9*NEQN + 2*NEQN**2
C         ATOL = absolute tolerance
C         BTOL = relative tolerance
C         where estimated local error is EWT(i) = RTOL*ABS(Y(i)) + ATOL
C         ITASK = 1 for normal computation of Y at TOUT
C         IOPT = 0 for no optional input
C         METH = 1 Adams, 2 = BDF
C         MITER = 0 no Jacobian, 1 = analytic Jacobian, 2 = estimated Jacobian
C         MF: MF = JSV*(10*METH + MITER), e.g.
C             10 = Adams with no Jacobian
C             21 = stiff with analytic Jacobian
C             22 = stiff with estimated Jacobian
C         ISTAT:  2 = success
C                -1 = excess work (wrong MF)
C                -2 = excess accuracy (wrong TOL)
C                -3 = illegal input
C                -4 = repeated error test failures
C                -5 = repeated convergence failures (bad Jacobian)
C                -6 = error weight became zero
C
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QMODEL (N,
     +                   P)

      USE MODULE_QNFIT, ONLY : NX, 
     +                         MODEL, NCALLS, NMOD, NPAR, NPTS, 
     +                         NVAR,
     +                         NTMAX, NYMAX, 
     +                         IADDUP, INDEXM, NUMPNT, 
     +                         NUMEQN, NUMPAR, NUMPOS, NUMVAR,                   
     +                         IRELAB, METH, MITER,
     +                         KMAX_A, KMAX_J, KMAX_F, KMAX_Y,
     +                         XVAL, YVAL, ZVAL,
     +                         THEORY,
     +                         A, B, FACT, IP,
     +                         DTOL, D02TOL, ENEG, EPOS, EPSI, RTOL, 
     +                         XTOL, ZTOL,
     +                         FMULT, WMULT, YMDE, YMJACC, 
     +                         NAMMOD, 
     +                         CONST, DEQN, EQUAL, MULTI1,
     +                         RELABS,
     +                         USE_D02CJF, USE_D02EJF, USE_JACOBIAN 
C
C Evaluate MODEL depending on DEQN, SUPPLY, NVAR
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN) :: N
      DOUBLE PRECISION, INTENT (IN) :: P(N)
C
C Locals
C      
      INTEGER    LIW, LRW, NDEQN
      PARAMETER (LIW = 31, LRW = 36, NDEQN = 1)
      INTEGER    IWORK(LIW)
      INTEGER    I, ICOUNT, J, JSEND
      INTEGER    ISEND, ITOL, ITASK, ISTAT, IOPT, JSV, MF
      PARAMETER (ISEND = 2, ITOL = 1, ITASK = 1, IOPT = 0, JSV = 1)
      DOUBLE PRECISION XX, YY, ZZ
      DOUBLE PRECISION XVAL_NP1
      DOUBLE PRECISION QNLIB1, QNLIB2, QNLIB3
      DOUBLE PRECISION ATOL(1), BTOL(1), TIME, TOUT, TSTART, TSTOP,
     +                 RWORK(LRW), Y(1), YNORM, YZERO
      DOUBLE PRECISION YPREV
      DOUBLE PRECISION TOL, ZERO, ONE, ZMIN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, ZMIN = 1.0D-50)
      LOGICAL    EQUAL_NP1
C
C Special temporary working array ZMULT to avoid re-defining YMULT
C =================================================================
C
      DOUBLE PRECISION ZMULT(NTMAX,NYMAX)
      CHARACTER  DEQERR(6)*80
      LOGICAL    ABORT
      EXTERNAL   QNLIB1, QNLIB2, QNLIB3
      EXTERNAL   DVODE
      EXTERNAL   PEDERV, YDERIV, QMODEX, DEQUSE, JACUSE, QNUSER, D02SOL
      INTRINSIC  ABS, MAX
C
C DATA and SAVE ODE workspace
C
      SAVE  IWORK, RWORK, Y, YPREV
      DATA  DEQERR /
     +'FATAL: ISTATE = -1 from DVODE ... excess work, maybe wrong MF ?',
     +'FATAL: ISTATE = -2 from DVODE .. maybe TOL value is too small ?',
     +'FATAL: ISTATE = -3 from DVODE .. maybe illegal input detected ?',
     +'FATAL: ISTATE = -4 from DVODE .. repeated error test failures ?',
     +'FATAL: ISTATE = -5 from DVODE  no conv. check Jacobian/MF/TOL ?',
     +'FATAL: ISTATE = -6 from DVODE  error weight = 0, and ATOL = 0 ?'/
C
C Scale the parameters up before evaluating the model
C
      DO I = 1, N
         A(I) = FACT(I)*P(I)
      ENDDO
      IF (MULTI1) THEN
C
C Calculate the THEORETICAL points in MULTI function mode
C
         IF (NPTS.EQ.1) THEN
C
C If NPTS = 1 the covariance matrix is being calculated at 1 point
C
            XX = XVAL(1)
            CALL QNUSER (ISEND,
     +                   KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                   NUMEQN, NUMPAR, NUMVAR, NX, A,
     +                   FMULT, XX, YY, YMDE, YMJACC, ZZ, NAMMOD,
     +                   ABORT, DEQN)
            I = 1
            J = NUMPNT(I)
C
C Find out where we are, i.e. which block of data x(1) is in currently
C
            DO WHILE (NUMPOS.GT.J .AND. I.LT.NUMEQN)
               I = I + 1
               J = J + NUMPNT(I)
            ENDDO
            THEORY(1) = FMULT(I)
         ELSE
C
C Use the IADDUP distinct x-values in WMULT to define the model values
C
           DO I = 1, IADDUP
               XX = WMULT(I)
               CALL QNUSER (ISEND,
     +                      KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                      NUMEQN, NUMPAR, NUMVAR, NX, A,
     +                      FMULT, XX, YY, YMDE, YMJACC, ZZ, NAMMOD,
     +                      ABORT, DEQN)
               DO J = 1, NUMEQN
                  ZMULT(I,J) = FMULT(J)
               ENDDO
            ENDDO
C
C Fill up the THEORY vector using INDEXM: the index of original x-values
C
            ICOUNT = 0
            DO J = 1, NUMEQN
               IF (NUMPNT(J).GT.0) THEN
                  DO I = 1, NUMPNT(J)
                     ICOUNT = ICOUNT + 1
                     THEORY(ICOUNT) = ZMULT(INDEXM(I,J),J)
                  ENDDO
               ENDIF
            ENDDO
         ENDIF
      ELSEIF (DEQN) THEN
C
C Differential equations so define TSTART, TSTOP and YZERO
C
         TSTART = ZERO
         TSTOP = XVAL(NPTS)
         IF (MODEL.EQ.1) THEN
            IF (NMOD.EQ.2 .OR. NMOD.EQ.4) THEN
               YZERO = ZERO
            ELSE
               YZERO = A(N)
            ENDIF
         ELSEIF (MODEL.EQ.2) THEN
            YZERO = MAX(A(N),ZMIN)
         ELSE
            YZERO = A(N)   
         ENDIF
C
C========================================================================
C This next code is only required to make sure DVODE works properly by
C defining XVAL(NPTS + 1) and EQUAL(NPTS + 1), e.g. for AUC, calibration, 
C dy/dx and so on. 
C
C Make sure XVAL(NPTS + 1) > XVAL(NPTS) and that EQUAL(NPTS + 1) = .FALSE.
C
        XVAL_NP1 = XVAL(NPTS + 1)
        EQUAL_NP1 = EQUAL(NPTS + 1)
        XVAL(NPTS + 1) = XVAL(NPTS) + ONE
        EQUAL(NPTS + 1) = .FALSE.
C========================================================================
C
         IF (XVAL(1).LT.ZERO .OR. ABS(TSTART - TSTOP).LE.RTOL) THEN
            DO I = 1, NPTS
               THEORY(I) = YZERO
            ENDDO
         ELSE
            IP(1) = MODEL
            IP(2) = NMOD
            IP(3) = NDEQN
            IP(4) = NPAR
            MF = JSV*(10*METH + MITER)
            TIME = TSTART
            TOUT = TSTART
            TOL = DTOL
            YNORM = ABS(YZERO)
            IF (IRELAB.EQ.0) THEN
               ATOL(1) = EPSI*(MAX(ONE, YNORM))
               BTOL(1) = TOL
            ELSEIF (IRELAB.EQ.1) THEN
               ATOL(1) = EPSI*(MAX(ONE, YNORM))
               BTOL(1) = ZERO
            ELSE
               ATOL(1) = ZERO
               BTOL(1) = TOL
            ENDIF
C
C Initial conditions DVODE ... Define Y(1) at t = 0 and set NCALLS = 0
C
            Y(1) = YZERO
            NCALLS = 0
C
C Now set YPREV and ISTAT and call DVODE
C
            ISTAT = 1
            YPREV = YZERO
            IF (MODEL.EQ.17) THEN
C
C User supplied model
C
               IF (USE_D02CJF .OR. USE_D02EJF) THEN 
                   JSEND = MODEL
                   CALL D02SOL (JSEND, NDEQN,
     +                          D02TOL, TSTART, TSTOP, Y,
     +                          RELABS,                  
     +                          USE_D02CJF, USE_D02EJF, USE_JACOBIAN)
               ELSE
                  CALL QMODEX (TOUT, Y)
                  DO WHILE (TOUT.LE.TSTOP)
                     IF (ISTAT.GT.0) THEN
                        CALL DVODE (DEQUSE, NDEQN, Y, TIME, TOUT, ITOL,
     +                              BTOL, ATOL, ITASK, ISTAT, IOPT,
     +                              RWORK, LRW, IWORK, LIW, JACUSE, MF,
     +                              A, IP)
                        IF (ISTAT.GT.0) THEN
                           YPREV = Y(1)
                        ELSE
                           I = - ISTAT
                           WRITE (6,'(A)') DEQERR(I)
                           Y(1) = YPREV
                        ENDIF
                     ELSE
                        Y(1) = YPREV
                     ENDIF
                     CALL QMODEX (TOUT, Y)
                  ENDDO
               ENDIF     
            ELSE
C
C Model in DLL
C
               IF (USE_D02CJF .OR. USE_D02EJF) THEN
                  JSEND = MODEL
                  CALL D02SOL (JSEND, NDEQN,
     +                         D02TOL, TSTART, TSTOP, Y,
     +                         RELABS, 
     +                         USE_D02CJF, USE_D02EJF, USE_JACOBIAN)
               ELSE
                  CALL QMODEX (TOUT, Y)
                  DO WHILE (TOUT.LE.TSTOP)
                     IF (ISTAT.GT.0) THEN
                        CALL DVODE (YDERIV, NDEQN, Y, TIME, TOUT, ITOL,
     +                              BTOL, ATOL, ITASK, ISTAT, IOPT,
     +                              RWORK, LRW, IWORK, LIW, PEDERV, MF,
     +                              A, IP)
                        IF (ISTAT.GT.0) THEN
                           YPREV = Y(1)
                        ELSE
                           I = - ISTAT
                           WRITE (6,'(A)') DEQERR(I)
                           Y(1) = YPREV
                        ENDIF
                     ELSE
                        Y(1) = YPREV
                     ENDIF
                     CALL QMODEX (TOUT, Y)
                  ENDDO
               ENDIF
            ENDIF   
         ENDIF
C
C Restore XVAL(NPTS + 1) and EQUAL(NPTS + 1)
C         
         XVAL(NPTS + 1) = XVAL_NP1
         EQUAL(NPTS + 1) = EQUAL_NP1
      ELSEIF (NVAR.EQ.1) THEN
C
C Function of one variable
C
         DO I = 1, NPTS
            IF (EQUAL(I)) THEN
               THEORY(I) = THEORY(I - 1)
            ELSE
               THEORY(I) = QNLIB1(MODEL, NMOD, NPAR, NX,
     +                            A, B, ENEG, EPOS, EPSI, RTOL,
     +                            XVAL(I), XTOL, ZTOL, CONST)
            ENDIF
        ENDDO
      ELSEIF (NVAR.EQ.2) THEN
C
C Function of two variables
C
         DO I = 1, NPTS
            IF (EQUAL(I)) THEN
               THEORY(I) = THEORY(I - 1)
            ELSE
               THEORY(I) = QNLIB2(MODEL, NMOD, NPAR, NX,
     +                            A, B, ENEG, EPOS, EPSI, RTOL,
     +                            XVAL(I), XTOL, YVAL(I), ZTOL, CONST)
            ENDIF
        ENDDO
      ELSEIF (NVAR.EQ.3) THEN
C
C Function of three variables
C
         DO I = 1, NPTS
            IF (EQUAL(I)) THEN
               THEORY(I) = THEORY(I - 1)
            ELSE
               THEORY(I) = QNLIB3(MODEL, NMOD, NPAR, NX,
     +                            A, B, ENEG, EPOS, EPSI, RTOL,
     +                            XVAL(I), XTOL, YVAL(I), ZVAL(I), ZTOL,
     +                            CONST)
            ENDIF
        ENDDO
      ENDIF
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QMODEX (XSOL, Y)
C
C ACTION : Intermediate output from DVODE
C ADVICE : This routine sets each time point for the next integration step
C          The module MODULE_QNFIT must be dimensioned correctly
C
C

      USE MODULE_QNFIT, ONLY : NCALLS, NPTS, NZEROS,
     +                         XVAL,
     +                         THEORY,
     +                         EQUAL

      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN)  :: Y(1)
      DOUBLE PRECISION, INTENT (OUT) :: XSOL
C
C Locals
C      
      INTEGER    I, NTEMP
      IF (NCALLS.EQ.0) THEN
C
C First call only so NCALLS must be set elsewhere = 0 to start the integration
C
         NCALLS = 1
         XSOL = XVAL(1)
         IF (NZEROS.EQ.0) THEN
C
C If there are no t = 0 points just carry on
C
            NCALLS = 1!to silence ftn95
         ELSE
C
C Set each replicate t = 0 point to Y(0)
C
            DO I = 1, NZEROS
               THEORY(NCALLS) = Y(1)
               NCALLS = NCALLS + 1
            ENDDO
            XSOL = XVAL(NCALLS)
         ENDIF
      ELSE
C
C Set current Y(i) (setting NCALLS to deal with replicates) then re-set t
C
         THEORY(NCALLS) = Y(1)
         NCALLS = NCALLS + 1
         XSOL = XVAL(NCALLS)
         NTEMP = NCALLS
         DO I = NTEMP, NPTS
            IF (.NOT.EQUAL(I)) RETURN
            THEORY(I) = Y(1)
            NCALLS = NCALLS + 1
            XSOL = XVAL(NCALLS)
         ENDDO
      ENDIF
      END
C
C-------------------------------------------------------------------------------
C The following code is for when D02 is used
C
      SUBROUTINE D02FCN (X, Y, F)
C
C Explicit function for D02
C      
      USE MODULE_QNFIT, ONLY : A, IP
      IMPLICIT   NONE
      DOUBLE PRECISION X, Y(*), F(*)
      INTEGER    NDEQN
      PARAMETER (NDEQN = 1)
      EXTERNAL   YDERIV
      CALL YDERIV (NDEQN, X, Y, F, A, IP)
      END 
C
C-----------------------------------------------------------------------
C   
      SUBROUTINE D02JAC (X, Y, PW)
C
C Explicit Jacobian for D02 
C      
      USE MODULE_QNFIT, ONLY : A, IP
      IMPLICIT   NONE
      DOUBLE PRECISION X, Y(*), PW(*)
      INTEGER    ML, MU
      INTEGER    NDEQN, NROWPW
      PARAMETER (NDEQN = 1, NROWPW = 1)
      EXTERNAL   PEDERV
      CALL PEDERV (NDEQN, X, Y, ML, MU, PW, NROWPW, A, IP)
      END 
C
C-----------------------------------------------------------------------
C
      SUBROUTINE D02FCN_USE (X, Y, F)
C
C User supplied function for D02
C      
      USE MODULE_QNFIT, ONLY : A, IP
      IMPLICIT   NONE
      DOUBLE PRECISION X, Y(*), F(*)
      INTEGER    NDEQN
      PARAMETER (NDEQN = 1)
      EXTERNAL   DEQUSE
      CALL DEQUSE (NDEQN, X, Y, F, A, IP)
      END 
C
C-----------------------------------------------------------------------
C   
      SUBROUTINE D02JAC_USE (X, Y, PW)
C
C user supplied Jacobian for D02
C      
      USE MODULE_QNFIT, ONLY : A, IP
      IMPLICIT   NONE
      DOUBLE PRECISION X, Y(*), PW(*)
      INTEGER    ML, MU
      INTEGER    NDEQN, NROWPW
      PARAMETER (NDEQN = 1, NROWPW = 1)
      EXTERNAL   JACUSE
      CALL JACUSE (NDEQN, X, Y, ML, MU, PW, NROWPW, A, IP)
      END         
C
C-----------------------------------------------------------------------
C
      SUBROUTINE D02SOL (ISEND, N, 
     +                   D02TOL, XSTART, XSTOP, Y,
     +                   RELABS, 
     +                   USE_D02CJF, USE_D02EJF, USE_JACOBIAN) 
C
C ACTION: version for QNFIT where N = 1 so allocatables suppressed
C AUTHOR: w.g.bardsley, university of manchester, u.k., 05/02/2010
C
C  ISEND: ISEND =  0, Configure ODE solver
C         ISEND = 17, user-defined model
C                o/w, library of models 
C D02TOL: TOl for D02 routines                     
C XSTART: start point
C  XSTOP: end point
C      Y: initial conditions then integrals
C RELABS: RELABs for D02 routines
C
C 
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND, N
      DOUBLE PRECISION,    INTENT (IN)    :: XSTART, XSTOP, Y(N)
      DOUBLE PRECISION,    INTENT (INOUT) :: D02TOL
      CHARACTER (LEN = *), INTENT (INOUT) :: RELABS
      LOGICAL,             INTENT (INOUT) :: USE_D02CJF, USE_D02EJF,
     +                                       USE_JACOBIAN 
C
C Allocatable
C      
C*****DOUBLE PRECISION, ALLOCATABLE :: W(:)
C
C Locals
C      
C*****INTEGER    IERR
      INTEGER    IFAIL, NDEC, NUMDEC
      INTEGER    NUMOPT, NEQN, NUMSTA, NUMTXT
      PARAMETER (NUMOPT = 4, NEQN = 1, NUMSTA = 3,
     +           NUMTXT = NUMSTA + NUMOPT - 1)
      INTEGER    NUMBLD(NUMTXT)
      INTEGER    IW
      PARAMETER (IW = NEQN*(NEQN + 12) + 50) 
      DOUBLE PRECISION W(IW) 
      DOUBLE PRECISION X, XEND
      DOUBLE PRECISION TOLMAX, TOLMIN, ZERO
      PARAMETER (TOLMAX = 1.0D-01, TOLMIN = 1.0D-10, ZERO = 0.0D+00)
      CHARACTER (LEN = 100) LINE, TEXT(NUMTXT)
      EXTERNAL   LSTBOX, GETDM1, PUTADV, PUTWAR
      EXTERNAL   D02WGB, QMODEX
      EXTERNAL   D02FCN, D02JAC, D02FCN_USE, D02JAC_USE
      DATA       NUMBLD / NUMTXT*0 / 
      
      IF (ISEND.EQ.0) THEN
C
C Configure the ODE interface
C        
         WRITE (TEXT,100)

         IF (USE_D02CJF) THEN
            NUMDEC = 2
         ELSEIF (USE_D02EJF .AND. USE_JACOBIAN) THEN
            NUMDEC = 3 
         ELSEIF (USE_D02EJF .AND. .NOT.USE_JACOBIAN) THEN    
            NUMDEC = 4
         ELSE
            NUMDEC = 1
         ENDIF  
            
         NUMBLD(1) = 1
         CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                TEXT)
         NUMBLD(1) = 0
     
         IF (NUMDEC.EQ.1) THEN
            USE_D02CJF = .FALSE.
            USE_D02EJF = .FALSE. 
         ELSEIF (NUMDEC.EQ.2) THEN
            USE_D02CJF = .TRUE.
            USE_D02EJF = .FALSE.
         ELSEIF (NUMDEC.EQ.3) THEN
            USE_D02CJF = .FALSE.
            USE_D02EJF = .TRUE.
            USE_JACOBIAN = .TRUE.
         ELSE
            USE_D02CJF = .FALSE.
            USE_D02EJF = .TRUE.
            USE_JACOBIAN = .FALSE.
         ENDIF
         
         IF (NUMDEC.GT.1) THEN
           
            CALL GETDM1 (TOLMIN, D02TOL, TOLMAX,
     +                  'D02CJF/EJF TOL value required')
     
            IF (RELABS.EQ.'M') THEN
               NDEC = 1 
            ELSEIF (RELABS.EQ.'A') THEN
               NDEC = 2 
            ELSEIF (RELABS.EQ.'R') THEN
               NDEC = 3
            ELSEIF (RELABS.EQ.'D') THEN
               NDEC = 4  
            ELSE
               NDEC = 1
            ENDIF 
            WRITE (TEXT,200)

            NUMBLD(1) = 1
            CALL LSTBOX (NUMBLD, NDEC, NUMOPT, NUMSTA, NUMTXT,
     +                   TEXT)             
            NUMBLD(1) = 0
     
            RELABS = TEXT(NDEC)(1:1)
         ENDIF
      ELSE 
C
C Check then call the integrator
C                           
         IF (N.NE.1) THEN
            CALL PUTADV ('DO2SOL called with N not equal to 1')
            RETURN
         ENDIF   
         IF (XSTART.GE.XSTOP) THEN
            CALL PUTADV ('D02SOL called with XSTART >= XSTOP')
            RETURN
         ELSE 
            X = XSTART
            XEND = XSTOP    
         ENDIF  
         IF (D02TOL.LE.ZERO) THEN
            CALL PUTADV ('D02SOL called with TOL =< 0')
            RETURN
         ENDIF  
         IF (RELABS.NE.'M' .AND. RELABS.NE.'A'.AND.
     +       RELABS.NE.'R' .AND. RELABS.NE.'D') THEN 
            CALL PUTADV ('D02SOL called with RELABS not M,A,R, or D')
            RETURN
         ENDIF    
         
C
C Allocate workspace
C         
C*********IW = N*(12 + N) + 50
C         IERR = 0
C         IF (ALLOCATED(W)) DEALLOCATE (W, STAT = IERR)
C         IF (IERR.NE.0) RETURN 
C         ALLOCATE (W(IW), STAT = IERR)
C*********IF (IERR.NE.0) RETURN    
C
C Call the solvers  
C
         IF (ISEND.EQ.17) THEN
C
C User-supplied model
C
            IF (USE_D02CJF) THEN
               CALL D02WGB ('D02CJF',
     +                      X, XEND, N, Y, D02FCN_USE, D02JAC_USE,
     +                      D02TOL, RELABS, QMODEX, W, IW, IFAIL)
            ELSEIF (USE_D02EJF .AND. USE_JACOBIAN) THEN
               CALL D02WGB ('D02EJF_EXPLICIT',
     +                      X, XEND, N, Y, D02FCN_USE, D02JAC_USE,
     +                      D02TOL, RELABS, QMODEX, W, IW, IFAIL)
            ELSEIF (USE_D02EJF .AND. .NOT.USE_JACOBIAN) THEN
               CALL D02WGB ('D02EJF_FINITE',
     +                      X, XEND, N, Y, D02FCN_USE, D02JAC_USE,
     +                      D02TOL, RELABS, QMODEX, W, IW, IFAIL)
            ENDIF     
         ELSE
           IF (USE_D02CJF) THEN
               CALL D02WGB ('D02CJF',
     +                      X, XEND, N, Y, D02FCN, D02JAC, D02TOL,
     +                      RELABS, QMODEX, W, IW, IFAIL)
            ELSEIF (USE_D02EJF .AND. USE_JACOBIAN) THEN
               CALL D02WGB ('D02EJF_EXPLICIT',
     +                      X, XEND, N, Y, D02FCN, D02JAC, D02TOL,
     +                      RELABS, QMODEX, W, IW, IFAIL)
             ELSEIF (USE_D02EJF .AND. .NOT.USE_JACOBIAN) THEN
               CALL D02WGB ('D02EJF_FINITE',
     +                      X, XEND, N, Y, D02FCN, D02JAC, D02TOL,
     +                      RELABS, QMODEX, W, IW, IFAIL)
            ENDIF
         ENDIF 
         IF (IFAIL.NE.0) THEN
            WRITE (LINE,300) IFAIL
            CALL PUTWAR (LINE)
         ENDIF         
C********DEALLOCATE (W, STAT = IERR)
      ENDIF   
C
C Format statements
C      
  100 FORMAT (
     + 'Choose the ODE solver required'
     +/
     +/'Use default DVODE (several options)'
     +/'Use NAG D02CJF: Adams method'   
     +/'use NAG D02EJF: BDF method (supplied explicit Jacobian)'
     +/'Use NAG D02EJF: BDF method (finite difference Jacobian)')
  200 FORMAT (
     + 'Choose the ODE test method required'
     +/
     +/'Mixed error test'
     +/'Absolute error test'
     +/'Relative error test'
     +/'Default error test')   
  300 FORMAT ('IFAIL =',I3,1X,'on exit from the D02 routine')   
      END
C
C      
     