C
C
C 02/11/2016 changes to VCOVAR to use TABLE1 for correlation matrices
C            with NPAR =< 10 instead of the call to MATCOR 

C
C QNFIT05.INS
C ===========
C these subroutines do not include MODULE_QNFIT
C
C This file contains:- subroutine ... RANDOM
C                      subroutine ... SETSUP
C                      subroutine ... TESTPS
C                      subroutine ... VCOVAR
C                      subroutine ... WEIGHT
C
C----------------------------------------------------------------------
C
      SUBROUTINE RANDOM (ISTATE, NOUT, NPAR,
     +                   BL, BU, PX, RNDOF, X,
     +                   ABORT)
C
C ACTION : Random search for improved parameter start values
C ADVICE : Set FACTORS and initialise ISTATE before calling this routine
C          NSCALE limits iterations (e.g. mainframe NSCALE = 4, PC NSCALE = 1)
C          NX must be >= NX in MODULE_QNFIT
C          18/11/2009 extensive revision
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NOUT, NPAR
      INTEGER,          INTENT (IN)    :: ISTATE(NPAR)
      DOUBLE PRECISION, INTENT (IN)    :: BL(NPAR), BU(NPAR)
      DOUBLE PRECISION, INTENT (INOUT) :: PX(NPAR), X(NPAR)
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    LSHADE, NMAX, NMIN, NSCALE, NSTART, NUMTXT, NX
      PARAMETER (LSHADE = 1, NMAX = 1024, NMIN = 64, NSCALE = 4,
     +           NSTART = 12, NUMTXT = 16, NX = 200)
      INTEGER    I, J, K, NBEST, NDEC, NLOOPS, NTRY
      INTEGER    ICOLOR, IX, IY, NUMOPT, N16
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, NUMOPT = 5, N16 = 16)
      INTEGER    NUMBLD(NUMTXT), NUMPOS(NUMOPT)
      INTEGER    COLOUR
      DOUBLE PRECISION RNDOF
      DOUBLE PRECISION ZERO, HALF, ONE, TWO, TEN
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION DUMMY, RNDEC, SIGMA, SSTART, TRIANG, TSTART
      DOUBLE PRECISION FBEST, FNOW, FSAV, RAN1, RAN2, RANSUM
      DOUBLE PRECISION DELTAL(NX), DELTAU(NX), XBEST(NX)
      DOUBLE PRECISION G05CAF$, G05DDF$
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    QNLGLS, RANDOM_SEARCH
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   FUNCT1, QNLGLS
      EXTERNAL   PUTADV, LBOX01, TABLE1
      EXTERNAL   G05DDF$, G05CAF$
      INTRINSIC  DBLE
      DATA NUMPOS / NUMOPT*1 /
      DATA NUMBLD / NUMTXT*0 /
C
C Check if random search is required
C  
      RANDOM_SEARCH = QNLGLS (N16)    
C
C Check dimensions
C
      IF (NPAR.GT.NX) THEN
         ABORT = .TRUE.
         WRITE (LINE,100) NX
         CALL PUTADV(LINE)
         RETURN
      ELSE
         ABORT = .FALSE.
      ENDIF
      IF (.NOT.RANDOM_SEARCH) RETURN
C
C Enquire if random search is required
C
      WRITE (TEXT,200)
      NDEC = 1
      NUMBLD(1) = 1
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT, NUMPOS,
     +             NSTART, NUMTXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (NDEC.EQ.1) THEN
         RETURN
      ELSEIF (NDEC.EQ.NUMOPT) THEN
         ABORT = .TRUE.
         RETURN
      ENDIF
C
C Set the no. of iterations and the interals for searching
C
      NLOOPS = NSCALE*(2**NPAR)*(2**NDEC)
      IF (NLOOPS.GT.NSCALE*NMAX) NLOOPS = NSCALE*NMAX
      IF (NLOOPS.LT.NSCALE*NMIN) NLOOPS = NSCALE*NMIN
      DO I = 1, NPAR
         DELTAL(I) = X(I) - BL(I)
         DELTAU(I) = BU(I) - X(I)
         PX(I) = X(I)
         XBEST(I) = X(I)
      ENDDO
C
C Find the objective function at the start
C
      CALL FUNCT1 (NPAR, X, FSAV)
      FBEST = FSAV
      NBEST = 0
      NTRY = 0
C
C Initialise the output table
C
      COLOUR = 15
      CALL TABLE1 (COLOUR, 'OPEN')
      WRITE (LINE,300)
      COLOUR = 4
      CALL TABLE1 (COLOUR, LINE)
      WRITE (LINE,400) NTRY, FBEST*RNDOF
      CALL TABLE1 (COLOUR, LINE)
      RNDEC = DBLE(NDEC)
      SIGMA = ZERO
      SSTART = TWO/RNDEC
      TRIANG = ZERO
      TSTART = ONE/RNDEC
      DO I = 1, NDEC
         SIGMA = SIGMA + SSTART
         IF (SIGMA.GT.TWO) SIGMA = TWO
         TRIANG = TRIANG + TSTART
         IF (TRIANG.GT.ONE) TRIANG = ONE
         DO J = 1, NLOOPS
            NTRY = NTRY + 1
            DO K = 1, NPAR
               IF (ISTATE(K).EQ.1) THEN
                  RAN1 = G05CAF$(DUMMY)
                  RAN2 = G05CAF$(DUMMY)
                  RANSUM = RAN1 + RAN2 - ONE
                  IF (RANSUM.GE.ZERO) THEN
                     X(K) = PX(K) + DELTAU(K)*RANSUM*TRIANG
                  ELSE
                     X(K) = PX(K) + DELTAL(K)*RANSUM*TRIANG
                  ENDIF
               ELSEIF (ISTATE(K).EQ.2) THEN
                  RAN1 = G05DDF$(ZERO, SIGMA)
                  X(K) = TEN**RAN1
               ELSEIF (ISTATE(K).EQ.3) THEN
                  RAN1 = G05DDF$(ZERO, SIGMA)
                  RAN2 = G05CAF$(DUMMY)
                  IF (RAN2.GT.HALF) THEN
                     RAN2 = ONE
                  ELSE
                     RAN2 = - ONE
                  ENDIF
                  X(K) = RAN2*(TEN**RAN1)
               ENDIF
               IF (X(K).GT.BU(K)) THEN
                  X(K) = BU(K)
               ELSEIF (X(K).LT.BL(K)) THEN
                  X(K) = BL(K)
               ENDIF
            ENDDO
            CALL FUNCT1 (NPAR,
     +                   X, FNOW)
            IF (FNOW.LT.FBEST) THEN
               FBEST = FNOW
               NBEST = NBEST + 1
               DO K = 1, NPAR
                  XBEST(K) = X(K)
               ENDDO
               WRITE (LINE,400) NTRY, FBEST*RNDOF
               COLOUR = 0
               CALL TABLE1 (COLOUR, LINE)
            ENDIF
         ENDDO
         WRITE (LINE,500) I, NLOOPS
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
      ENDDO
      DO I = 1, NPAR
         PX(I) = XBEST(I)
         X(I) = PX(I)
      ENDDO
      WRITE (TEXT,600) FSAV*RNDOF, FBEST*RNDOF, NBEST, NTRY
      WRITE (NOUT,600) FSAV*RNDOF, FBEST*RNDOF, NBEST, NTRY
      COLOUR = 0
      DO I = 1, 5
         CALL TABLE1 (COLOUR, TEXT(I))
      ENDDO
      CALL TABLE1 (COLOUR, 'CLOSE')
C
C Format statements
C      
  100 FORMAT ('Max. no. parameters in this version =',I3)
  200 FORMAT (
     + 'Using a random search for parameter starting estimates'
     +/
     +/'Random searches should not be necessary if you are using the'
     +/'expert mode and have good starting estimates. However, if you'
     +/'are not sure you have good starting values, a random search can'
     +/'often be useful. You should definitely not use this option if'
     +/'the model is very susceptible to variations in parameters that'
     +/'could cause overflow, as when parameters occur as exponents or'
     +/'in some differential equations. Searches will be unsymmetrical'
     +/'and triangular if bounds are set, but lognormal otherwise.'
     +/
     +/'Fit now with no random search'
     +/'Fit after short random search'
     +/'Fit after medium random search'
     +/'Fit after extensive random search'
     +/'Cancel fit')
  300 FORMAT (1X,'Iteration',6X,'WSSQ')
  400 FORMAT (I6,4X,1P,E10.3)
  500 FORMAT (1X,'End of cycle',I2,1X,'after',I6,1X,'iterations')
  600 FORMAT (/1X,'WSSQ before  =',1P,E10.3/1X,'WSSQ after   =',E10.3
     +/1X,'Improvements =',I7/1X,'Iterations   =',I7)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE SETSUP (IRELAB, METH, MITER,
     +                   DTOL, D02TOL, ENEG, EPOS, EPSI, RTOL, XTOL,
     +                   ZTOL,
     +                   OTYPE, RELABS,
     +                   SPLASH)
C
C ACTION : Machine constants and tolerances
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (OUT) :: IRELAB, METH, MITER
      DOUBLE PRECISION,    INTENT (OUT) :: DTOL, D02TOL, ENEG, EPOS,
     +                                     EPSI, RTOL, XTOL, ZTOL
      CHARACTER (LEN = *), INTENT (OUT) :: OTYPE, RELABS
      LOGICAL,             INTENT (IN)  :: SPLASH 
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMTXT
      PARAMETER (ICOLOR = 9, IX = 30, IY = 4, LSHADE = 1, NUMTXT = 22)
      INTEGER    NUMBLD(NUMTXT)
      DOUBLE PRECISION DVAL, ONE, PNT25, RVAL, TVAL
      PARAMETER (DVAL = 1.0D-04, ONE = 1.0D+00, PNT25 = 0.25D+00,
     +           RVAL = 1.0D+12, TVAL = 10.0D+00)
      DOUBLE PRECISION X02AJF$, X02AMF$
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      CHARACTER (LEN = 13) D13(7), SHOWLJ
      CHARACTER  TEXT(NUMTXT)*100
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   X02AMF$, X02AJF$
      EXTERNAL   PATCH1
      INTRINSIC  SQRT, LOG
      DATA       NUMBLD / NUMTXT*0 /
      E_NUMBERS = E_FORMATS()
      IRELAB = 0
      METH = 2
      MITER = 1
      DTOL = DVAL
      D02TOL = DVAL
      RTOL = RVAL*X02AMF$()
      ENEG = PNT25*LOG(RTOL)
      EPOS = - ENEG
      EPSI = TVAL*X02AJF$()
      ZTOL = SQRT(ONE/RTOL)
      XTOL = - ZTOL
      OTYPE  = 'medium'
      RELABS = 'D'
      IF (SPLASH) THEN
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) RTOL, ENEG, EPOS, EPSI, XTOL, ZTOL, OTYPE,
     +                       DTOL
         ELSE
             D13(1) = SHOWLJ(RTOL)
             D13(2) = SHOWLJ(ENEG)
             D13(3) = SHOWLJ(EPOS)
             D13(4) = SHOWLJ(EPSI)
             D13(5) = SHOWLJ(XTOL)
             D13(6) = SHOWLJ(ZTOL)
             D13(7) = SHOWLJ(DTOL)
             WRITE (TEXT,150) D13(1), D13(2), D13(3), D13(4), D13(5),
     +                                D13(6), OTYPE, D13(7)
         ENDIF  
         NUMBLD(1) = 1
         NUMBLD(13) = 1
         CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                TEXT,
     +                BORDER)
      ENDIF
C
C Format statement
C     
  100 FORMAT (
     + 'Default machine constants, tolerances and methods'
     +/
     +/'Minimum x for safe arithmetic  `',1P,E11.3
     +/'Minimum x allowed in exp(x)    `',1P,E11.3
     +/'Maximum x allowed in exp(x)    `',1P,E11.3
     +/'Minimum x such that 1 + x > 1  `',1P,E11.3
     +/'Minimum evaluated f(x)         `',1P,E11.3
     +/'Maximum evaluated f(x)         `',1P,E11.3
     +/'LBFGSB optimiser precision     `',2X,A
     +/'DVODE solver method            `','BDF, analytic Jacobian'
     +/'TOL for DVODE solver           `',1P,E11.3
     +/
     +/'Advice'
     +/
     +/'Supply your experimental data in sensible units,'
     +/'e.g. -1000 =< x =< 1000, -1000 =< y =< 1000, etc.'
     +/'Scale data and choose parameter start estimates'
     +/'to avoid the above limits,  otherwise numerical'
     +/'problems and failure to converge may result.'
     +/'Be very careful with models that use power laws,'
     +/'exponentiation, etc., which easily lead to over-'
     +/'or under-flow when ([y - f(x)]/s)^2 is evaluated.')
  150 FORMAT (
     + 'Default machine constants, tolerances and methods'
     +/
     +/'Minimum x for safe arithmetic  `',1X,A
     +/'Minimum x allowed in exp(x)    `',1X,A
     +/'Maximum x allowed in exp(x)    `',1X,A
     +/'Minimum x such that 1 + x > 1  `',1X,A
     +/'Minimum evaluated f(x)         `',1X,A
     +/'Maximum evaluated f(x)         `',1X,A
     +/'LBFGSB optimiser precision     `',2X,A
     +/'DVODE solver method            `',' BDF, analytic Jacobian'
     +/'TOL for DVODE solver           `',1X,A
     +/
     +/'Advice'
     +/
     +/'Supply your experimental data in sensible units,'
     +/'e.g. -1000 =< x =< 1000, -1000 =< y =< 1000, etc.'
     +/'Scale data and choose parameter start estimates'
     +/'to avoid the above limits,  otherwise numerical'
     +/'problems and failure to converge may result.'
     +/'Be very careful with models that use power laws,'
     +/'exponentiation, etc., which easily lead to over-'
     +/'or under-flow when ([y - f(x)]/s)^2 is evaluated.')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE TESTPS (ISEND, ISTATE, J, K,
     +                   BL, BU, EPSI, PX, RTOL, T, X,
     +                   LINE)
C
C ACTION: Test parameters for exceeding limits, etc.
C AUTHOR: W.G.Bardsley, University of Manchester, U.K.
C         07/08/2002 extensive revision
C         18/11/2009 extensive revision
C
C ISEND = 1: Set ISTATE(J) before curve fitting as follows:-
C            0 = FIXED, 1 = CONSTRAINED, 2 = POSITIVE, 3 = UNCONSTRAINED
C            T is maximum parameter value and K = - 1 if warnings needed
C
C ISEND = 2: Set ISTATE(J) after curve fitting as follows:-
C            -2 = LOWER, -1 = UPPER
C            K = - 1 if warnings issued, T not used
C
C ISEND = 3: First set NDOF = K and use T = ABS(PAR/STD.ERR.) to get
C            a p-value then K = - 1 if warnings issued
C
C PARAMETERS: XBIG and XSMALL warn when X is too far from 1.0 and FRAC
C             checks if X approaches a limit
C
C Function of K: if a warning is needed then K is returned as -1 with
C LINE = the message required but when ISEND = 3, K = NDOF on entry
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND, J
      INTEGER,             INTENT (INOUT) :: ISTATE, K
      DOUBLE PRECISION,    INTENT (IN)    :: EPSI, RTOL, X
      DOUBLE PRECISION,    INTENT (INOUT) :: BL, BU, PX, T
      CHARACTER (LEN = *), INTENT (OUT)   :: LINE
C
C Locals
C      
      INTEGER    IFAIL, NDOF
      DOUBLE PRECISION XBIG, XSMALL
      PARAMETER (XBIG = 1.0D+03, XSMALL = 1.0D-03)
      DOUBLE PRECISION FRAC
      PARAMETER (FRAC = 0.05D+00)
      DOUBLE PRECISION ZERO, PNT05, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, PNT05 = 0.05D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION ALPHA, BREL, G01EBF$, TREL
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      EXTERNAL   GETRG3, PUTADV
      EXTERNAL   G01EBF$
      INTRINSIC  ABS, DBLE
C
C Action now depends on ISEND = 1, 2 or 3
C
      IF (ISEND.EQ.1) THEN
C
C ISEND = 1: Set ISTATE before fitting
C ====================================
C
         ISTATE = 0
         IF (ABS(X - BL).LE.EPSI .AND. ABS(BU - X).LE.EPSI) THEN
C
C A fixed constant is required so return as follows:
C K = -1 requests output of LINE by the calling subroutine
C ISTATE = 0 to indicate fixed.
C
            BL = X
            BU = X
            PX = X
            K = - 1
            WRITE (LINE,100) J
         ELSE
C
C Check for all possible violations and if found set ISTATE = -3
C
            IF (BL.GT.BU) THEN
               WRITE (LINE,200) J
               ISTATE = - 3
            ELSEIF (X.LT.BL) THEN
               WRITE (LINE,300) J
               ISTATE = - 3
            ELSEIF (X.GT.BU) THEN
               WRITE (LINE,400) J
               ISTATE = - 3
            ELSEIF (X.GT.T) THEN
               WRITE (LINE,500) J, T
               ISTATE = - 3
            ELSEIF (X.LT. - T) THEN
               WRITE (LINE,600) J, - T
               ISTATE = - 3
            ENDIF
C
C If ISTATE = -3 issue the warning then ask for new values
C
            IF (ISTATE.EQ.- 3) THEN
               CALL PUTADV(LINE)
               WRITE (LINE,700) J
               CALL GETRG3 (BL, X, BU,
     +                      LINE)
               LINE = BLANK
            ENDIF
C
C At this stage  BL =< X =< BU so final check for parameter type
C
            K = 1
            IF (ABS(X - BL).LE.EPSI .AND. ABS(BU - X).LE.EPSI) THEN
C
C Fixed: BL = X = BU
C
               ISTATE = 0
               BL = X
               BU = X
               PX = X
               K = - 1
               WRITE (LINE,100) J
            ELSEIF (BL.GT. - T .AND. BU.LT.T) THEN
C
C Constrained: -T < BL < X < BU < T
C
               ISTATE = 1
               PX = X
            ELSEIF (ABS(BL - ZERO).LT.EPSI .AND. BU.GE.T) THEN
C
C Positive: 0 = BL =< X no upper limit
C
               ISTATE = 2
               PX = X
            ELSE
C
C Unconstrained: BL =< X =< BU
C
               ISTATE = 3
               PX = X
            ENDIF
C
C Issue a warning if X is too large or too small
C
            IF (X.GT.T) THEN
               WRITE (LINE,500) J, T
               K = -1
            ELSEIF (X.LT. - T) THEN
               WRITE (LINE,600) J, - T
               K = -1
            ENDIF
         ENDIF
      ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: Check parameters after fitting for approach to limits, etc.
C ======================================================================
C
         IF (ISTATE.EQ.0) THEN
            K = 1
            RETURN
         ELSEIF (ABS(X - BL).LE.EPSI) THEN
            ISTATE = - 2
            K = - 1
            WRITE (LINE,800) J
         ELSEIF (ABS(X - BU).LE.EPSI) THEN
            ISTATE = - 1
            K = - 1
            WRITE (LINE,900) J
         ENDIF
      ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3: Set parameter t values and report ill determined parameters
C ======================================================================
C
         IF (ISTATE.LT.1) RETURN
         NDOF = K
         IF (ISTATE.EQ.1) THEN
            IF (ABS(PX - BL).GT.RTOL .AND. ABS(BU - PX).GT.RTOL) THEN
               BREL = ABS((X - BL)/(PX - BL))
               TREL = ABS((BU - X)/(BU - PX))
               IF (BREL.LE.FRAC) THEN
                  K = - 1
                  WRITE (LINE,1000) J
               ENDIF
               IF (TREL.LE.FRAC) THEN
                  K = - 1
                  WRITE (LINE,1100) J
               ENDIF
            ENDIF
         ENDIF
         IF (ABS(X).GT.XBIG) THEN
            K = - 1
            WRITE (LINE,1200) J, XBIG
         ELSEIF (ABS(X).LT.XSMALL) THEN
            K = - 1
            WRITE (LINE,1300) J, XSMALL
         ENDIF
         IF (T.LE.ZERO) RETURN
         IFAIL = 1
         ALPHA = G01EBF$('Lower-tail', T, DBLE(NDOF), IFAIL)
         IF (IFAIL.NE.0) THEN
            WRITE (LINE,1400) J, IFAIL
            K = -1
            T = ONE
         ELSE
            T = TWO*(ONE - ALPHA)
            IF (T.LT.ZERO) T = ZERO
            IF (T.GT.ONE) T = ONE
            IF (T.GT.PNT05) THEN
               K = - 1
               WRITE (LINE,1500) J
            ENDIF
         ENDIF
      ELSE
C
C ISEND out of range
C ==================
C
         CALL PUTADV('ISEND out of range in call to TESTPS')
      ENDIF
C
C Format statments
C      
  100 FORMAT (1X,'CAUTION : Parameter',I3,' is now a fixed constant')
  200 FORMAT (1X,'*FATAL* : Parameter',I3,1X,'limits are reversed')
  300 FORMAT (1X,'*FATAL* : Parameter',I3,1X,'below lower limit')
  400 FORMAT (1X,'*FATAL* : Parameter',I3,1X,'above upper limit')
  500 FORMAT (' *FATAL* : Parameter',I3,1X,'too large (>',1P,E11.3,')')
  600 FORMAT (' *FATAL* : Parameter',I3,1X,'too small (<',1P,E11.3,')')
  700 FORMAT (
     +'Lower-limit, Start-value, Upper-limit required for parameter',I3)
  800 FORMAT (1X,'WARNING : Parameter',I3,' has reached lower limit')
  900 FORMAT (1X,'WARNING : Parameter',I3,' has reached upper limit')
 1000 FORMAT (1X,'CAUTION : Parameter',I3,' is  near to lower limit')
 1100 FORMAT (1X,'CAUTION : Parameter',I3,' is  near to upper limit')
 1200 FORMAT (1X,'CAUTION : Abs val internal param',I3,' >',1P,E9.2)
 1300 FORMAT (1X,'CAUTION : Abs val internal param',I3,' <',1P,E9.2)
 1400 FORMAT (1X,'WARNING : Parameter',I3,1X,'G01EBF/IFAIL =',I3)
 1500 FORMAT (1X,'CAUTION : Parameter',I3,1X,'is imprecise ... p>0.05')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE VCOVAR (INDEX, ISEND, ISTATE, NFREE, NHESS, NOUT, NP,
     +                   NPAR, NPTS, NUMPOS, NX, NZEROS,
     +                   CORR, CV, DIAGV, EIGVAL, EPSI, ERROR, FACT,
     +                   FJACC, FVAL, G, HESSEX, HESSIN, RNDOF, RTOL,
     +                   SIGMA, THEORY, W2, X, XVAL, YVAL, ZVAL,
     +                   RECORD,
     +                   EQUAL, FREE, STATS)
C
C ACTION : estimate the variance covariance matrix, etc.
C
C When ISEND = 1 estimate the
C Jacobian FJACC at the solution point using QNGRAD. Then form the
C Hessian from Jtranspose*J and invert to get the covariance matrix.
C Complicated code involving ESAVE, FSAVE, XSAV1, XSAV2, YSAVE, ZSAVE
C and NZEROS is required to fool FUNCT1 and the MODEL so that either
C the gradient vector or the Jacobian can be estimated by QNGRAD
C
C When ISEND = 2 estimate the
C eigenvalues of the internal projected Hessian and the correlation
C matrix if required.
C
C AUTHOR  : W. G. Bardsley, UNIVERSITY OF MANCHESTER, U.K., 05/10/1989
C           Now returns STATS = .FALSE. if covariance matrix rank deficient
C           05/03/1999 Added NUMPOS to argument list to keep track of the position
C                      in the data vector when calculating the Jacobian
C           14/08/1999 added call to MATCOR to display correlation matrix
C           03/01/2000 added call to WAITER
C           18/11/2009 extensive revision
C           12/12/2016 inreased correlation coefficients to 5 decimal places 

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND, NHESS, NOUT, NP,
     +                                       NPAR, NX  
      INTEGER,             INTENT (INOUT) :: NFREE, NPTS, NUMPOS, NZEROS
      INTEGER,             INTENT (INOUT) :: INDEX(NX)
      INTEGER,             INTENT (IN)    :: ISTATE(NX)
      DOUBLE PRECISION,    INTENT (IN)    :: EPSI, RNDOF, RTOL
      DOUBLE PRECISION,    INTENT (INOUT) :: CORR(NHESS,NHESS),
     +                                       CV(NHESS,NHESS), DIAGV(NX),
     +                                       EIGVAL(NX), ERROR(NP),
     +                                       FACT(NX), FJACC(NP,NX),
     +                                       FVAL(NP), G(NX),
     +                                       HESSEX(NHESS,NHESS),
     +                                       HESSIN(NHESS,NHESS), 
     +                                       SIGMA, THEORY(NP),
     +                                       W2(3*NX), X(NPAR),
     +                                       XVAL(NP), YVAL(NP),
     +                                       ZVAL(NP)     
      CHARACTER (LEN = *), INTENT (OUT)   :: RECORD(NX,NX)
      LOGICAL,             INTENT (INOUT) :: EQUAL(NP), FREE(NX), STATS
C
C Locals
C      
      INTEGER    I, ICOL, ICOUNT, IFAIL, IROW, J, K, NTEMP, NSAV1, NSAV2
      INTEGER    IADD9
      PARAMETER (IADD9 = 9)
      INTEGER    COLOUR, NSTART, NSTOP
      DOUBLE PRECISION DUMMY, SCALE1, SUM1, TEMP
      DOUBLE PRECISION ESAVE, FSAVE, TSAVE, XSAV1, XSAV2, YSAVE, ZSAVE
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      CHARACTER (LEN = 120) LINE, TEXT(100)
      CHARACTER (LEN = 32 ) EXTRA
      CHARACTER (LEN = 11 ) FRMAT
      CHARACTER (LEN = 9  ) DOTS, PFIXED, D9(10), SHOW09, FORM09
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ', DOTS = '    .....', PFIXED = '    *****')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ACTION, LSAVE, YES, YES4, YES5
      LOGICAL    QNLGLS
      EXTERNAL   E_FORMATS, FORM09, SHOW09
      EXTERNAL   FUNCT1
      EXTERNAL   F02AAF$
      EXTERNAL   QNINV1, QNGRD1, MATCOR, WAITER
      EXTERNAL   PUTWAR, PUTIFA, TABLE1, QNLGLS
      INTRINSIC  ABS, MAX, SQRT, MIN
      IF (.NOT.STATS) RETURN
      E_NUMBERS = E_FORMATS()  
      IF (ISEND.EQ.1) THEN
C
C The covariance matrix ... first save parameters then get the Jacobian
C
         ACTION = .TRUE.
         CALL WAITER (ACTION)
         NSAV1 = NPTS
         NSAV2 = NZEROS
         ESAVE = ERROR(1)
         FSAVE = FVAL(1)
         TSAVE = THEORY(1)
         XSAV1 = XVAL(1)
         XSAV2 = XVAL(2)
         YSAVE = YVAL(1)
         ZSAVE = ZVAL(1)
         LSAVE = EQUAL(2)
         NPTS = 1
         EQUAL(2) = .FALSE.
         YES = .FALSE.
         ICOUNT = 0
C
C The loop to calculate the Jacobian is indexed by NUMPOS but this is
C only required when in MULTI function mode
C
         DO I = 1, NSAV1
            NUMPOS = I
            XVAL(2) = XSAV2
            ERROR(1) = ERROR(I)
            FVAL(1) = FVAL(I)
            XVAL(1) = XVAL(I)
            YVAL(1) = YVAL(I)
            ZVAL(1) = ZVAL(I)
            XVAL(2) = XVAL(I) + ONE
            NZEROS = 0
            IF (ABS(XVAL(1) - ZERO).LE.EPSI) NZEROS = 1
            CALL QNGRD1 (FUNCT1,
     +                   IFAIL, NPAR,
     +                   G, W2, X, 
     +                   YES)
            IF (IFAIL.NE.0) ICOUNT = ICOUNT + 1
            DO J = 1, NPAR
               FJACC(I,J) = G(J)
            ENDDO
         ENDDO
         IF (ICOUNT.GT.0) THEN
            WRITE (LINE,100) ICOUNT
            CALL PUTWAR (LINE)
         ENDIF
C
C Restore the saved parameters
C
         NPTS = NSAV1
         NZEROS = NSAV2
         ERROR(1) = ESAVE
         FVAL(1) = FSAVE
         THEORY(1) = TSAVE
         XVAL(1) = XSAV1
         XVAL(2) = XSAV2
         YVAL(1) = YSAVE
         ZVAL(1) = ZSAVE
         EQUAL(2) = LSAVE
         DO I = 1, NPAR
            DO J = 1, I
               SUM1 = ZERO
               DO K = 1, NPTS
                  SUM1 = SUM1 + FJACC(K,I)*FJACC(K,J)
               ENDDO
               CORR(I,J) = TWO*SUM1
               CORR(J,I) = CORR(I,J)
            ENDDO
         ENDDO
C
C Construct the projected Hessian
C
         NFREE = 0
         DO I = 1, NPAR
            FREE(I) = .FALSE.
            IF (ISTATE(I).GT.0) THEN
                FREE(I) = .TRUE.
                NFREE = NFREE + 1
                INDEX(NFREE) = I
            ENDIF
         ENDDO
         DO I = 1, NFREE
            DO J = 1, I
               DUMMY = CORR(INDEX(I),INDEX(J))
               HESSIN(I,J) = DUMMY/RNDOF
               HESSIN(J,I) = HESSIN(I,J)
               HESSEX(I,J) = DUMMY/(FACT(INDEX(I))*FACT(INDEX(J)))
               HESSEX(J,I) = HESSEX(I,J)
            ENDDO
         ENDDO
C
C Do the matrix inversion
C
         CALL QNINV1 (NHESS, NFREE, NOUT, 
     +                HESSEX, CV)
         STATS = .FALSE.
         SCALE1 = TWO*SIGMA
         DO I = 1, NFREE
            DO J = 1, I
               IF (ABS(ONE - CV(I,J)).GE.EPSI) STATS = .TRUE.
               CV(I,J) = SCALE1*CV(I,J)
               IF (I.NE.J) CV(J,I) = CV(I,J)
            ENDDO
         ENDDO
         ACTION = .FALSE.
         CALL WAITER (ACTION)
C
C Get the diagonal elements
C
         NFREE = 0
         ICOUNT = 0
         DO I = 1, NPAR
            IF (FREE(I)) THEN
               NFREE = NFREE + 1
               DIAGV(I) = CV(NFREE,NFREE)
            ELSE
               DIAGV(I) = ZERO
               IF (ISTATE(I).NE.0) THEN
                  ICOUNT = ICOUNT + 1
                  WRITE (TEXT(ICOUNT),200) I
               ENDIF   
            ENDIF
         ENDDO
         IF (ICOUNT.GT.0) THEN
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            COLOUR = 0
            DO I = 1, ICOUNT
               CALL TABLE1 (COLOUR, TEXT(I))
            ENDDO
            CALL TABLE1 (COLOUR, 'CLOSE')
         ENDIF
C
C Create the correlation matrix
C
         IF (NFREE.GT.1) THEN
            IROW = 0
            DO I = 1, NPAR
               IF (FREE(I)) IROW = IROW + 1
               ICOL = 0
               DO J = 1, I - 1
                  IF (FREE(J)) ICOL = ICOL + 1
                  IF (FREE(I) .AND. FREE(J)) THEN
                     DUMMY = SQRT(ABS(CV(ICOL,ICOL)*CV(IROW,IROW)))
                     CORR(I,J) = CV(IROW,ICOL)/MAX(DUMMY,RTOL)
                     IF (CORR(I,J).LT.- ONE) CORR(I,J) = - ONE
                     IF (CORR(I,J).GT.  ONE) CORR(I,J) =   ONE
                  ELSE
                     CORR(I,J) = ZERO
                  ENDIF
               ENDDO
            ENDDO
C
C Pad out the covariance matrix
C
            IF (NFREE.LT.NPAR) THEN
               DO I = 1, NPAR
                  DO J = 1, I
                     IF (I.EQ.J) THEN
                        CV(J,J) = DIAGV(J)
                     ELSE
                        IF (FREE(I) .AND. FREE(J)) THEN
                           CV(I,J) = CORR(I,J)*SQRT(DIAGV(I)*DIAGV(J))
                        ELSE
                           CV(I,J) = ZERO
                        ENDIF
                        CV(J,I) = CV(I,J)
                     ENDIF
                  ENDDO
               ENDDO
            ENDIF
         ENDIF
      ELSEIF (ISEND.EQ.2) THEN
C
C Display the correlation matrix if required
C
         IF (NFREE.LE.1 .OR. NPAR.LE.1 .OR. .NOT.STATS) RETURN
         NTEMP = 4
         YES4 = QNLGLS (NTEMP) 
         NTEMP = 5
         YES5 = QNLGLS (NTEMP) 
         IF (YES4 .OR. YES5) THEN
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
         ELSE
            RETURN   
         ENDIF   
         IF (YES4) THEN
            DO I = 1, NPAR
               DO J = 1, I - 1
                  IF (FREE(I) .AND. FREE(J)) THEN
                     WRITE (RECORD(I,J),400) CORR(I,J)
                  ELSE
                     WRITE (RECORD(I,J),500) PFIXED
                  ENDIF
               ENDDO
               RECORD(I,I) = DOTS
               DO J = I + 1, NPAR
                  RECORD(I,J) = BLANK
               ENDDO   
            ENDDO
            IF (NFREE.LT.NPAR) THEN
               EXTRA =  '(fixed parameters *)'
            ELSE
               EXTRA =  BLANK
            ENDIF
            WRITE (NOUT,600) BLANK
            WRITE (LINE,700) EXTRA
            IF (NPAR.GT.10) THEN
               YES = .TRUE.
               CALL MATCOR (NX, NPAR, NOUT, 
     +                      RECORD, LINE, 
     +                      YES)
            ELSE
               WRITE (NOUT,600) LINE
C***           COLOUR = 15
C***           CALL TABLE1 (COLOUR, 'OPEN')
               COLOUR = 4
               CALL TABLE1 (COLOUR, LINE)
               COLOUR = 0
               DO I = 1, NPAR
                  WRITE (FRMAT,'(A1,I2,A8)') '(',I,'(1X,A9))'
                  WRITE (LINE,FRMAT) (RECORD(I,J), J = 1, I)
                  WRITE (NOUT,600) LINE
                  CALL TABLE1 (COLOUR, LINE)
               ENDDO
C***           CALL TABLE1 (COLOUR, 'CLOSE')    
            ENDIF  
         ENDIF
C
C Display eigenvalues if required
C
         IF (YES5) THEN
            I = NHESS
            J = NFREE
            IFAIL = 1
            CALL F02AAF$(HESSIN, I, J, EIGVAL, W2, IFAIL)
            IF (IFAIL.NE.0) THEN
               COLOUR = 15
               CALL TABLE1 (COLOUR, 'CLOSE')
               CALL PUTIFA (IFAIL, NOUT, 'F02AAF/VCOVAR')
               RETURN
            ENDIF
C***        COLOUR = 15
C***        CALL TABLE1 (COLOUR, 'OPEN')
            WRITE (TEXT,900)
            WRITE (NOUT,900)
            COLOUR = 4
            DO I = 1, 3
               CALL TABLE1 (COLOUR, TEXT(I))
            ENDDO
            COLOUR = 0
            NSTART = 1
            DO WHILE (NSTART.LE.NFREE)
               NSTOP = MIN(NSTART + IADD9,NFREE)
               IF (E_NUMBERS) THEN
                  WRITE (LINE,1000) (EIGVAL(I), I = NSTART, NSTOP)
                  WRITE (NOUT,1000) (EIGVAL(I), I = NSTART, NSTOP)
               ELSE
                  DO I = NSTART, NSTOP
                     D9(I) = SHOW09(EIGVAL(I))
                  ENDDO   
                  WRITE (LINE,1050) (D9(I), I = NSTART, NSTOP)
                  WRITE (NOUT,1050) (D9(I), I = NSTART, NSTOP)
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
               NSTART = NSTOP + 1
            ENDDO
            IF (EIGVAL(1).GT.RTOL) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,1100) EIGVAL(NFREE)/EIGVAL(1)
                  WRITE (NOUT,1100) EIGVAL(NFREE)/EIGVAL(1)
               ELSE
                  TEMP = EIGVAL(NFREE)/EIGVAL(1)
                  D9(1) = FORM09(TEMP)  
                  WRITE (LINE,1150) D9(1)
                  WRITE (NOUT,1150) D9(1)
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
            ENDIF
C***        CALL TABLE1 (COLOUR, 'CLOSE')
         ENDIF
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'CLOSE')
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     +I4,' nonzero IFAILs from QNGRAD/VCOVAR ... Imprecise gradient')
  200 FORMAT (1X,'WARNING : Ignore Std. err. for parameter',I3)
  400 FORMAT (F9.5)
  500 FORMAT (A9)
  600 FORMAT (A)
  700 FORMAT (1X,'Parameter correlation matrix',1X,A)
  900 FORMAT (/1X,'Eigenvalues of internal Hessian matrix'/)
 1000 FORMAT (1P,10E11.3)
 1050 FORMAT (1P,10(1X,A9))
 1100 FORMAT (1X,'Condition number =',1P,E11.3)
 1150 FORMAT (1X,'Condition number =',1X,A9)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE WEIGHT (ISEND, NOUT, NPTS,
     +                   AWT, BWT, CWT, ERROR, ERRSAV, THEORY,
     +                   SUPPLY)
C
C ACTION : Weights for data during re-fitting
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 22/05/1996
C
C ADVICE : ISEND = 1: Ask what to do or re-define AWT, BWT, CWT
C          ISEND = 2: Define ERROR using THEORY if SUPPLY = .TRUE.
C          ISEND = 3: Restore ERROR to original value if SUPPLY = .TRUE.
C
C          Note that AWT, BWT and CWT must be defined before this
C          routine is called with ISEND = 1 or 2 and they must be
C          saved externally. SUPPLY must also be initialised/saved.
C          ERROR and THEORY also must be defined when ISEND = 2 and
C          they should also be saved.
C
C          The call with ISEND = 1 is when re-entering from current
C          parameters has been selected. If calculated weights are
C          requested then the old errors are saved as ERRSAV. Call
C          with ISEND = 2 is from QMODEL and is only effective if
C          SUPPLY is .TRUE. Call with ISEND = 3 is for after curve
C          fitting and goodness of fit but before further action.
C          06/11/1997 altered to use A + [B*y]**C
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ISEND, NOUT, NPTS
      DOUBLE PRECISION, INTENT (INOUT) :: AWT, BWT, CWT, ERROR(NPTS),
     +                                    ERRSAV(NPTS), THEORY(NPTS)      
      LOGICAL,          INTENT (INOUT) :: SUPPLY
C
C Locals
C      
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 5,
     +           NSTART = 7, NTEXT = 11)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    I
      DOUBLE PRECISION EPSI, ZERO
      PARAMETER (EPSI = 1.0D-40, ZERO = 0.0D+00)
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01, GETDGE, PUTADV
      INTRINSIC  ABS, SQRT
      DATA       NUMBLD / 5*1, 6*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Action only if ISEND = 1, 2 or 3
C
      IF (ISEND.EQ.1) THEN
C
C Decide what to do next
C
   20    CONTINUE
         WRITE (TEXT,100) AWT, EPSI, BWT, ZERO, CWT, ZERO
         NUMDEC = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.EQ.1) THEN
C
C Use existing s from file
C
            SUPPLY = .FALSE.
            RETURN
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Use calculated weights so save old errors
C
            SUPPLY = .TRUE.
            DO I = 1, NPTS
               ERRSAV(I) = ERROR(I)
            ENDDO
            WRITE (NOUT,200) AWT, BWT, CWT
            RETURN
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Re-set value for AWT
C
            WRITE (LINE,300) 'A', AWT
            CALL GETDGE (AWT, EPSI,
     +                   LINE)
            GOTO 20
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Re-set value for BWT
C
            WRITE (LINE,300) 'B', BWT
            CALL GETDGE (BWT, ZERO,
     +                   LINE)
            GOTO 20
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Re-set value for CWT
C
            WRITE (LINE,300) 'C', CWT
            CALL GETDGE (CWT, ZERO,
     +                   LINE)
            GOTO 20
         ENDIF
      ELSEIF (ISEND.EQ.2) THEN
C
C Calculate new weights if SUPPLY = .TRUE. Then re-set SUPPLY = .FALSE.
C

         IF (SUPPLY) THEN
            DO I = 1, NPTS
               ERROR(I) = SQRT(AWT + ABS(BWT*THEORY(I))**CWT)
            ENDDO
         ENDIF
         RETURN
      ELSEIF (ISEND.EQ.3) THEN
         IF (SUPPLY) THEN
            DO I = 1, NPTS
               ERROR(I) = ERRSAV(I)
            ENDDO
            SUPPLY = .FALSE.
            WRITE (NOUT,400)
            CALL PUTADV ('Original s-values have now been restored')
         ENDIF
         RETURN
      ELSE
         CALL PUTADV('ISEND must be 1, 2 or 3 in WEIGHT')
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'The current values for A, B and C in the weight function'
     +/'s^2 = A + |B*best-fit-function-value|^C are:'
     +/'A =',1P,E10.3,' (Must be >=',E10.3,')'
     +/'B ='   ,E10.3,' (Must be >=',E10.3,')'
     +/'C ='   ,E10.3,' (Must be >=',E10.3,')'
     +/
     +/'Use s values from data file'
     +/'Use s values from:- A, B, C'
     +/'Change current value for A'
     +/'Change current value for B'
     +/'Change current value for C')
  200 FORMAT (/' s-values will now be calculated: A =',1P,E10.3,
     +', B =',E10.3,', C =',E10.3)
  300 FORMAT ('New value for',1X,A1,', Current value =',1P,E10.3)
  400 FORMAT (/' Original s-values have now been restored')
      END
C
C
