C
C
C QNFIT06.INS
C ===========
C These subroutines do not include MODULE_QNFIT
C
C Contains ... ZMAREA ... Area
C              ZMCALI ... Calibrate
C              ZMCBOX ... Dedicated check box    
C              ZMDERI ... Derivatives
C              ZMEVAL ... Evaluate
C              ZMFUNC ... Function for ZMCALI
C----------------------------------------------------------------------
C
      SUBROUTINE ZMAREA (N, NOUT, NP, NPTS, NX, NZEROS,
     +                   EPSI, P, THEORY, V, W, XMAX, XMIN, XVAL,
     +                   YVAL,
     +                   DEQN, EQSAV, EQUAL)
C
C ACTION: Estimate area
C         18/11/2009 edited
C         09/11/2016 edited
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N, NOUT, NP, NX
      INTEGER,          INTENT (INOUT) :: NPTS, NZEROS
      DOUBLE PRECISION, INTENT (IN)    :: EPSI, P(NX), XMAX, XMIN
      DOUBLE PRECISION, INTENT (INOUT) :: THEORY(NP), V(NP), W(NP), 
     +                                    XVAL(NP), YVAL(NP)  
      LOGICAL,          INTENT (IN)    :: DEQN     
      LOGICAL,          INTENT (INOUT) :: EQSAV(NP), EQUAL(NP)
C
C Locals
C      
      INTEGER    N3
      PARAMETER (N3 = 3)
      INTEGER    I, NDIV, NSAV, NUMDEC, NZSAV
      INTEGER    NUMOPT, NUMSTA, NUMTXT
      PARAMETER (NUMOPT = 5, NUMSTA = 3, NUMTXT = NUMSTA + NUMOPT - 1)
      INTEGER    NUMBLD(NUMTXT)
      DOUBLE PRECISION AREA, DELTA, XASAV, XBSAV, XSTART, XSTOP
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 13 ) D13(4), SHOWLJ
      CHARACTER (LEN = 12 ) FORM12, I12
      CHARACTER (LEN = 100) LINE, TEXT(30)
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   SIMSON, PUTADV, GETDG2, GETJM1, LSTBOX
      EXTERNAL   QMODEL
      INTRINSIC  ABS, DBLE, TRIM
      SAVE       NDIV, XASAV, XBSAV
      DATA       NDIV / 101 /
      DATA       XASAV, XBSAV / 0.0D+00, 1.0D+00 /
      DATA       NUMBLD / NUMTXT*0 /
C
C Check
C
      IF (XMAX.LE.XMIN) THEN
         CALL PUTADV ('XMAX =< XMIN')
         RETURN
      ENDIF
      IF (DEQN .AND. XMIN.LT.ZERO) THEN
         CALL PUTADV ('Differential equations require t >= 0')
         RETURN
      ENDIF
      E_NUMBERS = E_FORMATS()
C
C Save the current data
C
      NSAV = NPTS
      DO I = 1, NSAV
         V(I) = XVAL(I)
         W(I) = YVAL(I)
         EQSAV(I) = EQUAL(I)
      ENDDO
      IF (DEQN) NZSAV = NZEROS
      WRITE (NOUT,'(A)') ' '  
   20 CONTINUE
      IF (E_NUMBERS) THEN
         WRITE (TEXT,100) XMIN, XMAX, XASAV, XBSAV, NDIV
      ELSE
         D13(1) = SHOWLJ(XMIN)
         D13(2) = SHOWLJ(XMAX)
         D13(3) = SHOWLJ(XASAV)
         D13(4) = SHOWLJ(XBSAV)
         I12 = FORM12(NDIV)
         WRITE (TEXT,150) TRIM(D13(1)), TRIM(D13(2)), TRIM(D13(3)),
     +                    TRIM(D13(4)), TRIM(I12)
      ENDIF  
      NUMDEC = 1
      NUMBLD(1) = 4
      CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +             TEXT)
      NUMBLD(1) = 0
      IF (NUMDEC.LE.2) THEN
         IF (NUMDEC.EQ.1) THEN
            XSTART = XMIN
            XSTOP = XMAX
         ELSE
            XSTART = XASAV
            XSTOP = XBSAV
         ENDIF
         DELTA = (XSTOP - XSTART)/(DBLE(NDIV) - ONE)
         IF (DELTA.LT.EPSI) THEN
            CALL PUTADV ('Range A to B is too small')
            GOTO 20
         ENDIF
         XVAL(1) = XSTART
         XVAL(NDIV) = XSTOP
         EQUAL(1) = .FALSE.
         EQUAL(NDIV) = .FALSE.
         DO I = 2, NDIV - 1
            XVAL(I) = XVAL(I - 1) + DELTA
            EQUAL(I) = .FALSE.
         ENDDO
         NPTS = NDIV
         IF (DEQN) THEN
            IF (XVAL(1).LT.ZERO) THEN
               CALL PUTADV ('Differential equations require t >= 0')
               GOTO 20
            ENDIF
            XVAL(NDIV + 1) = XVAL(NDIV) + ONE
            IF (ABS(XVAL(1)).LE.EPSI) THEN
               NZEROS = 1
            ELSE
               NZEROS = 0
            ENDIF
         ENDIF
         CALL QMODEL (N,
     +                P)
         CALL SIMSON (NDIV, 
     +                AREA, XSTART, XSTOP, THEORY)
         IF (E_NUMBERS) THEN
            WRITE (LINE,200) XSTART, XSTOP, AREA 
         ELSE
            D13(1) = SHOWLJ(XSTART)
            D13(2) = SHOWLJ(XSTOP)
            D13(3) = SHOWLJ(AREA)
            I12 = FORM12(NDIV)
            WRITE (LINE,250) TRIM(D13(1)), TRIM(D13(2)), TRIM(I12), 
     +                       D13(3) 
         ENDIF 
         WRITE (NOUT,'(A)') LINE 
         CALL PUTADV (LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.3) THEN
         IF (E_NUMBERS) THEN
            WRITE (LINE,300) XASAV, XBSAV
         ELSE
            D13(1) = SHOWLJ(XASAV)
            D13(2) = SHOWLJ(XBSAV)
            WRITE (LINE,350) TRIM(D13(1)), TRIM(D13(2)) 
         ENDIF  
         CALL GETDG2 (XASAV, XBSAV,
     +                LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.4) THEN
         I12 = FORM12(NDIV)
         WRITE (LINE,400) TRIM(I12)
         CALL GETJM1 (N3, NDIV, NP,
     +                LINE)
         NDIV = (NDIV - 1)/2
         NDIV = 2*NDIV + 1
         GOTO 20
      ENDIF
C
C Restore the current data
C
      NPTS = NSAV
      DO I = 1, NPTS
         XVAL(I) = V(I)
         YVAL(I) = W(I)
         EQUAL(I) = EQSAV(I)
      ENDDO
      IF (DEQN) THEN
         NZEROS = NZSAV
         XVAL(NPTS + 1) = XVAL(NPTS) + ONE
         EQUAL(NPTS + 1) = .FALSE.
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Calculating the area under a curve (AUC)'
     +/
     +/'AUC over current range of data',1P,E13.5,',',E13.5
     +/'AUC over a chosen range A to B',   E13.5,',',E13.5
     +/'Change the chosen range A to B'
     +/'Change number of Simpson rule points (current =',I5,')'
     +/'Cancel')
  150 FORMAT (
     + 'Calculating the area under a curve (AUC)'
     +/
     +/'AUC over current range of data',2X,'(',A,',',2X,A,')'
     +/'AUC over a chosen range A to B',2X,'(',A,',',2X,A,')'
     +/'Change the chosen range A to B'
     +/'Change number of Simpson rule points (current =',1X,A,')'
     +/'Cancel')     
  200 FORMAT ('A =',1P,E13.5,', B =',E13.5,', Area =',E13.5)
  250 FORMAT (
     +'A =',1X,A,', B =',1X,A,', Simpson N =',1X,A,', Area =',1X,A)
  300 FORMAT (
     +'Range A, B required A < B (current =',1P,E13.5,',',E13.5,')')
  350 FORMAT (
     +'Range A, B required A < B (current =',1X,A,',',1X,A,')')     
  400 FORMAT ('Number of Simpson x-points required (current =',1X,A,')')
      END
C
C---------------------------------------------------------------------------------------
C
      SUBROUTINE ZMCBOX (ISEND)
C
C ACTION : Dedicated check box for vector input method
C AUTHOR : W. G. Bardlsey, universioty of manchester, u.k. 09/11/2016           
C
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER, INTENT (INOUT) :: ISEND 
C
C Locals
C 
       INTEGER NUMOPT, NUMSTA, NUMTXT
       CHARACTER (LEN = 100) TEXT(30)
       EXTERNAL RBOX02
       WRITE (TEXT,100)
       NUMOPT = 4
       NUMSTA = 5
       NUMTXT = 12
       CALL RBOX02 (ISEND, NUMOPT, NUMSTA, NUMTXT,
     +              TEXT)
  100 FORMAT (
     + 'Providing data for evaluation/derivatives/calibration'
     +/'.'
     +/'You must provide a column vector to proceed further'
     +/'.'
     +/'Type in data interactively (now)'
     +/'Input values from a file (now)'
     +/'Type in data interactively (from now on)'
     +/'Input values from a file (from now on)' 
     +/'.'
     +/'Your choice is specifically for this procedure this time.'
     +/'In other words, choosing one of the last two options will'
     +/'only remain as the active option during the current run')
      END           
C
C----------------------------------------------------------------------
C
      SUBROUTINE ZMCALI (NIN, NOUT, NPAR, NPTS, NW, NZEROS,
     +                   EPSI, THEORY, W, X, XMAX, XMIN, XVAL,
     +                   DEQN, EQUAL)
C
C ACTION : Solve the eqn. W(X) - CONST. = 0.0 using C05AZF
C          Subroutine required by program QNFIT
C          Requires function ZMFUNC
C AUTHOR : W. G. Bardsley, University of Manchester, U.K. 13/02/1995
C          18/11/2009 edited
C          09/11/2016 edited
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NIN, NOUT, NPAR, NW
      INTEGER,          INTENT (INOUT) :: NPTS, NZEROS
      DOUBLE PRECISION, INTENT (IN)    :: EPSI, XMAX, XMIN
      DOUBLE PRECISION, INTENT (INOUT) :: THEORY(1), W(NW), X(NPAR),
     +                                    XVAL(2)      
      LOGICAL,          INTENT (IN)    :: DEQN
      LOGICAL,          INTENT (INOUT) :: EQUAL(2)
C
C Locals
C      
      INTEGER    I, ISEND, ISFIX, IFAIL, IND, IR, NSAV, NZSAV
      INTEGER    NCALIB
      INTEGER    COLOUR
      INTEGER    ICOLOR
      INTEGER    NBOT, NTOP
      PARAMETER (NBOT = 0, NTOP = 250)
      DOUBLE PRECISION TSAV, XSAV1, XSAV2, X1, X2
      DOUBLE PRECISION RELERR
      PARAMETER (RELERR = 1.0D-04)
      DOUBLE PRECISION C(17)
      DOUBLE PRECISION FX, ZMFUNC, F1, F2, TOLX
      CHARACTER (LEN = 100) LINE, TEXT(30)
      CHARACTER (LEN = 13 ) D13(2), SHOWLJ
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, ESAV1, ESAV2
      LOGICAL    FIXNPT, LABEL
      PARAMETER (FIXNPT = .FALSE., LABEL = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   C05AZF$
      EXTERNAL   TABLE1, VEC1IN, GETJM1, GETVEC
      EXTERNAL   ZMFUNC, ZMCBOX
      DATA       ISEND, ISFIX, NCALIB / 3, 0, 3 /
      E_NUMBERS = E_FORMATS()
C
C Get the prediction data
C
      IF (ISFIX.EQ.0) THEN
         CALL ZMCBOX (ISEND)
         IF (ISEND.EQ.3) THEN
            ISFIX = 1
            ISEND = 1
         ELSEIF (ISEND.EQ.4) THEN
            ISFIX = 2
            ISEND = 2
         ENDIF      
      ENDIF 
      TEXT(1) = BLANK
      TEXT(2) = BLANK
      IF (ISEND.EQ.1) THEN
         CALL GETJM1 (NBOT, NCALIB, NTOP,
     +'How many values do you want to input')
         IF (NCALIB.LT.1) RETURN
         CALL GETVEC (NCALIB,
     +                W,
     +               'Press Enter after typing in each value')
      ELSE             
         CALL VEC1IN (ISEND, NIN, NW, NCALIB,
     +                W, TEXT(1), TEXT(2),
     +                ABORT, FIXNPT, LABEL)
         IF (ABORT .OR. NCALIB.LT.1) RETURN
      ENDIF     
      WRITE (NOUT,'(A)') BLANK
C
C Store parameters
C
       NSAV = NPTS
       NPTS = 1
       IF (DEQN) NZSAV = NZEROS
       TSAV = THEORY(1)
       XSAV1 = XVAL(1)
       XSAV2 = XVAL(2)
       ESAV1 = EQUAL(1)
       ESAV2 = EQUAL(2)
       EQUAL(1) = .FALSE.
       EQUAL(2) = .FALSE.
C
C Attempt calibration
C
      IF (TEXT(1).NE.BLANK .OR. TEXT(2).NE.BLANK) THEN
         WRITE (NOUT,'(A)') BLANK
         WRITE (NOUT,'(A)') 'Source of calibration data:'
         IF (TEXT(1).NE.BLANK) WRITE (NOUT,'(A)') TEXT(1)
         IF (TEXT(2).NE.BLANK) WRITE (NOUT,'(A)') TEXT(2)
         WRITE (NOUT,'(A)') BLANK
      ENDIF
      COLOUR = 15
      CALL TABLE1 (COLOUR, 'OPEN')
      COLOUR = 0
      DO I = 1, NCALIB
         ABORT = .TRUE.
         X1 = XMIN
         X2 = XMAX
         F1 = ZMFUNC(NPAR, NZEROS,
     +               EPSI, THEORY, X, X1, XVAL, W(I),
     +               DEQN)
         F2 = ZMFUNC(NPAR, NZEROS,
     +               EPSI, THEORY, X, X2, XVAL, W(I),
     +               DEQN)
         IF (F1*F2.GT.0.0) GOTO 60
         TOLX = RELERR
         IR = 2
         IND = 1
         IFAIL = 1
   20    CONTINUE
         CALL C05AZF$(X1, X2, FX, TOLX, IR, C, IND, IFAIL)
         IF (IND.EQ.0) GOTO 40
         IF (IND.LT.2 .OR. IND.GT.4) GOTO 60
         FX = ZMFUNC(NPAR, NZEROS,
     +               EPSI, THEORY, X, X1, XVAL, W(I),
     +               DEQN)
         GOTO 20
   40    CONTINUE
         IF (IFAIL.EQ.0) ABORT = .FALSE.
   60    CONTINUE
         IF (ABORT) THEN
            ICOLOR = 4
            IF (E_NUMBERS) THEN 
               WRITE (LINE,100) W(I)
               WRITE (NOUT,100) W(I)
            ELSE
               D13(1) = SHOWLJ(W(I))
               WRITE (LINE,150) D13(1)  
               WRITE (NOUT,150) D13(1)  
            ENDIF  
         ELSE
            ICOLOR = 0
            IF (E_NUMBERS) THEN 
               WRITE (LINE,200) W(I), X1
               WRITE (NOUT,200) W(I), X1
            ELSE
               D13(1) = SHOWLJ(W(I))
               D13(2) = SHOWLJ(X1)
               WRITE (LINE,250) D13(1), D13(2)
               WRITE (NOUT,250) D13(1), D13(2)
            ENDIF  
         ENDIF
         CALL TABLE1 (ICOLOR, LINE)
      ENDDO
      CALL TABLE1 (COLOUR, 'CLOSE')
C
C Restore parameters
C
      NPTS = NSAV
      IF (DEQN) NZEROS = NZSAV
      XVAL(1) = XSAV1
      XVAL(2) = XSAV2
      THEORY(1) = TSAV
      EQUAL(1) = ESAV1
      EQUAL(2) = ESAV2
C
C Format statements
C      
  100 FORMAT (1X,'y =',1P,E13.5,', x = ? (failure, e.g. out of range)')
  150 FORMAT (1X,'y =',1X,A13,'  x = ? (failure, e.g. out of range)')
  200 FORMAT (1X,'y =',1P,E13.5,', x =',E13.5)
  250 FORMAT (1X,'y =',1X,A13,'  x =',1X,A13)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ZMDERI (NGRAF, NIN, NOUT, NP, NPTS, NUMX, NZEROS,
     +                   EPSI, RTOL, THEORY, V, W, X, XMAX, XMIN, XVAL,
     +                   YMAX, YMIN,
     +                   DEQN, EQUAL)
C
C ACTION : Evaluate dy/dx
C          Subroutine required by program QNFIT
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,14/02/1995
C          18/11/2009 edited
C          09/11/2016 edited
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NGRAF, NIN, NOUT, NP, NUMX
      INTEGER,          INTENT (INOUT) :: NPTS, NZEROS
      DOUBLE PRECISION, INTENT (IN)    :: EPSI, RTOL, XMAX, XMIN, YMAX, 
     +                                    YMIN
      DOUBLE PRECISION, INTENT (INOUT) :: THEORY(*), V(NP), W(NP),
     +                                    X(NUMX), XVAL(2)      
      LOGICAL,          INTENT (IN)    :: DEQN
      LOGICAL,          INTENT (INOUT) :: EQUAL(2)
C
C Locals
C      
      INTEGER    I, ISEND, ISFIX, NSAV, NZSAV
      INTEGER    NDERIV
      INTEGER    COLOUR
      INTEGER    ICOLOR, JCOLOR, IXL, IYL, LSHADE
      PARAMETER (JCOLOR = 3, IXL = 4, IYL = 4, LSHADE = 0)
      INTEGER    NUMDEC, NUMOPT, NUMSTA, NUMTXT
      PARAMETER (NUMOPT = 4, NUMSTA = 3, NUMTXT = NUMSTA + NUMOPT - 1)
      INTEGER    NUMBLD(NUMTXT)
      INTEGER    N1, N2
      PARAMETER (N1 = 1, N2 = 2)
      INTEGER    L1, L0, M1, M0
      PARAMETER (L1 = 1, L0 = 0, M1 = 4, M0 = 0)
      INTEGER    NBOT, NTOP
      PARAMETER (NBOT = 0, NTOP = 250) 
      DOUBLE PRECISION TSAV, XSAV1, XSAV2
      DOUBLE PRECISION DELTAX, DYDX, FX, FXPH, H
      DOUBLE PRECISION DXBIG, DXLIT, DYBIG, DYFIN, DYINI, DYLIT
      DOUBLE PRECISION XDIFF, XTEMP(N2), YTEMP(N2)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 100) LINE, TEXT(30)
      CHARACTER (LEN = 60 ) PTITLE
      CHARACTER (LEN = 13 ) D13(8), SHOWLJ
      CHARACTER (LEN = 10 ) D10(2), FORMGR
      CHARACTER (LEN = 6  ) YTITLE
      CHARACTER (LEN = 1  ) BLANK, XTITLE
      PARAMETER (BLANK = ' ', XTITLE = 'x', YTITLE = 'dy/dx')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ESAV1, ESAV2
      LOGICAL    ABORT, FIXNPT, LABEL
      PARAMETER (FIXNPT = .FALSE., LABEL = .TRUE.)
      EXTERNAL   E_FORMATS, FORMGR, SHOWLJ
      EXTERNAL   TABLE1, VEC1IN, GETDM1, GKS004, LSTBOX, PATCH1
      EXTERNAL   QMODEL, ZMCBOX, GETJM1, GETVEC
      INTRINSIC  ABS, DBLE, TRIM
      SAVE       DELTAX
      DATA       DELTAX / 1.0D-06 /
      DATA       NUMBLD / NUMTXT*0 /
      DATA       ISEND, ISFIX, NDERIV / 3, 0, 3 /
      E_NUMBERS = E_FORMATS()
C
C Save parameters
C
      NSAV = NPTS
      NPTS = 1
      IF (DEQN) NZSAV = NZEROS
      TSAV = THEORY(1)
      XSAV1 = XVAL(1)
      XSAV2 = XVAL(2)
      ESAV1 = EQUAL(1)
      ESAV2 = EQUAL(2)
      EQUAL(1) = .FALSE.
      EQUAL(2) = .FALSE.
C
C Set the step size
C
      WRITE (NOUT,'(A)') BLANK
   20 CONTINUE
      H = DELTAX*(XMAX - XMIN)
      IF (H.LT.RTOL) H = RTOL
      NUMDEC = 1
      NUMBLD(1) = 4
      WRITE (TEXT,100) DELTAX
      CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT, 
     +             TEXT)
      NUMBLD(1) = 0
      IF (NUMDEC.EQ.1) THEN
C
C Get the derivative data
C
         IF (ISFIX.EQ.0) THEN
            CALL ZMCBOX (ISEND)
            IF (ISEND.EQ.3) THEN
               ISFIX = 1
               ISEND = 1
            ELSEIF (ISEND.EQ.4) THEN
               ISFIX = 2
               ISEND = 2
            ENDIF      
         ENDIF 
         TEXT(1) = BLANK
         TEXT(2) = BLANK
         IF (ISEND.EQ.1) THEN
            CALL GETJM1 (NBOT, NDERIV, NTOP,
     +'How many values do you want to input')
            IF (NDERIV.LT.1) GOTO 20
            CALL GETVEC (NDERIV,
     +                   W,
     +                  'Press Enter after typing in each value')
            
         ELSE             
            CALL VEC1IN (ISEND, NIN, NP, NDERIV,
     +                   W, TEXT(1), TEXT(2),
     +                   ABORT, FIXNPT, LABEL)
            IF (ABORT .OR. NDERIV.LT.1) GOTO 20
         ENDIF     
C
C Attempt estimation of dy/dx
C
         IF (TEXT(1).NE.BLANK .OR. TEXT(2).NE.BLANK) THEN
            WRITE (NOUT,'(A)') BLANK
            WRITE (NOUT,'(A)') 'Source of slope (dy/dx) data:'
            IF (TEXT(1).NE.BLANK) WRITE (NOUT,'(A)') TEXT(1)
            IF (TEXT(2).NE.BLANK) WRITE (NOUT,'(A)') TEXT(2)
            WRITE (NOUT,'(A)') BLANK
         ENDIF
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         DO I = 1, NDERIV
            XVAL(1) = W(I)
            IF (DEQN) THEN
               IF (ABS(W(I)).LT.EPSI) THEN
                  NZEROS = 1
              ELSE
                  NZEROS = 0
               ENDIF
               XVAL(2) = XVAL(1) + ONE
            ENDIF
            CALL QMODEL (NUMX, X)
            FX = THEORY(1)
            XVAL(1) = XVAL(1) + H
            IF (DEQN) THEN
               IF (ABS(W(I)).LT.EPSI) THEN
                  NZEROS = 1
              ELSE
                  NZEROS = 0
               ENDIF
               XVAL(2) = XVAL(1) + ONE
            ENDIF
            CALL QMODEL (NUMX, X)
            FXPH = THEORY(1)
            XVAL(1) = W(I)
            DYDX = (FXPH - FX)/H
            IF (W(I).LT.XMIN .OR. W(I).GT.XMAX) THEN
               ICOLOR = 4
               IF (E_NUMBERS) THEN
                  WRITE (LINE,200) W(I), DYDX
               ELSE
                  D13(1) = SHOWLJ(W(I))
                  D13(2) = SHOWLJ(DYDX)
                  WRITE (LINE,250) D13(1), D13(2)
               ENDIF  
               WRITE (NOUT,'(A)') LINE
            ELSEIF (FX.LT.YMIN .OR. FX.GT.YMAX) THEN
               ICOLOR = 1
               IF (E_NUMBERS) THEN
                  WRITE (LINE,300) W(I), DYDX
               ELSE
                  D13(1) = SHOWLJ(W(I))
                  D13(2) = SHOWLJ(DYDX)
                  WRITE (LINE,350) D13(1), D13(2) 
               ENDIF  
               WRITE (NOUT,'(A)') LINE
            ELSE
               ICOLOR = 0
               IF (E_NUMBERS) THEN
                  WRITE (LINE,400) W(I), DYDX
               ELSE
                  D13(1) = SHOWLJ(W(I))
                  D13(2) = SHOWLJ(DYDX)
                  WRITE (LINE,450) D13(1), D13(2)  
               ENDIF  
               WRITE (NOUT,'(A)') LINE
            ENDIF
            CALL TABLE1 (ICOLOR, LINE)
         ENDDO
         CALL TABLE1 (COLOUR, 'CLOSE')
         GOTO 20
      ELSEIF (NUMDEC.EQ.2) THEN
C
C Plot dy/dx
C
         XDIFF = (XMAX - XMIN)/(DBLE(NGRAF) - ONE)
         W(1) = XMIN
         W(NGRAF) = XMAX
         DO I = 2, NGRAF - 1
            W(I) = W(I - 1) + XDIFF
         ENDDO
         DO I = 1, N2
            XTEMP(I) = ZERO
            YTEMP(I) = ZERO
         ENDDO
         DXBIG = XVAL(1)
         DXLIT = XVAL(1)
         DYBIG = - ONE/RTOL
         DYLIT = ONE/RTOL
         DO I = 1, NGRAF
            XVAL(1) = W(I)
            IF (DEQN) THEN
               IF (ABS(W(I)).LT.EPSI) THEN
                  NZEROS = 1
               ELSE
                  NZEROS = 0
               ENDIF
               XVAL(2) = XVAL(1) + ONE
            ENDIF
            CALL QMODEL (NUMX, X)
            FX = THEORY(1)
            XVAL(1) = XVAL(1) + H
            IF (DEQN) THEN
               IF (ABS(W(I)).LT.EPSI) THEN
                  NZEROS = 1
               ELSE
                  NZEROS = 0
               ENDIF
               XVAL(2) = XVAL(1) + ONE
            ENDIF
            CALL QMODEL (NUMX, X)
            FXPH = THEORY(1)
            V(I) = (FXPH - FX)/H
            IF (I.EQ.1) THEN
               DYINI = V(I)
            ELSEIF (I.EQ.NGRAF) THEN
               DYFIN = V(I)
            ENDIF
            IF (V(I).GT.DYBIG) THEN
               DXBIG = W(I)
               DYBIG = V(I)
            ENDIF
            IF (V(I).LT.DYLIT) THEN
               DXLIT = W(I)
               DYLIT = V(I)
            ENDIF
         ENDDO
         IF (E_NUMBERS) THEN 
            WRITE (PTITLE,500) DYBIG, DXBIG
         ELSE
            D10(1) = FORMGR(DYBIG)
            D10(2) = FORMGR(DXBIG)  
            WRITE (PTITLE,525) TRIM(D10(1)), D10(2)  
         ENDIF 
         IF (E_NUMBERS) THEN  
            WRITE (NOUT,550) DYBIG, DXBIG
         ELSE
            D13(1) = SHOWLJ(DYBIG)
            D13(2) = SHOWLJ(DXBIG)
            WRITE (NOUT,575) D13(1), D13(2)
         ENDIF  
         XTEMP(1) = DXBIG
         YTEMP(1) = DYBIG
         CALL GKS004 (L1, L0, L0, L0,
     +                M0, M1, M0, M0,
     +                NGRAF, N1, N2, N2,
     +                W, XTEMP, XTEMP, XTEMP,
     +                V, YTEMP, YTEMP, YTEMP,
     +                PTITLE, XTITLE, YTITLE,
     +                LABEL, LABEL)
         IF (E_NUMBERS) THEN
            WRITE (NOUT,600) DYINI, XMIN, DYFIN, XMAX, DYLIT, DXLIT,
     +                       DYBIG, DXBIG
            WRITE (TEXT,600) DYINI, XMIN, DYFIN, XMAX, DYLIT, DXLIT,
     +                       DYBIG, DXBIG
         ELSE
            D13(1) = SHOWLJ(DYINI)
            D13(2) = SHOWLJ(XMIN)
            D13(3) = SHOWLJ(DYFIN)
            D13(4) = SHOWLJ(XMAX)
            D13(5) = SHOWLJ(DYLIT)
            D13(6) = SHOWLJ(DXLIT)
            D13(7) = SHOWLJ(DYBIG)
            D13(8) = SHOWLJ(DXBIG)
            WRITE (NOUT,650) D13(1), D13(2), D13(3), D13(4),
     +                       D13(5), D13(6), D13(7), D13(8)             
            WRITE (TEXT,650) D13(1), D13(2), D13(3), D13(4),
     +                       D13(5), D13(6), D13(7), D13(8)    
         ENDIF  
         CALL PATCH1 (JCOLOR, IXL, IYL, LSHADE, NUMBLD, NUMOPT,
     +                TEXT, FIXNPT)
         GOTO 20
      ELSEIF (NUMDEC.EQ.3) THEN
C
C Change fraction used to calculate h
C
         IF (E_NUMBERS) THEN
            WRITE (LINE,700) DELTAX
         ELSE
            D13(1) = SHOWLJ(DELTAX)  
            WRITE (LINE,750) D13(1)  
         ENDIF  
         CALL GETDM1 (1.0D+04*RTOL, DELTAX, ONE,
     +                LINE)
         GOTO 20
      ENDIF
C
C Restore parameters
C
      NPTS = NSAV
      IF (DEQN) NZEROS = NZSAV
      THEORY(1) = TSAV
      XVAL(1) = XSAV1
      XVAL(2) = XSAV2
      EQUAL(1) = ESAV1
      EQUAL(2) = ESAV2
C
C Format statements
C      
  100 FORMAT (
     + 'Calculating best-fit curve derivatives'
     +/
     +/'Estimate dy/dx from x-values (user inputs x)'
     +/'Plot dy/dx on the range of x (max/min slope)'
     +/'Alter step size h = epsi*range in dy/dx (epsi =',1P,E13.5,')'
     +/'Cancel')
  200 FORMAT (
     +1X,'x =',1P,E13.5,', dy/dx =',E13.5,', x out of data range')
  250 FORMAT (
     +1X,'x =',1X,A13,' dy/dx =',1X,A13,' (x out of data range)')   
  300 FORMAT (
     +1X,'x =',1P,E13.5,', dy/dx =',E13.5,', y out of data range')    
  350 FORMAT (
     +1X,'x =',1X,A13,' dy/dx =',1X,A13,' (y out of data range)')
  400 FORMAT (1X,'x =',1P,E13.5,', dy/dx =',E13.5)
  450 FORMAT (1X,'x =',1X,A13,' dy/dx =',1X,A)  
  500 FORMAT ('Maximum dy/dx =',1P,E11.3,', at x =',E11.3)!for plotting
  525 FORMAT ('Maximum dy/dx =',1X,A,' at x =',1X,A)!for plotting
  550 FORMAT ('Maximum dy/dx =',1P,E13.5,', at x =',E13.5)!for output to file
  575 FORMAT ('Maximum dy/dx =',1X,A13,' at x =',1X,A13)!for output to file  
  600 FORMAT (
     + 'Initial dy/dx =',1P,E13.5,', at x =',E13.5
     +/'Final   dy/dx =',1P,E13.5,', at x =',E13.5
     +/'Minimum dy/dx =',1P,E13.5,', at x =',E13.5
     +/'Maximum dy/dx =',1P,E13.5,', at x =',E13.5)
  650 FORMAT (
     + 'Initial dy/dx =',1X,A13,' at x =',1X,A13
     +/'Final   dy/dx =',1X,A13,' at x =',1X,A13
     +/'Minimum dy/dx =',1X,A13,' at x =',1X,A13
     +/'Maximum dy/dx =',1X,A13,' at x =',1X,A13)     
  700 FORMAT (
     +'Epsi: step size h = epsi*range (current epsi =',1P,E13.5,')')
  750 FORMAT (
     +'Epsi: step size h = epsi*range (current epsi =',1X,A,')')     
      END
C      
C----------------------------------------------------------------------
C
      SUBROUTINE ZMEVAL (NIN, NOUT, NP, NPTS, NUMX, NZEROS,
     +                   EPSI, THEORY, W, X, XMAX, XMIN, XVAL,
     +                   YMAX, YMIN,
     +                   DEQN, EQUAL)
C
C ACTION : Evaluate y = f(x)
C          Subroutine required by program QNFIT
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 14/02/1995
C          18/11/2009 edited
C          09/11/2016 edited
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NIN, NOUT, NP, NUMX
      INTEGER,          INTENT (INOUT) :: NPTS, NZEROS
      DOUBLE PRECISION, INTENT (IN)    :: EPSI, XMAX, XMIN, YMAX, YMIN
      DOUBLE PRECISION, INTENT (INOUT) :: THEORY(*), W(NP), X(NUMX), 
     +                                    XVAL(2)      
      LOGICAL,          INTENT (IN)    :: DEQN
      LOGICAL,          INTENT (INOUT) :: EQUAL(2)
C
C Locals
C      
      INTEGER    I, ISEND, ISFIX, NSAV, NZSAV
      INTEGER    NEVAL
      INTEGER    COLOUR
      INTEGER    ICOLOR
      INTEGER    NBOT, NTOP
      PARAMETER (NBOT = 0, NTOP = 250)
      DOUBLE PRECISION TSAV, XSAV1, XSAV2
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER (LEN = 100) LINE, TEXT(30)
      CHARACTER (LEN = 13 ) D13(2), SHOWLJ
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ESAV1, ESAV2
      LOGICAL    ABORT, FIXNPT, LABEL
      PARAMETER (FIXNPT = .FALSE., LABEL = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   TABLE1, VEC1IN
      EXTERNAL   QMODEL, ZMCBOX, GETJM1, GETVEC
      INTRINSIC  ABS
      DATA       ISEND, ISFIX, NEVAL / 3, 0, 3 / 
      E_NUMBERS = E_FORMATS()
C
C Get the prediction data
C
      IF (ISFIX.EQ.0) THEN
         CALL ZMCBOX (ISEND)
         IF (ISEND.EQ.3) THEN
            ISFIX = 1
            ISEND = 1
         ELSEIF (ISEND.EQ.4) THEN
            ISFIX = 2
            ISEND = 2
         ENDIF      
      ENDIF 
      TEXT(1) = BLANK
      TEXT(2) = BLANK
      IF (ISEND.EQ.1) THEN
         CALL GETJM1 (NBOT, NEVAL, NTOP,
     +'How many values do you want to input')
         IF (NEVAL.LT.1) RETURN
         CALL GETVEC (NEVAL,
     +                W,
     +               'Press Enter after typing in each value')
      ELSE             
         CALL VEC1IN (ISEND, NIN, NP, NEVAL,
     +                W, TEXT(1), TEXT(2),
     +                ABORT, FIXNPT, LABEL)
         IF (ABORT .OR. NEVAL.LT.1) RETURN
      ENDIF     
      WRITE (NOUT,'(A)') BLANK    
C
C Save parameters
C
      NSAV = NPTS
      NPTS = 1
      IF (DEQN) NZSAV = NZEROS
      TSAV = THEORY(1)
      XSAV1 = XVAL(1)
      XSAV2 = XVAL(2)
      ESAV1 = EQUAL(1)
      ESAV2 = EQUAL(2)
      EQUAL(1) = .FALSE.
      EQUAL(2) = .FALSE.
C
C Attempt evaluation
C
      IF (TEXT(1).NE.BLANK .OR. TEXT(2).NE.BLANK) THEN
         WRITE (NOUT,'(A)') BLANK
         WRITE (NOUT,'(A)') 'Source of evaluation data:'
         IF (TEXT(1).NE.BLANK) WRITE (NOUT,'(A)') TEXT(1)
         IF (TEXT(2).NE.BLANK) WRITE (NOUT,'(A)') TEXT(2)
         WRITE (NOUT,'(A)') BLANK
      ENDIF
      COLOUR = 15
      CALL TABLE1 (COLOUR, 'OPEN')
      DO I = 1, NEVAL
         XVAL(1) = W(I)
         IF (DEQN) THEN
            IF (ABS(W(I)).LT.EPSI) THEN
               NZEROS = 1
            ELSE
               NZEROS = 0
            ENDIF
            XVAL(2) = XVAL(1) + ONE
         ENDIF
         CALL QMODEL (NUMX, X)
         IF (XVAL(1).LT.XMIN .OR. XVAL(1).GT. XMAX) THEN
            ICOLOR = 4
            IF (E_NUMBERS) THEN
               WRITE (LINE,100) W(I), THEORY(1)
               WRITE (NOUT,100) W(I), THEORY(1)
            ELSE
               D13(1) = SHOWLJ(W(I))
               D13(2) = SHOWLJ(THEORY(1))
               WRITE (LINE,150) D13(1), D13(2) 
               WRITE (NOUT,150) D13(1), D13(2) 
            ENDIF  
         ELSEIF (THEORY(1).LT.YMIN .OR. THEORY(1).GT.YMAX) THEN
            ICOLOR = 1
            IF (E_NUMBERS) THEN
               WRITE (LINE,200) W(I), THEORY(1)
               WRITE (NOUT,200) W(I), THEORY(1)
            ELSE
               D13(1) = SHOWLJ(W(I))
               D13(2) = SHOWLJ(THEORY(1))
               WRITE (LINE,250) D13(1), D13(2) 
               WRITE (NOUT,250) D13(1), D13(2) 
            ENDIF  
         ELSE
            ICOLOR = 0
            IF (E_NUMBERS) THEN
               WRITE (LINE,300) W(I), THEORY(1)
               WRITE (NOUT,300) W(I), THEORY(1)
            ELSE
               D13(1) = SHOWLJ(W(I))
               D13(2) = SHOWLJ(THEORY(1)) 
               WRITE (LINE,350) D13(1), D13(2)
               WRITE (NOUT,350) D13(1), D13(2)
            ENDIF  
         ENDIF
         CALL TABLE1 (ICOLOR, LINE)
      ENDDO
      CALL TABLE1 (COLOUR, 'CLOSE')
C
C Restore parameters
C
      NPTS = NSAV
      IF (DEQN) NZEROS = NZSAV
      THEORY(1) = TSAV
      XVAL(1) = XSAV1
      XVAL(2) = XSAV2
      EQUAL(1) = ESAV1
      EQUAL(2) = ESAV2
C
C Format statements
C      
  100 FORMAT (1X,'x =',1P,E13.5,', y =',E13.5,', x out of data range')
  150 FORMAT (1X,'x =',1X,A13,'  y =',1X,A13,' (x out of data range)')
  200 FORMAT (1X,'x =',1P,E13.5,', y =',E13.5,', y out of data range')
  250 FORMAT (1X,'x =',1X,A13,'  y =',1X,A13,' (y out of data range)')
  300 FORMAT (1X,'x =',1P,E13.5,', y =',E13.5)
  350 FORMAT (1X,'x =',1X,A13,'  y =',1X,A13)
      END
C
C----------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION ZMFUNC (N, NZEROS,
     +                                  EPSI, THEORY, X, XARG, XVAL,
     +                                  YARG,
     +                                  DEQN)
C
C action: function required by subroutine ZMCALIB
C         18/11/2009 edited

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N
      INTEGER,          INTENT (INOUT) :: NZEROS
      DOUBLE PRECISION, INTENT (IN)    :: EPSI, X(N), XARG, YARG
      DOUBLE PRECISION, INTENT (INOUT) :: THEORY(*), XVAL(2)
      LOGICAL,          INTENT (IN)    :: DEQN
C
C Local
C      
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      EXTERNAL   QMODEL
      INTRINSIC  ABS
      XVAL(1) = XARG
      IF (DEQN) THEN
         XVAL(2) = XARG + ONE
         IF (ABS(XARG).LE.EPSI) THEN
            NZEROS = 1
         ELSE
            NZEROS = 0
         ENDIF
      ENDIF
      CALL QMODEL (N,
     +             X)
      ZMFUNC = YARG - THEORY(1)
      END
C
C
