C
C
C QNFIT07.INS: ZMCUTS, ZMFILE, ZMSURF, ZMWSSQ
C ============
C These subroutines do not include MODULE_QNFIT (except for ZMSURF)
C
C----------------------------------------------------------------------
C
      SUBROUTINE ZMCUTS (NGRAF, NP, NPAR, NPTS, NX,
     +                   EPSI, FVAL, S, T, THEORY, U, V, W, X, XVAL,
     +                   YVAL, ZVAL,
     +                   FNAME1,
     +                   EQSAV, EQUAL)
C
C ACTION : Plot cuts through the best fit surface
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 13/2/96
C          15/02/1998 Added FNAME1 and VIEWER to scan data
C          03/08/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NGRAF, NP, NPAR, NX
      INTEGER,             INTENT (INOUT) :: NPTS
      DOUBLE PRECISION,    INTENT (IN)    :: EPSI, X(NX)
      DOUBLE PRECISION,    INTENT (INOUT) :: FVAL(NP), S(NP), T(NP),
     +                                       THEORY(NP), U(NP),
     +                                       V(NP), W(NP), XVAL(NP), 
     +                                       YVAL(NP), ZVAL(NP)
      CHARACTER (LEN = *), INTENT (IN)    :: FNAME1
      LOGICAL,             INTENT (INOUT) :: EQSAV(NP), EQUAL(NP)
C
C Locals
C      
      INTEGER    NXX, NYY
      INTEGER    I, NPTSAV
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMTXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 3, NUMOPT = 9, NUMTXT = 24)
      INTEGER    L1, L2, L3, L4, M1, M2, M3, M4, N1, N2, N3, N4, N100
      PARAMETER (L1 = 0, L2 = 1, L3 = 0, L4 = 0,
     +           M1 = 1, M2 = 0, M3 = 0, M4 = 0,
     +           N3 = 2, N4 = 2, N100 = 100)
      INTEGER    ISEND
      PARAMETER (ISEND = 1)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    NUMBLD (30)
      DOUBLE PRECISION XFIX, XSTART, XSTOP, YFIX, YSTART, YSTOP      
      DOUBLE PRECISION XGRAF1(N3), XGRAF2(N4), YGRAF1(N3), YGRAF2(N4)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER (LEN = 100) :: OPTS(NUMOPT), TEXT(30)
      CHARACTER (LEN = 24)  :: PTITLE
      CHARACTER (LEN = 1)   :: XTITLE
      CHARACTER (LEN = 4)   :: YTITLE
      CHARACTER (LEN = 1)   :: BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    AXES, GSAVE
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE.)
      EXTERNAL   QMODEL, ZMSURF
      EXTERNAL   LBOX02, GETDM1, ABSORT, DIVIDE, PUTADV, GKS004,
     +           VIEWER, GETJM1
      EXTERNAL   ZMFILE, PATCH2
      INTRINSIC  ABS
      SAVE       NPTSAV
      SAVE       NXX, NYY
      DATA       NUMPOS / NUMOPT*1 /
      DATA       NXX, NYY / 50, 50 / 
      DATA       NUMBLD / 30*0 / 
C
C Write the residuals files
C  
      CALL ZMFILE (ISEND, NPTS,
     +             FVAL, THEORY, XVAL, YVAL)      
C
C Save the current data and calculate XSTART, XSTOP, YSTART, YSTOP
C
      NPTSAV = NPTS
      XSTART = XVAL(1)
      XSTOP = XVAL(1)
      YSTART = YVAL(1)
      YSTOP = YVAL(1)
      DO I = 1, NPTSAV
         S(I) = XVAL(I)
         T(I) = YVAL(I)
         U(I) = FVAL(I)
         EQSAV(I) = EQUAL(I)
         EQUAL(I) = .FALSE.
         IF (XVAL(I).GT.XSTOP) XSTOP = XVAL(I)
         IF (XVAL(I).LT.XSTART) XSTART = XVAL(I)
         IF (YVAL(I).GT.YSTOP) YSTOP = YVAL(I)
         IF (YVAL(I).LT.YSTART) YSTART = YVAL(I)
      ENDDO
      PTITLE = BLANK
      XTITLE = BLANK
      YTITLE = BLANK
      NUMDEC = 1
C
C Main branch point
C
   20 CONTINUE
      WRITE (OPTS,100) NXX, NYY
      CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +             OPTS)
      IF (NUMDEC.LT.3) THEN
         IF (NUMDEC.EQ.1) THEN
C
C Fix y and vary x
C
            YFIX = YSTART 
            CALL GETDM1 (YSTART, YFIX, YSTOP,
     +                  'Fixed value of y required')
            NPTS = 0
            DO I = 1, NPTSAV
               IF (ABS(T(I) - YFIX).LE.EPSI) THEN
                  NPTS = NPTS + 1
                  V(NPTS) = S(I)
                  W(NPTS) = U(I)
               ENDIF
            ENDDO
            IF (NPTS.EQ.0) THEN
               CALL PUTADV ('No y-data found with this value')
               GOTO 20
            ENDIF
            CALL DIVIDE (NGRAF, 
     +                   XVAL, XSTART, XSTOP)
            DO I = 1, NGRAF
               YVAL(I) = YFIX
               ZVAL(I) = XVAL(I)
            ENDDO
            WRITE (PTITLE,200) YFIX
            XTITLE = 'x'
            YTITLE = 'f(x)'
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Fix x and vary y
C
            XFIX = XSTART
            CALL GETDM1 (XSTART, XFIX, XSTOP,
     +                  'Fixed value of x required')
            NPTS = 0
            DO I = 1, NPTSAV
               IF (ABS(S(I) - XFIX).LE.EPSI) THEN
                  NPTS = NPTS + 1
                  V(NPTS) = T(I)
                  W(NPTS) = U(I)
               ENDIF
            ENDDO
            IF (NPTS.EQ.0) THEN
               CALL PUTADV ('No x-data found with this value')
               GOTO 20
            ENDIF
            CALL DIVIDE (NGRAF,
     +                   YVAL, YSTART, YSTOP)
            DO I = 1, NGRAF
               XVAL(I) = XFIX
               ZVAL(I) = YVAL(I)
            ENDDO
            WRITE (PTITLE,300) XFIX
            XTITLE = 'y'
            YTITLE = 'g(y)'
         ENDIF
C
C Save NPTS as N1 then re-set NPTS = NGRAF for call to QMODEL
C
         N1 = NPTS
         N2 = NGRAF
         NPTS = NGRAF
         CALL QMODEL (NPAR, 
     +                X)
C
C Sort W(V) if N1 > 1 then plot the graph
C
         IF (N1.GT.1) CALL ABSORT (N1,
     +                             V, W)
         XGRAF1(1) = ZERO  
         XGRAF1(2) = ZERO  
         XGRAF2(1) = ZERO  
         XGRAF2(2) = ZERO  
         YGRAF1(1) = ZERO  
         YGRAF1(2) = ZERO  
         YGRAF2(1) = ZERO  
         YGRAF2(2) = ZERO  
         CALL GKS004 (L1, L2, L3, L4,
     +                M1, M2, M3, M4,
     +                N1, N2, N3, N4,
     +                V, ZVAL,   XGRAF1, XGRAF2,
     +                W, THEORY, YGRAF1, YGRAF2,
     +                PTITLE, XTITLE, YTITLE,
     +                AXES, GSAVE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.3) THEN
         CALL VIEWER (ISEND, 
     +                FNAME1, BLANK, BLANK)
         GOTO 20
      ELSEIF (NUMDEC.EQ.4) THEN
         CALL ZMSURF (NPAR, NXX, NYY, 
     +                X, XSTART, XSTOP, YSTART, YSTOP)
         GOTO 20
      ELSEIF (NUMDEC.EQ.5) THEN
         CALL PUTADV ('Not available in this version')
         GOTO 20
      ELSEIF (NUMDEC.EQ.6) THEN
         CALL GETJM1 (N3, NXX, N100,
     +               'Number of X-divisions required') 
         GOTO 20
      ELSEIF (NUMDEC.EQ.7) THEN
         CALL GETJM1 (N3, NYY, N100,
     +               'Number of Y-divisions required') 
         GOTO 20   
      ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
         WRITE (TEXT,400)
         NUMBLD(1) = 1   
         NUMBLD(8) = 1   
         NUMBLD(14) = 1  
         CALL PATCH2 (NUMBLD, NUMTXT,
     +                TEXT)          
         GOTO 20
      ELSE
C
C Restore the data
C
         NPTS = NPTSAV
         DO I = 1, NPTS
            XVAL(I) = S(I)
            YVAL(I) = T(I)
            FVAL(I) = U(I)
            EQUAL(I) = EQSAV(I)
         ENDDO
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Plot x varied with y fixed (section plus data)'
     +/'Plot y varied with x fixed (section plus data)'
     +/'View current x,y,z values (examine data file)'
     +/'Plot best-fit z = f(x,y) (surface or contours)'
     +/'Plot best-fit z = f(x,y) (surface plus data) [NA]'
     +/'Change number of X divisions: current =',I4
     +/'Change number of Y divisions: current =',I4
     +/'Help'
     +/'Cancel')
  200 FORMAT ('f(x) with y =',1P,E11.3)
  300 FORMAT ('g(y) with x =',1P,E11.3)
  400 FORMAT (
     + 'Plotting sequential sections across the best-fit surface'
     +/
     +/'If you want a plot with x varied and y fixed to show sections' 
     +/'across the best fit surface, then data and curves can be saved' 
     +/'using the [Advanced] option to generate sequential sections. It' 
     +/'helps to view the data file to choose sensible fixed values.'
     +/
     +/'Plotting the best-fit surface'
     +/
     +/'Normally a smooth surface can be plotted using about 20 to 40'
     +/'divisions of the x and y axes, but for contours more will be'
     +/'required.'
     +/
     +/'Plotting contours'
     +/
     +/'Displaying the surface with data can be unsatisfactory due to' 
     +/'data points being both below and above the best-fit surface.'
     +/'Another way is plot coordinates for positive and negative'
     +/'residuals in appropriate symbols on a contour diagram. This'
     +/'is facilitated by the fact that qnfit saves the coordinates in'
     +/'two files in your \Documents\Simfit\res folder called' 
     +/'      qnfit_positive_residuals.txt'
     +/'      qnfit_negative_residuals.txt'
     +/'which can be used to provide such contour overlays.')
      END
c
c
      subroutine zmfile (isend, npts,
     +                   fval, theory, xval, yval)
c
c action: write x,y coordinates for positive and negative residuals to a file 
c author: w.g.bardsley, university of manchester, u.k. 27/12/2016
c
c The residuals files are for over-laying onto contours for
c best-fit surfaces plots from qnfit
c   
c isend provided is for possible future developments as follows:
c isend = 1: create the files
c       o/w: delete the files
c  
      implicit none
c
c arguments
c        
      integer,          intent (in) :: isend, npts
      double precision, intent (in) :: fval(npts), theory(npts), 
     +                                 xval(npts), yval(npts)
c
c locals
c     
      integer    n2
      parameter (n2 = 2)
      integer    i, ios, l, nneg, nout, npos
      character (len = 1024) negres, posres, res
      character (len = 28  ) negfil, posfil
      character (len = 1   ) blank, bslash
      parameter (blank = ' ',
     +           bslash = '\',
     +           negfil = 'qnfit_negative_residuals.txt',
     +           posfil = 'qnfit_positive_residuals.txt') 
      logical    askif, there
      parameter (askif = .false.)
      external   resdir, getnou, deleet
c
c calculate the number of positive and negative residuals
c      
      if (npts.lt.1) return
      npos = 0
      nneg = 0
      do i = 1, npts
         if (fval(i).ge.theory(i)) then
            npos = npos + 1
         else
            nneg = nneg +1
         endif
      enddo  
c
c define the output files
c      
      call resdir (l,
     +             res)
      if (res(l:l).ne.bslash) then
         l = l + 1
         res(l:l) = bslash
      endif   
      negres = blank
      negres = res(1:l)//negfil(1:28)
      posres = blank
      posres = res(1:l)//posfil(1:28)
      if (isend.eq.1) then
         if (nneg.gt.0) then
c
c negative residuals
c        
            call getnou (nout)
            open (unit = nout, file = negres, iostat = ios)
            write (nout,100,iostat=ios) negfil  
            if (ios.eq.0) write (nout,200,iostat=ios) nneg, n2
            do i = 1, npts
               if (fval(i).lt.theory(i)) write (nout,300,iostat=ios)
     +                                          xval(i), yval(i)
            enddo                 
           close (unit = nout)
         endif    
         if (npos.gt.0) then
            call getnou (nout)
            open (unit = nout, file = posres, iostat = ios)
            write (nout,100,iostat=ios) posfil  
            if (ios.eq.0) write (nout,200,iostat=ios) npos, n2
            do i = 1, npts
               if (fval(i).ge.theory(i)) write (nout,300,iostat=ios)
     +                                          xval(i), yval(i)
            enddo                 
            close (unit = nout)
         endif
      else
         call deleet (negres,
     +                askif, there)  
         call deleet (posres,
     +                askif, there)            
      endif  
c
c format statements
c      
  100 format (a)
  200 format (2i6) 
  300 format (1p,2e13.5)
      end
C
C----------------------------------------------------------------------
C
      SUBROUTINE ZMSURF (N, NXX, NYY, 
     +                   X, XSTART, XSTOP, YSTART, YSTOP)
C
C ACTION : Calculate the best fit surface
C          Subroutine required by program QNFIT
C          This alters the data values so it should only be called
C          from a routine that saves the original data values
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          15/02/1998 Developed from subroutine OUTDAT of MAKDAT

      USE MODULE_QNFIT, ONLY : NPTS,  
     +                         XVAL, YVAL,
     +                         THEORY,
     +                         EQUAL   
      
C
      IMPLICIT   NONE
C
C Argument list
C
      INTEGER,          INTENT (IN) :: N, NXX, NYY
      DOUBLE PRECISION, INTENT (IN) :: X(N), XSTART, XSTOP, YSTART, 
     +                                 YSTOP
C
C Special data for surface plotting: NMAX must agree with SURD2S$
C
      INTEGER    JSEND, KSEND, NMAX
      PARAMETER (KSEND = 4, NMAX = 100)
      DOUBLE PRECISION XXMAX, XXMIN
      DOUBLE PRECISION YYMAX, YYMIN
      DOUBLE PRECISION ZZ(NMAX, NMAX)
      DOUBLE PRECISION VECTOR (NMAX*NMAX + 6)
      LOGICAL    UNUSED(NMAX,NMAX)
C
C Usual data
C
      INTEGER    I, J, K, L
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      DOUBLE PRECISION XDELTA, YDELTA, YTEMP
      EXTERNAL   QMODEL
      EXTERNAL   SURD2S
      INTRINSIC  DBLE
C
C Data for QMODEL
C
C
C This code will only work if the data has no replicates and
C is in order of X increasing for successive increasing fixed Y
C at all equal intervals for X and also for Y
C
C
C First of all calculate NXX, NYY, XXMAX, XXMIN, YYMAX, YYMIN
C
      XXMAX = XSTOP
      XXMIN = XSTART
      XDELTA = (XSTOP - XSTART)/(DBLE(NXX) - ONE)
      YYMAX = YSTOP
      YYMIN = YSTART
      YDELTA = (YSTOP - YSTART)/(DBLE(NYY) - ONE)
      K = 0
      DO I = 1, NXX
         YTEMP = YSTART + DBLE(I - 1)*YDELTA
         DO J = 1, NYY
            K = K + 1
            YVAL(K) = YTEMP
            XVAL(K) = XSTART + DBLE(J - 1)*XDELTA
            EQUAL(K) = .FALSE.
         ENDDO
      ENDDO
      NPTS = K
      CALL QMODEL (N,
     +             X)
      JSEND = KSEND
      IF (JSEND.EQ.3) THEN
C
C Now fill in VECTOR if JSEND = 3
C
         VECTOR(1) = DBLE(NXX)
         VECTOR(2) = DBLE(NYY)
         VECTOR(3) = XXMIN
         VECTOR(4) = XXMAX
         VECTOR(5) = YYMIN
         VECTOR(6) = YYMAX
         L = 6
         DO I = 1, NPTS
            L = L + 1
            VECTOR(L) = THEORY(I)
         ENDDO
      ELSEIF (JSEND.EQ.4) THEN
C
C Otherwise fill in ZZ if JSEND = 4
C
         L = 0
         DO J = 1, NYY
            DO I = 1, NXX
               L = L + 1
               ZZ(I,J) = THEORY(L)
            ENDDO
         ENDDO
      ENDIF
      CALL SURD2S (JSEND, NMAX, NXX, NYY,
     +             VECTOR, XXMAX, XXMIN, YYMAX, YYMIN, ZZ,
     +             UNUSED)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ZMWSSQ (NPAR,
     +                   FACT, X)
C
C ACTION : Plot of WSSQ at the solution point
C          Subroutine required by program QNFIT
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          Derived from OUTDAT of program MAKDAT
C          04/09/2009 minor editing
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NPAR
      DOUBLE PRECISION, INTENT (INOUT) :: FACT(NPAR), X(NPAR)
C
C Special data for surface plotting: NMAX must agree with SURD2S$
C                                    ============================
C
      INTEGER    JSEND, KSEND, NMAX, NXX, NYY
      PARAMETER (KSEND = 4, NMAX = 100)
      DOUBLE PRECISION XXMAX, XXMIN, YYMAX, YYMIN, ZZ(NMAX,NMAX)
      DOUBLE PRECISION XVAL(NMAX), YVAL(NMAX), VECTOR(NMAX*NMAX + 6)
      LOGICAL    UNUSED(NMAX,NMAX)
C
C Usual data
C
      INTEGER    I, I1, I2, J, L, NGRID, NPLOT
      INTEGER    N0, N1, N2, N4, N10
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4, N10 = 10)
      DOUBLE PRECISION DELTA, F1SAV, F2SAV, XTEMP, X1SAV, X2SAV
      DOUBLE PRECISION X2(2), X3(2), X4(2), Y2(2), Y3(2), Y4(2)
      DOUBLE PRECISION ONE, SIGMA
      PARAMETER (ONE = 1.0D+00)
      CHARACTER (LEN = 100) :: LINE
      CHARACTER (LEN = 32)  :: PTITLE
      CHARACTER (LEN = 5)   :: XTITLE
      CHARACTER (LEN = 9)   :: YTITLE
      PARAMETER (YTITLE = 'WSSQ/NDOF')
      LOGICAL    GRAPH
      PARAMETER (GRAPH = .TRUE.)
      INTRINSIC  DBLE
      EXTERNAL   FUNCT1
      EXTERNAL   PUTADV, GETDLE, GETDGE, GETJM1, GKS004, DIVIDE
      EXTERNAL   SURD2S
C
C If NPAR = 1 no choice, otherwise pick 1 or 2 parameters to vary
C
      IF (NPAR.EQ.1) THEN
         NPLOT = N1
         I1 = N1
      ELSE
         NPLOT = N1
         CALL GETJM1 (N1, NPLOT, N2,
     +   'Total number of best fit parameters to be varied')
         I1 = N1
         IF (NPLOT.EQ.N1) THEN
            CALL GETJM1 (N1, I1, NPAR,
     +      'Number i of the parameter p(i) to be varied')
         ENDIF
      ENDIF
      IF (NPLOT.EQ.1) THEN
C
C Special action if NPLOT = 1, make NGRID divisible by 4
C
         I = NMAX
         NGRID = 60
         CALL GETJM1 (N4, NGRID, I,
     +               'Number of points required for the plot (60 ?)')
         NGRID = N4*(NGRID/N4)
C
C Now calculate XXMAX, XXMIN, XVAL in internal coordinates to begin with
C
         F1SAV = FACT(I1)
         X1SAV = X(I1)
         XTEMP = F1SAV*X1SAV
         WRITE (LINE,100) I1, XTEMP
         XXMIN = XTEMP
         CALL GETDLE (XXMIN, XTEMP,
     +                LINE)
         WRITE (LINE,200) I1, XTEMP
         XXMAX = XTEMP
         CALL GETDGE (XXMAX, XTEMP, 
     +                LINE)
         XXMAX = XXMAX/F1SAV
         XXMIN = XXMIN/F1SAV
         CALL DIVIDE (NGRID,
     +                XVAL, XXMIN, XXMAX)
C
C Now calculate YVAL then restore XVAL to external parameters
C
         DO I = N1, NGRID
            X(I1) = XVAL(I)
            CALL FUNCT1 (NPAR,
     +                   X, SIGMA)
            XVAL(I) = F1SAV*XVAL(I)
            YVAL(I) = SIGMA
         ENDDO
         VECTOR(N1) = ONE
         VECTOR(N2) = ONE
         IF (I1.LT.N10) THEN
            WRITE (PTITLE,300) I1
            WRITE (XTITLE,400) I1
         ELSE
            WRITE (PTITLE,500) I1
            WRITE (XTITLE,600) I1
         ENDIF
C
C Next call problematical with /f_stdcall + /checkmate so 
C used X2, X3, X4, Y1, Y2, Y3, Y4 instead of VECTOR 
c Note: X2, X3, X4, Y2, Y3, Y4 are dummy arrays that will not be plotted
C         
         DO I = N1, N2
            X2(I) = ONE
            X3(I) = ONE
            X4(I) = ONE
            Y2(I) = ONE
            Y3(I) = ONE
            Y4(I) = ONE
         ENDDO    
         CALL GKS004 (N1,    N0, N0, N0,
     +                N0,    N0, N0, N0,
     +                NGRID, N1, N1, N1,
     +                XVAL,  X2, X3, X4,
     +                YVAL,  Y2, Y3, Y4,
     +                PTITLE, XTITLE, YTITLE,
     +                GRAPH, GRAPH)
C
C Restore FACT and X
C
         FACT(I1) = F1SAV
         X(I1) = X1SAV
      ELSE
C
C This code will only work if the data has no replicates and
C is in order of X increasing for successive increasing fixed Y
C at all equal intervals for X and also for Y
C
   20    CONTINUE
         I1 = N1
         CALL GETJM1 (N1, I1, NPAR,
     +   'Number i of the parameter p(i) to plot along the x axis')
         I2 = N2
         CALL GETJM1 (N1, I2, NPAR,
     +   'Number j of the parameter p(j) to plot along the y axis')
         IF (I1.EQ.I2) THEN
            CALL PUTADV ('Same parameter for x and y ... Try again')
            GOTO 20
         ENDIF
         I = NMAX
         NGRID = 40
         CALL GETJM1 (N2, NGRID, I,
     +               'Number of (x,y) grid points required (40 ?)')
C
C Now calculate XXMAX, XXMIN, XVAL
C
         NXX = NGRID
         F1SAV = FACT(I1)
         X1SAV = X(I1)
         XTEMP = F1SAV*X1SAV
         WRITE (LINE,100) I1, XTEMP
         XXMIN = XTEMP
         CALL GETDLE (XXMIN, XTEMP,
     +                LINE)
         WRITE (LINE,200) I1, XTEMP
         XXMAX = XTEMP
         CALL GETDGE (XXMAX, XTEMP,
     +               LINE)
         XXMAX = XXMAX/F1SAV
         XXMIN = XXMIN/F1SAV
         XVAL(N1) = XXMIN
         XVAL(NGRID) = XXMAX
         DELTA = (XXMAX - XXMIN)/(DBLE(NGRID) - ONE)
         DO I = N2, NGRID - N1
            XVAL(I) = XVAL(I - N1) + DELTA
         ENDDO
C
C Now calculate YYMAX, YYMIN, YVAL
C
         NYY = NGRID
         F2SAV = FACT(I2)
         X2SAV = X(I2)
         XTEMP = F2SAV*X2SAV
         WRITE (LINE,100) I2, XTEMP
         YYMIN = XTEMP
         CALL GETDLE (YYMIN, XTEMP, 
     +                LINE)
         WRITE (LINE,200) I2, XTEMP
         YYMAX = XTEMP
         CALL GETDGE (YYMAX, XTEMP,
     +                LINE)
         YYMAX = YYMAX/F2SAV
         YYMIN = YYMIN/F2SAV
         YVAL(N1) = YYMIN
         YVAL(NGRID) = YYMAX
         DELTA = (YYMAX - YYMIN)/(DBLE(NGRID) - ONE)
         DO I = N2, NGRID - N1
            YVAL(I) = YVAL(I - N1) + DELTA
         ENDDO
C
C Restore limits to external coordinates to avoid confusing users
C

         XXMIN = F1SAV*XXMIN
         XXMAX = F1SAV*XXMAX
         YYMIN = F2SAV*YYMIN
         YYMAX = F2SAV*YYMAX
         JSEND = KSEND
         IF (JSEND.EQ.3) THEN
C
C Now fill in VECTOR if JSEND = 3
C
            VECTOR(1) = DBLE(NXX)
            VECTOR(2) = DBLE(NYY)
            VECTOR(3) = XXMIN
            VECTOR(4) = XXMAX
            VECTOR(5) = YYMIN
            VECTOR(6) = YYMAX
            L = 6
            DO I = N1, NGRID
               DO J = N1, NGRID
                  L = L + 1
                  X(I1) = XVAL(J)
                  X(I2) = YVAL(I)
                  CALL FUNCT1 (NPAR,
     +                         X, SIGMA)
                  VECTOR(L) = SIGMA
               ENDDO
            ENDDO
         ELSEIF (JSEND.EQ.4) THEN
C
C Otherwise fill in ZZ if JSEND = 4
C
            DO J = 1, NGRID
               DO I = 1, NGRID
                  X(I1) = XVAL(I)
                  X(I2) = YVAL(J)
                  CALL FUNCT1 (NPAR, X, SIGMA)
                  ZZ(I,J) = SIGMA
               ENDDO
            ENDDO
         ENDIF
         CALL SURD2S (JSEND, NMAX, NXX, NYY,
     +                VECTOR, XXMAX, XXMIN, YYMAX, YYMIN, ZZ,
     +                UNUSED)
C
C Restore FACT and X
C
         FACT(I1) = F1SAV
         FACT(I2) = F2SAV
         X(I1) = X1SAV
         X(I2) = X2SAV
      ENDIF
C
C Format statements
C      
  100 FORMAT ('Lower limit: current value for p(',I2,') =',1P,E11.3)
  200 FORMAT ('Upper limit: current value for p(',I2,') =',1P,E11.3)
  300 FORMAT ('WSSQ/NDOF as a function of p(',I1,') ')
  400 FORMAT ('p(',I1,') ')
  500 FORMAT ('WSSQ/NDOF as a function of p(',I2,')')
  600 FORMAT ('p(',I2,')')
      END
C
C
