C
C QNFIT08.INS
C ===========
C these subroutines do not include MODULE_QNFIT except for ZMDCON
C
C ZMPLOT : Extra plotting
C ZMDCON : deconvolution ... uses MODULE_QNFIT
C ZMSTOR : F tests
C ZMTYPE : type of linear regression
C
C----------------------------------------------------------------------
C
      SUBROUTINE ZMPLOT (MODEL, NMOD, NP, NPAR, NPLOT, NPTS, NPTSAV,
     +                   ASYMP, FACT, FVAL, S, T, THEORY, U, V, X, XMAX,
     +                   XMIN, XSAV, XSTORE, XVAL, Y1, Y2, Y3, Y4, Y5, 
     +                   Y6, Y7, Y8, Y9, Y10, Y11, Y12,
     +                   EQUAL)
C
C ACTION : Extra plotting after fitting in QNFIT
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 20/11/1998
C          30/08/2000 added call to GKST04 for deconvolution if OK
C
C          MODEL, NMOD, NP, NPAR, NPLOT, XMAX and XMIN are unchanged
C          NPTSAV, FVAL and XSAV must never be changed ... be careful
C          to use substitutions when calling graphics
C          NPTS, THEORY, X and XVAL are changed during program operation
C          but are restored on final exit ... be careful to make sure
C          they are correctly restored
C          S, T, U, V and Y1 to Y12 are workspaces but note that Y1
C          must be dimensioned Y1(NP) because it is used for FVAL
C          EQUAL must be set to .FALSE. then restored by the subroutine
C          calling ZMPLOT to the correct values for replicates
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: MODEL, NMOD, NP, NPAR, NPLOT,
     +                                    NPTSAV
      INTEGER,          INTENT (INOUT) :: NPTS
      DOUBLE PRECISION, INTENT (IN)    :: ASYMP, XMAX, XMIN 
      DOUBLE PRECISION, INTENT (IN)    :: FACT(NPAR), FVAL(NP), XSAV(NP) 
      DOUBLE PRECISION, INTENT (INOUT) :: X(NPAR)
      DOUBLE PRECISION, INTENT (INOUT) :: S(NP), T(NP),
     +                                    THEORY(NP), U(NP), V(NP), 
     +                                    XSTORE(NPAR),
     +                                    XVAL(NP),    Y1(NP),
     +                                     Y2(NPLOT),  Y3(NP),
     +                                     Y4(NPLOT),  Y5(NP),
     +                                     Y6(NPLOT),  Y7(NP),
     +                                     Y8(NPLOT),  Y9(NP), 
     +                                    Y10(NPLOT), Y11(NP),
     +                                    Y12(NPLOT)      
      LOGICAL,          INTENT (INOUT) :: EQUAL(NP)
C
C Locals
C      
      INTEGER    I, NERR, NPTS1
      INTEGER    K0, K1, K2, K3, K5
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K5 = 5)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 7,
     +           NSTART = 10, NTEXT = 16)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12,
     +           M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12,
     +           N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12
      DOUBLE PRECISION XMAX1, XMIN1
      DOUBLE PRECISION XTEMP(K2), YTEMP(K2)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER  TEXT(NTEXT)*100, LINE*100
      CHARACTER  PTITLE*20, XTITLE*1, YTITLE*1
      PARAMETER (XTITLE = 'x', YTITLE = 'y')
      LOGICAL    ABORT
      LOGICAL    FIXED, FLASH, HIGH
      PARAMETER (FIXED = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    GSAVE1, GSAVE2
      PARAMETER (GSAVE1 = .TRUE., GSAVE2 = .TRUE.)
      EXTERNAL   QMODEL
      EXTERNAL   DIVIDE, LBOX01, GKST04, NYYBAR, PUTADV, GKST12,
     +           GKSEB4, ZMDCON, GETJM1, GETDGE, GETDLE, GKS004
      SAVE       NPTS1
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       NPTS1 / 320 /
      DATA       L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12
     +         /  0,  2,  1,  1,  1,  1,  1,  1,  1,   1,   1,   1 /
      DATA       M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12
     +         /  1,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,   0 /
      DATA       XTEMP / 0.0D+00, 0.0D+00 /
      DATA       YTEMP / 0.0D+00, 0.0D+00 /
C
C Initialise then calculate a best-fit curve
C
      XMAX1 = XMAX
      XMIN1 = XMIN
      NPTS = NPTS1
      DO I = 1, NPLOT
         EQUAL(I) = .FALSE.
      ENDDO
      CALL DIVIDE (NPTS1,
     +             XVAL, XMIN1, XMAX1)
      CALL QMODEL (NPAR,
     +             X)
C
C Main loop for repeat operations
C
   20 CONTINUE
      WRITE (TEXT,100) NPTS1, XMAX1, XMAX, XMIN1, XMIN
      NUMDEC = 4
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             FIXED, FLASH, HIGH)
      IF (NUMDEC.EQ.1) THEN
C
C Change NPTS1
C
         CALL GETJM1 (K2, NPTS1, NPLOT,
     +               'Value required for N_plot')
         NPTS = NPTS1
      ELSEIF (NUMDEC.EQ.2) THEN
C
C Change XMAX1
C
         WRITE (LINE,200) XMAX1, XMAX
         CALL GETDGE (XMAX1, XMIN1,
     +                LINE)
      ELSEIF (NUMDEC.EQ.3) THEN
C
C Change XMIN1
C
         WRITE (LINE,200) XMIN1, XMIN
         CALL GETDLE (XMIN1, XMAX1,
     +                LINE)
      ELSEIF (NUMDEC.EQ.4) THEN
C
C Extrapolate: Note that GKST04 can alter Y and/or X , e.g. if a
C Scatchard transformation is used. So a substitution is made to stop
C NYYBAR thinking that x is out of order which is really due to a
C rounding error when reversing a Scatchard transformation.
C
         DO I = K1, NPTSAV
            S(I) = XSAV(I)
            T(I) = FVAL(I)
         ENDDO
         DO I = K1, NPTS1
            U(I) = XVAL(I)
            V(I) = THEORY(I)
         ENDDO
         PTITLE = 'Extrapolation'
         CALL GKST04 (K0, K1, K0, K0,
     +                K1, K0, K0, K0,
     +                NPTSAV, NPTS1, K0, K0,
     +                ASYMP,
     +                S, U, XTEMP, XTEMP,
     +                T, V, YTEMP, YTEMP,
     +                PTITLE, XTITLE, YTITLE,
     +                GSAVE1, GSAVE2)
      ELSEIF (NUMDEC.EQ.5) THEN
C
C Deconvolute
C
         CALL ZMDCON (MODEL, NMOD, NP, NPAR, NPLOT, NPTS, NPTSAV,
     +                N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12,
     +                FACT, FVAL, THEORY, X, XSTORE, XVAL, Y1, Y2, Y3,
     +                Y4, Y5, Y6, Y7, Y8, Y9, Y10, Y11, Y12,
     +                ABORT)
         IF (ABORT) THEN
            CALL PUTADV ('Model unsuitable for graphical deconvolution')
         ELSE
            DO I = K1, NPTSAV
               S(I) = XSAV(I)
            ENDDO
            PTITLE = 'Deconvolution'
            IF (N5.EQ.K0  .AND. N6.EQ.K0 .AND. N7.EQ.K0  .AND.
     +          N8.EQ.K0  .AND. N9.EQ.K0 .AND. N10.EQ.K0 .AND.
     +          N11.EQ.K0 .AND. N12.EQ.K0) THEN
               IF (MODEL.EQ.14) THEN
                  CALL GKS004 (L1, L2, L3, L4,
     +                         M1, M2, M3, M4,
     +                         N1, N2, N3, N4,
     +                         S, XVAL, XVAL, XVAL,
     +                         Y1, Y2, Y3, Y4,
     +                         PTITLE, XTITLE, YTITLE,
     +                         GSAVE1, GSAVE2)
               ELSE
                  CALL GKST04 (L1, L2, L3, L4,
     +                         M1, M2, M3, M4,
     +                         N1, N2, N3, N4,
     +                         ASYMP,
     +                         S, XVAL, XVAL, XVAL,
     +                         Y1, Y2, Y3, Y4,
     +                         PTITLE, XTITLE, YTITLE,
     +                         GSAVE1, GSAVE2)                 
               ENDIF  
            ELSE
               CALL GKST12 (L1, L2, L3, L4, L5, L6, L7, L8, L9, L10,
     +                      L11, L12,
     +                      M1, M2, M3, M4, M5, M6, M7, M8, M9, M10,
     +                      M11, M12,
     +                      N1, N2, N3, N4, N5, N6, N7, N8, N9, N10,
     +                      N11, N12,
     +                      ASYMP,
     +                      S, XVAL, XVAL, XVAL, XVAL, XVAL, XVAL,
     +                      XVAL, XVAL, XVAL, XVAL, XVAL,
     +                      Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10,
     +                      Y11, Y12,
     +                      PTITLE, XTITLE, YTITLE,
     +                      GSAVE1, GSAVE2)
            ENDIF
         ENDIF
      ELSEIF (NUMDEC.EQ.6) THEN
C
C Error bars
C
         NERR = NPTSAV
         DO I = 1, NERR
            S(I) = XSAV(I)
            T(I) = FVAL(I)
            V(I) = ONE
         ENDDO
         CALL NYYBAR (K3, NERR, S, T, V)
         DO I = 1, NERR
            U(I) = T(I) - V(I)
            V(I) = T(I) + V(I)
         ENDDO
         PTITLE = 'Error Bars'
         CALL GKSEB4 (K0, K1, K0, K0,
     +                K5, K0, K0, K0,
     +                NERR, NPTS1, K0, K0,
     +                S, XVAL, XTEMP, XTEMP,
     +                V, V, U, U, T, THEORY, YTEMP, YTEMP,
     +                PTITLE, XTITLE, YTITLE,
     +                GSAVE1, GSAVE2)
      ENDIF
C
C If NPTS1, XMAX1 or XMIN1 have been changed then recalculate XVAL and THEORY
C
      IF (NUMDEC.GE.1 .AND. NUMDEC.LE.3) THEN
         CALL DIVIDE (NPTS1,
     +                XVAL, XMIN1, XMAX1)
         CALL QMODEL (NPAR,
     +                X)
      ENDIF
      IF (NUMDEC.LT.NUMOPT) GOTO 20
      NPTS = NPTSAV
C
C Format statements
C      
  100 FORMAT (
     + 'N_plot, X_max and X_min control'
     +/'extrapolation, deconvolution needs'
     +/'sums of functions, and error bars'
     +/'are calculated from replicates.'
     +/
     +/'N_plot =',I5
     +/'X_max =',1P,E11.3,' (data =',E11.3,')'
     +/'X_min =',   E11.3,' (data =',E11.3,')'
     +/
     +/'Change N_plot'
     +/'Change X_max'
     +/'Change X_min'
     +/'Plot/Extrapolate'
     +/'Plot/Deconvolute'
     +/'Plot/Error-bars'
     +/'Cancel')
  200 FORMAT ('Value required: current =', 1P,E11.3,', data =',E11.3)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ZMDCON (MODEL, NMOD, NP, NPAR, NPLOT, NPTS, NPTSAV, N1,
     +                   N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12,
     +                   FACT, FVAL, THEORY, X, XSTORE, XVAL, Y1, Y2,
     +                   Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10, Y11, Y12,
     +                   ABORT)
      USE MODULE_QNFIT, ONLY : ENEG, EPOS, RTOL
C
C ACTION : Graphical deconvolution if model is a sum of functions
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 21/11/98
C          NPTS is now the no. of points plotted not the no. of data points
C          17/03/2010 added normal pdfs and cdfs
C
C          MODEL =  1: Polynomial
C          MODEL =  3: MM
C          MODEL =  4: HL
C          MODEL =  7: Exp
C          MODEL =  8: Mono
C          MODEL =  9: Gaussian
C          MODEL = 14: 2 Normal pdfs or cdfs
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: MODEL, NMOD, NP, NPAR, NPLOT, 
     +                                    NPTS, NPTSAV
      INTEGER,          INTENT (INOUT) :: N1, N2, N3, N4, N5, N6, N7,
     +                                    N8, N9, N10, N11, N12
      DOUBLE PRECISION, INTENT (IN)    :: FACT(NPAR), FVAL(NP), XVAL(NP)
      DOUBLE PRECISION, INTENT (INOUT) :: X(NPAR)
      DOUBLE PRECISION, INTENT (INOUT) :: THEORY(NP), 
     +                                    XSTORE(NPAR),
     +                                     Y1(NP),  Y2(NPLOT),
     +                                     Y3(NP),  Y4(NPLOT),
     +                                     Y5(NP),  Y6(NPLOT),
     +                                     Y7(NP),  Y8(NPLOT),
     +                                     Y9(NP), Y10(NPLOT),
     +                                    Y11(NP), Y12(NPLOT)
      LOGICAL,            INTENT (OUT) :: ABORT
C
C Locals
C       
      INTEGER    I, ICOUNT, J, JSTOP, MM, NN
      INTEGER    K0, K1
      PARAMETER (K0 = 0, K1 = 1)
      DOUBLE PRECISION A(30), Z
      DOUBLE PRECISION F114
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      LOGICAL    CONST
      EXTERNAL   QMODEL, F114
C
C Check input parameters and store X
C
      IF (MODEL.EQ.1 .OR.
     +    MODEL.EQ.3 .OR.
     +    MODEL.EQ.4 .OR.
     +    MODEL.EQ.7 .OR.
     +    MODEL.EQ.8 .OR.
     +    MODEL.EQ.9) THEN
         IF (NMOD.EQ.1 .OR. NMOD.GT.9) THEN
            ABORT = .TRUE.
         ELSE
            ABORT = .FALSE.
         ENDIF
      ELSEIF (MODEL.EQ.14) THEN
         IF (NMOD.EQ.203 .OR. NMOD.EQ.204) THEN
            ABORT = .FALSE.
            CONST = .FALSE.
         ELSE
            ABORT = .TRUE.
         ENDIF          
      ELSE
         ABORT = .TRUE.
      ENDIF
      IF (ABORT) RETURN
C
C Store parameters
C
      DO I = K1, NPAR
         XSTORE(I) = X(I)
      ENDDO
C
C Is there a constant term in the model
C
      CONST = .FALSE.
      IF (MODEL.EQ.1) THEN
         IF (NPAR.GT.NMOD) CONST = .TRUE.
      ELSEIF (MODEL.LT.9) THEN
         IF (NPAR.GT.2*NMOD) CONST = .TRUE.
      ELSEIF (MODEL.EQ.9) THEN
         IF (NPAR.GT.3*NMOD) CONST = .TRUE.
      ENDIF
      IF (CONST) X(NPAR) = ZERO
C
C Zeroise extra NI
C
      N5 = K0
      N6 = K0
      N7 = K0
      N8 = K0
      N9 = K0
      N10 = K0
      N11 = K0
      N12 = K0
C
C The data
C
      N1 = NPTSAV
      DO I = K1, N1
         Y1(I) = FVAL(I)
      ENDDO
C
C The best fit curve
C
      N2 = NPTS
      DO I = K1, N2
         Y2(I) = THEORY(I)
      ENDDO

      IF (MODEL.EQ.14) THEN
C
C Statistical models
C        
         N3 = NPTS
         N4 = NPTS
         NN = 3
         CONST = .FALSE.
         IF (NMOD.EQ.203) THEN
C
C 2 normal pdfs
C           
            MM = 1
            A(1) = FACT(1)*X(1)
            A(2) = FACT(2)*X(2)
            A(3) = FACT(3)*X(3)
            DO I = 1, NPTS
               Z = XVAL(I)
               Y3(I) = F114(MM, NN, A, ENEG, EPOS, RTOL, Z)
            ENDDO   
            A(1) = FACT(4)*X(4)
            A(2) = FACT(5)*X(5)
            A(3) = ONE - FACT(3)*X(3)
            DO I = 1, NPTS
               Z = XVAL(I)
               Y4(I) = F114(MM, NN, A, ENEG, EPOS, RTOL, Z)
            ENDDO     
         ELSE
C
C 2 normal cdfs
C           
            MM = 101
            A(1) = FACT(1)*X(1)
            A(2) = FACT(2)*X(2)
            A(3) = FACT(3)*X(3)
            DO I = 1, NPTS
               Z = XVAL(I)
               Y3(I) = F114(MM, NN, A, ENEG, EPOS, RTOL, Z)
            ENDDO   
            A(1) = FACT(4)*X(4)
            A(2) = FACT(5)*X(5)
            A(3) = ONE - FACT(3)*X(3)
            DO I = 1, NPTS
               Z = XVAL(I)
               Y4(I) = F114(MM, NN, A, ENEG, EPOS, RTOL, Z)
            ENDDO                
         ENDIF    
      ELSE   
         JSTOP = NMOD
         ICOUNT = K0
         DO J = K1, JSTOP
            ICOUNT = ICOUNT + K1
            IF (MODEL.EQ.1) THEN
C
C For a polynomial set all terms except ICOUNT to zero
C
               DO I = K1, NPAR
                  X(I) = ZERO
               ENDDO
               X(ICOUNT) = XSTORE(ICOUNT)
            ELSE
C
C For sums just set all leading coefficients to zero except for ICOUNT
C
               DO I = K1, NMOD
                  IF (I.EQ.ICOUNT) THEN
                     X(I) = XSTORE(I)
                  ELSE
                     X(I) = ZERO
                  ENDIF
               ENDDO
            ENDIF
C
C Calculate component ICOUNT with all others = 0
C
            CALL QMODEL (NPAR,
     +                   X)
            IF (ICOUNT.EQ.1) THEN
               N3 = NPTS
               DO I = K1, NPTS
                  Y3(I) = THEORY(I)
               ENDDO
            ELSEIF (ICOUNT.EQ.2) THEN
               N4 = NPTS
               DO I = K1, NPTS
                  Y4(I) = THEORY(I)
               ENDDO
            ELSEIF (ICOUNT.EQ.3) THEN
               N5 = NPTS
               DO I = K1, NPTS
                  Y5(I) = THEORY(I)
               ENDDO
            ELSEIF (ICOUNT.EQ.4) THEN
               N6 = NPTS
               DO I = K1, NPTS
                  Y6(I) = THEORY(I)
               ENDDO
            ELSEIF (ICOUNT.EQ.5) THEN
               N7 = NPTS
               DO I = K1, NPTS
                  Y7(I) = THEORY(I)
               ENDDO
            ELSEIF (ICOUNT.EQ.6) THEN
               N8 = NPTS
               DO I = K1, NPTS
                  Y8(I) = THEORY(I)
               ENDDO
            ELSEIF (ICOUNT.EQ.7) THEN
               N9 = NPTS
               DO I = K1, NPTS
                  Y9(I) = THEORY(I)
               ENDDO
            ELSEIF (ICOUNT.EQ.8) THEN
               N10 = NPTS
               DO I = K1, NPTS
                  Y10(I) = THEORY(I)
               ENDDO
            ELSEIF (ICOUNT.EQ.9) THEN
               N11 = NPTS
               DO I = K1, NPTS
                  Y11(I) = THEORY(I)
               ENDDO
            ENDIF
         ENDDO
      ENDIF  
C
C Add another term if CONST = .TRUE.
C
      IF (CONST) THEN
         DO I = K1, NMOD
            X(I) = ZERO
         ENDDO
         X(NPAR) = XSTORE(NPAR)
         CALL QMODEL (NPAR,
     +                X)
         IF (ICOUNT.EQ.1) THEN
            N4 = NPTS
            DO I = K1, NPTS
               Y4(I) = THEORY(I)
            ENDDO
         ELSEIF (ICOUNT.EQ.2) THEN
            N5 = NPTS
            DO I = K1, NPTS
               Y5(I) = THEORY(I)
            ENDDO
         ELSEIF (ICOUNT.EQ.3) THEN
            N6 = NPTS
            DO I = K1, NPTS
               Y6(I) = THEORY(I)
            ENDDO
         ELSEIF (ICOUNT.EQ.4) THEN
            N7 = NPTS
            DO I = K1, NPTS
               Y7(I) = THEORY(I)
            ENDDO
         ELSEIF (ICOUNT.EQ.5) THEN
            N8 = NPTS
            DO I = K1, NPTS
               Y8(I) = THEORY(I)
            ENDDO
         ELSEIF (ICOUNT.EQ.6) THEN
            N9 = NPTS
            DO I = K1, NPTS
               Y9(I) = THEORY(I)
            ENDDO
         ELSEIF (ICOUNT.EQ.7) THEN
            N10 = NPTS
            DO I = K1, NPTS
               Y10(I) = THEORY(I)
            ENDDO
         ELSEIF (ICOUNT.EQ.8) THEN
            N11 = NPTS
            DO I = K1, NPTS
               Y11(I) = THEORY(I)
            ENDDO
         ELSEIF (ICOUNT.EQ.9) THEN
            N12 = NPTS
            DO I = K1, NPTS
               Y12(I) = THEORY(I)
            ENDDO
         ENDIF
      ENDIF
C
C Restore X and THEORY to original values
C
      DO I = 1, NPAR
         X(I) = XSTORE(I)
      ENDDO
      CALL QMODEL (NPAR,
     +             X)
      ABORT = .FALSE.
      END
C
C
      SUBROUTINE ZMSTOR (NOUT, NPAR, NPTS,
     +                   WSSQ)
C
C ACTION : Store points for F-test
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 22/11/1998
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT, NPAR, NPTS
      DOUBLE PRECISION, INTENT (IN) :: WSSQ
C
C Locals
C      
      EXTERNAL   FTEST1
      CALL FTEST1 (NOUT, NPAR, NPTS,
     +             WSSQ)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ZMTYPE (LWTYPE, MODEL, NMOD, NPAR, NVAR, 
     +                   DEQN)
C
C ACTION : Choose type of linear regression
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 03/02/1999
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN)  :: MODEL, NMOD, NPAR, NVAR
      INTEGER, INTENT (OUT) :: LWTYPE
      LOGICAL, INTENT (IN)  :: DEQN
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 3,
     +           NSTART = 16, NTEXT = 18)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      CHARACTER  TEXT(NTEXT)*100
      LOGICAL    FIXED, FLASH, HIGH
      PARAMETER (FIXED = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      LWTYPE = 1
      IF (MODEL.EQ.1 .AND. NMOD.EQ.1 .AND. NPAR.LE.2 .AND. NVAR.EQ.1
     +    .AND. .NOT.DEQN) THEN
         WRITE (TEXT,100)
         NUMBLD(1) = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, LWTYPE, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                FIXED, FLASH, HIGH)
      ENDIF
  100 FORMAT (
     + 'Line fitting options'
     +/
     +/'You can now fit a straight line by nonlinear regression using'
     +/'y = p(1)x + p(2) with various weights and objective functions.'
     +/'If there is error in y but not in x, you should use a normal'
     +/'regression and minimise the sum of [(y(i) - f(x(i)))/s(i)]^2.'
     +/'Where there is error in both y and x you can use reduced major'
     +/'axis regression, which minimises the sum of triangular areas,'
     +/'i.e. minimising the sum of [(y(i) - f(x(i)))/{g(p(1))*s(i)}]^2,'
     +/'where g(p(1)) = sqrt[abs(p(1)] and p(1) scales proportionately'
     +/'by changes in the scale of x. Alternatively, you can mimimise'
     +/'the sum of distances, as in major axis regression (principal'
     +/'component or orthogonal regression) by minimising the above'
     +/'sum but with g(p(1)) = sqrt[1 + p(1)^2], but this does not'
     +/'scale the slope estimate (i.e. p(1)) proportionately.'
     +/'Normal regression'
     +/'Reduced major axis'
     +/'Major axis')
      END
C
C
