C
C QNFIT09.INS: Multifunction routines
C ============
C
C Note: this version uses MODNAM(24)*80 and uses KMAX_A, KMAX_F,
C       KMAX_J and KMAX_Y to dimension the call to QNUSER
C
C MULT1A
C MULT1B
C MULT1C
C MULT1D
C
C----------------------------------------------------------------------
C
      SUBROUTINE MULT1A (NIN, NP, NPAR1, NPTS, NX,
     +                   BL1, BU1, ERROR, FVAL, XVAL, X1,
     +                   ABORT, EQUAL, EXPERT)
C
C ACTION : read in data for qnfit in multi-function mode
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 03/03/1999
C          12/12/2009 added EOFEXP and arguments NPAR1, NX, BL1, BU, X1, EXPERT
C
C          NP = max. dimension of arrays
C          NPTS = total length of data vector
C          ERROR = S values off data files
C          FVAL = Observed function values
C          XVAL = Observed x-values
C          ABORT = .FALSE. for successful read in
C          EQUAL = .FALSE. since not used when defining THEORY

      USE MODULE_QNFIT, ONLY : IADDUP, INDEXM, NPTBIG, NUMEQN, NUMPNT, 
     +                         MULTI1, M1DATA, M1MOD, 
     +                         NTMAX, NYMAX, IMW,
     +                         SMULT, STEMP, WMULT, XMULT, XTEMP, YMULT,
     +                         YTEMP  

C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: NIN, NP, NX
      INTEGER,          INTENT (INOUT) :: NPAR1
      INTEGER,          INTENT (INOUT) :: NPTS
      DOUBLE PRECISION, INTENT (INOUT) :: BL1(NX), BU1(NX), ERROR(NP),
     +                                    FVAL(NP), XVAL(NP), X1(NX)
      LOGICAL,          INTENT (OUT)   :: ABORT 
      LOGICAL,          INTENT (INOUT) :: EQUAL(NP), EXPERT
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, N0
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, N0 = 0)
      INTEGER    I, J, MEQN, MEQSAV
      CHARACTER  LINE*100
      CHARACTER  FNAMES(NYMAX)*1024, TITLES(NYMAX)*80
      CHARACTER  BLANK*1, PCENT*1
      PARAMETER (BLANK = ' ', PCENT = '%')
      LOGICAL    YES, SUPPLY, THERE
      SAVE       MEQN
      DATA       MEQN / 3 /
      EXTERNAL   DATBIG, GETJM1, PUTADV, YESNO2, EOFEXP, DATMUL
C
C Special action if M1DATA = .TRUE.
C
      CLOSE (UNIT = NIN) 
      IF (M1DATA) THEN
         YES = .TRUE.
         LINE = 'Re-use the existing multi-function data sets'
         CALL YESNO2 (ICOLOR, IX, IY, 
     +                LINE,
     +                YES)
         IF (YES) THEN
            ABORT = .FALSE.
            IF (M1MOD) THEN
               MULTI1 = .TRUE.
            ELSE
               MULTI1 = .FALSE.
            ENDIF      
            RETURN
         ENDIF
      ENDIF
C
C Initialise the logicals
C
      ABORT = .TRUE.
      M1DATA = .FALSE.
      EXPERT = .FALSE.
C
C Get the multi-function data
C
      MEQSAV = MEQN
      CALL GETJM1 (N0, MEQN, NYMAX,
     +            'Number of equations (all with 1 common variable)')
      IF (MEQN.NE.MEQSAV) THEN
         M1MOD = .FALSE.
         MULTI1 = .FALSE.
      ENDIF   
      NUMEQN = MEQN
      IF (NUMEQN.EQ.0) RETURN
      WRITE (LINE,100) NUMEQN
      CALL PUTADV (LINE)
      CLOSE (UNIT = NIN)
      CALL DATMUL (NUMEQN, NIN, NPTBIG,
     +             FNAMES, TITLES,
     +             ABORT)   
      CLOSE (UNIT = NIN)
      IF (ABORT) THEN
         SUPPLY = .FALSE.
      ELSE
         SUPPLY = .TRUE.
      ENDIF          
      CLOSE (UNIT = NIN)
      CALL DATBIG (IADDUP, INDEXM, IMW, NUMEQN, NIN, NUMPNT, NTMAX,
     +             NYMAX, 
     +             SMULT, STEMP, WMULT, XMULT, XTEMP, YMULT, YTEMP,
     +             FNAMES, TITLES,
     +             ABORT, SUPPLY)
      CLOSE (UNIT = NIN)
      M1DATA = .NOT.ABORT
C
C Copy the data into the working arrays
C
      IF (M1DATA) THEN
C
C Call EOFEXP to see if the file has starting estimates appended
C         
         DO I = 1, NUMEQN
            J = I
            IF (FNAMES(J).NE.BLANK .AND. FNAMES(J).NE.PCENT) THEN
               INQUIRE (FILE = FNAMES(J), EXIST = THERE)
               IF (THERE) EXIT
            ENDIF     
         ENDDO     
         CALL EOFEXP (NPAR1, NX,
     +                BL1, X1, BU1,           
     +                FNAMES(J),
     +                ABORT) 
         IF (NPAR1.GT.0) EXPERT = .TRUE.
         NPTBIG = 0
         NPTS = 0
         DO J = 1, NUMEQN
            IF (NUMPNT(J).GT.0) THEN
               NPTBIG = NPTBIG + NUMPNT(J)
               DO I = 1, NUMPNT(J)
                  NPTS = NPTS + 1
                  ERROR(NPTS) = SMULT(I,J)
                  FVAL(NPTS) = YMULT(I,J)
                  XVAL(NPTS) = XMULT(I,J)
                  EQUAL(NPTS) = .FALSE.
                  IF (NPTS.EQ.NP) THEN
                     CALL PUTADV ('NPTS >= NP in subroutine MULT1B')
                     RETURN
                  ENDIF
               ENDDO
            ENDIF
         ENDDO
      ENDIF
      CLOSE (UNIT = NIN)
C
C If data and model are present then MULTI1 = .TRUE.
C     
      IF (M1DATA .AND. M1MOD) THEN
         MULTI1 = .TRUE.
      ELSE  
         MULTI1 = .FALSE.
      ENDIF   
C
C Format statement
C      
  100 FORMAT (
     +'Now supply files or a library file for',I4,' (x,y,s) data sets')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE MULT1B (ABORT)
C
C ACTION : read in an ASCII model file for multi-function mode
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 03/03/1999

      USE MODULE_QNFIT, ONLY : KMAX_A, KMAX_J, KMAX_F, KMAX_Y, NYMAX,
     +                         NUMEQN, NUMPAR, NUMVAR, 
     +                         MULTI1,
     +                         AMULT, FMULT, YMDE, YMJACC, 
     +                         NAMMOD,
     +                         M1DATA, M1MOD

C
      IMPLICIT   NONE
C
C Argument
C 
      LOGICAL, INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    ICOLOR, ISEND, IX, IY
      PARAMETER (ICOLOR = 3, ISEND = 1, IX = 4, IY = 4)
      DOUBLE PRECISION X1, Y1, Z1
      CHARACTER  LINE*100
      LOGICAL    DEQN, YES
      PARAMETER (DEQN = .FALSE.)
      EXTERNAL   QNUSER, PUTADV, YESNO2
C
C Special action if MULTI1 = .TRUE.
C
      IF (M1MOD) THEN
         YES = .TRUE.
         LINE = 'Re-use the current ASCII text model file'
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE, 
     +                YES)
         IF (YES) THEN
            ABORT = .FALSE.
            IF (M1DATA) THEN
               MULTI1 = .TRUE.
            ELSE
               MULTI1 = .FALSE.
            ENDIF                        
            RETURN
         ENDIF
      ENDIF
      ABORT = .TRUE.
C
C Call the DLL USER_FILE
C
      IF (NUMEQN.LT.1 .OR. NUMEQN.GT.NYMAX) RETURN
      NUMVAR = 1
      WRITE (LINE,100) NUMEQN
      CALL PUTADV (LINE)
      CALL QNUSER (ISEND,
     +             KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +             NUMEQN, NUMPAR, NUMVAR, NYMAX,
     +             AMULT, FMULT, X1, Y1, YMDE, YMJACC, Z1,
     +             NAMMOD, 
     +             ABORT, DEQN)
      M1MOD = .NOT.ABORT
C
C If data and model are present then MULTI1 = .TRUE.
C
      IF (M1DATA .AND. M1MOD) THEN
         MULTI1 = .TRUE.
      ELSE
         MULTI1 = .FALSE.
      ENDIF      
C
C Format statement
C        
  100 FORMAT ('Now supply an ASCII model file for',I4,' equations')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE MULT1C (NP, NPLOT,
     +                   XMAX, XMIN, XPLOT, X1, X3, X5, X7, X9, X11,
     +                   Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10, Y11,
     +                   Y12)
C
C ACTION : Extra plotting after fitting in QNFIT
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 20/11/98
C          08/01/2017 changed plotting symbols in call to GKS012

      USE MODULE_QNFIT, ONLY : KMAX_A, KMAX_J, KMAX_F, KMAX_Y, 
     +                         NPMAX,  
     +                         NUMEQN, NUMPAR, NUMPNT, NUMVAR,
     +                         AMULT, FMULT, XMULT, YMDE, YMULT, YMJACC,
     +                         NAMMOD 

C
      IMPLICIT   NONE

C
C Arguments
C
      INTEGER,          INTENT (IN)    :: NP, NPLOT
      DOUBLE PRECISION, INTENT (IN)    :: XMAX, XMIN
      DOUBLE PRECISION, INTENT (INOUT) :: XPLOT(NPLOT), X1(NP), X3(NP),
     +                                    X5(NP), X7(NP), X9(NP),
     +                                    X11(NP), Y1(NP), Y2(NPLOT), 
     +                                    Y3(NP), Y4(NPLOT), Y5(NP),
     +                                    Y6(NPLOT), Y7(NP), Y8(NPLOT),
     +                                    Y9(NP), Y10(NPLOT), Y11(NP), 
     +                                    Y12(NPLOT)
C
C Locals
C     
      INTEGER    I, J, K, NPTS1
      INTEGER    K2
      PARAMETER (K2 = 2)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 6,
     +           NSTART = 15, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    KVEC(6)
      INTEGER    NUMBLD(NTEXT), KUMPOS(NUMOPT)
      INTEGER    L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12,
     +           M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12,
     +           N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12
      DOUBLE PRECISION XMAX1, XMIN1
      DOUBLE PRECISION XX, YY, ZZ
      CHARACTER  TEXT(NTEXT)*100, LINE*100
      CHARACTER  PTITLE*30, XTITLE*1, YTITLE*1
      PARAMETER (XTITLE = 'x', YTITLE = 'y')
      LOGICAL    ABORT
      LOGICAL    FIXED, FLASH, HIGH
      PARAMETER (FIXED = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    DEQN, GSAVE1, GSAVE2
      PARAMETER (DEQN = .FALSE., GSAVE1 = .TRUE., GSAVE2 = .TRUE.)
      EXTERNAL   DIVIDE, LBOX01, GKS012, GETJM1, GETDGE, GETDLE, QNUSER
      SAVE       NPTS1, KVEC
      DATA       NUMBLD / NTEXT*0 /
      DATA       KUMPOS / NUMOPT*1 /
      DATA       NPTS1 / 120 /
      DATA       L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12
     +         /  0,  1,  0,  1,  0,  1,  0,  1,  0,   1,   0,   1 /
      DATA       M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12
     +         /  5,  0,  8,  0, 14,  0,  11,  0,  6,   0,  9,   0 /
      DATA       KVEC / 1, 2, 3, 4, 5, 6 /
C
C Initialise then calculate a set of default best-fit curves
C
      XMAX1 = XMAX
      XMIN1 = XMIN
      DO I = 1, 6
         IF (KVEC(I).GT.NUMEQN) KVEC(I) = 0
      ENDDO
C
C LABEL 20: branch point for calculating plotting data
C =========
C
   20 CONTINUE
      N1 = 0
      N2 = 0
      N3 = 0
      N4 = 0
      N5 = 0
      N6 = 0
      N7 = 0
      N8 = 0
      N9 = 0
      N10 = 0
      N11 = 0
      N12 = 0
C
C Fill in the data points for X and Y as determined by KVEC
C
      DO J = 1, 6
         IF (J.EQ.1 .AND. KVEC(J).GT.0) THEN
            DO I = 1, NUMPNT(KVEC(J))
               N1 = N1 + 1
               X1(N1) = XMULT(N1,KVEC(J))
               Y1(N1) = YMULT(N1,KVEC(J))
            ENDDO
         ELSEIF (J.EQ.2 .AND. KVEC(J).GT.0) THEN
            DO I = 1, NUMPNT(KVEC(J))
               N3 = N3 + 1
               X3(N3) = XMULT(N3,KVEC(J))
               Y3(N3) = YMULT(N3,KVEC(J))
            ENDDO
         ELSEIF (J.EQ.3 .AND. KVEC(J).GT.0) THEN
            DO I = 1, NUMPNT(KVEC(J))
               N5 = N5 + 1
               X5(N5) = XMULT(N5,KVEC(J))
               Y5(N5) = YMULT(N5,KVEC(J))
            ENDDO
         ELSEIF (J.EQ.4 .AND. KVEC(J).GT.0) THEN
            DO I = 1, NUMPNT(KVEC(J))
               N7 = N7 + 1
               X7(N7) = XMULT(N7,KVEC(J))
               Y7(N7) = YMULT(N7,KVEC(J))
            ENDDO
         ELSEIF (J.EQ.5 .AND. KVEC(J).GT.0) THEN
            DO I = 1, NUMPNT(KVEC(J))
               N9 = N9 + 1
               X9(N9) = XMULT(N9,KVEC(J))
               Y9(N9) = YMULT(N9,KVEC(J))
            ENDDO
         ELSEIF (J.EQ.6 .AND. KVEC(J).GT.0) THEN
            DO I = 1, NUMPNT(KVEC(J))
               N11 = N11 + 1
               X11(N11) = XMULT(N11,KVEC(J))
               Y11(N11) = YMULT(N11,KVEC(J))
            ENDDO
         ENDIF
      ENDDO
C
C Divide up XPLOT for the best fit curves
C
      CALL DIVIDE (NPTS1,
     +             XPLOT, XMIN1, XMAX1)
C
C Use the NPTS1 distinct x-values in XPLOT to define the model values
C
      DO I = 1, NPTS1
         XX = XPLOT(I)
         CALL QNUSER (K2,
     +                KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                NUMEQN, NUMPAR, NUMVAR, NPMAX, AMULT,
     +                FMULT, XX, YY, YMDE, YMJACC, ZZ, NAMMOD,
     +                ABORT, DEQN)
         DO J = 1, 6
            IF (J.EQ.1 .AND. KVEC(J).GT.0) THEN
               N2 = N2 + 1
               Y2(N2) = FMULT(KVEC(J))
            ELSEIF (J.EQ.2 .AND. KVEC(J).GT.0) THEN
               N4 = N4 + 1
               Y4(N4) = FMULT(KVEC(J))
            ELSEIF (J.EQ.3 .AND. KVEC(J).GT.0) THEN
               N6 = N6 + 1
               Y6(N6) = FMULT(KVEC(J))
            ELSEIF (J.EQ.4 .AND. KVEC(J).GT.0) THEN
               N8 = N8 + 1
               Y8(N8) = FMULT(KVEC(J))
            ELSEIF (J.EQ.5 .AND. KVEC(J).GT.0) THEN
               N10 = N10 + 1
               Y10(N10) = FMULT(KVEC(J))
            ELSEIF (J.EQ.6 .AND. KVEC(J).GT.0) THEN
               N12 = N12 + 1
               Y12(N12) = FMULT(KVEC(J))
            ENDIF
         ENDDO
      ENDDO
C
C LABEL 40: Main loop for repeat operations
C =========
C
   40 CONTINUE
      WRITE (TEXT,100) NPTS1, XMAX1, XMAX, XMIN1, XMIN,
     +                (KVEC(I), I = 1, 6)
      NUMDEC = 5
      NUMBLD(1) = 4
      NUMBLD(3) = 1
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             KUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             FIXED, FLASH, HIGH)
      NUMBLD(1) = 0
      NUMBLD(3) = 0
      IF (NUMDEC.EQ.1) THEN
C
C Change NPTS1
C
         NPTS1 = NPLOT
         CALL GETJM1 (K2, NPTS1, NPLOT,
     +               'Value required for N_plot')
      ELSEIF (NUMDEC.EQ.2) THEN
C
C Change XMAX1
C
         WRITE (LINE,200) XMAX1, XMAX
         CALL GETDGE (XMAX1, XMIN1,
     +                LINE)
      ELSEIF (NUMDEC.EQ.3) THEN
C
C Change XMIN1
C
         WRITE (LINE,200) XMIN1, XMIN
         CALL GETDLE (XMIN1, XMAX1,
     +                LINE)
      ELSEIF (NUMDEC.EQ.4) THEN
C
C Change the plotting sequence
C
         I = 1
         J = I
         K = 6
         CALL GETJM1 (I, J, K, 
     +               'The sequence number required')
         I = 0
         K = NUMEQN
         KVEC(J) = 1
         CALL GETJM1 (I, KVEC(J), K,
     +'Number of data/best-fit curve pair to plot at this point')
      ELSEIF (NUMDEC.EQ.5) THEN
C
C Extrapolate
C
            PTITLE = 'Data and Current Model'
            CALL GKS012 (L1, L2, L3, L4, L5, L6, L7, L8, L9, L10,
     +                   L11, L12,
     +                   M1, M2, M3, M4, M5, M6, M7, M8, M9, M10,
     +                   M11, M12,
     +                   N1, N2, N3, N4, N5, N6, N7, N8, N9, N10,
     +                   N11, N12,
     +                   X1, XPLOT, X3, XPLOT, X5, XPLOT, X7, XPLOT,
     +                   X9, XPLOT, X11, XPLOT,
     +                   Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10,
     +                   Y11, Y12,
     +                   PTITLE, XTITLE, YTITLE,
     +                   GSAVE1, GSAVE2)
      ENDIF
C
C If NPTS1, XMAX1 or XMIN1 have been changed then recalculate plotting data
C
      IF (NUMDEC.GE.1 .AND. NUMDEC.LE.4) THEN
         GOTO 20
      ELSEIF (NUMDEC.LT.NUMOPT) THEN
         GOTO 40
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Multi-function plotting options'
     +/
     +/'N_plot, X_max and X_min control extrapolation'
     +/
     +/'N_plot =',I5
     +/'X_max =',1P,E11.3,' (data =',E11.3,')'
     +/'X_min =',   E11.3,' (data =',E11.3,')'
     +/'Sequence 1 (plot items 1/2)   `: data/best-fit',I3
     +/'Sequence 2 (plot items 3/4)   `: data/best-fit',I3
     +/'Sequence 3 (plot items 5/6)   `: data/best-fit',I3
     +/'Sequence 4 (plot items 7/8)   `: data/best-fit',I3
     +/'Sequence 5 (plot items 9/10)  `: data/best-fit',I3
     +/'Sequence 6 (plot items 11/12) `: data/best-fit',I3
     +/
     +/'Change N_plot'
     +/'Change X_max'
     +/'Change X_min'
     +/'Change sequence'
     +/'Plot'
     +/'Cancel')
  200 FORMAT ('Value required: current =', 1P,E11.3,', data =',E11.3)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE MULT1D
C
C ACTION: Call MULT1C for a starting-estimate-plot before fitting
C AUTHOR: w.g.bardsley, university of manchester, u.k., 12/12/2009
C         05/02/2010 introduced XHIGH and XLOW 
C
C         This routine use the arrays as work space except for the raw data in
C         XMULT which is used to calcuklate XMAX and XMIN. It requires that the
C         current factors and parameters are made avaiable for model evaluation.
C      
      USE MODULE_QNFIT, ONLY : NP, NPLOT, 
     +                         NUMEQN, NUMPNT,
     +                         XMULT, XPLOT,
     +                         T, U, V, W, XVAL, ZVAL,
     +                         Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10,
     +                         Y11, Y12  
      IMPLICIT NONE
      INTEGER  I, J
      DOUBLE PRECISION XMAX, XMIN, XTEMP
      DOUBLE PRECISION XHIGH, XLOW
      PARAMETER (XHIGH = 1.0D+00, XLOW = - XHIGH)
      EXTERNAL MULT1C
C
C Calculate XMAX and XMIN as they mey be changed by MULT1C
C      
      XMAX = XLOW
      XMIN = XHIGH
      DO J = 1, NUMEQN
         IF (NUMPNT(J).GT.0) THEN
            DO I = 1, NUMPNT(J)
               XTEMP = XMULT(I,J)
               IF (XTEMP.GT.XMAX) XMAX = XTEMP
               IF (XTEMP.LT.XMIN) XMIN = XTEMP  
            ENDDO   
         ENDIF
      ENDDO
      CALL MULT1C (NP, NPLOT,
     +             XMAX, XMIN, XPLOT, T, U, V, W, XVAL, ZVAL,
     +             Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10, Y11,
     +             Y12)
      END
C
C      