C
C QNFIT10.INS
C =========== 
C 
C ADVISE
C QNDAT5
C QNITER
C QNLGLS
C QNPLOT uses MODULE_QNFIT
C QNPCHK
C
C----------------------------------------------------------------------
C
      SUBROUTINE ADVISE (NMAX,
     +                   DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)  :: NMAX
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (OUT) :: ABORT
      LOGICAL,             INTENT (IN)  :: FIRST
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 15, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  OPTION(NUMOPT)*50, TEXT(30)*100
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_QNFIT
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (TEXT,100) DVER, NMAX
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   TEXT, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_QNFIT ('qnfit')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `QNFIT'
     +/'        `      '
     +/'Action  `Constrained nonlinear weighted least squares curve'
     +/'        `fitting by the quasi-Newton method.'
     +/'        `      '
     +/'Models  `Simfit Libraries or user-defined models'
     +/'        `      '
     +/'Version `',A
     +/'        `Maximum number of rows',I6
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
       END

C
C--------------------------------------------------------------------------
C
      SUBROUTINE QNDAT5 (NIN, NPTS, NVEC,
     +                   FNAME, TITLE,
     +                   ABORT)
C
C ACTION : get data files for passing to DAT5IN
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          21/01/2010 developed fron DAT5IN
C
C          NIN: (input/unchanged) unconnected unit for data input
C         NPTS: (output) number of data points
C         NVEC: (input/unchanged) number of vectors
C        FNAME: (output) file name
C        TITLE: (output) data title
C        ABORT: (output) error indicator
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)  :: NIN, NVEC 
      INTEGER,             INTENT (OUT) :: NPTS
      CHARACTER (LEN = *), INTENT (OUT) :: FNAME, TITLE
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    I, ICOUNT, IOS, J, NCOL, NROW
      INTEGER    N0, N1, N2, N3, N5
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N5 = 5)
      INTEGER    NCBOT, NCMID, NCTOP, NRBOT, NRMID, NRTOP
      DOUBLE PRECISION V1, V2, V3, V4, V5
      CHARACTER  LINE*100
      LOGICAL    XYONLY
      EXTERNAL   OFILES, CHKFIL, PUTADV, CHECKF, ISITSF
      V1 = 1.0D+00!this and next 5 lines to silence NAGfor	
      V2 = V1
      V3 = V2
      V4 = V3
      V5 = V4
      V1 = V5
C
C Initialise and check
C
      ABORT = .TRUE.
      NPTS = 0
      WRITE (FNAME,100)
      WRITE (TITLE,200)
      IF (NIN.LT.N1 .OR. NVEC.LT.N1 .OR. NVEC.GT.N5) THEN
         WRITE (LINE,300)
         CALL PUTADV (LINE)
         RETURN
      ENDIF      
C
C Attempt to open a data file
C
      CLOSE (UNIT = NIN)
      CALL OFILES (N3, NIN,
     +             FNAME,
     +             ABORT)
      CLOSE (UNIT = NIN)
      IF (ABORT) THEN
         WRITE (FNAME,100)
         WRITE (TITLE,200)
         RETURN
      ENDIF
C
C Check that the file is a data file
C      
      CALL ISITSF (NCOL, NROW,
     +             FNAME)
      IF (NCOL.GT.N0 .AND. NROW.GT.N0) THEN
         OPEN (UNIT = NIN, FILE = FNAME)
      ELSE
         ABORT = .TRUE.
         WRITE (FNAME,100)
         WRITE (TITLE,200)         
         RETURN
      ENDIF            
C
C File is present ... check title, header and data
C
      ABORT = .TRUE.
      NCBOT = NVEC
      NCTOP = NVEC
      NRBOT = N1
      ICOUNT = N1
      READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
      IF (IOS.NE.0) GOTO 20
      ICOUNT = N2
      READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
      IF (IOS.NE.N0) GOTO 20
      NCMID = J
      NRMID = I
C
C Check if S values are being supplied
C
      IF (NVEC.GT.N2 .AND. NCMID.EQ.NVEC - N1) THEN
         XYONLY = .TRUE.
      ELSEIF (NCMID.EQ.NVEC) THEN
         XYONLY = .FALSE.
      ELSE
         GOTO 20
      ENDIF
      IF (NRMID.LT.N1) GOTO 20
C
C Now give the user the option to view/accept/reject
C
      CLOSE (UNIT = NIN)
      CALL CHECKF (FNAME, TITLE,
     +             ABORT)
      IF (ABORT) THEN
C
C User does not want these data
C
         WRITE (FNAME,200)
         WRITE (TITLE,300)
         RETURN
      ELSE
C
C Re-connect the file and wind on
C
         OPEN (UNIT = NIN, FILE = FNAME)
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
      ENDIF
      NPTS = NRMID
      IF (XYONLY) THEN
C
C Read data but final column of s-values set = 1
C
         DO I = N1, NPTS
            ICOUNT = ICOUNT + 1
            IF (NVEC.EQ.3) THEN
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1, V2
            ELSEIF (NVEC.EQ.4) THEN
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1, V2, V3
            ELSE
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1, V2,
     +                                               V3, V4
            ENDIF
            IF (IOS.NE.N0) GOTO 20
         ENDDO
      ELSE
C
C Read data and final column of s-values
C
         DO I = N1, NPTS
            ICOUNT = ICOUNT + 1
            IF (NVEC.EQ.1) THEN
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1
            ELSEIF (NVEC.EQ.2) THEN
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1, V2
            ELSEIF (NVEC.EQ.3) THEN
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1, V2, V3
            ELSEIF (NVEC.EQ.4) THEN
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1, V2, V3, V4
            ELSE
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1, V2,
     +                                               V3, V4, V5
            ENDIF
            IF (IOS.NE.N0) GOTO 20
         ENDDO
      ENDIF
C
C Success so return with file still connected for further reading
C
      ABORT = .FALSE.
      RETURN
C
C Label 20: Here if a crash has occurred reading the file
C ========
C
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      NRTOP = 100000
      CALL CHKFIL (ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID,
     +             NRTOP,
     +             FNAME, TITLE)
      WRITE (FNAME,100)
      WRITE (TITLE,200)            
C
C Format statements
C      
  100 FORMAT ('No current file')
  200 FORMAT ('No current data')
  300 FORMAT ('NIN, or NVEC out of range in call to QNDAT5')
      END
C
C----------------------------------------------------------------------
C 
c
c
      subroutine qniter (n,
     +                   iter,
     +                   action)
c
c action: iteration data for qnfit
c author: w.g.bardsley, university of manchester, u.k., 11/03/2017
c
c      n: number of iteration files
c   iter: iteration files
c action: if .true. copy iter(3) into iter(4)
c         o/w option to view iteration files 
c
     
      implicit   none
c
c arguments
c      
      integer,             intent (in)    :: n
      character (len = *), intent (inout) :: iter(n) 
      logical,             intent (in)    :: action          
c
c locals
c      
      integer    isend, n6, n8, nhelp
      parameter (isend = 1, n6 = 6, n8 = 8, nhelp = 25) 
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 6, numsta = 18, numtxt = numsta + numopt - 1) 
      integer    ios, l, nin, nout, numbld(30)
      character (len = 256) line
      character (len = 100) text(30)
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    op, repeet, there
      external   lstbox, viewer, putadv, revpro, patch2, getnou
      intrinsic  len_trim, trim
      data       numbld / 30*0 /
c
c check n
c      
      if (n.ne.4) then
         call putadv ('N inconsistent in call to QNITER')
         return
      endif
c
c check action
c      
      if (action) then
         inquire (file = iter(3), exist = there, opened = op,
     +            iostat = ios)
         if (ios.eq.0 .and. there .and. .not.op) then
            call getnou (nin)
            open (unit = nin, file = iter(3), iostat = ios)
            if (ios.ne.0) then
               close (unit = nin)
               return
            endif
            l = len_trim(iter(3))
            iter(4) = iter(3)(1:l - 3)//'tmp'
            call getnou (nout)
            open (unit = nout, file = iter(4), iostat = ios) 
            if (ios.ne.0) then
               close (unit = nin)   
               close (unit = nout)
               return
            endif   
            do while (ios.eq.0)
               read (nin,'(a)',iostat=ios) line
               if (ios.eq.0) write (nout,'(a)',iostat=ios) trim(line)
            enddo      
            close (unit = nin)
            close (unit = nout)
         endif   
         return
      endif
      
      numdec = numopt
      repeet = .true.
      do while (repeet)
         write (text,100)
         numbld(1) = 4
         numbld(6) = 1
         numbld(9) = 1
         numbld(13) = 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         numbld(6) = 0
         numbld(9) = 0
         numbld(13) = 0
         if (numdec.lt.numopt - 1) then
            inquire (file = iter(numdec), exist = there, opened = op, 
     +               iostat = ios) 
            if (ios.ne.0) then
               call putadv ('INQUIRE IOS not zero for this file') 
            elseif (iter(numdec).eq.blank) then
               call putadv ('Filename selected is blank')     
            elseif (.not.there) then
               call putadv ('File does not exist or is empty')
            elseif (op) then
               if (numdec.eq.1) then
                  call revpro (n8) 
               elseif (numdec.eq.2) then   
                  call revpro (n6) 
               else
                  call putadv ('File is connected')
               endif     
            else    
               call viewer (isend,
     +                      iter(numdec), blank, blank)
            endif
         elseif (numdec.eq.numopt - 1) then  
            write (text,200)
            numbld(1) = 4
            numbld(3) = 1
            numbld(13) = 1
            call patch2 (numbld, nhelp,
     +                   text)
            numbld(1) = 0
            numbld(3) = 0
            numbld(13) = 0            
         else     
           repeet = .false.
         endif  
      enddo       
  100 format (
     + 'QNFIT diagnostic iteration records'
     +/     
     +/'Files archived in the ...user\documents\simfit\res\'
     +/'folder containing iteration data are as follows'
     +/
     +/'iterate.txt'
     +/'Iterations from LBFGSB stored during each session'
     +/     
     +/'w_qnfit.txt'
     +/'Summary for LBFGSB but some versions containt extra data'     
     +/'(e.g. if DVODE is used to fit differential equations.)'
     +/
     +/'iteration.dat (Also used by program USERMOD)'
     +/'Parameters supplied for function evaluation and function'     
     +/'values returned are written for individual optimisations'
     +/'with all optimisers and DE solvers.'
     +/     
     +/'View iterate.txt'
     +/'View w_qnfit.txt'
     +/'View iterate.dat (current)'
     +/'View iterate.dat (previous)'
     +/'Help'
     +/'Cancel ... Exit this diagnostic session')
  200 format (
     + 'Archiving the optimisation iteration data'
     +/ 
     +/'iterate.txt and w_qnfit.txt'    
     +/'As each session starts QNFIT empties the two files'
     +/'iterate.txt and w_qnfit.txt but then keeps them open'
     +/'for the current run to append data. If data are needed'
     +/'subsequently they must be saved after QNFIT closes.'
     +/'iterate.txt just contains the iterates, while w_qnfit.txt'
     +/'stores a summary from each optimisation. In addition, some'     
     +/'versions of QNFIT wil hold more extensive iteration data,'
     +/'particularly if DVODE is used to fit differential equations.'     
     +/
     +/'iterate.dat (Also used by program USERMOD)'
     +/'The file iterate.dat is much more extensive and is only'
     +/'required in circumstances where an optimisation fails to'
     +/'converge or crashes. Irrespective of which optimiser or'     
     +/'DE solver is used, this file records the parameter values'
     +/'supplied by the optimiser in the first columns along with'
     +/'the objective function returned in the last column. It must'     
     +/'be realised that parameters are also supplied for function'
     +/'evaluation in order to calculate the gradient vector by'
     +/'central differences during reverse communication, so the'
     +/'file can become very large. For this reason the previous'
     +/'version is stored, then a new file is opened for each cycle'
     +/'of fitting. So any useful data must be saved as required.')     
      end
c      
c
c       
C----------------------------------------------------------------------
C
      logical function qnlgls (n)
c
c action: return logical variables for qnfit
c author: w.g.bardsley, university of manchester, u.k., 18/11/2009
c
      implicit none
c
c argument
c         
      integer, intent (in) :: n
c
c locals
c
      integer    nmax
      parameter (nmax = 18)
      character (len = 100) text(nmax), title   
      external   chkbox 
      logical    lglvar(nmax)
      save       lglvar
      data       lglvar / .true.,    ! 1. short summary
     +                    .true.,    ! 2. table of parameters
     +                    .true.,    ! 3. plot data
     +                    .false.,   ! 4. correlation matrix
     +                    .false.,   ! 5. Hessian
     +                    .false.,   ! 6. display residuals
     +                    .false.,   ! 7. file residuals
     +                    .false.,   ! 8. save residuals
     +                    .true.,    ! 9. display residuals summary
     +                    .true.,    !10. file residuals summary
     +                    .false.,   !11. residuals plot
     +                    .false.,   !12. check for large number of parameters
     +                    .false.,   !13. display EXPERT MODE limits from data file
     +                    .false.,   !14. display at limits before fitting
     +                    .false.,   !15. display at limits after fitting
     +                    .false.,   !16. allow random search before fitting
     +                    .false.,   !17. check for x in increasing order
     +                    .false. /  !18. option to suppress/restore data
      if (n.lt.1 .or. n.gt.nmax) then
         write (title,100)
         write (text,200)
         call chkbox (nmax,
     +                text, title,
     +                lglvar)
         qnlgls = .false.
      else
         qnlgls = lglvar(n)
      endif   
  100 format (
     +'Select the options required for subsequent QNFIT procedures')
  200 format (
     + 'Best-fit model: display/file short summary'
     +/'Best-fit model: display/file table of parameters'
     +/'Best-fit model: plot data with best-fit curve'
     +/'Best-fit model: display/file correlation matrix'
     +/'Best-fit model: display/file Hessian eigenvalues, etc.'
     +/'Table of residuals: display'
     +/'Table of residuals: file'
     +/'Table of residuals: Save As ...'
     +/'Analysis of residuals: display'
     +/'Analysis of residuals: file'
     +/'Analysis of residuals: display diagnostic plots'
     +/'Parameters: warning if there are a large number'
     +/'Parameters: display limits provided by data file'
     +/'Parameters: display when at limits before fitting'
     +/'Parameters: display when at limits after fitting'
     +/'Parameters: random search for starting estimates'
     +/'Data: check for x not in increasing order, etc.'
     +/'Data: suppress/restore values interactively')
      end
c       
c----------------------------------------------------------------------
c       
      subroutine qnplot
c
c action: plot data and starting-estimate-curve
c author: w.g.bardsley, university of manchester, u.k., 07/12/2009
c      
      use module_qnfit, only : npar, nplot, npts, nvar,
     +                         fval, theory, x, xval, xsav, y2, y4,
     +                         equal, eqsav, m1data
      implicit none
      integer    i, nptsav
      integer    l1, l2, l3, l4, m1, m2, m3, m4, n1, n2, n3, n4
      parameter (l1 = 0, l2 = 1, l3 = 0, l4 = 0,
     +                   m2 = 0, m3 = 0, m4 = 0,
     +                           n3 = 2, n4 = 2)     
      double precision xmax, xmin
      logical    axes, gsave
      parameter (axes = .true., gsave = .true.)
      external   divide, qmodel, PUTADV, gks004 
c
c check for 1 variable
c      
      if (nvar.gt.1 .or. m1data) then
         call PUTADV ('Only for one function of one variable')
         return
      endif
c
c store the data and calculate xmax and xmin
c      
      nptsav = npts   
      npts = nplot
      xmax = xval(1)
      xmin = xmax
      do i = 1, nptsav
         if (xval(i).gt.xmax) xmax = xval(i)
         if (xval(i).lt.xmin) xmin = xval(i)  
         xsav(i) = xval(i)
         eqsav(i) = equal(i)
      enddo
c
c create a best-fit curve adding a final point for DVODE if required
c      
      call divide (npts,
     +             xval, xmin, xmax)  
      do i = 1, npts + 1
         equal(i) = .false.
      enddo  
      call qmodel (npar,
     +             x)
c
c plot
c     
      m1 = 1
      n1 = nptsav
      n2 = nplot
      call gks004 (l1, l2, l3, l4,
     +             m1, m2, m3, m4,
     +             n1, n2, n3, n4,
     +             xsav,   xval, y2,    y4,
     +             fval, theory, y2(3), y4(3),         
     +             'Data and Starting-Estimate-Curve', 'x', 'y',
     +              axes, gsave) 
c
c restore original data
c     
      npts = nptsav
      do i = 1, npts
         xval(i) = xsav(i)
         equal(i)= eqsav(i)
      enddo   
      end
c
c----------------------------------------------------------------------
c      
      subroutine qnpchk (n,
     +                   bl, bu, fact, px, x,
     +                   title,
     +                   action)
c
c action: check qnfit parameter settings
c author: w.g.bardsley, university of manchester, u.k., 16/12/2009
c
c This routine can be called at critical points from the main program,
c i.e. QNFIT.FOR, in order to follow the evolution of parameters, limits,
c and scaling factors. It is intended for use during program development
c to make sure all the scaling is being done properly. The calls are
c controlled by setting CHKPAR in the main program.
c  
c
      implicit none
c
c arguments
c          
      integer,             intent (in) :: n
      double precision,    intent (in) :: bl(n), bu(n), fact(n), px(n),
     +                                    x(n)
      character (len = *), intent (in) :: title       
      logical,             intent (in) :: action
c
c locals
c      
      integer   i, j
      character line*100
      external  table1
      if (n.gt.0 .and. action) then
         j = 15
         call table1 (j, 'OPEN')
         j = 1
         call table1 (j, title)
         write (line,100)
         j = 4
         call table1 (j, line)
         j = 0
         do i = 1, n
            write (line,200) i, bl(i), bu(i), fact(i), px(i), x(i)
            call table1 (j, line)
         enddo
         call table1 (j, 'CLOSE')   
      endif
  100 format ('  i        bl        bu      fact        px         x')
  200 format (i3,5f10.4)     
      end
c
c        
      
             