C
C FTN95 version
C =============
C
C Requires RANNUM1.FOR: WALKER
C
C      INCLUDE 'c:\simfit7\work\rannum1.for', NOLIST
C      INCLUDE 'c:\simfit7\work\x64_dllchk.for', NOLIST
C
C
      PROGRAM MAIN
C
C PROGRAM : RANNUM
C VERSION : details from SIMVER/DLLCHK
C FORTRAN : 95, Double precision
C ACTION  : Generates pseudo-random numbers
C ADVICE    This version is for arbitrary sizes
C NAG     : G05CBF, G05CCF (Seeds)
C           G05ECF, G05EDF
C           G05CAF, G05DBF, G05DCF, G05DDF, G05DEF, G05DFF, G05FFF,
C           G05DHF, G05DPF (REAL)
C           G05DYF, G05EYF (INTEGER)
C           X02AMF
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K.
C DATE    : 05/08/1990
C           28/02/1993 Added GET???, PUT??? and compressed
C           19/01/1994 DBOS version
C           20/02/1995 Version for Salamanca
C           13/5/97 win32 version
C           03/04/1998 Added random walk
C           07/08/1998 added dllchk
C           14/12/1998 replaced TUTORS by TUTOR1
C           13/09/1999 added call to WINDOW
C           14/02/2000 added SIMVER
C           06/04/2001 revised
C           19/05/2003 extensive revision of MAIN and NUMBER and added
C                      RANDAT, REPEET, INUM and ANUM
C           02/08/2005 increased DVER to *30 and added to call to ADVISE
C           01/06/2006 added RANMAT and changed RANDAT to M_RANDAT
C           20/06/2006 converted code to allocatable arrays
C           28/09/2007 edited for version 6
C           17/08/2012 added tests for U(0,1) generator and split ADVISE 
C                      into ADVISE and CHOOSE
C           22/03/2019 added calls to PDPLOT, CDPLOT and RESFIL and connected NOUT for results files
C
      IMPLICIT   NONE
      INTEGER    ISEND, JSEED, KTYPE, MODE
      INTEGER    NOUT
      PARAMETER (NOUT = 4)
      DOUBLE PRECISION XVER, YVER
      CHARACTER (LEN = 1024) FNAME
      CHARACTER (LEN = 80  ) TITLE
      CHARACTER (LEN = 30  ) DVER
      CHARACTER (LEN = 15  ) PVER
      CHARACTER (LEN = 6   ) PNAME
      PARAMETER (PVER = 'w_rannum.exe')
      PARAMETER (PNAME = 'RANNUM')
      LOGICAL    ABORT, ACTION, REPEET, SHOW
      EXTERNAL   ADVISE, CHOOSE, NUMRAN, WALKER, HELP_RANNUM
      EXTERNAL   DLLCHK, WINDOW, SIMVER, M_RANDAT, RANMAT, U01TST,
     +           RSEEDS, RESFIL

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C Note ISEND = 2 since may be called from SIMSTAT which has already
C called WINDOW with ISEND = 1
C
      ISEND = 2
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

      CALL ADVISE (DVER,
     +             ABORT)
      IF (ABORT) THEN
         REPEET = .FALSE.
      ELSE
         REPEET = .TRUE.
         ISEND = 1
         CALL RSEEDS (ISEND, JSEED, KTYPE)
         CALL RESFIL (NOUT,
     +                FNAME,
     +                ABORT)
         IF (ABORT) THEN
            REPEET = .FALSE.
         ELSE   
           WRITE (NOUT,100)          
         ENDIF  
      ENDIF 
           
      DO WHILE (REPEET)
         CALL CHOOSE (MODE)
         IF (MODE.EQ.1) THEN
C
C MODE = 1: Random numbers   
C ---------
C
            CALL NUMRAN (NOUT)
  
         ELSEIF (MODE.EQ.2) THEN
C
C MODE = 2: Random matrices
C ---------
C
            CALL RANMAT
         ELSEIF (MODE.EQ.3) THEN
C
C MODE = 3: Random permutations
C ---------
C
            CALL M_RANDAT
        ELSEIF (MODE.EQ.4) THEN
C
C MODE = 4: Random walks
C ---------
C
            CALL WALKER             
         ELSEIF (MODE.EQ.5) THEN
C
C MODE = 5: Test the U(0,1) generator
C ---------
C            
            ISEND = 1
            CALL RSEEDS (ISEND, JSEED, KTYPE)
            CALL U01TST (NOUT)              
         ELSEIF (MODE.EQ.6) THEN
C
C MODE = 6: Select the seed
C ---------
C         
            ISEND = 3
            CALL RSEEDS (ISEND, JSEED, KTYPE)   
         ELSEIF (MODE.EQ.7) THEN
C
C MODE = 7: Help
C ---------
C            
            CALL HELP_RANNUM ('rannum') 
         ELSE
C
C Quit ... Exit
C -------------
C
            REPEET = .FALSE.
         ENDIF
      ENDDO

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 2
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CLOSE (UNIT = NOUT)
C
C======================================================================
C
  100 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : RANNUM'
     +/1X,'ACTION  : Generate pseudo-random numbers'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
      END
C
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)    :: DVER
      LOGICAL,             INTENT (OUT)   :: ABORT 
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 14, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_RANNUM
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ISEND = 1
      REPEET = .TRUE.
      WRITE (HEADER,100) DVER
      DO WHILE (REPEET)
         CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                HEADER, OPTION)
         IF (ISEND.EQ.1) THEN
            CALL HELP_RANNUM ('rannum')
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSE
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO             
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '     
     +/'Program `RANNUM'
     +/'        `      '     
     +/'Action  `Generate pseudo random numbers, permutations,'
     +/'        `Latin squares, or random walks.'
     +/'        `Select probability density or mass functions'
     +/'        `then tables/files/plots of random numbers.'
     +/'        `      '     
     +/'Version `',A
     +/'        `      '     
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '     
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C
      SUBROUTINE CHOOSE (MODE) 
C
C Choose option required
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER, INTENT (INOUT) :: MODE
C
C Locals
C
      INTEGER    ISEND, JSEED, KTYPE
      INTEGER    KUMDEC, KUMOPT, KSTART, KTEXT
      PARAMETER (KUMOPT = 8, KSTART = 5, KTEXT = KSTART + KUMOPT - 1)
      INTEGER    KUMBLD(KTEXT)
      CHARACTER (LEN = 100) LINE, TEXT(30)
      CHARACTER (LEN = 12 ) FORM12, WORD12
      EXTERNAL   LSTBOX, RSEEDS, FORM12
      DATA       KUMBLD / KTEXT*0 /
      
      ISEND = 0
      CALL RSEEDS (ISEND, JSEED, KTYPE)
      IF (KTYPE.EQ.1) THEN
         WORD12 = FORM12(JSEED) 
         WRITE (LINE,100) WORD12
      ELSE
         WRITE (LINE,200)
      ENDIF      
      WRITE (TEXT,300) LINE
      KUMBLD(1) = 4
      KUMDEC = 1
      CALL LSTBOX (KUMBLD, KUMDEC, KUMOPT, KSTART, KTEXT,
     +             TEXT)
      MODE = KUMDEC
C
C Format statements
C     
  100 FORMAT ('Current seed type: User-selected seed =',1X,A) 
  200 FORMAT ('Current seed type: System clock')
  300 FORMAT (
     + 'Options for program RANNUM'
     +/
     +/A
     +/
     +/'Generate sequences of random numbers'
     +/'Generate random matrices'
     +/'Generate random permutations'
     +/'Generate and plot random walks'
     +/'Test the current U(0,1) generator'
     +/'Set the seed type'
     +/'Help'
     +/'Quit ... Exit program RANNUM' )
      END
C
C
      