C
C U01TST
C U01001 
C U01002
C U01003
C WALKER
C
C  31/05/2022 added E_NUMBERS and E_FORMATS, etc.
 
      subroutine u01tst (nout)
c
c action: test the u(0,1) generator
c author: w.g.bardsley, university of manchester, u.k., 17/08/2012
c
      implicit   none
      integer,   intent (in) :: nout 
      integer    isend, jseed, ktype
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 6, numsta = 3, numtxt = numsta + numopt - 1)
      integer    numbld(30)
      character (len = 100) text(30)
      logical    repeet  
      logical    first
      save       first
      data       first / .true. /
      data       numbld / 30*0 /
      external   lstbox, revpro, rseeds
      external   u01001, u01002, u01003, u01004 
      if (first) then
c
c make sure generator is using random seed
c        
         first = .false.
         isend = 0
         call rseeds (isend, jseed, ktype) 
         if (ktype.ne.0) then
            isend = 1
            call rseeds (isend, jseed, ktype)
         endif             
      endif 
      numdec = 1
      repeet = .true.
      do while (repeet) 
         write (text,100)
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.eq.1) then        
c
c numdec = 1: runs up or down
c           
            call u01001 (nout)
         elseif (numdec.eq.2) then
c
c numdec = 2: bar chart
c         
            call u01002
         elseif (numdec.eq.3) then
c
c numdec = 3: chi-square
c         
            call u01003 (nout)
         elseif (numdec.eq.4) then
c
c numdec = 4: Kolomogov-Smirnov
c         
            call u01004 (nout)
         
         elseif (numdec.eq.5) then
c
c numdec = 5: results
c         
            call revpro (nout)       
         else
c
c numdec = 5: exit
c           
            repeet = .false.
         endif
      enddo
c
c format statements
c                  
  100 format (   
     + 'Testing the U(0,1) generator'
     +/
     +/'Runs up (or down) test'
     +/'Bar chart plot'
     +/'Chi-square test'
     +/'Kolmogorov-Smirnov test'
     +/'Results'
     +/'Quit ... Exit U(0,1) testing options')
      end
c
c------------------------------------------------------------------------------
c
      subroutine u01001 (nout)
c
c action: Test a U(0,1) generator, e.g. g05caf$
c author: w.g.bardsley, 17/08/2012
c      
      implicit   none
c
c argument
c      
      integer, intent (in) :: nout
c
c locals
c      
      integer    i, icount, ifail, j, k, m, maxr, n, nruns
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 8, numsta = 9, numtxt = numsta + numopt - 1)
      integer    numbld(30) 
      integer    ldcov, lwrk
      parameter (ldcov = 20, lwrk = ldcov*(ldcov + 5)/2 + 1, m = -1)
      integer    ncount(ldcov)
      double precision ex(ldcov), cov(ldcov,ldcov),
     +                 wrk(lwrk), wsav(3), x(1000), z
      double precision df, chi, prob
      double precision g05caf$
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 1  ) cl
      character (len = 6  ) run_type
      character (len = 13 ) showlj, d13
      character (len = 12 ) form12, word12_dof, word12_icount, word12_k,
     +                      word12_maxr, word12_n, word12_nruns,
     +                      word12_size 
      character (len = 30)  symbol
      character (len = 100) text(30)
      logical    e_numbers, e_formats
      logical    repeet, runs_down
      external   form12, lstbox, getjm1, table1, plevel, patch2, revpro
      external   e_formats, showlj
      external   g05caf$, g08eaf$
      intrinsic  nint
      save       icount, maxr, k, n
      data       icount, maxr, k, n / 0, 6, 10, 1000 /
      save       runs_down 
      data       runs_down / .false. /
      data       numbld / 30*0 /
c
c initialise 
c
      e_numbers = e_formats()
      ifail = 0
c
c main loop
c
      numdec = numopt - 1   
      repeet = .true.
      do while (repeet) 
         j = k*n
         word12_size = form12(j)
         word12_k = form12(k)
         word12_n = form12(n)
         word12_maxr = form12(maxr)
         if (runs_down) then
            run_type = '[Down]'
         else
            run_type = '[Up]'
         endif      
         write (text,100) word12_n, word12_k, word12_size,
     +                    word12_maxr, run_type        
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.eq.1) then 
c
c numdec = 1: generate then test
c                  
            do i = 1, 3
               wsav(i) = zero
            enddo
            ifail = 0
            
            do i = 1, k
c
c k must be at least 3 and wrk(1) to wrk(3) must be saved/restored between calls
c              
               do j = 1, 3
                 wrk(j) = wsav(j)
               enddo  
               do j = 1, n
                  x(j) = g05caf$(z)
               enddo
               if (runs_down) then
c
c change sign if runs_down  = .true.
c                 
                  do j = 1, n
                     x(j) = -x(j)
                  enddo   
               endif  
               if (i.eq.1) then
c
c first call when i = 1
c                 
                  cl = 'F'
               elseif (i.lt.k) then
c
c intermediate calls when i < k
c               
                  cl = 'I'
               else
c
c last call when i = k
c                 
                  cl = 'L'
               endif         
               call g08eaf$ (cl, n, x, m, maxr, nruns, ncount, ex, cov,
     +                       ldcov, chi, df, prob, wrk, lwrk, ifail)
               do j = 1, 3
                  wsav(j) = wrk(j)
               enddo   
            enddo 
           
            icount = icount + 1
            call plevel (prob,
     +                   symbol)  
            word12_icount = form12(icount)         
            word12_nruns = form12(nruns)
c
c check that dof is calculated correctly 
c      
            j = nint(df)
            if (j.ge.maxr) then
               do i = maxr, 1, -1
                  if (ncount(i).le.0) then
                     j = j - 1
                  else
                     exit
                  endif
               enddo
            endif   
            word12_dof = form12(j)
            
            if (e_numbers) then
               write (text,200) word12_icount, run_type, word12_size, 
     +                          word12_nruns, chi,
     +                          word12_dof, prob, symbol
            else
               d13 = showlj(chi)
               write (text,250) word12_icount, run_type, word12_size, 
     +                          word12_nruns, d13,
     +                          word12_dof, prob, symbol
            endif  
            j = 15
            call table1 (j, 'OPEN')
            write (nout,'(a)') ' '
            do i = 1, 7
               if (i.eq.1) then
                  j = 4
               else
                  j = 0
               endif       
               call table1 (j, text(i))
               write (nout,'(a)') text(i)
            enddo
            call table1 (j, 'CLOSE')  
         elseif (numdec.eq.2) then
c
c numdec = 2: change cycle length
c         
            i = 50
            j = 10000
            call getjm1 (i, n, j, 'Cycle length required')
            numdec = 1
         elseif (numdec.eq.3) then
c
c numdec = 3: change number of cycles
c         
            i = 3
            j = 10000
            call getjm1 (i, k, j, 'Number of cycles required') 
            numdec = 1 
         elseif (numdec.eq.4) then
c
c numdec = 4: change maximum number of runs
c         
            i = 3
            j = ldcov
            call getjm1 (i, maxr, j, 'Maximum run length') 
            numdec = 1   
         elseif (numdec.eq.5) then
c
c numdec = 5: change run type
c         
            runs_down = .not.runs_down
            numdec = 1
         elseif (numdec.eq.6) then
c
c numdec = 6: results
c          
            call revpro (nout)
         elseif (numdec.eq.7) then
c
c numdec = 7: help
c         
            write (text,300)
            numbld(1) = 1
            j = 22
            call patch2 (numbld, j,
     +                   text)     
            numbld(1) = 0
            numdec = 1 
         else
            repeet = .false.      
         endif
      enddo 
c
c format statements
c        
  100 format (
     + 'Runs up (or down) test for the U(0,1) generator'
     +/
     +/'Cycle length =',1x,a
     +/'Number of cycles =',1x,a
     +/'Sample size =',1x,a
     +/'Maximum run length =',1x,a
     +/'Run type is',1x,a
     +/
     +/'Generate then test'
     +/'Change cycle length'
     +/'Change number of cycles'
     +/'Change maximum run length'
     +/'Change run type'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit runs up (or down) options')
  200 format (
     + 'U(0,1) generator runs up/down test number',1x,a 
     +/'Run type            ',1x,a
     +/'Sample size         ',1x,a 
     +/'Total number of runs',1x,a
     +/'Test statistic  C   ',1p,e11.4
     +/'Degrees of freedom  ',1x,a
     +/'P(chi-sqd.)>= C     ',0p,f7.4,1x,a)
  250 format (
     + 'U(0,1) generator runs up/down test number',1x,a 
     +/'Run type              ',1x,a
     +/'Sample size           ',1x,a 
     +/'Total number of runs  ',1x,a
     +/'Test statistic  C     ',1x,a
     +/'Degrees of freedom    ',1x,a
     +/'p = P(chi-sqd.)>= C   ',f7.4,1x,a)     
  300 FORMAT (
     + 'The runs up (or down) test for randomness'
     +/      
     +/'To define runs up consider the following sequence of numbers'
     +/'.2, .4, .45, .4, .15, .75, .95, .23, .27, .4, .25, .1, .34, .39'
     +', .61,.12'
     +/'which has runs up of length 3, 1, 3, 3, 1, and 4.'
     +/
     +/'The runs up test is for examining randomness in a vector of'       
     +/'floating point numbers, such as when checking a random number'      
     +/'generator for presence of serial correlations. It will fail'      
     +/'if there are ties in the data, i.e. consecutive numbers are'      
     +/'equal because they are integers or are only stored with a'      
     +/'limited number of significant figures.'      
     +/      
     +/'The following points should be noted:' 
     +/     
     +/'1)`The sample size should be rather large, say n >= 4000.'
     +/'2)`Max. run length MAXR should be e.g. =< 4 for n =< 4000, or'       
     +/'  `=< 6 for n >= 10000, else chi-square bin counts may be low'       
     +/'  `and the chi-square test will be compromised. MAXR and DOF' 
     +/'  `are decreased temporarily if empty bins are encountered.'      
     +/'3)`Data sets can also analysed for runs down by temporarily'
     +/'  `reversing the signs.')                  
      end   
c
c--------------------------------------------------------------------------
c
      subroutine u01002
c
c action: generate U(0,1) then plot as a bar chart
c author: w.g.bardsley, university of manchester, u.k., 12/09/2012
c      
      implicit   none
      double precision, allocatable :: x(:)
      integer    i, ierr, n
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 3, numsta = 5, numtxt = numsta + numopt - 1)
      integer    nmax, nmin
      parameter (nmax = 10000000, nmin = 20)
      integer    numbld(10)
      double precision g05caf$, z
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character (len = 100) text(10)
      character (len = 12) form12, word12
      logical    repeet
      external   g05caf$, sdplot, lstbox, getjm1, form12
      save       n
      data       n / 1000 /
      data       numbld / 10*0 /
      ierr = 0
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      allocate (x(n),stat = ierr)
      if (ierr.ne.0) then
         deallocate(x, stat = ierr)
         n = 1000
         return
      endif     
      repeet = .true.
      do while (repeet)
         word12 = form12(n)
         write (text,100) word12
         numdec = 2
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.eq.1) then  
c
c numdec = 1: change n
c            
            call getjm1 (nmin, n, nmax,
     +                  'New sample size required') 
            ierr = 0
            if (allocated(x)) deallocate(x, stat = ierr)
            if (ierr.ne.0) return
            allocate (x(n),stat = ierr)
            if (ierr.ne.0) then
               deallocate(x, stat = ierr)
               n = 1000
               return
            endif    
         elseif (numdec.eq.2) then 
c
c numdec = 2: plot then exit
c          
            do i = 1, n
               x(i) = g05caf$(z)
            enddo
            call sdplot (n,
     +                   zero, one, x)
            repeet = .false.
         else
c
c numdec = 3: quit
c           
            repeet = .false.
         endif
      enddo  
      deallocate (x, stat = ierr) 
c
c format statement
c         
  100 format (
     + 'Plotting U(0,1) values as a bar chart'
     +/
     +/'Current sample size n =',1x,a
     +/
     +/'Change sample size n'
     +/'Generate x(1), ..., x(n) then plot'
     +/'Quit ... Exit bar chart plot options')              
      end  
c
c-----------------------------------------------------------------
c
      subroutine u01003 (nout)
c
c action: generate U(0,1) then do a chi-square test
c author: w.g.bardsley, university of manchester, u.k., 16/09/2012
c      
      implicit   none
c
c argument
c      
      integer, intent (in) :: nout
c
c locals
c       
      double precision, allocatable :: obs(:), barrier(:), x(:)
      integer    i, ierr, icount, ifail, j, n, nbins
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 5, numsta = 6, numtxt = numsta + numopt - 1)
      integer    nmax, nmin
      parameter (nmax = 10000000, nmin = 20)
      integer    nbmax, nbmin
      parameter (nbmax = 1000, nbmin = 2)
      integer    numbld(10)
      double precision chisqd, delta, dnbins, dn, dof, e, p, z
      double precision g01ecf$, g05caf$
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character (len = 100) text(10)
      character (len = 30 ) symbol
      character (len = 13 ) d13, showlj
      character (len = 12 ) form12, word12(3)
      logical    e_numbers, e_formats
      logical    repeet
      external   e_formats, showlj
      external   lstbox, getjm1, table1, plevel, revpro, form12	
      external   g01ecf$, g05caf$
      intrinsic  dble
      save       icount, n, nbins
      data       icount, n, nbins / 0, 1000, 20 /
      data       numbld / 10*0 /
c
c initialise then allocate
c      
      e_numbers = e_formats()
      ierr = 0
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      allocate (x(n),stat = ierr)
      if (ierr.ne.0) then
         deallocate(x, stat = ierr)
         n = 1000
         return
      endif     
      if (allocated(obs)) deallocate(obs, stat = ierr)
      if (ierr.ne.0) return
      allocate (obs(nbins),stat = ierr)
      if (ierr.ne.0) then
         deallocate(obs, stat = ierr)
         nbins = 20
         return
      endif     
      if (allocated(barrier)) deallocate(barrier, stat = ierr)
      if (ierr.ne.0) return
      allocate (barrier(nbins),stat = ierr)
      if (ierr.ne.0) then
         deallocate(barrier, stat = ierr)
         nbins = 20
         return
      endif
c
c main loop
c           
      repeet = .true.
      do while (repeet)
         word12(1) = form12(n)
         word12(2) = form12(nbins)
         write (text,100) word12(1), word12(2)
         numdec = 3
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.eq.1) then  
c
c numdec = 1: change n
c            
            call getjm1 (nmin, n, nmax,
     +                  'New sample size required') 
            ierr = 0
            if (allocated(x)) deallocate(x, stat = ierr)
            if (ierr.ne.0) return
            allocate (x(n),stat = ierr)
            if (ierr.ne.0) then
               deallocate(x, stat = ierr)
               n = 1000
               return
            endif   
         elseif (numdec.eq.2) then  
c
c numdec = 2: change nbins
c            
            call getjm1 (nbmin, nbins, nbmax,
     +                  'New number of bins required') 
            ierr = 0
            if (allocated(obs)) deallocate(obs, stat = ierr)
            if (ierr.ne.0) return
            allocate (obs(nbins),stat = ierr)
            if (ierr.ne.0) then
               deallocate(obs, stat = ierr)
               nbins = 20
               return
            endif    
            if (allocated(barrier)) deallocate(barrier, stat = ierr)
            if (ierr.ne.0) return
            allocate (barrier(nbins),stat = ierr)
            if (ierr.ne.0) then
               deallocate(barrier, stat = ierr)
               nbins = 20
               return
            endif                             
         elseif (numdec.eq.3) then 
c
c numdec = 3: test 
c          
            icount = icount + 1
            dn = dble(n)
            dnbins = dble(nbins)
            do i = 1, n
               x(i) = g05caf$(z)
            enddo
            do i = 1, nbins
               obs(i) = zero
            enddo  
            delta = one/dnbins
            barrier(1) = delta
            do i = 2, nbins - 1
               barrier(i) = barrier(i - 1) + delta
            enddo
            barrier(nbins) = one
            do i = 1, n
               do j = 1, nbins
                  if (x(i).ge.zero .and. x(i).le.barrier(j)) then
                     obs(j) = obs(j) + one
                     exit
                  endif   
               enddo  
            enddo     
            chisqd = zero
            e = dn/dnbins
            do i = 1, nbins
               chisqd = chisqd + (obs(i) - e)**2/e
            enddo 
            dof = dble(nbins - 1)
            p = g01ecf$('U', chisqd, dof, ifail)
            call plevel (p,
     +                   symbol)           
            word12(3) = form12(icount)
            if (e_numbers) then
               write (text,200) word12(3), word12(1), word12(2), chisqd,
     +                          p, symbol 
               write (nout,200) word12(3), word12(1), word12(2), chisqd,
     +                          p, symbol 
            else
               d13 = showlj(chisqd)  
               write (text,250) word12(3), word12(1), word12(2), d13,
     +                          p, symbol 
               write (nout,250) word12(3), word12(1), word12(2), d13,
     +                          p, symbol  
            endif
            j = 15
            call table1 (j, 'OPEN')
            do i = 2, 6
               if (i.eq.2) then
                  j = 4
               else
                  j = 0
               endif      
               call table1 (j, text(i))
            enddo
            call table1 (j, 'CLOSE')   
         elseif (numdec.eq.4) then
c
c numdec = 4: results
c         
            call revpro (nout)   
         else
c
c numdec = 3: quit
c           
            repeet = .false.
         endif
      enddo  
      deallocate (x, stat = ierr) 
      deallocate (obs, stat = ierr) 
      deallocate (barrier, stat = ierr) 
c
c format statement
c         
  100 format (
     + 'Chi-square test on U(0,1) values'
     +/
     +/'Current sample size, n =',1x,a
     +/'Current number of bins, nbins =',1x,a
     +/
     +/'Change sample size, n'
     +/'Change number of bins, nbins' 
     +/'Generate x(1), ..., x(n) then test'
     +/'Results'
     +/'Quit ... Exit chi-squared options')
  200 format (
     +/'U(0,1) generator Chi-squared test number',1x,a
     +/'Sample size     ',1x,a
     +/'Number of bins  ',1x,a
     +/'Test statistic C',1p,e11.4
     +/'P(chi-sqd. >= C)',0p,f7.4,1x,a)          
  250 format (
     +/'U(0,1) generator Chi-squared test number',1x,a
     +/'Sample size           ',1x,a
     +/'Number of bins        ',1x,a
     +/'Test statistic C      ',1x,a
     +/'p = P(chi-sqd. >= C)  ',f7.4,1x,a)                   
      end  
c
c-----------------------------------------------------------------------------
c
      subroutine u01004 (nout)
c
c action: generate U(0,1) then do a Kolomogorov-Smirnov test
c author: w.g.bardsley, university of manchester, u.k., 16/09/2012
c
c         Note that DIST is len = 2 in the simfit version
c      
      implicit   none
c
c argument
c      
      integer, intent (in) :: nout
c
c locals
c       
      double precision, allocatable :: x(:), sx(:)
      integer    i, ierr, icount, ifail, j, n
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 4, numsta = 5, numtxt = numsta + numopt - 1)
      integer    nmax, nmin, ntype
      parameter (nmax = 10000000, nmin = 20, ntype = 1)
      integer    numbld(10)
      double precision d, p, par(2), z
      double precision g05caf$
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character (len = 100) text(10)
      character (len = 30 ) symbol
      character (len = 13 ) d13(2), showlj
      character (len = 12 ) form12, word12(2)
      character (len = 2  ) dist, estima
      parameter (dist = 'U ', estima = 'S ')
      logical    e_numbers, e_formats
      logical    repeet
      external   e_formats, showlj
      external   lstbox, getjm1, table1, plevel, revpro, form12
      external   g05caf$, g08cbf$
      save       icount, n
      data       icount, n / 0, 1000 /
      data       numbld / 10*0 /
c
c initialise then allocate
c      
      e_numbers = e_formats()
      ierr = 0
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      allocate (x(n),stat = ierr)
      if (ierr.ne.0) then
         deallocate(x, stat = ierr)
         n = 1000
         return
      endif     
      if (allocated(sx)) deallocate(sx, stat = ierr)
      if (ierr.ne.0) return
      allocate (sx(n),stat = ierr)
      if (ierr.ne.0) then
         deallocate(sx, stat = ierr)
         n = 1000
         return
      endif     
c
c main loop
c           
      repeet = .true.
      do while (repeet)
         word12(1) = form12(n)
         write (text,100) word12(1)
         numdec = 2
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.eq.1) then  
c
c numdec = 1: change n
c            
            call getjm1 (nmin, n, nmax,
     +                  'New sample size required') 
            ierr = 0
            if (allocated(x)) deallocate(x, stat = ierr)
            if (ierr.ne.0) return
            allocate (x(n),stat = ierr)
            if (ierr.ne.0) then
               deallocate(x, stat = ierr)
               n = 1000
               return
            endif
            if (allocated(sx)) deallocate(sx, stat = ierr)
            if (ierr.ne.0) return
            allocate (sx(n),stat = ierr)
            if (ierr.ne.0) then
               deallocate(sx, stat = ierr)
               n = 1000
               return
            endif   
         elseif (numdec.eq.2) then 
c
c numdec = 2: test 
c          
            icount = icount + 1
            do i = 1, n
               x(i) = g05caf$(z)
            enddo
            par(1) = zero
            par(2) = one
            ifail = 0
            call g08cbf$ (n, x, dist, par, estima, ntype, d, z, p, sx,
     +                    ifail)
            call plevel (p,
     +                   symbol)           
            word12(2) = form12(icount)
            if (e_numbers) then
               write (text,200) word12(2), word12(1), d, z, p,
     +                          symbol 
               write (nout,200) word12(2), word12(1), d, z, p,
     +                          symbol 
            else
               d13(1) = showlj(d)
               d13(2) = showlj(z)
               write (text,250) word12(2), word12(1), d13(1), d13(2), p,
     +                          symbol 
               write (nout,250) word12(2), word12(1), d13(1), d13(2), p,
     +                          symbol 
            endif  
            j = 15
            call table1 (j, 'OPEN')
            do i = 2, 6
               if (i.eq.2) then
                  j = 4
               else
                  j = 0
               endif      
               call table1 (j, text(i))
            enddo
            call table1 (j, 'CLOSE') 
         elseif (numdec.eq.3) then
c
c numdec = 3: results
c         
            call revpro (nout)     
         else
c
c numdec = 3: quit
c           
            repeet = .false.
         endif
      enddo  
      deallocate (x, stat = ierr) 
      deallocate (sx, stat = ierr) 
c
c format statement
c         
  100 format (
     + 'Kolmogorov-Smirnov test on U(0,1) values'
     +/
     +/'Current sample size n =',1x,a
     +/
     +/'Change sample size n'
     +/'Generate x(1), ..., x(n) then test'
     +/'Results'
     +/'Quit ... Exit Kolmogorov-Smirnov test options')
  200 format (
     +/'U(0,1) generator Kolmogorov-Smirnov test number',1x,a
     +/'Sample size n       ',2x,a
     +/'Test statistic D    ',1p,e12.4
     +/'Standardised Z value',   e12.4
     +/'Significance level p',0p,f8.4,1x,a)     
  250 format (
     +/'U(0,1) generator Kolmogorov-Smirnov test number',1x,a
     +/'Sample size n         ',1x,a
     +/'Test statistic D      ',1x,a
     +/'Standardised Z value  ',1x,a
     +/'Significance level p  ',f7.4,1x,a)                      
      end   
C
C------------------------------------------------------------------------
C
      SUBROUTINE WALKER 
C
C ACTION : Generate random walks: NR must be equal to NMAX in this version
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 8/4/98
C          20/06/2006 edited 
C          28/09/2007 defined arrays locally 
C          31/07/2015 added DISJOINT
C
      IMPLICIT   NONE   
C
C Locals
C     
      INTEGER    NA, NGRAF, NI, NMAX
      PARAMETER (NA = 10, NGRAF = 10000, NI = 10, NMAX = 100000)
      INTEGER    N0, N1, N2, N3
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3)
      INTEGER    L, M
      PARAMETER (L = 1, M = 0)
      INTEGER    IFAIL, ISEND, JSEED, KTYPE, LOOP, NOUT1
      INTEGER    NDIST, NDISTX, NDISTY, NDISTZ, NR, NUM, NWALK
      INTEGER    IX(NI), IY(NI), IZ(NI), INUMX, INUMY, INUMZ
      INTEGER    COLOUR
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    I, K, NPLOTS, NSHOW
      INTEGER    NUMBLD(30), NUMPOS(30)
      DOUBLE PRECISION RTOL
      DOUBLE PRECISION RX(NMAX), RY(NMAX), RZ(NMAX)
      DOUBLE PRECISION X(NGRAF), XTEMP(NGRAF), Y(NGRAF), YTEMP(NGRAF),
     +                 Z(NGRAF)
      DOUBLE PRECISION AX(NA), AY(NA), AZ(NA), ANUMX, ANUMY, ANUMZ
      DOUBLE PRECISION XSTART, YSTART, ZSTART
      DOUBLE PRECISION XPREV, YPREV, ZPREV
      DOUBLE PRECISION XWALK, YWALK, ZWALK
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 1024) FNAME
      CHARACTER (LEN = 100 ) LINE, TEXT(30)
      CHARACTER (LEN = 80  ) TITLEX, TITLEY, TITLEZ
      CHARACTER (LEN = 30  ) PTITLE
      CHARACTER (LEN = 30  ) DTYPE
      CHARACTER (LEN = 13  ) D13(3), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 12  ) XTITLE, YTITLE
      CHARACTER (LEN = 12  ) FORM12, WORD12, WORD12_NUM, WORD12_NWALK
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, DISJOINT
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    GSAVE, AXES
      PARAMETER (GSAVE = .TRUE., AXES = .TRUE.)
      LOGICAL    FILE, SCREEN, TABLE
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   G05EDF$, G05ECF$
      EXTERNAL   PUTADV, FNAMES, OFILES, TABLE1, LBOX01, GETNOU,
     +           GETJM1, GKS004, GETTXT, GETD01, SPACE0, FORM12
      EXTERNAL   RANNUM_OUTPUT, RANNUM_PARAMS, DEFGKS, HELP_RANNUM,
     +           RSEEDS
      INTRINSIC  DBLE, TRIM
      SAVE       DISJOINT
      SAVE       IX, IY, IZ, NDIST, NUM, NWALK, AX, AY, AZ
      SAVE       XSTART, YSTART, ZSTART, TITLEX, TITLEY, TITLEZ
      DATA       NUM, NWALK / 20, 2 /
      DATA       XSTART, YSTART, ZSTART / ZERO, ZERO, ZERO /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 30*1 /
      DATA       DISJOINT / .FALSE. /
C
C Initialise to N(0,1)
C
      E_NUMBERS = E_FORMATS()
      ISEND = 0
      CALL RSEEDS (ISEND, JSEED, KTYPE)
      IF (KTYPE.EQ.1) WORD12 = FORM12(JSEED)
      CALL DEFGKS
      NDISTX = 7
      NDISTY = 7
      NDISTZ = 7
      IX(1) = 1
      IY(1) = 1
      IZ(1) = 1
      AX(1) = ZERO
      AY(1) = ZERO
      AZ(1) = ZERO
      AX(2) = ONE
      AY(2) = ONE
      AZ(2) = ONE
      DO I = 1, N2
         XTEMP(I) = ZERO
         YTEMP(I) = ZERO
      ENDDO
C
C Special action if NDIST = 12, 15 or 13
C

      NR = NMAX
      IF (NDISTX.EQ.12 .OR. NDISTX.EQ.15) THEN
         CALL G05EDF$(IX(1), AX(1), RX, NR, IFAIL)
      ELSEIF (NDISTX.EQ.13) THEN
         CALL G05ECF$(AX(1), RX, NR, IFAIL)
      ENDIF
      IF (NDISTY.EQ.12 .OR. NDISTY.EQ.15) THEN
         CALL G05EDF$(IY(1), AY(1), RY, NR, IFAIL)
      ELSEIF (NDISTY.EQ.13) THEN
         CALL G05ECF$(AY(1), RY, NR, IFAIL)
      ENDIF
      IF (NDISTZ.EQ.12 .OR. NDISTZ.EQ.15) THEN
         CALL G05EDF$(IZ(1), AZ(1), RZ, NR, IFAIL)
      ELSEIF (NDISTZ.EQ.13) THEN
         CALL G05ECF$(AZ(1), RZ, NR, IFAIL)
      ENDIF
      NSHOW = NUM + 1
      TITLEX = 'Standard Normal: N(0,1)'
      TITLEY = 'Standard Normal: N(0,1)'
      TITLEZ = 'Standard Normal: N(0,1)'
C
C Main branch point
C
   20 CONTINUE
      WORD12_NUM = FORM12(NUM)
      K = LEN_TRIM(WORD12_NUM)
      WORD12_NWALK = FORM12(NWALK)
      IF (DISJOINT) THEN
         DTYPE = 'DISJOINT ... stepwise walk'
      ELSE
         DTYPE = 'COINCIDENT ... continuous walk' 
      ENDIF     
      IF (E_NUMBERS) THEN
         WRITE (TEXT,100) TITLEX, TITLEY, TITLEZ,
     +                    XSTART, YSTART, ZSTART,
     +                    WORD12_NUM(1:K), WORD12_NWALK, DTYPE
      ELSE
         D13(1) = SHOWLJ(XSTART)
         D13(2) = SHOWLJ(YSTART)
         D13(3) = SHOWLJ(ZSTART)
         WRITE (TEXT,150) TITLEX, TITLEY, TITLEZ,
     +                    TRIM(D13(1)), TRIM(D13(2)), TRIM(D13(3)),
     +                    WORD12_NUM(1:K), WORD12_NWALK, DTYPE  
      ENDIF  
      IFAIL = 3
      FILE = .FALSE.
      SCREEN = .FALSE.
      TABLE = .FALSE.
      NSTART = 13
      NUMOPT = 14
      NTEXT = NSTART + NUMOPT - 1
      NUMBLD(1) = 4
      NUMBLD(3) = 1
      NUMBLD(5) = 1
      NUMBLD(7) = 1
      NUMDEC = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +             NUMOPT, NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NUMBLD(1) = 0
      NUMBLD(3) = 0
      NUMBLD(5) = 0
      NUMBLD(7) = 0
      IF (NUMDEC.EQ.1) THEN
C
C Screen only
C
         SCREEN = .TRUE.
      ELSEIF (NUMDEC.EQ.2) THEN
C
C Table only
C
         TABLE = .TRUE.
      ELSEIF (NUMDEC.EQ.3) THEN
C
C File only
C
         FILE = .TRUE.
      ELSEIF (NUMDEC.GE.4  .AND. NUMDEC.LE.6) THEN
C
C Choose a distribution
C
   40    CONTINUE
         
         WRITE (TEXT,200)
         NSTART = 3
         NUMOPT = 17
         NTEXT = NSTART + NUMOPT - 1
         NDIST = 7
         NUMBLD(1) = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDIST,
     +                NUMOPT, NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         IF (NDIST.EQ.NUMOPT - 1) THEN
C
C Help
C
            CALL HELP_RANNUM ('rannum')
            GOTO 40
         ELSEIF (NDIST.EQ.NUMOPT) THEN
C
C No change
C
            GOTO 20
         ENDIF
         IF (NUMDEC.EQ.4) THEN
C
C X-distribution
C
            NDISTX = NDIST
            CALL RANNUM_PARAMS (IX, NA, NDISTX, NI, 
     +                          AX, RTOL,
     +                          TITLEX)
            IF (NDISTX.EQ.12 .OR. NDISTX.EQ.15) THEN
               NR = NMAX
               CALL G05EDF$(IX(1), AX(1), RX, NR, IFAIL)
            ELSEIF (NDIST.EQ.13) THEN
               NR = NMAX
               CALL G05ECF$(AX(1), RX, NR, IFAIL)
            ENDIF
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Y-distribution
C
            NDISTY = NDIST
            CALL RANNUM_PARAMS (IY, NA, NDISTY, NI, 
     +                          AY, RTOL, TITLEY)
            IF (NDISTY.EQ.12 .OR. NDISTY.EQ.15) THEN
               NR = NMAX
               CALL G05EDF$(IY(1), AY(1), RY, NR, IFAIL)
            ELSEIF (NDISTY.EQ.13) THEN
               NR = NMAX
               CALL G05ECF$(AY(1), RY, NR, IFAIL)
            ENDIF
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Z-distribution
C
            NDISTZ = NDIST
            CALL RANNUM_PARAMS (IZ, NA, NDISTZ, NI, 
     +                          AZ, RTOL, TITLEZ)
            IF (NDISTZ.EQ.12 .OR. NDISTZ.EQ.15) THEN
               NR = NMAX
               CALL G05EDF$(IZ(1), AZ(1), RZ, NR, IFAIL)
            ELSEIF (NDISTZ.EQ.13) THEN
               NR = NMAX
               CALL G05ECF$(AZ(1), RZ, NR, IFAIL)
            ENDIF
         ENDIF
         GOTO 20
      ELSEIF (NUMDEC.EQ.7) THEN
C
C X_start
C
         CALL GETD01 (XSTART, 'X-start')
         GOTO 20
      ELSEIF (NUMDEC.EQ.8) THEN
C
C Y_start
C
         CALL GETD01 (YSTART, 'Y-start')
         GOTO 20
      ELSEIF (NUMDEC.EQ.9) THEN
C
C Z_start
C
         CALL GETD01 (ZSTART, 'Z-start')
         GOTO 20
      ELSEIF (NUMDEC.EQ.10) then
C
C No. of steps
C
         CALL GETJM1 (N1, NUM, NMAX,
     +'The number of pseudo-random values required (> 0)')
         NSHOW = NUM + 1
         GOTO 20
      ELSEIF (NUMDEC.EQ.11) THEN
C
C No. of variables
C
         CALL GETJM1 (N1, NWALK, N3,
     +'The number of variables required')
         GOTO 20
      ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
         DISJOINT = .NOT.DISJOINT 
         IF (NWALK.EQ.N1) THEN
            IF (DISJOINT) THEN
               CALL PUTADV ('The plot will be stepwise')
            ELSE
               CALL PUTADV ('The plot will be continuous')
            ENDIF
         ELSE   
            IF (DISJOINT) THEN
               CALL PUTADV ('Variables will now change consecutively')
            ELSE
               CALL PUTADV ('Variables will now change simultaneously')
            ENDIF       
         ENDIF   
         GOTO 20  
      ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Help
C
         CALL HELP_RANNUM ('rannum') 
         GOTO 20
      ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Exit
C
         RETURN
      ENDIF
C
C Open a file
C
      IF (FILE) THEN
         ISEND = 1
         CALL GETNOU (NOUT1)
         CLOSE (UNIT = NOUT1)
         CALL OFILES (ISEND, NOUT1, 
     +                FNAME, 
     +                ABORT)
         IF (ABORT) THEN
            GOTO 20
         ENDIF
      ENDIF
      IFAIL = 0
      IF (KTYPE.EQ.1) THEN
         WRITE (LINE,300) WORD12
         CALL PUTADV (LINE)
      ENDIF
      IF (FILE) THEN
         CALL GETTXT ('Title for these data', LINE)
         WRITE (NOUT1,400) LINE
         IF (NWALK.EQ.1) THEN 
            WRITE (NOUT1,500) NUM + 1, N2
         ELSE 
            WRITE (NOUT1,500) NUM + 1, NWALK 
         ENDIF   
      ENDIF
      IF (TABLE .AND. NSHOW.GT.N0) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         COLOUR = 4
         CALL TABLE1 (COLOUR, 'Random Walk')
         COLOUR = 0
      ENDIF
      NR = NMAX
      NPLOTS = 1
      IF (NWALK.EQ.1) THEN
         XWALK = XSTART
         XPREV = ZERO
         YPREV = XSTART
         IF (E_NUMBERS) THEN
            WRITE (LINE,'(I6,1P,E13.5)') N0, XWALK
         ELSE
            D13(1) = SHOWRJ(XWALK)
            WRITE (LINE,'(I6,1X,A13)') N0, D13(1)
         ENDIF  
         X(NPLOTS) = XSTART
         Y(NPLOTS) = YSTART
      ELSEIF (NWALK.EQ.2) THEN
         XWALK = XSTART
         YWALK = YSTART
         XPREV = XSTART
         YPREV = YSTART
         IF (E_NUMBERS) THEN
            WRITE (LINE,'(1P,2E13.5)') XWALK, YWALK
         ELSE
            D13(1) = SHOWRJ(XWALK)
            D13(2) = SHOWRJ(YWALK) 
            WRITE (LINE,'(2(1X,A13))') D13(1), D13(2)
         ENDIF  
         X(1) = XSTART
         Y(1) = YSTART
      ELSEIF (NWALK.EQ.3) THEN
         XWALK = XSTART
         YWALK = YSTART
         ZWALK = ZSTART
         XPREV = XSTART
         YPREV = YSTART
         ZPREV = ZSTART
         IF (E_NUMBERS) THEN
            WRITE (LINE,'(1P,3E13.5)') XWALK, YWALK, ZWALK
         ELSE
            D13(1) = SHOWRJ(XWALK)
            D13(2) = SHOWRJ(YWALK)
            D13(3) = SHOWRJ(ZWALK) 
            WRITE (LINE,'(3(1X,A13))') D13(1),D13(2), D13(3)
         ENDIF  
         X(1) = XSTART
         Y(1) = YSTART
         Z(1) = ZSTART
      ENDIF
C
C Main loop to increment the WALK
C
      IF (FILE) WRITE (NOUT1,400) LINE
        
      DO LOOP = 1, NUM
C
C Generate the numbers
C
         CALL RANNUM_OUTPUT (IX, INUMX, NA, NDISTX, NI, NR, 
     +                       AX, ANUMX, RX, RTOL)
         IF (NWALK.GT.1)
     +   CALL RANNUM_OUTPUT (IY, INUMY, NA, NDISTY, NI, NR, 
     +                       AY, ANUMY, RY, RTOL)
         IF (NWALK.GT.2)
     +   CALL RANNUM_OUTPUT (IZ, INUMZ, NA, NDISTZ, NI, NR, 
     +                       AZ, ANUMZ, RZ, RTOL)
C
C Increment the walk
C
         IF (NDISTX.LE.11) THEN
            XWALK = XWALK + ANUMX
         ELSE
            XWALK = XWALK + DBLE(INUMX)
         ENDIF
         IF (NWALK.GT.1) THEN
            IF (NDISTY.LE.11) THEN
               YWALK = YWALK + ANUMY
            ELSE
               YWALK = YWALK + DBLE(INUMY)
            ENDIF
         ENDIF
         IF (NWALK.GT.2) THEN
            IF (NDISTZ.LE.11) THEN
               ZWALK = ZWALK + ANUMZ
            ELSE
               ZWALK = ZWALK + DBLE(INUMZ)
            ENDIF
         ENDIF
         IF (FILE .OR. TABLE) THEN
C
C Write the increment to LINE if FILE or TABLE
C
            IF (LOOP.EQ.1 .AND. TABLE .AND. LOOP.LE.NSHOW)
     +          CALL TABLE1 (COLOUR, LINE)
            IF (NWALK.EQ.1) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,'(I6,1P,E13.5)') LOOP, XWALK
               ELSE
                  D13(1) = SHOWRJ(XWALK)
                  WRITE (LINE,'(I6,1X,A13)') LOOP, D13(1)  
               ENDIF   
            ELSEIF (NWALK.EQ.2) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,'(1P,2E13.5)') XWALK, YWALK
               ELSE
                  D13(1) = SHOWRJ(XWALK)
                  D13(2) = SHOWRJ(YWALK)
                  WRITE (LINE,'(1P,2(1X,A13))') D13(1), D13(2) 
               ENDIF  
            ELSEIF (NWALK.EQ.3) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,'(1P,3E13.5)') XWALK, YWALK, ZWALK
               ELSE
                  D13(1) = SHOWRJ(XWALK)
                  D13(2) = SHOWRJ(YWALK)
                  D13(3) = SHOWRJ(ZWALK)
                  WRITE (LINE,'(1P,3(1X,A13))') D13(1), D13(2), D13(3) 
               ENDIF  
            ENDIF
            IF (FILE) WRITE (NOUT1,400) LINE
            IF (TABLE .AND. LOOP.LE.NSHOW) CALL TABLE1 (COLOUR, LINE)
         ENDIF
         IF (SCREEN .AND. NPLOTS.LT.NGRAF) THEN
C
C Generate plotting data
C
            NPLOTS = NPLOTS + 1
            IF (NWALK.EQ.1) THEN
               IF (DISJOINT) THEN       
                  XPREV = XPREV + ONE
                  X(NPLOTS) = XPREV
                  Y(NPLOTS) = YPREV
                  IF (NPLOTS.LT.NGRAF) THEN
                     NPLOTS = NPLOTS + 1
                     YPREV = XWALK
                     X(NPLOTS) = XPREV
                     Y(NPLOTS) = YPREV
                  ENDIF
               ELSE  
                  XPREV = XPREV  + ONE
                  X(NPLOTS) = XPREV
                  Y(NPLOTS) = XWALK       
               ENDIF   
            ELSEIF (NWALK.EQ.2) THEN
               IF (DISJOINT) THEN
                  XPREV = XWALK
                  X(NPLOTS) = XWALK
                  Y(NPLOTS) = YPREV
                  IF (NPLOTS.LT.NGRAF) THEN
                     NPLOTS = NPLOTS + 1
                     X(NPLOTS) = XPREV
                     Y(NPLOTS) = YWALK
                     YPREV = YWALK
                  ENDIF   
               ELSE   
                  X(NPLOTS) = XWALK
                  Y(NPLOTS) = YWALK
               ENDIF   
            ELSEIF (NWALK.EQ.3) THEN
               IF (DISJOINT) THEN
                  XPREV = XWALK
                  X(NPLOTS) = XWALK
                  Y(NPLOTS) = YPREV
                  Z(NPLOTS) = ZPREV
                  IF (NPLOTS.LT.NGRAF) THEN
                     NPLOTS = NPLOTS + 1
                     X(NPLOTS) = XPREV
                     Y(NPLOTS) = YWALK
                     YPREV = YWALK
                     Z(NPLOTS) = ZPREV
                  ENDIF 
                  IF (NPLOTS.LT.NGRAF) THEN
                     NPLOTS = NPLOTS + 1
                     X(NPLOTS) = XPREV
                     Y(NPLOTS) = YPREV
                     Z(NPLOTS) = ZWALK
                     ZPREV = ZWALK
                  ENDIF 
               ELSE  
                  X(NPLOTS) = XWALK
                  Y(NPLOTS) = YWALK
                  Z(NPLOTS) = ZWALK
               ENDIF   
            ENDIF
         ENDIF
      ENDDO
      
      IF (TABLE .AND. NSHOW.GT.N0) THEN
         CALL TABLE1 (COLOUR, 'CLOSE')
      ENDIF
      
      IF (SCREEN .AND. NPLOTS.GT.1) THEN
         IF (NWALK.LT.3) THEN
            IF (NWALK.EQ.1) THEN
               PTITLE = DTYPE
               XTITLE = 'Steps'
               YTITLE = 'Position'
            ELSEIF (NWALK.EQ.2) THEN
               PTITLE = DTYPE
               XTITLE = 'X-Position'
               YTITLE = 'Y-Position'
            ENDIF
            CALL GKS004 (L, N0, N0, N0, L, M, M, M, NPLOTS, N0, N0, N0,
     +                   X, XTEMP, XTEMP, XTEMP,
     +                   Y, YTEMP, YTEMP, YTEMP,
     +                   PTITLE, XTITLE, YTITLE,
     +                   GSAVE, AXES)
         ELSEIF (NWALK.EQ.3) THEN
            CALL SPACE0 (NPLOTS, NGRAF, X, XTEMP, Y, YTEMP, Z)
         ENDIF
      ENDIF
      
      IF (FILE) THEN
         WRITE (NOUT1,600) N2 + NWALK
         IF (KTYPE.EQ.1) THEN
            WRITE (NOUT1,700) WORD12
         ELSE
            WRITE (NOUT1,800)
         ENDIF
         WRITE (NOUT1,900)
         WRITE (NOUT1,1000) TITLEX
         IF (NWALK.GT.1) WRITE (NOUT1,1100) TITLEY
         IF (NWALK.GT.2) WRITE (NOUT1,1200) TITLEZ
         CLOSE (UNIT = NOUT1)
         IFAIL = 2
         CALL FNAMES (IFAIL, FNAME)
      ENDIF
      GOTO 20
C
C Format statements
C      
  100 FORMAT (
     + 'Generating 1D, 2D, or 3D random walks'
     +/
     +/'The current X-distribution is:'
     +/A
     +/'The current Y-distribution is:'
     +/A
     +/'The current Z-distribution is:'
     +/A
     +/'X_start =',1P,E13.5,', Y_start =',1P,E13.5,
     +', Z_start =',1P,E13.5
     +/'Number of steps =',1X,A,', Number of variables =',1X,A
     +/'Plot type:',1X,A
     +/
     +/'Generate a walk then Plot'
     +/'Generate a walk then Tabulate'
     +/'Generate a walk then Save As ...'
     +/'Change X-distribution'
     +/'Change Y-distribution'
     +/'Change Z-distribution'
     +/'Change X-start'
     +/'Change Y-start'
     +/'Change Z-start'
     +/'Change number of steps'
     +/'Change number of variables'
     +/'Change plot type' 
     +/'Help'
     +/'Quit ... Exit random walk options')
  150 FORMAT (
     + 'Generating 1D, 2D, or 3D random walks'
     +/
     +/'The current X-distribution is:'
     +/A
     +/'The current Y-distribution is:'
     +/A
     +/'The current Z-distribution is:'
     +/A
     +/'X_start =',1X,A,', Y_start =',1X,A,
     +', Z_start =',1X,A
     +/'Number of steps =',1X,A,', Number of variables =',1X,A
     +/'Plot type:',1X,A
     +/
     +/'Generate a walk then Plot'
     +/'Generate a walk then Tabulate'
     +/'Generate a walk then Save As ...'
     +/'Change X-distribution'
     +/'Change Y-distribution'
     +/'Change Z-distribution'
     +/'Change X-start'
     +/'Change Y-start'
     +/'Change Z-start'
     +/'Change number of steps'
     +/'Change number of variables'
     +/'Change plot type' 
     +/'Help'
     +/'Quit ... Exit random walk options')     
  200 FORMAT (
     +'Distributions available in this version'
     +/
     +/'Cauchy'
     +/'Chi-square'
     +/'Negative exponential'
     +/'Gamma'
     +/'Logistic'
     +/'Lognormal'
     +/'Normal'
     +/'Uniform'
     +/'Weibull'
     +/'F'
     +/'T'
     +/'Binomial (integers)'
     +/'Poisson (integers)'
     +/'Uniform (integers)'
     +/'+1 or -1 (integers)'
     +/'Help'
     +/'Cancel')
  300 FORMAT ('Repeatable initial state: seed =',1X,A)
  400 FORMAT (A)
  500 FORMAT (2I6)
  600 FORMAT (I6)
  700 FORMAT (
     +'Numbers from RANNUM with repeatable initial state, SEED =',1X,A)
  800 FORMAT (
     +'Numbers from RANNUM with non-repeatable (random) initial state')
  900 FORMAT (
     +'File format: title, dimensions, data, then further details')
 1000 FORMAT ('X_distribution: ', A)
 1100 FORMAT ('Y_distribution: ', A)
 1200 FORMAT ('Z_distribution: ', A)
      END
C
C                   

      