C
C
C Extra source files are required as follows:-
C ============================================
C
C RFFIT1.FOR: ADVISE, DATAIN, DATFIT, DATOUT
C RFFIT2.FOR: DERIV1, DERIV2, DETAIL, FUNCT1, L1NORM, LINEAR, MONIT
C RFFIT3.FOR: ORDER, PARAMS, RANDOM, TESTQS, ZMOD
C DLLCHK.FOR: consistency checking
C
C These must be included now
C ==========================
C
C     INCLUDE 'rffit1.for', NOLIST
C     INCLUDE 'rffit2.for', NOLIST
C     INCLUDE 'rffit3.for', NOLIST
C     INCLUDE 'dllchk.for', NOLIST
C
C
C-----------------------------------------
C Start of Module to replace common blocks
C-----------------------------------------
      MODULE MODULE_RFFIT
      
      IMPLICIT NONE
         
      INTEGER    NMAX
      INTEGER    ITIME, KFAST, MFAST, NPTS
      INTEGER    NFACT
      PARAMETER (NFACT = 13)
      DOUBLE PRECISION DOFDOM, FACT(NFACT), REELN
      LOGICAL    ANIN, A0IN
        
      DOUBLE PRECISION, ALLOCATABLE :: ERRY(:), THEORY(:), XVAL(:),
     +                                 YVAL(:)
      LOGICAL,          ALLOCATABLE :: EQUAL(:)
         
      END MODULE MODULE_RFFIT
C---------------------------------------
C End of module to replace common blocks
C---------------------------------------      

C
C
      PROGRAM MAIN
C
C VERSION : details form SIMVER/DLLCHK
C NAG     : E02GBF, E04JAF, F01ABF, G01EBF, G01EDF, G01ECF, G01EEF,
C           G01BJF, G01FBF, G01FDF, G05CCF, G05DDF, G02CAF, S15ABF,
C           X02AJF, X02AMF
C INPUT   : File with TITLE, NPTS, X, Y, Standard error in Y
C           as prepared by programs MAKFIL, MAKDAT, ADDERR or EDITFL
C ACTION  : Best-fit positive rational function. Random search and/or
C           solving the over-determined system for starting values.
C           Then optimisation using a quasi-Newton routine and F test.
C           X- and Y-data transformed to 'order unity' internally.
C MODEL   : Y(X) = F(X)/G(X), where:-
C           F(X) = A(0) + A(1)*X + A(2)*X**2 + ... + A(N)*X**N
C           G(X) =  1.0 + B(1)*X + B(2)*X**2 + ... + B(N)*X**N.
C OUTPUT  : Weighted sums of squares, F statistics, parameters
C           and residuals. Details written to a file if requested.
C ADVICE  : Make sure Standard error in Y > 0.0 and X in increasing order.
C           Set parameters : NF   = unit for data output file
C                            NMAX = maximum number of points
C                            NN   = maximum order (N:N)
C                            NX   = No. of parameters (NX = 2*NN + 1)
C AUTHOR  : W. G. Bardsley, 20/5/86
C REVISED : 31/01/1990  Re-organised, dimensions, INVERT, VARCOV, QNGRAD
C           12/02/1990 PROBRS, GRAF2A
C           20/03/1991 DATTIN, DATCHK, RES001, FTESTS
C           06/05/1991 Extensive use of W
C           09/01/1992 Corrected NUMBER in call to RESGKS and FTESTS
C                      GETNUM, GETCHR, GKST02, GKST03, GKSR01, ENDALL, REPEAT
C           31/12/1993 Compressed version using GETYES, PUT??? etc.
C           07/04/1993 Replaced GKST04 and added diagonal 1 to correlation matrix
C           13/06/1993 Added call to RESFIL
C           23/05/1994 DBOS version
C           20/02/1995 Version for Salamanca
C           27/10/1995 Split source code and cleaned up for nag 16
C           21/09/1997 win32 version ... COMMON needed for models
C           20/03/1998 Added GOGOGO and NEW
C           07/08/1998 added dllchk
C           28/09/1998 corrected dimension for arrays AA, BB in DATFIT
C           02/10/1998 FTN95 version
C           14/12/1998 replaced TUTORS by TUTOR1
C           19/08/1999 revised control
C           13/09/1999 added call to WINDOW
C           05/12/1999 increased dimension LW1
C           14/02/2000 added SIMVER
C           10/04/2001 revised
C           20/05/2001 added call to PCVTST
C           03/08/2005 increased DVER to *30 and added to call to ADVISE
C           29/10/2007 replaced COMMON by MODULE_RFFIT and edited for version 6
C           26/11/2013 increased NGRAF to 400 and introduced TABLE6 to display results
C           12/03/2015 added a preliminary search to RANDOM
C                      added function RANNUM to constrain G05DDF to three sigma
C                      introduced FACTOR into DETAIL to scale SIGMA
C                      introduced all starting estimates = 1 as default in DETAIL    
C                      edited PARAMS to output external and internal starting estimates 
C

      USE MODULE_RFFIT
      
      IMPLICIT   NONE
C
C Allocatable arrays
C
      INTEGER,          ALLOCATABLE :: INDXl1(:)
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:), E(:,:), F(:), FJACC(:,:),
     +                                 W3(:)
      LOGICAL,          ALLOCATABLE :: EQSAV(:)
C
C Other declarations
C      
      INTEGER    NN, NX
      PARAMETER (NN = 6, NX = 2*NN + 1)
      INTEGER    NIN, NF, NGRAF, NHESS
      PARAMETER (NIN = 3, NF = 4, NGRAF = 400, NHESS = NX + 1)
      INTEGER    N10, LIW, LW1, LW2, LW3
      PARAMETER (N10 = 10,
     +           LIW = 3*NX,
     +           LW1 = 2*(2*N10*NX + 4*NX + 11*N10*N10 + 8*N10),
     +           LW2 = 3*NX)
      INTEGER    INDEX(NX), ISTATE(NX), IW(LIW), NBD(NX)
      INTEGER    NPAR(NN), NUMBER(NN)
      INTEGER    ITYPE, MAXNUM, NBIG, NDOF, NFREE, NRAND, NSMALL,
     +           NSTART, NSTOP
      INTEGER    IERR, ISEND, NCOL, NROW 
      DOUBLE PRECISION S(NX)
      DOUBLE PRECISION BL(NX), BU(NX), DIAGV(NX), ERR(NX), G(NX),
     +                 PAR(NX), STORES(NX), TL(NX), TPER(NX), TU(NX),
     +                 X(NX)
      DOUBLE PRECISION CORR(NX,NX), CV(NHESS,NHESS), 
     +                 HESSEX(NHESS,NHESS)
      DOUBLE PRECISION XSAV(NGRAF), YSAV(NGRAF)
      DOUBLE PRECISION W1(LW1), W2(LW2)
      DOUBLE PRECISION AA(NN), BB(NN), WSSQ(NN)
      DOUBLE PRECISION A0, A1, AN, OBJFUN, SIGMA, TESTQ, XT, YT
      DOUBLE PRECISION EPSI, RTOL
      DOUBLE PRECISION XVER, YVER
      CHARACTER  FNAME1*1024, FNAME2*1024, TITLE*100
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_rffit.exe')
      CHARACTER  BLANK*1, PNAME*5
      PARAMETER (BLANK = ' ', PNAME = 'RFFIT')
      LOGICAL    FREE(NX), NOUT(9)
      LOGICAL    DOIT, ISTOP, FIRST, NEW, REPEET
      LOGICAL    ABORT, ACTION, SHOW
      EXTERNAL   G05CCF$
      EXTERNAL   GOGOGO
      EXTERNAL   ADVISE, DATAIN, DETAIL, RANDOM, LINEAR, DATFIT, DATOUT,
     +           M_FITONE     
      EXTERNAL   DLLCHK, WINDOW, SIMVER

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

C
C Advise user
C
      FIRST = .TRUE.
      CALL ADVISE (DVER,
     +             ISTOP, FIRST)
      IF (ISTOP) THEN
         DOIT = .FALSE.
      ELSE
         DOIT = .TRUE.
C
C Initialise random number generator and filenames
C
         CALL G05CCF$
         NCOL = 0
         NROW = 0
         FNAME1 = BLANK
         FNAME2 = BLANK
         NEW = .TRUE.
         NRAND = 4
         NSTART = 1
         NSTOP = 2
C
C Initialise output types
C nout(1) ... display analysis table
C nout(2) ... display starting estimates
C nout(3) ... display random search
C nout(4) ... plot    best fit curves
C nout(5) ... plot    residuals
C nout(6) ... display residuals table
C nout(7) ... file    residuals table
C nout(8) ... high precision convergence test
C nout(9) ... store/test parameters/covariance-matrix
C
         NOUT(1) = .TRUE.
         NOUT(2) = .FALSE.
         NOUT(3) = .FALSE.
         NOUT(4) = .TRUE.
         NOUT(5) = .FALSE.
         NOUT(6) = .TRUE.
         NOUT(7) = .FALSE.
         NOUT(8) = .FALSE.
         NOUT(9) = .FALSE.
      ENDIF
C
C Branch point for repeat analysis
C
      IF (DOIT) THEN
         REPEET = .TRUE.
         DO WHILE (REPEET)
            IF (NEW) THEN
C
C Get a new data file
C              
               ISEND = 12
               CALL M_FITONE (ISEND, NCOL, NIN, NROW,
     +                        FNAME1, TITLE) 
               IF (NCOL.GE.2 .AND. NCOL.LE.3 .AND. NROW.GT.1) THEN
                  NPTS = NROW
                  NMAX = MAX(NPTS,NGRAF)
                  ISTOP = .FALSE.
                  NEW = .FALSE.
                  IERR = 0
                  IF (ALLOCATED(INDXl1)) DEALLOCATE(INDXL1, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(ERRY)) DEALLOCATE(ERRY, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(THEORY)) DEALLOCATE(THEORY, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(XVAL)) DEALLOCATE(XVAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(YVAL)) DEALLOCATE(YVAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(EQUAL)) DEALLOCATE(EQUAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT 
                  IF (ALLOCATED(EQSAV)) DEALLOCATE(EQSAV, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                                   
                  ALLOCATE(INDXL1(NMAX + NX), STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  ALLOCATE(ERRY(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  ALLOCATE(THEORY(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(XVAL(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(YVAL(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(EQUAL(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  ALLOCATE(EQSAV(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT    

                  IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(E)) DEALLOCATE(E, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(F)) DEALLOCATE(F, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(FJACC)) DEALLOCATE(FJACC, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(W3)) DEALLOCATE(W3, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(EQSAV)) DEALLOCATE(EQSAV, STAT = IERR)
                  IF (IERR.NE.0) EXIT

                  ALLOCATE(A(NMAX,NX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(E(NX,NMAX + NX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(F(NMAX + NX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(FJACC(NMAX,NX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(EQSAV(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT

                  LW3 = 3*NMAX + 8*NX + NX*NX + (NX + 1)*(NX + 2)/2
                  ALLOCATE(W3(LW3), STAT = IERR)
                  IF (IERR.NE.0) EXIT
               ELSE
                  ISTOP = .TRUE.
               ENDIF                      
            ENDIF 
            IF (.NOT.ISTOP) THEN            
C
C Read in data
C
               CALL DATAIN (NIN, NF, NMAX, NPTS,
     +                      EPSI, ERRY, RTOL, XT, XVAL, YT, YVAL,
     +                      FNAME1, FNAME2,
     +                      EQUAL, ISTOP, NEW)
            ENDIF
            IF (ISTOP) THEN
               DOIT = .FALSE.
               FNAME1 = BLANK
            ELSE
               DOIT = .TRUE.
            ENDIF
            IF (DOIT) THEN
C
C Decide the type of analysis required
C
               CALL DETAIL (ITYPE, MAXNUM, NBIG, NF, NN, NPTS, NRAND,
     +                      NSMALL, NSTART, NSTOP,
     +                      AA, A0, A1, AN, BB, RTOL, SIGMA, XT, XVAL,
     +                      YT, YVAL,
     +                      ANIN, A0IN, EQUAL, ISTOP, NOUT)
               IF (ISTOP) THEN
                  DOIT = .FALSE.
               ELSE
                  DOIT = .TRUE.
               ENDIF
            ENDIF

C
C Loop over each model order selected
C
            IF (DOIT) THEN
               DO ITIME = NSTART, NSTOP
C
C Random search
C
                 CALL RANDOM (ISTATE, ITIME, ITYPE, KFAST, MAXNUM,
     +                        MFAST, NBIG, NDOF, NF, NN, NPAR, NPTS,
     +                        NRAND, NSMALL, NUMBER, NX,
     +                        A0, A1, AN, DOFDOM, FACT, SIGMA, STORES,
     +                        TESTQ, X,
     +                        ANIN, A0IN, ISTOP, NOUT)
C
C Overdetermined L1 norm solution
C
                  CALL LINEAR (INDXL1, ITIME, ITYPE, LW3, NF, NMAX, NN,
     +                         NPAR, NPTS, NRAND, NUMBER, NX,
     +                         A, AA, BB, DOFDOM, E, ERRY, F, FACT, S,
     +                         STORES, TESTQ, THEORY, W3, X, XVAL, YVAL,
     +                         YT,
     +                         ISTOP, NOUT)
C
C Curve fitting
C
                  CALL DATFIT (ISTATE, ITIME, IW, LIW, LW1, LW2, MFAST,
     +                         NBD, NDOF, NF, NN, NPAR, NPTS, NRAND, NX,
     +                         AA, BB, BL, BU, DOFDOM, EPSI, FACT, G,
     +                         OBJFUN, WSSQ, W1, W2, X, YT,
     +                         ANIN, A0IN, ISTOP, NOUT)
C
C Output results
C
                  CALL DATOUT (INDEX, ISTATE, ITIME, LW2, LW3, MFAST,
     +                         NDOF, NF, NFREE, NGRAF, NHESS, NMAX, NN,
     +                         NPAR, NPTS, NSTART, NUMBER, NX,
     +                         AA, BB, CORR, CV, DIAGV, ERR, ERRY, FACT,
     +                         FJACC, G, HESSEX, OBJFUN, PAR, RTOL,
     +                         THEORY, TL, TPER, TU, W3, WSSQ, W2,
     +                         X, XSAV, XT, XVAL, YSAV, YT, YVAL,
     +                         EQSAV, EQUAL, FREE, ISTOP, NOUT)
               ENDDO
            ENDIF
C
C Another go ?
C
            CALL GOGOGO (NF,
     +                   FNAME1, FNAME2, PNAME,
     +                   ISTOP, NEW)
            IF (ISTOP) THEN
               REPEET = .FALSE.
            ELSE
               REPEET = .TRUE.
            ENDIF
         ENDDO
      ENDIF
C
C Terminate program
C

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C

      CLOSE (UNIT = NF)
      END
C
C
