C
C RFFIT1.FOR: include code for RFFIT
C =========
C
C ADVISE
C DATAIN
C DATFIT
C DATOUT
C
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (IN)  :: FIRST
      LOGICAL,             INTENT (OUT) :: ABORT
      
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_RFFIT
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_RFFIT ('rffit')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `RFFIT'
     +/'        `      '
     +/'Action  `Fits a sequence of positive rational functions by'
     +/'        `constrained weighted least squares and calculates'
     +/'        `statistics to choose the best model.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE DATAIN (NIN, NF, NMAX, NPTS,
     +                   EPSI, ERRY, RTOL, XT, XVAL, YT, YVAL,
     +                   FNAME1, FNAME2,
     +                   EQUAL, ISTOP, NEW)
C
C Read X, Y, Error, NPTS, calculate XT, YT
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NIN, NF, NMAX
      INTEGER,             INTENT (INOUT) :: NPTS
      DOUBLE PRECISION,    INTENT (OUT)   :: EPSI, ERRY(NMAX), RTOL, XT,
     +                                       XVAL(NMAX), YT, YVAL(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME1, FNAME2
      LOGICAL,             INTENT (IN)    :: NEW
      LOGICAL,             INTENT (OUT)   :: EQUAL(NMAX), ISTOP
C
C Locals
C      
      INTEGER    I, ICOUNT
      DOUBLE PRECISION X02AJF$, X02AMF$
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  LINE*100, TITLE*80
      CHARACTER (LEN = 80) TRIM80, WORD80
      EXTERNAL   X02AJF$, X02AMF$
      EXTERNAL   DATFIL, DATCHK, PUTFAT, RESFIL, DATSXY, TRIM80
      SAVE ICOUNT
      DATA ICOUNT / 0 /
C
C Assign EPSI and RTOL
C
      EPSI = X02AJF$()
      RTOL = 1.0D+09*X02AMF$()
C
C Read in and check data
C
      IF (NEW) THEN
         CLOSE (UNIT = NIN)
         CALL DATFIL (NIN, NMAX, NPTS,
     +                ERRY, XVAL, YVAL,
     +                FNAME1, TITLE,
     +                ISTOP)
         CLOSE (UNIT = NIN)
         IF (ISTOP) RETURN
      ELSE
         CLOSE (UNIT = NIN)
         CALL DATSXY (NIN, NMAX, NPTS,
     +                ERRY, XVAL, YVAL,
     +                FNAME1, TITLE,
     +                ISTOP)
         CLOSE (UNIT = NIN)
         IF (ISTOP) RETURN
      ENDIF
      CALL DATCHK (NPTS,
     +             ERRY, XVAL, YVAL,
     +             ISTOP)
      IF (ISTOP) RETURN
C
C Further checks on input data and calculate XT, YT
C
      IF (NPTS.LT.3) THEN
         CALL PUTFAT ('Must be at least 3 x-values')
         ISTOP = .TRUE.
         RETURN
      ENDIF
      DO I = 1, NPTS
         IF (XVAL(I).LT.ZERO .OR. YVAL(I).LT.ZERO) THEN
            WRITE (LINE,100) I
            CALL PUTFAT (LINE)
            ISTOP = .TRUE.
            RETURN
         ENDIF
      ENDDO
      XT = XVAL(1)
      YT = YVAL(1)
      EQUAL(1) = .FALSE.
      DO I = 2, NPTS
         IF (XVAL(I).GT.XT) XT = XVAL(I)
         IF (YVAL(I).GT.YT) YT = YVAL(I)
         IF (XVAL(I).GT.XVAL(I - 1) .OR. XVAL(I).LT.XVAL(I - 1)) THEN
            EQUAL(I) = .FALSE.
         ELSE
            EQUAL(I) = .TRUE.
         ENDIF
      ENDDO
C
C Open output file for results and write out program declaration
C
      IF (ICOUNT.EQ.0) THEN
         CALL RESFIL (NF,
     +                FNAME2,
     +                ISTOP)
         IF (ISTOP) RETURN
         WRITE (NF,200)
      ENDIF
      ICOUNT = ICOUNT + 1
      WORD80 = TRIM80(FNAME1)
      WRITE (NF,300) ICOUNT, WORD80, TITLE
C
C Transform ERRY, XVAL, YVAL
C
      DO I = 1, NPTS
         ERRY(I) = ERRY(I)/YT
         XVAL(I) = XVAL(I)/XT
         YVAL(I) = YVAL(I)/YT
      ENDDO
C
C Format statements
C      
  100 FORMAT ('x or y < 0 at data point',I6,' ... Must be > 0')
  200 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : RFFIT'
     +/1X,'ACTION  : Fit positive n:n rational functions'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
  300 FORMAT (/1X,'Analysis number',I3
     +/1X,'------------------'
     +/1X,'File name'/1X,A/1X,'Data title'/1X,A)
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE DATFIT (ISTATE, ITIME, IW, LIW, LW1, LW2, MFAST,
     +                   NBD, NDOF, NF, NN, NPAR, NPTS, NRAND, NX,
     +                   AA, BB, BL, BU, DOFDOM, EPSI, FACT, G, OBJFUN,
     +                   WSSQ, W1, W2, X, YT,
     +                   ANIN, A0IN, ISTOP, NOUT)
C
C Curve fitting by the NAG quasi-Newton routine E04JAF or QNFIT1/LBFGS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,            INTENT (IN)  :: LIW, LW1, LW2, NN, NX
      INTEGER,            INTENT (IN)  :: ITIME, MFAST, NDOF, NF,
     +                                    NPAR(NN), NPTS, NRAND
      INTEGER,          INTENT (OUT)   :: ISTATE(NX), IW(LIW), NBD(NX)
      DOUBLE PRECISION, INTENT (IN)    :: DOFDOM, EPSI, YT 
      DOUBLE PRECISION, INTENT (INOUT) :: AA(NN), BB(NN), FACT(NX),
     +                                    WSSQ(NN)
      DOUBLE PRECISION, INTENT (OUT)   :: OBJFUN, X(NX)
      DOUBLE PRECISION, INTENT (OUT)   :: BL(NX), BU(NX), G(NX),
     +                                    W1(LW1), W2(LW2)
      LOGICAL,          INTENT (IN)    :: A0IN, ANIN, ISTOP, NOUT(9)
C
C Locals
C     
      INTEGER    I, IFAIL, M, N
      
      DOUBLE PRECISION F
      DOUBLE PRECISION BLMAX, BLMIN, FMAX, FMIN, ZERO, ONE
      PARAMETER (BLMAX = 1.0D+07, BLMIN = 1.0D-07, FMAX = 1.0D+07,
     +           FMIN = 1.0D-7, ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   DERIV1, DERIV2, FUNCT1, QNFIT1
      EXTERNAL   PARAMS, ZMOD
      EXTERNAL   CHECKW, PUTIFA
      INTRINSIC  ABS
      IF (ISTOP) RETURN
C
C Set up parameters for curve-fitting
C
      DO I = 1, NPAR(ITIME)
         NBD(I) = 1
         BL(I) = BLMIN
         BU(I) = BLMAX
         X(I) = ONE
         ISTATE(I) = 1
         IF (NRAND.GE.4) FACT(I) = ONE
         IF (FACT(I).GT.FMAX) THEN
            FACT(I) = FMAX  
         ELSEIF (FACT(I).LT.FMIN) THEN
            FACT(I) = FMIN
         ENDIF  
      ENDDO
      IF (.NOT.A0IN) THEN
         NBD(1) = 2
         X(1) = ZERO
         BL(1) = ZERO
         BU(1) = ZERO
         FACT(1) = ONE
         ISTATE(1) = 0
      ENDIF
      IF (.NOT.ANIN) THEN
         NBD(MFAST) = 2
         X(MFAST) = ZERO
         BL(MFAST) = ZERO
         BU(MFAST) = ZERO
         FACT(MFAST) = ONE
         ISTATE(MFAST) = 0
      ENDIF
C
C Display/set the parameters then check WSSQ before entry
C
      M = ITIME
      N = NPAR(ITIME)
      CALL PARAMS (ISTATE, M, MFAST, N, NF, NRAND,
     +             AA, BB, FACT, X, YT,
     +             NOUT(2))
      CALL FUNCT1 (N,
     +             X, F)
      WSSQ(ITIME) = DOFDOM*F
      CALL CHECKW (NDOF,
     +             WSSQ(ITIME))
C
C Entry to curve-fitting routine
C

C
C The next code decides on fitting mode
C
      IF (NOUT(8)) THEN
         CALL QNFIT1 (DERIV2, FUNCT1,
     +                IFAIL, IW, LIW, LW1, LW2, N, NBD, NF, NPTS,
     +                BL, BU, F, G, W1, W2, X,
     +                'exact', 'high')
      ELSE
         CALL QNFIT1 (DERIV1, FUNCT1,
     +                IFAIL, IW, LIW, LW1, LW2, N, NBD, NF, NPTS,
     +                BL, BU, F, G, W1, W2, X,
     +                'approximate', 'medium')
      ENDIF
      OBJFUN = F
      WSSQ(ITIME) = DOFDOM*OBJFUN

C
C Call to ZMOD to make sure THEORY is set correctly then check IFAIL
C
      CALL ZMOD (X)
      IF (IFAIL.NE.0 .AND. IFAIL.NE.1 .AND. IFAIL.NE.2)
     +    CALL PUTIFA (IFAIL, NF, 'E04JAF/DATFIT')
      DO I = 1, N
         IF (ISTATE(I).NE.0) THEN
            IF (ABS(X(I) - BL(I)).LE.EPSI) ISTATE(I) = - 2
            IF (ABS(X(I) - BU(I)).LE.EPSI) ISTATE(I) = - 1
         ENDIF
      ENDDO
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE DATOUT (INDEX, ISTATE, ITIME, LW2, LW3, MFAST, NDOF,
     +                   NF, NFREE, NGRAF, NHESS, NMAX, NN, NPAR, NPTS,
     +                   NSTART, NUMBER, NX,
     +                   AA, BB, CORR, CV, DIAGV, ERR, ERRY, FACT,
     +                   FJACC, G, HESSEX, OBJFUN, PAR, RTOL, THEORY,
     +                   TL, TPER, TU, W, WSSQ, W2, X, XSAV,
     +                   XT, XVAL, YSAV, YT, YVAL,
     +                   EQSAV, EQUAL, FREE, ISTOP, NOUT)
C
C Output printed or written to a file
C 23/02/2022 added E_NUMBERS and E_FORMATS, etc.   
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: LW2, LW3, NGRAF, NHESS, NMAX,
     +                                    NN, NX
      INTEGER,          INTENT (IN)    :: ITIME, MFAST, NDOF, NF, NSTART
      INTEGER,          INTENT (IN)    :: ISTATE(NX), NPAR(NN),
     +                                    NUMBER(NN)
      INTEGER,          INTENT (INOUT) :: NPTS
      INTEGER,          INTENT (OUT)   :: INDEX(NX), NFREE
      DOUBLE PRECISION, INTENT (IN)    :: AA(NN), BB(NN), FACT(NX),
     +                                    OBJFUN, RTOL, XT, YT
      DOUBLE PRECISION, INTENT (INOUT) :: ERRY(NMAX), THEORY(NMAX),
     +                                    WSSQ(NN),
     +                                    X(NX), XSAV(NGRAF),
     +                                    XVAL(NMAX), YSAV(NGRAF),
     +                                    YVAL(NMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: CORR(NX,NX), CV(NHESS,NHESS),
     +                                    DIAGV(NX), ERR(NX),  
     +                                    FJACC(NMAX,NX), G(NX),
     +                                    HESSEX(NHESS,NHESS), PAR(NX), 
     +                                    TL(NX), TPER(NX), TU(NX),
     +                                    W(LW3), W2(LW2) 
      LOGICAL,         INTENT (IN)     :: ISTOP, NOUT(9)
      LOGICAL,         INTENT (INOUT)  :: EQSAV(NMAX), EQUAL(NMAX)
      LOGICAL,         INTENT (OUT)    :: FREE(NX)
C
C locals
C     
      INTEGER    L0, L1, L2, L3, L5
      PARAMETER (L0 = 0, L1 = 1, L2 = 2, L3 = 3, L5 = 5)
      INTEGER    I, IFAIL, J, JCOLOR(50), NSAV
      INTEGER    NTEMP, NTEXT
      DOUBLE PRECISION PNT05, PNT975
      PARAMETER (PNT05 = 0.05D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION XTEMP1(L2), XTEMP2(L2), YTEMP1(L2), YTEMP2(L2)
      DOUBLE PRECISION ALPHA, ASYMP, TSTAT, XFIRST, XLAST
      DOUBLE PRECISION G01EBF$, G01FBF$
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      CHARACTER (LEN = 13) D13(4), SHOWRJ
      CHARACTER  FIXED*2, GOOD*2, POOR*2
      PARAMETER (FIXED = ' f', GOOD = '  ', POOR = ' *')
      CHARACTER  CHAR7(20,20)*7, CHAR8(20,20)*8, PTYPE(20)*7
      CHARACTER  PTITLE*37, XTITLE*1, YTITLE*1
      CHARACTER  TEXT(50)*120
      CHARACTER  TEMP(30)*120
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   G01EBF$, G01FBF$
      EXTERNAL   PUTIFA, GKSR01, FTESTS, DIVIDE, GKST04, TABLE6, PCVTST
      EXTERNAL   FUNCT1, QNCOV1, ZMOD
      INTRINSIC  SQRT, ABS, MAX, DBLE
      SAVE       NSAV
      IF (ISTOP) RETURN
      E_NUMBERS = E_FORMATS() 
      DO I = 1, 50
         JCOLOR(I) = 1
      ENDDO   
C
C Calculate covariance matrix and parameter standard errors
C
      CALL QNCOV1 (FUNCT1,
     +             INDEX, ISTATE, NF, NFREE, NHESS, NMAX, NPAR(ITIME),
     +             NPTS, NX,
     +             CORR, CV, DIAGV, ERRY, FACT, FJACC, G, HESSEX,
     +             OBJFUN, W2, X, XVAL, YVAL, THEORY,
     +             EQUAL, FREE)
      PAR(1) = FACT(1)*X(1)*YT
      ERR(1) = SQRT(ABS(DIAGV(1)))*YT
      DO I = 2, MFAST
         PAR(I) = FACT(I)*X(I)*AA(I - 1)
         ERR(I) = SQRT(ABS(DIAGV(I)))*AA(I - 1)
      ENDDO
      DO I = 1, ITIME
         J = MFAST + I
         PAR(J) = FACT(J)*X(J)*BB(I)
         ERR(J) = SQRT(ABS(DIAGV(J)))*BB(I)
      ENDDO
      IFAIL = 1
      TSTAT = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
      CALL PUTIFA (IFAIL, NF, 'G01FBF/DATOUT')
      DO I = 1, NPAR(ITIME)
         IF (ISTATE(I).GT.ZERO) THEN
            TL(I) = PAR(I) - TSTAT*ERR(I)
            TU(I) = PAR(I) + TSTAT*ERR(I)
            TPER(I) = ZERO
            PTYPE(I) = GOOD
            IF (ERR(I).GT.RTOL) THEN
               IFAIL = 1
               ALPHA = ONE - G01EBF$('Lower-tail', ABS(PAR(I)/ERR(I)),
     +                               DBLE(NDOF), IFAIL)
               CALL PUTIFA (IFAIL, NF, 'G01EBF/DATOUT')
               TPER(I) = TWO*ALPHA
               IF (TPER(I).LE.PNT05) THEN
                  PTYPE(I) = GOOD
               ELSE
                  PTYPE(I) = POOR
               ENDIF
            ENDIF
         ELSE
            TL(I) = ZERO
            TU(I) = ZERO
            TPER(I) = ONE
            PTYPE(I) = FIXED
         ENDIF
      ENDDO
C
C display table of best fit parameters, etc. **************************************
C
      DO I = 1, 50
         JCOLOR(I) = 0
      ENDDO   
      WRITE (TEMP,100) ITIME, ITIME
      NTEXT = 0
      DO I = 1, 4
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = TEMP(I)
      ENDDO
      JCOLOR(NTEXT) = 4
      NTEXT = NTEXT + 1
C
C Note: MFAST = ITIME + 1
C       FORMAT 100 WRITES 4 LINES
C
      
      IF (E_NUMBERS) THEN
         WRITE (TEXT(NTEXT),200) 1, 0, PAR(1), ERR(1), TL(1), TU(1),
     +                           TPER(1), PTYPE(1)
         WRITE (TEMP,200) (I, I - 1, PAR(I), ERR(I), TL(I),
     +                     TU(I), TPER(I), PTYPE(I), I = 2, MFAST)
      ELSE
         D13(1) = SHOWRJ(PAR(1))
         D13(2) = SHOWRJ(ERR(1))
         D13(3) = SHOWRJ(TL(1)) 
         D13(4) = SHOWRJ(TU(1))
         WRITE (TEXT(NTEXT),250) 1, 0, D13(1), D13(2), D13(3), D13(4),
     +                           TPER(1), PTYPE(1)
         NTEMP = 0
         DO I = 2, MFAST
            NTEMP = NTEMP + 1
            D13(1) = SHOWRJ(PAR(I))
            D13(2) = SHOWRJ(ERR(I))
            D13(3) = SHOWRJ(TL(I)) 
            D13(4) = SHOWRJ(TU(I))
            WRITE (TEMP(NTEMP),250) I, I - 1, D13(1), D13(2), D13(3),
     +                              D13(4), TPER(I), PTYPE(I)
         ENDDO
      ENDIF 
      DO I = 2, MFAST
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = TEMP(I - 1)
      ENDDO
      IF (E_NUMBERS) THEN
         WRITE (TEMP,300) (MFAST + I, I, PAR(MFAST + I),
     +                     ERR(MFAST + I), TL(MFAST + I), 
     +                     TU(MFAST + I), TPER(MFAST + I),
     +                     PTYPE(MFAST + I), I = 1, ITIME)
      ELSE
         NTEMP = 0
         DO I = 1, ITIME
            NTEMP = NTEMP + 1
            D13(1) = SHOWRJ(PAR(MFAST + I))
            D13(2) = SHOWRJ(ERR(MFAST + I))
            D13(3) = SHOWRJ(TL(MFAST + I))
            D13(4) = SHOWRJ(TU(MFAST + I))
            WRITE (TEMP(NTEMP),350) MFAST + I, I, D13(1), 
     +                              D13(2), D13(3), D13(4), 
     +                              TPER(MFAST + I),
     +                              PTYPE(MFAST + I)
         ENDDO 
      ENDIF  
   
      DO I = 1, ITIME
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = TEMP(I)
      ENDDO
C
C Table of correlation matrix setting f for fixed parameters
C
      IF (NFREE.GT.1) THEN
         DO I = 1, NPAR(ITIME)
            DO J = 1, I
               IF (FREE(I) .AND. FREE(J)) THEN
                  IF (NPAR(ITIME).LT.13) THEN
                     WRITE (CHAR8(I,J),400) CORR(I,J)
                  ELSE
                    WRITE (CHAR7(I,J),450) CORR(I,J)
                  ENDIF
               ELSE
                  IF (NPAR(ITIME).LT.13) THEN
                     WRITE (CHAR8(I,J),500) FIXED
                  ELSE
                     WRITE (CHAR7(I,J),550) FIXED
                  ENDIF
               ENDIF
            ENDDO
         ENDDO
      ENDIF
      IF (NFREE.GT.1 .AND. NOUT(1)) THEN
         WRITE (TEMP,600)
         DO I = 1, 2
            NTEXT = NTEXT + 1
            TEXT(NTEXT) = TEMP(I)
         ENDDO
         JCOLOR(NTEXT) = 4
         DO I = 1, NPAR(ITIME)
             NTEXT = NTEXT + 1
             IF (NPAR(ITIME).LT.13) THEN
                WRITE (TEXT(NTEXT),700) (CHAR8(I,J), J = 1, I)
             ELSE
                WRITE (TEXT(NTEXT),750) (CHAR7(I,J), J = 1, I)
             ENDIF
         ENDDO
      ENDIF
      CALL TABLE6 (JCOLOR, NTEXT,
     +             TEXT)   
C
C Write table of best-fit parameter, etc. to results file************************************************
C       
      WRITE (NF,100)  ITIME, ITIME
      IF (E_NUMBERS) THEN
         WRITE (NF,200)  1, 0, PAR(1), ERR(1), TL(1), TU(1), TPER(1),
     +                PTYPE(1)
         WRITE (NF,200) (I, I - 1, PAR(I), ERR(I), TL(I), TU(I), 
     +                   TPER(I), PTYPE(I), I = 2, MFAST)
      ELSE
         D13(1) = SHOWRJ(PAR(1))
         D13(2) = SHOWRJ(ERR(1))
         D13(3) = SHOWRJ(TL(1)) 
         D13(4) = SHOWRJ(TU(1))
         WRITE (NF,250) 1, 0, D13(1), D13(2), D13(3), D13(4), TPER(1),
     +                  PTYPE(1)
         DO I = 2, MFAST
            D13(1) = SHOWRJ(PAR(I))
            D13(2) = SHOWRJ(ERR(I))
            D13(3) = SHOWRJ(TL(I)) 
            D13(4) = SHOWRJ(TU(I))
            WRITE (NF,250) I, I - 1, D13(1), D13(2), D13(3), D13(4),
     +                     TPER(I), PTYPE(I)
         ENDDO
      ENDIF  
      IF (E_NUMBERS) THEN
         WRITE (NF,300) (MFAST + I, I, PAR(MFAST + I), ERR(MFAST + I),
     +                   TL(MFAST + I), TU(MFAST + I), TPER(MFAST + I),
     +                   PTYPE(MFAST + I), I = 1, ITIME)
      ELSE
         DO I = 1, ITIME
            D13(1) = SHOWRJ(PAR(MFAST + I))
            D13(2) = SHOWRJ(ERR(MFAST + I))
            D13(3) = SHOWRJ(TL(MFAST + I))
            D13(4) = SHOWRJ(TU(MFAST + I))
            WRITE (NF,350) MFAST + I, I, D13(1), D13(2),
     +                     D13(3), D13(4), TPER(MFAST + I),
     +                     PTYPE(MFAST + I)
         ENDDO 
      ENDIF  
      IF (NFREE.GT.1) THEN
         WRITE (NF,600)
         DO I = 1, NPAR(ITIME)
             IF (NPAR(ITIME).LT.13) THEN
                WRITE (NF,700) (CHAR8(I,J), J = 1, I)
             ELSE
                WRITE (NF,750) (CHAR7(I,J), J = 1, I)
             ENDIF
         ENDDO
      ENDIF

C
C First call ZMOD to make sure THEORY is defined properly then set
C best-fit curve etc. in external coordinates and call GKSR01, FTESTS
C
      CALL ZMOD (X)
      DO I = 1, NPTS
         ERRY(I) = ERRY(I)*YT
         THEORY(I) = THEORY(I)*YT
         XVAL(I) = XVAL(I)*XT
         YVAL(I) = YVAL(I)*YT
      ENDDO
C
C Analyse residuals
C
      CALL GKSR01 (NF, NUMBER(ITIME), NPTS,
     +             W(1), ERRY, THEORY, W(NPTS + 1), XVAL, YVAL,
     +             NOUT(7), SAVEIT, NOUT(5), NOUT(6), NOUT(1))
C
C F test
C
      IF (ITIME.GT.NSTART) THEN
         CALL FTESTS (NUMBER(ITIME - 1), NUMBER(ITIME), NF, NPTS,
     +                WSSQ(ITIME - 1), WSSQ(ITIME), 
     +                SAVEIT, NOUT(1))
      ENDIF

C
C Graphics if requested with
C W(       1 -->  NPTS) = XVAL in old coordinates
C W(NPTS + 1 --> 2NPTS) = THEORY in old coordinates
C
      IF (NOUT(4)) THEN
         DO I = 1, NPTS
            EQSAV(I) = EQUAL(I)
            W(I) = XVAL(I)
            W(NPTS + I) = THEORY(I)
         ENDDO
         XFIRST = XVAL(1)/XT
         XLAST = XVAL(NPTS)/XT
         CALL DIVIDE (NGRAF, 
     +                XVAL, XFIRST, XLAST)
         DO I = 1, NGRAF
            EQUAL(I) = .FALSE.
         ENDDO
         NSAV = NPTS
         NPTS = NGRAF
         CALL ZMOD (X)
         NPTS = NSAV
         DO I = 1, NGRAF
            XVAL(I) = XVAL(I)*XT
            THEORY(I) = THEORY(I)*YT
         ENDDO
         XTITLE = 'x'
         YTITLE = 'y'
         IF (ITIME.EQ.1 .AND. (PAR(2) - PAR(1)*PAR(3)).GT.ZERO) THEN
            ASYMP = PAR(2)/MAX(RTOL, PAR(3))
         ELSEIF ((PAR(ITIME+1)*PAR(2*ITIME)-PAR(ITIME)*PAR(2*ITIME+1))
     +      .GT.ZERO) THEN
            ASYMP = PAR(ITIME + 1)/MAX(RTOL,PAR(2*ITIME + 1))
         ELSE
            ASYMP = - ONE
         ENDIF
         DO I = 1, L2
            XTEMP1(I) = ONE
            XTEMP2(I) = ONE
            YTEMP1(I) = ONE
            YTEMP2(I) = ONE
         ENDDO
         IF (ITIME.EQ.NSTART) THEN
            PTITLE = 'Experimental Data and Best-Fit Curve'
            CALL GKST04 (L0, L1, L0, L0,
     +                   L5, L0, L0, L0,
     +                   NPTS, NGRAF, L2, L2,
     +                   ASYMP,
     +                   W, XVAL, XTEMP1, XTEMP2,
     +                   YVAL, THEORY, YTEMP1, YTEMP2,
     +                   PTITLE, XTITLE, YTITLE,
     +                   SAVEIT, SAVEIT)
         ELSE
            PTITLE = 'Data, Best-Fit Curve and Previous Fit'
            CALL GKST04 (L0, L1, L3, L0,
     +                   L5, L0, L0, L0,
     +                   NPTS, NGRAF, NGRAF, L2, 
     +                   ASYMP,
     +                   W, XVAL, XSAV, XTEMP1,
     +                   YVAL, THEORY, YSAV, YTEMP1,
     +                   PTITLE, XTITLE, YTITLE,
     +                   SAVEIT, SAVEIT)
         ENDIF
C
C Save best-fit curve and restore data
C
         DO I = 1, NGRAF
            XSAV(I) = XVAL(I)
            YSAV(I) = THEORY(I)
         ENDDO
         DO I = 1, NPTS
            EQUAL(I) = EQSAV(I)
            XVAL(I) = W(I)
            THEORY(I) = W(NPTS + I)
         ENDDO
      ENDIF
C
C Call PCVTST
C
      IF (NOUT(9)) THEN
         DO I = 1, NPAR(ITIME)
            DO J = 1, I
               IF (I.EQ.J) THEN
                  IF (FREE(I)) THEN
                     CV(I,I) = ERR(I)**2
                  ELSE
                     CV(I,I) = ZERO
                  ENDIF
               ELSE
                  IF (FREE(I) .AND. FREE(J)) THEN
                     CV(I,J) = CORR(I,J)*ERR(I)*ERR(J)
                  ELSE
                     CV(I,J) = ZERO
                  ENDIF
                  CV(J,I) = CV(I,J)
               ENDIF
            ENDDO
         ENDDO
         I = 1
         CALL PCVTST (I, NF, NPAR(ITIME), NPTS, NHESS,
     +                CV, PAR)
      ENDIF      
C
C Finally restore to internal coordinates
C
      DO I = 1, NPTS
         ERRY(I) = ERRY(I)/YT
         THEORY(I) = THEORY(I)/YT
         XVAL(I) = XVAL(I)/XT
         YVAL(I) = YVAL(I)/YT
      ENDDO
C      
C Format statements      
C 
  100 FORMAT (
     +/1X,'For best-fit',I2,':',I1,1X,'function (f = fixed parameter)'
     +//1X,
     +'Number Parameter     Value        Std.Error    Lower95%cl   ',
     +' Upper95%cl',4X,'p')
  200 FORMAT (4X,I2,4X,'A(',I1,')',2X,1P,4E14.5,0P,F8.4,A)
  250 FORMAT (4X,I2,4X,'A(',I1,')',2X,4(1X,A13),F8.4,A)
  300 FORMAT (4X,I2,4X,'B(',I1,')',2X,1P,4E14.5,0P,F8.4,A)  
  350 FORMAT (4X,I2,4X,'B(',I1,')',2X,4(1X,A13),F8.4,A)        
  400 FORMAT (F8.4)
  450 FORMAT (F7.4)
  500 FORMAT ('   ',A2,'  ')
  550 FORMAT ('   ',A2,' ')
  600 FORMAT (
     +/1X,'Parameter correlation matrix (f = fixed parameter)')
  700 FORMAT (12A8)
  750 FORMAT (13A7)
      END
C
C
