C
C RFFIT2.FOR: include code for RFFIT
C ==========
C
C DERIV1
C DERIV2
C DETAIL
C FUNCT1
C L1NORM
C LINEAR
C MONIT
C
C
C
      subroutine deriv1 (funct, n, g, w, x)
c
c action : finite difference approximation to derivatives using qngrd1
c
      implicit   none
c
c arguments
c      
      integer,          intent (in)    :: n
      double precision, intent (out)   :: g(n), w(3*n)
      double precision, intent (inout) :: x(n)
c
c locals
c      
      integer    inform
      
      logical    tpoint
      parameter (tpoint = .false.)
      external   funct, qngrd1
      call qngrd1 (funct, inform, n, g, w, x, tpoint)
      end
C
C
CFTN95$OPTIONS (SILENT)
      SUBROUTINE DERIV2 (FUNCT,
     +                   N,
     +                   G, W, X)
C
C
C Rational function with A(0) and A(N) if required
C

      USE MODULE_RFFIT, ONLY : ITIME, KFAST, FACT, YVAL, THEORY, ERRY,
     +                         DOFDOM, ANIN, A0IN, NPTS, XVAL, MFAST, 
     +                         EQUAL
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N
      DOUBLE PRECISION, INTENT (OUT)   :: G(N), W(3*N)
      DOUBLE PRECISION, INTENT (INOUT) :: X(N)
C
C Locals
C      
      INTEGER    NN, NX
      PARAMETER (NN = 6, NX = 2*NN + 1)
      INTEGER    I, J, K
      DOUBLE PRECISION A(NN + 1), B(NN + 1), C(NN + 1), D(NN + 1)
      DOUBLE PRECISION BOT, BOT2, RATIO, TERM, T(20), TOP
      double precision f
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      EXTERNAL FUNCT
C
C ====================================================================
C FUNCT must be called before this routine (as in QNFIT1) to make sure
C that THEORY is correctly set ... o/w call FUNCT at this point
C     CALL FUNCT (N, X, F)
      if (n.lt.0) call funct (n, x, f)!to silence NAGfor
      w(1) = zero  
C ====================================================================
C
C
C Initialise G(I) = 0.0
C
      DO I = 1, N
         G(I) = ZERO
      ENDDO
C
C Calculate scaled parameters and temporary arrays
C
      DO I = 1, ITIME
         J = KFAST - I
         K = ITIME + J
         A(I) = FACT(J)*X(J)
         C(I) = FACT(K)*X(K)
      ENDDO
      A(MFAST) = FACT(1)*X(1)
      C(MFAST) = ONE
C
C A and C must not now be changed but B and D are calculated as needed
C
      B(1) = A(1)
      D(1) = C(1)
C
C The loop over each point
C
      DO I = 1, NPTS
C
C Calculate the common TERM
C
         TERM = (YVAL(I) - THEORY(I))/(ERRY(I)*ERRY(I))
C
C Calculate numerator and denominator for the rational function
C
         IF (.NOT.EQUAL(I)) THEN
C
C Define the monomials x, x^2, x^3, etc.
C
            T(1) = XVAL(I)
            IF (ITIME.GT.1) THEN
               DO J = 2, ITIME
                  T(J) = T(1)*T(J - 1)
               ENDDO
            ENDIF
C
C Now the rational function numerator, denominator and denominator^2
C
            DO J = 2, MFAST
               B(J) = B(J - 1)*XVAL(I) + A(J)
               D(J) = D(J - 1)*XVAL(I) + C(J)
            ENDDO
            TOP = B(MFAST)
            BOT = D(MFAST)
            BOT2 = BOT*BOT
         ENDIF
C
C First the numerator derivatives
C
         DO J = 1, ITIME + 1
            K = J - 1
            IF (J.EQ.1) THEN
               IF (A0IN) G(1) = G(1) + FACT(1)*TERM/BOT
            ELSEIF (J.EQ.ITIME + 1) THEN
               IF (ANIN) G(J) =  G(J) + FACT(J)*T(K)*TERM/BOT
            ELSE
               G(J) = G(J) + FACT(J)*T(K)*TERM/BOT
            ENDIF
         ENDDO
C
C Now the denominator derivatives
C
         K = 0
         RATIO = TOP/BOT2
         DO J = ITIME + 2, 2*ITIME + 1
            K = K + 1
            G(J) = G(J) - FACT(J)*T(K)*RATIO*TERM
         ENDDO
      ENDDO
C
C Finally correct for the multiplier
C
      TERM = - TWO/DOFDOM
      DO I = 1, N
         G(I) = TERM*G(I)
      ENDDO
      END
C
C-------------------------------------------------------------------
C
      SUBROUTINE DETAIL (ITYPE, MAXNUM, NBIG, NF, NN, NPTS, NRAND,
     +                   NSMALL, NSTART, NSTOP,
     +                   AA, A0, A1, AN, BB, RTOL, SIGMA, XT, XVAL,
     +                   YT, YVAL,
     +                   ANIN, A0IN, EQUAL, ISTOP, NOUT_IN)
C
C Read orders and control function type and output
C 30/08/2017 developed from sffit_detail.for 
C 13/02/2020 added SWITCH_OFF and METHOD which is used (as set by the parameter METHOD1) as follows:
C            METHOD = 1: two separate intialisation questions
C            METHOD = 2: one page with both questions
C            o/w assume A(0) = 0 and A(N) varied  
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NF, NN, NPTS
      INTEGER,          INTENT (INOUT) :: ITYPE, MAXNUM, NBIG, NRAND,
     +                                    NSMALL, NSTART, NSTOP
      DOUBLE PRECISION, INTENT (IN)    :: RTOL, XVAL(NPTS), XT,
     +                                    YVAL(NPTS), YT
      DOUBLE PRECISION, INTENT (INOUT) :: AA(NN), A0, A1, AN, BB(NN),
     +                                    SIGMA
      LOGICAL,          INTENT (INOUT) :: ANIN, A0IN, EQUAL(NPTS), 
     +                                    ISTOP, NOUT_IN(9)
C
C locals
C        
      integer    method, method1, n_query
      parameter  (method1 = 2, n_query = 19)
      integer    numcol, numrow, ntext
      parameter (numcol = 1, numrow = 0)     
      integer    numopt, numsta, numtxt, n1
      parameter (numopt = 24, numsta = 1, n1 = 1)
      integer    i, icolor, ixl, iyl, j, kvalue(numopt),
     +           numbld(numopt), numpos(numopt), kvlim_1(numopt),
     +           kvlim_2(numopt)
      integer    nbold(30)
      integer    icolor1, ix, iy, klog, lshade
      parameter (icolor1 = 9, ix = 4, iy = 4, klog = 14)
      parameter (icolor = 7, ixl = 0, iyl = 0, lshade = 0)
      double precision xvalue(numopt) 
      double precision zero, one, factor
      parameter (zero = 0.0d+00, one = 1.0d+00, factor = 2.0d+00)
      character (len = 100) svalue(numopt), text_in(numopt)
      character (len = 100) line, text(30)
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    nout(klog)
      logical    first_time, switch_off
      logical    repeet
      logical    abort, first
      logical    fixed, full, high
      parameter (fixed = .false., full = .true., high = .true.)
      LOGICAL    BORDER, FLASH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE.)      
      external   advise, get00x, order, yesno1, putfat  
      intrinsic  max, min 
      save       first_time, switch_off
      data       first_time, switch_off  / .true., .false. /
      data       nbold / 30*0 /
      data       numpos / numopt*0 /

      IF (ISTOP) RETURN
c
c check
c
      if (switch_off) then
          if (.not.anin) then
            if (nstart.lt.2) nstart = 2
            if (nstart.gt.nstop) nstop = nstart  
          endif  
C
C Estimate A0, A1 and AN
C
         CALL ORDER (ITYPE, NF, NPTS,
     +               A0, A1, AN, RTOL, XVAL, YVAL,
     +               EQUAL, ISTOP)
         return
      endif 
      if (nstart.lt.1 .or. nstart.gt.nstop .or. nstop.gt.nn) then 
         call putfat (
     +'Must have 1 =< NSTART =< NSTOP =< NN in call to DETAIL')
         return
      endif 
      if (nrand.lt.1 .or. nrand.gt.5) then
         call putfat ('Must have 1 =< NRAND =< 5 in call to DETAIL')
         return
      endif  
C
C Action taken first time round
C        
      IF (FIRST_TIME) THEN
         FIRST_TIME = .FALSE.
         METHOD = METHOD1
         A0IN = .FALSE.
         ANIN = .TRUE.
         IF (METHOD.EQ.1) THEN
C
C Is A(0) required ?
C
            WRITE (TEXT,100)
            NTEXT = 9
            LINE = 'Include an A(0) term in the model ? (usually no)'
            A0IN = .FALSE.
            CALL YESNO1 (ICOLOR1, IX, IY, LSHADE, NUMCOL, NUMROW, NTEXT,
     +                   LINE, TEXT,
     +                   BORDER, FLASH, HIGH, A0IN)
C
C Is A(N) required ?
C
            WRITE (TEXT,200)
            LINE = 'Include an A(n) term in the model ? (usually yes)'
            ANIN = .TRUE.
            CALL YESNO1 (ICOLOR1, IX, IY, LSHADE, NUMCOL, NUMROW, NTEXT,
     +                   LINE, TEXT,
     +                   BORDER, FLASH, HIGH, ANIN)
         ELSEIF (METHOD.EQ.2) THEN
            write (text_in,300)
            do i = 1, n_query
               kvalue(i) = 0
               kvlim_1(i) = 0
               kvlim_2(i) = 1 
               numbld(i) = 0
               numpos(i) = 8
               svalue(i) = blank
               xvalue(i) = zero
            enddo
            numbld(1) = 1
            kvalue(n_query - 2) = 0
            kvalue(n_query) = 1  
            numpos(n_query - 2) = 4
            numpos(n_query) = 4 
            call get00x (icolor, ixl, iyl, kvalue, kvlim_1, kvlim_2, 
     +                   lshade, numbld, n_query, numpos, numsta,
     +                   n_query,
     +                   xvalue,
     +                   svalue, text_in,
     +                   fixed, full, high)
            if (kvalue(n_query - 2).eq.1) then
               a0in = .true.
            elseif (kvalue(n_query - 1).eq.0) then
               a0in = .false. 
            endif     
            if (kvalue(n_query).eq.1) then
               anin = .true.
            elseif (kvalue(n_query).eq.0) then
               anin = .false.
            endif           
         ENDIF
         IF (.NOT.A0IN .AND. ANIN)      ITYPE = 1
         IF (.NOT.A0IN .AND. .NOT.ANIN) ITYPE = 2
         IF (A0IN .AND. ANIN)           ITYPE = 3
         IF (A0IN .AND. .NOT.ANIN)      ITYPE = 4
      ENDIF
C
C End of first time actions then fine tune nstart and nstop
C
      
      if (.not.anin) then
         if (nstart.lt.2) nstart = 2
         if (nstart.gt.nstop) nstop = nstart  
      endif  
C
C Estimate A0, A1 and AN
C
      CALL ORDER (ITYPE, NF, NPTS,
     +            A0, A1, AN, RTOL, XVAL, YVAL,
     +            EQUAL, ISTOP)
      IF (ISTOP) RETURN
c
c initialise all local variables
c
      do i = 1, klog
         nout(i) = .false.
      enddo   
      do i = 1, 9
         nout(i) = nout_in(i)
      enddo
      nout(10) = a0in
      nout(11) = anin
      do i = 1, numopt
         numbld(i) = 0
         numpos(i) = 0
         kvalue(i) = 0
         kvlim_1(i) = 0
         kvlim_2(i) = 0
         xvalue(i) = zero
         svalue(i) = blank
      enddo
c
c set parameters for nstart and nstop and default nrand
c      
      kvlim_1(2) = 1
      kvlim_2(2) = nn
      kvlim_1(3) = 1
      kvlim_2(3) = nn
      kvalue(2) = nstart
      kvalue(3) = nstop
      do i = 1, 5
         if (nrand.eq.i) kvalue(i + 4) = 1
      enddo
c
c create the text array
c      
      write (text_in,400) n1, nn
      numpos(1) = 8 
         numbld(1) = 1!blue text
      numpos(2) = 9
      numpos(3) = 9
      numpos(4) = 8
         numbld(4) = 1!blue text
      numpos(5) = 6
      numpos(6) = 6 
      numpos(7) = 6
      numpos(8) = 6
      numpos(9) = 6
      numpos(10) = 8
         numbld(10) = 1!blue text
      numpos(11) = 4
      numpos(12) = 4 
      numpos(13) = 4
      numpos(14) = 4
      numpos(15) = 4
      numpos(16) = 4
      numpos(17) = 4
      numpos(18) = 4
      numpos(19) = 4
      numpos(20) = 4
      numpos(21) = 4
      numpos(22) = 4
      numpos(23) = 4
      numpos(24) = 4
C
C set logical parameters
C nout(1)  ... display analysis table
C nout(2)  ... display starting estimates
C nout(3)  ... display random search
C nout(4)  ... plot    best fit curves
C nout(5)  ... plot    residuals
C nout(6)  ... display residuals table
C nout(7)  ... file    residuals table
C nout(8)  ... high precision convergence test
C nout(9) ... parameters and covariance matrix
C
C internally to set a0in and anin
C
C nout(10) ... a0in
C nout(11) ... anin
C              help
C              quit
C
      j = 10
      do i = 1, 9
         j = j + 1
         if (nout(i)) kvalue(j) = 1
      enddo
      j = j + 1  
      nout(10) = a0in
      if (nout(10)) kvalue(j) = 1
      j = j + 1  
      nout(11) = anin
      if (nout(11)) kvalue(j) = 1
c
c loop over the options
c      
      numtxt = numopt
      repeet = .true.
      do while (repeet)
         kvalue(numopt - 2) = 0
         kvalue(numopt) = 0
         call get00x (icolor, ixl, iyl, kvalue, kvlim_1, kvlim_2, 
     +                lshade, numbld, numopt, numpos, numsta, numtxt,
     +                xvalue,
     +                svalue, text_in,
     +                fixed, full, high)
c
c define nstart, nstop
c     
         nstart = min(kvalue(2),kvalue(3))
         nstop = max(kvalue(2),kvalue(3))
c
c define nrand
c         
         j = 0
         do i = 5, 9
            j = j + 1
            if (kvalue(i).eq.1) then
               nrand = j
            endif
         enddo  
         IF (NRAND.EQ.1) THEN
            MAXNUM = 2500
            NBIG = 10
            NSMALL = 1
            SIGMA = 0.5D+00
         ELSEIF (NRAND.EQ.2) THEN
            MAXNUM = 5000
            NBIG = 25
            NSMALL =  2
            SIGMA = 0.3D+00
         ELSEIF (NRAND.EQ.3) THEN
            MAXNUM = 10000
            NBIG = 50
            NSMALL =  4
            SIGMA = 0.125D+00
         ENDIF
         IF (NRAND.LT.4) SIGMA = SIGMA/FACTOR
         AA(1) = YT/XT
         BB(1) = ONE/XT
         DO I = 2, NSTOP
            AA(I) = AA(I - 1)/XT
            BB(I) = BB(I - 1)/XT
         ENDDO
c
c assign logical variables
c
         j = 10
         do i = 1, 12
            j = j + 1
            if (kvalue(j).eq.1) then
               nout(i) = .true.
            else
               nout(i) = .false.
            endif   
         enddo  
        
c
c check if Advise or Quit have been chosen
c
         if (kvalue(numopt - 1).eq.1) switch_off = .true.
         if (kvalue(numopt - 2).eq.1) then
             first = .false.
             call advise (blank,
     +                    abort, first) 
             kvalue(numopt - 2) = 0
             repeet = .true.
             
         elseif (kvalue(numopt).eq.1) then
            istop = .true.
            return
         else
            repeet = .false.
            do i = 1, 9
               nout_in(i) = nout(i)
            enddo 
            if (kvalue(20).eq.1) then
               a0in = .true.
            else
               a0in = .false.
            endif
            if (kvalue(21).eq.1) then
               anin = .true.
            else
               anin = .false.
            endif  
            IF (.NOT.A0IN .AND. ANIN)      ITYPE = 1
            IF (.NOT.A0IN .AND. .NOT.ANIN) ITYPE = 2
            IF (A0IN .AND. ANIN)           ITYPE = 3
            IF (A0IN .AND. .NOT.ANIN)      ITYPE = 4  
            if (.not.anin) then
               if (nstart.lt.2) nstart = 2
               if (nstart.gt.nstop) nstop = nstart  
           endif     
         endif    
      enddo
C
C Format statements
C      
  100 FORMAT ('First time question concerning parameter A(0)'
     +/
     +/'You can include A(0) as a parameter to be estimated'
     +/'(which increases the curve-fitting difficulties) or'
     +/'it can be held fixed at the value A(0) = 0.'
     +/
     +/'Only include A(0) if y is definitely nonzero when x'
     +/'is zero, e.g., when x is an activator or inhibitor.'
     +/)
  200 FORMAT ('First time question concerning parameter A(n)'
     +/
     +/'You can include A(n) as a parameter to be estimated'
     +/'(which increases the curve-fitting difficulties) or'
     +/'it can be held fixed at the value A(n) = 0.'
     +/
     +/'Only leave out A(n) if y approaches zero as x tends'
     +/'to infinity, e.g., with substrate inhibition.'
     +/)
  300 FORMAT ('First time questions concerning parameters A(0) and A(N)'
     +/
     +/'You can include A(0) as a numerator parameter to be estimated'
     +/'(which increases the curve-fitting difficulties).'
     +/'Or, more usually, it can be held fixed at the value A(0) = 0.'
     +/
     +/'Only include A(0) if y is definitely nonzero when x'
     +/'is zero, e.g., when x is an activator or inhibitor.'
     +/
     +/'You can include A(N) as a numerator parameter to be estimated'
     +/'(which is the usual case with enzyme kinetics).'
     +/'Or it can be held fixed at the value A(N) = 0.'
     +/
     +/'Only set A(N) = 0 if y approaches zero as x tends'
     +/'to infinity, e.g., with substrate inhibition.'
     +/
     +/'Estimate numerator parameter A(0)'
     +/
     +/'Estimate numerator parameter A(N)')
  400 FORMAT (
     + 'Choose the sequence of rational functions'                  !1
     +/'Lowest order (>=',i2,' Must be >=2 if AN = 0)'              !2
     +/'Highest order (=<',i2,')'                                   !3
     +/'Choose the method to use for parameter starting estimates'  !4 
     +/'Short Random search'                                        !5
     +/'Medium Random search'                                       !6
     +/'Extensive Random search'                                    !7!   NEW ITEM
     +/'Use default starting estimates'                             !8   !7 
     +/'You input starting estimates'                               !9   !8
     +/'Choose the procedures required for this analysis'           !10  !9 
     +/'Display the goodness of fit analysis'                       !11  !10
     +/'Display values of starting estimates'                       !12  !11
     +/'Display details of any random search'                       !13  !12
     +/'Plot the best fit curves and data'                          !14  !13 
     +/'Provide options to plot residuals'                          !15  !14
     +/'Display tables of (wtd.) residuals'                         !16  !15
     +/'Write residuals to results log file'                        !17  !16
     +/'Use analytic-gradient/high-precision'                       !18  !17
     +/'Store/test parameters/covariance-matrix'                    !19
     +/'Fit an intial numerator parameter A0'                       !20
     +/'Fit a final numerator parameter AN'                         !21
     +/'Help'                                                       !22 
     +/'Do not ask again this session'                              !23                                                                           
     +/'Quit ... Exit program RFFIT')                               !24                       
      END
C
C-------------------------------------------------------------------
C
      SUBROUTINE FUNCT1 (N,
     +                   XC, FC)
C
C Evaluation ot the weighted residual  if NPTS = 1
C Evaluation of the objective function if NPTS > 1
C

      USE MODULE_RFFIT, ONLY : YVAL, THEORY, ERRY, NPTS, DOFDOM

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      DOUBLE PRECISION, INTENT (IN)  :: XC(N)
      DOUBLE PRECISION, INTENT (OUT) :: FC
C
C Locals
C      
      INTEGER    NN, NX
      PARAMETER (NN = 6, NX = 2*NN + 1)
      INTEGER    I
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL ZMOD
      CALL ZMOD (XC)
      IF (NPTS.EQ.1) THEN
         FC = (YVAL(1) - THEORY(1))/ERRY(1)
      ELSE
         FC = ZERO
         DO I = 1, NPTS
            FC = FC + ((YVAL(I) - THEORY(I))/ERRY(I))**2
         ENDDO
         FC = FC/DOFDOM
      ENDIF
      END
C
C-------------------------------------------------------------------
C
      SUBROUTINE L1NORM (INDX, LW, M, N, NF, NMAX, NX,
     +                   A, B, E, F, S, W)
C
C Minimise AX - B in the L1 norm using E02GBF
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: LW, M, N, NF, NMAX, NX
      INTEGER,          INTENT (OUT)   :: INDX(M + N)
      DOUBLE PRECISION, INTENT (IN)    :: A(NMAX,N), B(M)
      DOUBLE PRECISION, INTENT (OUT)   :: E(NX, M + N), F(M + N), W(LW)
      DOUBLE PRECISION, INTENT (INOUT) :: S(N)
C
C Locals
C     
      INTEGER    I, IFAIL, J, K, MPL
      DOUBLE PRECISION SMIN
      PARAMETER (SMIN = 1.0D-05)
      DOUBLE PRECISION EL1N
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL MONIT
      EXTERNAL E02GBF$
      EXTERNAL PUTIFA
      DO I = 1, N
         DO J = 1, M
            E(I,J) = A(J,I)
         ENDDO
      ENDDO
      DO I = 1, N
         DO J = M + 1, M + N
            IF (J.EQ.M + I) THEN
               E(I,J) = ONE
            ELSE
               E(I,J) = ZERO
            ENDIF
         ENDDO
      ENDDO
      DO I = 1, M
         F(I) = B(I)
      ENDDO
      DO I = M + 1, M + N
         F(I) = SMIN
      ENDDO
      I = - 1
      J = 1000
      IFAIL = 1
      MPL = M + N
      CALL E02GBF$(M, N, MPL, E, NX, F, S, J, MONIT, I, K,
     +             EL1N, INDX, W, LW, IFAIL)
      CALL PUTIFA (IFAIL, NF, 'E02GBF/L1NORM')
      DO I = 1, N
         IF (S(I).LT.SMIN) S(I) = SMIN
      ENDDO
      END
C
C-------------------------------------------------------------------
C
      SUBROUTINE LINEAR (INDX, ITIME, ITYPE, LW, NF, NMAX, NN, NPAR,
     +                   NPTS, NRAND, NUMBER, NX,
     +                   A, AA, BB, DOFDOM, E, ERRY, F, FACT, S,
     +                   STORES, TESTQ, THEORY, W, X, XVAL, YVAL, YT,
     +                   ISTOP, NOUT)
C
C Solution of the over-determined linear system
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ITIME, ITYPE, LW, NF, NMAX,
     +                                    NN, NPTS, NRAND, NX
      INTEGER,          INTENT (IN)    :: NPAR(NN), NUMBER(NN)
      INTEGER,          INTENT (OUT)   :: INDX(NMAX + NX)
      DOUBLE PRECISION, INTENT (IN)    :: AA(NN), BB(NN), DOFDOM,
     +                                    ERRY(NMAX), TESTQ, XVAL(NMAX), 
     +                                    YVAL(NMAX), YT
      DOUBLE PRECISION, INTENT (OUT)   :: A(NMAX,NX), E(NX,NMAX + NX),
     +                                    F(NMAX + NX), S(NX),
     +                                    THEORY(NMAX), W(LW)
      DOUBLE PRECISION, INTENT (INOUT) :: FACT(NX), STORES(NX), X(NX)
      LOGICAL,          INTENT (IN)    :: ISTOP, NOUT(*)
C
C Locals
C      
      INTEGER    I, J, K, M, N
      INTEGER    COLOUR
      DOUBLE PRECISION ONE, SMIN
      PARAMETER (ONE = 1.0D+00, SMIN = 1.0D-06)
      DOUBLE PRECISION FCN, TEMP
      CHARACTER  LINE*80
      CHARACTER (LEN = 13) D13, SHOWLJ
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   TABLE1
      EXTERNAL   L1NORM, FUNCT1
C
C No action if NRAND >= 4 or ISTOP = .TRUE.
C
      IF (ISTOP) RETURN
      IF (NRAND.GE.4) RETURN
      E_NUMBERS = E_FORMATS() 
C
C Define M, N, S
C
      M = NPTS
      N = NUMBER(ITIME)
      DO I = 1, N
         IF (ITYPE.EQ.1) THEN
            S(I) = STORES(I + 1)
         ELSEIF (ITYPE.EQ.2) THEN
            IF (I.LE.ITIME - 1) THEN
               S(I) = STORES(I + 1)
            ELSE
               S(I) = STORES(I + 2)
            ENDIF
         ELSEIF (ITYPE.EQ.3) THEN
            S(I) = STORES(I)
         ELSE
            IF (I.LE.ITIME) THEN
               S(I) = STORES(I)
            ELSE
               S(I) = STORES(I + 1)
            ENDIF
         ENDIF
         IF (S(I).LT.SMIN) S(I) = SMIN
      ENDDO
C
C Display results if NOUT(3) = .TRUE.
C
      IF (NOUT(3)) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         WRITE (LINE,100)
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
         COLOUR = 0
      ENDIF
      WRITE (NF,100)
C
C Next action depends on ITYPE
C
      IF (ITYPE.EQ.1) THEN
C
C ITYPE = 1
C =========
C
         DO I = 1, M
            THEORY(I) = YVAL(I)/ERRY(I)
            TEMP = ONE/ERRY(I)
            DO J = 1, ITIME
               TEMP = TEMP*XVAL(I)
               A(I,J) = TEMP
               A(I,ITIME + J) = - YVAL(I)*TEMP
            ENDDO
         ENDDO
         CALL L1NORM (INDX, LW, M, N, NF, NMAX, NX,
     +                A, THEORY, E, F, S, W)
         DO I = 1, N
            IF (NOUT(3)) THEN
               IF (I.LE.ITIME) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,200) I, S(I)*AA(I)
                     WRITE (NF,200) I, S(I)*AA(I)
                  ELSE
                     TEMP = S(I)*AA(I)
                     D13 = SHOWLJ(TEMP)
                     WRITE (LINE,250) I, D13
                     WRITE (NF,250) I, D13 
                  ENDIF  
               ELSE
                  J = I - ITIME
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,300) J, S(I)*BB(J)
                     WRITE (NF,300) J, S(I)*BB(J)
                  ELSE
                     TEMP = S(I)*BB(J)
                     D13 = SHOWLJ(TEMP)
                     WRITE (LINE,350) J, D13
                     WRITE (NF,350) J, D13
                  ENDIF  
               ENDIF
               CALL TABLE1 (COLOUR, LINE)
            ENDIF
            FACT(1 + I) = S(I)
         ENDDO
      ELSEIF (ITYPE.EQ.2) THEN
C
C ITYPE = 2
C =========
C
         DO I = 1, M
            THEORY(I) = YVAL(I)/ERRY(I)
            TEMP = ONE/ERRY(I)
            DO J = 1, ITIME - 1
               TEMP = TEMP*XVAL(I)
               A(I,J) = TEMP
               A(I,ITIME - 1 + J) = - YVAL(I)*TEMP
            ENDDO
            A(I,N) = XVAL(I)*A(I,N - 1)
         ENDDO
         CALL L1NORM (INDX, LW, M, N, NF, NMAX, NX,
     +                A, THEORY, E, F, S, W)
         DO I = 1, ITIME - 1
            IF (NOUT(3)) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,200) I, S(I)*AA(I)
                  WRITE (NF,200) I, S(I)*AA(I)
               ELSE
                  TEMP = S(I)*AA(I)
                  D13 = SHOWLJ(TEMP)
                  WRITE (LINE,250) I, D13
                  WRITE (NF,250) I, D13 
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
            ENDIF
            FACT(1 + I) = S(I)
         ENDDO
         DO I = ITIME, N
            J = 1 - ITIME + I
            IF(NOUT(3)) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,300) J, S(I)*BB(J)
                  WRITE (NF,300) J, S(I)*BB(J)
               ELSE
                  TEMP = S(I)*BB(J)
                  D13 = SHOWLJ(TEMP)
                  WRITE (LINE,350) J, D13
                  WRITE (NF,350) J, D13
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
            ENDIF
            FACT(2 + I) = S(I)
         ENDDO
      ELSEIF (ITYPE.EQ.3) THEN
C
C ITYPE = 3
C =========
C
         DO I = 1, M
            THEORY(I) = YVAL(I)/ERRY(I)
            TEMP = ONE/ERRY(I)
            A(I,1) = TEMP
            DO J = 1, ITIME
               TEMP = TEMP*XVAL(I)
               A(I,1 + J) = TEMP
               A(I,ITIME + 1 + J) = - YVAL(I)*TEMP
            ENDDO
         ENDDO
         CALL L1NORM (INDX, LW, M, N, NF, NMAX, NX,
     +                A, THEORY, E, F, S, W)
         DO I = 1, N
            J = I - 1
            K = J - ITIME
            IF (NOUT(3)) THEN
               IF (I.EQ.1) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,200) 0, S(1)*YT
                     WRITE (NF,200) 0, S(1)*YT
                  ELSE
                     TEMP = S(1)*YT
                     D13 = SHOWLJ(TEMP) 
                     WRITE (LINE,250) 0, D13
                     WRITE (NF,250) 0, D13 
                  ENDIF  
               ELSEIF (I.LE.ITIME + 1) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,200) J, S(I)*AA(J)
                     WRITE (NF,200) J, S(I)*AA(J)
                  ELSE
                     TEMP = S(I)*AA(J)
                     D13 = SHOWLJ(TEMP)
                     WRITE (LINE,250) J, D13
                     WRITE (NF,250) J, D13
                  ENDIF  
               ELSE
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,300) K, S(I)*BB(K)
                     WRITE (NF,300) K, S(I)*BB(K)
                  ELSE
                     TEMP = S(I)*BB(K)
                     D13 = SHOWLJ(TEMP) 
                     WRITE (LINE,350) K, D13
                     WRITE (NF,350) K, D13
                  ENDIF  
               ENDIF
               CALL TABLE1 (COLOUR, LINE)
            ENDIF
            FACT(I) = S(I)
         ENDDO
      ELSEIF (ITYPE.EQ.4) THEN
C
C ITYPE = 4
C =========
C
         DO I = 1, M
            THEORY(I) = YVAL(I)/ERRY(I)
            TEMP = ONE/ERRY(I)
            A(I,1) = TEMP
            DO J = 1, ITIME - 1
               TEMP = TEMP*XVAL(I)
               A(I,1 + J) = TEMP
               A(I,ITIME + J) = - YVAL(I)*TEMP
            ENDDO
            A(I,N) = - YVAL(I)*(XVAL(I)**ITIME)/ERRY(I)
         ENDDO
         CALL L1NORM (INDX, LW, M, N, NF, NMAX, NX,
     +                A, THEORY, E, F, S, W)
         DO I = 1, ITIME
            IF (NOUT(3)) THEN
               IF (I.EQ.1) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,200) 0, S(1)*YT
                     WRITE (NF,200) 0, S(1)*YT
                  ELSE
                     TEMP = S(1)*YT 
                     D13 = SHOWLJ(TEMP)
                     WRITE (LINE,250) 0, D13
                     WRITE (NF,250) 0, D13 
                  ENDIF  
               ELSE
                  J = I - 1
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,200) J, S(I)*AA(J)
                     WRITE (NF,200) J, S(I)*AA(J)
                  ELSE
                     TEMP = S(I)*AA(J)
                     D13 = SHOWLJ(TEMP)
                     WRITE (LINE,250) J, D13
                     WRITE (NF,250) J, D13 
                  ENDIF  
               ENDIF
               CALL TABLE1 (COLOUR, LINE)
            ENDIF
            FACT(I) = S(I)
         ENDDO
         DO I = ITIME + 1, N
            IF (NOUT(3)) THEN
               J = I - ITIME
               IF (E_NUMBERS) THEN
                  WRITE (LINE,300) J, S(I)*BB(J)
                  WRITE (NF,300) J, S(I)*BB(J)
               ELSE
                  TEMP = S(I)*BB(J)
                  D13 = SHOWLJ(TEMP) 
                  WRITE (LINE,350) J, D13
                  WRITE (NF,350) J, D13
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)   
            ENDIF
            FACT(1 + I) = S(I)
         ENDDO
      ENDIF
C
C Common action after calling E02GBF
C ==================================
C
      CALL FUNCT1 (NPAR(ITIME), X, FCN)
      IF (NOUT(3)) THEN
         IF (E_NUMBERS) THEN
            WRITE (LINE,400) DOFDOM*FCN
         ELSE
            TEMP = DOFDOM*FCN
            D13 = SHOWLJ(TEMP) 
            WRITE (LINE,450) D13
         ENDIF  
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
         COLOUR = 0
      ENDIF
      IF (E_NUMBERS) THEN
         WRITE (NF,400) DOFDOM*FCN
      ELSE
         TEMP = DOFDOM*FCN
         D13 = SHOWLJ(TEMP)
         WRITE (NF,450) D13
      ENDIF  
C
C Has E02GBF improved on random search
C
      IF (FCN.GT.TESTQ) THEN
         IF (NOUT(3)) THEN
            WRITE (LINE,500)
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
         WRITE (NF,500)
         DO I = 1, NPAR(ITIME)
            FACT(I) = STORES(I)
         ENDDO
      ELSE
         IF (NOUT(3)) THEN
            WRITE (LINE,600)
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
         WRITE (NF,600)
      ENDIF
      IF (NOUT(3)) CALL TABLE1 (COLOUR, 'CLOSE')
C
C Format statements
C        
  100 FORMAT (1X,'Over-determined L1-norm parameters')
  200 FORMAT (6X,'A(',I1,')',5X,1P,E13.5)
  250 FORMAT (6X,'A(',I1,')',5X,A13)
  300 FORMAT (6X,'B(',I1,')',5X,1P,E13.5)
  350 FORMAT (6X,'B(',I1,')',5X,A13)
  400 FORMAT (1X,'WSSQ from over-determined linear L1-norm fit =',
     +1P,E13.5)
  450 FORMAT (1X,'WSSQ from over-determined linear L1-norm fit =',
     +1X,A13)
  500 FORMAT (1X,'Starting estimates from random search')
  600 FORMAT (1X,'Starting estimates from over det. sys.')
      END
C
C-------------------------------------------------------------------
C
CFTN95$OPTIONS (SILENT)
      SUBROUTINE MONIT (N, X, NITER, K, EL1N)
C
C Monitor E02GBF if required ... DO NOTHING
C
      INTEGER K, N, NITER
      DOUBLE PRECISION EL1N, X(N)
      RETURN
      END
C
C
