C
C
C RFFIT3.FOR: include code for RFFIT
C ==========
C
C ORDER
C PARAMS
C RANDOM
C TESTQS
C VARCOV
C ZMOD
C
C
      SUBROUTINE ORDER (ITYPE, NF, NPTS,
     +                  A0, A1, AN, RTOL, XVAL, YVAL,
     +                  EQUAL, ISTOP)
C
C Estimate A0 = A(0), A1 = A(1), AN = A(N)/B(N) by linear regression
C to first/last sets of distinct data points
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ITYPE, NF, NPTS
      DOUBLE PRECISION, INTENT (IN)    :: RTOL, XVAL(NPTS), YVAL(NPTS)
      DOUBLE PRECISION, INTENT (OUT)   :: A0, A1, AN
      LOGICAL,          INTENT (IN)    :: EQUAL(NPTS)
      LOGICAL,          INTENT (INOUT) :: ISTOP
C
C locals
C      
      INTEGER    I, IFAIL, NBOT, NREP, NTOP, NTRY
      DOUBLE PRECISION XBOT(3), XTOP(3), YBOT(3), YTOP(3)
      DOUBLE PRECISION RESUL(20), RXBOT(3), RXTOP(3), RYBOT(3),
     +                 RYTOP(3)
      DOUBLE PRECISION YSUM
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   G02CAF$
      EXTERNAL   PUTIFA, PUTWAR, PUTFAT
      INTRINSIC  ABS, MAX
      NBOT = 0
      NTRY = 0
   10 CONTINUE
      NTRY = NTRY + 1
      IF (NTRY.GT.NPTS) GOTO 50
      NREP = 0
      YSUM = ZERO
      IF (ABS(XVAL(NTRY)).GT.RTOL) THEN
         NBOT = NBOT + 1
   20    CONTINUE
         NREP = NREP + 1
         YSUM = YSUM + YVAL(NTRY)
         IF (NTRY.EQ.NPTS) THEN
            XBOT(NBOT) = XVAL(NPTS)
            YBOT(NBOT) = YSUM/NREP
         ELSEIF (EQUAL(NTRY + 1)) THEN
            NTRY = NTRY + 1
            GOTO 20
         ELSE
            XBOT(NBOT) = XVAL(NTRY)
            YBOT(NBOT) = YSUM/NREP
         ENDIF
      ELSE
         GOTO 10
      ENDIF
      IF (ABS(YBOT(NBOT)).LT.RTOL) THEN
         NBOT = NBOT - 1
         GOTO 10
      ENDIF
      IF (NBOT.LT.3) GOTO 10
      NTOP = 0
      NTRY = NPTS + 1
   30 CONTINUE
      NTRY = NTRY - 1
      IF (NTRY.LT.1) GOTO 50
      NREP = 0
      YSUM = ZERO
      IF (ABS(XVAL(NTRY)).GT.RTOL) THEN
         NTOP = NTOP + 1
  40     CONTINUE
         NREP = NREP + 1
         YSUM = YSUM + YVAL(NTRY)
         IF (NTRY.EQ.1) THEN
            XTOP(NTOP) = XVAL(1)
            YTOP(NTOP) = YSUM/NREP
         ELSEIF (NTRY.EQ.NPTS) THEN
            IF (EQUAL(NPTS)) THEN
               NTRY = NTRY - 1
               GOTO 40
            ELSE
               XTOP(NTOP) = XVAL(NPTS)
               YTOP(NTOP) = YSUM/NREP
            ENDIF
         ELSEIF (EQUAL(NTRY)) THEN
            NTRY = NTRY - 1
            GOTO 40
         ELSE
            XTOP(NTOP) = XVAL(NTRY)
            YTOP(NTOP) = YSUM/NREP
         ENDIF
      ELSE
         GOTO 30
      ENDIF
      IF (ABS(YTOP(NTOP)).LT.RTOL) THEN
         NTOP = NTOP - 1
         GOTO 30
      ENDIF
      IF (NTOP.LT.3) GOTO 30
      NTOP = 3
      DO I = 1, NTOP
         RXBOT(I) = ONE/XBOT(I)
         RXTOP(I) = ONE/XTOP(I)
         RYBOT(I) = ONE/YBOT(I)
         RYTOP(I) = ONE/YTOP(I)
      ENDDO
      IFAIL = 1
      IF (ITYPE.EQ.1) THEN
         A0 = ZERO
         CALL G02CAF$(NTOP, RXBOT, RYBOT, RESUL, IFAIL)
         IF (RESUL(6).LT.ZERO) ISTOP = .TRUE.
         A1 = ONE/MAX(RTOL, ABS(RESUL(6)))
         CALL G02CAF$(NTOP, RXTOP, RYTOP, RESUL, IFAIL)
         IF (RESUL(7).LT.ZERO) ISTOP = .TRUE.
         AN = ONE/MAX(RTOL, ABS(RESUL(7)))
      ELSEIF (ITYPE.EQ.2) THEN
         A0 = ZERO
         CALL G02CAF$(NTOP, RXBOT, RYBOT, RESUL, IFAIL)
         IF (RESUL(6).LT.ZERO) ISTOP = .TRUE.
         A1 = ONE/MAX(RTOL, ABS(RESUL(6)))
         AN = ZERO
      ELSEIF (ITYPE.EQ.3) THEN
         CALL G02CAF$(NTOP, XBOT, YBOT, RESUL, IFAIL)
         IF (RESUL(7).LT.ZERO) ISTOP = .TRUE.
         A0 = ABS(RESUL(7))
         A1 = ONE
         CALL G02CAF$(NTOP, RXTOP, RYTOP, RESUL, IFAIL)
         IF (RESUL(7).LT.ZERO) ISTOP = .TRUE.
         AN = ONE/MAX(RTOL, ABS(RESUL(7)))
      ELSE
         CALL G02CAF$(NTOP, XBOT, YBOT, RESUL, IFAIL)
         IF (RESUL(7).LT.ZERO) ISTOP = .TRUE.
         A0 = ABS(RESUL(7))
         A1 = ONE
         AN = ZERO
      ENDIF
      CALL PUTIFA (IFAIL, NF, 'G02CAF/ORDER')
      IF (ISTOP) THEN
         CALL PUTWAR ('A0, A1 or AN < 0 so sign reversed')
         ISTOP = .FALSE.
      ENDIF
      RETURN
   50 CONTINUE
      CALL PUTFAT ('Must have 3 distinct nonzero X,Y-values')
      ISTOP = .TRUE.
      END
C
C-------------------------------------------------------------------
C
      SUBROUTINE PARAMS (ISTATE, M, MFAST, N, NF, NRAND,
     +                   AA, BB, FACT, X, YT,
     +                   NOUT)
C
C Input/output starting estimates before curve-fitting
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: M, MFAST, N, NF, NRAND
      INTEGER,          INTENT (IN)    :: ISTATE(N)
      DOUBLE PRECISION, INTENT (IN)    :: AA(M), BB(M), X(N), YT
      DOUBLE PRECISION, INTENT (INOUT) :: FACT(N)
      LOGICAL,          INTENT (IN)    :: NOUT
C
C Locals
C      
      INTEGER    I
      INTEGER    COLOUR
      DOUBLE PRECISION ONE, FMAX, FMIN, PAR(20)
      PARAMETER (ONE = 1.0D+00, FMAX = 1.0D+07, FMIN = 1.0D-07)
      CHARACTER (LEN = 13) D13(2), SHOWRJ
      CHARACTER  A*1, B*1, LINE*80
      PARAMETER (A = 'A', B = 'B')
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   GETDM1, TABLE1
      E_NUMBERS = E_FORMATS()
      IF (NRAND.EQ.4) THEN    
         DO I = 1, N
            PAR(I) = ONE
            IF (I.EQ.1) THEN
               IF (ISTATE(1).GT.0) THEN
                  FACT(1) = PAR(1)/YT
               ENDIF
            ELSEIF (I.LE.MFAST) THEN
               IF (ISTATE(I).GT.0) THEN
                  FACT(I) = PAR(I)/AA(I - 1)
               ENDIF
            ELSE
               FACT(I) = PAR(I)/BB(I - MFAST)
             ENDIF
         ENDDO   
      ELSEIF (NRAND.EQ.5) THEN
         DO I = 1, N
            PAR(I) = ONE
            IF (I.EQ.1) THEN
               IF (ISTATE(1).GT.0) THEN
                  WRITE (LINE,100) A, 0
                  CALL GETDM1 (FMIN, PAR(1), FMAX, LINE)
                  FACT(1) = PAR(1)/YT
               ENDIF
            ELSEIF (I.LE.MFAST) THEN
               IF (ISTATE(I).GT.0) THEN
                  WRITE (LINE,100) A, I - 1
                  CALL GETDM1 (FMIN, PAR(I), FMAX, LINE)
                  FACT(I) = PAR(I)/AA(I - 1)
               ENDIF
            ELSE
               WRITE (LINE,100) B, I - MFAST
               CALL GETDM1 (FMIN, PAR(I), FMAX, LINE)
               FACT(I) = PAR(I)/BB(I - MFAST)
             ENDIF
         ENDDO
      ENDIF
      
      DO I = 1, N
         IF (I.EQ.1) THEN
            PAR(1) = FACT(1)*X(1)*YT
         ELSEIF (I.LE.MFAST) THEN
            PAR(I) = FACT(I)*X(I)*AA(I - 1)
         ELSE
            PAR(I) = FACT(I)*X(I)*BB(I - MFAST)
         ENDIF
      ENDDO
      
      WRITE (NF,200)
      WRITE (NF,300)
      DO I = 1, N
         IF (I.LE.MFAST) THEN
            IF (E_NUMBERS) THEN
               WRITE (NF,400) A, I - 1, PAR(I), FACT(I)
            ELSE
               D13(1) = SHOWRJ(PAR(I))
               D13(2) = SHOWRJ(FACT(I))  
               WRITE (NF,450) A, I - 1, D13(1), D13(2) 
            ENDIF  
         ELSE
            IF (E_NUMBERS) THEN
               WRITE (NF,400) B, I - MFAST, PAR(I), FACT(I)
            ELSE
               D13(1) = SHOWRJ(PAR(I))
               D13(2) = SHOWRJ(FACT(I))   
               WRITE (NF,450) B, I - MFAST, D13(1), D13(2)
            ENDIF  
         ENDIF
      ENDDO
      
      IF (NOUT) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         WRITE (LINE,200)
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
         WRITE (LINE,300)
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
         COLOUR = 0
         DO I = 1, N
            IF (I.LE.MFAST) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,400) A, I - 1, PAR(I), FACT(I)
               ELSE
                  D13(1) = SHOWRJ(PAR(I))
                  D13(2) = SHOWRJ(FACT(I))
                  WRITE (LINE,450) A, I - 1, D13(1), D13(2)
               ENDIF  
            ELSE
               IF (E_NUMBERS) THEN 
                  WRITE (LINE,400) B, I - MFAST, PAR(I), FACT(I)
               ELSE
                  D13(1) = SHOWRJ(PAR(I))
                  D13(2) = SHOWRJ(FACT(I)) 
                  WRITE (LINE,450) B, I - MFAST, D13(1), D13(2)
               ENDIF  
            ENDIF
            CALL TABLE1 (COLOUR, LINE)
         ENDDO
         CALL TABLE1 (COLOUR, 'CLOSE')
      ENDIF
C
C Format statements
C      
  100 FORMAT (1X,'Starting estimate for',1X,A1,'(',I1,')')
  200 FORMAT (1X,'Parameter Starting Estimates')
  300 FORMAT (7X,'    External      Internal')
  400 FORMAT (1X,A1,'(',I1,')',1P,2(1X,E13.5))
  450 FORMAT (1X,A1,'(',I1,')',2(1X,A13))
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE RANDOM (ISTATE, ITIME, ITYPE, KFAST, MAXNUM, MFAST,
     +                   NBIG, NDOF, NF, NN, NPAR, NPTS, NRAND, NSMALL,
     +                   NUMBER, NX,
     +                   A0, A1, AN, DOFDOM, FACT, SIGMA, STORES,
     +                   TESTQ, X,
     +                   ANIN, A0IN, ISTOP, NOUT)
C
C Random search for starting estimates for scaling factors
C 12/03/2015 added a preliminary search and replaced G05DDF$ by RANNUM
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NN, NX
      INTEGER,          INTENT (IN)    :: ITIME, ITYPE, NF, NPTS, NRAND
      INTEGER,          INTENT (INOUT) :: NPAR(NN), NUMBER(NN)
      INTEGER,          INTENT (OUT)   :: ISTATE(NX), KFAST, MFAST, NDOF
      INTEGER,          INTENT (IN)    :: MAXNUM, NBIG,  NSMALL
      DOUBLE PRECISION, INTENT (IN)    :: A0, A1, AN, SIGMA 
      DOUBLE PRECISION, INTENT (OUT)   :: DOFDOM, FACT(NX), STORES(NX),
     +                                    TESTQ, X(NX)
      LOGICAL,          INTENT (IN)    :: ANIN, A0IN, NOUT(9)
      LOGICAL,          INTENT (INOUT) :: ISTOP
C
C Locals
C     
      INTEGER    I, J, K, L, LFAST, NFAST, NLOOPS
      INTEGER    COLOUR
      DOUBLE PRECISION PNT25, ZERO, ONE, TWO, TEN
      PARAMETER (PNT25 = 0.25D+00, ZERO = 0.0D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION B1, F, STDEV
      DOUBLE PRECISION RANNUM
      CHARACTER  LINE*100
      LOGICAL    CASE1
      EXTERNAL   RANNUM
      EXTERNAL   PUTFAT, TABLE1
      EXTERNAL   FUNCT1, TESTQS
      IF (ISTOP) RETURN
      IF (ITIME.EQ.1 .AND. ITYPE.EQ.2) THEN
         CALL PUTFAT ('Zero function requested')
         ISTOP = .TRUE.
         RETURN
      ENDIF
C
C Set NPAR, MFAST, NUMBER etc. then NDOF and DOFDOM
C
      NPAR(ITIME) = 2*ITIME + 1
      KFAST = ITIME + 2
      MFAST = ITIME + 1
      NFAST = NPAR(ITIME)
      LFAST = NFAST - 1
      NUMBER(ITIME) = NPAR(ITIME) - 2
      IF (A0IN) NUMBER(ITIME) = NUMBER(ITIME) + 1
      IF (ANIN) NUMBER(ITIME) = NUMBER(ITIME) + 1
      NDOF = NPTS - NUMBER(ITIME)
      DOFDOM = NDOF
      IF (DOFDOM.LE.ZERO) THEN
         CALL PUTFAT ('Insufficient data ... Analysis terminated')
         ISTOP = .TRUE.
         RETURN
      ENDIF
C
C No random search if NRAND >= 4
C
      IF (NRAND.GE.4) RETURN
C
C Display if required
C
      IF (NOUT(3)) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         COLOUR = 4
      ENDIF
C
C Starting values
C
      DO I = 1, NFAST
         ISTATE(I) = 1
         FACT(I) = ONE
         STORES(I) = ONE
          X(I) = ONE
      ENDDO
      IF (A0IN) THEN
         FACT(1) = A0
      ELSE
         ISTATE(1) = 0
         X(1) = ZERO
      ENDIF
      FACT(2) = A1
      IF (ANIN) THEN
         FACT(MFAST) = AN
      ELSE
         ISTATE(MFAST) = 0
         X(MFAST) = ZERO
      ENDIF
      CASE1 = .FALSE.
C
C 1:1
C
      IF (ITIME.EQ.1) THEN
         IF (ANIN) THEN
            CASE1 = .TRUE.
            B1 = A1/AN
            FACT(2) = A1
            FACT(3) = B1
          ELSE
            FACT(2) = ONE
         ENDIF
      ENDIF
      CALL FUNCT1 (NFAST,
     +             X, F)
      L = 1
      CALL TESTQS (L, ITIME, NF, NN, NPAR, NX,
     +             DOFDOM, F, FACT, STORES, TESTQ,
     +             NOUT)
      NLOOPS = NBIG*(2**NUMBER(ITIME))
      IF (NLOOPS.GT.MAXNUM) NLOOPS = MAXNUM
      
C
C Preliminary global search from a fixed point
C
      STDEV = SIGMA
      DO I = 1, NSMALL
         STDEV = TWO*STDEV
         DO J = 1, NLOOPS
            IF (A0IN) THEN
               FACT(1) = TEN**RANNUM(ZERO, PNT25)
               FACT(2) = TEN**RANNUM(ZERO, STDEV)
            ELSE
               FACT(2) = TEN**RANNUM(ZERO, PNT25)
            ENDIF
            IF (CASE1) THEN
               FACT(3) = TEN**RANNUM(ZERO, PNT25)
            ELSE
               DO K = 3, ITIME
                  FACT(K) = TEN**RANNUM(ZERO, STDEV)
               ENDDO
               DO K = KFAST, LFAST
                  FACT(K) = TEN**RANNUM(ZERO, STDEV)
               ENDDO
               IF (ANIN) THEN
                  FACT(MFAST) = TEN**RANNUM(ZERO, STDEV)
                  FACT(NFAST) = TEN**RANNUM(ZERO, PNT25)
               ELSE
                  FACT(NFAST) = TEN**RANNUM(ZERO, STDEV)
               ENDIF
            ENDIF
            CALL FUNCT1 (NFAST, X, F)
            L = 2
            CALL TESTQS (L, ITIME, NF, NN, NPAR, NX,
     +                   DOFDOM, F, FACT, STORES, TESTQ,
     +                   NOUT)
         ENDDO
         IF (NOUT(3)) THEN
            WRITE (LINE,100) I, STDEV
            CALL TABLE1 (COLOUR, LINE)
            WRITE (NF,100) I, STDEV
         ENDIF
      ENDDO
      
C
C Constrained global search from a fixed point
C
      STDEV = SIGMA
      DO I = 1, NSMALL
         STDEV = TWO*STDEV
         DO J = 1, NLOOPS
            IF (A0IN) THEN
               FACT(1) = A0*(TEN**RANNUM(ZERO, PNT25))
               FACT(2) =     TEN**RANNUM(ZERO, STDEV)
            ELSE
               FACT(2) = A1*(TEN**RANNUM(ZERO, PNT25))
            ENDIF
            IF (CASE1) THEN
               FACT(3) = B1*(TEN**RANNUM(ZERO, PNT25))
            ELSE
               DO K = 3, ITIME
                  FACT(K) = TEN**RANNUM(ZERO, STDEV)
               ENDDO
               DO K = KFAST, LFAST
                  FACT(K) = TEN**RANNUM(ZERO, STDEV)
               ENDDO
               IF (ANIN) THEN
                  FACT(MFAST) = TEN**RANNUM(ZERO, STDEV)
                  FACT(NFAST) = (FACT(MFAST)/AN)*
     +                           TEN**RANNUM(ZERO, PNT25)
               ELSE
                  FACT(NFAST) = TEN**RANNUM(ZERO, STDEV)
               ENDIF
            ENDIF
            CALL FUNCT1 (NFAST, X, F)
            L = 2
            CALL TESTQS (L, ITIME, NF, NN, NPAR, NX,
     +                   DOFDOM, F, FACT, STORES, TESTQ,
     +                   NOUT)
         ENDDO
         IF (NOUT(3)) THEN
            WRITE (LINE,200) I, STDEV
            CALL TABLE1 (COLOUR, LINE)
            WRITE (NF,100) I, STDEV
         ENDIF
      ENDDO
C
C Local intelligent search from a moving centre
C
      DO I = 1, NLOOPS
         DO J = 1, NFAST
            IF (ISTATE(J).GT.0) THEN
               FACT(J) = STORES(J)*(TEN**RANNUM(ZERO, PNT25))
            ENDIF
         ENDDO
         CALL FUNCT1 (NFAST,
     +                X, F)
         L = 2
         CALL TESTQS (L, ITIME, NF, NN, NPAR, NX,
     +                DOFDOM, F, FACT, STORES, TESTQ,
     +                NOUT)
      ENDDO
      IF (NOUT(3)) THEN
         WRITE (LINE,300) PNT25
         CALL TABLE1 (COLOUR, LINE)
         WRITE (NF,300) PNT25
      ENDIF
      L = 3
      CALL TESTQS (L, ITIME, NF, NN, NPAR, NX,
     +             DOFDOM, F, FACT, STORES, TESTQ,
     +             NOUT)
C
C Format statments
C   
  100 FORMAT (1X,'Preliminary search',I3,1X,
     +'finished (N(0,sigma^2) with sigma =',F6.3,')')  
  200 FORMAT (1X,'Constrained search',I3,1X,
     +'finished (N(0,sigma^2) with sigma =',F6.3,')')
  300 FORMAT (1X,'Local search over (N(0,sigma^2) with sigma =',
     +        F6.3,')')
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE TESTQS (ISEND, ITIME, NF, NN, NPAR, NX,
     +                   DOFDOM, F, FACT, STORES, TESTQ,
     +                   NOUT)
C
C Examine WSSQ for improvement and store best-fit factors
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NN, NX
      INTEGER,          INTENT (IN)    :: ISEND, ITIME, NF, NPAR(NN)
      DOUBLE PRECISION, INTENT (IN)    :: DOFDOM
      DOUBLE PRECISION, INTENT (INOUT) :: F, FACT(NX), STORES(NX), TESTQ
      LOGICAL,          INTENT (IN)    :: NOUT(9)
C
C Locals
C      
      INTEGER    I, ICOUNT, J, JCOUNT
      INTEGER    COLOUR
      DOUBLE PRECISION QSAVE, TEMP
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER (LEN = 13) D13(2), SHOWLJ
      CHARACTER (LEN = 12) FORM12, WORD12(2)
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   TABLE1
      INTRINSIC  TRIM
      SAVE       ICOUNT, JCOUNT, QSAVE
      E_NUMBERS = E_FORMATS()
      IF (ISEND.EQ.1) THEN
         ICOUNT = 0
         JCOUNT = 0
         QSAVE  = DOFDOM*F
         IF (NOUT(3)) THEN
            WRITE (LINE,100) ITIME, ITIME
            COLOUR = 4
            CALL TABLE1 (COLOUR, LINE)
            WRITE (NF,100) ITIME, ITIME
         ENDIF
      ELSEIF (ISEND.EQ.2) THEN
         ICOUNT = ICOUNT + 1
         IF (F.GE.TESTQ) RETURN
         JCOUNT = JCOUNT + 1
      ENDIF
      IF (ISEND.EQ.1 .OR. ISEND.EQ.2) THEN
         TESTQ = F
         IF (NOUT(3)) THEN
            IF (E_NUMBERS) THEN
               WRITE (LINE,200) ICOUNT, DOFDOM*F
               WRITE (NF,200) ICOUNT, DOFDOM*F
            ELSE
               TEMP = DOFDOM*F
               D13(1) = SHOWLJ(TEMP)
               WRITE (LINE,250) ICOUNT, D13(1)
               WRITE (NF,250) ICOUNT, D13(1)
            ENDIF  
            COLOUR = 0
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
         DO J = 1, NPAR(ITIME)
            STORES(J) = FACT(J)
         ENDDO
         RETURN
      ENDIF
      IF (NOUT(3)) THEN
         WORD12(1) = FORM12(ICOUNT)
         WORD12(2) = FORM12(JCOUNT)
         IF (E_NUMBERS) THEN
            WRITE (TEXT,300) ITIME, ITIME, TRIM(WORD12(1)),
     +                       TRIM(WORD12(2)), QSAVE,  DOFDOM*TESTQ
         ELSE
            D13(1) = SHOWLJ(QSAVE)
            TEMP = DOFDOM*TESTQ
            D13(2) = SHOWLJ(TEMP)
            WRITE (TEXT,350) ITIME, ITIME, TRIM(WORD12(1)), 
     +                       TRIM(WORD12(2)), D13(1), D13(2)
         ENDIF  
         DO I = 1, 5
            IF (I.LE.2) THEN
               COLOUR = 4
            ELSE
               COLOUR = 0
            ENDIF
            LINE = TEXT(I)
            CALL TABLE1 (COLOUR, LINE)
         ENDDO
         CALL TABLE1 (COLOUR, 'CLOSE')
         WORD12(1) = FORM12(ICOUNT)
         WORD12(2) = FORM12(JCOUNT)
         IF (E_NUMBERS) THEN
            WRITE (NF,300) ITIME, ITIME, TRIM(WORD12(1)),
     +                     TRIM(WORD12(2)), QSAVE, DOFDOM*TESTQ
         ELSE
            D13(1) = SHOWLJ(QSAVE)
            TEMP = DOFDOM*TESTQ
            D13(2) = SHOWLJ(TEMP) 
            WRITE (NF,350) ITIME, ITIME, TRIM(WORD12(1)),
     +                     TRIM(WORD12(2)), D13(1), D13(2)
         ENDIF  
      ENDIF
C
C Format statements
C      
  100 FORMAT (1X,'Iteration',4X,'WSSQ (',I1,':',I1,')')
  200 FORMAT (1X,I8,4X,1P,E13.5)
  250 FORMAT (1X,I8,4X,A13)
  300 FORMAT (/1X,'For random',I2,':',I1,1X,'search'
     +/1X,'Number of improvements in',1X,A,1X,'cycles =',1X,A
     +/1X,'WSSQ before search =',1P,E13.5
     +/1X,'WSSQ after  search =',   E13.5/)
  350 FORMAT (/1X,'For random',I2,':',I1,1X,'search'
     +/1X,'Number of improvements in',1X,A,1X,'cycles =',1X,A
     +/1X,'WSSQ before search =',1X,A13
     +/1X,'WSSQ after  search =',1X,A13/)   
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE ZMOD (P)
C
C Rational function with A(0) and A(N) if required
C

      USE MODULE_RFFIT, ONLY : ITIME, KFAST, FACT, MFAST, EQUAL, XVAL,
     +                         NPTS, THEORY

      IMPLICIT   NONE
C
C Argument
C      
      DOUBLE PRECISION, INTENT (IN) :: P(*)
C
C Locals
C      
      INTEGER    NN
      PARAMETER (NN = 6)
      INTEGER    I, J, K
      DOUBLE PRECISION A(NN + 1), B(NN + 1), C(NN + 1), D(NN + 1)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      DO I = 1, ITIME
         J = KFAST - I
         K = ITIME + J
         A(I) = FACT(J)*P(J)
         C(I) = FACT(K)*P(K)
      ENDDO
      A(MFAST) = FACT(1)*P(1)
      C(MFAST) = ONE
      B(1) = A(1)
      D(1) = C(1)
      DO I = 1, NPTS
         IF (EQUAL(I)) THEN
            THEORY(I) = THEORY(I - 1)
         ELSE
            DO J = 2, MFAST
               B(J) = B(J - 1)*XVAL(I) + A(J)
               D(J) = D(J - 1)*XVAL(I) + C(J)
            ENDDO
            THEORY(I) = B(MFAST)/D(MFAST)
         ENDIF
      ENDDO
      END
C
C
      DOUBLE PRECISION FUNCTION RANNUM (A, B)
C
C Normal variable truncated at limits
C      
      IMPLICIT NONE
      DOUBLE PRECISION, INTENT (IN) :: A, B
      DOUBLE PRECISION  BOT, TOP
      DOUBLE PRECISION  FACTOR
      PARAMETER (FACTOR = 3.0D+00) 
      DOUBLE PRECISION  G05DDF$, VALUE
      EXTERNAL G05DDF$
      VALUE = FACTOR*B
      BOT = A - VALUE
      TOP = A + VALUE
      VALUE = G05DDF$(A, B)
      DO WHILE (VALUE.LT.BOT .OR. VALUE.GT.TOP)
         VALUE = G05DDF$(A, B)
      ENDDO
      RANNUM = VALUE
      END
C
C         