C
C RSTEST: MAIN, ADVISE, CHOOSE
C =======
C
C     INCLUDE 'dllchk.for'
      PROGRAM MAIN
C
C VERSION: details from SIMVER/DLLCHK
C ACTION : Nonparametric statistics
C AUTHOR : W. G. Bardsley, 14/07/1989
C REVISED: 21/12/1989 OFILES and option for G01BDF
C          08/01/1990 Added BINOMP
C          05/03/1993 GET???, PUT??? and compressed
C          16/06/1993 RESFIL
C          13/09/1994 DBOS version
C          01/12/1994 started to add nonparametrics and graphics
C          03/12/1994 used NX, NY, NZ to store data for re-use
C          08/03/1995 Added Spearman/Kendall-tau Np correlation
C          15/11/1995 upgraded for nag mark 16
C          09/05/1996 corrected sigma/sigma^2 mistake in KS1SAM
C          22/05/1995 altered UPDOWN to protect with small samples
C          14/12/1996 Changed dimension of IWRK and put NPCORR in DLL
C          16/12/1996 Added ANOVA0 and VECTST
C          22/12/1996 Transferred VECONE, VECTWO, KS2SAM to SIMFIT.LIB
C                     and removed CDFOUT, CDFVAL, KS1SAM
C          26/04/1997 win32 version
C          07/08/1998 added dllchk
C          14/12/1998 replaced TUTORS by TUTOR1
C          12/08/1999 increased dimension for NPCORR and added NCOL and
C                     NROW set to zero to force new data each time
C          13/09/1999 added calls to WINDOW
C          14/02/2000 added SIMVER
C          18/04/2002 corrected argument list to NPCORR
C          22/09/2003 new array D and new argument list for ANOVA0
C          22/04/2004 added WSRTST
C          03/03/2005 reworked CHOOSE, moved UPDOWN to DLL, added more calls
C          11/04/2005 replaced ANOVA0 by ANOVA1 and ANOVA2
C          02/08/2005 increased DVER to *30 and added to call to ADVISE
C          18/11/2005 added call to REGRAN which needed new workspaces
C          10/01/2003 deleted E and removed C and D in call to ANOVA2, also
C                     deleted B and CORR and new argument list for NPCORR
C          12/02/2006 new arguments for COCHRQ
C          03/03/2006 new arguments for NPCORR
C          27/03/2006 new arguments for ANOVA1 and ANOVA2 
C          24/07/2006 new call to REGRAN
C          20/08/2007 edited for Version 6 ... now uses calls to m_* routines
C
      IMPLICIT   NONE
C
C Integer parameters
C      
      INTEGER    NIN, NOUT, NMAX, NSMALL, NWMAX, N1
      PARAMETER (NIN = 3, NOUT = 4, NMAX = 10000,
     +           NSMALL = 100, NWMAX = 5*NMAX, N1 = 1)
      INTEGER    N_MATRIX, N_VECTOR, N_DOUBLE
      PARAMETER (N_MATRIX = 6, N_VECTOR = 3, N_DOUBLE = 5)
      INTEGER    M, NCOL, NROW, NX, NY, NW, NZ
C
C Integers
C      
      INTEGER    ISEND, JSEND, KSEND
C
C Integer arrays
C      
      INTEGER    IWRK(4*NMAX + 2)
      INTEGER    NCOL_MATRIX(N_MATRIX), NROW_MATRIX(N_MATRIX),
     +           NROW_VECTOR(N_VECTOR),
     +           NROW_VECTX(N_DOUBLE), NROW_VECTY(N_DOUBLE)
C
C Double precision
C     
      DOUBLE PRECISION XVER, YVER
C
C Double precision arrays
C      
      DOUBLE PRECISION V(2*NMAX), W(NWMAX), W1(NWMAX), W2(NWMAX)
C
C Character parameters
C      
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_rstest.exe')
      CHARACTER  BLANK*1, NODATA*10, PNAME*6
      PARAMETER (BLANK = ' ', NODATA = 'No Data', PNAME = 'RSTEST')
C
C Characters
C      
      CHARACTER  FNAME*1024, FNAMEA*1024, FNAMEX*1024, FNAMEY*1024,
     +           FNAMEZ*1024
      CHARACTER  TITLE*80, TITLEA*80, TITLEX*80, TITLEY*80, TITLEZ*80
C
C Character arrays
C     
      CHARACTER  FSAV(NSMALL)*1024, TSAV(NSMALL)*80
      CHARACTER  FNAME_MATRIX(N_MATRIX)*1024, TITLE_MATRIX(N_MATRIX)*80
      CHARACTER  FNAME_VECTOR(N_VECTOR)*1024, TITLE_VECTOR(N_VECTOR)*80
      CHARACTER  FNAME_VECTX(N_DOUBLE)*1024, TITLE_VECTX(N_DOUBLE)*80,
     +           FNAME_VECTY(N_DOUBLE)*1024, TITLE_VECTY(N_DOUBLE)*80
C
C Logical parameters
C
      LOGICAL    SUPPLY_MATRIX
      PARAMETER (SUPPLY_MATRIX = .TRUE.)
C
C Logicals
C      
      LOGICAL    ABORT, ACTION, AGAIN, FIRST, SHOW
C
C Externals
C     
      EXTERNAL   RESFIL, FNAMES, VECTST, REVPRO
      EXTERNAL   ADVISE, BINOMP, CHOOSE, RUNSIN
      EXTERNAL   M_MVSTAT, M_ANOVA1, M_ANOVAM, M_MATONE, M_VECONE,
     +           M_VECTWO
      EXTERNAL   DLLCHK, WINDOW, SIMVER
C
C Data
C      
      SAVE       NCOL_MATRIX, NROW_MATRIX, NROW_VECTOR,
     +           NROW_VECTX, NROW_VECTY, 
     +           FNAME_MATRIX, TITLE_MATRIX,
     +           FNAME_VECTOR, TITLE_VECTOR,
     +           FNAME_VECTX, TITLE_VECTX,
     +           FNAME_VECTY, TITLE_VECTY  
      DATA       NCOL_MATRIX / N_MATRIX*0 /
      DATA       NROW_MATRIX / N_MATRIX*0 /
      DATA       NROW_VECTOR / N_VECTOR*0 /
      DATA       NROW_VECTX / N_DOUBLE*0 /
      DATA       NROW_VECTY / N_DOUBLE*0 /   
      DATA       FNAME_MATRIX / N_MATRIX*BLANK /
      DATA       TITLE_MATRIX / N_MATRIX*BLANK /
      DATA       FNAME_VECTOR / N_VECTOR*BLANK /
      DATA       TITLE_VECTOR / N_VECTOR*BLANK /
      DATA       FNAME_VECTX / N_DOUBLE*BLANK /
      DATA       TITLE_VECTX / N_DOUBLE*BLANK /
      DATA       FNAME_VECTY / N_DOUBLE*BLANK /
      DATA       TITLE_VECTY / N_DOUBLE*BLANK /
C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C Note ISEND = 2 since may be called from SIMSTAT which has already
C called WINDOW with ISEND = 1 (This Advice is not valid at Version 6)
C
      ISEND = 2
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND, 
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

      FIRST = .TRUE.
      CALL ADVISE (DVER,
     +             ABORT, FIRST)
      IF (ABORT) THEN
         AGAIN = .FALSE.
      ELSE
         NCOL = - 1
         NROW = - 1
         NX = - 1
         NY = - 1
         NW = - 1
         NZ = - 1
         FNAME = BLANK
         FNAMEA = BLANK
         FNAMEX = BLANK
         FNAMEY = BLANK
         FNAMEZ = BLANK
         TITLEA = NODATA
         TITLEX = NODATA
         TITLEY = NODATA
         TITLEZ = NODATA
C
C Note: FNAME must not be re-defined after exit from RESFIL
C
         CALL RESFIL (NOUT, 
     +                FNAME,
     +                ABORT)
         IF (ABORT) THEN
            AGAIN = .FALSE.
         ELSE
            AGAIN = .TRUE.
            WRITE (NOUT,100)
            ISEND = 18
         ENDIF
      ENDIF
      DO WHILE (AGAIN)
C
C Get the users decision
C
         CALL CHOOSE (ISEND)
         IF (ISEND.EQ.1) THEN
C
C ISEND = 1: Sign test
C
            CALL BINOMP (NOUT)
         ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: Runs on +ves/-ves
C
            JSEND = 2
            NX = N1
            NY = N1
            NZ = N1
            CALL RUNSIN (JSEND, NIN, N1, NOUT, NX, NY, NW,
     +                   V, W, W1,
     +                   TITLEX, TITLEY, TITLEZ)
         ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3: Runs on residuals [VECTOR = 1]
C
            M = 1
            FNAMEZ = FNAME_VECTOR(M)
            TITLEZ = TITLE_VECTOR(M)
            NZ = NROW_VECTOR(M)
            JSEND = 13
            CALL M_VECONE (JSEND, NIN, NOUT, NZ,
     +                     FNAMEZ, TITLEZ)
            FNAME_VECTOR(M) = FNAMEZ
            TITLE_VECTOR(M) = TITLEZ
            NROW_VECTOR(M) = NZ
         ELSEIF (ISEND.EQ.4) THEN
C
C ISEND = 4: Runs on paired samples [DOUBLE = 1]
C
            M = 1 
            NX = NROW_VECTX(M)
            NY = NROW_VECTY(M)
            FNAMEX = FNAME_VECTX(M)
            FNAMEY = FNAME_VECTY(M)
            TITLEX = TITLE_VECTX(M)
            TITLEY = TITLE_VECTY(M)
            JSEND = 8
            CALL M_VECTWO (JSEND, NIN, NOUT, NX, NY,
     +                     FNAMEX, FNAMEY, TITLEX, TITLEY)
            NROW_VECTX(M) = NX
            NROW_VECTY(M) = NY
            FNAME_VECTX(M) = FNAMEX             
            FNAME_VECTY(M) = FNAMEY
            TITLE_VECTX(M) = TITLEX
            TITLE_VECTY(M) = TITLEY  
         ELSEIF (ISEND.EQ.5) THEN
C
C ISEND = 5: Runs up and down [VECTOR = 2]
C
            M = 2
            FNAMEZ = FNAME_VECTOR(M)
            TITLEZ = TITLE_VECTOR(M)
            NZ = NROW_VECTOR(M)
            JSEND = 14
            CALL M_VECONE (JSEND, NIN, NOUT, NZ,
     +                     FNAMEZ, TITLEZ)
            FNAME_VECTOR(M) = FNAMEZ
            TITLE_VECTOR(M) = TITLEZ
            NROW_VECTOR(M) = NZ 
         ELSEIF (ISEND.EQ.6) THEN
C
C ISEND = 6: KS 1-sample [VECTOR = 3]
C
            
            M = 3
            FNAMEZ = FNAME_VECTOR(M)
            TITLEZ = TITLE_VECTOR(M)
            NZ = NROW_VECTOR(M)
            JSEND = 3
            CALL M_VECONE (JSEND, NIN, NOUT, NZ,
     +                     FNAMEZ, TITLEZ)
            FNAME_VECTOR(M) = FNAMEZ
            TITLE_VECTOR(M) = TITLEZ
            NROW_VECTOR(M) = NZ 
         ELSEIF (ISEND.EQ.7) THEN
C
C ISEND = 7: KS 2-sample [DOUBLE = 2]
C
            M = 2 
            NX = NROW_VECTX(M)
            NY = NROW_VECTY(M)
            FNAMEX = FNAME_VECTX(M)
            FNAMEY = FNAME_VECTY(M)
            TITLEX = TITLE_VECTX(M)
            TITLEY = TITLE_VECTY(M)
            JSEND = 4
            CALL M_VECTWO (JSEND, NIN, NOUT, NX, NY,
     +                     FNAMEX, FNAMEY, TITLEX, TITLEY)
            NROW_VECTX(M) = NX
            NROW_VECTY(M) = NY
            FNAME_VECTX(M) = FNAMEX             
            FNAME_VECTY(M) = FNAMEY
            TITLE_VECTX(M) = TITLEX
            TITLE_VECTY(M) = TITLEY   
         ELSEIF (ISEND.EQ.8) THEN
C
C ISEND = 8: MWU test [DOUBLE = 3]
C
            M = 3 
            NX = NROW_VECTX(M)
            NY = NROW_VECTY(M)
            FNAMEX = FNAME_VECTX(M)
            FNAMEY = FNAME_VECTY(M)
            TITLEX = TITLE_VECTX(M)
            TITLEY = TITLE_VECTY(M)
            JSEND = 5
            CALL M_VECTWO (JSEND, NIN, NOUT, NX, NY,
     +                     FNAMEX, FNAMEY, TITLEX, TITLEY)
            NROW_VECTX(M) = NX
            NROW_VECTY(M) = NY
            FNAME_VECTX(M) = FNAMEX             
            FNAME_VECTY(M) = FNAMEY
            TITLE_VECTX(M) = TITLEX
            TITLE_VECTY(M) = TITLEY     
         ELSEIF (ISEND.EQ.9) THEN
C
C ISEND = 9: Wilcoxon siged ranks [DOUBLE = 4]
C
            M = 4 
            NX = NROW_VECTX(M)
            NY = NROW_VECTY(M)
            FNAMEX = FNAME_VECTX(M)
            FNAMEY = FNAME_VECTY(M)
            TITLEX = TITLE_VECTX(M)
            TITLEY = TITLE_VECTY(M)
            JSEND = 6
            CALL M_VECTWO (JSEND, NIN, NOUT, NX, NY,
     +                     FNAMEX, FNAMEY, TITLEX, TITLEY)
            NROW_VECTX(M) = NX
            NROW_VECTY(M) = NY
            FNAME_VECTX(M) = FNAMEX             
            FNAME_VECTY(M) = FNAMEY
            TITLE_VECTX(M) = TITLEX
            TITLE_VECTY(M) = TITLEY      
         ELSEIF (ISEND.EQ.10) THEN
C
C ISEND = 10: Median, Mood, David [DOUBLE = 5]
C
            M = 5 
            NX = NROW_VECTX(M)
            NY = NROW_VECTY(M)
            FNAMEX = FNAME_VECTX(M)
            FNAMEY = FNAME_VECTY(M)
            TITLEX = TITLE_VECTX(M)
            TITLEY = TITLE_VECTY(M)
            JSEND = 9
            CALL M_VECTWO (JSEND, NIN, NOUT, NX, NY,
     +                     FNAMEX, FNAMEY, TITLEX, TITLEY)
            NROW_VECTX(M) = NX
            NROW_VECTY(M) = NY
            FNAME_VECTX(M) = FNAMEX             
            FNAME_VECTY(M) = FNAMEY
            TITLE_VECTX(M) = TITLEX
            TITLE_VECTY(M) = TITLEY  
         ELSEIF (ISEND.EQ.11) THEN
C
C ISEND = 11: Groups across rows
C                
            M = 6
            NCOL = NCOL_MATRIX(M)
            NROW = NROW_MATRIX(M)
            FNAMEA = FNAME_MATRIX(M)
            TITLEA = TITLE_MATRIX(M)
            ISEND = 35
            CALL M_MATONE (ISEND, NCOL, NIN, NOUT, NROW,
     +                     FNAMEA, TITLEA)
            NCOL_MATRIX(M) = NCOL
            NROW_MATRIX(M) = NROW
            FNAME_MATRIX(M) = FNAMEA
            TITLE_MATRIX(M) = TITLEA   
         ELSEIF (ISEND.EQ.12) THEN
C
C ISEND = 12: All possible comparisons
C
            CALL VECTST (IWRK, NIN, NMAX, NOUT, NSMALL,
     +                   V, W, W1, W2,
     +                   FSAV, TSAV)
         ELSEIF (ISEND.EQ.13) THEN
C
C ISEND = 13: Nonparametric correlation [MATRIX = 1]
C
            M = 1
            NCOL = NCOL_MATRIX(M)
            NROW = NROW_MATRIX(M)
            FNAMEA = FNAME_MATRIX(M)
            TITLEA = TITLE_MATRIX(M)
            ISEND = 2 
            CALL M_MVSTAT (ISEND, NCOL, NIN, NOUT, NROW,
     +                     FNAMEA, TITLEA)
            NCOL_MATRIX(M) = NCOL
            NROW_MATRIX(M) = NROW
            FNAME_MATRIX(M) = FNAMEA
            TITLE_MATRIX(M) = TITLEA   
         ELSEIF (ISEND.EQ.14) THEN
C
C ISEND = 14: ANOVA, Kruskall-Wallis
C
            JSEND = 3
            CALL M_ANOVA1 (JSEND, NOUT, NIN,
     +                     SUPPLY_MATRIX)         
         ELSEIF (ISEND.EQ.15) THEN
C
C ISEND = 15: Friedman [MATRIX = 2]
C
            M = 2
            NCOL = NCOL_MATRIX(M)
            NROW = NROW_MATRIX(M)
            FNAMEA = FNAME_MATRIX(M)
            TITLEA = TITLE_MATRIX(M)
            JSEND = 2
            KSEND = 3
            CALL M_ANOVAM (JSEND, KSEND, NCOL, NOUT, NIN, NROW,
     +                     FNAMEA, TITLEA)
            NCOL_MATRIX(M) = NCOL
            NROW_MATRIX(M) = NROW
            FNAME_MATRIX(M) = FNAMEA
            TITLE_MATRIX(M) = TITLEA   
         ELSEIF (ISEND.EQ.16) THEN
C
C ISEND = 16: Kendall coefficient of concordance [MATRIX = 3]
C
            M = 3
            NCOL = NCOL_MATRIX(M)
            NROW = NROW_MATRIX(M)
            FNAMEA = FNAME_MATRIX(M)
            TITLEA = TITLE_MATRIX(M)
            ISEND = 31
            CALL M_MATONE (ISEND, NCOL, NIN, NOUT, NROW,
     +                     FNAMEA, TITLEA)
            NCOL_MATRIX(M) = NCOL
            NROW_MATRIX(M) = NROW
            FNAME_MATRIX(M) = FNAMEA
            TITLE_MATRIX(M) = TITLEA   
         ELSEIF (ISEND.EQ.17) THEN
C
C ISEND = 17: Cochran Q [MATRIX = 4]
C
            M = 4
            NCOL = NCOL_MATRIX(M)
            NROW = NROW_MATRIX(M)
            FNAMEA = FNAME_MATRIX(M)
            TITLEA = TITLE_MATRIX(M)
            ISEND = 10 
            CALL M_MATONE (ISEND, NCOL, NIN, NOUT, NROW,
     +                     FNAMEA, TITLEA)
            NCOL_MATRIX(M) = NCOL
            NROW_MATRIX(M) = NROW
            FNAME_MATRIX(M) = FNAMEA
            TITLE_MATRIX(M) = TITLEA   
         ELSEIF (ISEND.EQ.18) THEN
C
C ISEND = 18: Regression on ranks [MATRIX = 5]
C
            M = 5
            NCOL = NCOL_MATRIX(M)
            NROW = NROW_MATRIX(M)
            FNAMEA = FNAME_MATRIX(M)
            TITLEA = TITLE_MATRIX(M)
            ISEND = 29 
            CALL M_MATONE (ISEND, NCOL, NIN, NOUT, NROW,
     +                     FNAMEA, TITLEA)
            NCOL_MATRIX(M) = NCOL
            NROW_MATRIX(M) = NROW
            FNAME_MATRIX(M) = FNAMEA
            TITLE_MATRIX(M) = TITLEA    
         ELSEIF (ISEND.EQ.19) THEN
C
C ISEND = 19: Help
C
            FIRST = .FALSE.
            CALL ADVISE (DVER,
     +                   ABORT, FIRST)
         ELSEIF (ISEND.EQ.20) THEN
C
C ISEND = 20: Results
C
            CALL REVPRO (NOUT)
         ELSEIF (ISEND.EQ.21) THEN
C
C ISEND = 20: Quit
C
            AGAIN = .FALSE.
            CLOSE (UNIT = NOUT)
            ISEND = 2
            CALL FNAMES (ISEND,
     +                   FNAME)
         ENDIF
      ENDDO

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 2
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C
      CLOSE (UNIT = NOUT)
C
C Format statement
C
  100 FORMAT (
     +/1X,'PACKAGE: SIMFIT'
     +/1X,'PROGRAM: RSTEST'
     +/1X,'ACTION : Run, sign and other nonparametric tests'
     +/1X,'AUTHOR : W. G. Bardsley, University of Manchester, U.K.')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (IN)  :: FIRST
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_RSTEST
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
           ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_RSTEST ('rstest')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `RSTEST'
     +/'        `      '
     +/'Action  `Nonparameric tests: Run/Sign test, Runs up or'
     +/'        `down for randomness test, Kolmogorov-Smirnov one'
     +/'        `and two sample tests, Mann-Whitney U test, etc.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE CHOOSE (ISEND)
C
C Choose the option required
C 03/03/2005 added check for NAG library
C
      IMPLICIT   NONE
C
C Argument
C
      INTEGER, INTENT (OUT) :: ISEND
C
C Locals
C
      INTEGER    IX, IY, MARK20, NUMOPT, NUMOPT_2
      PARAMETER (IX = 4, IY = 4, MARK20 = 20, NUMOPT = 21, 
     +           NUMOPT_2 = NUMOPT - 2)
      INTEGER    ISAV, MARK
      CHARACTER  TEXT(30)*100, NAG*5
      CHARACTER  BLANK5*5, NAG5*5
      PARAMETER (BLANK5 = '     ', NAG5 = '(NAG)')
      LOGICAL    ABORT, OK, REPEET, TITLES
      PARAMETER (TITLES = .TRUE.)
      EXTERNAL   LVIEW2
      EXTERNAL   DLLNAG, CHKNAG
      SAVE ISAV
      DATA ISAV / NUMOPT_2 /
C
C Check for NAG library
C
      CALL DLLNAG (MARK,
     +             OK)
      IF (MARK.GE.MARK20 .AND. OK) THEN
         NAG = BLANK5
      ELSE
         NAG = NAG5
      ENDIF
      WRITE (TEXT,100) NAG
      ISEND = ISAV
      REPEET = .TRUE.
      DO WHILE (REPEET)
         CALL LVIEW2 (IX, IY, ISEND, NUMOPT,
     +                TEXT, TITLES)
         OK = .TRUE.
         IF (ISEND.EQ.18) THEN
            CALL CHKNAG (MARK20,
     +                   ABORT)
            IF (ABORT) THEN
               OK = .FALSE.
               ISEND = 18
            ENDIF   
         ENDIF
         IF (OK) REPEET = .FALSE.
      ENDDO        
      ISAV = ISEND
C
C Format statement
C      
  100 FORMAT (
     + 'RSTEST: Name of the statistical test  `Sample required'
     +/'Sign test on number of +ves, -ves     `2 numbers'
     +/'Run and sign test on +ves, -ves, runs `3 numbers'
     +/'Run and sign test on set of residuals `1 sample'
     +/'Run and sign test on matched pairs    `2 samples'
     +/'Runs up (or down) test for randomness `1 sample'
     +/'1-sample Kolmogorov-Smirnov test      `1 sample'
     +/'2-sample Kolmogorov-Smirnov test      `2 samples'
     +/'2-sample Mann-Whitney U test          `2 samples'
     +/'2-sample Wilcoxon signed-rank test    `2 samples'
     +/'2-sample Median, Mood, David tests    `2 samples'
     +/'Groups across rows MW_U/KS_D tests    `n samples/matrix'
     +/'All possible pairs MW_U/KS_D tests    `n samples'
     +/'Spearman/Kendall-tau NP correlation   `matrix'
     +/'Kruskal-Wallis ANOVA                  `n samples/matrix'
     +/'Friedman ANOVA                        `matrix'
     +/'Kendall coefficient of concordance    `matrix'
     +/'Cochran Q on X-classified binary data `(0,1) matrix'
     +/'Regression on ranks                   `x1..xm,y,t,s matrix',2X,A
     +/'Help                                  `...'
     +/'Results                               `...'
     +/'Quit ... Exit program RSTEST          `...')
      END
C
C
