c
c===========================================================================
c run6_1.ins
c ==========
c This file MUST NOT be edited
c           ========
c This is the ftn95 version developed from the ftn77 version on 19/12/98
c 07/11/99 added calculator and run_calculator
c 15/11/99 added check_run5_dll
c 02/11/99 replaced start_process@ by winexec
c 14/02/2000 dimensioned all character strings 256
c 10/09/2000 altered viewer codes and added user*.* and deq*.*
c 03/09/2001 added call to psspec$
c 05/02/2002 added *.mod to view routine after usermod?.tf?
c 08/02/2002 increased dimension to nval(12) and added trim80 to folders
c 14/02/2002 added clipboard/run_clipboard
c 20/03/2002 added quotes to gsview arguments
c 31/01/2003 added code for results files
c 21/08/2003 increased number of results files saved to 1 plus 10 previous
c 14/11/2003 added i_edit_results
c 17/11/2003 moved running programs to runexe in w_menus.dll
c 30/04/2004 added run_explorer to call runexe in w_menus.dll
c 03/06/2005 added i_view_recent 
c 18/08/2006 replaced calls to run_help by calls to help_main and added faq 
c 01/10/2006 added fname and supply to arguments for ps2??? routines
c 29/11/2006 added call to simdir in run_viewer
c 13/07/2007 edited for version 6
c
c Note that the following files must be consistent:
c run6.for, run6_1.ins, run6_2.ins and run6.htm
c help.for (and all the html files)
c===========================================================================
c
c help items
c ==========
c icon_help
c menu1_help
c menu2_help
c menu3_help
c menu4_help
c menu5_help
c menu6_help
c menu7_help
c menu8_help
c menu9_help
c menu10_help
c
c check item
c ==========
c check_run6_dll
c
c run items
c ===========
c run_viewer
c i_view_file
c
c other items
c ===========
c item_jpg
c item_pcx
c item_bmp
c item_tif
c item_png
c item_pdf
c item_xps
c item_pf
c item_svg
c svg_item
c i_print_file
c
c other call back functions
c =========================
c acrobat
c calculator
c clipboard
c configure
c editor
c explorer 
c faq
c files
c folders
c gsview
c information
c modules
c pfiles
c release
c reserved
c technical
c
c code for results files
c ======================
c i_edit_results
c i_help_results
c i_print_results
c i_save_results
c i_view_recent
c i_view_results
c i_table_results
c results_file
c
      recursive integer function icon_help()
      implicit   none
      character  command_line*7
      parameter (command_line = 'summary')
      external   help_main
      icon_help = 2
      call help_main (command_line)
      end
c
c
      recursive integer function menu1_help()
      implicit   none
      character  command_line*4
      parameter (command_line = 'file')
      external   help_main
      menu1_help = 2
      call help_main (command_line)
      end
c
c
      recursive integer function menu2_help()
      implicit   none
      character  command_line*4
      parameter (command_line = 'edit')
      external   help_main
      menu2_help = 2
      call help_main (command_line)
      end
c
c
      recursive integer function menu3_help()
      implicit   none
      character  command_line*4
      parameter (command_line = 'view')
      external   help_main
      menu3_help = 2
      call help_main (command_line)
      end
c
c
      recursive integer function menu4_help()
      implicit   none
      character  command_line*3
      parameter (command_line = 'fit')
      external   help_main
      menu4_help = 2
      call help_main (command_line)
      end
c
c
      recursive integer function menu5_help()
      implicit   none
      character  command_line*5
      parameter (command_line = 'calib')
      external   help_main
      menu5_help = 2
      call help_main (command_line)
      end
c
c
      recursive integer function menu6_help()
      implicit   none
      character  command_line*4
      parameter (command_line = 'plot')
      external   help_main
      menu6_help = 2
      call help_main (command_line)
      end
c
c
      recursive integer function menu7_help()
      implicit   none
      character  command_line*5
      parameter (command_line = 'stats')
      external   help_main
      menu7_help = 2
      call help_main (command_line)
      end
c
c
      recursive integer function menu8_help()
      implicit   none
      character  command_line*4
      parameter (command_line = 'area')
      external   help_main
      menu8_help = 2
      call help_main (command_line)
      end
c
c
      recursive integer function menu9_help()
      implicit   none
      character  command_line*8
      parameter (command_line = 'simulate')
      external   help_main
      menu9_help = 2
      call help_main (command_line)
      end
c
c
      recursive integer function menu10_help()
      implicit   none
      character  command_line*7
      parameter (command_line = 'modules')
      external   help_main
      menu10_help = 2
      call help_main (command_line)
      end
c
c
      subroutine check_run6_dll (xver, yver, dver, pver, store)
c
c 10/04/99 completely new version that does not call program help
c pver and pver1 are not used but are retained for possible future use
c 03/09/2001 added call to psspec$ to check PostScript specials
c
      implicit   none
      integer    isend, nout
      parameter (isend = 3, nout = 0)
      double precision xver, yver
      double precision xver1, yver1
      character  dver*(*), pver*(*)
      character  dver1*30, pver1*30
      logical    store
      logical    abort, show
      parameter (show = .false.)
      external   dllchk
      external   psspec$
      save       xver1, yver1, dver1, pver1
      data       xver1, yver1 / 5.40d+00, 4.012d+00 /
      data       dver1, pver1 / 'February  05  2002', 'w_simfit.exe' /
      if (store) then
c
c if store = true then called the first time from run6
c
         xver1 = xver
         yver1 = yver
         dver1 = dver
         pver1 = pver
         call dllchk (xver, yver, dver, pver, abort, show)
         call psspec$(isend, nout)
      else
c
c store = false so retrieve parameters
c
         xver = xver1
         yver = yver1
         dver = dver1
         pver = pver1
      endif
      end
c
c
      subroutine run_viewer (i_choose)
c
c values of i_choose as follows:
c ==============================
c
c  3: readme  (c:\program files\simfit\doc\w_readme.* files)
c  4: tf      (c:\program files\simfit\dem\*.tf? files)
c  5: tfl     (c:\program files\simfit\dem\*.tfl files)
c  6: user    (...\My Documents\simfit\usr\*.* files)
c  7: deq     (c:\program files\simfit\deq*.tf?)
c  8: dir     (c:\program files\simfit\dem\*.plf)
c  9: cfg     (*.cfg files)
c 10: text    (selected files)
c
c 14: in      (w_in.tmp file)
c 15: out     (w_out.tmp file)
c 16: i1      (c:\program files\simfit\doc\w_readme.* files)
c
c 18: pdf     (acrobat read w_manual.pdf)
c
      implicit   none
      include   <windows.ins>, nolist
      integer    isend, k, l
      integer    i_choose, i_view_file
      double precision correction, pcent, size1
      parameter (pcent = 100.0d+00)
      character  fname*1024, path*1024, pattern*1024
      character  trim60*60
      character  path1*1024, pattern1*1024, simfit*1024
      logical    there, view_file
      external   w_viewer,  putfat
      external   w_syspar, trim60, docdir, tmpdir
      external   i_view_file, run_acrobat
      external   vutext
      save       path1, pattern1
      intrinsic  dble, leng
      common     /view/ view_file
      data       path1, pattern1 / 'C:', '*.*' /
      if (i_choose.eq.14 .or. i_choose.eq.15) then
         call tmpdir (l,
     +                simfit)
      elseif (i_choose.eq.3 .or. i_choose.eq.16 .or.
     +        i_choose.eq.18) then
         call docdir (l,
     +                simfit)
      endif          
      if (i_choose.le.2) then
         return
      elseif (i_choose.ge.3 .and. i_choose.le.9) then
         isend = i_choose - 2
         call vutext (isend)
      elseif (i_choose.eq.10) then
         call use_windows95_font@()
         call w_syspar (k, 'f')
         correction = dble(k)/pcent
         size1 = 0.8d+00*correction
         k = winio@('%fn[ms sans serif]%tc[black]%ts&', size1)
         k = winio@('%sy[3d_thin]&')
         k = winio@('%bg[grey]%tc[black]&')
         k = winio@('%ob[bottom_exit, scored]&')
         k = winio@('%ca[SIMFIT: view a file]&')
         k = winio@('%co[full_check]&')
         k = winio@('%ff%`bg[white]%tc[black]&')
         k = winio@('%40rs&', path1)
         k = winio@('Path (e.g.   C:\Results)&')
         k = winio@('%ff%`bg[white]%tc[black]&')
         k = winio@('%40rs&', pattern1)
         k = winio@('Pattern (e.g.   *.*)&')
         k = winio@('%ff%nl%cn%^`6bt[Apply]    %^6bt[Cancel]&',
     +       i_view_file, 'EXIT')
         k = winio@('%nl&')
         k = winio@('%cb')
         k = 2
         call w_viewer (k,
     +                  fname, path1, pattern1)
      elseif (i_choose.gt.10 .and. i_choose.lt.14) then
         return
      elseif (i_choose.eq.14) then
         k = 1
         fname = simfit(1:l)//'w_in.tmp'
         call w_viewer (k, 
     +                  fname, path, pattern)
      elseif (i_choose.eq.15) then
         k = 1
         fname = simfit(1:l)//'w_out.tmp'
         call w_viewer (k,
     +                  fname, path, pattern)
      elseif (i_choose.eq.16) then
         fname = simfit(1:l)//'w_readme.i1'
         k = 1
         call w_viewer (k, 
     +                  fname, path, pattern)
      elseif (i_choose.eq.17) then
         return
      elseif (i_choose.eq.18) then
         fname = simfit(1:l)//'w_manual.pdf'
         inquire (file = fname, exist = there)
         if (there) then
            call run_acrobat (fname)
         else
            call putfat ('Cannot locate '//trim60(fname))
         endif
      else
         return
      endif
      end
c
c
      recursive integer function i_view_file()
      logical view_file
      common /view/ view_file
      view_file = .true.
      i_view_file = 0
      end
c
c
c items
c =====
c
c
      recursive integer function item_jpg()
c...ps to jpeg  
      implicit   none        
      character  blank*1
      parameter (blank = ' ')
      logical    supply
      parameter (supply = .false.)
      external ps2jpg
      call ps2jpg (blank,
     +             supply)      
      item_jpg = 2
      end
c
c
      recursive integer function item_pcx()
c...ps to pcx   
      implicit   none
      character  blank*1
      parameter (blank = ' ')
      logical    supply
      parameter (supply = .false.)
      external   ps2pcx
      call ps2pcx (blank,
     +             supply)      
      item_pcx = 2
      end
c
c
      recursive integer function item_bmp()
c...ps to bmp        
      implicit   none
      character  blank*1
      parameter (blank = ' ')
      logical    supply
      parameter (supply = .false.)
      external   ps2bmp
      call ps2bmp (blank,
     +             supply)      
      item_bmp = 2
      end
c
c
      recursive integer function item_tif()
c...ps to tif 
      implicit   none
      character  blank*1
      parameter (blank = ' ')
      logical    supply
      parameter (supply = .false.)
      external   ps2tif
      call ps2tif (blank,
     +             supply)      
      item_tif = 2
      end
c
c
      recursive integer function item_png()
c...ps to png        
      implicit   none
      character  blank*1
      parameter (blank = ' ')
      logical    supply
      parameter (supply = .false.) 
      external   ps2png 
      call ps2png (blank,
     +             supply)       
      item_png = 2
      end
c
c
      recursive integer function item_pdf()
c...ps to pdf        
      implicit   none
      character  blank*1
      parameter (blank = ' ')
      logical    supply 
      parameter (supply = .false.)
      external   ps2pdf
      call ps2pdf (blank,
     +             supply)      
      item_pdf = 2
      end
c
c
      recursive integer function item_xps()
c...ps to xps        
      implicit   none
      character  blank*1
      parameter (blank = ' ')
      logical    supply 
      parameter (supply = .false.)
      external   ps2xps
      call ps2xps (blank,
     +             supply)      
      item_xps = 2
      end      
c
c
      recursive integer function item_svg()
c...ps to pdf        
      implicit   none
      character  blank*1
      parameter (blank = ' ')
      logical    supply 
      parameter (supply = .false.)
      external   ps2svg
      call ps2svg (blank,
     +             supply)      
      item_svg = 2
      end  
c
c
      recursive integer function svg_item()
c...editsvg        
      implicit   none
      external   editsvg_driver
      call editsvg_driver
      svg_item = 2
      end                
c
c
      recursive integer function item_p_f()
c...print a file          
      implicit   none
      include   <windows.ins>, nolist
      integer    k, lpti
      integer    i_print_file
      integer    lower, upper
      parameter (lower = 0, upper = 4)
      double precision correction, pcent, size1
      parameter (pcent = 100.0d+00)
      character  path*1024, path1*1024, pattern*1024, pattern1*1024
      logical    print_file
      external   i_print_file
      external   w_printr, w_syspar
      intrinsic  dble
      common    /printer/ print_file
      data       lpti / 0 /
      data       path1 / 'C:' /
      data       pattern1 / '*.*' /
      print_file = .false.
      call use_windows95_font@()
      call w_syspar (k, 'f')
      correction = dble(k)/pcent
      size1 = 0.8d+00*correction
      k = winio@('%fn[ms sans serif]%tc[black]%ts&', size1)
      k = winio@('%sy[3d_thin]&')
      k = winio@('%bg[grey]%tc[black]&')
      k = winio@('%ob[bottom_exit, scored]&')
      k = winio@('%ca[SIMFIT: print a file]&')
      k = winio@('%co[full_check]&')
      k = winio@('%ff%`bg[white]%tc[black]&')
      k = winio@('%il&', lower, upper)
      k = winio@('%5rd&', lpti)
      k = winio@(
     +'Printer (0: default, 1: LPT1, etc. as in w_simfit.cfg)&')
      k = winio@('%ff%`bg[white]%tc[black]&')
      k = winio@('%40rs&', path1)
      k = winio@('Path (e.g.   C:\Results)&')
      k = winio@('%ff%`bg[white]%tc[black]&')
      k = winio@('%40rs&', pattern1)
      k = winio@('Pattern (e.g.   *.*)&')
      k = winio@('%ff%nl%cn%^`6bt[Apply]     %^6bt[Cancel]&',
     +    i_print_file, 'EXIT')
      k = winio@('%ff%nl&')
      k = winio@('%cb')
      if (print_file) then
         path = path1
         pattern = pattern1
         call w_printr (lpti, path, pattern)
      endif
      item_p_f = 2
      end
c
c
      recursive integer function i_print_file()
      logical print_file
      common    /printer/ print_file
      print_file = .true.
      i_print_file = 0
      end
c
c
c call back functions
c ===================
c

c
c
      recursive integer function acrobat()
      implicit   none
      integer    isend
      parameter (isend = 2)
      character (len = 1024) fname
      logical    abort
      external   view_file_types
      acrobat = 2
      call view_file_types (isend,
     +                      fname,
     +                      abort)
      end
c
c
      recursive integer function calculator()
      implicit   none
      character  command_line*1
      parameter (command_line = ' ')
      external   run_calculator
      calculator = 2
      call run_calculator (command_line)
      end
c
c
      recursive integer function clipboard()
      implicit   none
      external   w_clipit
      clipboard = 2
      call w_clipit
      end
c
c
      recursive integer function configure()
      implicit   none
      integer    k, l1, l2, l3, l4, len200, nval(12)
      character  current1*1024, current2*1024, cval(12)*1024
      character  curdir@*1024
      external   w_config, lcase1, mssage, len200
      external   curdir@
      intrinsic  index
      configure = 2
      k = 1
      call w_config (k, nval, cval)
      if (nval(6).eq.0) return
      current1 = curdir@()
      current2 = cval(3)
      call lcase1 (current1)
      l1 = index(current1,'\')
      l2 = len200(current1)
      if (current1(l2:l2).eq.'\') current1(l2:l2) = ' '
      call lcase1 (current2)
      l3 = index(current2,'\')
      l4 = len200(current2)
      if (current2(l4:l4).eq.'\') current2(l4:l4) = ' '
      if (l1.gt.0 .and. l2.gt.l1 .and. l3.gt.0 .and. l4.gt.l3) then
         if (current1(l1:l2).ne.current2(l3:l4)) then
            k = 3
            call mssage (k)
         endif
      endif
      end
c
c
      recursive integer function editor()
      implicit   none
      character  command_line*1
      parameter (command_line = ' ')
      external   run_editor
      editor = 2
      call run_editor (command_line)
      end
c
c
      recursive integer function explorer()
      implicit   none
      character  command_line*1
      parameter (command_line = ' ')
      external   run_explorer
      explorer = 2
      call run_explorer (command_line) 
      end
c
c
      recursive integer function faq()
      implicit   none
      character  command_line*3
      parameter (command_line = 'faq')
      external   help_main
      faq = 2
      call help_main (command_line)
      end      
c
c
      recursive integer function files()
      implicit none
      integer  k
      external mssage
      files = 2
      k = 2
      call mssage (k)
      end
c
c
            recursive integer function folders()
c 20/11/2022 cut down by elimnating two items and adding a blank line between items   
c          cval(1) : editor
c          cval(2) : explorer
c          cval(3) : simfit
c          cval(4) : results
c          cval(5) : user
c          cval(6) : config
c          cval(7) : ***Not used
c          cval(8) : ghostscript
c          cval(9) : temp
c          cval(10): gsview, i.e. EPS-viewer
c          cval(11): acrobat, i.e. PDF-reader
c          cval(12): calculator
c
c     + 'Current folder:' curdir@
c     +/'Simfit folder:'  cval(3)
c     +/'PS viewer:'      cval(10)
c     +/'Ghostscript:'    cval(8)
c     +/'PDF viewer:'     cval(11)
c     +/'Editor:'         cval(1)
c     +/'Explorer:'       cval(2)
c     +/'Calculator:'     cval(12)
      implicit   none
      integer    icolor, ix, iy, lshade, mode, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 0, mode = 0,
     +           numtxt = 23)
      integer    numbld(numtxt)
      integer    i, nval(12)
      character (len = 1024) cval(12), curdir@
      character (len = 100 ) name(8), text(numtxt), trim100
      logical    border
      parameter (border = .false.)
      external   w_config, patch1
      external   curdir@
      external   trim100
      data numbld / 1,0,0, 1,0,0, 1,0,0, 1,0,0, 1,0,0, 1,0,0, 
     +              1,0,0, 1,0 /
      folders = 2
      call w_config (mode, nval, cval)
      name(1) = trim100(curdir@())   !current d1rectory
      name(2) = trim100(cval(3))     !simfit folder
      name(3) = trim100(cval(10))    !gsview
      name(4) = trim100(cval(8))     !ghostscript
      name(5) = trim100(cval(11))    !pdf viewer
      name(6) = trim100(cval(1))     !editor
      name(7) = trim100(cval(2))     !exlorer
      name(8) = trim100(cval(12))    !calculator
      write (text,100) (name(i), i = 1, 8)
      call patch1 (icolor, ix, iy, lshade, numbld, numtxt, text, border)
c
c format statement
c      
  100 format (
     + 'Current folder:'
     +/A
     +/
     +/'Simfit folder:'
     +/A
     +/
     +/'PS viewer:'
     +/A
     +/
     +/'Ghostscript:'
     +/A
     +/
     +/'PDF viewer:'
     +/A
     +/
     +/'Editor:'
     +/A
     +/
     +/'Explorer:'
     +/A
     +/
     +/'Calculator:'
     +/A)
      end
c
c
      recursive integer function gsview()
      implicit   none
      integer    isend
      parameter (isend = 1)
      character (len = 1024) fname
      logical    abort
      external   view_file_types
      gsview = 2
      call view_file_types (isend,
     +                      fname,
     +                      abort)
      end
c
c
      recursive integer function information()
      implicit none
      integer  k
      external mssage
      information = 2
      k = 1
      call mssage (k)
      end
c
c
      recursive integer function modules()
      implicit   none
      integer    isend
      parameter (isend = 0)
      integer    ifail
      character  fname*1024
      external   w_module
      external   run_win32
      intrinsic  max
      modules = 2
      call w_module (isend, fname)
      ifail = 0
      call run_win32 (ifail, fname)
      end
c
c
      recursive integer function pfiles()
      implicit none
      external qfile0
      pfiles = 2
      call qfile0
      end        
c
c
      recursive integer function release()
      double precision xver, yver
      character  dver*30, pver*30
      logical    store, show
      parameter (store = .false., show = .true.)
      logical    abort
      external   dllchk, check_run6_dll
      release = 2
      call check_run6_dll (xver, yver, dver, pver, store)
      call dllchk (xver, yver, dver, pver, abort, show)
      end
c
c
      recursive integer function technical()
      integer isend
      parameter (isend = 0)
      external mssage
      technical = 2
      call mssage (isend)
      end
c
c

c
c code for results files
c ======================
c
c
      recursive integer function i_edit_results()
      implicit   none
      integer    isend
      parameter (isend = 4)
      character (len = 1024) fname
      external   results_file
      call results_file (isend,
     +                   fname)
      i_edit_results = 2
      end
c
c
      recursive integer function i_help_results()
      implicit   none
      character  command_line*7
      parameter (command_line = 'results')
      external   help_main
      call help_main (command_line)
      i_help_results = 2
      end
c
c
      recursive integer function i_print_results()
      implicit   none
      integer    isend
      parameter (isend = 2)
      character (len = 1024) fname
      external   results_file
      call results_file (isend,
     +                   fname)
      i_print_results = 2
      end
c
c
      recursive integer function i_save_results()
      implicit   none
      integer    isend
      parameter (isend = 3)
      character (len = 1024) fname
      external   results_file
      call results_file (isend,
     +                   fname)
      i_save_results = 2
      end
c
c
      recursive integer function i_table_results()
      implicit   none
      external   tabber
      call tabber
      i_table_results = 2
      end      
c
c
      recursive integer function i_view_recent()
      external recent
      call recent
      i_view_recent = 2
      end
c
c
      recursive integer function i_view_results()
      implicit   none
      integer    isend
      parameter (isend = 1)
      character (len = 1024) fname
      external   results_file
      call results_file (isend,
     +                   fname)
      i_view_results = 2
      end
c
c
      
c
c
      recursive integer function simfit_url()
      implicit none
      character (len = 21) url
      parameter (url = 'https://simfit.org.uk')
      external use_url
      simfit_url = 2
      call use_url (url)
      end