
C
C RUN6_3.INS: RUN6_LOGO
c i_run_simfit_programs
c run_simfit_programs
C =====================
C
C
      SUBROUTINE RUN6_LOGO (ISEND, VERSION)
C
C ACTION: SIMFIT main front page logo
C AUTHOR: w.g.bardsley, university of manchester, u.k. 08/11/2003
C         07/08/2007 extensively revised for version 6
C         08/10/2022 added new websites and raised the logo from 3*depth to 2*depth
C
      IMPLICIT   NONE
      INCLUDE   <windows.ins>
C
C Arguments
C
      INTEGER    ISEND
      CHARACTER  VERSION*(*)
C
C Locals
C
      INTEGER    BOOL, HANDLE, K0, K1
      PARAMETER (BOOL = 1, HANDLE = 0, K0 = 0, K1 = 1)
      INTEGER    K, KX, KY
      INTEGER    NUMRGB$
      DOUBLE PRECISION DEFOLT, FACTOR, SCALEX, SCALEY
      PARAMETER (DEFOLT = 1024.0D+00, SCALEX = 0.75D+00,
     +           SCALEY = 0.50D+00)
C ... Colours
      INTEGER    ICOLOR, CNAME, CTITLE, CSHADE, CTEXT, CWEB
C ... Simfit: number of shading loops
      INTEGER    NSHADE
      PARAMETER (NSHADE = 5)
C ... Title: font size
      INTEGER    IFY1
      PARAMETER (IFY1 = 60)
C ... Character: font size for subheading
      INTEGER    IFY2
      PARAMETER (IFY2 = 14)
C ... Name: font size
      INTEGER    IFY3
      PARAMETER (IFY3 = 12)
C ... Temporary integers
      INTEGER    I, IDX, IDY
      integer    iy_start, width, depth
      double precision half, yscale
      parameter (half = 0.5d+00, yscale = 1.5d+00)
C ... Texts
      CHARACTER  SIMFIT*6
      PARAMETER (SIMFIT = 'Simfit')
      CHARACTER  TITLE*46
      PARAMETER (TITLE = 
     +          'Simulation, fitting, statistics, and plotting.')
      CHARACTER  NAME*44
      PARAMETER (NAME = 'W.G.Bardsley, University of Manchester, U.K.')   
      CHARACTER  WEBSITE0*17
      PARAMETER (WEBSITE0 = 'https://simfit.uk') 
      CHARACTER  WEBSITE*21
      PARAMETER  (WEBSITE = 'https://simfit.org.uk')
      CHARACTER  WEBSITE1*30
      PARAMETER (WEBSITE1 = 'https://simfit.silverfrost.com')
C ... Externals
      EXTERNAL   W_SYSPAR
      EXTERNAL   NUMRGB$
      INTRINSIC  DBLE, NINT
      IF (ISEND.EQ.1) THEN
C
C Define the colours
C
         K = USE_RGB_COLOURS@(HANDLE, BOOL)
         ICOLOR = 14
         CTITLE = NUMRGB$(ICOLOR)
         ICOLOR = 15
         CNAME = NUMRGB$(ICOLOR)
         ICOLOR = 0
         CSHADE = NUMRGB$(ICOLOR)
         ICOLOR = 15
         CTEXT = NUMRGB$(ICOLOR)
         ICOLOR = 15
         CWEB = NUMRGB$(ICOLOR)
C
C Set up the screen and text attributes
C
         CALL W_SYSPAR (K, 'x')
         KX = NINT(DBLE(K)*SCALEX)
         FACTOR = DBLE(K)/DEFOLT
         CALL W_SYSPAR (K, 'y')
         KY = NINT(DBLE(K)*SCALEY)
         IDX = K0
         IDY = K0
         K = WINIO@('%`cu&', CURSOR_ARROW)

         k = winio@('%pv%gr[rgb_colours]&', kx, ky)
         
         K = USE_RGB_COLOURS@(HANDLE, BOOL)
         
C Draw shading then Simfit
C
         CALL SELECT_FONT@('Times New Roman')
         K = K1
         CALL ITALIC_FONT@(K)
         IDY = NINT(FACTOR*DBLE(IFY1))
         
         idx = nint(half*dble(idy))
                  
         CALL SIZE_IN_PIXELS@(IDY, IDX)
         
         call get_text_size@(simfit, width, depth)
         idx = nint(half*dble(kx - width))
         iy_start = 2*depth
         idy = iy_start
         
         DO I = K1, NSHADE
            IDX = IDX - K1
            IDY = IDY - K1
            CALL DRAW_CHARACTERS@(SIMFIT, IDX, IDY, CSHADE)
         ENDDO
         IDX = IDX - K1
         IDY = IDY - K1
         CALL DRAW_CHARACTERS@(SIMFIT,IDX, IDY, CTITLE)
C
C Draw text
C
         CALL SELECT_FONT@('Arial')
         K = K0
         CALL BOLD_FONT@(K)
         K = K0
         CALL ITALIC_FONT@(K)

         IDY = NINT(FACTOR*DBLE(IFY2))
         idx = nint(half*dble(idy))
         CALL SIZE_IN_PIXELS@(IDY, IDX)
         
         call get_text_size@(title, width, depth)
         idx = nint(half*dble(kx - width))
         iy_start = iy_start + nint(yscale*dble(depth))
         idy = iy_start
         
         CALL DRAW_CHARACTERS@(TITLE, IDX, IDY, CTEXT)

C
C Draw name
C
         CALL SELECT_FONT@('Times New Roman')
         K = K1
         CALL ITALIC_FONT@(K)

         IDY = NINT(FACTOR*DBLE(IFY3))
         
         idx = nint(half*dble(idy))
         
         CALL SIZE_IN_PIXELS@(IDY, IDX)
         
         call get_text_size@(name, width, depth)
         idx = nint(half*dble(kx - width))
         iy_start = iy_start + nint(yscale*dble(depth))
         idy = iy_start
         
         CALL DRAW_CHARACTERS@(NAME, IDX, IDY, CNAME)

C
C Version
C

         call get_text_size@(version(1:leng(version)), width, depth)
         idx = nint(half*dble(kx - width))
         iy_start = iy_start + nint(yscale*dble(depth))
         idy = iy_start
         
         CALL DRAW_CHARACTERS@(VERSION, IDX, IDY, CNAME)
C
C Web sites
C
         
         call get_text_size@(website0(1:leng(website0)), width, depth) 
         iy_start = iy_start + nint(yscale*dble(depth)) 
         idy = iy_start 
         
         CALL DRAW_CHARACTERS@(WEBSITE0, IDX, IDY, CWEB)

         call get_text_size@(website(1:leng(website)), width, depth)
         iy_start = iy_start + nint(yscale*dble(depth))
         idy = iy_start 
         
         CALL DRAW_CHARACTERS@(WEBSITE, IDX, IDY, CWEB)

         call get_text_size@(website1(1:leng(website1)), width, depth) 
         iy_start = iy_start + nint(yscale*dble(depth))
         idy = iy_start
         
         CALL DRAW_CHARACTERS@(WEBSITE1, IDX, IDY, CWEB)

         
      ELSE
C
C Set up the screen and text attributes
C
         CALL W_SYSPAR (K, 'x')
         KX = NINT(DBLE(K)*SCALEX)
         FACTOR = DBLE(K)/DEFOLT
         CALL W_SYSPAR (K, 'y')
         KY = NINT(DBLE(K)*SCALEY)
         IDX = K0
         IDY = K0
         K = WINIO@('%`cu&', CURSOR_ARROW)
         K = WINIO@('%pv%gr[rgb_colours]&', KX, KY)
      ENDIF
      END
C
C
      recursive integer function i_run_simfit_programs()
      implicit none
      external run_simfit_programs
      i_run_simfit_programs = 1
      call run_simfit_programs
      end
c
c
      subroutine run_simfit_programs
      implicit   none
      integer    numdec, numopt
      parameter (numopt = 39)
      character  fname(numopt)*30, text(numopt)*100
      external   listbx, run_simfit
      write (text,100)
      numdec = 1
      call listbx (numdec, numopt,
     +             text) 
      if (numdec.eq.1) then
         return
      else
         numdec = numdec - 1
      endif      
      fname(1) = 'w_adderr.exe'
      fname(2) = 'w_average.exe'
      fname(3) = 'w_binomial.exe'
      fname(4) = 'w_calcurve.exe'
      fname(5) = 'w_chisqd.exe'
      fname(6) = 'w_compare.exe'
      fname(7) = 'w_csafit.exe'
      fname(8) = 'w_deqsol.exe'
      fname(9) = 'w_editfl.exe'
      fname(10) = 'w_editmt.exe'
      fname(11) = 'w_editps.exe'
      fname(12) = 'w_eoqsol.exe'
      fname(13) = 'w_exfit.exe'
      fname(14) = 'w_ftest.exe'
      fname(15) = 'w_gcfit.exe'
      fname(16) = 'w_help.exe'
      fname(17) = 'w_hlfit.exe'
      fname(18) = 'w_inrate.exe'
      fname(19) = 'w_linfit.exe'
      fname(20) = 'w_makcsa.exe'
      fname(21) = 'w_makdat.exe'
      fname(22) = 'w_makfil.exe'
      fname(23) = 'w_maklib.exe'
      fname(24) = 'w_makmat.exe'
      fname(25) = 'w_maksim.exe'
      fname(26) = 'w_mmfit.exe'
      fname(27) = 'w_normal.exe'
      fname(28) = 'w_polnom.exe'
      fname(29) = 'w_qnfit.exe'
      fname(30) = 'w_rannum.exe'
      fname(31) = 'w_rffit.exe'
      fname(32) = 'w_rstest.exe'
      fname(33) = 'w_sffit.exe'
      fname(34) = 'w_simplot.exe'
      fname(35) = 'w_simstat.exe'
      fname(36) = 'w_spline.exe'
      fname(37) = 'w_ttest.exe'
      fname(38) = 'w_usermod.exe'
      call run_simfit (fname(numdec))
  100 format (
     + 'Cancel  `No action'
     +/'adderr  `Add random error to exact data'
     +/'average `Average values, thresholds, and areas'
     +/'binomial`Binomial and Poisson distributions'
     +/'calcurve`Cubic spline calibration curves'
     +/'chisqd  `Chi-square distribution'
     +/'compare `Spline smoothing to compare two curves'
     +/'csafit  `Flow cytometry analysis'
     +/'deqsol  `Simulate and fit differential equations'
     +/'editfl  `Edit curve fitting type data files'
     +/'editmt  `Edit vector and matrix type data files'
     +/'editps  `Edit PostScript files and make collages'
     +/'eoqsol  `Optimal design for data point spacing'
     +/'exfit   `Fit exponential functions'
     +/'ftest   `F distribution'
     +/'gcfit   `Fit growth and survival curves'
     +/'help    `Tutorials'
     +/'hlfit   `Fit High/Low affinity ligand binding sites'
     +/'inrate  `Estimate initial rates and asymptotic slopes'
     +/'linfit  `Fit linear and GLM models'
     +/'makcsa  `Make flow cytometry data'
     +/'makdat  `Make exact data from model equations'
     +/'makfil  `Make a curve fitting file from raw data'
     +/'maklib  `Make a library file from existing files'
     +/'makmat  `Make a vector or matrix file from raw data'
     +/'maksim  `Make a data file from a spreadsheet table'
     +/'mmfit   `Fit Michaelis-Menten functions'
     +/'normal  `Normal distribution'
     +/'polnom  `Fit polynomials and use for calibration'
     +/'qnfit   `Advanced curve fitting'
     +/'rannum  `Generate random numbers, walks, or matrices'
     +/'rffit   `Fit positive rational functions'
     +/'rstest  `Runs, signs, and other nonparametric tests'
     +/'sffit   `Fit cooperative ligand binding saturation functions'
     +/'simplot `Comprehensive graph plotting package'
     +/'simstat `Comprehensive statistical analysis package'
     +/'spline  `Spline fitting'
     +/'ttest   `t distribution'
     +/'usermod `User-defined models')
      end
c
c      
