C
C This version of SFFIT  requires extra source files as follows
C ==============================================================
C
C SFFIT1.FOR: ADVISE, DATAIN, DATFIT, DATOUT
C SFFIT2.FOR: DERIV1, DERIV2, DETAIL, FUNCT1, KMVMAX
C SFFIT3.FOR: L1NORM, LINEAR, MONIT, ORDER, PARAMS, RANDOM, SWAPKS,
C             TESTQS, ZMOD
C DLLCHK.FOR: consistency check
C
C
C Now include the extra code
C ==========================
C
C     INCLUDE 'sffit1.for', NOLIST
C     INCLUDE 'sffit2.for', NOLIST
C     INCLUDE 'sffit3.for', NOLIST
C     INCLUDE 'dllchk.for', NOLIST
C

C-----------------------------------------
C Start of Module to replace common blocks
C-----------------------------------------
      MODULE MODULE_SFFIT
      
      IMPLICIT NONE
         
      INTEGER    NMAX
      INTEGER    ITIME, MFAST, NFAST, NPTS
      INTEGER    NFACT
      PARAMETER (NFACT = 13)
      DOUBLE PRECISION DOFDOM, FACT(NFACT), REELN
      LOGICAL    YSCALE(2)
        
      DOUBLE PRECISION, ALLOCATABLE :: ERRY(:), THEORY(:), XVAL(:),
     +                                 YVAL(:)
      LOGICAL,          ALLOCATABLE :: EQUAL(:)
         
      END MODULE MODULE_SFFIT
C---------------------------------------
C End of module to replace common blocks
C---------------------------------------      

c      COMMON
c     +/CYCLES/ ITIME, MFAST, NFAST, NPTS
c     +/SCALAR/ DOFDOM, FACT(NX), REELN
c     +/VALUES/ ERRY(NMAX), THEORY(NMAX), XVAL(NMAX), YVAL(NMAX)
c     +/LGICAL/ EQUAL(NMAX), YSCALE(2)
C
      PROGRAM MAIN
C
C VERSION : details from SIMVER/DLLCHK
C FORTRAN : 95, Double precision
C NAG     : C05AZF, E02GBF, E04JAF, G01EBF,
C           G01FBF, G05CCF, G05DDF, G02CAF,
C           F01ABF,
C           X02AJF, X02AMF
C INPUT   : File with TITLE, NPTS, X, Y, Standard error in Y
C           as prepared by programs MAKFIL, MAKDAT, ADDERR or EDITFL
C ACTION  : Best-fit positive saturation function. Random search and/or
C           solving the over-determined system for starting estimates
C           then optimisation using a quasi-Newton routine and F test.
C           X- and Y-data transformed to 'ORDER UNITY' internally.
C MODEL   : Y(X) = Z*X*F'(X)/(N*F(X))  +  C   where
C           F(X) = 1.0 + K(1)*X + ... + K(N)*(X**N)
C           Z and C are optional scaling factors',
C OUTPUT  : Weighted sums of squares, F statistics, parameters
C           and residuals as requested. All details can be written
C           to a data output file
C ADVICE  : Make sure that the standard error in Y > 0.0,
C           and X in increasing order
C           Choose units so that Z = 1 and C = 0 if possible
C           otherwise determine these scaling parameters first and then
C           normalise the data (using EDITFL) and re-run
C           Set parameters : NF   = Unit for data output file
C                            NMAX = Maximim number of points
C                            NN   = Maximum order (N:N)
C                            NX   = No. of parameters (NX = NN + 2)
C AUTHOR  : W. G. Bardsley, 22/10/86
C REVISED : 31/01/1990  Re-organised, dimensions, INVERT, COVVAR, QNGRAD
C           12/02/1990 PROBRS, GRAF2A
C           17/03/1991 DATTIN, DATCHK, RES001, FTESTS
C           07/05/1991 Extensive use of W
C           10/01/1992 Corrected NUMBER in call to RESGKS and FTESTS
C           25/06/1992 ENDALL, REPEAT, GETNUM, GETCHR, CHECKT, CHECKW,
C                      GKSR01, GKST02, GKST03
C           07/01/1993 GKS004, PUT??? etc.
C           07/04/1993 Added GKST04 and diagonal 1 in correlation matrix
C           21/04/1993 Altered KMVMAX to calculate both possible Km values
C           14/06/1993 RESFIL
C           03/06/1994 DBOS version
C           22/02/1995 Version for Salamanca
C           30/10/1995 Split code and transformed to nag mark 16
C           25/09/1997 win32 version ... using QNFIT1/LBFGS
C                      COMMON block now only used for model
C           20/03/1998 Added GOGOGO and NEW
C           07/08/1998 added dllchk
C           03/10/1998 FTN95 version
C           14/12/1998 replaced TUTORS by TUTOR1
C           19/08/1999 revised control
C           13/09/1999 added call to WINDOW
C           05/12/1999 increased dimension LW1
C           14/02/2000 added SIMVER
C           10/04/2001 revised
C           18/05/2001 added call to PCVTST
C           02/08/2005 increased DVER to *30 and added to call to ADVISE
C           25/10/2007 replaced COMMON by MODULE_SFFIT and edited for version 6 
C           26/11/2013 increased NGRAF to 200 and introduced TABLE6 to display results 
C           16/11/2023 added call to SV_SFFIT
C


      USE MODULE_SFFIT

      IMPLICIT   NONE
C
C Allocatable arrays
C
      INTEGER,          ALLOCATABLE :: INDX(:)
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:), E(:,:), F(:), FJACC(:,:),
     +                                 W3(:)
      LOGICAL,          ALLOCATABLE :: EQSAV(:)  
C
C Other declarations
C
      INTEGER    I, IOS, ITEMP, J 
      INTEGER    I_STATUS, I_LENGTH           
      INTEGER    NF, NIN, NN, NX, N2
      PARAMETER (NF = 4, NIN = 3, NN = 10, NX = NN + 2, N2 = 2)
      INTEGER    N0, N1, N10, LIW, LW1, LW2, LW3
      PARAMETER (N0 = 0, N1 = 1, N10 = 10,
     +           LIW = 3*NX,
     +           LW1 = 2*(2*N10*NX + 4*NX + 11*N10*N10 + 8*N10),
     +           LW2 = 3*NX)
      INTEGER    NGRAF, NHESS
      PARAMETER (NGRAF = 240, NHESS = NX + 1)
      INTEGER    INDEX(NX), ISTATE(NX), IW(LIW), NBD(NX)
      INTEGER    NPAR(NN), NUMBER(NN)
      INTEGER    IFAIL, ITYPE, MAXNUM, NBIG, NDOF, NFREE, NRAND,
     +           NSMALL, NSTART, NSTOP
      INTEGER    IERR, ISEND, NCOL, NROW
      DOUBLE PRECISION BL(NX), BU(NX), DIAGV(NX), ERR(NX), G(NX),
     +                 PAR(NX), S(NX), STORES(NX), TL(NX), TPER(NX),
     +                 TU(NX), X(NX), CORR(NX,NX), CV(NHESS,NHESS),
     +                 HESSEX(NHESS,NHESS), OLDK(NN), WSSQ(NN),
     +                 XGRAF(NGRAF), YGRAF(NGRAF), W1(LW1), W2(LW2), 
     +                 Z(2,LW2)
      DOUBLE PRECISION OBJFUN, SIGMA, TESTQ
      DOUBLE PRECISION XM, YB, YS
      DOUBLE PRECISION EPSI, RTOL
      DOUBLE PRECISION XVER, YVER
      CHARACTER  FNAME1*1024, FNAME2*1024, LINE*100, TITLE*80
      CHARACTER  COMMAND*30, DVER*30, PVER*15
      PARAMETER (PVER = 'w_sffit.exe')
      CHARACTER  BLANK*1, LETTER, PNAME*5
      PARAMETER (BLANK = ' ', PNAME = 'SFFIT')
      
      LOGICAL    FREE(NX), NOUT(10)
      LOGICAL    DOIT, ISTOP, JUMP, NEW, REPEET
      LOGICAL    EXTRA, FIRST
      LOGICAL    ABORT, ACTION, SHOW
      
      EXTERNAL   GOGOGO, PUTADV, POLBIN
      EXTERNAL   ADVISE, DATAIN, RANDOM, LINEAR, DATFIT, DATOUT, DETAIL
      EXTERNAL   G05CCF$
      EXTERNAL   DLLCHK, WINDOW, SIMVER, M_FITONE

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE, 
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

      ITEMP = COMMAND_ARGUMENT_COUNT()  
      IF (ITEMP.EQ.N1) THEN
         CALL GET_COMMAND_ARGUMENT (N1, COMMAND, I_LENGTH, I_STATUS)
         IF (I_LENGTH.GE.N1 .AND. I_STATUS.EQ.N0) THEN
C
C 29/10/2023
C Replaced non-integer characters by blanks to interpret '0' as 0 which causes trouble otherwise
C It appears that 'i' is passed by run_program and returned as such by command argument 
C retrieval and read accurately except for '0' which is not read as 0 even if the quotes are 
C removed. Is it being read as a C string terminator ? So 0 is changed to 11 to call sv_simstat. 
C         
            do i = 1, i_length
               letter = command(i:i)
               j = ichar(letter)
               if (j.lt.48 .or. j.gt.57) command(i:i) = blank
            enddo  
             
            READ (COMMAND,*,IOSTAT=IOS) I
             
            IF (IOS.EQ.N0) THEN
               IF (I.GE.N1 .AND. I.LE.N10) THEN
                  ITEMP = I
               ELSE
                  ITEMP = N0
               ENDIF
            ELSE
               ITEMP = N0
            ENDIF
         ELSE
            ITEMP = N0
         ENDIF      
      ENDIF
      IF (ITEMP.EQ.N0) THEN
         JUMP = .FALSE.
      ELSE
         JUMP = .TRUE.
      ENDIF

C
C Advise user
C
      EXTRA = .FALSE.
      FIRST  = .TRUE.
      IF (JUMP) THEN
        ISTOP = .FALSE.
      ELSE  
         CALL ADVISE (DVER,
     +                ISTOP, FIRST)
      ENDIF
      IF (ISTOP) THEN
         DOIT = .FALSE.
      ELSE
         DOIT = .TRUE.
C
C Initialise random number generator, filenames and extra
C
         CALL G05CCF$
         FNAME1 = BLANK
         FNAME2 = BLANK
         NCOL = 0
         NROW = 0
         NEW = .TRUE.
C
C Initialise output types
C nout(1) ... display analysis table
C nout(2) ... display starting estimates
C nout(3) ... display random search
C nout(4) ... plot    best fit curves
C nout(5) ... plot    residuals
C nout(6) ... display residuals table
C nout(7) ... file    residuals table
C nout(8) ... high precision convergence test
C nout(9) ... cooperativity analysis
C nout(10) ... save/test parameters/covariance-matrix
C
         NOUT(1) = .TRUE.
         NOUT(2) = .FALSE.
         NOUT(3) = .FALSE.
         NOUT(4) = .TRUE.
         NOUT(5) = .FALSE.
         NOUT(6) = .TRUE.
         NOUT(7) = .FALSE.
         NOUT(8) = .FALSE.
         NOUT(9) = .TRUE.
         NOUT(10) = .FALSE.
         NRAND = N1 
         NSTART = N2
         NSTOP = N2
      ENDIF
      IF (JUMP) NOUT(9) = .FALSE.
C
C Branch point for repeated analysis
C
      IF (DOIT) THEN
         REPEET = .TRUE.
         DO WHILE (REPEET)
C
C read in and check a new data set
C
              IF (NEW) THEN
C
C Get a new data file
C              
               ISEND = 11
               CALL M_FITONE (ISEND, NCOL, NIN, NROW,
     +                        FNAME1, TITLE) 
               IF (NCOL.GE.2 .AND. NCOL.LE.3 .AND. NROW.GT.1) THEN
                  NPTS = NROW
                  NMAX = MAX(NPTS,NGRAF)
                  ISTOP = .FALSE.
                  NEW = .FALSE.
                  IERR = 0
                  IF (ALLOCATED(INDX)) DEALLOCATE(INDX, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(ERRY)) DEALLOCATE(ERRY, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(THEORY)) DEALLOCATE(THEORY, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(XVAL)) DEALLOCATE(XVAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(YVAL)) DEALLOCATE(YVAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(EQUAL)) DEALLOCATE(EQUAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT 
                  IF (ALLOCATED(EQSAV)) DEALLOCATE(EQSAV, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                                   
                  ALLOCATE(INDX(NMAX + NX), STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  ALLOCATE(ERRY(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  ALLOCATE(THEORY(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(XVAL(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(YVAL(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(EQUAL(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  ALLOCATE(EQSAV(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT    

                  IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(E)) DEALLOCATE(E, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(F)) DEALLOCATE(F, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(FJACC)) DEALLOCATE(FJACC, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(W3)) DEALLOCATE(W3, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(EQSAV)) DEALLOCATE(EQSAV, STAT = IERR)
                  IF (IERR.NE.0) EXIT

                  ALLOCATE(A(NMAX,NX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(E(NX,NMAX + NX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(F(NMAX + NX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(FJACC(NMAX,NX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(EQSAV(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT

                  LW3 = 3*NMAX + 8*NX + NX*NX + (NX + 1)*(NX + 2)/2
                  ALLOCATE(W3(LW3), STAT = IERR)
                  IF (IERR.NE.0) EXIT
               ELSE
                  ISTOP = .TRUE.
               ENDIF                      
            ENDIF  
C
C Initialise the data 
C            
            IF (.NOT.ISTOP) THEN
               CALL DATAIN (NF, NIN, NMAX, NPTS,
     +                      EPSI, ERRY, RTOL, XM, XVAL, YVAL,
     +                      FNAME1, FNAME2,
     +                      EQUAL, ISTOP, JUMP, NEW)
            ENDIF
            IF (ISTOP) THEN
               FNAME1 = BLANK
               DOIT = .FALSE.
            ELSE
               DOIT = .TRUE.
C
C Fix details of program operation
C
               CALL DETAIL (ITYPE, MAXNUM, NBIG, NF, NN, NPTS, NRAND,
     +                      NSMALL, NSTART, NSTOP,
     +                      OLDK, RTOL, SIGMA, XM, XVAL, YB, YS, YVAL,
     +                      EQUAL, ISTOP, JUMP, NOUT, YSCALE)
               IF (ISTOP) THEN
                  DOIT = .FALSE.
               ELSE
                  DOIT = .TRUE.
               ENDIF
            ENDIF
C
C Main loop over model orders
C
            IF (DOIT) THEN
               DO ITIME = NSTART, NSTOP
C
C random search for starting estimates
C
                  CALL RANDOM (ISTATE, ITIME, MAXNUM, MFAST, NBIG, NDOF,
     +                         NF, NFAST, NN, NPAR, NPTS, NRAND, NSMALL,
     +                         NUMBER, NX,
     +                         DOFDOM, FACT, REELN, SIGMA, STORES,
     +                         TESTQ, X, YB, YS,
     +                         ISTOP, NOUT, YSCALE)
C
C Overdetermined L1 fit
C
                  CALL LINEAR (INDX, ITIME, LW3, MFAST, NF, NFAST, NMAX,
     +                         NN, NPTS, NRAND, NX,
     +                         A, DOFDOM, E, ERRY, F, FACT, OLDK, REELN,
     +                         S, STORES, TESTQ, THEORY, W3, X, XVAL,
     +                         YB, YS, YVAL,
     +                         ISTOP, NOUT)
C
C Curve fitting
C
                  CALL DATFIT (ISTATE, ITIME, IW, LIW, LW1, LW2, MFAST,
     +                         NBD, NDOF, NF, NN, NPAR, NPTS, NRAND, NX,
     +                         BL, BU, DOFDOM, EPSI, FACT, G, OBJFUN,
     +                         OLDK, WSSQ, W1, W2, X,
     +                         ISTOP, JUMP, NOUT, YSCALE)
C
C Output the results
C
                  CALL DATOUT (INDEX, ISTATE, ITIME, LW2, LW3, NDOF, NF,
     +                         NFREE, NGRAF, NHESS, NMAX, NN, NPAR,
     +                         NPTS, NSTART, NUMBER, NX,
     +                         CORR, CV, DIAGV, ERR, ERRY, FACT, FJACC,
     +                         G, HESSEX, OBJFUN, OLDK, PAR, RTOL,
     +                         THEORY, TL, TPER, TU, W3, WSSQ, W2, X,
     +                         XGRAF, XM, XVAL, YGRAF, YVAL,
     +                         EQSAV, EQUAL, FREE, ISTOP, NOUT, YSCALE)
                      
                  IF (ITIME.GT.1 .AND. NOUT(9)) THEN
                     DO I = 1, NPTS
                        XVAL(I) = XM*XVAL(I)
                     ENDDO   
                     CALL POLBIN (IFAIL, NF, NGRAF, LW2, ITIME, NPTS,
     +                            W1, PAR, W3, XGRAF, XVAL(NPTS),
     +                            XVAL(1), YGRAF,
     +                            Z, XVAL, YVAL)
                     DO I = 1, NPTS
                        XVAL(I) = XVAL(I)/XM
                     ENDDO   
                 ENDIF
                 IF (ITIME.GT.1 .AND. FNAME2.NE.BLANK .AND. .NOT.ISTOP)
     +                EXTRA = .TRUE.
               ENDDO
            ENDIF
C
C Another go ?
C
            CALL GOGOGO (NF,
     +                   FNAME1, FNAME2, PNAME, 
     +                   ISTOP, NEW)
            IF (ISTOP) THEN
               REPEET = .FALSE.
            ELSE
               REPEET = .TRUE.
            ENDIF
         ENDDO
      ENDIF
C
C Extra advice if required then terminate program
C
      IF (EXTRA .AND. .NOT.JUMP) THEN
         WRITE (LINE,100)
         CALL PUTADV (LINE)
      ENDIF


C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C

      CLOSE (UNIT = NF)
  100 FORMAT ('Extra details have been added to the results file')
      END
C
C
