C
C SFFIT1.FOR: include code for SFFIT
C ==========
C
C ADVISE
C DATAIN
C DATFIT
C DATOUT
C
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user of SFFIT
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (IN)  :: FIRST 
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_SFFIT
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_SFFIT ('sffit')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `SFFIT'
     +/'        `      '
     +/'Action  `Best fit cooperative ligand binding function for n'
     +/'        `sites using constrained, weighted least squares.'
     +/'        `Scaling and baseline parameters can be estimated.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE DATAIN (NF, NIN, NMAX, NPTS,
     +                   EPSI, ERRY, RTOL, XM, XVAL, YVAL,
     +                   FNAME1, FNAME2,
     +                   EQUAL, ISTOP, JUMP, NEW)
C
C Read X, Y, ERROR, NPTS, Calculate XM
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NF, NIN, NMAX
      INTEGER,             INTENT (INOUT) :: NPTS
      DOUBLE PRECISION,    INTENT (OUT)   :: EPSI, RTOL
      DOUBLE PRECISION,    INTENT (OUT)   :: ERRY(NMAX), XM, XVAL(NMAX),
     +                                       YVAL(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME1, FNAME2
      LOGICAL,             INTENT (IN)    :: JUMP, NEW
      LOGICAL,             INTENT (OUT)   :: EQUAL(NMAX), ISTOP
C
C Locals
C      
      INTEGER    I, ICOUNT
      DOUBLE PRECISION XT
      DOUBLE PRECISION ZERO, FIVE
      PARAMETER (ZERO = 0.0D+00, FIVE = 5.0D+00)
      DOUBLE PRECISION X02AJF$, X02AMF$
      CHARACTER  TITLE*80
      CHARACTER  LINE*100
      CHARACTER (LEN = 80) TRIM80, WORD80
      EXTERNAL   X02AMF$, X02AJF$
      EXTERNAL   DATFIL, DATCHK, PUTFAT, RESFIL, DATSXY, TRIM80
      SAVE ICOUNT
      DATA ICOUNT / 0 /
C
C Assign EPSI and RTOL
C
      EPSI = X02AJF$()
      RTOL = 1.0D+09*X02AMF$()
C
C Read in and check data
C
      IF (NEW) THEN
         CLOSE (UNIT = NIN)
         CALL DATFIL (NIN, NMAX, NPTS,
     +                ERRY, XVAL, YVAL,
     +                FNAME1, TITLE,
     +                ISTOP)
         CLOSE (UNIT = NIN)
         IF (ISTOP) RETURN
      ELSE
         CLOSE (UNIT = NIN)
         CALL DATSXY (NIN, NMAX, NPTS,
     +                ERRY, XVAL, YVAL,
     +                FNAME1, TITLE,
     +                ISTOP)
         CLOSE (UNIT = NIN)
         IF (ISTOP) RETURN
      ENDIF
      CALL DATCHK (NPTS,
     +             ERRY, XVAL, YVAL,
     +             ISTOP)
      IF (ISTOP) RETURN
C
C Further checks on input data and calculate YT
C
      IF (NPTS.LT.3) THEN
         CALL PUTFAT ('Must be at least 3 x-values')
         ISTOP = .TRUE.
         RETURN
      ENDIF
      DO I = 1, NPTS
         IF (XVAL(I).LT.ZERO .OR. YVAL(I).LT.ZERO) THEN
             WRITE (LINE,100) I
             CALL PUTFAT (LINE)
             ISTOP = .TRUE.
             RETURN
         ENDIF
      ENDDO
      XT = XVAL(1)
      EQUAL(1) = .FALSE.
      DO I = 2, NPTS
         IF (XVAL(I).GT.XT) XT = XVAL(I)
         IF (XVAL(I).GT.XVAL(I - 1) .OR. XVAL(I).LT.XVAL(I - 1)) THEN
            EQUAL(I) = .FALSE.
         ELSE
            EQUAL(I) = .TRUE.
         ENDIF
      ENDDO
      XM = XT/FIVE
C
C Open output file for results and write out program declaration
C
      IF (ICOUNT.EQ.0) THEN
         CALL RESFIL (NF,
     +                FNAME2,
     +                ISTOP)
         IF (ISTOP) RETURN
         IF (JUMP) THEN  
            WRITE (NF,150)
         ELSE
            WRITE (NF,200)
         ENDIF      
      ENDIF
      ICOUNT = ICOUNT + 1
      WORD80 = TRIM80(FNAME1)
      WRITE (NF,300) ICOUNT, WORD80, TITLE
C
C Transform XVAL
C
      DO I = 1, NPTS
         XVAL(I) = XVAL(I)/XM
      ENDDO
C
C Format statements
C      
  100 FORMAT ('x or y < 0 at data point',I6,' ... Must be > 0')
  150 FORMAT (/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : SV_SFFIT'
     +/1X,'ACTION  : Fit cooperative ligand binding functions'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
  200 FORMAT (/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : SFFIT'
     +/1X,'ACTION  : Fit cooperative ligand binding functions'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
  300 FORMAT (/1X,'Analysis number',I3
     +/1X,'------------------'
     +/1X,'File name'/1X,A/1X,'Data title'/1X,A)
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE DATFIT (ISTATE, ITIME, IW, LIW, LW1, LW2, MFAST, NBD,
     +                   NDOF, NF, NN, NPAR, NPTS, NRAND, NX,
     +                   BL, BU, DOFDOM, EPSI, FACT, G, OBJFUN, OLDK,
     +                   WSSQ, W1, W2, X,
     +                   ISTOP, JUMP, NOUT, YSCALE)
C
C Curve fitting by quasi-Newton routine QNFIT1/LBFGS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: LIW, LW1, LW2, NN, NX
      INTEGER,          INTENT (IN)    :: ITIME, MFAST, NDOF, NF, NPTS,
     +                                    NRAND
      INTEGER,          INTENT (OUT)   :: ISTATE(NX), IW(LIW),  NBD(NX) 
      INTEGER,          INTENT (INOUT) :: NPAR(NN)
      DOUBLE PRECISION, INTENT (IN)    :: DOFDOM, EPSI
      DOUBLE PRECISION, INTENT (INOUT) :: FACT(NX), OLDK(NN), WSSQ(NN)
      DOUBLE PRECISION, INTENT (OUT)   :: BL(NX), BU(NX), G(NX), OBJFUN,
     +                                    W1(LW1), W2(LW2), X(NX)
      LOGICAL,          INTENT (IN)    :: ISTOP, JUMP, NOUT(10),
     +                                    YSCALE(2)
C
C Locals
C      
      INTEGER    I, IFAIL, N
      DOUBLE PRECISION BLMIN, BUMAX, FMIN, ZERO, ONE
      PARAMETER (BLMIN = 1.0D-10, BUMAX = 1.0D+08, FMIN = 1.0D-10,
     +           ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION F
      EXTERNAL   DERIV1, DERIV2, FUNCT1, QNFIT1
      EXTERNAL   PARAMS, ZMOD
      EXTERNAL   CHECKW, PUTIFA
      INTRINSIC  ABS
      IF (ISTOP) RETURN
C
C Set up parameters for curve-fitting
C
      N = NPAR(ITIME)
      DO I = 1, N
         NBD(I) = 1
         BL(I) = BLMIN
         BU(I) = BUMAX
         X(I) = ONE
         ISTATE(I) = 1
         IF (NRAND.EQ.4) FACT(I) = ONE
         IF (FACT(I).LT.FMIN) FACT(I) = FMIN
      ENDDO
      IF (.NOT.YSCALE(1)) THEN
         NBD(MFAST) = 2
         BL(MFAST) = ONE
         BU(MFAST) = ONE
         FACT(MFAST) = ONE
         ISTATE(MFAST) = 0
      ENDIF
      IF (YSCALE(2)) THEN
         NBD(N) = 2
         BL(N) = - BUMAX
      ELSE
        NBD(N) = 2
        BL(N) = ZERO
        BU(N) = ZERO
        FACT(N) = ONE
        X(N) = ZERO
        ISTATE(N) = 0
      ENDIF
      CALL PARAMS (N, NF, NRAND, 
     +             FACT, OLDK, X,
     +             NOUT(2), YSCALE)
      CALL FUNCT1 (N,
     +             X, F)
      WSSQ(ITIME) = DOFDOM*F
      CALL CHECKW (NDOF,
     +             WSSQ(ITIME))
C
C Entry to curve-fitting routine
C The next code uses NOUT(8) for optimisation type
C
      IF (JUMP) THEN
         IFAIL = 0
      ELSE    
         IF (NOUT(8)) THEN
            CALL QNFIT1 (DERIV2, FUNCT1,
     +                   IFAIL, IW, LIW, LW1, LW2, N, NBD, NF, NPTS,
     +                   BL, BU, F, G, W1, W2, X,
     +                   'exact', 'high')
         ELSE
            CALL QNFIT1 (DERIV1, FUNCT1,
     +                   IFAIL, IW, LIW, LW1, LW2, N, NBD, NF, NPTS,
     +                   BL, BU, F, G, W1, W2, X,
     +                   'approximate', 'medium')
         ENDIF
      ENDIF
      OBJFUN = F
      WSSQ(ITIME) = DOFDOM*OBJFUN

C
C Call ZMOD to make sure THEORY is defined correctly then check IFAIL
C
      CALL ZMOD (X)
      IF (IFAIL.NE.0 .AND. IFAIL.NE.1 .AND. IFAIL.NE.2)
     +   CALL PUTIFA (IFAIL, NF, 'QNFIT1/DATFIT')
      DO I = 1, N
         IF (ISTATE(I).NE.0) THEN
            IF (ABS(X(I) - BL(I)).LE.EPSI) ISTATE(I) = - 2
            IF (ABS(X(I) - BU(I)).LE.EPSI) ISTATE(I) = - 1
         ENDIF
      ENDDO
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE DATOUT (INDEX, ISTATE, ITIME, LW2, LW3, NDOF, NF,
     +                   NFREE, NGRAF, NHESS, NMAX, NN, NPAR, NPTS,
     +                   NSTART, NUMBER, NX,
     +                   CORR, CV, DIAGV, ERR, ERRY, FACT, FJACC, G,
     +                   HESSEX, OBJFUN, OLDK, PAR, RTOL, THEORY, TL,
     +                   TPER, TU, W, WSSQ, W2, X, XGRAF, XM, XVAL,
     +                   YGRAF, YVAL,
     +                   EQSAV, EQUAL, FREE, ISTOP, NOUT, YSCALE)
C
C Output printed or written to a file
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: LW2, LW3, NGRAF, NHESS, NMAX,
     +                                    NN, NX
      INTEGER,          INTENT (IN)    :: ISTATE(NX), ITIME, NDOF, NF,
     +                                    NPAR(NN), NSTART, NUMBER(NN)
      INTEGER,          INTENT (OUT)   :: INDEX(NX), NFREE
      INTEGER,          INTENT (INOUT) :: NPTS 
      DOUBLE PRECISION, INTENT (IN)    :: FACT(NX), OBJFUN, OLDK(NN),
     +                                    RTOL, XM
      DOUBLE PRECISION, INTENT (INOUT) :: ERRY(NMAX), THEORY(NMAX), 
     +                                    WSSQ(NN), X(NX), XGRAF(NGRAF),
     +                                    XVAL(NMAX), YGRAF(NGRAF),
     +                                    YVAL(NMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: CORR(NX,NX), CV(NHESS,NHESS),
     +                                    DIAGV(NX), ERR(NX),
     +                                    FJACC(NMAX,NX), G(NX),
     +                                    HESSEX(NHESS,NHESS), 
     +                                    PAR(NN), TL(NX), TPER(NX), 
     +                                    TU(NX), W(LW3), W2(LW2)
      LOGICAL,         INTENT (IN)    :: ISTOP, NOUT(10), YSCALE(2)
      LOGICAL,         INTENT (INOUT) :: EQUAL(NMAX)
      LOGICAL,         INTENT (OUT)   :: EQSAV(NMAX), FREE(NX)
C
C Locals
C     
      INTEGER    L0, L1, L2, L3, L14
      PARAMETER (L0 = 0, L1 = 1, L2 = 2, L3 = 3, L14 = 5)
      INTEGER    I, IFAIL, ITP1, ITP2, J, MTRY, NSAV, NTRY
      INTEGER    NP1, NP2
      INTEGER    JCOLOR(50)
      INTEGER    NTEXT
      DOUBLE PRECISION PNT05, PNT975
      PARAMETER (PNT05 = 0.05D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION VMAX, XFIRST, XLAST, XTRY, YTRY
      DOUBLE PRECISION ALPHA, TSTAT
      DOUBLE PRECISION G01EBF$, G01FBF$
      DOUBLE PRECISION XTEMP1(L2), XTEMP2(L2), YTEMP1(L2), YTEMP2(L2)
      DOUBLE PRECISION ZERO, ONE, TWO, F100
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           F100 = 100.0D+00)
      CHARACTER (LEN = 13) D13(4), SHOWRJ 
      CHARACTER  BLANK2*2, FIXED*2, STAR*2
      PARAMETER (BLANK2 = '  ', FIXED = ' f', STAR = ' *')
      CHARACTER  CHAR(20,20)*8, SYMBOL(20)*2
      CHARACTER  PTITLE*37, XTITLE*1, YTITLE*1
      CHARACTER  TEMP(30)*100, TEXT(50)*100, TITLE(4)*80
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   G01EBF$, G01FBF$
      EXTERNAL   KMVMAX, SWAPKS, ZMOD
      EXTERNAL   PUTIFA, GKSR01, FTESTS, DIVIDE, GKST04, TABLE6, FUNCT1,
     +           QNCOV1, PCVTST
      INTRINSIC  SQRT, ABS, DBLE
      IF (ISTOP) RETURN
      E_NUMBERS = E_FORMATS()  
C
C Estimate covariance matrix and parameter standard errors
C
      ITP1 = ITIME + 1
      ITP2 = ITIME + 2
C
C Calculate covariance matrix and parameter standard errors
C
      CALL QNCOV1 (FUNCT1,
     +             INDEX, ISTATE, NF, NFREE, NHESS, NMAX, NPAR(ITIME),
     +             NPTS, NX,
     +             CORR, CV, DIAGV, ERRY, FACT, FJACC, G, HESSEX,
     +             OBJFUN, W2, X, XVAL, YVAL, THEORY,
     +             EQUAL, FREE)
      IFAIL = 1
      TSTAT = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
      CALL PUTIFA (IFAIL, NF, 'G01FBF/DATOUT')
      DO I = 1, ITIME
         PAR(I) = FACT(I)*OLDK(I)*X(I)
         ERR(I) = OLDK(I)*SQRT(ABS(DIAGV(I)))
         TL(I) = PAR(I) - TSTAT*ERR(I)
         TU(I) = PAR(I) + TSTAT*ERR(I)
      ENDDO
      DO I = ITP1, ITP2
         PAR(I) = FACT(I)*X(I)
         ERR(I) = SQRT(ABS(DIAGV(I)))
         TL(I) = PAR(I) - TSTAT*ERR(I)
         TU(I) = PAR(I) + TSTAT*ERR(I)
      ENDDO
      DO I = 1, NPAR(ITIME)
         TPER(I) = ONE
         IF (ISTATE(I).GT.0) THEN
            TPER(I) = ZERO
            IF (ERR(I).GT.RTOL) THEN
               IFAIL = 1
               ALPHA = ONE - G01EBF$('Lower-tail', ABS(PAR(I)/ERR(I)),
     +                               DBLE(NDOF), IFAIL)
               CALL PUTIFA (IFAIL, NF, 'G01EBF/DATOUT')
               TPER(I) = TWO*ALPHA
            ENDIF
            IF (TPER(I).GT.PNT05) THEN
               SYMBOL(I) = STAR
            ELSE
               SYMBOL(I) = BLANK2
            ENDIF
         ELSE 
            SYMBOL(I) = FIXED  
         ENDIF
      ENDDO
      IF (.NOT.YSCALE(1)) SYMBOL(ITP1) = FIXED
      IF (.NOT.YSCALE(2)) SYMBOL(ITP2) = FIXED
C
C Output best-fit parameters
C
      DO I = 1, 50
         JCOLOR(I) = 0
      ENDDO   
      WRITE (NF,100) ITIME
      IF (E_NUMBERS) THEN
         WRITE (NF,200) (I, I, PAR(I), ERR(I), TL(I), TU(I), TPER(I),
     +                   SYMBOL(I), I = 1, ITIME)
      ELSE
         DO I = 1, ITIME  
            D13(1) = SHOWRJ(PAR(I))
            D13(2) = SHOWRJ(ERR(I))
            D13(3) = SHOWRJ(TL(I))
            D13(4) = SHOWRJ(TU(I))
            WRITE (NF,250) I, I, D13(1), D13(2), D13(3), D13(4),
     +                     TPER(I), SYMBOL(I)
         ENDDO
      ENDIF 
      IF (E_NUMBERS) THEN 
         WRITE (NF,300)  ITP1, PAR(ITP1), ERR(ITP1), TL(ITP1), TU(ITP1),
     +                   TPER(ITP1), SYMBOL(ITP1)
      ELSE
         D13(1) = SHOWRJ(PAR(ITP1))
         D13(2) = SHOWRJ(ERR(ITP1))
         D13(3) = SHOWRJ(TL(ITP1))
         D13(4) = SHOWRJ(TU(ITP1))
         WRITE (NF,350)  ITP1, D13(1), D13(2), D13(3), D13(4),
     +                   TPER(ITP1), SYMBOL(ITP1)
      ENDIF  
      IF (E_NUMBERS) THEN
         WRITE (NF,400)  ITP2, PAR(ITP2), ERR(ITP2), TL(ITP2), TU(ITP2),
     +                   TPER(ITP2), SYMBOL(ITP2)
      ELSE
         D13(1) = SHOWRJ(PAR(ITP2))
         D13(2) = SHOWRJ(ERR(ITP2))
         D13(3) = SHOWRJ(TL(ITP2))
         D13(4) = SHOWRJ(TU(ITP2))
         WRITE (NF,450)  ITP2, D13(1), D13(2), D13(3), D13(4),
     +                   TPER(ITP2), SYMBOL(ITP2)

      ENDIF  
      WRITE (TITLE,100) ITIME
      IF (E_NUMBERS) THEN
         WRITE (TEMP,200) (I, I, PAR(I), ERR(I), TL(I), TU(I), TPER(I),
     +                     SYMBOL(I), I = 1, ITIME)
      ELSE
         DO I = 1, ITIME
            D13(1) = SHOWRJ(PAR(I))
            D13(2) = SHOWRJ(ERR(I))
            D13(3) = SHOWRJ(TL(I))
            D13(4) = SHOWRJ(TU(I))
            WRITE (TEMP(I),250) I, I, D13(1), D13(2), D13(3), D13(4),
     +                          TPER(I), SYMBOL(I)  
         ENDDO
      ENDIF  
      NTEXT = 0
      DO I = 1, 4
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = TITLE(I)
      ENDDO
      JCOLOR(NTEXT) = 4   
      DO I = 1, ITIME
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = TEMP(I)
      ENDDO
      NTEXT = NTEXT + 1
      IF (E_NUMBERS) THEN
         WRITE (TEXT(NTEXT),300) ITP1, PAR(ITP1), ERR(ITP1), TL(ITP1),
     +                           TU(ITP1), TPER(ITP1), SYMBOL(ITP1)
      ELSE
         D13(1) = SHOWRJ(PAR(ITP1))
         D13(2) = SHOWRJ(ERR(ITP1))
         D13(3) = SHOWRJ(TL(ITP1))
         D13(4) = SHOWRJ(TU(ITP1))
         WRITE (TEXT(NTEXT),350) ITP1, D13(1), D13(2), D13(3), D13(4),
     +                           TPER(ITP1), SYMBOL(ITP1)
      ENDIF  
      NTEXT = NTEXT + 1
      IF (E_NUMBERS) THEN
         WRITE (TEXT(NTEXT),400) ITP2, PAR(ITP2), ERR(ITP2), TL(ITP2),
     +                           TU(ITP2), TPER(ITP2), SYMBOL(ITP2)
      ELSE
         D13(1) = SHOWRJ(PAR(ITP2))
         D13(2) = SHOWRJ(ERR(ITP2))
         D13(3) = SHOWRJ(TL(ITP2))
         D13(4) = SHOWRJ(TU(ITP2))
         WRITE (TEXT(NTEXT),450) ITP2, D13(1), D13(2), D13(3), D13(4),
     +                           TPER(ITP2), SYMBOL(ITP2)
      ENDIF  
      MTRY = ITIME
      NTRY = NPAR(ITIME)
      XTRY = ZERO
      YTRY = F100*XVAL(NPTS)*XM
      CALL KMVMAX (MTRY, NTRY, NF, I, PAR, VMAX, XTRY, YTRY, TEMP)
      IF (I.GT.0) THEN
         DO J = 1, I
            NTEXT = NTEXT + 1
            TEXT(NTEXT) = TEMP(J)
         ENDDO
      ENDIF
      IF (NFREE.GT.1) THEN
         WRITE (NF,500)
         DO I = 1, NPAR(ITIME)
            DO J = 1, I
               IF (FREE(I) .AND. FREE(J)) THEN
                  WRITE (CHAR(I,J),600) CORR(I,J)
               ELSE
                  WRITE (CHAR(I,J),700) FIXED
               ENDIF
            ENDDO
         ENDDO
         DO I = 1, NPAR(ITIME)
             WRITE (NF,800) (CHAR(I,J), J = 1, I)
         ENDDO
         IF (NOUT(1)) THEN
            WRITE (TEMP,500)
            DO I = 1, 2
               NTEXT = NTEXT + 1
               TEXT(NTEXT) = TEMP(I)
            ENDDO
            JCOLOR(NTEXT) = 4   
            DO I = 1, NPAR(ITIME)
               NTEXT = NTEXT + 1
               WRITE (TEXT(NTEXT),800) (CHAR(I,J), J = 1, I)
            ENDDO
         ENDIF
      ENDIF
      CALL TABLE6 (JCOLOR, NTEXT,
     +             TEXT)       

C
C First call ZMOD to make sure THEORY is defined properly then define
C
C W(        1 -->  NPTS) = OLDX
C W( NPTS + 1 --> 2NPTS) = RESID
C W(2NPTS + 1 --> 3NPTS) = WRESID
C
C Then call GKSR01, FTESTS
C
      CALL ZMOD (X)
      DO I = 1, NPTS
         W(I) = XVAL(I)*XM
      ENDDO
      NP1 = NPTS + 1
      NP2 = 2*NPTS + 1
      CALL GKSR01 (NF, NUMBER(ITIME), NPTS,
     +             W(NP1), ERRY, THEORY, W(NP2), W(1), YVAL,
     +             NOUT(7), SAVEIT, NOUT(5), NOUT(6), NOUT(1))
      IF (ITIME.GT.NSTART) THEN
         CALL FTESTS (NUMBER(ITIME - 1), NUMBER(ITIME), NF, NPTS,
     +                WSSQ(ITIME - 1), WSSQ(ITIME), SAVEIT, NOUT(1))
      ENDIF
C
C Graphs of best-fit curves if required after defining W as follows:-
C
C W(        1 -->  NPTS) = OLDX (X in old coordinates)
C W( NPTS + 1 --> 2NPTS) = XSAV (X in new coordinates)
C W(2NPTS + 1 --> 3NPTS) = ZSAV (Actual theory)
C
      IF (NOUT(4)) THEN
         DO I = 1, NPTS
            EQSAV(I) = EQUAL(I)
            W(NPTS + I) = XVAL(I)
            W(NP2 + I - 1) = THEORY(I)
         ENDDO
         EQUAL(1) = .FALSE.
         XFIRST = XVAL(1)
         XLAST = XVAL(NPTS)
         CALL DIVIDE (NGRAF,
     +                XVAL, XFIRST, XLAST)
         DO I = 1, NGRAF
            EQUAL(I) = .FALSE.
         ENDDO
         NSAV = NPTS
         NPTS = NGRAF
         CALL ZMOD (X)
         NPTS = NSAV
         DO I = 1, NGRAF
            XVAL(I) = XM*XVAL(I)
         ENDDO
         DO I = 1, L2
            XTEMP1(I) = ONE
            XTEMP2(I) = ONE
            YTEMP1(I) = ONE
            YTEMP2(I) = ONE
         ENDDO
         XTITLE = 'x'
         YTITLE = 'y'
         IF (ITIME.EQ.NSTART) THEN
            PTITLE = 'Experimental Data and Best-Fit Curve'
            CALL GKST04 (L0, L1, L0, L0,
     +                   L14, L0, L0, L0,
     +                   NPTS, NGRAF, L2, L2,
     +                   VMAX,
     +                   W, XVAL, XTEMP1, XTEMP2, 
     +                   YVAL, THEORY, YTEMP1, YTEMP2,
     +                   PTITLE, XTITLE, YTITLE,
     +                   SAVEIT, SAVEIT)
         ELSE
            PTITLE = 'Data, Best-Fit Curve and Previous Fit'
            CALL GKST04 (L0, L1, L3, L0,
     +                   L14, L0, L0, L0,
     +                   NPTS, NGRAF, NGRAF, L2,
     +                   VMAX,
     +                   W, XVAL, XGRAF, XTEMP1,
     +                   YVAL, THEORY, YGRAF, YTEMP1,
     +                   PTITLE, XTITLE, YTITLE, 
     +                   SAVEIT, SAVEIT)
         ENDIF
C
C Save best-fit curve and restore data
C
         DO I = 1, NGRAF
            XGRAF(I) = XVAL(I)
            YGRAF(I) = THEORY(I)
         ENDDO
         DO I = 1, NPTS
            EQUAL(I) = EQSAV(I)
            XVAL(I) = W(NPTS + I)
            THEORY(I) = W(NP2 + I - 1)
         ENDDO
      ENDIF
C
C Call PCVTST   
C
      IF (NOUT(10)) THEN
         I = 1
         J = NPAR(ITIME)
         CALL PCVTST (I, NF, J, NPTS, NHESS,
     +                CV, PAR)
      ENDIF
      CALL SWAPKS (ITIME, NF,
     +             PAR)      
C
C Format statements
C
  100 FORMAT (
     +/1X,'For best-fit order',I2,' function (f = fixed parameter)'
     +/
     +/1X,'Number Parameter       Value     Std.Error    Lower95%cl   ',
     +' Upper95%cl',4X,'p')
  200 FORMAT (1X,I2,7X,'K(',I1,')',1X,1P,E14.5,3E14.5,0P,F8.4,1X,A)
  250 FORMAT (1X,I2,7X,'K(',I1,')',1X,4(1X,A13),F8.4,1X,A)
  300 FORMAT (1X,I2,9X,'Z',        2X,1P,E14.5,3E14.5,0P,F8.4,1X,A)
  350 FORMAT (1X,I2,9X,'Z',        2X,4(1X,A13),F8.4,1X,A)
  400 FORMAT (1X,I2,9X,'C',        2X,1P,E14.5,3E14.5,0P,F8.4,1X,A)
  450 FORMAT (1X,I2,9X,'C',        2X,4(1X,A13),F8.4,1X,A)
  500 FORMAT (
     +/1X,'Parameter correlation matrix (f = fixed parameter)')
  600 FORMAT (F8.4)
  700 FORMAT ('  ',A2,'  ')
  800 FORMAT (12A8)
      END
C
C
