C
C SFFIT2.FOR: Include code for SFFIT
C ==========
C
C DERIV1
C DERIV2
C DETAIL
C FUNCT1
C KMVMAX
C
C
C
      subroutine deriv1 (funct, n, g, w, x)
c
c action : finite difference approximation to derivatives using qngrd1
c
      implicit   none
c
c arguments
c      
      integer,          intent (in) :: n
      double precision, intent (inout) :: x(n)
      double precision, intent (out)   :: g(n), w(3*n)
c
c locals
c      
      integer    inform
      logical    tpoint
      parameter (tpoint = .false.)
      external   funct, qngrd1
      call qngrd1 (funct, inform, n, g, w, x, tpoint)
      end
C
C----------------------------------------------------------------------
C
CFTN95$OPTIONS (SILENT)
      SUBROUTINE DERIV2 (FUNCT, N, G, W, X)
C
C Saturation function with scaling factors if required
C

      USE MODULE_SFFIT, ONLY : ITIME, FACT, XVAL, ERRY, THEORY, YSCALE,
     +                         NPTS, REELN, DOFDOM, YVAL, MFAST, NFAST

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N
      DOUBLE PRECISION, INTENT (INOUT) :: X(N)
      DOUBLE PRECISION, INTENT (OUT)   :: G(N), W(3*N)
C
C Locals
C      
      INTEGER    NN, NX
      PARAMETER (NN = 10, NX = NN + 2)
      INTEGER    I, J
      DOUBLE PRECISION ASCALE, BOT, BOT2, T(NN), TERM, TOP, XI
      DOUBLE PRECISION A(NN), B(NN), C(NN)
      double precision f!to silence NAGfor
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      EXTERNAL FUNCT
      INTRINSIC DBLE
C
C==================================================================
C This subroutine will only work if THEORY is set correctly as in a
C previous call to QNFIT1 o/w FUNCT must be called at this point
C     CALL FUNCT (N, X, F)
      if (n.lt.0) call funct (n, x, f)!to silence NAGfor
      w(1) = zero  
C==================================================================
C
C
C Set A and B ... these must not then be subsequently changed
C
      DO I = 1, ITIME
         J = MFAST - I
         A(I) = FACT(J)*X(J)
         G(I) = ZERO
      ENDDO
      ASCALE = FACT(MFAST)*X(MFAST)/REELN
c      OSCALE = FACT(NFAST)*X(NFAST)!to silence NAGfor
      G(MFAST) = ZERO
      G(NFAST) = ZERO
      B(1) = A(1)
      C(1) = B(1)
C
C The main loop to build up derivatives
C
      DO I = 1, NPTS
C
C Calculate the monomials, numerator and denominator
C
         XI = XVAL(I)
         T(1) = XI
         IF (ITIME.GT.1) THEN
           DO J = 2, ITIME
               B(J) = B(J - 1)*XI + A(J)
               C(J) = C(J - 1)*XI + B(J)
               T(J) = XI*T(J - 1)
            ENDDO
         ENDIF
         BOT = B(ITIME)*XI + ONE
         BOT2 = BOT*BOT
         TOP = C(ITIME)*XI
C
C Now work out TERM
C
         TERM = (YVAL(I) - THEORY(I))/(ERRY(I)*ERRY(I))
C
C Derivatives for the K(i)
C
         DO J = 1, ITIME
            G(J) = G(J) +
     +      FACT(J)*T(J)*TERM*(DBLE(J)*BOT - TOP)/BOT2
         ENDDO
         IF (YSCALE(1))
     +       G(MFAST) = G(MFAST) + FACT(MFAST)*TERM*TOP/(REELN*BOT)
         IF (YSCALE(2))
     +       G(NFAST) = G(NFAST) + FACT(NFAST)*TERM
      ENDDO
C
C Now the final correction
C
      TERM = - TWO/DOFDOM
      DO I = 1, ITIME
         G(I) = ASCALE*TERM*G(I)
      ENDDO
      IF (YSCALE(1)) G(MFAST) = TERM*G(MFAST)
      IF (YSCALE(2)) G(NFAST) = TERM*G(NFAST)
      END
C
C--------------------------------------------------------------------------
C
      SUBROUTINE DETAIL (ITYPE, MAXNUM, NBIG, NF, NN, NPTS, NRAND,
     +                   NSMALL, NSTART, NSTOP,
     +                   OLDK, RTOL, SIGMA, XM, XVAL, YB, YS, YVAL,
     +                   EQUAL, ISTOP, JUMP, NOUT_IN, YSCALE)
C
C Read orders, scaling, output, set types
C 26/08/2017 new version derived from hlfit_detail 
C 13/02/2020 added switch_off
C 25/02/2022 always initialise OLDK(1) to OLDK(NN)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NF, NN, NPTS
      INTEGER,          INTENT (INOUT) :: ITYPE, MAXNUM, NBIG, NRAND,
     +                                    NSMALL, NSTART, NSTOP
      DOUBLE PRECISION, INTENT (IN)    :: RTOL, XM, XVAL(NPTS),
     +                                    YVAL(NPTS)    
      DOUBLE PRECISION, INTENT (INOUT) :: OLDK(NN), SIGMA, YB, YS
      LOGICAL,          INTENT (IN)    :: EQUAL(NPTS),JUMP  
      LOGICAL,          INTENT (INOUT) :: ISTOP, NOUT_IN(10), YSCALE(2)  
C
C locals
C        
      INTEGER    numopt1, ntext
      PARAMETER (numopt1 = 4, ntext = 22)     
      integer    numopt, numsta, numtxt, n1, n2
      parameter (numopt = 24, numsta = 1, numtxt = numopt, n1 = 1,
     +           n2 = 2)
      integer    i, icolor, ixl, iyl, j, kvalue(numopt),
     +           numbld(numopt), numpos(numopt), kvlim_1(numopt),
     +           kvlim_2(numopt)
      integer    nbold(30)
      integer    icolor1, ix, iy, klog, lstart, lshade
      parameter (icolor1 = 9, ix = 4, iy = 4, klog = 14, lstart = 19)
      parameter (icolor = 7, ixl = 0, iyl = 0, lshade = 0)
      double precision xvalue(numopt) 
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 100) svalue(numopt), text_in(numopt)
      character (len = 100) line, text(30)
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    cin, zin
      logical    nout(klog)
      logical    repeet, first_time
      logical    abort, first
      logical    switch_off
      logical    fixed, full, high
      parameter (fixed = .false., full = .true., high = .true.)
      LOGICAL    BORDER, FLASH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE.)      
      external   advise, get00x, putfat, lbox01, order  
      intrinsic  max, min 
      save       switch_off, first_time
      data       switch_off, first_time  / .false., .true. /
      data       nbold / 30*0 /
      data       numpos / numopt*0 /
C      
C initialise all elements of OLDK
C      
         OLDK(1) = 1.0D+00/XM
         DO I = 2, NN
            OLDK(I) = OLDK(I - 1)/XM
         ENDDO      
c
c check
c     
      if (switch_off) then 
C
C Still need to calculate YB and YS for starting estimates
C
         CALL ORDER (ITYPE, NF, NPTS,
     +               RTOL, XVAL, YB, YS, YVAL,
     +               EQUAL, ISTOP)
         return 
      endif  

      if (nstart.lt.1 .or. nstart.gt.nstop .or. nstop.gt.nn) then 
         call putfat (
     +'Must have 1 =< NSTART =< NSTOP =< NN in call to DETAIL')
         return
      endif 
      if (nrand.lt.1 .or. nrand.gt.4) then
         call putfat ('Must have 1 =< NRAND =< 4 in call to DETAIL')
         return
      endif  
C
C Include Z and C ?
C
      if (first_time) then
         first_time = .false.
         IF (JUMP) THEN
            ITYPE = 1
         ELSE   
            WRITE (TEXT,100)
            ITYPE = 1
            NBOLD(1) = 4
            CALL LBOX01 (ICOLOR1, IX, IY, LSHADE, NBOLD, ITYPE, NUMOPT1,
     +                   NUMPOS, LSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            NBOLD(1) = 0
         ENDIF   
         CIN = .FALSE.
         ZIN = .FALSE.
         IF (ITYPE.EQ.1) THEN
            YSCALE(1) = .FALSE.
            YSCALE(2) = .FALSE.
         ELSEIF (ITYPE.EQ.2) THEN
            ZIN = .TRUE.
            YSCALE(1) = .TRUE.
            YSCALE(2) = .FALSE.
         ELSEIF (ITYPE.EQ.3) THEN
            CIN = .TRUE.
            YSCALE(1) = .FALSE.
            YSCALE(2) = .TRUE.
         ELSE
            CIN = .TRUE.
            ZIN = .TRUE.
            YSCALE(1) = .TRUE.
            YSCALE(2) = .TRUE.
         ENDIF
      else
         zin = yscale(1)
         cin = yscale(2)    
      endif             
c
c initialise all local variables
c
      do i = 1, klog
         nout(i) = .false.
      enddo   
      do i = 1, 10
         nout(i) = nout_in(i)
      enddo
      nout(12) = zin
      nout(13) = cin
      do i = 1, numopt
         numbld(i) = 0
         numpos(i) = 0
         kvalue(i) = 0
         kvlim_1(i) = 0
         kvlim_2(i) = 0
         xvalue(i) = zero
         svalue(i) = blank
      enddo
c
c set parameters for nstart and nstop and default nrand
c      
      kvlim_1(2) = 1
      kvlim_2(2) = nn
      kvlim_1(3) = 1
      kvlim_2(3) = nn
      kvalue(2) = nstart
      kvalue(3) = nstop
      do i = 1, 4
         if (nrand.eq.i) kvalue(i + 4) = 1
      enddo
      kvalue(23) = 0
      kvalue(24) = 0
c
c create the text array
c      
      write (text_in,200) n2, nn
      numpos(1) = 8 
         numbld(1) = 1!blue text
      numpos(2) = 9
      numpos(3) = 9
      numpos(4) = 8
         numbld(4) = 1!blue text
      numpos(5) = 6
      numpos(6) = 6 
      numpos(7) = 6
      numpos(8) = 6
      numpos(9) = 8
         numbld(9) = 1!blue text
      numpos(10) = 4
      numpos(11) = 4
      numpos(12) = 4 
      numpos(13) = 4
      numpos(14) = 4
      numpos(15) = 4
      numpos(16) = 4
      numpos(17) = 4
      numpos(18) = 4
      numpos(19) = 4
      numpos(20) = 4
      numpos(21) = 4
      numpos(22) = 4
      numpos(23) = 4
      numpos(24) = 4
C
C set logical parameters
C nout(1)  ... display analysis table
C nout(2)  ... display starting estimates
C nout(3)  ... display random search
C nout(4)  ... plot    best fit curves
C nout(5)  ... plot    residuals
C nout(6)  ... display residuals table
C nout(7)  ... file    residuals table
C nout(8)  ... high precision convergence test
C nout(9)  ... cooperativity analysis
C nout(10) ... parameters and covariance matrix
C
C internally to set cin and zin
C
C nout(11) ... scaling factor Z
C nout(12) ... baseline correction C
C              help
C              quit
C
 
      j = 9
      do i = 1, 10
         j = j + 1
         if (nout(i)) kvalue(j) = 1
      enddo
      j = j + 1  
      nout(11) = zin
      if (nout(12)) kvalue(j) = 1
      j = j + 1  
      nout(12) = cin
      if (nout(13)) kvalue(j) = 1
C
C Calculate YB and YS for starting estimates
C
      CALL ORDER (ITYPE, NF, NPTS,
     +            RTOL, XVAL, YB, YS, YVAL,
     +            EQUAL, ISTOP)
      IF (ISTOP) RETURN
       
        
c
c loop over the options
c      
      repeet = .true.
      do while (repeet)
         kvalue(numopt - 1) = 0
         kvalue(numopt) = 0
         call get00x (icolor, ixl, iyl, kvalue, kvlim_1, kvlim_2, 
     +                lshade, numbld, numopt, numpos, numsta, numtxt,
     +                xvalue,
     +                svalue, text_in,
     +                fixed, full, high)
c
c define nstart, nstop
c     
         nstart = min(kvalue(2),kvalue(3))
         nstop = max(kvalue(2),kvalue(3))
c
c define nrand
c         
         j = 0
         do i = 5, 8
            j = j + 1
            if (kvalue(i).eq.1) then
               nrand = j
            endif
         enddo  
         IF (NRAND.EQ.1) THEN
            MAXNUM = 400
            NBIG = 10
            NSMALL = 1
            SIGMA = 0.5D+00
         ELSEIF (NRAND.EQ.2) THEN
            MAXNUM = 1000
            NBIG = 25
            NSMALL = 2
            SIGMA = 0.3D+00
         ELSEIF (NRAND.EQ.3) THEN
            MAXNUM = 2500
            NBIG = 50
            NSMALL = 4
            SIGMA = 0.125D+00  
         ENDIF 
c
c assign logical variables
c
         j = 9
         do i = 1, 12
            j = j + 1
            if (kvalue(j).eq.1) then
               nout(i) = .true.
            else
               nout(i) = .false.
            endif   
         enddo  
c
c check if Advise or Quit have been chosen
c          
         if (kvalue(numopt - 1).eq.1) switch_off = .true.
         if (kvalue(numopt - 2).eq.1) then
             first = .false.
             call advise (blank,
     +                    abort, first) 
             kvalue(numopt - 2) = 0
             repeet = .true.
         elseif (kvalue(numopt).eq.1) then
             istop = .true.
             return    
         else
            do i = 1, 10
               nout_in(i) = nout(i)
            enddo   
            zin = nout(11)
            cin = nout(12)
            yscale(1) = zin
            yscale(2) = cin
            if (zin .and. cin) then
               itype = 4
               line =
     +'Model is Z = ?, C = ?, C =< y =< Z + C (estimate Z and C)'
            elseif (cin) then
               itype = 3
               line = 
     +'Model is Z = 1, C = ?, C =< y =< 1 + C (estimate C)'
            elseif (zin) then
               itype = 2
               line = 
     +'Model is Z = ?, C = 0, 0 =< y =< Z (estimate Z)'
            else
               itype = 1
               line = 
     +'Model is Z = 1, C = 0, 0 =< y =< 1'
            endif         
            write (nf,'(a)') blank  
            write (nf,'(a)') line  
            write (nf,'(a)') blank  
            repeet = .false.    
         endif  
      enddo   
c
c format statements
c 
  100 FORMAT (
     + 'First time query about fitting ligand binding models'
     +/
     +/'p(x) = 1 + K(1)x + K(2)x^2 +...+ K(n)x^n   (binding polynomial)'
     +/'q(x) = K(1)x + 2K(2)x^2 +...+ nK(n)x^n  (i.e. x times dp(x)/dx)'
     +/'y(x) = (Z/n)q(x)/p(x) + C (overall response)'
     +/
     +/'Here Z is a constant of proportionality between response above'
     +/'baseline (i.e. y - C) and the fractional occupation of sites,'
     +/'while C is the baseline response (i.e. y when ligand conc = 0).'
     +/'Note that y(0) = C, y(infinity) = Z + C and that y(x) is also'
     +/'given by y(x) = (Z/n)*dlog(p)/dlog(x) + C.'
     +/
     +/'Try to scale the data so y(0) = 0 and y(infinity) = 1 (that is'
     +/'use Z = 1, C = 0) for optimal curve-fitting (Type 1 below).'
     +/'If the baseline response is not zero then vary C (Type 3 or 4).'
     +/'If the response is not from zero to 1 vary Z (Type 2 or 4).'
     +/'If in doubt choose to vary both Z and C (Type 4)'
     +/
     +/'Type 1: Z = 1, C = 0, 0 =< y =< 1 (The usual case)'
     +/'Type 2: Z = ?, C = 0, 0 =< y =< Z (Also estimate Z)'
     +/'Type 3: Z = 1, C = ?, C =< y =< 1 + C (Also estimate C)'
     +/'Type 4: Z = ?, C = ?, C =< y =< Z + C (Estimate both Z and C)')
  200 FORMAT (
     + 'Choose the sequence of cooperative sites required'           !1
     +/'Lowest order (>=',i2,')'                                    !2
     +/'Highest order (=<',i2,')'                                   !3
     +/'Choose the method to use for parameter starting estimates'  !4 
     +/'Short Random search'                                        !5
     +/'Medium Random search'                                       !6
     +/'Extensive Random search'                                    !7 
     +/'You input starting estimates'                               !8
     +/'Choose the procedures required for this analysis'           !9 
     +/'Display the goodness of fit analysis'                       !10
     +/'Display values of starting estimates'                       !11
     +/'Display details of any random search'                       !12
     +/'Plot the best fit curves and data'                          !13 
     +/'Provide options to plot residuals'                          !14
     +/'Display tables of (wtd.) residuals'                         !15
     +/'Write residuals to results log file'                        !16
     +/'Use analytic-gradient/high-precision'                       !17
     +/'Do a cooperativity analysis (if n > 1)'                     !18 
     +/'Store/test parameters/covariance-matrix'                    !19
     +/'Fit a scaling factor Z'                                     !20
     +/'Fit a baseline correction factor C'                         !21
     +/'Help'                                                       !22   
     +/'Do not ask again this session'                              !23     
     +/'Quit ... Return to previous menu')                          !24
      END
C
C--------------------------------------------------------------
C
      SUBROUTINE FUNCT1 (N,
     +                   XC, FC)
C
C Evaluation of the weighted residual  if NPTS = 1
C Evaluation of the objective function if NPTS > 1
C

      USE MODULE_SFFIT, ONLY : NPTS, YVAL, THEORY, ERRY, DOFDOM

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      DOUBLE PRECISION, INTENT (IN)  :: XC(N)
      DOUBLE PRECISION, INTENT (OUT) :: FC
C
C Locals
C      
      INTEGER    I
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL ZMOD
      CALL ZMOD (XC)
      IF (NPTS.EQ.1) THEN
         FC = (YVAL(1) - THEORY(1))/ERRY(1)
      ELSE
         FC = ZERO
         DO I = 1, NPTS
            FC = FC + ((YVAL(I) - THEORY(I))/ERRY(I))**2
         ENDDO
         FC = FC/DOFDOM
         ENDIF
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE KMVMAX (M, N, NF, NTEMP, 
     +                   P, VMAX, X, Y, 
     +                   TEMP)
C
C Predict asymptote and half saturation point
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  ::  M, N, NF
      INTEGER,             INTENT (OUT) :: NTEMP
      DOUBLE PRECISION,    INTENT (IN)  :: P(N), X, Y
      DOUBLE PRECISION,    INTENT (OUT) :: VMAX
      CHARACTER (LEN = *), INTENT (OUT) :: TEMP(20)
C
C Locals
C      
      INTEGER    I, IR, IND, IFAIL
      DOUBLE PRECISION EPSI
      PARAMETER (EPSI = 1.0D-07)
      DOUBLE PRECISION A(20), B(20), C(20), D(20)
      DOUBLE PRECISION DELTA, FX, TOLX, XX, YY
      CHARACTER (LEN = 13) D13(2), SHOWLJ
      CHARACTER  RECORD(3)*80
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   C05AZF$
      EXTERNAL   PUTIFA
      INTRINSIC  ABS
      E_NUMBERS = E_FORMATS()
      DO I = 1, M
         A(I) = P(M + 1 - I)
      ENDDO
      B(1) = A(1)
      C(1) = B(1)
      VMAX = P(M + 1)
      IF (M.EQ.1 .AND. P(1).GT.1.0D-20) THEN
         IFAIL = 0
         XX = 1.0D+00/P(1)
      ELSE
         DELTA = - VMAX/2.0D+00
         XX = X
         YY = Y
         TOLX = 1.0D-04
         IR = 0
         IND = 1
         IFAIL = 1
   20    CONTINUE
         CALL C05AZF$(XX, YY, FX, TOLX, IR, D, IND, IFAIL)
         IF (IND.EQ.0) GOTO 40
         IF (IND.LT.2 .OR. IND.GT.4) RETURN
         DO I = 2, M
            B(I) = B(I - 1)*XX + A(I)
            C(I) = C(I - 1)*XX + B(I)
         ENDDO
         FX = (P(M + 1)/M)*(C(M)*XX/(B(M)*XX + 1.0D+00)) + DELTA
         GOTO 20
   40    CONTINUE
         CALL PUTIFA (IFAIL, NF, 'C05AZF/KMVMAX')
      ENDIF
      NTEMP = 0
      IF (IFAIL.EQ.0) THEN
         IF (E_NUMBERS) THEN
            WRITE (RECORD,100) VMAX, XX
            WRITE (NF,100) VMAX, XX
         ELSE
            D13(1) = SHOWLJ(VMAX)
            D13(2) = SHOWLJ(XX) 
            WRITE (RECORD,150) D13(1), D13(2)
            WRITE (NF,150) D13(1), D13(2) 
         ENDIF  
         DO I = 1, 3
            NTEMP = NTEMP + 1
            TEMP(NTEMP) = RECORD(I)
         ENDDO
      ENDIF
      IF (ABS(P(N)).GT.EPSI) THEN
         VMAX = P(M + 1) + P(N)
         DELTA = P(N) - VMAX/2.0D+00
         XX = X
         YY = Y
         TOLX = 1.0D-04
         IR = 0
         IND = 1
         IFAIL = 1
   60    CONTINUE
         CALL C05AZF$(XX, YY, FX, TOLX, IR, D, IND, IFAIL)
         IF (IND.EQ.0) GOTO 80
         IF (IND.LT.2 .OR. IND.GT.4) RETURN
         DO I = 2, M
            B(I) = B(I - 1)*XX + A(I)
            C(I) = C(I - 1)*XX + B(I)
         ENDDO
         FX = (P(M + 1)/M)*(C(M)*XX/(B(M)*XX + 1.0D+00)) + DELTA
         GOTO 60
   80    CONTINUE
         CALL PUTIFA (IFAIL, NF, 'C05AZF/KMVMAX')
         IF (IFAIL.EQ.0) THEN
            IF (E_NUMBERS) THEN
               WRITE (RECORD,200) VMAX, XX
            ELSE
               D13(1) = SHOWLJ(VMAX)
               D13(2) = SHOWLJ(XX)
               WRITE (RECORD,250) D13(1), D13(2)
            ENDIF  
            DO I = 1, 3
               NTEMP = NTEMP + 1
               TEMP(NTEMP) = RECORD(I)
            ENDDO
            IF (E_NUMBERS) THEN
               WRITE (NF,200) VMAX, XX
            ELSE
               D13(1) = SHOWLJ(VMAX)
               D13(2) = SHOWLJ(XX)
               WRITE (NF,250) D13(1), D13(2)
            ENDIF  
         ENDIF
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     +/1X,'Apparent Vmax (i.e. Z or f(infinity) - C) =',1P,E13.5
     +/1X,'Apparent Km (i.e. x where f(x) - C = Z/2) =',E13.5)
  150 FORMAT (
     +/1X,'Apparent Vmax (i.e. Z or f(infinity) - C) =',1X,A
     +/1X,'Apparent Km (i.e. x where f(x) - C = Z/2) =',1X,A)   
  200 FORMAT (
     + 1X,'The value of C is nonzero so we also calculate:'
     +/1X,'Max. pred. hz. asymp. (i.e. f(x) as x -> infinity) =',
     +1P,E13.5
     +/1X,'Value of x when f(x) is half max. pred. hz. asymp. =',
     +E13.5)
  250 FORMAT (
     + 1X,'The value of C is nonzero so we also calculate:'
     +/1X,'Max. pred. hz. asymp. (i.e. f(x) as x -> infinity) =',
     +1X,A
     +/1X,'Value of x when f(x) is half max. pred. hz. asymp. =',
     +1X,A)   
      END
C
C
