C
C SFFIT3.FOR: Include code for SFFIT
C ==========
C
C L1NORM
C LINEAR
C MONIT
C ORDER
C PARAMS
C RANDOM
C SWAPKS
C TESTQS
C ZMOD
C
C
      SUBROUTINE L1NORM (INDX, LW, M, N, NF, NMAX, NX,
     +                   A, B, E, F, S, W)
C
C Minimise AX - B in the L1 norm using E02GBF
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: LW, M, N, NF, NMAX, NX
      INTEGER,          INTENT (OUT)   :: INDX(M + N)
      DOUBLE PRECISION, INTENT (IN)    :: A(NMAX,N), B(M)
      DOUBLE PRECISION, INTENT (OUT)   :: E(NX,M + N), F(M + N), W(LW)
      DOUBLE PRECISION, INTENT (INOUT) :: S(N)  
C
C Locals
C     
      INTEGER    I, IFAIL, J, K, MPL
      DOUBLE PRECISION SMIN, ZERO, ONE
      PARAMETER (SMIN = 1.0D-05, ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION EL1N
      EXTERNAL   E02GBF$
      EXTERNAL   MONIT
      EXTERNAL   PUTIFA
      DO I = 1, N
         DO J = 1, M
            E(I,J) = A(J,I)
         ENDDO
      ENDDO
      DO I = 1, N
         DO J = M + 1, M + N
            IF (J.EQ.M + I) THEN
               E(I,J) = ONE
            ELSE
               E(I,J) = ZERO
            ENDIF
         ENDDO
      ENDDO
      DO I = 1, M
         F(I) = B(I)
      ENDDO
      DO I = M + 1, M + N
         F(I) = SMIN
      ENDDO
      J = 1000
      I = - 1
      MPL = M + N
      IFAIL = 1
      CALL E02GBF$(M, N, MPL, E, NX, F, S, J, MONIT, I, K,
     +             EL1N, INDX, W, LW, IFAIL)
      CALL PUTIFA (IFAIL, NF, 'E02GBF/L1NORM')
      DO I = 1, N
         IF (S(I).LT.SMIN) S(I) = SMIN
      ENDDO
      END
C
C
      SUBROUTINE LINEAR (INDX, ITIME, LW, MFAST, NF, NFAST, NMAX, NN,
     +                   NPTS, NRAND, NX,
     +                   A, DOFDOM, E, ERRY, F, FACT, OLDK, REELN,
     +                   S, STORES, TESTQ, THEORY, W, X, XVAL, YB, YS,
     +                   YVAL,
     +                   ISTOP, NOUT)
C
C Solution of the over-determined linear system
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ITIME, LW, MFAST, NF, NFAST,
     +                                    NMAX, NN, NPTS, NRAND, NX
      INTEGER,          INTENT (OUT)   :: INDX(NMAX + NX)
      DOUBLE PRECISION, INTENT (IN)    :: DOFDOM, ERRY(NMAX), OLDK(NN), 
     +                                    REELN, STORES(NX), TESTQ,
     +                                    X(NX), XVAL(NMAX),
     +                                    YB, YS, YVAL(NMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: A(NMAX,NX), E(NX,NMAX + NX), 
     +                                    F(NMAX + NX), S(NX),
     +                                    THEORY(NMAX), W(LW)
      DOUBLE PRECISION, INTENT (INOUT) :: FACT(NX)
      LOGICAL,          INTENT (IN)    :: ISTOP, NOUT(10)
C
C Locals
C      
      INTEGER    I, J, M, N
      INTEGER    COLOUR
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      DOUBLE PRECISION FCN, TEMP
      CHARACTER (LEN = 13) D13, SHOWLJ
      CHARACTER  LINE*100
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   FUNCT1, L1NORM
      EXTERNAL   TABLE1
      INTRINSIC  DBLE
      IF (ISTOP) RETURN
      IF (ITIME.EQ.1) RETURN
      IF (NRAND.EQ.4) RETURN
      E_NUMBERS = E_FORMATS()  
      M = NPTS
      N = ITIME
      DO I = 1, N
         S(I) = STORES(I)
      ENDDO
      DO I = 1, M
         THEORY(I) = REELN*(YVAL(I) - YB)/ERRY(I)
         TEMP = ONE
         DO J = 1, N
            TEMP = TEMP*XVAL(I)
            A(I,J) = (DBLE(J)*YS/ERRY(I) - THEORY(I))*TEMP
         ENDDO
      ENDDO
      CALL L1NORM (INDX, LW, M, N, NF, NMAX, NX,
     +             A, THEORY, E, F, S, W)
      IF (NOUT(3)) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         WRITE (LINE,100)
         WRITE (NF,100)
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
         COLOUR = 0
      ENDIF
      DO I = 1, N
         FACT(I) = S(I)
      ENDDO
      FACT(MFAST) = YS
      FACT(NFAST) = YB
      IF (NOUT(3)) THEN
         DO I = 1, N
            IF (E_NUMBERS) THEN
               WRITE (LINE,200) I, OLDK(I)*S(I)
               WRITE (NF,200) I, OLDK(I)*S(I)
            ELSE
               TEMP = OLDK(I)*S(I)
               D13 = SHOWLJ(TEMP)  
               WRITE (LINE,250) I, D13
               WRITE (NF,250) I, D13
            ENDIF  
            CALL TABLE1 (COLOUR, LINE)
         ENDDO
         IF (E_NUMBERS) THEN
            WRITE (LINE,300) 'Z', YS
            WRITE (NF,300) 'Z', YS
         ELSE
            D13 = SHOWLJ(YS)
            WRITE (LINE,350) 'Z', D13
            WRITE (NF,350) 'Z', D13
         ENDIF  
         CALL TABLE1 (COLOUR, LINE)
         IF (E_NUMBERS) THEN
            WRITE (LINE,300) 'C', YB
            WRITE (NF,300) 'C', YB
         ELSE
            D13 = SHOWLJ(YB)
            WRITE (LINE,350) 'C', D13
            WRITE (NF,350) 'C', D13 
         ENDIF  
         CALL TABLE1 (COLOUR, LINE)
      ENDIF
      CALL FUNCT1 (NFAST,
     +             X, FCN)
      IF (NOUT(3)) THEN
         IF (E_NUMBERS) THEN
            WRITE (LINE,400) DOFDOM*FCN
         ELSE
            TEMP = DOFDOM*FCN
            D13 = SHOWLJ(TEMP)
            WRITE (LINE,450) D13 
         ENDIF  
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
         COLOUR = 0
      ENDIF
      IF (E_NUMBERS) THEN 
         WRITE (NF,400) DOFDOM*FCN
      ELSE
         TEMP = DOFDOM*FCN 
         D13 = SHOWLJ(TEMP)
         WRITE (NF,450) D13 
      ENDIF  
      IF (FCN.GT.TESTQ) THEN
         IF (NOUT(3)) THEN
            WRITE (LINE,500)
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
         WRITE (NF,500)
         DO I = 1, NFAST
            FACT(I) = STORES(I)
         ENDDO
      ELSE
         IF (NOUT(3)) THEN
            WRITE (LINE,600)
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
         WRITE (NF,600)
      ENDIF
      IF (NOUT(3)) CALL TABLE1 (COLOUR, 'CLOSE')
C
C Format statements
C        
  100 FORMAT (1X,'Over-determined L1 norm parameters')
  200 FORMAT (6X,'K(',I1,')',5X,1P,E13.5)
  250 FORMAT (6X,'K(',I1,')',5X,A13)
  300 FORMAT (8X,A1,6X,1P,E13.5)
  350 FORMAT (8X,A1,6X,A13)
  400 FORMAT (1X,'WSSQ from over-det. lin. sys. =',1P,E13.5)
  450 FORMAT (1X,'WSSQ from over-det. lin. sys. =',1X,A13)
  500 FORMAT (1X,'Start estimates from random search')
  600 FORMAT (1X,'Start estimates from over-det. sys.')
      END
C
C-------------------------------------------------------------------
C
CFTN95$OPTIONS (SILENT)
      SUBROUTINE MONIT (N, X, NITER, K, EL1N)
C
C Monitor E02GBF if required
C
      IMPLICIT NONE
      INTEGER K, N, NITER
      DOUBLE PRECISION EL1N, X(N)
      END
C
C
      SUBROUTINE ORDER (ITYPE, NF, NPTS,
     +                  RTOL, XVAL, YB, YS, YVAL,
     +                  EQUAL, ISTOP)
C
C Estimate YB, YS by linear regression to first/last distinct points
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ITYPE, NF, NPTS
      DOUBLE PRECISION, INTENT (IN)    :: RTOL, XVAL(NPTS), YVAL(NPTS)
      DOUBLE PRECISION, INTENT (OUT)   :: YB, YS
      LOGICAL,          INTENT (IN)    :: EQUAL(NPTS)
      LOGICAL,          INTENT (INOUT) :: ISTOP
C
C Locals
C      
      INTEGER    I, IFAIL, NBOT, NREP, NTOP, NTRY
      DOUBLE PRECISION YSUM
      DOUBLE PRECISION RESUL(20)
      DOUBLE PRECISION RXTOP(3), RYTOP(3), XBOT(3), XTOP(3),
     +                 YBOT(3), YTOP(3)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      
      EXTERNAL   G02CAF$
      EXTERNAL   PUTIFA, PUTFAT, PUTCAU
      INTRINSIC  ABS, MAX
      IF (ITYPE.EQ.1) THEN
         YB = ZERO
         YS = ONE
         RETURN
      ENDIF
      NBOT = 0
      NTRY = 0
   10 CONTINUE
      NTRY = NTRY + 1
      IF (NTRY.GT.NPTS) GOTO 50
      NREP = 0
      YSUM = ZERO
      IF (ABS(XVAL(NTRY)).GT.RTOL) THEN
         NBOT = NBOT + 1
   20    CONTINUE
         NREP = NREP + 1
         YSUM = YSUM + YVAL(NTRY)
         IF (NTRY.EQ.NPTS) THEN
            XBOT(NBOT) = XVAL(NPTS)
            YBOT(NBOT) = YSUM/NREP
         ELSEIF (EQUAL(NTRY + 1)) THEN
            NTRY = NTRY + 1
            GOTO 20
         ELSE
            XBOT(NBOT) = XVAL(NTRY)
            YBOT(NBOT) = YSUM/NREP
         ENDIF
      ELSE
         GOTO 10
      ENDIF
      IF (ABS(YBOT(NBOT)).LT.RTOL) THEN
         NBOT = NBOT - 1
         GOTO 10
      ENDIF
      IF (NBOT.LT.3) GOTO 10
      NTOP = 0
      NTRY = NPTS + 1
   30 CONTINUE
      NTRY = NTRY - 1
      IF (NTRY.LT.1) GOTO 50
      NREP = 0
      YSUM = ZERO
      IF (ABS(XVAL(NTRY)).GT.RTOL) THEN
         NTOP = NTOP + 1
  40     CONTINUE
         NREP = NREP + 1
         YSUM = YSUM + YVAL(NTRY)
         IF (NTRY.EQ.1) THEN
            XTOP(NTOP) = XVAL(1)
            YTOP(NTOP) = YSUM/NREP
         ELSEIF (NTRY.EQ.NPTS) THEN
            IF (EQUAL(NPTS)) THEN
               NTRY = NTRY - 1
               GOTO 40
            ELSE
               XTOP(NTOP) = XVAL(NPTS)
               YTOP(NTOP) = YSUM/NREP
            ENDIF
         ELSEIF (EQUAL(NTRY)) THEN
            NTRY = NTRY - 1
            GOTO 40
         ELSE
            XTOP(NTOP) = XVAL(NTRY)
            YTOP(NTOP) = YSUM/NREP
         ENDIF
      ELSE
         GOTO 30
      ENDIF
      IF (ABS(YTOP(NTOP)).LT.RTOL) THEN
         NTOP = NTOP - 1
         GOTO 30
      ENDIF
      IF (NTOP.LT.3) GOTO 30
      NTOP = 3
      IFAIL = 1
      IF (ITYPE.EQ.2) THEN
         YB = ZERO
         DO I = 1, NTOP
             RXTOP(I) = ONE/XTOP(I)
             RYTOP(I) = ONE/YTOP(I)
         ENDDO
         CALL G02CAF$(NTOP, RXTOP, RYTOP, RESUL, IFAIL)
         IF (RESUL(7).LT.ZERO) ISTOP = .TRUE.
         YS = ONE/MAX(RTOL, ABS(RESUL(7)))
      ELSEIF (ITYPE.EQ.3) THEN
         YS = ONE
         CALL G02CAF$(NTOP, XBOT, YBOT, RESUL, IFAIL)
         IF (RESUL(7).LT.ZERO) ISTOP = .TRUE.
         YB = ABS(RESUL(7))
      ELSE
         CALL G02CAF$(NTOP, XBOT, YBOT, RESUL, IFAIL)
         IF (RESUL(7).LT.ZERO) ISTOP = .TRUE.
         YB = ABS(RESUL(7))
         DO I = 1, NTOP
            RXTOP(I) = ONE/XTOP(I)
            RYTOP(I) = ONE/(YTOP(I) - YB)
         ENDDO
         CALL G02CAF$(NTOP, RXTOP, RYTOP, RESUL, IFAIL)
         IF (RESUL(7).LT.ZERO) ISTOP = .TRUE.
         YS = ONE/MAX(RTOL, ABS(RESUL(7)))
      ENDIF
      CALL PUTIFA (IFAIL, NF, 'G02CAF/ORDER')
      IF (ISTOP) THEN
         CALL PUTCAU ('Bad data ? ... Sign of scaling factor reversed')
         ISTOP = .FALSE.
      ENDIF
      RETURN
   50 CONTINUE
      CALL PUTFAT ('Must have 3 distinct nonzero x-values')
      ISTOP = .TRUE.
      END
C
C-------------------------------------------------------------------
C
      SUBROUTINE PARAMS (N, NF, NRAND, 
     +                   FACT, OLDK, X, 
     +                   NOUT, YSCALE)
C
C Input/output starting estimates before curve-fitting
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N, NF, NRAND
      DOUBLE PRECISION, INTENT (IN)    :: OLDK(N), X(N)
      DOUBLE PRECISION, INTENT (INOUT) :: FACT(N)
      LOGICAL,          INTENT (IN)    :: NOUT, YSCALE(2)
C
C Locals
C      
      INTEGER    I
      INTEGER    COLOUR
      DOUBLE PRECISION PAR(20)
      DOUBLE PRECISION FMAX, FMIN, ZERO, ONE
      PARAMETER (FMAX = 1.0D+30, FMIN = 1.0D-20, ZERO = 0.0D+00,
     +           ONE = 1.0D+00)
      CHARACTER (LEN = 13) D13, SHOWLJ
      CHARACTER  LINE*100
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   GETRM1, TABLE1
      E_NUMBERS = E_FORMATS()
      IF (NRAND.LT.4) THEN
         DO I = 1, N - 2
            PAR(I) = OLDK(I)*FACT(I)*X(I)
         ENDDO
         PAR(N - 1) = FACT(N - 1)*X(N - 1)
         PAR(N) = FACT(N)*X(N)
      ELSE
         DO I = 1, N
            IF (I.LE.N - 2) THEN
               WRITE (LINE,100) I
               CALL GETRM1 (FMIN, PAR(I), FMAX, LINE)
               FACT(I) = PAR(I)/OLDK(I)
            ELSEIF (I.EQ.N - 1) THEN
               PAR(I) = ONE
               IF (YSCALE(1)) THEN
                  CALL GETRM1 (FMIN, PAR(I), FMAX,
     +                        'Starting estimate for Z')
                  FACT(I) = PAR(I)
               ENDIF
            ELSE
               PAR(I) = ZERO
               IF (YSCALE(2)) THEN
                  CALL GETRM1 (FMIN, PAR(I), FMAX,
     +                        'Starting estimate for C')
                  FACT(I) = PAR(I)
               ENDIF
            ENDIF
         ENDDO
      ENDIF
      WRITE (NF,200)
      DO I = 1, N
         IF (E_NUMBERS) THEN
            IF (I.LE.N - 2) THEN
               WRITE (NF,300) I, PAR(I)
            ELSEIF (I.EQ.N - 1) THEN
               WRITE (NF,400) 'Z', PAR(I)
            ELSE
               WRITE (NF,400) 'C', PAR(I)
            ENDIF
         ELSE 
           D13 = SHOWLJ(PAR(I)) 
           IF (I.LE.N - 2) THEN
               WRITE (NF,350) I, D13
            ELSEIF (I.EQ.N - 1) THEN
               WRITE (NF,450) 'Z', D13
            ELSE
               WRITE (NF,450) 'C', D13
            ENDIF
         ENDIF    
      ENDDO
      IF (NOUT) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         WRITE (LINE,200)
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
         COLOUR = 0
         DO I = 1, N
            IF (E_NUMBERS) THEN
               IF (I.LE.N - 2) THEN
                  WRITE (LINE,300) I, PAR(I)
               ELSEIF (I.EQ.N - 1) THEN
                  WRITE (LINE,400) 'Z', PAR(I)
               ELSE
                  WRITE (LINE,400) 'C', PAR(I)
               ENDIF
            ELSE
               D13 = SHOWLJ(PAR(I))
               IF (I.LE.N - 2) THEN
                  WRITE (LINE,350) I, D13
               ELSEIF (I.EQ.N - 1) THEN
                  WRITE (LINE,450) 'Z', D13
               ELSE
                  WRITE (LINE,450) 'C', D13
               ENDIF
            ENDIF  
            CALL TABLE1 (COLOUR, LINE)
         ENDDO
         CALL TABLE1 (COLOUR, 'CLOSE')
      ENDIF
C
C Format statements
C      
  100 FORMAT (1X,'Starting estimate for K(',I1,')')
  200 FORMAT (1X,'Parameter starting estimates')
  300 FORMAT (1X,'K(',I1,') =',1P,E13.5)
  350 FORMAT (1X,'K(',I1,') =',1X,A13)
  400 FORMAT (3X,A1,2X,'=',1P,E13.5)
  450 FORMAT (3X,A1,2X,'=',1X,A13)
      END
C
C-------------------------------------------------------------------
C
      SUBROUTINE RANDOM (ISTATE, ITIME, MAXNUM, MFAST, NBIG, NDOF,
     +                   NF, NFAST, NN, NPAR, NPTS, NRAND, NSMALL,
     +                   NUMBER, NX,
     +                   DOFDOM, FACT, REELN, SIGMA, STORES,
     +                   TESTQ, X, YB, YS,
     +                   ISTOP, NOUT, YSCALE)
C
C Random search for starting estimates for scaling factors
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NN, NX
      INTEGER,          INTENT (IN)    :: ITIME, MAXNUM, NBIG, NF, NPTS, 
     +                                    NRAND, NSMALL 
      INTEGER,          INTENT (OUT)   :: ISTATE(NX), MFAST, NDOF, NFAST
      INTEGER,          INTENT (INOUT) :: NPAR(NN), NUMBER(NN)
      DOUBLE PRECISION, INTENT (IN)    :: SIGMA, YB, YS
      DOUBLE PRECISION, INTENT (OUT)   :: DOFDOM, FACT(NX), REELN, 
     +                                    STORES(NX), TESTQ, X(NX)
      LOGICAL,          INTENT (IN)    :: NOUT(10), YSCALE(2)
      LOGICAL,          INTENT (INOUT) :: ISTOP
C
C Locals
C     
      INTEGER    I, J, K, L, NLOOPS
      INTEGER    COLOUR
      
      DOUBLE PRECISION F, STDEV
      DOUBLE PRECISION G05DDF$
      DOUBLE PRECISION ZERO, ONE, TWO, TEN, PNT25
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           TEN = 10.0D+00, PNT25 = 0.25D+00)
      CHARACTER  LINE*100
      EXTERNAL   G05DDF$
      EXTERNAL   TESTQS, FUNCT1, TABLE1, PUTFAT
      IF (ISTOP) RETURN
C
C Assign REELN, NPAR, MFAST, NFAST, NUMBER, NDOF, DOFDOM
C
      REELN = ITIME
      NPAR(ITIME) = ITIME + 2
      MFAST = ITIME + 1
      NFAST = NPAR(ITIME)
      NUMBER(ITIME) = ITIME
      IF (YSCALE(1)) NUMBER(ITIME) = NUMBER(ITIME) + 1
      IF (YSCALE(2)) NUMBER(ITIME) = NUMBER(ITIME) + 1
      NDOF = NPTS - NUMBER(ITIME)
      DOFDOM = NDOF
      IF (NDOF.LE.0) THEN
         CALL PUTFAT ('Insufficient data ... Analysis terminated')
         ISTOP = .TRUE.
         RETURN
      ENDIF
C
C Return if starting estimates input else global random search
C
      IF (NRAND.EQ.4) RETURN
      IF (NOUT(3)) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         COLOUR = 4
      ENDIF
      DO I = 1, NFAST
         ISTATE(I) = 1
         FACT(I) = ONE
         X(I) = ONE
      ENDDO
      IF (YSCALE(1)) THEN
         FACT(MFAST) = YS
      ELSE
         ISTATE(MFAST) = 0
      ENDIF
      IF (YSCALE(2)) THEN
         FACT(NFAST) = YB
      ELSE
         ISTATE(NFAST) = 0
         X(NFAST) = ZERO
      ENDIF
      CALL FUNCT1 (NFAST, X, F)
      L = 1
      CALL TESTQS (L, ITIME, NF, NN, NPAR, NX,
     +             DOFDOM, F, FACT, STORES, TESTQ,
     +             NOUT)
      NLOOPS = NBIG*(2**NUMBER(ITIME))
      IF (NLOOPS.GT.MAXNUM) NLOOPS = MAXNUM
      STDEV = SIGMA
      DO I = 1, NSMALL
         STDEV = TWO*STDEV
         DO J = 1, NLOOPS
            DO K = 1, ITIME
               FACT(K) = TEN**G05DDF$(ZERO, STDEV)
            ENDDO
         IF (YSCALE(1)) FACT(MFAST) = YS*(TEN**G05DDF$(ZERO, PNT25))
         IF (YSCALE(2)) FACT(NFAST) = YB*(TEN**G05DDF$(ZERO, PNT25))
         CALL FUNCT1 (NFAST, X, F)
         L = 2
         CALL TESTQS (L, ITIME, NF, NN, NPAR, NX,
     +                DOFDOM, F, FACT, STORES, TESTQ,
     +                NOUT)
         ENDDO
         IF (NOUT(3)) THEN
            WRITE (LINE,200) I, STDEV
            WRITE (NF,200) I, STDEV
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
      ENDDO
C
C Now intelligent local search
C
      DO I = 1, NLOOPS
         DO J = 1, NFAST
            IF (ISTATE(J).GT.0) THEN
               FACT(J) = STORES(J)*(TEN**G05DDF$(ZERO, PNT25))
            ENDIF
         ENDDO
         CALL FUNCT1 (NFAST, X, F)
         L = 2
         CALL TESTQS (L, ITIME, NF, NN, NPAR, NX,
     +                DOFDOM, F, FACT, STORES, TESTQ,
     +                NOUT)
      ENDDO
      IF (NOUT(3)) THEN
         WRITE (LINE,300) PNT25
         WRITE (NF,300) PNT25
         CALL TABLE1 (COLOUR, LINE)
      ENDIF
      L = 3
      CALL TESTQS (L, ITIME, NF, NN, NPAR, NX,
     +             DOFDOM, F, FACT, STORES, TESTQ,
     +             NOUT)
      IF (ITIME.EQ.1) THEN
         DO I = 1, NFAST
            FACT(I) = STORES(I)
         ENDDO
      ENDIF
C
C Format statement
C      
C 100 FORMAT (1X,'Wait',3X,'...',3X,'Random search in progress')
  200 FORMAT (1X,'Search',I2,1X,'finished (N(0,sigma^2) with sigma =',
     +F5.2,')')
  300 FORMAT (1X,'Local search over (N(0,sigma^2) with sigma =',
     +F5.2,')')
      END
C
C-------------------------------------------------------------------
C
      SUBROUTINE SWAPKS (N, NF,
     +                   C)
C
C Supply overall binding constants K(I) in C  then
C swap K into A and B and form inverses if possible
C 24/02/2022 now calls POLSWP
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: N, NF
      DOUBLE PRECISION, INTENT (IN) :: C(N)
      EXTERNAL POLSWP
      CALL POLSWP (N, NF,
     +             C)
      END
C
C-------------------------------------------------------------------
C
      SUBROUTINE TESTQS (ISEND, ITIME, NF, NN, NPAR, NX,
     +                   DOFDOM, F, FACT, STORES, TESTQ,
     +                   NOUT)
C
C Test WSSQ for improvement
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NN, NX
      INTEGER,          INTENT (IN)    :: ISEND, ITIME, NF, NPAR(NN)
      DOUBLE PRECISION, INTENT (IN)    :: DOFDOM, FACT(NX)
      DOUBLE PRECISION, INTENT (INOUT) :: F, TESTQ, STORES(NX)
      LOGICAL,          INTENT (IN)    :: NOUT(10)
C
C Locals
C      
      
      INTEGER    I, ICOUNT, J, JCOUNT
      INTEGER    COLOUR
      DOUBLE PRECISION QSAVE, TEMP
      CHARACTER (LEN = 13) D13(2), SHOWLJ  
      CHARACTER (LEN = 12) FORM12, I12(2)
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   TABLE1
      SAVE       ICOUNT, JCOUNT, QSAVE
      E_NUMBERS = E_FORMATS() 
      IF (ISEND.EQ.1) THEN
         ICOUNT = 0
         JCOUNT = 0
         QSAVE  = DOFDOM*F
         IF (NOUT(3)) THEN
            WRITE (LINE,100) ITIME, ITIME
            WRITE (NF,100) ITIME, ITIME
            COLOUR = 4
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
      ELSEIF (ISEND.EQ.2) THEN
         ICOUNT = ICOUNT + 1
         IF (F.GE.TESTQ) RETURN
         JCOUNT = JCOUNT + 1
      ENDIF
      IF (ISEND.EQ.1 .OR. ISEND.EQ.2) THEN
         TESTQ = F
         IF (NOUT(3)) THEN
            IF (E_NUMBERS) THEN
               WRITE (LINE,200) ICOUNT, DOFDOM*F
               WRITE (NF,200) ICOUNT, DOFDOM*F
            ELSE
               TEMP = DOFDOM*F
               D13(1) = SHOWLJ(TEMP)
               WRITE (LINE,250) ICOUNT, D13(1)
               WRITE (NF,250) ICOUNT, D13(1) 
            ENDIF  
            COLOUR = 0
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
         DO J = 1, NPAR(ITIME)
            STORES(J) = FACT(J)
         ENDDO
         RETURN
      ENDIF
      IF (NOUT(3)) THEN
         I12(1) = FORM12(ICOUNT)
         I12(2) = FORM12(JCOUNT)
         IF (E_NUMBERS) THEN
            WRITE (TEXT,300) ITIME, ITIME, TRIM(I12(1)), TRIM(I12(2)),
     +                       QSAVE, DOFDOM*TESTQ
            WRITE (NF,300) ITIME, ITIME, TRIM(I12(1)), TRIM(I12(2)),
     +                     QSAVE, DOFDOM*TESTQ
         ELSE
            D13(1) = SHOWLJ(QSAVE)
            TEMP = DOFDOM*TESTQ
            D13(2) = SHOWLJ(TEMP)
            WRITE (TEXT,350) ITIME, ITIME, TRIM(I12(1)), TRIM(I12(2)),
     +                       D13(1), D13(2)
            WRITE (NF,350) ITIME, ITIME, TRIM(I12(1)), TRIM(I12(2)), 
     +                     D13(1), D13(2)
         ENDIF  
         DO I = 1, 5
            IF (I.EQ.2) THEN
               COLOUR = 4
            ELSE
               COLOUR = 0
            ENDIF
            LINE = TEXT(I)
            CALL TABLE1 (COLOUR, LINE)
         ENDDO
         CALL TABLE1 (COLOUR, 'CLOSE')
      ENDIF
C
C Format statements
C      
  100 FORMAT (1X,'Iteration    WSSQ (',I1,':',I1,')')
  200 FORMAT (1X,I8,4X,1P,E13.5)
  250 FORMAT (1X,I8,4X,A13)
  300 FORMAT (/1X,'For best random',I2,':',I1,1X,'search'
     +/1X,'Number of improvements in',1X,A,1X,'cycles =',1X,A
     +/1X,'WSSQ before search =',1P,E13.5
     +/1X,'WSSQ after  search =',   E13.5/)
  350 FORMAT (/1X,'For best random',I2,':',I1,1X,'search'
     +/1X,'Number of improvements in',1X,A,1X,'cycles =',1X,A
     +/1X,'WSSQ before search =',1X,A13
     +/1X,'WSSQ after  search =',1X,A13/)   
      END
C
C-------------------------------------------------------------------
C
      SUBROUTINE ZMOD (P)
C
C Saturation function with scaling factors if required
C

      USE MODULE_SFFIT, ONLY : ITIME, FACT, REELN, NPTS, EQUAL, THEORY,
     +                         XVAL, MFAST, NFAST

      IMPLICIT   NONE
C
C Argument
C      
      DOUBLE PRECISION, INTENT (IN) :: P(*)
C
C Locals
C      
      INTEGER    NN, NX
      PARAMETER (NN = 10, NX = NN + 2)
      INTEGER    I, J
      DOUBLE PRECISION ASCALE, BOT, OSCALE, TOP
      DOUBLE PRECISION A(NN), B(NN), C(NN)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      DO I = 1, ITIME
         J = MFAST - I
         A(I) = FACT(J)*P(J)
      ENDDO
      ASCALE = FACT(MFAST)*P(MFAST)/REELN
      OSCALE = FACT(NFAST)*P(NFAST)
      B(1) = A(1)
      C(1) = B(1)
      DO I = 1, NPTS
         IF (EQUAL(I)) THEN
            THEORY(I) = THEORY(I - 1)
         ELSE
            DO J = 2, ITIME
               B(J) = B(J - 1)*XVAL(I) + A(J)
               C(J) = C(J - 1)*XVAL(I) + B(J)
            ENDDO
            BOT = B(ITIME)*XVAL(I) + ONE
            TOP = C(ITIME)*XVAL(I)
            THEORY(I) = ASCALE*(TOP/BOT) + OSCALE
         ENDIF
      ENDDO
      END
C
C
