C
C SV_SIMPLOT is attached 
C
C Main program for SIMPLOT
C ========================
C
      PROGRAM MAIN
C
C PACKAGE : SIMFIT
C PROGRAM : SIMPLOT
C ACTION  : Read in ASCII files and create a graph
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K.
C VERSION : set from SIMVER/DLLCHK
C GRAPHICS: PostScript/TrueType
C           28/06/1995 Extensive revision to INTEGER*2
C           04/08/1995 Added two plot facility
C           07/09/1995 Added surface plotting
C           04/03/1996 Increased dimension
C           10/07/1996 Added curves in space
C           08/08/1996 Added library file option
C           20/09/1996 Dimensioned/Initialised all arrays in main program
C           03/10/1996 Increased the dimensions JARROW, JSTRNG, NGRAFS
C           20/02/1997 Added BARCAP_1 to control bar chart error bars
C           14/07/1997 win32 version
C           28/11/1997 extensive revision
C           12/12/1997 Added arguments for GKSOBJ$
C           22/01/1998 Increased dimension of KPANEL to equal NGRAFS
C           04/02/1998 Removed questions for library file
C           09/03/1998 Option for vector field
C           07/08/1998 added dllchk
C           10/09/1998 added fsav1 to allow data editing in temporary files
C           13/12/1998 added code to call w_labels and w_symbol from DETAIL
C                      and to initialise JCOLOR, L and M each time GKSGRF
C                      is called
C           22/07/1999 Changed transformation scheme
C           08/09/1999 Changed calculation of ASYMP and warned when order
C                      of magnitude selected in log plots
C           13/09/1999 added calls to WINDOW
C           29/11/1999 added call to ERRBAR to calculate error bars
C           08/01/2000 added NFILE1 and call to DELEET
C           10/01/2000 decreased array size as follows:
C                      NGRAFS from   200 to  100
C                      NMAX   from 10000 to 5000
C                      NWORDS from   300 to  100
C                      as there seem to be paging problems.
C           14/02/2000 added SIMVER and called DEFGKS$ immediately
C           03/07/2000 edited for double precision and improved
C                      checking for transformations
C           29/09/2000 added PKURVE
C           28/10/2000 extensive editing
C           05/03/2001 added PFILES for project files
C           22/03/2001 corrected L and M when using SUPPLY_XY
C           01/06/2001 restored NWORDS = 300 to increase bar chart limits
C           24/07/2001 re-set NWORDS = NGRAFS = 200 to avoid dimension
C                      clashes in dlls
C           17/08/2001 added facility to type in 3-D data
C           07/11/2001 upgraded argument list for SPACE1
C           28/09/2002 increased NWORDS from 200 to 500
C           07/10/2002 set NGRAFS = 300 and NWORDS = 1000
C           07/01/2002 dimensioned WIDE(5*NGRAFS)
C           20/01/2003 extensive revision, including SIMOPT$ and calls
C                      to VECEXH and MATEXH
C           15/10/2004 altered call to SYMBOL, checked that line and symbol
C                      are not both suppressed, replace advice by HTML help
C           11/07/2005 increased NWORDS from 1000 to 2000
C           27/07/2005 set version from SIMVER/DLLCHK
C           06/01/2006 NRMAX1 = 1000, and altered argument list to MATEXH
C           06/04/2006 introduced M_VECONE and M_MATONE
C           08/07/2006 increased NMAX from 5000 to 10000
C           01/11/2007 added statistical plotting options
C           30/01/2008 removed X, ..., YT from call to GKSGRF$
C           02/11/2010 added SIZE and WIDE to SYMBOL argument list 
C           26/09/2011 made NXTRA = NWORDS 
C           23/05/2013 added metafile replay
C           04/05/2024 added sv_simplot
C
      IMPLICIT   NONE
      include   <windows.ins>
      INTEGER    KPANEL, NFILE1, NGRAFS, NIN, NMAX, NWORDS, NXTRA
      PARAMETER (NGRAFS = 300, KPANEL = NGRAFS, NIN = 3, NMAX = 10000,
     +           NWORDS = 2000, NXTRA = NWORDS)
      INTEGER    NGRAF2, NGRAF3, NGRAF4
      PARAMETER (NGRAF2 = 2*NGRAFS, NGRAF3 = 3*NGRAFS,
     +           NGRAF4 = 4*NGRAFS)
      INTEGER    KPAR
      PARAMETER (KPAR = 100)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12, 
     +           N13, N14, N15, N16, N100
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N8 = 8, N9 = 9, N10 = 10, N11 = 11, N12 = 12, 
     +           N13 = 13, N14 = 14, N15 = 15, N16 = 16, N100 = 100)
      INTEGER    NF, NIN1, NIN2, NOUT
      PARAMETER (NIN1 = 7, NIN2 = 8, NF = 4, NOUT = 9)
      INTEGER    IFILL(NXTRA), IHUE(NXTRA), JCOLOR(NGRAFS),
     +           L(NGRAFS), M(NGRAFS), NSAV(NGRAFS)
      INTEGER    IWRK(NMAX)
      INTEGER    I, ICOUNT, IOS, IPREV, ISEND, ITYPE, J, K, MODEL, 
     +           NMAX1, NX, NY
      INTEGER    ISEND1, NCOL, NROW, NZ
      INTEGER    NCOL_B, NCOL_D, NCOL_K, NCOL_M, NCOL_P
      INTEGER    NROW_B, NROW_D, NROW_K, NROW_M, NROW_P
      INTEGER    I_LENGTH, I_STATUS
      DOUBLE PRECISION VECTOR(N100**2 + 6)
      DOUBLE PRECISION XMAX, XMIN, YMAX, YMIN
      DOUBLE PRECISION FACTOR(NXTRA), PAR(KPAR), SIZE(NGRAFS),
     +                 WIDE(5*NGRAFS)
      DOUBLE PRECISION X(NMAX), XH(NMAX), XT(NMAX), 
     +                 Y(NMAX), YH(NMAX), YT(NMAX) 
      DOUBLE PRECISION Z(N100,N100), ZTEMP(N100,N100)
      DOUBLE PRECISION XVER, YVER
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER  FNAME*1024
      CHARACTER  FSAV(NGRAFS)*1024, FSAV1(NGRAFS)*1024,
     +           LABEL1(NWORDS)*40,
     +           LABVEC(NWORDS)*40, PLINE(KPANEL)*40, PSYMB(KPANEL)*40,
     +           TSAV(NGRAFS)*80, WORDX(NWORDS)*40, WORDY(NWORDS)*40, 
     +           VECTOR1(60)*40 
      CHARACTER  FNAMEM*1024, FNAMEV*1024, TITLEM*80, TITLEV*80
      CHARACTER  FNAME_B*1024, FNAME_D*1024, FNAME_K*1024, FNAME_M*1024,
     +           FNAME_P*1024
      CHARACTER  TITLE_B*80,  TITLE_D*80,  TITLE_K*80,  TITLE_M*80, 
     +           TITLE_P*80
      CHARACTER  TITLES(4)*80
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_simplot.exe')
      CHARACTER  PNAME*7, TITLE*80, WORD2*2, WORD4*4
      PARAMETER (PNAME = 'SIMPLOT')
      CHARACTER  BLANK*1, LETTER, ZERO40*40
      PARAMETER (BLANK = ' ',
     +           ZERO40 = '0000000000000000000000000000000000000000')
      CHARACTER (LEN = 100) COMMAND
      LOGICAL    ABORT, ACTION, SHOW, TYPE_IN, UNUSED(N100,N100)
      LOGICAL    BARCAP(NGRAFS), BARCAP_1, BAR_CHART, LIB_FILE,
     +           LOWER(NGRAFS), PIE_CHART, PLOTX(NWORDS), PLOTY(NWORDS),
     +           PLOTZ(NWORDS), PSHOW(KPANEL), SUPPLY_XY, TWO_PLOTS,
     +           UPPER(NGRAFS), VECTOR_FIELD, YAXIS(NGRAFS)
      LOGICAL    ACCEPT1(NGRAFS)
      LOGICAL    AGAIN, FIRST, VIEW_PLOT
      LOGICAL    ASKIF, THERE
      PARAMETER (ASKIF = .FALSE.)
      EXTERNAL   ADVISE$, GKSGRF, DETAIL$, SURFAC, INTYPE, SPACE0,
     +           SPACE5, GKSSAV
      EXTERNAL   DLLCHK, SYMBOL, WINDOW, DELEET, LCASE1, SIMVER, PKURVE,
     +           PFILES, LABELS, PLOT_SPACE_FILES
      EXTERNAL   M_VECONE, M_MATONE, FNAMES, M_MVSTAT
      EXTERNAL   DEFGKS, NUMOBJ, PLTOBJ
      EXTERNAL   SV_SIMPLOT 
      INTRINSIC  DBLE
C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      call set_max_dialog_size@(5000,50000)
      ISEND = N1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER, 
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================
C


C
C First check the command line to initialise ISEND and JUMP
C
      ISEND = COMMAND_ARGUMENT_COUNT()  
      IF (ISEND.NE.N1) THEN
         ISEND = N0
      ELSE      
         CALL GET_COMMAND_ARGUMENT (N1, COMMAND, I_LENGTH, I_STATUS)
         IF (I_LENGTH.GE.N1 .AND. I_STATUS.EQ.N0) THEN
C
C 29/10/2023
C Replaced non-integer characters by blanks to interpret '0' as 0 which causes trouble otherwise
C It appears that 'i' is passed by run_program and returned as such by command argument 
C retrieval and read accurately except for '0' which is not read as 0 even if the quotes are 
C removed. Is it being read as a C string terminator ? So 0 is changed to 11 to call sv_simstat. 
C         
            do i = 1, i_length
               letter = command(i:i)
               j = ichar(letter)
               if (j.lt.48 .or. j.gt.57) command(i:i) = blank
            enddo  
             
            READ (COMMAND,*,IOSTAT=IOS) I
            IF (IOS.EQ.N0) THEN
               IF (I.GE.N1 .AND. I.LE.N10) THEN
                  ISEND = I
               ELSE
                  ISEND = N0
               ENDIF
            ELSE
               ISEND = N0
            ENDIF
         ELSE
            ISEND = N0
         ENDIF      
      ENDIF
      IF (ISEND.GT.N0) THEN
         CALL SV_SIMPLOT
         GOTO 20
      ENDIF

C
C Initialise
C
C      FIRST = .TRUE.
C      CALL ADVISE (DVER,
C     +               ISTOP, FIRST)
C      IF (.NOT.ISTOP) THEN
C         CALL RESFIL (NF,
C     +                FNAME, ISTOP)
C         WRITE (NF,100)
C         IF (.NOT.ISTOP) THEN
C            IF (JUMP) THEN
C               CALL SV_SIMPLOT (NIN, NF)
C            ELSE   
C               CALL FITLIN (NIN, NF)
C            ENDIF
C        ENDIF       



C
C Call advise
C
      FNAME = BLANK
      CALL DEFGKS
      FIRST = .TRUE.
      CALL ADVISE$(NGRAFS,
     +             DVER,
     +             ABORT, FIRST, VIEW_PLOT)
      IF (ABORT) THEN
         AGAIN = .FALSE.
      ELSE
         AGAIN = .TRUE.
C
C Close all units
C
         CLOSE (UNIT = NF)
         CLOSE (UNIT = NIN)
         CLOSE (UNIT = NIN1)
         CLOSE (UNIT = NIN2)
         CLOSE (UNIT = NOUT)
C
C
C Initialise objects
C
          CALL PLTOBJ (N1, N1)
C
C Initialise all the array variables (except for coordinates)
C
         BARCAP_1 = .TRUE.
         DO ISEND = N1, KPANEL
            PLINE(ISEND) = BLANK
            PSYMB(ISEND) = ZERO40
            PSHOW(ISEND) = .TRUE.
         ENDDO
         DO ISEND = N1, NGRAFS
            JCOLOR(ISEND) = N0
            L(ISEND) = N1
            M(ISEND) = N1
            NSAV(ISEND) = N1
            SIZE(ISEND) = ONE
            WIDE(ISEND) = ONE
            WIDE(ISEND + NGRAFS) = ONE
            WIDE(ISEND + NGRAF2) = ONE
            WIDE(ISEND + NGRAF3) = ONE
            WIDE(ISEND + NGRAF4) = ONE
            FSAV(ISEND) = BLANK
            FSAV1(ISEND) = BLANK
            TSAV(ISEND) = BLANK
            BARCAP(ISEND) = .TRUE.
            LOWER(ISEND) = .TRUE.
            UPPER(ISEND) = .TRUE.
            YAXIS(ISEND) = .TRUE.
         ENDDO
         DO ISEND = N1, NWORDS
            LABEL1(ISEND) = BLANK
            LABVEC(ISEND) = ZERO40
            WORDX(ISEND) = BLANK
            WORDY(ISEND) = BLANK
            PLOTX(ISEND) = .TRUE.
            PLOTY(ISEND) = .TRUE.
            PLOTZ(ISEND) = .TRUE.
         ENDDO
         DO ISEND = N1, NXTRA
            IFILL(ISEND) = N1
            IHUE(ISEND) = N0
            FACTOR(ISEND) = ONE
         ENDDO  
         DO ISEND = N1, KPAR
            PAR(ISEND) = ONE
         ENDDO
C
C Initialise the exhaustive analysis parameters
C
         NCOL = N0
         NROW = N0
         NZ = N0
         NCOL_B = N0
         NCOL_D = N0
         NCOL_K = N0
         NCOL_M = N0
         NCOL_P = N0
         NROW_B = N0
         NROW_D = N0
         NROW_K = N0
         NROW_M = N0
         NROW_P = N0
         FNAMEM = 'No_file'
         FNAMEV = 'No_file'
         FNAME_B = 'No_file'
         FNAME_D = 'No_file'
         FNAME_K = 'No_file'
         FNAME_M = 'No_file'
         FNAME_P = 'No_file'
         TITLEM = 'No_data'
         TITLEV = 'No_data'
         TITLE_B = 'No data'
         TITLE_D = 'No data'
         TITLE_K = 'No data'
         TITLE_M = 'No data'
         TITLE_P = 'No data'
C
C Set TYPE_IN = .FALSE. and ISEND = 10 to call help the first time
C
         TYPE_IN = .FALSE.
         ISEND = N11
         TITLES(1) = '(x,y) Plot'
         TITLES(2) = 'x'
         TITLES(3) = 'y'
         TITLES(4) = 'z'
      ENDIF
C
C=================================================================================
C The main loop if AGAIN = .TRUE.
C=================================================================================
C
      ICOUNT = N0
      IPREV = N0
      NFILE1 = N0
      DO WHILE (AGAIN)
C
C Close all units except NF which holds results from call to RESFIL
C
         CLOSE (UNIT = NIN)
         CLOSE (UNIT = NIN1)
         CLOSE (UNIT = NIN2)
         CLOSE (UNIT = NOUT)
         IF (TYPE_IN) ISEND = N8
C
C Call to DETAIL$ to get the users decision
C
         CALL DETAIL$(ISEND, NF,
     +                FNAME,
     +                BAR_CHART, LIB_FILE, PIE_CHART, SUPPLY_XY,
     +                TWO_PLOTS, TYPE_IN, VECTOR_FIELD, VIEW_PLOT)
C
C Exit if ISEND > 16
C     
         IF (ISEND.GT.N16) EXIT
C
C Set JCOLOR, L, M, IHUE, IFILL, LABELS to defaults
C
         CALL SYMBOL (N1, JCOLOR, IWRK, L, M,
     +                SIZE, WIDE)
         CALL LABELS (N1, IHUE, IFILL,
     +                LABEL1, PlINE, WORDX, VECTOR1)
         DO I = 1, 20
            LABVEC(I) = VECTOR1(I)
            PSYMB(I) = VECTOR1(I + 20)
            WORDY(I) = VECTOR1(I + 40)
         ENDDO   
         IF (SUPPLY_XY) THEN
C
C Supply data using a project/multi-file approach
C
            ITYPE = N4
            CALL PFILES (IPREV, ITYPE, NFILE1, NIN, NGRAFS, NOUT,
     +                   FSAV,
     +                   ACCEPT1)
            CLOSE (UNIT = NIN)
            CLOSE (UNIT = NOUT)
            IF (NFILE1.LT.N1) THEN
               SUPPLY_XY = .FALSE.
               NFILE1 = NGRAFS
               IPREV = N0
            ELSE
               IPREV = N4
            ENDIF
         ELSE
            IPREV = N0
            NFILE1 = NGRAFS
         ENDIF
         IF (ISEND.LE.N8) THEN
C
C Check if the user wants to re-plot stored objects
C
            ICOUNT = ICOUNT + N1
            IF (ICOUNT.GT.N1) CALL NUMOBJ (N1, I, J, K)
         ENDIF
         IF (ISEND.LT.N6) THEN
C
C ISEND < 6: Normal, Double, Bar or Chart type plot
C===========
C
            IF (ISEND.EQ.N1 .OR. ISEND.EQ.N2) THEN
               IF (SUPPLY_XY) THEN
C
C Override L and M if SUPPLY_XY for small/large samples
C
                  CLOSE (UNIT = NIN)
                  DO I = N1, NFILE1
                     OPEN (UNIT = NIN, FILE = FSAV(I), IOSTAT = IOS)
                     IF (IOS.EQ.N0) READ (NIN,'(A)',IOSTAT=IOS) TSAV(I)
                     IF (IOS.EQ.N0) READ (NIN,*,IOSTAT=IOS) J, K
                     IF (IOS.EQ.N0) THEN
                        IF (L(I).EQ.N0 .AND. M(I).EQ.N0) THEN
                           L(I) = N1
                           M(I) = N1
                        ENDIF
                        IF (J.LT.60) THEN
                           L(I) = N0
                           IF (M(I).EQ.N0) M(I) = N1
                        ELSE
                           IF (L(I).EQ.N0) L(I) = N1
                           M(I) = N0
                        ENDIF
                     ENDIF
                     CLOSE (UNIT = NIN)
                  ENDDO
               ENDIF
            ENDIF
C
C Call the main plotting routine
C===============================
C

            CLOSE (UNIT = NIN)
C
C Deallocate all allocated workspaces then define NMAX1
C     
            I = N1
            CALL GKSSAV (N0, I,
     +                   ABORT)              

            NMAX1 = NWORDS
                
            CALL GKSGRF (IFILL, IHUE, JCOLOR, KPANEL, L, M, NFILE1,
     +                   NGRAFS, NIN, NMAX1, NSAV, NWORDS, NXTRA,
     +                   FACTOR, SIZE, WIDE, 
     +                   FSAV, FSAV1, LABEL1, LABVEC, PLINE, PSYMB,
     +                   TSAV, TITLES, WORDX, WORDY,
     +                   BARCAP, BARCAP_1, BAR_CHART, LIB_FILE, LOWER,
     +                   PIE_CHART, PLOTX, PLOTY, PLOTZ, PSHOW,
     +                   SUPPLY_XY, TWO_PLOTS, TYPE_IN, UPPER,
     +                   VECTOR_FIELD, YAXIS)
     
            CLOSE (UNIT = NIN)     
C
C Deallocate all allocated workspaces
C     
            I = N1
            CALL GKSSAV (N0, I,
     +                   ABORT)             
C
C Delete all temporary files
C
            DO I = N1, NFILE1
               WORD2 = FSAV(I)(1:2)
               CALL LCASE1 (WORD2)
               IF (WORD2.EQ.'f$') THEN
                  WORD4 = FSAV(I)(9:12)
                  CALL LCASE1 (WORD4)
                  IF (WORD4.EQ.'.tmp') THEN
                     CALL DELEET (FSAV(I), ASKIF, THERE)
                  ENDIF
               ENDIF
               WORD2 = FSAV1(I)(1:2)
               CALL LCASE1 (WORD2)
               IF (WORD2.EQ.'f$') THEN
                  WORD4 = FSAV1(I)(9:12)
                  CALL LCASE1 (WORD4)
                  IF (WORD4.EQ.'.tmp') THEN
                     CALL DELEET (FSAV1(I), ASKIF, THERE)
                  ENDIF
               ENDIF
            ENDDO
            IF (TWO_PLOTS .OR. BAR_CHART .OR. VECTOR_FIELD .OR.
     +          PIE_CHART) NFILE1 = N0
         ELSEIF (ISEND.EQ.N6) THEN
C
C ISEND = 6: Surface type plot
C===========
C
            ISEND = N2
            NX = N100
            NY = N100
            CALL SURFAC (ISEND, MODEL, N100, NX, NY, 
     +                   VECTOR, X, XMAX, XMIN, XH, XT, Y, YMAX, YMIN,
     +                   YH, YT, Z, ZTEMP,
     +                   UNUSED)
            IPREV = N0
            ISEND = N6
            NFILE1 = N0
         ELSEIF (ISEND.EQ.N7) THEN
C
C ISEND = 7: Curves in space
C===========
C
            CALL PLOT_SPACE_FILES
            CLOSE (UNIT = NIN)
            IPREV = N0
            NFILE1 = N0
         ELSEIF (ISEND.EQ.N8) THEN
C
C ISEND = 8: Type in (if required) for 3-D plot
C===========
C
            CALL INTYPE (ITYPE, NOUT, NX, NY, N100,
     +                   XT, X, XH, Z,
     +                   ABORT)
            CLOSE (UNIT = NOUT)
            IF (.NOT.ABORT .AND. NX.GT.N1 .AND. NY.GT.N1) THEN
               IF (ITYPE.EQ.N1) THEN
                  XMIN = ONE
                  XMAX = DBLE(NX)
                  YMIN = ONE
                  YMAX = DBLE(NY)
                  ISEND = N4
                  CALL SURFAC (ISEND, MODEL, N100, NX, NY,
     +                         VECTOR, X, XMAX, XMIN, XH, XT, Y, YMAX,
     +                         YMIN, YH, YT, Z, ZTEMP, 
     +                         UNUSED)
               ELSEIF (ITYPE.EQ.N2) THEN
                  CALL SPACE5 (NX, NMAX, 
     +                         XT, YT, X, Y, XH)
               ELSEIF (ITYPE.EQ.N3) THEN
                  CALL SPACE0 (NX, NMAX,
     +                         XT, YT, X, Y, XH)
               ENDIF
            ENDIF
            ISEND = N9
         ELSEIF (ISEND.EQ.N9) THEN
C
C ISEND = 9: Parametric curves
C===========
C
            CALL PKURVE (KPAR,
     +                   PAR)
            ISEND = N10
            IPREV = N0
            NFILE1 = N0
         ELSEIF (ISEND.EQ.N10) THEN
C
C ISEND = 10: Exhaustive analysis of a vector
C============
C
            CLOSE (UNIT = NIN1)
            ISEND1 = N1
            CALL M_VECONE (ISEND1, NIN1, NF, NZ,
     +                     FNAMEV, TITLEV)
            CLOSE (UNIT = NIN1)
         ELSEIF (ISEND.EQ.N11) THEN
C
C ISEND = 11: Exhaustive analysis of a matrix
C============
C
            CLOSE (UNIT = NIN1)
            ISEND1 = N6
            CALL M_MATONE (ISEND1, NCOL, NIN1, NF, NROW,
     +                     FNAMEM, TITLEM)
            CLOSE (UNIT = NIN1)
         ELSEIF (ISEND.EQ.N12) THEN
C
C ISEND = 12: Dendrogram
C============
C
            CLOSE (UNIT = NIN1)
            ISEND1 = N5
            CALL M_MVSTAT (ISEND1, NCOL_D, NIN1, NF, NROW_D,
     +                     FNAME_D, TITLE_D)
            CLOSE (UNIT = NIN1)
         ELSEIF (ISEND.EQ.N13) THEN
C
C ISEND = 13: K-means clustering
C============
C
            CLOSE (UNIT = NIN1)
            ISEND1 = N7
            CALL M_MVSTAT (ISEND1, NCOL_K, NIN1, NF, NROW_K,
     +                     FNAME_K, TITLE_K)
            CLOSE (UNIT = NIN1)
         ELSEIF (ISEND.EQ.N14) THEN
C
C ISEND = 14: Principal components
C============
C
            CLOSE (UNIT = NIN1)
            ISEND1 = N8
            CALL M_MVSTAT (ISEND1, NCOL_P, NIN1, NF, NROW_P,
     +                     FNAME_P, TITLE_P)
            CLOSE (UNIT = NIN1)
         ELSEIF (ISEND.EQ.N15) THEN
C
C ISEND = 15: Biplot
C============
C
            CLOSE (UNIT = NIN1)
            ISEND1 = N14
            CALL M_MVSTAT (ISEND1, NCOL_B, NIN1, NF, NROW_B,
     +                     FNAME_B, TITLE_B)
            CLOSE (UNIT = NIN1) 
         ELSEIF (ISEND.EQ.N16) THEN
C
C ISEND = 16: MANOVA plot
C============
C
            CLOSE (UNIT = NIN1)
            ISEND1 = N15
            CALL M_MVSTAT (ISEND1, NCOL_M, NIN1, NF, NROW_M,
     +                     FNAME_M, TITLE_M)
            CLOSE (UNIT = NIN1)                                
         ELSE
C
C ISEND > 16: quit
C=============
C
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C If exhaustive analysis has been done inform user about results file
C
      CLOSE (UNIT = NF)
      ISEND = N2
      CALL FNAMES (ISEND,
     +             FNAME)


C
C======================================================================
C The program is finished so we can close down the background window
C

   20 CONTINUE
      ISEND = N1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE, 
     +             ACTION)
C
C======================================================================
C

      END
C
C---------------------------------------------------------------------------------
C---------------------------------------------------------------------------------
C
      SUBROUTINE SV_SIMPLOT
C
C 11/04/2024 Now two matrices A(NMAX,NMAX) and A1(NRMAX,NCMAX) where A is
C            used for pie charts and bar charts but A1 used for standard plots 
C            and the dimensions must agree with those in SV_MATTIN
C 04/05/2024 introduced subroutine PLOT24 to plot up to 4 simple plots
C    
      IMPLICIT NONE
      INTEGER I, ISEND, J, KTYPE, L, NUMDEC, N1, N2
      PARAMETER (N1 = 1, N2 = 2)
      INTEGER NIN
      PARAMETER (NIN = 3)
      INTEGER NCOL, NMAX, NROW
      PARAMETER (NMAX = 200)
      INTEGER  NCMAX, NRMAX
      PARAMETER (NCMAX = 3, NRMAX = 500)
      INTEGER NUMOPT, NUMSTA, NUMTXT
      PARAMETER (NUMOPT = 7, NUMSTA = 15, NUMTXT = 21)
      INTEGER NUMBLD(NUMTXT) 
      INTEGER NTEMP1, NTEMP2
      DOUBLE PRECISION A(NMAX,NMAX),
     +                 A1(NRMAX,NCMAX), 
     +                 VECTOR(NMAX**2 + 6)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.00D+00) 
      CHARACTER (LEN = 1024) FNAMEA(8), FNAME, STUB
      CHARACTER (LEN = 100 ) HEADER, TEXT(NUMTXT), TITLEA(8)
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (BLANK = ' ')
      PARAMETER (HEADER = 'Simplified Version of Simfit plot options')	
      LOGICAL    ABORT, FIRST, NEWDAT, REPEET
      LOGICAL    UNUSED(NMAX,NMAX)
      EXTERNAL   LSTBOX, SV_MATTIN, X_DEMDIR, OFILES
      EXTERNAL   SV_ADD_PLOT, PLOT24
      DATA FIRST / .TRUE. /
      DATA FNAMEA / BLANK, BLANK, BLANK, BLANK,
     +              BLANK, BLANK, BLANK, BLANK / 
      DATA TITLEA / BLANK, BLANK, BLANK, BLANK,
     +              BLANK, BLANK, BLANK, BLANK /
      DATA NEWDAT / .FALSE. /
      SAVE FIRST, FNAMEA, TITLEA, NEWDAT 
C
C Initialise
C     
      DO I = 1, NMAX
         DO J = 1, NMAX
            A(I,J) = ZERO
         ENDDO
      ENDDO
      DO I = 1, NRMAX
         DO J = 1,NCMAX
            A1(I,J) = ZERO
         ENDDO
      ENDDO      
      DO I = 1, NMAX*NMAX + 6
         VECTOR(I) = ZERO
      ENDDO 
      NCOL = 0
      NROW = 0          
C
C First get the demo folder, define STUB then initialise FNAME(i)
C     
      IF (FIRST) THEN
         FIRST = .FALSE. 
         CALL X_DEMDIR (L,
     +                  STUB)
         IF (STUB(L:L).NE. '\') THEN
            L = L + 1
            STUB(L:L) = '\'
         ENDIF 
         FNAMEA(1) = STUB(1:L)//'SV_PLOT.TF1'
         FNAMEA(2) = STUB(1:L)//'SV_PLOT.TF2'
         FNAMEA(3) = STUB(1:L)//'SV_PLOT.TF3'
         FNAMEA(4) = STUB(1:L)//'SV_PLOT.TF4'
         FNAMEA(5) = STUB(1:l)//'SV_PLOT.TF5'
         FNAMEA(6) = STUB(1:l)//'SV_PLOT.TF6'
         FNAMEA(7) = STUB(1:l)//'SV_PLOT.TF7'
         FNAMEA(8) = STUB(1:l)//'SV_PLOT.TF8'
       ENDIF   
C
C Define the LSTBOX menu then call LSTBOX
C      
      DO I = 1, NUMTXT
         NUMBLD(I) = 0
      ENDDO 
      NUMBLD(1) = 4
      WRITE (TEXT,100)
      NUMDEC = 1
      
      REPEET = .TRUE.
      DO WHILE (REPEET)       
   20    CONTINUE
         CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                TEXT)
C
C Check for the special cases NUMDEC = 1, 2, < NUMOPT, and NUMDEC = NUMOPT
C     
         IF (NUMDEC.EQ.N1) THEN   
            KTYPE = N1
         ELSEIF (NUMDEC.EQ.N2) THEN 
            CALL SV_ADD_PLOT      
            GOTO 20
         ELSEIF (NUMDEC.LT.NUMOPT) THEN
            KTYPE = NUMDEC - N1
         ELSE   
            KTYPE = NUMOPT
            REPEET = .FALSE.
         ENDIF       
           
         IF (KTYPE.EQ.1) THEN
             CALL PLOT24
         ELSEIF (KTYPE.EQ.2) THEN
            OPEN (UNIT = NIN, FILE = FNAMEA(2))
            READ (NIN,'(A)') TITLEA(2)
            READ (NIN, *) NROW, NCOL
            DO I = 1, NROW
               READ (NIN, *) (A(I,J), J = 1, NCOL)
            ENDDO
            CLOSE (UNIT = NIN)
         ELSEIF (KTYPE.EQ.3) THEN
            OPEN (UNIT = NIN, FILE = FNAMEA(3))
            READ (NIN,'(A)') TITLEA(3)
            READ (NIN, *) NROW, NCOL
            DO I = 1, NROW
               READ (NIN, *) (A(I,J), J = 1, NCOL)
            ENDDO
            CLOSE (UNIT = NIN) 
          ELSEIF (KTYPE.EQ.4) THEN
            OPEN (UNIT = NIN, FILE = FNAMEA(4))
            READ (NIN,'(A)') TITLEA(4)
            READ (NIN, *) NROW, NCOL
            DO I = 1, NROW
               READ (NIN, *) (A1(I,J), J = 1, NCOL)
            ENDDO
            CLOSE (UNIT = NIN)       
          ELSEIF (KTYPE.EQ.5) THEN
            OPEN (UNIT = NIN, FILE = FNAMEA(5))
            READ (NIN,'(A)') TITLEA(5)
            READ (NIN, *) NTEMP1, NTEMP2
            DO I = 1, NTEMP1
               READ (NIN, *) VECTOR(I)
            ENDDO
            CLOSE (UNIT = NIN) 
            NCOL = NINT(VECTOR(1))
            NROW = NINT(VECTOR(2))      
         ENDIF
C
C Next code only used when KTYPE < NUMOPT
C         
         IF (KTYPE.NE.1 .AND. KTYPE.NE.NUMOPT) THEN
            ABORT = .FALSE.
            NEWDAT = .FALSE.
            CALL SV_MATTIN (KTYPE, NCMAX, NCOL, NMAX, NRMAX, NROW,
     +                      NTEMP1, NTEMP2,    
     +                      A, A1, VECTOR,
     +                      FNAMEA(KTYPE), HEADER, TITLEA(KTYPE),
     +                      ABORT, NEWDAT, UNUSED)
            IF (.NOT.ABORT) THEN                 
               IF (NEWDAT) THEN
                  ISEND = 3
                  FNAME = FNAMEA(KTYPE) 
                  CLOSE (UNIT = NIN)
                  CALL OFILES (ISEND, NIN,
     +                         FNAME,
     +                         ABORT) 
                  CLOSE (UNIT = NIN)
                  IF (.NOT.ABORT) THEN
                     FNAMEA(KTYPE) = FNAME
                     OPEN (UNIT = NIN,FILE = FNAME)
                     READ (NIN,'(A)') TITLEA(KTYPE)
                     CLOSE (UNIT = NIN) 
                  ENDIF 
               ENDIF   
            ENDIF
         ENDIF   
      ENDDO
C
C Format statement
C        
  100 FORMAT (    
     + 'Demonstrating sv_Simfit plotting styles'
     +/
     +/'This section runs in the inexperienced user mode so that'
     +/'when a plot is chosen you can view the actual data as a'
     +/'numerical table or as the original data file with a header'
     +/'and trailer section. You can then arrange your data into'
     +/'the correct file format to plot your results.'
     +/
     +/'The simple plot allows limited editing but tranferring into'
     +/'Advanced Graphics permits extensive editing including adding'
     +/'further data sets for plotting. A right button click on any'
     +/'plot explains the difference between Simple and Advanced'         
     +/'graphics. The other plots are in Advanced Graphics.'
     +/
     +/'Display up to four simple plots'
     +/'How to add new data to a simple plot' 
     +/'Display a pie chart (Labels on the data file)'
     +/'Display a bar chart (Labels on the data file)'
     +/'Display a 3D space curve'
     +/'Display a 3D surface/contours'
     +/'Quit ... Exit the simplified version of simplot') 
      END
c
c
      subroutine sv_add_plot
      implicit none
      integer i
      integer icolor, ix, iy, lshade, numtxt
      parameter (icolor = 9, ix = 0, iy = 0, lshade = 0, numtxt = 20)
      integer numbld(numtxt)
      character (len = 100) text(numtxt)
      logical border
      parameter (border = .false.)
      external patch1
      do i = 1, numtxt
         numbld(i) = 0
      enddo    
      numbld(1) = 1
      write (text,100)
      call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +             text, border)
  100 format (
     +' Adding additional data for plotting'
     +/
     +/'It is easy to add extra data for plotting when a single data'
     +/'set has been plotted.'
     +/
     +/'Pressing the [Advanced] button will allow you to transfer the' 
     +/'data set into the Simfit Advanced Plotting routine that will'
     +/'allow extensive editing before saving hardcopy.'
     +/
     +/'One of the advanced editing options is [Data] and, when this' 
     +/'is pressed, it is possible to enter additional data sets for' 
     +/'plotting as existing files you have prepared, or by simply'
     +/'typing in a new data set using the numerical editor interface.'
     +/
     +/'In order for the data you input to be plotted correctly you'
     +/'must have x-values in the first column in increasing order'
     +/'and corresponding y-values in the second column.'
     +/     
     +/'The main program called Simplot allows you to do this or to'
     +/'input several files at the same time as a library file.')
      end
c
c       
C
C
      SUBROUTINE SV_MATTIN (KTYPE, NCMAX, NCOL, NMAX, NRMAX, NROW,
     +                      NTEMP1, NTEMP2,  
     +                      A, A1, VECTOR,
     +                      FNAMEA, HEADER, TITLEA,
     +                      ABORT, NEWDAT, UNUSED)
C
C ACTION : Provide a matrix for plotting
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          05/02/2006 derived from VEC4IN
C          14/02/2006 added FNAME to arguments and control
C          21/05/2006 deleted X, Y in calls to MATTRN 
C          26/02/2007 added INTENTS 
C          02/04/2007 allowed NCOL = 1, i.e. vectors
C          12/10/2007 removed allocatable and allowed temporary file creation
C          19/04/2008 increased output format to E15.7
C          10/07/2008 added FNAMEB, NWMAX, and call to CPYTRL to copy trailer
C          06/04/2010 trapped ncol < 1 or nrow < 1 but allowed ncol = 1 or nrow = 1
C          12/09/2023 adapted for simplified version of simfit
C          04/02/2024 corrected to allow labels and changing data files 
C
C        NCMAX: (input/unchanged) max. column dimension
C         NCOL: (input/OUTPUT) column dimension
C         NMAX: (input/unchanged) max. row dimension
C         NROW: (input/OUTPUT) row dimension
C            A: (input/OUTPUT) sample (may be edited)
C       FNAMEA: (input/OUTPUT) file name (may be changed)
C       HEADER: (input/unchanged) header for menu
C       TITLEA: (input/OUTPUT) title
C        ABORT: (OUTPUT) error indicator
C       NEWDAT: (OUTPUT) requests new data
C
C Note: This version can change NCOL and NROW and only
C       returns ABORT = .TRUE. if there are no appropriate data, or the user
C       has selected Cancel to abort further calculations. It does not set
C       ABORT = .TRUE. if the user fails to read in data as it will just leave
C       any existing data unchanged. This involves the use of X and Y so it
C       is important that NMAX >= NROW. NEWDAT is returned
C       as .TRUE. only if new data are requested.
C
      IMPLICIT   NONE
      INCLUDE <WINDOWS.INS>
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: KTYPE, NMAX 
      INTEGER,             INTENT (IN)    :: NCMAX, NRMAX
      INTEGER,             INTENT (INOUT) :: NCOL, NROW 
      INTEGER,             INTENT (IN)    :: NTEMP1, NTEMP2 
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NMAX,NMAX)
      DOUBLE PRECISION,    INTENT (INOUT) :: A1(NRMAX,NCMAX)  
      DOUBLE PRECISION,    INTENT (INOUT) :: VECTOR(NMAX**2 + 6)
      CHARACTER (LEN = *), INTENT (INOUT) :: HEADER
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAMEA, TITLEA
      LOGICAL,             INTENT (INOUT) :: UNUSED(NMAX,NMAX)         
      LOGICAL,             INTENT (INOUT) :: ABORT, NEWDAT
C
C Locals
C
      INTEGER    ICOLOR, ISEND, IX, IY, JSEND, LSHADE, NUMDEC, 
     +           NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, JSEND = 3,
     +           NUMOPT = 6, NSTART = 12, NTEXT = NUMOPT + NSTART - 1)
      INTEGER    N0, N1, N2, N3, N4, N5, N500, NLABEL 
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N500 = 500, NLABEL = 20)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    JCOLOR(20), JFILL(20)
      INTEGER    ITYPE
      PARAMETER (ITYPE = 1)
      INTEGER    I, L_PLOT, M_PLOT, N, NX, NY
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00) 
      DOUBLE PRECISION TIME, XMAX, XMIN, YMAX, YMIN
      PARAMETER (TIME = 0.1D+00) 
      DOUBLE PRECISION X(N500), XTEMP(N500), Y(N500), YTEMP(N500), 
     +                 Z(N500)
      DOUBLE PRECISION FACT(NLABEL)
      CHARACTER  FORM12*12, WORD12_C*12, WORD12_R*12
      CHARACTER  ZNAME*80, ZTITLE*80
      CHARACTER  CIPHER*30, LINE*100, TEXT(30)*100
      CHARACTER  CHOP80*80, TRIM80*80
      CHARACTER  BLANK*1, DONE*1, NODATA*1, READY*1, STATE*1
      CHARACTER (LEN = 40) LABEL(20), LABEL1(20), PANEL(20),
     +           TITLES(20), WORDX(20), VECTORS(60)
      PARAMETER ( BLANK = ' ',
     +             DONE = '*',
     +           NODATA = 'X',
     +            READY = '*')
      LOGICAL    ABORT1
      LOGICAL    BORDER, EDITED, FLASH, HIGH, REPEET
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    CURVE, FIXCOL, FIXROW, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .FALSE.,
     +           ORDER = .FALSE., WEIGHT = .FALSE.)
      LOGICAL    SHOW_LABELS
      PARAMETER (SHOW_LABELS = .TRUE.)
      EXTERNAL   PUTFAT, VBOX01, CHOP80, EDITOR, BCPLOT, SPACE0, SURD2S,  
     +           PATCH1, VIEWER, TRIM80, FORM12, GKS001, PCPLOT 
      EXTERNAL   EOFCHA, LABELS
      EXTERNAL   SLEEP1@
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       L_PLOT, M_PLOT / 1, 5 /
C
C Check NRMAX = N500 and NCMAX >= 3
C    
      IF (NRMAX.NE.N500 .OR. NCMAX.LT.3) CALL PUTFAT (
     +'Must have NRMAX = N500 and NCMAX >= 3 in call to SV_MATTIN')
C
C Initialise
C
      CALL SLEEP1@(TIME)
      ABORT = .FALSE.
      NEWDAT = .FALSE.
      ZNAME = TRIM80(FNAMEA)
      ZTITLE = CHOP80(TITLEA)
      DO I = 1, NLABEL
        LABEL(I) = BLANK
        TITLES(I) = BLANK
      ENDDO   
C
C for sv_mattin
C      
      ISEND = KTYPE     
      IF (KTYPE.EQ.4) THEN
         N = NROW
         DO I = 1, N
            X(I) = A1(I,1)  
            Y(I) = A1(I,2)  
            Z(I) = A1(I,3)
         ENDDO
      ENDIF        
C
C Loop
C
      EDITED = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (NCOL.LT.N1 .OR. NROW.LT.N1) THEN
            STATE = NODATA
            NUMDEC = N5
         ELSE
            STATE = READY
            NUMDEC = N1
         ENDIF
         IF (EDITED) THEN
            CIPHER = DONE
         ELSE
            CIPHER = BLANK
         ENDIF
         WORD12_R = FORM12(NROW)
         WORD12_C = FORM12(NCOL)
         WRITE (TEXT,100) HEADER, ZNAME, ZTITLE, WORD12_R, 
     +                    WORD12_C, STATE, CIPHER
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         NUMBLD(7) = N1
         CALL VBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         NUMBLD(4) = N0
         NUMBLD(7) = N0
         IF (NUMDEC.LT.N5) THEN
            IF (NCOL.LT.N1 .OR. NROW.LT.N1) THEN
               WRITE (LINE,200)
               CALL PUTFAT (LINE)
               NUMDEC = N0
            ENDIF
         ENDIF   
         IF (NUMDEC.EQ.N1) THEN
C
C Analyse
C              
            IF (KTYPE.EQ.1) THEN
C
C KTYPE = 1: standard x,y plot
C              
               N = NROW
               DO I = 1, N
                  X(I) = A1(I,1)
                  Y(I) = A1(I,2)
               ENDDO  
               CALL TEMPORARY_YIELD@() 
               CALL GKS001 (L_PLOT, M_PLOT, N,
     +                      X, Y,            
     +                      ZTITLE, 'X', 'Y') 
               CALL TEMPORARY_YIELD@()
            ELSEIF (KTYPE.EQ.2) THEN
C
C KTYPE = 2: piechart
C
C---------------------------------------------------------------------------
C---------------------------------------------------------------------------
C Note: The following information concerns subsroutines labels and eofcha 
C       subroutine labels sets default labels etc. and expects dimensions 
C       jcolor(20), jfill(20), label(20), panel(20), wordx(20), vectors(60)
C       that I must have done for some reason and should be corrected. 
C       subroutine eofcha reads data set as begin{labels) ... end{labels}
C--------------------------------------------------------------------------- 
C---------------------------------------------------------------------------
C   
               CALL LABELS (JSEND, JCOLOR, JFILL,
     +                      LABEL, PANEL, WORDX, VECTORS)
               N = NROW
               CALL EOFCHA (N, 
     +                      FNAMEA, LABEL1,
     +                      ABORT1)
               IF (.NOT.ABORT1) THEN
                  DO  I = 1, NROW
                     LABEL(I) = LABEL1(I)
                  ENDDO
               ENDIF      
               DO I = 1, NROW
                  FACT(I) = ZERO
                  X(I) = A(I,1)
               ENDDO  
               I = 2
               CALL TEMPORARY_YIELD@()
               CALL PCPLOT (I, JFILL, JCOLOR, N,
     +                      FACT, X,
     +                      LABEL, ZTITLE) 
               CALL TEMPORARY_YIELD@()
            ELSEIF (KTYPE.EQ.3) THEN
C
C KTYPE = 3: barchart (Now accepts begin{labels} ... end{labels} as with piecharts)
C    
               CALL LABELS (JSEND, JCOLOR, JFILL,
     +                      LABEL, PANEL, WORDX, VECTORS)
               N = NROW
               CALL EOFCHA (N, 
     +                      FNAMEA, LABEL1,
     +                      ABORT1)
               IF (.NOT.ABORT1) THEN
                  DO  I = 1, NROW
                     LABEL(I) = LABEL1(I)
                  ENDDO
               ENDIF                
               I = 2
               CALL TEMPORARY_YIELD@()
               CALL BCPLOT (I, NCOL, NMAX, NROW,
     +                      A,
     +                      LABEL, TITLES) 
               CALL TEMPORARY_YIELD@()
            ELSEIF (KTYPE.EQ.4) THEN
C
C KTYPE = 4: space curve
C           
               CALL TEMPORARY_YIELD@()
               CALL SPACE0 (N, N500, 
     +                      X, XTEMP, Y, YTEMP, Z)       
               CALL TEMPORARY_YIELD@()  
            ELSEIF (KTYPE.EQ.5) THEN
C
C KTYPE = 5: surface/contours
C           
C          ISEND = 1: supply MODEL, calculate NX, NY, VECTOR, Z
C          ISEND = 2: read VECTOR  from  file, calculate NX, NY, Z
C          ISEND = 3: user supplies VECTOR, calculate NX, NY, Z
C          ISEND = 4: user supplies NX, NY, Z, calculate VECTOR
C
               ISEND = 3 
               NX = NINT(VECTOR(1))
               NY = NINT(VECTOR(2))
               XMIN = VECTOR(3)
               XMAX = VECTOR(4)
               YMIN = VECTOR(5)
               YMAX = VECTOR(6) 
               CALL TEMPORARY_YIELD@()
               CALL SURD2S (ISEND, NMAX, NX, NY,
     +                      VECTOR, XMAX, XMIN, YMAX, YMIN, A,
     +                      UNUSED)
               CALL TEMPORARY_YIELD@()                   
            ENDIF
            
            ABORT = .FALSE.
            NEWDAT = .FALSE.
            
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C View data
C
            WRITE (LINE,300)
            ISEND = N1
            IF (KTYPE.EQ.1 .OR. KTYPE.EQ.4) THEN
               CALL EDITOR (ISEND, ITYPE, NCOL, NRMAX, NROW,
     +                      A1,
     +                      LINE,
     +                      CURVE, FIXCOL, FIXROW, SHOW_LABELS, ORDER, 
     +                      WEIGHT)
            ELSEIF (KTYPE.EQ.2 .OR. KTYPE.EQ.3) THEN  
                CALL EDITOR (ISEND, ITYPE, NCOL, NMAX, NROW,
     +                       A,
     +                       LINE,
     +                       CURVE, FIXCOL, FIXROW, SHOW_LABELS, ORDER, 
     +                       WEIGHT)
            
            ELSEIF (KTYPE.EQ.5) THEN
               CALL EDITOR (ISEND, ITYPE, NTEMP2, NTEMP1, NTEMP1,
     +                      VECTOR,
     +                      LINE,
     +                      CURVE, FIXCOL, FIXROW, SHOW_LABELS, ORDER, 
     +                      WEIGHT)
            ENDIF   
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C View file
C
            CALL VIEWER (N1,
     +                   FNAMEA, BLANK, BLANK)
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C Read in new A data
C
            ABORT = .FALSE.
            NEWDAT = .TRUE.
            REPEET = .FALSE. 
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C Help
C
            WRITE (TEXT,1000)
            I = 22
            NUMBLD(1) = N1
            NUMBLD(10) = N1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, I,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = N0
            NUMBLD(10) = N0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            ABORT = .FALSE.
            REPEET = .FALSE.
            RETURN
         ENDIF
      ENDDO   
C
C Format statements
C
  100 FORMAT (
     + A
     +/
     +/'Name of the current data file is:'
     +/A
     +/
     +/'Title of the current data set is:'
     +/A
     +/
     +/'Number of rows =',1X,A
     +/'Number of columns =',1X,A
     +/
     +/'Plot',1X,A
     +/'Show data',1X,A
     +/'View file'
     +/'New file'
     +/'Help'
     +/'Quit ... Exit')
  200 FORMAT ('Insufficient data')
  300 FORMAT ('Viewing the current data')
 1000 FORMAT (
     + 'Supplying a data sample for analysis'
     +/
     +/'The analytical procedure you have selected requires one sample'
     +/'in the form of a data matrix with no missing values, that is'
     +/'X with N rows and M columns, and the N*M elements'
     +/'x(1,1), x(1,2), ..., x(1,M)'
     +/'x(2,1), x(2,2), ..., x(2,M)'
     +/'...'
     +/'x(N,1), x(N,2), ..., x(N,M)'
     +/'Alternative methods to supply data'
     +/'1)`You can make a file using program MAKMAT. This is the best'
     +/'  `method since a permanent copy of your data will be saved.'
     +/'2)`You can create a file from your spreadsheet program, e.g.'
     +/'  `from Excel using a macro such as simfit6.xls.'
     +/'3)`You can copy a table from your spreadsheet to the clipboard'
     +/'  `then paste it in after choosing the [New data] option.'
     +/'4)`You can type in small samples at the terminal.'
     +/'5)`You can edit or transform an existing sample interactively.'
     +/'  `If you do this it will not alter the original data set'
     +/'  `which will be restored after analysis has been completed.'
     +/'6)`Any format can be used, e.g. 10, 10.0, 1.e1, 1.0e+01, etc.'
     +/'  `for ten, but you should always supply a meaningful title.')
      END
C
C


















