C
C
      SUBROUTINE ADVISE$(NGRAFS,
     +                   DVER,
     +                   ABORT, FIRST, VIEW_PLOT)
C
C Advise user
C Note that VIEW_PLOT is initialised in this routine and cannot be changed again 
C so ADVISE$ should only be called once and that is from SIMPLOT when starting up          
C
      IMPLICIT   NONE
C
C Arguments: NMAX (input/unchanged), ABORT and FIRST (input/output)
C
      INTEGER,             INTENT (IN)  :: NGRAFS
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (IN)  :: FIRST
      LOGICAL,             INTENT (OUT) :: ABORT
      LOGICAL,             INTENT (OUT) :: VIEW_PLOT
C
C Locals
C
      INTEGER    NUMDEC
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 7, NUMHDR = 14, NUMOPT = 4)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    AGAIN
      EXTERNAL   TITLES, HELP_SIMPLOT
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'First-time user',
     +'Experienced user',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER, NGRAFS
            NUMDEC = 1
            CALL TITLES (ICOLOR, NUMBLD, NUMDEC, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            NUMDEC = 1
         ENDIF
         IF (NUMDEC.EQ.1) THEN
            CALL HELP_SIMPLOT ('simplot')
            IF (FIRST) THEN
               AGAIN = .TRUE.
            ELSE
               AGAIN = .FALSE.
            ENDIF
         ELSEIF (NUMDEC.EQ.2) THEN
            VIEW_PLOT = .TRUE.
            ABORT = .FALSE.
            AGAIN = .FALSE.
         ELSEIF (NUMDEC.EQ.3) THEN
            VIEW_PLOT = .FALSE.
            ABORT = .FALSE.
            AGAIN = .FALSE.   
         ELSEIF (NUMDEC.EQ.4) THEN
            ABORT = .TRUE.
            AGAIN = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `SIMPLOT'
     +/'        `      '
     +/'Action  `Get data from files, clipboard, other programs.'
     +/'        `Then edit title, legends, error bars, symbols,'
     +/'        `lines, extra text, arrows to compose a graph.'
     +/'        `      '
     +/'Version `',A
     +/'        `Maximum number of curves displayed simultaneously',I5
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
       END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE DETAIL$(ISEND, NF,
     +                   FNAME,
     +                   BAR_CHART, LIB_FILE, PIE_CHART, SUPPLY_XY,
     +                   TWO_PLOTS, TYPE_IN, VECTOR_FIELD, VIEW_PLOT)
C
C Details of plot type required
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NF 
      INTEGER,             INTENT (INOUT) :: ISEND
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME
      LOGICAL,             INTENT (IN)    :: VIEW_PLOT
      LOGICAL,             INTENT (OUT)   :: BAR_CHART, LIB_FILE,
     +                                       PIE_CHART,
     +                                       SUPPLY_XY,
     +                                       TWO_PLOTS, TYPE_IN,
     +                                       VECTOR_FIELD
C
C Locals
C
      INTEGER    I
      INTEGER    N1, N2, N20, N23, N60, NLGL
      PARAMETER (N1 = 1, N2 = 2, N20 = 20, N23 = 23, N60 = 60,
     +           NLGL = 15)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMDEC, NUMBLD(30), NUMPOS(30)
      INTEGER    JCOLOR_1(N20), KCOLOR(N20), L(N20), M(N20)
      INTEGER    JCOLOR_2(N20), JFILL(N20)
      INTEGER    MCOLOR, JXL, JYL, JSHADE, JUMTXT
      PARAMETER (MCOLOR = 9, JXL = 4, JYL = 4, JSHADE = 1, JUMTXT = 20)
      INTEGER    JUMBLD(JUMTXT)
      INTEGER    KVAL_11, NKLCFG
      DOUBLE PRECISION SIZES(N20), THICK(N20)
      CHARACTER  TEXT(30)*100
      CHARACTER  LABEL1(N20)*40, PANEL1(N20)*40, WORDX1(N20)*40,
     +           VECTOR1(N60)*40
      LOGICAL    LA(NLGL), LS(NLGL)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    STORE
      PARAMETER (STORE = .TRUE.)
      LOGICAL    AGAIN, DISPLAY(10), MAIN_MENU, META_FILE, REPEET
      EXTERNAL   SIMOPT$
      EXTERNAL   SIMHLP, PUTMES, HELP_SIMPLOT
      EXTERNAL   LBOX01, PATCH1, LABELS, SYMBOL, GSTYLE, NKLCFG
      EXTERNAL   DEMSIM70
      EXTERNAL   SIMPLOT_METAFILE, SIMPLOT_REQUIRED

      external   simplot_test_files
      
      SAVE       DISPLAY
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 30*1 /
      DATA       JUMBLD / JUMTXT*0 /
      DATA       DISPLAY / 10*.TRUE. /

C
C Branch point after giving test file information
C
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
C
C First set all logicals to .FALSE.
C
         BAR_CHART = .FALSE.
         LIB_FILE = .FALSE.
         META_FILE = .FALSE.
         PIE_CHART = .FALSE.
         SUPPLY_XY = .FALSE.
         TWO_PLOTS = .FALSE.
         TYPE_IN = .FALSE.
         VECTOR_FIELD = .FALSE.
         META_FILE = .TRUE.
         DO WHILE (META_FILE)
            META_FILE = .FALSE.
            
  20  continue
  
            
            WRITE (TEXT,100)
            NUMBLD(1) = 4
            NUMBLD(26) = 1
            NUMBLD(27) = 1
            NUMOPT = 17
            NSTART = 9
            NTEXT = 27
            NUMDEC = 10
            CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                   NUMOPT, NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            NUMBLD(1) = 0
            NUMBLD(26) = 0
            NUMBLD(27) = 0

            MAIN_MENU = .FALSE.
            IF (VIEW_PLOT) THEN  
               if ((numdec.ge.2 .and. numdec.le.9) .or. 
     +            numdec.eq.15) then
                  call simplot_test_files (numdec,
     +                                     main_menu)
                  if (main_menu) goto 20
               endif
            ENDIF
     
            CALL SIMPLOT_REQUIRED (NUMDEC)
            IF (NUMDEC.EQ.15) THEN
C
C Metafile replay has been requested so run it then go for another option 
C              
               CALL SIMPLOT_METAFILE
               META_FILE = .TRUE.
            ELSEIF (NUMDEC.GT.15) THEN
C
C One of the other options has been selected so proceed
C            
               NUMDEC = NUMDEC  + 1
            ENDIF     
         ENDDO   
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 19C ==========
C Simple options so call SIMOPT$ which can only return 1,2,3,4, o/w quit
C
            CALL SIMOPT$(ISEND, NF,
     +                   FNAME)
            IF (ISEND.EQ.1) THEN
C
C NUMDEC = 1, ISEND = 1
C =====================
C Type in x,y
C
               ISEND = 8
            ELSEIF (ISEND.EQ.2) THEN
C
C NUMDEC = 1, ISEND = 2
C =====================
C Type in a matrix
C
               ISEND = 9
            ELSEIF (ISEND.EQ.3) THEN
C
C NUMDEC = 1, ISEND = 3
C =====================
C Exhaustive analysis of a vector
C
               ISEND = 10
               RETURN
            ELSEIF (ISEND.EQ.4) THEN
C
C NUMDEC = 1, ISEND = 4
C =====================
C Exhaustive analysis of a matrix
C
               ISEND = 11
               RETURN
            ELSEIF (ISEND.EQ.5) THEN
C
C NUMDEC = 1, ISEND = 5
C ======================
C Dendrogram
C           
               ISEND = 12    
               RETURN
           ELSEIF (ISEND.EQ.6) THEN
C
C NUMDEC = 1, ISEND = 6
C =====================
C K-means clusters
C           
               ISEND = 13    
               RETURN
           ELSEIF (ISEND.EQ.7) THEN
C
C NUMDEC = 1, ISEND = 7
C =====================
C Principal components
C           
               ISEND = 14    
               RETURN
           ELSEIF (ISEND.EQ.8) THEN
C
C NUMDEC = 1, ISEND = 15
C ======================
C Biplot
C           
               ISEND = 15    
               RETURN  
            ELSEIF (ISEND.EQ.9) THEN
C
C NUMDEC = 1, ISEND = 16
C ======================
C MANOVA symbol/labels plots
C            
               ISEND = 16
               RETURN                
            ELSE
C
C NUMDEC = 1, QUIT FROM SIMOPT$
C =============================
C No choice
C              
               ISEND = 0
            ENDIF
         ELSEIF (NUMDEC.LE.8) THEN
C
C 2 =< NUMDEC =< 8
C ================
C Standard options so just subtract 1 to define ISEND
C
            ISEND = NUMDEC - 1
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C
C NUMDEC = NUMOPT - 1
C ===================
C Demonstration
C 
            ISEND = 18           
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C NUMDEC = NUMOPT
C ===============
C QUIT 
C         
            ISEND = 19
         ELSE
C
C 9 =< NUMDEC < NUMOPT - 1
C ========================
C Help/Configure options so just add 1 to define ISEND
C           
            ISEND = NUMDEC + 1
         ENDIF
C
C Subsequent options now depend on ISEND
C    
         IF (ISEND.GE.1 .AND. ISEND.LE.10) THEN
C
C Get KVAL_11 to see if first-time messages are to be displayed
C      
            KVAL_11 = NKLCFG(N23)                
         ENDIF
            
         IF (ISEND.EQ.0) THEN
C
C ISEND = 0
C =========
C No option returned from SIMOPT$
C
            AGAIN = .TRUE.
         ELSEIF (ISEND.EQ.1) THEN
C
C ISEND = 1 (NUMDEC = 2)
C =========
C Normal x,y
C
            LIB_FILE = .FALSE.
            IF (DISPLAY(1) .AND. KVAL_11.EQ.N1) THEN
               WRITE (TEXT,1)
               I = 21
               CALL PUTMES (I, TEXT)
               DISPLAY(1) = .FALSE.
            ENDIF
            REPEET = .TRUE.
            DO WHILE (REPEET)
               WRITE (TEXT,200)
               NUMDEC = 4
               NUMOPT = 5
               NSTART = 8
               NTEXT =  NSTART + NUMOPT - 1
               NUMBLD(1) = 4 
               NUMBLD(3) = 1
               CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, 
     +                      NUMOPT, NUMPOS, NSTART, NTEXT,
     +                      TEXT,
     +                      BORDER, FLASH, HIGH)
               NUMBLD(1) = 0
               NUMBLD(3) = 0
               LIB_FILE = .FALSE.
               IF (NUMDEC.EQ.1) THEN
                  LIB_FILE = .TRUE.
                  AGAIN = .FALSE.
                  SUPPLY_XY = .FALSE.
                  REPEET = .FALSE.
               ELSEIF (NUMDEC.EQ.2) THEN
                  AGAIN = .FALSE.
                  SUPPLY_XY = .FALSE.
                  REPEET = .FALSE.
               ELSEIF (NUMDEC.EQ.3) THEN
                  AGAIN = .FALSE.
                  SUPPLY_XY = .TRUE.
                  REPEET = .FALSE.
               ELSEIF (NUMDEC.EQ.4) THEN
                  REPEET = .TRUE.
                  WRITE (TEXT,300)
                  JUMBLD(1) = 1
                  CALL PATCH1 (MCOLOR, JXL, JYL, JSHADE, JUMBLD, JUMTXT,
     +                         TEXT,
     +                         BORDER)
                  JUMBLD(1) = 0
               ELSE
                  REPEET = .FALSE.
               ENDIF
            ENDDO
         ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2 (NUMDEC = 3)
C =========
C Double plot
C
            TWO_PLOTS = .TRUE.
            IF (DISPLAY(2) .AND. KVAL_11.EQ.N1) THEN
               WRITE (TEXT,2)
               I = 15
               CALL PUTMES (I, TEXT)
               DISPLAY(2) = .FALSE.
            ENDIF
            AGAIN = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3 (NUMDEC = 4)
C =========
C Bar chart
C
            BAR_CHART = .TRUE.
            IF (DISPLAY(3) .AND. KVAL_11.EQ.N1) THEN
               WRITE (TEXT,3)
               I = 23
               CALL PUTMES (I, TEXT)
               DISPLAY(3) = .FALSE.
            ENDIF
            AGAIN = .FALSE.
         ELSEIF (ISEND.EQ.4) THEN
C
C ISEND = 4 (NUMDEC = 5)
C =========
C Pie chart
C
            PIE_CHART = .TRUE.
            IF (DISPLAY(4) .AND. KVAL_11.EQ.N1) THEN
               WRITE (TEXT,4)
               I = 20
               CALL PUTMES (I, TEXT)
               DISPLAY(4) = .FALSE.
            ENDIF
            AGAIN = .FALSE.
         ELSEIF (ISEND.EQ.5) THEN
C
C ISEND = 5 (NUMDEC = 6)
C =========
C Vector field
C
            VECTOR_FIELD = .TRUE.
            IF (DISPLAY(5) .AND. KVAL_11.EQ.N1) THEN
               WRITE (TEXT,5)
               I = 11
               CALL PUTMES (I, TEXT)
               DISPLAY(5) = .FALSE.
            ENDIF
            AGAIN = .FALSE.
         ELSEIF (ISEND.EQ.6) THEN
C
C ISEND = 6 (NUMDEC = 7)
C =========
C Surface
C
            IF (DISPLAY(6) .AND. KVAL_11.EQ.N1) THEN
               WRITE (TEXT,6)
               I = 21
               CALL PUTMES (I, TEXT)
               DISPLAY(6) = .FALSE.
            ENDIF
            AGAIN = .FALSE.
         ELSEIF (ISEND.EQ.7) THEN
C
C ISEND = 7 (NUMDEC = 8)
C =========
C Space curve
C
            IF (DISPLAY(7) .AND. KVAL_11.EQ.N1) THEN
               WRITE (TEXT,7)
               I = 11
               CALL PUTMES (I, TEXT)
               DISPLAY(7) = .FALSE.
            ENDIF
            AGAIN = .FALSE.
         ELSEIF (ISEND.EQ.8) THEN
C
C ISEND = 8
C =========
C Type in 2-D
C
            IF (DISPLAY(8) .AND. KVAL_11.EQ.N1) THEN
               WRITE (TEXT,8)
               I = 11
               CALL PUTMES (I, TEXT)
               DISPLAY(8) = .FALSE.
            ENDIF
            ISEND = 1
            TYPE_IN = .TRUE.
            AGAIN = .FALSE.
         ELSEIF (ISEND.EQ.9) THEN
C
C ISEND = 9
C =========
C Type in 3-D
C
            IF (DISPLAY(9) .AND. KVAL_11.EQ.N1) THEN
               WRITE (TEXT,9)
               I = 11
               CALL PUTMES (I, TEXT)
               DISPLAY(9) = .FALSE.
            ENDIF
            ISEND = 8
            AGAIN = .FALSE.
         ELSEIF (ISEND.EQ.10) THEN
C
C ISEND = 10 (NUMDEC = 9)
C ==========
C Parametric equations
C

            IF (DISPLAY(10) .AND. KVAL_11.EQ.N1) THEN
               WRITE (TEXT,10)
               I = 11
               CALL PUTMES (I, TEXT)
               DISPLAY(10) = .FALSE.
            ENDIF
            ISEND = 9
            AGAIN = .FALSE.
         ELSEIF (ISEND.EQ.11) THEN
C
C ISEND = 11 (NUMDEC = 10)
C ==========
C Help
C
            CALL HELP_SIMPLOT ('simplot')
            NUMDEC = 11
         ELSEIF (ISEND.EQ.12) THEN
C
C ISEND = 12 (NUMDEC = 11)
C ==========
C Details
C
            CALL SIMHLP 
            NUMDEC = 10
         ELSEIF (ISEND.EQ.13) THEN
C
C ISEND = 13 (NUMDEC = 12)
C ==========
C Configure lines, symbols and colours
C
            CALL SYMBOL (N2, JCOLOR_1, KCOLOR, L, M,
     +                   SIZES, THICK)
            NUMDEC = 10
         ELSEIF (ISEND.EQ.14) THEN
C
C ISEND = 14 (NUMDEC = 13)
C ==========
C Configure fill styles and labels
C
            CALL LABELS (N2, JCOLOR_2, JFILL,
     +                   LABEL1, PANEL1, WORDX1, VECTOR1)
            NUMDEC = 10
          ELSEIF (ISEND.EQ.15) THEN
C
C ISEND = 15 (NUMDEC = 14)
C ==========
C Configure plot styles
C
            CALL GSTYLE (NLGL,
     +                   LA, LS, STORE)            
            NUMDEC = 10   
         ELSEIF (ISEND.EQ.16) THEN
C
C ISEND = 16
C ==========
C
            ISEND = 10
            AGAIN = .FALSE.
         ELSEIF (ISEND.EQ.17) THEN
C
C ISEND = 17
C ==========
C         
            ISEND = 11
            AGAIN = .FALSE.
         ELSEIF (ISEND.EQ.18) THEN
C
C ISEND = 18 (NUMDEC = NUMOPT - 1)
C ==========
C Demonstration         
C
            CALL DEMSIM70   
         ELSE
C
C ISEND = 19 (NUMDEC = NUMOPT)
C ==========
C QUIT
C           
            ISEND = 17
            AGAIN = .FALSE.
         ENDIF
      ENDDO
    1 FORMAT (
     + 'First time message: the formats for normal (x,y) plots.'
     +/
     +/'To suppress this message use [Configure],[Advanced],[Speedup].'
     +/
     +/'You can input files with 2 columns(x,y), 3 columns (x,y,s),'
     +/'4 columns (x,yle,y,yue for low, mean, upper error bars) or 6'
     +/'columns (xle,x,xhe,yle,y,yhe error bars). A default plot will'
     +/'then be created with symbols only for small data sets but with'
     +/'no symbols and joined by lines for large data sets.'
     +/
     +/'Since this is tedious, it is best to collect all the data files'
     +/'together by creating a library file with all the filenames you'
     +/'require to overlay, then you only need to input one file. If'
     +/'the first file is library file, the input phase is terminated.'
     +/'You can also initiate a project, using multiple file selection.'
     +/
     +/'Whichever method is used for data input, all editing features'
     +/'can be used from the [Data] option.'
     +/
     +/'Use the configuration option to set colours, lines and symbols'
     +/'but note that defaults are overwritten by configuration files.')
    2 FORMAT (
     + 'First time message: the format for double plots.'
     +/
     +/'To suppress this message use [Configure],[Advanced],[Speedup].'
     +/
     +/'You input a succession of plot files and for each file you will'
     +/'be asked to assign the data to either the left hand y-axis, or'
     +/'the right hand y-axis. If you only specify one type then the'
     +/'plot type will revert to the normal (x,y) plotting type. The'
     +/'files can be (x,y), (x,y,s) or (x,yle,y,yue) type files.'
     +/
     +/'Whichever method is used for data input, all editing features'
     +/'can be used from the [Data] option, but transformations are not'
     +/'permitted since this could cause ambiguity with the shared x'
     +/'axis. Just use EDITMT to transform the data before plotting if'
     +/'you want a transformed double graph.')
    3 FORMAT (
     + 'First time message: the formats for creating bar charts.'
     +/
     +/'To suppress this message use [Configure],[Advanced],[Speedup].'
     +/
     +/'For simple bar charts input a m-rows by n-columns matrix and it'
     +/'will be assumed you want m groups, each containing n bars (the'
     +/'usual case) requiring one default label for each group. Your'
     +/'data will be transformed automatically and then written to a'
     +/'temporary (advanced) barchart file which you can edit and save.'
     +/'You can generate error bars or include error bar values from a'
     +/'m by n matrix of errors to be added to the corresponding bars.'
     +/
     +/'For advanced barcharts with extensive extra features you input'
     +/'an advanced barchart file (9 columns), giving you full control'
     +/'over the position, width, error bars, fill style, colour, and'
     +/'label for each individual bar. To appreciate the possibilities'
     +/'you should run and browse the test files barchart.tf?.'
     +/
     +/'Whichever method is used for data input, all editing features'
     +/'can be used from the [Data] option.'
     +/
     +/'Use the configuration option to set colours, styles and labels'
     +/'but note that advanced bar chart files over-ride defaults.')
    4 FORMAT (
     + 'First time message: the formats for pie charts.'
     +/
     +/'To suppress this message use [Configure],[Advanced],[Speedup].'
     +/
     +/'If you input a vector with n positive values it will be assumed'
     +/'that you want n segments with default labels, so your data will'
     +/'be transformed automatically then written to a temporary'
     +/'(advanced) piechart file which you can edit or save.'
     +/
     +/'For an advanced piechart using the extensive extra features you'
     +/'input an advanced piechart file (4 columns) giving full control'
     +/'over the displacement, fill style, colour, and label for each'
     +/'individual segment. To appreciate the possibilities you should'
     +/'run and browse the test files piechart.tf?.'
     +/
     +/'Whichever method is used for data input, all editing features'
     +/'can be used from the [Data] option.'
     +/
     +/'Use the configuration option to set colours, styles and labels'
     +/'but note that advanced pie chart files override defaults.')
    5 FORMAT (
     + 'First time message: the format for vector field and biplots.'
     +/
     +/'To suppress this message use [Configure],[Advanced],[Speedup].'
     +/
     +/'Normally you will only use this option to plot vector field and'
     +/'other flow type diagrams generated by the SIMFIT simulation'
     +/'programs. For instance a phase portrait for two autonomous'
     +/'differential equations using DEQSOL, or a multivariate biplot.'
     +/
     +/'To explore this plotting type just read in a test file such as'
     +/'vfield.tf1 for a vector field or vfield.tf2 for a biplot.')
    6 FORMAT (
     + 'First time message: the format for surface and contour plots.'
     +/
     +/'To suppress this message use [Configure],[Advanced],[Speedup].'
     +/
     +/'Normally you will only use this option to plot surfaces and'
     +/'contours generated for z = f(x,y) by the SIMFIT simulation'
     +/'programs. For instance a plot from MAKDAT or a best fit'
     +/'surface or objective function from QNFIT.'
     +/
     +/'To explore this plotting type just read in a test file such as'
     +/'surface.tf1, which is a vector file formatted as follows:-'
     +/'Nx, Ny, Xmin, Xmax, Ymin, Ymax, z(x,y) in order of columns of'
     +/'z for increasing x appended in sequence of increasing y. It is'
     +/'assumed that the x points are at fixed x-intervals and the y at'
     +/'fixed y-intervals.'
     +/
     +/'If you input a n by m matrix the program will assume the matrix'
     +/'is a set of z(x,y) values, and that you want to plot a 3-D bar'
     +/'chart with x-values = 1, 2, ..., n and y-values = 1, 2, ..., m,'
     +/'but you will be warned if there are too few z = f(x,y) values'
     +/'to plot a meaningful contour diagram.')
    7 FORMAT (
     + 'First time message: the format for space curves.'
     +/
     +/'To suppress this message use [Configure],[Advanced],[Speedup].'
     +/
     +/'You can use this option for arbitrary (x,y,z) data or to plot'
     +/'parametric space curves, as x(t), y(t), z(t) from a SIMFIT'
     +/'simulation programs. For instance data from MAKDAT, USERMOD or'
     +/'this program, using your own parametric model equations.'
     +/
     +/'To explore this plotting type just read in a test file such as'
     +/'the library file spiral.tfl.')
    8 FORMAT (
     + 'First time message: the format for typing in your 2-D data.'
     +/
     +/'To suppress this message use [Configure],[Advanced],[Speedup].'
     +/
     +/'Normally you will only use this option to plot simple x,y plots'
     +/'from a short table of data values. You first create a data file'
     +/'and with pie and bar charts this is used to create an advanced'
     +/'pie or bar chart file for plotting.'
     +/
     +/'Note that if you do use this option you can always save the'
     +/'advanced bar chart file for re-use from the [Data] option.')
    9 FORMAT (
     + 'First time message: the format for typing in your 3-D data.'
     +/
     +/'To suppress this message use [Configure],[Advanced],[Speedup].'
     +/
     +/'Normally you will only use this option to plot very simple'
     +/'3-D barcharts, scattergrams or space curves. This technique'
     +/'is definitely not the way to use this program.'
     +/
     +/'You should either use program MAKMAT to type in a data set or'
     +/'get one of the SIMFIT surface plotting programs to plot the'
     +/'data directly or create a file to save typing in again.')
   10 FORMAT (
     + 'First time message: the format for parametric curves.'
     +/
     +/'To suppress this message use [Configure],[Advanced],[Speedup].'
     +/
     +/'Normally you will only use this option to plot plane curves'
     +/'in the form r = r(theta) [or x = x(t), y = y(t)] or space'
     +/'curves in the form x = x(t), y = y(t), z = z(t). You must'
     +/'know how to prepare your own model files in SIMFIT format.'
     +/
     +/'It is better to practise first with program USERMOD and the'
     +/'test files rose.mod, ellipse.mod and helix.mod.')
  100 FORMAT (
     + 'Select a graph type then input the appropriate data'
     +/
     +/'Standard x,y plots have one vertical scale (y-axis) but double'
     +/'graphs use two scales. Files can have x,y or error bar values'
     +/'which can be overlayed then displayed as symbols only, lines'
     +/'only, or symbols and lines, to create the diagram required.'
     +/'Input a previously saved SIMPLOT metafile to resume editing.'
     +/
     +/'Simple and Statistical plots'
     +/'Normal plot with one X-axis and one Y-axis'
     +/'Double plot with one X-axis and two Y-axes'
     +/'Bar chart from a data matrix or advanced bar chart file'
     +/'Pie chart from a data vector or advanced pie chart file'
     +/'Vector field'
     +/'3-D surface/contours/barcharts [z = f(x,y)]'
     +/'3-D lines/symbols/arrows/labels [x,y,z swarms]'
     +/'User defined parametric equations'
     +/'Help: Summary'
     +/'Help: Details'
     +/'Configure: line-types and plot symbols'
     +/'Configure: fill-styles and chart labels'
     +/'Configure: simple and advanced plotting styles'
     +/'Configure: input a previously saved SIMPLOT metafile'
     +/'Demonstrate plotting styles'
     +/'Quit ... Exit program SIMPLOT'
     +/'With Standard x,y axes and 3D space curves, the first file can'
     +/'be a library file containing a list of files to be plotted.')
  200 FORMAT (
     + 'Supplying data files to SIMPLOT for plotting'
     +/
     +/'Method    `Action required'
     +/'Library   `All data files specified in one library file'
     +/'Individual`Files supplied interactively one at a time'
     +/'Project   `Select from the current plot file archive'
     +/
     +/'Input ... a library file'
     +/'Input ... individual files'
     +/'Input ... graph project files'
     +/'Help'
     +/'Cancel')
  300 FORMAT (
     + 'Alternative ways to input data for plotting'
     +/
     +/'If you just want to type in data for a single plot, select'
     +/'[Cancel] then choose to type in data interactively. You will'
     +/'then save the data to a file for re-use.'
     +/
     +/'If you want to plot single files, select the option to read in'
     +/'individual files (2 re-tries allowed after each failure).'
     +/
     +/'If you have a set of files to plot, it is best to use program'
     +/'MAKLIB to create a library file to reference all the files you'
     +/'want to plot. If the first file you select is a plotting file'
     +/'instead of a library file, then single file selection will be'
     +/'used as above, instead of the library file option.'
     +/
     +/'Experienced users can use the project option, which allows you'
     +/'to build a project by adding files singly, or by multiple file'
     +/'selection from disk filestore or from a project archive file,'
     +/'called g_recent.cfg, which stores a list of all graphics files'
     +/'you have used recently.')
      END

C
C-------------------------------------------------------------------------------------
  
c
c
      subroutine simplot_required (isend)
c
c action: set mask for the main simplot menu demo files
c author: w.g.bardsley, university of manchester, u.k., 28/06/2020
c      
      implicit none
c
c argument
c      
      integer, intent (in) :: isend
c
c locals
c      
      integer i
      integer nmask
      parameter (nmask = 10)
      integer mask(nmask)
      logical required(nmask)
      logical store
      parameter (store = .true.)
      external x_putadv, query_files_required
c
c check isend
c      
      if (isend.lt.1 .or. isend.gt.17) then
         call x_putadv (
     +'ISEND out of range in call to SIMPLOT_REQUIRED')
         return
      endif   
      if ((isend.ge.10 .and. isend.le.14) .or. isend.eq.16) return
      if (isend.eq.17) then
         do i = 1, nmask
            required(i) = .true.
         enddo
      else      
         do i = 1, nmask
            required(i) = .false.
         enddo    
         if (isend.ge.1 .and. isend.le.9) then
            required(isend) = .true.
         elseif (isend.eq.15) then
            required(nmask) = .true.     
         endif   
      endif
      do i = 1, nmask
         if (required(i)) then
            mask(i) = 1
         else
            mask(i) = 0
         endif  
      enddo
      call query_files_required (mask, nmask,
     +                           store)
      end
c
c          

      
C
C------------------------------------------------------------------------
C
      SUBROUTINE SIMOPT$(ISEND, NF, 
     +                   FNAME)
C
C Subsidiary options
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NF
      INTEGER,             INTENT (INOUT) :: ISEND
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME
C
C Locals
C
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NSTART = 3,
     +           NUMOPT = 12)
      INTEGER    NUMDEC, NUMBLD(30), NUMPOS(20)
      CHARACTER  TEXT(30)*100
      LOGICAL    ABORT, FIRST, REPEET
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   PATCH1, RESFIL, LBOX01, MVPLOT
      SAVE       FIRST
      DATA       FIRST / .TRUE. /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (TEXT,100)
         NUMDEC = ISEND
         NUMDEC = NUMOPT - 1
         NTEXT = NSTART + NUMOPT - 1
         NUMBLD(1) = 4
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         REPEET = .FALSE.
         IF (NUMDEC.EQ.1) THEN
C
C Type in for 2-D: ISEND = 1
C
            ISEND = 1
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Type in for 3-D: ISEND = 2
C
            ISEND = 2
         ELSEIF (NUMDEC.EQ.3) THEN
            IF (FIRST) THEN
C
C Exhaustive analysis of a vector: ISEND = 3
C
               FIRST = .FALSE.
               CALL RESFIL (NF, FNAME, ABORT)
               WRITE (NF,300)
            ENDIF
            ISEND = 3
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Exhaustive analysis of a matrix: ISEND = 4
C
            IF (FIRST) THEN
               FIRST = .FALSE.
               CALL RESFIL (NF, FNAME, ABORT)
               WRITE (NF,300)               
            ENDIF
            ISEND = 4
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Dendrogram: ISEND = 5
C
            IF (FIRST) THEN
               FIRST = .FALSE.
               CALL RESFIL (NF, FNAME, ABORT)
               WRITE (NF,300)               
            ENDIF
            ISEND = 5 
         ELSEIF (NUMDEC.EQ.6) THEN
C
C K-means clustering: ISEND = 6
C
            IF (FIRST) THEN
               FIRST = .FALSE.
               CALL RESFIL (NF, FNAME, ABORT)
               WRITE (NF,300)               
            ENDIF
            ISEND = 6
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Principal components: ISEND = 7
C
            IF (FIRST) THEN
               FIRST = .FALSE.
               CALL RESFIL (NF, FNAME, ABORT)
               WRITE (NF,300)               
            ENDIF
            ISEND = 7
         ELSEIF (NUMDEC.EQ.8) THEN
C
C Biplot: ISEND = 8
C
            IF (FIRST) THEN
               FIRST = .FALSE.
               CALL RESFIL (NF, FNAME, ABORT)
               WRITE (NF,300)               
            ENDIF
            ISEND = 8   
         ELSEIF (NUMDEC.EQ.9) THEN
C
C MANOVA values/scores as symbols/labels
C                                 
            ISEND = 9
         ELSEIF (NUMDEC.EQ.10) THEN
C
C Box-whisker/scatter/percentiles/error-bars
C            
            CALL MVPLOT
            REPEET = .TRUE.
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Help
C
            REPEET = .TRUE.
            WRITE (TEXT,200)
            NTEXT = 21
            NUMBLD(1) = 1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NTEXT,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = 0
         ELSE
C
C Quit: ISEND = 9
C
            ISEND = 9
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Simple and Statistical plotting options'
     +/
     +/'Type-in 2-D data then save/plot'
     +/'Type-in 3-D data then save/plot'
     +/'Exhaustive analysis of a vector'
     +/'Exhaustive analysis of a matrix'
     +/'Dendrogram'
     +/'K-means clusters'
     +/'Principal components'
     +/'Multivariate 2D and 3D biplots'
     +/'Multivariate values/scores as symbols/labels'
     +/'Box-whisker/scatter/percentiles/error-bars'
     +/'Help'
     +/'Cancel')
  200 FORMAT (
     + 'The simple plotting procedures'
     +/
     +/'These options are intended to enable first time users to become'
     +/'familiar with the advanced Simfit plotting techniques by giving'
     +/'the opportunity to plot single data sets in a several formats.'
     +/'For instance, you can read in a data file or type in some data'
     +/'to create a data file for interactive plotting.'
     +/
     +/'To use the exhaustive analysis of a vector you just provide a'
     +/'vector, i.e. a single column of data, which can then be plotted'
     +/'as a histogram, cumulative distribution, time series, mean'
     +/'centered rod plot, or pie chart (for positive values).'
     +/
     +/'To analyse a matrix you supply a n(rows) by m(columns) data set'
     +/'which can then be plotted as a 2-D barchart, a box and whisker'
     +/'plot, a scatter plot or a 3-D skyscaper/cylinder plot.'
     +/
     +/'The options to type in data interactively are not recommended'
     +/'for routine use, as Simplot is designed to work with data files'
     +/'stored in sets as graph project files, or library files, but'
     +/'they are useful for rapid plotting of small data sets.')
  300 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : SIMPLOT'
     +/1X,'ACTION  : Fit polynomials for calibration/evaluation'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')     
      END
C
C
