c
c
      subroutine plot_space_files
c
c action: Read in files then plot x,y,z type space data
c author: w.g.bardsley, university of manchester, u.k., 14/01/2008
c         02/08/2008 replaced call to isitmf by call to isitsf
c         17/10/2008 deleted call to demo3d 
c      
      implicit none
      integer    i, ios, iprev, isend, l1, l2, ncol, nout, nrow, ntemp, 
     +           ntotal 
      integer    len200
      integer    itype, nfmax, nfmin, nfiles, nin, nwmax
      parameter (itype = 3, nfmax = 300, nfmin = 1, nin = 3,
     +           nwmax = 2000)
      integer    icolor, ixl, iyl, lshade, numdec, numopt, numsta, 
     +           numtxt      
      parameter (icolor = 7, ixl = 4, iyl = 4, lshade = 0, numopt = 4,
     +           numsta = 15, numtxt = numopt + numsta - 1)     
      integer    numbld(numtxt), numpos(numopt)
      character  line*1024, simfit*1024, text(30)*100
      character  files(nfmax)*1024, ftemp*1024, lfile*1024
      character  blank*1, bslash*1
      parameter (blank = ' ', bslash = '\')
      logical    abort, again, repeet, there, yesno
      logical    accept(nfmax)
      logical    plot_arrows, plot_labels, plot_lines, 
     +           plot_perpendiculars, plot_symbols      
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      external   lbox01, getjm1, ofiles, getnou, yesno2, isitsf, len200,
     +           putfat, space6, isitlf, demdir, triml1, pfiles, chkbox      
      intrinsic  index
      data       numbld / numtxt*0 /
      data       numpos / numopt*1 /
      data       plot_arrows, plot_labels, plot_lines,
     +           plot_perpendiculars, plot_symbols
     +           / .false., .false., .false., .false., .true. / 
      numdec = numopt
      numbld(1) = 4
      repeet = .true.
c
c select files or demo
c      
      do while (repeet)
         nfiles = 0
         ntotal = 0
         write (text,100)
         call lbox01 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                numopt, numpos, numsta, numtxt,
     +                text,
     +                border, flash, high)
         if (numdec.eq.1) then
c
c method 1: select individual files
c           
            write (line,200)
            ntemp = 1
            call getjm1 (nfmin, ntemp, nfmax,
     +                   line)
            again = .true.
            do while (again .and. nfiles.lt.ntemp)
               call getnou (nout)
               close (unit = nout)
               isend = 3
               call ofiles (isend, nout, 
     +                      ftemp,
     +                      abort)
               close (unit = nout)
               if (.not.abort) then
                  call isitsf (ncol, nrow,
     +                         ftemp)  
                  if (nrow.lt.1 .or. ncol.ne.3) then
                     abort = .true.
                     write (line,300) nfiles + 1
                     call putfat (line) 
                     abort = .true.
                  endif
               endif 
               if (.not.abort) then
                  nfiles = nfiles + 1
                  files(nfiles) = ftemp
                  ntotal = ntotal + nrow
               else
                  write (line,400) nfiles 
                  yesno = .true.
                  call yesno2 (icolor, ixl, iyl, 
     +                         line,
     +                         yesno)
                  again = yesno 
               endif   
            enddo     
         elseif (numdec.eq.2) then
c
c method 2: use a library file
c         
            call getnou (nout)
            close (unit = nout)
            isend = 3
            call ofiles (isend, nout, 
     +                   lfile,
     +                   abort)
            close (unit = nout)
            if (.not.abort) then
               call isitlf (lfile,
     +                      yesno)  
               if (yesno) then
                  call demdir (l1,
     +                         simfit)                  
                  call getnou (nout)
                  open (unit = nout, file = lfile, iostat = ios)
                  if (ios.eq.0) read (nout,'(a)',iostat=ios) line
                  if (ios.eq.0) then  
                     again = .true.
                  else
                     again = .false.
                  endif      
                  do while (again)  
                     read (nout,'(a)',iostat=ios) ftemp
                     if (ios.ne.0 .or. ftemp.eq.blank) then
                        again = .false.
                        there = .false.
                     else
                        inquire (file = ftemp, exist = there,
     +                           iostat = ios)   
                        if (.not.there .and. ios.eq.0 .and. 
     +                      index(ftemp,bslash).le.0) then
                           line = ftemp
                           call triml1 (line)
                           l2 = len200(line)
                           ftemp = simfit(1:l1)//line(1:l2) 
                           inquire (file = ftemp, exist = there,
     +                              iostat = ios)
                        endif
                     endif
                     if (ios.eq.0 .and. there) then
                        call isitsf (ncol, nrow,
     +                               ftemp)
                        if (ncol.eq.3 .and. nrow.gt.0) then                       
                           nfiles = nfiles + 1
                           files(nfiles) = ftemp
                           ntotal = ntotal + nrow
                        else
                           write (line,300) nfiles + 1
                           call putfat (line) 
                           again = .false.
                        endif     
                     else
                        again = .false.
                     endif      
                  enddo
                  close (unit = nout)
               else
                  write (line,500)
                  call putfat (line)   
               endif   
            endif     
         elseif (numdec.eq.3) then
c
c method 3: use the matrix project archive
c         
            iprev = 0
            call getnou (nout)
            do i = 1, nfmax
               files(i) = blank
               accept(i) = .false.
            enddo  
            ntemp = 0
            call pfiles (iprev, itype, ntemp, nin, nfmax, nout,
     +                   files,
     +                   accept)
            if (ntemp.gt.0) then
                do i = 1, nfmax
                   call isitsf (ncol, nrow,
     +                          files(i))
                   if (ncol.eq.3 .and. nrow.gt.0) then
                      nfiles = nfiles + 1
                      ntotal = ntotal + nrow
                      if (nfiles.eq.ntemp) exit
                   else
                       write (line,300) nfiles + 1
                       call putfat (line)
                       exit
                   endif                                     
                enddo        
            endif      
         elseif (numdec.eq.numopt) then
c
c cancel
c         
            return
         endif
         if (nfiles.gt.0) then
c
c set up defaults
c      
            write (text,600)
            if (ntotal.gt.nwmax) plot_labels = .false.   
            accept(1) = plot_arrows
            accept(2) = plot_labels
            accept(3) = plot_lines
            accept(4) = plot_perpendiculars
            accept(5) = plot_symbols
            write (line,700) 
            i = 5
            call chkbox (i,
     +                   text, line,
     +                   accept)    
            plot_arrows = accept(1)
            plot_labels = accept(2)
            plot_lines = accept(3)
            plot_perpendiculars = accept(4)
            plot_symbols = accept(5)
            if (plot_labels .and. ntotal.gt.nwmax) then
               plot_labels = .false.
               write (line,800) nwmax
               call putfat (line)
            endif   
c
c call the plotting subroutine
c
            call space6 (nfiles,
     +                   files,
     +                   plot_arrows, 
     +                   plot_labels,
     +                   plot_lines,
     +                   plot_perpendiculars,
     +                   plot_symbols)
         endif
      enddo 
 100  format (
     + 'Three dimensional plotting of x,y,z data swarms'
     +/
     +/'You can read in a succession of files with coordinates needed'
     +/'to create the plots you require. Each such file must have just'
     +/'three columns, i.e., x, y and z, where it is understood that'
     +/'successive values are related, e.g. x=x(t), y=y(t) and z=z(t)'
     +/'as in the test files spiral.tf1 and spiral.tf2. Make/edit the'
     +/'files using programs makmat/editmt or paste from the clipboard.'
     +/
     +/'To facilitate the plotting of many sets of coordinates, you can'
     +/'reference coordinates from a library file (like spiral.tfl).'
     +/
     +/'Advanced users can select from their matrix project archive.'
     +/
     +/'Input individual files'
     +/'Read in a library file'
     +/'Use your matrix project archive'
     +/'Cancel')
  200 format ('Number of 3-column data files required for plotting')
  300 format ('Must have no. of rows > 0 and columns = 3 in file',i4)         
  400 format ('No. of files accepted so far =',i4,1x,'Try again')
  500 format ('This is not a Simfit library file')
  600 format (
     + 'Plot arrows'
     +/'Plot labels'
     +/'Plot_lines'
     +/'Plot perpendiculars'
     +/'Plot symbols')
  700 format ('Select the default plotting style')   
  800 format ('Too many labels requested ... maxmimum =',I5)
      end
c
c 
c
c demsim70: comprehensive illustration of the simfit plotting styles
c ========
c For details read simdem.txt or simdem.html 
c 
c The idea behind this program is to collect together a set of calls
c to the user-friendly front ends for the simfit plotting routines so
c that users of the simdem package can quickly see what is available.
c The sample sizes can be altered interactively for most of these calls
c to illustrate the effects encountered with very small or very large
c data sets. More details can be found from the headers in the simdem
c source code for the individual routines or in the w_graphics.dll 
c source codes available from http://www.simfit.manchester.ac.uk 
c
      subroutine demsim70  
      implicit   none
      integer    ncmax, ndend, nmax, nout, npmax, nrmax, nsmax, ntheta,
     +           nwmax
      parameter (ncmax = 20, ndend = 5, nmax = 10000, nout = 4,
     +           npmax = 50, nrmax = 500, nsmax = 100, ntheta = 250,
     +           nwmax = 2000)
      integer    l0, l1, l2, m0, m5, m8
      parameter (l0 = 0, l1 = 1, l2 = 2, m0 = 0, m5 = 5, m8 = 8)
      integer    mode
      parameter (mode = 0)
      integer    i, ifail, isend, itype, i1, i2, j, k, ntemp,
     +           numbld(30), numdec, numopt, numtxt  
      integer    ncol, nfiles, nlab, npie, nrow
      integer    jcolor(12), l(12), m(12), n(12)
      integer    ifill(npmax), ihue(npmax)
      integer    nbins, nobs(nwmax), nset, nsur, nvec
      integer    ilc(ndend - 1), iuc(ndend - 1), iord(ndend)
      integer    iarrow(nmax), ikolor(nmax), jarrow, lcolor, ngks
      parameter (lcolor = 15, ngks = 0)
      integer    ncdf, nsamp, ncdmax 
      parameter (ncdf = 10, nsamp = 20, ncdmax = 2*nsamp)
      integer    ncbins, npdf, npdmax, nsamp1
      parameter (ncbins = 5, npdf = 20, nsamp1 = 40, npdmax = 4*nsamp1)
      integer    jarrow_vf
      parameter (jarrow_vf = 16)
      integer    iarrow_vf(jarrow_vf), ikolor_vf(jarrow_vf),
     +           jcolor_vf, lcolor_vf, m_vf, ngks_vf 
      integer    black, blue, green, red, white
      parameter (black = 0, blue = 9, green = 10, red = 12, white = 15)
      double precision a, atemp, btemp
      parameter (a = 20.0d+00) 
      double precision e(nmax), xh(nmax), yh(nmax)
      double precision x1(nmax), x2(nmax),  x3(nmax),  x4(nmax),
     +                 x5(nmax), x6(nmax),  x7(nmax),  x8(nmax),
     +                 x9(nmax), x10(nmax), x11(nmax), x12(nmax) 
      double precision y1(nmax), y2(nmax),  y3(nmax),  y4(nmax),
     +                 y5(nmax), y6(nmax),  y7(nmax),  y8(nmax),
     +                 y9(nmax), y10(nmax), y11(nmax), y12(nmax)  
      double precision yh1(nmax), yh3(nmax), yl1(nmax), yl3(nmax)
      double precision xx1(nmax), xx2(nmax), yy1(nmax), yy2(nmax)
      double precision xp(nmax), xptemp(nmax), yp(nmax), yptemp(nmax)
      double precision x(nrmax,ncmax), xvec(nmax), yvec(nmax)
      double precision r(ntheta), t(ntheta)
      double precision fact(npmax)
      double precision vector(nsmax**2 + 6), xmax, xmin, ymax, ymin,
     +                 z(nsmax,nsmax)
      double precision delta, r1, r2, hsize(nmax), params(20), theta,
     +                 twopi 
      double precision cd(ndend - 1), thresh, xdend(ndend,3)
      double precision cdf(ncdf), sample(nsamp), tcdf(ncdf),
     +                 xcdf(nrmax), ycdf(nrmax), zcdf(nrmax)
      double precision pdf(npdf), sampl1(nsamp1), tpdf(npdf),
     +                 xpdf(npdmax), ypdf(npdmax)
      double precision g05cafg, g05ddfg, x01aafg
      double precision error, four, head, one, two, zero
      parameter (error = 0.25d+00, four = 4.0d+00, head = 0.01d+00,
     +           one = 1.0d+00, two = 2.0d+00, zero = 0.0d+00) 
      double precision addtox, addtoy, hsize_vf(jarrow_vf), tsize_vf,
     +                 x1_vf(jarrow_vf), x2_vf(jarrow_vf), 
     +                 x3_vf(jarrow_vf),
     +                 y1_vf(jarrow_vf), y2_vf(jarrow_vf),
     +                 y3_vf(jarrow_vf)    
      character  labels(nwmax)*4
      character  ptitle*60, xtitle*20, ytitle*20  
      character  ptitl1(2)*40, xtitl1(2)*20, ytitl1(2)*20  
      character  temp(20)*100, text(40)*100, titles(4)*40
      character  files(12)*1024, wordx(ndend)*1 
      character  label1_vf(jarrow_vf)*2, label2_vf(jarrow_vf)*2
      character  ptitle_vf*18, xtitle_vf*1, ytitle_vf*1
      parameter (ptitle_vf = 'Arrows with Labels', xtitle_vf = 'x',
     +           ytitle_vf = 'y')  
      character  blank*1
      parameter (blank = ' ')
      logical    unused(nsmax,nsmax)
      logical    axes, gsave, repeet 
      parameter (axes = .true., gsave = .true.)
      external   listbx, putfat, gettmp, deltmp, patch2,
     +           gks001, gks004, gks012, gkst04, gkst12, gkseb4, gkscb4,
     +           gkshb4, gksvf1, gksvf3, pltobj,
     +           bcplot, bwplot, ebplot, hist01, hnplot, lbplot, mtplot,
     +           pcplot, tsplot, space0, surd2s, elips1, smplot, rtplot,
     +           dgplot, cdplot, pdplot, demo3d, sbplot, images        
      external   g05cafg, g05ccfg, g05ddfg, g02cafg, x01aafg
      intrinsic  dble, sin, cos, min
      data numbld / 30*0 / 
      data ilc   / 2, 1, 1, 1 /
      data iuc   / 4, 3, 5, 2 /
      data iord  / 1, 3, 5, 2, 4 /
      data cd    / 1.0d+00, 2.0d+00, 6.5d+00, 14.13d+00 /
      data wordx / 'A', 'B', 'C', 'D', 'E' /
      data sample /
     +-0.1251D+01, -0.8949D+00, -0.8082D+00, -0.7000D+00, -0.6648D+00,
     +-0.3640D+00, -0.3588D+00, -0.3125D+00, -0.3073D+00, -0.2855D+00,
     +-0.8175D-01,  0.1030D+00,  0.1130D+00,  0.1229D+00,  0.2740D+00,
     + 0.4958D+00,  0.5124D+00,  0.8592D+00,  0.1301D+01,  0.1565D+01 /
      data tcdf /
     +-0.1251D+01, -0.9381D+00, -0.6252D+00, -0.3124D+00,  0.5063D-03,
     + 0.3134D+00,  0.6262D+00,  0.9391D+00,  0.1252D+01,  0.1565D+01 /
      data cdf /
     +0.1343D+00,  0.2528D+00,  0.3948D+00,  0.5116D+00,  0.5501D+00,
     +0.4909D+00,  0.3635D+00,  0.2233D+00,  0.1139D+00,  0.4819D-01 /
      data sampl1 /
     +-0.2117D+01, -0.1583D+01, -0.1275D+01, -0.1202D+01, -0.1018D+01,
     +-0.8655D+00, -0.8011D+00, -0.6995D+00, -0.6744D+00, -0.5887D+00,
     +-0.5654D+00, -0.4868D+00, -0.4810D+00, -0.4470D+00, -0.4403D+00,
     +-0.3938D+00, -0.3613D+00, -0.2735D+00, -0.2422D+00, -0.2067D+00,
     +-0.1680D+00, -0.1423D+00, -0.1130D+00, -0.1040D+00, -0.7391D-01,
     +-0.6547D-02,  0.1313D+00,  0.1880D+00,  0.2213D+00,  0.2657D+00,
     + 0.2844D+00,  0.5517D+00,  0.5544D+00,  0.5581D+00,  0.6531D+00,
     + 0.7271D+00,  0.7323D+00,  0.1018D+01,  0.1561D+01,  0.1761D+01 /
      data tpdf /
     +-0.2117D+01, -0.1913D+01, -0.1709D+01, -0.1505D+01, -0.1301D+01,
     +-0.1097D+01, -0.8924D+00, -0.6883D+00, -0.4841D+00, -0.2800D+00,
     +-0.7582D-01,  0.1283D+00,  0.3325D+00,  0.5366D+00,  0.7407D+00,
     + 0.9449D+00,  0.1149D+01,  0.1353D+01,  0.1557D+01,  0.1761D+01 /
      data pdf /
     +0.2165D-01,  0.4036D-01,  0.7028D-01,  0.1143D+00,  0.1736D+00,
     +0.2463D+00,  0.3263D+00,  0.4038D+00,  0.4668D+00,  0.5040D+00,
     +0.5082D+00,  0.4786D+00,  0.4210D+00,  0.3459D+00,  0.2654D+00,
     +0.1902D+00,  0.1273D+00,  0.7961D-01,  0.4649D-01,  0.2536D-01 /
c
c initialise random number generator and starting parameters
c                 
      call g05ccfg       
      twopi = two*x01aafg(delta)
      nbins = 5                   
      ncol = 4  
      nfiles = 3
      nlab = 20
      npie = 8
      nrow = 5  
      nset = 5
      nsur = 20
      ntemp = 20   
      nvec = 20  
c
c initialise values for gks routines that remain unaltered
c      
      do i = 1, 12
         jcolor(i) = i
         l(i) = 0
         m(i) = i 
         n(i) = ntemp
      enddo                      
      do i = 1, nmax 
         x1(i) = dble(i)    
         x2(i) = x1(i)
         x3(i) = x1(i)
         x4(i) = x1(i) 
         x5(i) = x1(i)
         x6(i) = x1(i)
         x7(i) = x1(i)
         x8(i) = x1(i)
         x9(i) = x1(i)
         x10(i) = x1(i)
         x11(i) = x1(i)
         x12(i) = x1(i)
      enddo
c
c initialise yj(i) values that depend on the current value of ntemp 
c note parameter a > yj(i)and yj(i) > 0 for possible transforms
c      
      delta = twopi/dble(ntemp)
      do i = 1, ntemp
         y1(i) = two + sin(x1(i)*delta)
         y2(i) = y1(i) + one
         y3(i) = y2(i) + one
         y4(i) = y3(i) + one  
         y5(i) = y4(i) + one
         y6(i) = y5(i) + one
         y7(i) = y6(i) + one
         y8(i) = y7(i) + one
         y9(i) = y8(i) + one
         y10(i) = y9(i) + one
         y11(i) = y10(i) + one
         y12(i) = y11(i) + one
         yh1(i) = y1(i) + error
         yh3(i) = y3(i) + error
         yl1(i) = y1(i) - error
         yl3(i) = y3(i) - error
         xp(i) = cos(two*x1(i)*delta)
         yp(i) = sin(two*x1(i)*delta)
      enddo   
c
c initialise vector field data
c             
      j = 0   
      k = 0
      delta = twopi/50.0d+00  
      r2 = error
      r1 = r2 + error
      do i = 1, nmax   
         e(i) = error
         j = j + 1
         if (j.eq.51) then    
            j = 1
            r1 = r1 + two*error
            r2 = r2 + two*error
            if (k.eq.14) then 
               k = 0
            else
               k = k + 1
            endif      
         endif   
         ikolor(i) = k              
         theta = dble(i)*delta
         xx1(i) = r1*cos(theta)
         yy1(i) = r1*sin(theta)
         xx2(i) = r2*cos(theta)
         yy2(i) = r2*sin(theta)    
      enddo
      do i = 1, nmax
        iarrow(i) = 1
        hsize(i) = head
      enddo  
c
c initialise random matrix x(i,j) with >= 0 for possible bar chart
c                        
      atemp = zero
      btemp = one
      do j = 1, ncmax
         do i = 1, nrmax 
            x(i,j) = two + g05cafg(theta) + g05ddfg(atemp, btemp)
            if (x(i,j).lt.zero) x(i,j) = zero
         enddo
      enddo   
c
c initialise labels
c      
      do i = 1, nwmax
         write (labels(i),'(i4)') i
      enddo                 
      
c
c end of initialisation and start of main loop
c ============================================
c      
      repeet = .true.  
      do while (repeet)   
         write (temp,100)   
         do i = 1, 19
            text(i) = temp(i)
         enddo
         write (temp,101)
         numopt = 32
         do i = 20, numopt   
            text(i) = temp(i - 19)
         enddo    
         write (ptitle,200) ntemp 
         xtitle = 'x-axis'
         ytitle = 'y-axis'   
         numdec = 1
         call listbx (numdec, numopt,
     +                text)
         if (numdec.gt.1 .and. numdec.lt.numopt - 1) then
c
c make sure counters are initialised properly
c           
            twopi = two*x01aafg(delta)
            nbins = 5                   
            ncol = 4  
            nfiles = 3
            nlab = 20
            npie = 8
            nrow = 5  
            nset = 5
            nsur = 20
            ntemp = 20   
            nvec = 20  
c
c clear away any graphical objects
c          
            i = 1
            j = 1
            call pltobj (i, j)
c
c re-set y1 through to y12
c          
            i1 = 5
            i2 = ntemp
            if (i2.ne.ntemp) then
               ntemp = i2   
               do i = 1, 12
                  n(i) = ntemp
               enddo
               delta = twopi/dble(ntemp)   
               do i = 1, ntemp
                  y1(i) = two + sin(x1(i)*delta)
                  y2(i) = y1(i) + one
                  y3(i) = y2(i) + one
                  y4(i) = y3(i) + one  
                  y5(i) = y4(i) + one
                  y6(i) = y5(i) + one
                  y7(i) = y6(i) + one
                  y8(i) = y7(i) + one
                  y9(i) = y8(i) + one
                  y10(i) = y9(i) + one
                  y11(i) = y10(i) + one
                  y12(i) = y11(i) + one
                  yh1(i) = y1(i) + error
                  yh3(i) = y3(i) + error
                  yl1(i) = y1(i) - error
                  yl3(i) = y3(i) - error
                  xp(i) = cos(two*x1(i)*delta)
                  yp(i) = sin(two*x1(i)*delta)
               enddo
            endif   
         endif
           
         if (numdec.eq.1) then
c
c numdec = 1: images
c 
            call images (mode)
         elseif (numdec.eq.2) then 
c
c numdec = 2: single plot
c         
            call gks001 (l(1), m(1), n(1),
     +                   x1,
     +                   y1,
     +                   ptitle, xtitle, ytitle)             
         elseif (numdec.eq.3) then  
c
c numdec = 3: up to 4 plots
c         
            call gks004 (l(1), l(2), l(3), l(4), 
     +                   m(1), m(2), m(3), m(4), 
     +                   n(1), n(2), n(3), n(4),
     +                   x1, x2, x3, x4,
     +                   y1, y2, y3, y4,
     +                   ptitle, xtitle, ytitle,
     +                   axes, gsave)
         elseif (numdec.eq.4) then  
c
c numdec = 4: up to 12 plots
c         
            call gks012 (l(1), l(2), l(3), l(4),  l(5),  l(6),
     +                   l(7), l(8), l(9), l(10), l(11), l(12),       
     +                   m(1), m(2), m(3), m(4),  m(5),  m(6),
     +                   m(7), m(8), m(9), m(10), m(11), m(12),   
     +                   n(1), n(2), n(3), n(4),  n(5),  n(6), 
     +                   n(7), n(8), n(9), n(10), n(11), n(12),   
     +                   x1, x2, x3, x4,  x5,  x6,
     +                   x7, x8, x9, x10, x11, x12,
     +                   y1, y2, y3, y4,  y5,  y6,
     +                   y7, y8, y9, y10, y11, y12,
     +                   ptitle, xtitle, ytitle,
     +                   axes, gsave)
c
c numdec= 5: up to 4 transforms
c     
         elseif (numdec.eq.5) then  
            call gkst04 (l(1), l(2), l(3), l(4), 
     +                   m(1), m(2), m(3), m(4), 
     +                   n(1), n(2), n(3), n(4),
     +                   a,
     +                   x1, x2, x3, x4,
     +                   y1, y2, y3, y4,
     +                   ptitle, xtitle, ytitle,
     +                   axes, gsave)
         elseif (numdec.eq.6) then  
c
c numdec = 6: up to 12 transforms
c         
            call gkst12 (l(1), l(2), l(3), l(4),  l(5),  l(6),
     +                   l(7), l(8), l(9), l(10), l(11), l(12),       
     +                   m(1), m(2), m(3), m(4),  m(5),  m(6),
     +                   m(7), m(8), m(9), m(10), m(11), m(12),   
     +                   n(1), n(2), n(3), n(4),  n(5),  n(6), 
     +                   n(7), n(8), n(9), n(10), n(11), n(12),   
     +                   a,
     +                   x1, x2, x3, x4,  x5,  x6,
     +                   x7, x8, x9, x10, x11, x12,
     +                   y1, y2, y3, y4,  y5,  y6,
     +                   y7, y8, y9, y10, y11, y12,
     +                   ptitle, xtitle, ytitle,
     +                   axes, gsave)  
         elseif (numdec.eq.7) then 
c
c numdec = 7: up to 2 standard error bars and best fit curves
c          
            call gkseb4 (l0, l1, l0, l2, 
     +                   m5, m0, m8, m0, 
     +                   n(1), n(2), n(3), n(4),
     +                   x1, x2, x3, x4,
     +                   yh1, yh3, yl1, yl3, y1, y2, y3, y4,
     +                   ptitle, xtitle, ytitle,
     +                   axes, gsave)  
         elseif (numdec.eq.8) then  
c
c numdec = 8: as gkseb4 but restricted for such as bar chart use 
c         
            call gkscb4 (l0, l1, l0, l2, 
     +                   m5, m0, m8, m0, 
     +                   n(1), n(2), n(3), n(4),
     +                   x1, x2, x3, x4,
     +                   yh1, yh3, yl1, yl3, y1, y2, y3, y4,
     +                   ptitle, xtitle, ytitle,
     +                   axes, gsave) 
         elseif (numdec.eq.9) then                
c
c numdec = 9: swapped error bars for horizontal use such as log-odds
c         
            itype = 1! must be 1 for log-e or 2 for log-10
            ptitl1(1) = 'Interchanged axes'!title for simple graph 
            ptitl1(2) = ptitle             !true plot title (for simplot)
            xtitl1(1) = 'x'                !y legend for simple graph
            xtitl1(2) = ytitle             !true x-title (for simplot)
            if (itype.eq.1) then
               ytitl1(1) = 'log_e(y)'      !x legend for simple graph 
            else   
               ytitl1(1) = 'log_10(y)'     !x legend for simple graph
            endif
            ytitl1(2) = xtitle             !true y-title (for simplot)
            call gkshb4 (itype,
     +                   l0, l1, l0, l2, 
     +                   m5, m0, m8, m0, 
     +                   n(1), n(2), n(3), n(4),
     +                   x1, x2, x3, x4,
     +                   yh1, yh3, yl1, yl3, y1, y2, y3, y4,
     +                   ptitl1, xtitl1, ytitl1,
     +                   axes, gsave)     
         elseif (numdec.eq.10) then 
c
c numdec = 10: vector field
c         
            jarrow = ntemp
            call gksvf1 (iarrow, ikolor, jarrow, lcolor, ngks,
     +                   hsize, xx1, xx2, yy1, yy2, 
     +                   ptitle, xtitle, ytitle, 
     +                   axes, gsave)
         elseif (numdec.eq.11) then
c
c numdec = 11: vector field with labels, e.g. for matrix bi-plot
c                                                    
            lcolor_vf = white 
            jcolor_vf = black   
            m_vf = 0
            ngks_vf = 0            
            tsize_vf = one 
            addtox = 0.05d+00
            addtoy = 0.05d+00
            delta = twopi/dble(jarrow_vf)
            theta = - delta
            do i = 1, jarrow_vf  
               write (label1_vf(i),'(i2)') i
               label2_vf(i) = '00'
               theta = theta + delta  
               if (i.le.5) then
                  iarrow_vf(i) = 1
                  ikolor_vf(i) = black
               elseif (i.le.9) then
                  iarrow_vf(i) = 16
                  ikolor_vf(i) = blue
               elseif (i.le.13) then
                  iarrow_vf(i) = 2
                  ikolor_vf(i) = green
               else
                  iarrow_vf(i) = 3
                  ikolor_vf(i) = red
               endif             
               hsize_vf(i) = 0.01d+00
               x2_vf(i) = zero
               y2_vf(i) = zero
               x1_vf(i) = cos(theta)
               y1_vf(i) = sin(theta)  
               x3_vf(i) = x1_vf(i) 
               y3_vf(i) = y1_vf(i)
               if (x3_vf(i).gt.addtox) then
                  x3_vf(i) = x3_vf(i) + addtox
               elseif (x3_vf(i).lt.-addtox) then
                  x3_vf(i) = x3_vf(i) - two*addtox 
               endif     
               if (y3_vf(i).gt.addtoy) then
                  y3_vf(i) = y3_vf(i) + addtoy
               elseif (y3_vf(i).lt.-addtoy) then
                  y3_vf(i) = y3_vf(i) - two*addtoy   
               endif    
            enddo
            call gksvf3 (iarrow_vf, ikolor_vf, jarrow_vf, jcolor_vf,
     +                   lcolor_vf, m_vf, ngks_vf,
     +                   hsize_vf, tsize_vf,
     +                   x1_vf, x2_vf, x3_vf, 
     +                   y1_vf, y2_vf, y3_vf,
     +                   label1_vf, label2_vf,
     +                   ptitle_vf, xtitle_vf, ytitle_vf,
     +                   axes, gsave)
         elseif (numdec.eq.12) then 
c
c numdec = 12: bar chart plot
c         
            isend = 2
            titles(1) = 'Bar Chart'
            titles(2) = 'Columns' 
            titles(3) = 'Rows'
            titles(4) = blank
            call bcplot (isend, ncol, nrmax, nrow,
     +                   x,
     +                   labels, titles) 
         elseif (numdec.eq.13) then 
c
c numdec = 13: stack plot
c         
            isend = 2
            titles(1) = 'Stack Plot'
            titles(2) = 'Columns' 
            titles(3) = 'Rows'
            titles(4) = blank
            call sbplot (isend, ncol, nrmax, nrow,
     +                   x,
     +                   labels, titles)           
         elseif (numdec.eq.14 .or. numdec.eq.17) then
c
c numdec = 14: boxes and whiskers
c numdec = 17: bar chart with error bars
c         
            i2 = nwmax/4
            if (nset.gt.i2) nset = i2
            j = nwmax/nset   
            nvec = 0 
            atemp = zero
            btemp = one
            do i = 1, nset
               nobs(i) = j
               do k = 1, j
                  nvec = nvec + 1
                  xvec(nvec) = two + g05ddfg(atemp, btemp)
                  if (xvec(nvec).lt.zero) xvec(nvec) = zero
               enddo   
            enddo 
            isend = 2
            titles(2) = 'Groups' 
            titles(3) = 'Values'
            titles(4) = ' '                    
            if (numdec.eq.14) then
               titles(1) = 'Boxes and Whiskers'
               call bwplot (isend, nobs, nset, nvec,
     +                      xvec,
     +                      labels, titles)             
            else 
               titles(1) = 'Error Bar Plot'
               call ebplot (isend, nobs, nset, nvec,
     +                      xvec,
     +                      labels, titles) 
            endif            
         elseif (numdec.eq.15) then     
c
c numdec = 15: cdf plot
c
            titles(1) = 'Sample and best-fit cdf'
            titles(2) = 'Values'
            titles(3) = 'CDF and step function'
            call cdplot (ncdf, ncdmax, nsamp,
     +                   cdf, sample, tcdf, xcdf, ycdf, zcdf,
     +                   titles(1), titles(2), titles(3))
         elseif (numdec.eq.16) then    
c
c numdec = 16: dendrogram
c
             thresh = 5.0d+00
             titles(1) = 'Dendrogram'
             titles(2) = 'Item'
             titles(3) = 'Metric'
             call dgplot (ilc, iuc, iord, ndend, ndend,
     +                    cd, thresh, xdend,
     +                    titles(1), wordx, titles(2), titles(3))  
         elseif (numdec.eq.18) then    
c
c numdec = 18: bivariate confidence ellipses
c
            atemp = zero
            btemp = two
            do i = 1, ntemp
               xvec(i) = g05ddfg(atemp, btemp)
               yvec(i) = g05ddfg(atemp, btemp)
            enddo
            ifail = 0
            call g02cafg(ntemp, xvec, yvec, params, ifail)
            if (ifail.eq.0) then
               call elips1 (ntemp, params, xvec, yvec)     
            else
               call putfat ('failure in call to g02caf')
            endif      
         elseif (numdec.eq.19) then
c
c numdec = 19: histograms
c            
            i2 = min(ntemp,200)
            if (nbins.gt.i2) nbins = i2
            call hist01 (nbins, nmax, j, 
     +                   e, x1, xh, y1, yh,
     +                   gsave)
         elseif (numdec.eq.20) then
c
c numdec = 20: normal or half normal plots
c                                
            atemp = zero
            btemp = two
            do i = 1, ntemp
               yvec(i) = g05ddfg(atemp, btemp)
            enddo   
            isend = 1
            call hnplot (isend, ntemp,
     +                   yvec)       
            isend = 2
            call hnplot (isend, ntemp,
     +                   yvec)       
         elseif (numdec.eq.21) then 
c
c numdec = 21: labels plot
c         
            i2 = nwmax
            if (nlab.gt.i2) nlab = i2
            atemp = zero
            btemp = one
            do i = 1, nlab
               xvec(i) = g05ddfg(atemp, btemp)
               yvec(i) = g05ddfg(atemp, btemp)
            enddo  
            write (ptitle,200) nlab
            call lbplot (nlab,
     +                   xvec, yvec,
     +                   ptitle, labels, xtitle, ytitle)        
         elseif (numdec.eq.22) then  
c
c numdec = 22: matrix plots
c         
            isend = 4
            call mtplot (isend, ncmax, ncol, nrmax, nrow, 
     +                   x)       
         elseif (numdec.eq.23) then
c
c numdec = 23: pie chart
c         
            i2 = npmax
            if (npie.gt.i2) npie = i2
            isend = 1
            call pcplot (isend, ifill, ihue, npie,
     +                   fact, x1,
     +                   labels, 'Pie Chart')
         elseif (numdec.eq.24) then
c
c numdec = 24: pdf
c         
            titles(1) = 'Histogram and best-fit pdf'
            titles(2) = 'Values'
            titles(3) = 'Bins and pdf'
            call pdplot (ncbins, npdf, npdmax, nsamp1,
     +                   pdf, sampl1, tpdf, xpdf, ypdf,
     +                   titles(1), titles(2), titles(3))
         elseif (numdec.eq.25) then
c
c numdec = 25: r(theta) 
c         
            delta = twopi/dble(ntheta - 1)
            t(1) = zero
            do i = 2, ntheta - 1
               t(i) = t(i - 1) + delta
            enddo
            t(ntheta) = twopi
            do i = 1, ntheta
               r(i) = sin(four*t(i))
            enddo
            call rtplot (ntheta,
     +                   r, t)
         elseif (numdec.eq.26) then
c
c numdec = 26: arbitrary number of plots
c
            i2 = 12
            if (nfiles.gt.i2) nfiles = i2
            do i = 1, nfiles
               call gettmp (j, files(i))
               open (unit = nout, file = files(i))
               write (nout,'(a)') blank
               write (nout,'(2i4)') ntemp, 2
               do j = 1, ntemp
                  atemp = x1(j)
                  if (i.eq.1) then
                     btemp = y1(j)
                  elseif (i.eq.2) then
                     btemp = y2(j) 
                  elseif (i.eq.3) then
                     btemp = y3(j)
                  elseif (i.eq.4) then
                     btemp = y4(j)
                  elseif (i.eq.5) then
                     btemp = y5(j)
                  elseif (i.eq.6) then
                     btemp = y6(j)    
                  elseif (i.eq.7) then
                     btemp = y7(j) 
                  elseif (i.eq.8) then
                     btemp = y8(j)
                  elseif (i.eq.9) then
                     btemp = y9(j)
                  elseif (i.eq.10) then
                     btemp = y10(i)
                  elseif (i.eq.11) then
                     btemp = y11(j)
                  elseif (i.eq.12) then
                     btemp = y12(j)
                  endif   
                  write (nout,'(1p,2e11.3)') atemp, btemp
               enddo
               close(unit = nout)
            enddo
            write(titles(1),200) ntemp
            titles(2) = 'x'
            titles(3) = 'y'
            titles(4) = blank
            call smplot (jcolor, l, m, nfiles, files, titles)
            call deltmp         
         elseif (numdec.eq.27) then     
c
c numdec = 27: time series 
c         
            do i = 1, ntemp
               yvec(i) = y1(i) - two
            enddo   
            i1 = 1
            i2 = 0
            isend = 2
            call tsplot (isend, i1, i2, ntemp,
     +                   one, xvec, xvec, one, yvec,                 
     +                   ptitle, xtitle, ytitle)
            isend = 4
            call tsplot (isend, i1, i2, ntemp,
     +                   one, xvec, xvec, one, yvec,                 
     +                   ptitle, xtitle, ytitle)
         elseif (numdec.eq.28) then
c
c numdec = 28: spiral
c
            call space0 (ntemp, nmax,
     +                   xp, xptemp, yp, yptemp, x1)             
         elseif (numdec.eq.29) then
c
c numdec = 29: 3D surface/bar chart/contours
c         
            i2 = nsmax
            if (nsur.gt.i2) nsur = i2
            xmin = - one
            xmax = one
            ymin = - one
            ymax = one
            delta = (xmax - xmin)/(dble(nsur - 1))
            atemp = xmin - delta 
            do j = 1, nsur
               atemp = atemp + delta
               btemp = ymin - delta
               do i = 1, nsur
                  btemp = btemp + delta
                  z(i,j) = btemp**2 - atemp**2
               enddo
            enddo
            isend = 4
            call surd2s (isend, nsmax, nsur, nsur, 
     +                   vector, xmax, xmin, ymax, ymin, z,
     +                   unused)
         elseif (numdec.eq.30) then
c
c numdec = 30: 3D curves/swarms/vectors
c
            call demo3d         
         elseif (numdec.eq.numopt - 1) then
c         
c numdec = numopt - 1: help
c 
            write (text,300)         
            numtxt = 21
            numbld(1) = 1
            numbld(8) = 1
            numbld(11) = 1
            numbld(14) = 1
            numbld(18) = 1
            call patch2 (numbld, numtxt,
     +                   text)             
         
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: exit loop
c         
            repeet = .false.
         endif   
      enddo
  100 format (
     + 'Show typical plotting styles'
     +/'number of plots = 1'
     +/'number of plots =< 4'
     +/'number of plots =< 12'
     +/'number of transforms =< 4'
     +/'number of transforms =< 12'
     +/'error bars...standard'
     +/'error bars...restricted'
     +/'error bars...rotated'   
     +/'vector field'
     +/'vector field with labels'
     +/'bar chart'  
     +/'stack plot'       
     +/'box and whisker plot'
     +/'cumulative and cdf'
     +/'dendrogram'    
     +/'bar chart and error bars'   
     +/'confidence ellipses'  
     +/'histograms')  
  101 format ( 
     + 'normal/half-normal plot'   
     +/'plot with labels'      
     +/'columns/rows from matrix'     
     +/'pie chart' 
     +/'histogram and pdf'
     +/'parametric r = r(theta)'  
     +/'multiple advanced plots'        
     +/'time series'
     +/'parametric space curve'
     +/'surface/contour/barchart'
     +/'3D curves/swarms/vectors'
     +/'Help'
     +/'Quit ... Exit demonstration')             
  200 format ('Plot with n =',i4) 
  300 format ('Demonstrating the Simfit graphics routines'
     +/
     +/'This program provides a convenient way to explore the standard'
     +/'Simfit plot types. It is a simple version of program simdem70' 
     +/'from the Simdem package. To use these routines from program'
     +/'Simplot you just have to supply correctly formatted data.'
     +/
     +/'1) Standard graphs' 
     +/'These require two columns, x in column 1, and y in column 2.'
     +/
     +/'2) Pie charts'
     +/'These require a vector of positive values.'
     +/
     +/'3) Bar charts' 
     +/'These require a matrix, where each each row will be interpreted'
     +/'as a set of groups, and each column will be a group.'
     +/
     +/'4) Test files'
     +/'Test files are provided via the [Demo] button on the file open'
     +/'control, while the [View] control from the main Simfit menu'
     +/'allows you to browse the test files for formatting details') 
      end
c
c 
c
c
      subroutine demo3d
c
c Demonstrate how to call space6$ for 3D space curves, swarms, and vectors
c
      implicit   none
      integer    i, ifail, j, n, nfiles, nout, numdec
      integer    nmax, numopt, ncols
      parameter (nmax = 50, numopt = 7, ncols = 3)
      double precision zero, one, two, three, pi, stretch1, stretch2
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00, 
     +           three = 3.0d+00, pi = 3.1415927d+00,
     +           stretch1 = 0.666d+00, stretch2 = 1.50d+00)
      double precision delta
      double precision t(nmax), x(nmax), y(nmax), z(nmax)
      character  fnames(4)*1024
      character  text(numopt)*80
      character  file1*1024, file2*1024, file3*1024, file4*1024,
     +           file5*1024
      character  begin_labels*13, end_labels*11, title*25
      parameter (begin_labels = 'begin{labels}',
     +             end_labels = 'end{labels}',
     +                  title = 'Temporary File for demo3D')       
      logical    repeet
      logical    askif, there
      parameter (askif = .false.)
      logical    plot_arrows, plot_labels, plot_lines, 
     +           plot_perpendiculars, plot_symbols
      external   listbx, space6, gettmp, deleet, getnou, pltobj
      intrinsic  cos, sin, dble
c
c find an unopened unit
c      
      call getnou (nout)
c
c inititialise logical varaiables
c           
      
      plot_arrows = .false.
      plot_labels = .false.
      plot_lines = .false.
      plot_perpendiculars = .false.
      plot_symbols = .false.
c
c Define t
c
      n = nmax
      t(1) = zero
      t(n) = two*pi
      delta = (t(n) - t(1))/(dble(n) - one)
      do i = 2, n - 1
         t(i) = t(i - 1) + delta
      enddo
c
c Define x, y, z as a helix
c
      x(1) = one
      y(1) = zero
      z(1) = one
      do i = 2, n - 1
         delta = two*t(i)
         x(i) = cos(delta)
         y(i) = sin(delta)
         z(i) = dble(i)
      enddo
      x(n) = x(1)
      y(n) = y(1)
      z(n) = dble(n)
c
c file1 just contains x, y, z data 
c
      call gettmp (ifail,
     +             file1)
      open (unit = nout, file = file1)
      write (nout,'(a)') title
      write (nout,'(2i6)') n, ncols
      do i = 1, n
        write (nout,'(3e12.4)') x(i), y(i), z(i)
      enddo
      close (unit = nout)   
c
c file2 contains an interior helix
c
      call gettmp (ifail,
     +             file2)
      open (unit = nout, file = file2)
      write (nout,'(a)') title
      write (nout,'(2i6)') n, ncols
      do i = 1, n
        write (nout,'(3e12.4)') x(i)/two, y(i)/two, stretch1*z(i)
      enddo
      close (unit = nout)  
c
c file3 contains another interior helix
c
      call gettmp (ifail,
     +             file3)
      open (unit = nout, file = file3)
      write (nout,'(a)') title
      write (nout,'(2i6)') n, ncols
      do i = 1, n
        write (nout,'(3e12.4)') x(i)/three, y(i)/three, stretch2*z(i)
      enddo
      close (unit = nout)  
c
c file4 contains a subset of file1 but with labels added
c
      call gettmp (ifail,
     +             file4)
      open (unit = nout, file = file4)
      write (nout,'(a)') title
      write (nout,'(2i6)') n/2, ncols
      do i = 1, n/2
        write (nout,'(3e12.4)') x(i), y(i), z(i)
      enddo
      write (nout,'(a)') begin_labels
      do i = 1, n/2
         if (i.lt.10) then
            write (nout,'(a1,i1)') 'A', i
         elseif (i.lt.100) then
            write (nout,'(a1,i2)') 'A', i
         else
            write (nout,'(a1,i3)') 'A', i
         endif        
      enddo  
      write (nout,'(a)') end_labels
      close (unit = nout)   
c
c file5 contains a subset of file2 but with labels added
c
      call gettmp (ifail,
     +             file5)
      open (unit = nout, file = file5)
      write (nout,'(a)') title
      write (nout,'(2i6)') n/2 - 15, ncols
      j = -1
      do i = 1, n/2 - 15
        j = j + 2
        write (nout,'(3e12.4)') x(j)/two, y(j)/two, stretch1*z(j)
      enddo
      write (nout,'(a)') begin_labels
      j = -1
      do i = 1, n/2 - 15
         j = j + 2
         if (j.lt.10) then
            write (nout,'(a1,i1)') 'B', j
         elseif (j.lt.100) then
            write (nout,'(a1,i2)') 'B', j
         else
            write (nout,'(a1,i3)') 'B', j
         endif        
      enddo  
      write (nout,'(a)') end_labels
      close (unit = nout)   
c
c The main loop
c
      write (text,100)
      repeet = .true.
      do while (repeet)
          numdec = numopt
          call listbx (numdec, numopt,
     +                 text) 
          if (numdec.lt.numopt) then
c
c clear away any objects
c            
             i = 1
             j = 1
             call pltobj (i, j)
          endif  
          if (numdec.eq.1) then
c
c curves
c            
             nfiles = 3
             fnames(1) = file1
             fnames(2) = file2
             fnames(3) = file3
             plot_lines = .true.
             call space6 (nfiles,
     +                    fnames,
     +                    plot_arrows,
     +                    plot_labels,
     +                    plot_lines,
     +                    plot_perpendiculars,
     +                    plot_symbols)
             plot_lines = .false. 
          elseif (numdec.eq.2) then 
c
c swarms
c          
             nfiles = 3
             fnames(1) = file1
             fnames(2) = file2
             fnames(3) = file3
             plot_symbols = .true.
             call space6 (nfiles,
     +                    fnames,
     +                    plot_arrows,
     +                    plot_labels,
     +                    plot_lines,
     +                    plot_perpendiculars,
     +                    plot_symbols)
             plot_symbols = .false. 
          elseif (numdec.eq.3) then
c
c swarms with perpendiculars
c          
             nfiles = 2
             fnames(1) = file4
             fnames(2) = file5
             plot_symbols = .true.
             plot_perpendiculars = .true.
             call space6 (nfiles,
     +                    fnames,
     +                    plot_arrows,
     +                    plot_labels,
     +                    plot_lines,
     +                    plot_perpendiculars,
     +                    plot_symbols)
             plot_symbols = .false.
             plot_perpendiculars = .false. 
          elseif (numdec.eq.4) then
c
c swarms with labels
c          
             nfiles = 2
             fnames(1) = file4
             fnames(2) = file5
             plot_symbols = .true.
             plot_labels = .true.
             call space6 (nfiles,
     +                    fnames,
     +                    plot_arrows,
     +                    plot_labels,
     +                    plot_lines,
     +                    plot_perpendiculars,
     +                    plot_symbols)
             plot_symbols = .false.
             plot_labels = .false. 
          elseif (numdec.eq.5) then
c
c arrows
c          
             nfiles = 2
             fnames(1) = file4
             fnames(2) = file5
             plot_arrows = .true.
             call space6 (nfiles,
     +                    fnames,
     +                    plot_arrows,
     +                    plot_labels,
     +                    plot_lines,
     +                    plot_perpendiculars,
     +                    plot_symbols)
             plot_arrows = .false.
          elseif (numdec.eq.6) then
c
c arrows with labels
c          
             nfiles = 2
             fnames(1) = file4
             fnames(2) = file5
             plot_arrows = .true.
             plot_labels = .true.
             call space6 (nfiles,
     +                    fnames,
     +                    plot_arrows,
     +                    plot_labels,
     +                    plot_lines,
     +                    plot_perpendiculars,
     +                    plot_symbols)
             plot_arrows = .false.
             plot_labels = .false. 
          elseif (numdec.eq.numopt) then
             repeet = .false. 
          endif
            
      enddo  
c
c delete temporary files
c      
      call deleet (file1,
     +             askif, there)
      call deleet (file2,
     +             askif, there)
      call deleet (file3,
     +             askif, there)
      call deleet (file4,
     +             askif, there)
      call deleet (file5,
     +             askif, there)     
c
c format statement
c      
  100 format (
     + 'Demonstrate 3D curves'
     +/'Demonstrate 3D swarms'
     +/'Demonstrate 3D swarms with perpendiculars'
     +/'Demonstrate 3D swarms with labels'
     +/'Demonstrate 3D vectors'
     +/'Demonstrate 3D vectors with labels'
     +/'Cancel')       
      end
c
c     

