c
c----------------------------------------------------------------------------------------
c     
      subroutine simplot_test_files (isend,
     +                               main_menu)
c
c action: provide test files for SIMPLOT  
c author: w.g.bardsley, university of manchester, u.k., 27/07/2020
c         07/09/2020 It can be used to pass the chosen test file to any graphics routine 
c                    by calling simplot_tf to store the file name
c                    This version uses simplot_tf just for isend = 15 (metafiles)
c         07/10/2020 Now returns main_menu = .not.switch_off(k) and switching off must be selected
c
c  1: simple and statistical plots
c  2: standard x,y axes
c  3: double x, y axes
c  4: bar chart
c  5: pie chart
c  6: vector field
c  7: 3d surface
c  8: 3d swarms
c  9: parametric equations
c 15: metafiles (uses simplot_tf to transfer information to mfplot)
c       
      implicit none
c
c arguments
c      
      integer,             intent (in)  :: isend
      logical,             intent (out) :: main_menu   
c
c locals
c      
      integer    i, ios, k, l, m, numdec
      integer    jsend, num_items, numopt, numsta, numtxt, num_xtra
      parameter (jsend = 1, num_items = 9, numopt = 5, numsta = 13,
     +           numtxt = numsta + numopt - 1, num_xtra = 7)
      integer    numbld(numtxt)
      integer    numbld_1(30), numtxt_1
      character (len = 1024) dem, fname
      character (len = 100 ) extras(num_xtra), line, option(num_items),
     +                       text(numtxt), text_1(30), trim100, word100
      character (len = 40  ) info
      character (len = 20  ) stub
      character (len = 6   ) cipher
      character (len = 1   ) blank, bslash
      parameter (blank = ' ', bslash = '\')
      logical    active(num_items), repeet, switch_off(15), there
      logical    store
      parameter (store = .true.)
      external   demdir, putadv, trim100, lstbox, viewer, patch2 
      external   simplot_tf
      external   simplot3_2, simplot3_3, simplot3_4, simplot3_5, 
     +           simplot3_6, simplot3_7, simplot3_8, simplot3_9,
     +           simplot3_15
      intrinsic  len_trim
      data       active / num_items*.false. /
      data       switch_off /15*.false. /
      data       numbld_1 /  30*0  /
c
c intialise k, main_menu, fname and initialise simplot_tf then check if switched off 
c   
      if (isend.eq.15) then
         k = 9        !***k must not be changed again in this subroutine
      else   
         k = isend - 1!***k must not be changed again in this subroutine  
      endif   
      fname = blank
      call simplot_tf (fname,
     +                 store) 
      if (switch_off(k)) then
         main_menu = .false.
         return
      endif   
      main_menu = .true.   
c
c intialise  
c    
      option(1) = 'for standard X,Y axes'
      option(2) = 'for one X-axis but two Y-axes'
      option(3) = 'for bar charts'
      option(4) = 'for pie charts'
      option(5) = 'for for vector fields'
      option(6) = 'for 3d surface and/or contours'
      option(7) = 'for curves in space or data swarms'
      option(8) = 'for parametric equations'
      option(9) = 'to demonstrate a metafile'
      do i = 1, num_xtra
         extras(i) = blank
      enddo    
      fname = blank
      stub = blank
      call demdir (l,
     +             dem)
      if (dem(l:l).ne.bslash) then
         l = l + 1
         dem(l:l) = bslash
      endif  
      if (isend.eq.2) then
         stub = 'simfig1.TFL'
         extras(2) = 
     +'This library file lists multiple files so they can be plotted'
         extras(3) =
     +'in sequence without having to specify individual files.' 
         extras(5) =
     +'Library files can be made with program MAKLIB but multiple files'
         extras(6) = 
     +'can be input from the Open dialogue or your project archive.'                
      elseif (isend.eq.3) then
         stub = 'plot2.tf1'
         extras(2) = 
     +'Double plots use files with the same range of X-values but two'
         extras(3) =
     +'ranges of Y-values, e.g., plot2.tf1 using the left Y-axis with' 
         extras(4) =
     +'plot2.tf2 and plot2.tf3 plotted using the right Y-axis.'  
         extras(6) =
     +'Choosing to plot data will also show plot2.tf2, and plot2.tf3.'                           
      elseif (isend.eq.4) then
         stub = 'matrix.tf2'
         extras(2) = 
     +'Bar charts can be made from n by m matrices of positive values'
         extras(3) = 
     +'where rows represent groups and columns cases in each group.'   
         extras(4) = 
     +'Matrices are transformed into advanced bar chart files but these'
         extras(5) = 
     +'can be made directly for more features. To appreciate this use' 
         extras(6) = 
     +'[Demo] then [View] then [Open] on an advanced bar chart file.'       
      elseif (isend.eq.5) then
         stub = 'vector.tf1'
         extras(2) = 
     +'Pie charts can be made from n by 1 vectors of positive values'
         extras(3) = 
     +'where the values are numbers or proportions in each segment.'   
         extras(4) = 
     +'Vectors are transformed into advanced pie chart files which can'
         extras(5) = 
     +'be made directly for special features. To appreciate this use' 
         extras(6) = 
     +'[Demo] then [View] then [Open] on an advanced pie chart file.'  
      elseif (isend.eq.6) then
         stub = 'vfield.tf1' 
         extras(2) = 
     +'Vector field diagrams can be created directly but more usually'
         extras(3) = 
     +'they are created for phase portraits of differential equations'   
         extras(4) = 
     +'generated by program DEQSOL.'
         extras(5) = 
     +'DEQSOL also provides options to colour arrows to emphasize'
         extras(6) =
     +'direction and alter sizes to indicate magnitude.' 
      elseif (isend.eq.7) then
         stub = 'surface.tf1'
         extras(2) = 
     +'Skyscraper type 3D bar charts can be created from n by matrices'
         extras(3) = 
     +'but 3D surfaces or contours diagrams require data in a special'   
         extras(4) = 
     +'n by 1 vector format which can be understood by using the [Demo]'
         extras(5) = 
     +'button then [View] the last lines followed by [Open] to plot.'
         extras(6) =
     +'Such vectors can be created directly by programs such as QNFIT.'
      elseif (isend.eq.8) then
         stub = 'spiral.TFL'
         extras(2) = 
     +'Space curves or swarms of data points require files with three'
         extras(3) = 
     +'columns with x(t), y(t), z(t) data in either individual files,'   
         extras(4) = 
     +'library files or your project archive. If parameter t defines'
         extras(5) = 
     +'order the points can be joined up to form curves. Otherwise the'
         extras(6) =
     +'data can plot as swarms of points, e.g., with perpendiculars.'
      elseif (isend.eq.9) then
         stub = 'rose_e.mod'
         extras(2) = 
     +'Simplot can plot data in 2 dimensions defined by equations in'
         extras(3) = 
     +'parametric form such as r(theta), or [x(t), y(t)], or in 3'   
         extras(4) = 
     +'dimensions, that is [x(t),y(t),z(t)]. '
         extras(5) = 
     +'The mathematical model provided must be in the Simfit format for'
         extras(6) =
     +'mathematical models as created by program USERMOD.'
      elseif (isend.eq.15) then
         stub = 'metafile.tf1'
         extras(2) = 
     +'Simfit 2D advanced graphics can be interrupted at any point to'  
         extras(3) =    
     +'create a metafile containing all the data and control parameters'   
         extras(4) = 
     +'in current use. This is a very valuable feature allowing Simfit'
         extras(5) = 
     +'users to stop editing then store such a record because it can'
         extras(6) =
     +'be input later into program SIMPLOT in order to resume editing.'    
      else
         call putadv (
     +'ISEND out of range in call to SIMPLOT_TEST_FILES')
         return
      endif
     
      m = len_trim(stub)                           
      fname = dem(1:l)//stub(1:m)
      inquire (file = fname, exist = there, iostat = ios)  
      if (ios.eq.0 .and. .not.there) then
          fname = blank
          line = 'Test file '//stub(1:m)//' cannot be located' 
          call putadv (line)  
          return
      endif  
      
c
c build up the menu
c        
      do i = 1, numtxt
         numbld(i) = 0
         text(i) = blank
      enddo  
      numbld(1) = 4
      numbld(4) = 1 
      word100 = trim100(fname)
      numdec = 1
      cipher = blank
      repeet =.true.
      numdec = 4
      do while (repeet)
         if (switch_off(k)) then
            cipher = '[OK]'
            main_menu = .false.
            info = '[and proceed to experienced user mode]'
         else
            cipher = '[No]'
            main_menu = .true.
            info = '[and return to the main menu]'
         endif
         write (text,100) option(k), word100,
     +                   (extras(i), i = 1, num_xtra),
     +                    cipher, info   
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         if (numdec.eq.1) then
            numdec = 2
            
            if (isend.eq.2) then!simple graphs
               call simplot3_2 (fname) 
            elseif (isend.eq.3) then!double plot
               call simplot3_3   
            elseif (isend.eq.4) then!barchart
               call simplot3_4 (fname) 
            elseif (isend.eq.5) then!piechart
               call simplot3_5 (fname)  
            elseif (isend.eq.6) then!vector field
               call simplot3_6(fname)            
            elseif (isend.eq.7) then!3D surface
               call simplot3_7 (fname)
            elseif (isend.eq.8) then!space curves
               call simplot3_8 (fname)   
            elseif (isend.eq.9) then!r(theta)
               call simplot3_9 (fname)   
            elseif (isend.eq.15) then!metafile
               call simplot3_15 (fname)   
            endif
            
         elseif (numdec.eq.2) then
            numdec = 1
            call viewer (jsend,
     +                   fname, blank, blank)
         elseif (numdec.eq.3) then
            numdec = 1
            switch_off(k) = .not.switch_off(k)
         elseif (numdec.eq.4) then
            numdec = 2
            write (text_1,200)
            numbld_1(1) = 1
            numbld_1(19) = 1  
            numtxt_1 = 24
            call patch2 (numbld_1, numtxt_1,
     +                   text_1)              
         else   
            repeet = .false.  
         endif
      enddo
c
c always make sure that no test file is left in storage and that main_menu = .not.switch_off(k) 
c      
      call simplot_tf (blank,
     +                 store)
      main_menu = .not.switch_off(k) 
c
c format statements
c        
  100 format (
     + 'Simplot demonstration ',a
     +/
     +/'A typical test file to demonstrate this procedure is'
     +/a         
     +/'which can be viewed now by selecting option 2.'
     +/a!xtras(1) to 6 from here       
     +/a        
     +/a        
     +/a
     +/a
     +/a
     +/a
     +/'Plot data contained in this test file'        
     +/'View this test file to check the format'        
     +/'Switch_off View/Plot mode',2x,a   
     +/'Help' 
     +/'Quit ... Exit this procedure',1x,a)        
  200 format (  
     + 'Explanation about View/Plot mode for first-time Simplot users'
     +/
     +/'Simplot users will wish to analyse their own data sets and when' 
     +/'a file type has been selected from the main Simplot menu there'
     +/'will usually be one or more options available, as follows.' 
     +/
     +/'1)` Sequentially provide one or more individual data files'
     +/'2)` Input a library file for multiple file selection'
     +/'3)` Use a project archive for multiple file selection'
     +/'Also, from the File Open Dialogue there are always the options'
     +/'4)` Press the [Paste] button to retrieve clipboard data' 
     +/'5)` Press the [Demo] button to view/open test data files' 
     +/ 
     +/'However, when using any unfamilar plot type for the first time' 
     +/'the View/Plot option allows you to plot or view a test file to'
     +/'see the format required for each plot type. On exit, return to'
     +/'the main menu allows you to View-Plot other plot types.'
     +/
     +/'Switching off View/Plot mode and returning to Normal mode'
     +/
     +/'The View/Plot Simplot mode is intended to help first-time users'
     +/'to see what is involved with each plotting option by displaying'
     +/'the plot or the data format required. However, for each plot'
     +/'type, there is also an option to return to normal mode.')
      end
c
c-------------------------------------------------------------------
c
      subroutine simplot3_2 (fname)
c
c action: plot simple files
c author: w.g.bardsley, university of manchester, u.k., 29/08/2020
c      

      implicit none  
c
c argument
c      
      character (len = *), intent (in) :: fname
c
c locals
c      
      integer    i, ios 
      integer    nfiles, nin
      parameter (nfiles = 3)
      integer    jfiles(nfiles), lfiles(nfiles), mfiles(nfiles)
      character (len = 256 ) files(nfiles)
      character (len = 256 ) sim256
      character (len = 40  ) titles(4), stub
      external   getnou, smplot, sim256
      data       jfiles / 4, 1, 0 /
      data       lfiles / 0, 1, 2 /
      data       mfiles / 5, 0, 0 /
      data       titles / 'Plotting simfig1.TFL', 'x', 'y', ' ' / 
      if (index(fname,'simfig1.').le.0) return  
      call getnou (nin)
      open (unit = nin, file = fname, iostat = ios)  
      if (ios.ne.0) then
         close (unit = nin) 
         return
      endif
      do i = 1, 4
         read (nin,'(a)',iostat=ios) stub 
         if (ios.ne.0) then
            close (unit = nin)
            return
         endif
         if (i.gt.1) then
            files(i - 1) = sim256(stub)   
        endif
      enddo 
      close (unit = nin)
      call smplot (jfiles, lfiles, mfiles, nfiles,
     +             files, titles)
      end
c
c----------------------------------------------------------  
c  
      subroutine simplot3_3 
      implicit   none
      integer    i, nfiles
      parameter (nfiles = 3)
      integer jfiles(nfiles), 
     +        lfiles(nfiles),
     +        mfiles(nfiles)
      character (len = 256) files(nfiles), x_sim256
      CHARACTER (len = 60 ) titles(4)
      logical    left_axis(nfiles)
      external   dbplot, x_sim256
      titles(1) = 'plot2.tf1 (LHS), plot2.tf2 and plot2.tf3 (RHS).'
      titles(2) = 'X-values'
      titles(3) = 'Y-values (LHS)'
      titles(4) = 'Z-values (RHS)'
      do i = 1, nfiles
         if (i.eq.1) then
            files(i) = x_sim256('plot2.tf1')
            jfiles(i) = 1
            lfiles(i) = i
            mfiles(i) = 5
            left_axis(i) = .true.
         elseif (i.eq.2) then   
            files(i) = x_sim256('plot2.tf2')
            jfiles(i) = 4
            lfiles(i) = i
            mfiles(i) = 8
            left_axis(i) = .false.
         elseif (i.eq.3) then   
            files(i) = x_sim256('plot2.tf3')
            jfiles(i) = 2
            lfiles(i) = i
            mfiles(i) = 11
            left_axis(i) = .false.
         endif   
      enddo 
      call dbplot (jfiles, lfiles, mfiles, nfiles,
     +             files, titles,
     +             left_axis)   
      end
c
c---------------------------------------------------------------
c 
      subroutine simplot3_4 (fname)
c
c action: plot a barchart from a matrix file
c author: w.g.bardsley, university of manchester, u.k., 26/08/2020
c      

      implicit none  
c
c argument
c      
      character (len = *), intent (in) :: fname
c
c locals
c
      integer    i, ios, j, ncol, nin, nrow  
      integer    isend, ncmax, nrmax
      parameter (isend = 1, ncmax = 20, nrmax = 20)
      double precision xmat(nrmax,ncmax)
      character (len = 80) titles(4)
      character (len = 40) labels(nrmax)
      character (len = 1 ) blank
      parameter (blank = ' ')
      external   getnou, bcplot
      call getnou (nin)
      open (unit = nin, file = fname, iostat = ios)
      read (nin,'(a)',iostat=ios) titles(1)
      read (nin,*,iostat=ios) nrow, ncol
      do i = 1, nrow
         labels(i) = blank
         read (nin,*,iostat=ios) (xmat(i,j), j = 1, ncol)
      enddo
      titles(2) = 'x'
      titles(3) = 'y'
      titles(4) = blank 
      close (unit = nin)
      call bcplot (isend, ncol, nrmax, nrow,
     +             xmat,
     +             labels, titles)   
      end
c
c-------------------------------------------------------------
c
      subroutine simplot3_5 (fname)
c
c action: plot a piechart from a vector file
c author: w.g.bardsley, university of manchester, u.k., 26/08/2020
c      
      implicit none
c
c argument
c      
      character (len = *), intent (in) :: fname
c
c locals
c      
      integer    nin, npts
      integer    isend, nmax
      parameter (isend = 2, nmax = 20)
      integer    ifillv(nmax), ihuev(nmax)
      double precision fact(nmax), xvec(nmax)
      character (len = 1024) fcopy
      character (len = 100 ) title
      character (len = 40  ) lvec(nmax)
      logical    abort, supply
      parameter (supply = .true.)
      external   piefil$
      external   getnou, pcplot, copyfl, deltmp
      call copyfl (isend,
     +             fname, fcopy,
     +             abort)             
       call getnou (nin)
       close (unit = nin)
       call piefil$ (ifillv, ihuev, nin, nmax, npts,
     +               fact, xvec,
     +               fcopy, lvec, title,   
     +               abort, supply)
       close (unit = nin)
       call pcplot (isend, ifillv, ihuev, npts,
     +              fact, xvec,
     +              lvec, title)   
      call deltmp       
      end
c
c--------------------------------------------------------
c      
      subroutine simplot3_6 (fname)
c
c action: pass a vector-field file to glsvf1 for plotting
c author: w.g.bardsley, university of manchester, u.k. 01/09/2020
c      
      implicit   none
c
c argument
c      
      character (len = *), intent (in) :: fname
c
c locals
c          
      integer    i, ios, nin, ntemp, npts
      integer    jarrow
      parameter (jarrow = 1000)
      integer    iarrow(jarrow), icolor(jarrow)
      integer    lcolor, ngks 
      parameter (lcolor = 1, ngks = 0)
      double precision head(jarrow), x1(jarrow), x2(jarrow), 
     +                               y1(jarrow), y2(jarrow)
      character (len = 80) ptitle
      character (len = 1 ) xtitle, ytitle
      parameter (xtitle = 'x', ytitle = 'y')
      logical    axes, gsave
      parameter (axes = .true., gsave = .true.)
      external   getnou, gksvf1

      call getnou (nin)
      open (unit = nin, file = fname, iostat = ios)
      if (ios.ne.0) then
         close (unit = nin)
         return
      endif  
      read (nin,'(a)',iostat=ios) ptitle
      if (ios.ne.0) then
         close (unit = nin)
         return
      endif  
      read (nin,*,iostat=ios) npts, ntemp
      if (ios.ne.0) then
         close (unit = nin)
         return
      endif  
      do i = 1, npts
         iarrow(i) = 1
         icolor(i) = 0
         head(i) = 0.005d+00
         read (nin,*,iostat=ios) x1(i), x2(i), y1(i), y2(i)
         if (ios.ne.0) then
            close (unit = nin)
            return
         endif  
      enddo
      close (unit = nin)
      call GKSVF1 (IARROW, ICOLOR, NPTS, LCOLOR, NGKS,
     +             HEAD, X1, X2, Y1, Y2,
     +             PTITLE, XTITLE, YTITLE,
     +             AXES, GSAVE)
      end
c
c-----------------------------------------------------------------    
c
      subroutine simplot3_7 (fname)
c
c action: pass a surface file supplied in fname to surd2s for plotting
c author: w.g.bardsley, university of manchester, u.k. 25/08/2020
c      
      implicit   none
c
c argument
c      
      character (len = *), intent (in) :: fname
c
c locals
c      
      integer    i, icount, ios, ncol, nin, nrow, nx, ny
      integer    isend, nmax,  nz 
      parameter (isend = 3, nmax = 100, nz = nmax**2 + 6)
      double precision vector(nmax**2 + 6), z(nmax,nmax)
      double precision xmax, xmin, ymax, ymin   
      character (len = 100) title
      logical    unused(nmax,nmax)
      external   getnou, putadv, surd2s
      call getnou (nin)          
      open (unit = nin, file = fname, iostat = ios)
      if (ios.ne.0) goto 20
      icount = 1
      read (nin,'(a)',iostat=ios) title
      if (ios.ne.0) goto 20
      icount = icount + 1  
      read (nin, *,iostat=ios) nrow, ncol
      if (ios.ne.0 .or. ncol.ne.1 .or. nrow.gt.nz) goto 20 
      do i = 1, nrow 
         icount = icount + 1
         read (nin,*,iostat=ios) vector(i) 
         if (ios.ne.0) goto 20
      enddo  
      close (unit = nin)    
      nx = nint(vector(1))
      ny = nint(vector(2))
      xmin = vector(3)
      xmax = vector(4)
      ymin = vector(5)
      ymax = vector(6)
      call surd2s (isend, nmax, nx, ny,
     +             vector, xmax, xmin, ymax, ymin, z,
     +             unused)    
   20 continue
      close (unit = nin)
      if (ios.ne.0) then
         write (title,100) icount
         call putadv (title)
      endif
  100 format ('FILE supplied to SIMPLOT3_7 is inconsistent at line',i6)    
      end

c
c------------------------------------------------------------------------
c      
      subroutine simplot3_8 (fname)
c
c action: plot spiral.TFL
c author: w.g.bardsley, university of manchester, u.k. 29/08/2020
c 
      implicit   none
c
c argument
c      
      character (len = *), intent (in) :: fname
c
c locals
c           
      integer    i
      integer    nquery
      parameter (nquery = 5) 
      
      integer    ios, nfmax, nin
      parameter (nfmax = 2)
      character (len = 1024) ftemp(nfmax), stubs(nfmax), sim256
      character (len = 100 ) text(5), title
      logical    accept(5), plot_arrows, plot_labels, plot_lines,
     +           plot_perpendiculars, plot_symbols
      external   space6, sim256, getnou, chkbox
      intrinsic  index
      if (index(fname,'spiral.').le.0) return
c
c read file names off the library file
c        
      call getnou (nin)
      open (file = fname, unit = nin, iostat = ios)
      if (ios.ne.0) then
         close (unit = nin)
         return
      endif   
      read (nin,'(a)',iostat=ios) title
      if (ios.ne.0) then
         close (unit = nin)
         return
      endif 
      do i = 1, nfmax
         read (nin,'(a)',iostat=ios) stubs(i) 
         if (ios.ne.0) then
            close (unit = nin)
            return
         endif   
      enddo
      close (unit = nin)
      do i = 1, nfmax
         ftemp(i) = sim256(stubs(i))
      enddo   
c
c call chkbox
c      
      write (text,100)
      title = 'Select the default plotting style'
      do i = 1, 5
         if (i.eq.3 .or. i.eq.5) then
            accept(i) = .true.
         else    
            accept(i) = .false.
         endif   
      enddo
      call chkbox (nquery,
     +             text, title,
     +             accept)   
      plot_arrows = accept(1)
      plot_labels = accept(2)
      plot_lines = accept(3)
      plot_perpendiculars = accept(4)
      plot_symbols = accept(5)   
      call space6 (nfmax,
     +             ftemp,
     +             plot_arrows,
     +             plot_labels,
     +             plot_lines,
     +             plot_perpendiculars,
     +             plot_symbols)             
  100 format (
     + 'Plot arrows'
     +/'Plot labels'          
     +/'Plot lines'          
     +/'Plot perpendiculars'          
     +/'Plot symbols')          
      end
c
c----------------------------------------------------------------------- 
c  
      subroutine simplot3_9 (fname)

c
c action: plot r(theta)
c author: w.g.bardsley, university of manchester, u.k. 28/08/2020
c
c Note: for simplicity this does not actually use rose.mod
c      
      implicit   none
c
c argument
c      
      character (len = *), intent (in) :: fname
c
c locals
c      
      integer    i, ntheta
      parameter (ntheta = 200)
      double precision r(ntheta), t(ntheta)
      double precision delta, four, twopi, zero
      parameter (four = 4.0d+00, twopi = 6.2831853d+00, zero = 0.0d+00)
      external   rtplot
      intrinsic  cos, sin, index
      if (index(fname,'rose.mod').le.0 .and.
     +    index(fname,'rose_e.mod').le.0) return
      delta = twopi/dble(ntheta - 1)
      t(1) = zero
      do i = 2, ntheta - 1
         t(i) = t(i - 1) + delta
      enddo
      t(ntheta) = twopi
      do i = 1, ntheta
         r(i) = sin(four*t(i))
      enddo
      call rtplot (ntheta, 
     +             r, t)
      end                             
c
c-----------------------------------------------------------------------
c
      subroutine simplot3_15 (fname)  
c
c action: pass a copy of the metafile supplied in fname to mfplot for plotting
c author: w.g.bardsley, university of manchester, u.k. 28/08/2020
c
c  Note: it is important to make a copy of intent (in) files before using simplot_tf 
c        with store = .true. to transfer data to a plotting routine
c
      implicit none      
c   
c argument
c      
      character (len = *), intent (in) :: fname
c
c locals
c      
      
      integer    ifail
      character (len = 1024) ftemp 
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    abort, store
      parameter (store = .true.)
      external   mfplot, simplot_tf
      external   deltmp, gettmp, svg_copy
      call gettmp (ifail,
     +             ftemp) 
      call svg_copy (fname, ftemp,
     +               abort)
      if (abort) return     
      call simplot_tf (ftemp,
     +                 store)    
      call mfplot
      ftemp = blank
      call simplot_tf (ftemp,
     +                 store)
      call deltmp   
      end
c
c      