C
C------------------------------------------------------------
C  SIMSTAT.FOR: MAIN, DECIDE
C SIMSTAT1.FOR: SUB001 ... exhaustive analysis
C SIMSTAT2.FOR: SUB002 ... standard tests
C SIMSTAT3.FOR: SUB003 ... ANOVA
C SIMSTAT4.FOR: SUB004 ... ANOVAP
C SIMSTAT5.FOR: SUB005 ... Multivariate
C SIMSTAT6.FOR: SUB006 ... Regression
C SIMSTAT7.FOR: SUB007 ... GLM
C SIMSTAT8.FOR: SUB008 ... Time series
C SIMSTAT9.FOR: SUB009 ... Calculations
C SIMSTATA.FOR: SUB010 ... Numerical analysis
C SIMSTATX.INS: EXTRAS
C------------------------------------------------------------
C
C     INCLUDE 'simstat1.ins'
C     INCLUDE 'simstat2.ins'
C     INCLUDE 'simstat3.ins'
C     INCLUDE 'simstat4.ins'
C     INCLUDE 'simstat5.ins'
C     INCLUDE 'simstat6.ins'
C     INCLUDE 'simstat7.ins'
C     INCLUDE 'simstat8.ins'
C     INCLUDE 'simstat9.ins'
C     INCLUDE 'simstata.ins'
C     INCLUDE 'simstatx.ins'
C     INCLUDE 'dllchk.for'
      PROGRAM MAIN
C
C VERSION: now set by the call to SIMVER/DLLCHK
C ACTION : The main SIMFIT statistical programs
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          16/06/1996 added zeros of a polynomial (ZEROS1)
C          19/07/1996 added determinant, eigenvalues, inverse
C          24/07/1996 added solutions for Ax = b (A sq. nonsingular)
C          14/12/1996 added VECTST, XYCORR and NPCORR
C          16/12/1996 added ANOVA routines
C          19/12/1996 added LINEAR, CONTIN, TTESTS
C          22/12/1996 added MWUTST, KS1SAM, KS2SAM, XSAV, YSAV, ZSAV,
C                           TITLEX, TITLEY, TITLEZ, NXSAV, NYSAV, NZSAV
C          05/05/1997 WIN32 version
C          01/11/1997 added POLBIN to SUB008
C          21/02/1998 added SPOWER to SUB008
C          07/08/1998 added dllchk
C          07/09/1998 added CLIM95 to SUB008 and decreased NCMAX from 50 to 16
C          14/12/1998 replaced TUTORS by TUTOR1
C          28/01/1999 added autocorrelations
C          17/03/1999 added L1 norm AX = B
C          30/06/1999 added regression options and analysis of proportions
C          05/08/1999 added call to MATEXH and increased NCMAX back to 50
C          07/08/1999 added SSHELP, BINOMP, TRINOM
C          12/08/1999 added NCSAV, NRSAV, ASAV, FSAV1, TSAV1 to preserve
C                     data between calls to NPCORR and XYCORR
C          13/09/1999 added calls to WINDOW
C          26/10/1999 decreased NRMAX from 10000 to 5000
C          14/02/2000 added SIMVER
C          07/08/2000 added GLM
C          28/05/2001 added SIMPLE
C          17/07/2001 added CLUST1/DENDR1
C          18/08/2001 added extra arrays for MATEXH dimensioned N100
C          30/01/2002 added TITLEA for ASAV
C          01/03/2002 reverted %ww to topmost and no_minbox
C          29/08/2002 increased dimension of IWRK for Cox regression and
C                     added IWRK to call to SUBCCC
C          24/09/2002 increased dimension of W for cluster analysis
C          08/10/2002 very extensive revision including SUB001 to SUB006
C          03/12/2002 introduced NWMAX to dimension W for large dendrograms
C          28/07/2003 added IWRK, A, NCMAX, NGRAF, XGRAF, YGRAF to argument
C                     list for SUB006 and survival times to time series menu
C          26/01/2004 extensive reorganisation
C          10/06/2005 added MWRK and new arguments list for SUB004
C          27/07/2005 added DVER in call to ADVISE
C          19/08/2005 added COMMAND_LINE@, JUMP and code changes to allow
C                     FNAMES and RESFIL to work properly
C          30/10/2005 added extra arguments to SUB06 and SUB08 and replaced
C                     ADVISE_SIMSTAT by direct call to HELP_SIMSTAT
C          13/12/2005 start of major editing to decrease memory requirements:
C                     deleted NOBS, AA, BB, PRED (SUB009)
C                     deleted WORK1, XBIGT (SUB006)
C                     changed NSMALL from 100 to 10, Now E is E(NRMAX, NCMAX + 8)
C                     deleted VGLM and replaced by E (in SUB007, SUB008)
C                     deleted ZPOLY in call to SUB009, SUB010
C                     deleted MWRK and used IWRK in call to SUB004
C                     deleted Z1 and Z2 from call to SUB001
C          06/01/2006 deleted N100 and UNUSED in call to SUB001, deleted
C                     references to D, E, S, W3, W4, and W5 and slimmed down
C          22/01/2006 deleted Z and ZSAV
C          12/03/2006 major overhaul...SIMSTAT now has minimum memory load
C          01/08/2006 increased MAX_MM and added new arguments for SUB005 
C          16/06/2007 replaced COMLIN by COMMAND_ARGUMENT_COUNT and GET_COMMAND 
C          16/09/2007 increased NXYMAX to 10 
C          09/08/2008 increased NAMAX to 40
C          05/02/2017 added arguments to call M_MATONE from SUB009 
C          29/10/2023 added call to SV_SIMSTAT when run_program passes '11' instead of '0'
C------------------------------------------------------------------------------
C
      IMPLICIT   NONE
C
C Parameters used to set array dimensions, etc.
C
      INTEGER    MAX_MM, MAX_MV, NAMAX, NBMAX, NIN, NOUT, NXYMAX, NZMAX
      PARAMETER (MAX_MM =  5, !no. of matrix-matrix files stored....(for m_mattwo)
     +           MAX_MV =  6, !no. of matrix-vector files stored....(for m_matvec)
     +            NAMAX = 40, !no. of matrix files stored...........(for m_matone)
     +            NBMAX = 20, !no. of multivariate matrices stored..(for m_mvstat)
     +              NIN =  3, !unconnected unit for data input
     +             NOUT =  4, !pre-connected unit for results file
     +           NXYMAX = 10, !no. of vector pairs stored...........(for m_vectwo)
     +            NZMAX = 18) !no. of vector files stored...........(for m_vecone)
C
C Arrays holding dimensions and filenames/titles for stored data
C
      INTEGER    NC1_MM(MAX_MM), NC2_MM(MAX_MM),
     +           NR1_MM(MAX_MM), NR2_MM(MAX_MM)
      INTEGER    NB_MV(MAX_MV),  NC_MV(MAX_MV), NR_MV(MAX_MV)
      INTEGER    NCSAVA(NAMAX),  NCSAVB(NBMAX),
     +           NRSAVA(NAMAX),  NRSAVB(NBMAX)
      INTEGER    NXSAV(NXYMAX),  NYSAV(NXYMAX), NZSAV(NZMAX)
      CHARACTER  F1_MM(MAX_MM)*1024,  F1_MV(MAX_MV)*1024,
     +           F2_MM(MAX_MM)*1024,  F2_MV(MAX_MV)*1024,
     +           S_MM(MAX_MM)*5,     S_MV(MAX_MV)*4,
     +           T1_MM(MAX_MM)*80,   T1_MV(MAX_MV)*80,
     +           T2_MM(MAX_MM)*80,   T2_MV(MAX_MV)*80
      CHARACTER  FNAMEA(NAMAX)*1024,  FNAMEB(NBMAX)*1024,
     +           FNAMEX(NXYMAX)*1024, FNAMEY(NXYMAX)*1024,
     +           FNAMEZ(NZMAX)*1024,
     +           PAIRXY(NXYMAX)*3,
     +           STOREA(NAMAX)*2,    STOREB(NBMAX)*2,
     +           STOREXY(NXYMAX)*3,  STOREZ(NZMAX)*1,
     +           TITLEA(NAMAX)*80,   TITLEB(NBMAX)*80,
     +           TITLEX(NXYMAX)*80,  TITLEY(NXYMAX)*80,
     +           TITLEZ(NZMAX)*80
C
C Parameters that must not be changed, edited in any way, or translated
C
      INTEGER    N0, N1, N2, N10, N11
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N10 = 10, N11 = 11)
      CHARACTER  PVER*15
      PARAMETER (PVER = 'w_simstat.exe')
      CHARACTER  BLANK*1, PNAME*7
      PARAMETER (BLANK = ' ', PNAME = 'SIMSTAT')
      CHARACTER  SIMFIT*16
      PARAMETER (SIMFIT = 'Simfit: program ')
c
c Parameters that can be translated if required
c
      CHARACTER  NO_DATA*30, NO_FILE*30
      PARAMETER (NO_DATA = 'No data', NO_FILE = 'No file')
C
C Scalars
C
      INTEGER    I, IOS, ISEND, J
      INTEGER    I_LENGTH, I_STATUS
      DOUBLE PRECISION XVER, YVER
      CHARACTER  LOGFIL*1024, TITLE*80
      CHARACTER  COMMAND*100
      CHARACTER  DVER*30
      CHARACTER (LEN = 1) LETTER
      LOGICAL    ABORT, ACTION, FIRST, JUMP, REPEET, SHOW
C
C Externals
C
      EXTERNAL   SV_SIMSTAT
      EXTERNAL   HELP_SIMSTAT
      EXTERNAL   RESFIL, FNAMES, REVPRO
      EXTERNAL   DECIDE, SUB001, SUB002, SUB003, SUB004, SUB005, SUB006,
     +           SUB007, SUB008, SUB009, SUB010
      EXTERNAL   DLLCHK, WINDOW, SIMVER  
      EXTERNAL   SIMSTAT_REQUIRED
      INTRINSIC  COMMAND_ARGUMENT_COUNT, GET_COMMAND_ARGUMENT
C
C Saved variables
C
      SAVE       FIRST

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = N1
      ACTION = .TRUE.
      TITLE = SIMFIT//PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

C
C First check the command line to initialise ISEND and JUMP
C
      ISEND = COMMAND_ARGUMENT_COUNT()  
      IF (ISEND.NE.N1) THEN
         ISEND = N0
      ELSE      
         CALL GET_COMMAND_ARGUMENT (N1, COMMAND, I_LENGTH, I_STATUS)
   
         IF (I_LENGTH.GE.N1 .AND. I_STATUS.EQ.N0) THEN
C
C 29/10/2023
C Replaced non-integer characters by blanks to interpret '0' as 0 which causes trouble otherwise
C It appears that 'i' is passed by run_program and returned as such by command argument 
C retrieval and read accurately except for '0' which is not read as 0 even if the quotes are 
C removed. Is it being read as a C string terminator ? So 0 is changed to 11 to call sv_simstat. 
C         
            do i = 1, i_length
               letter = command(i:i)
               j = ichar(letter)
               if (j.lt.48 .or. j.gt.57) command(i:i) = blank
            enddo  
                        
            READ (COMMAND,*,IOSTAT=IOS) I

            IF (IOS.EQ.N0) THEN
               IF (I.EQ.N11) THEN
                  ISEND = N11
                  CALL SV_SIMSTAT
                  GOTO 20
               ELSEIF (I.GE.N1 .AND. I.LE.N10) THEN
                  ISEND = I
               ELSE
                  ISEND = N0
               ENDIF
            ELSE
               ISEND = N0
            ENDIF
         ELSE
            ISEND = N0
         ENDIF      
      ENDIF
      IF (ISEND.EQ.N0) THEN
         JUMP = .FALSE.
      ELSE
         JUMP = .TRUE.
      ENDIF
C
C Now initialise the other variables
C
      LOGFIL = BLANK
      TITLE = NO_DATA
      DO I = N1, MAX_MM
         NC1_MM(I) = N0
         NC2_MM(I) = N0
         NR1_MM(I) = N0
         NR2_MM(I) = N0
         F1_MM(I) = NO_FILE
         F2_MM(I) = NO_FILE
         S_MM(I) = BLANK
         T1_MM(I) = NO_DATA
         T2_MM(I) = NO_DATA
      ENDDO
      DO I = N1, MAX_MV
         NB_MV(I) = N0
         NC_MV(I) = N0
         NR_MV(I) = N0
         F1_MV(I) = NO_FILE
         F2_MV(I) = NO_FILE
         S_MV(I) = BLANK
         T1_MV(I) = NO_DATA
         T2_MV(I) = NO_DATA
      ENDDO
      DO I = N1, NAMAX
         NCSAVA(I) = N0
         NRSAVA(I) = N0
         FNAMEA(I) = NO_FILE
         STOREA(I) = BLANK
         TITLEA(I) = NO_DATA
      ENDDO
      DO I = N1, NBMAX
         NCSAVB(I) = N0
         NRSAVB(I) = N0
         FNAMEB(I) = NO_FILE
         STOREB(I) = BLANK
         TITLEB(I) = NO_DATA
      ENDDO
      DO I = N1, NXYMAX
         NXSAV(I) = N0
         NYSAV(I) = N0
         PAIRXY(I) = BLANK
         STOREXY(I) = BLANK
      ENDDO
      DO I = N1, NZMAX
         NZSAV(I) = N0
         FNAMEZ(I) = NO_FILE
         STOREZ(I) = BLANK
         TITLEZ(I) = NO_DATA
      ENDDO
      ABORT = .TRUE.
      FIRST = .TRUE.
      REPEET = .TRUE.
C
C The main loop
C =============
C
      DO WHILE (REPEET)
C
C Call the main menu if JUMP = .FALSE.
C
         IF (.NOT.JUMP) CALL DECIDE (ISEND,
     +                               DVER)
         IF (FIRST .AND. ISEND.GE.N1 .AND. ISEND.LE.N10) THEN
C
C Open the results file only on the first time round
C
            FIRST = .FALSE.
            CALL RESFIL (NOUT,
     +                   LOGFIL,
     +                   ABORT)
            WRITE (NOUT,100)
         ENDIF
         CALL SIMSTAT_REQUIRED (ISEND)
         IF (ISEND.EQ.1) THEN
C
C ISEND = 1: Explore
C ==========
C
            CALL SUB001 (NAMAX, NCSAVA, NIN, NOUT, NRSAVA,
     +                   NXSAV, NXYMAX, NYSAV, NZMAX, NZSAV,
     +                   FNAMEA, FNAMEX, FNAMEY, FNAMEZ,
     +                   NO_DATA, NO_FILE, PAIRXY,
     +                   STOREA, STOREXY, STOREZ,
     +                   TITLEA, TITLEX, TITLEY, TITLEZ)
         ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: Tests
C ==========
C
            CALL SUB002 (NAMAX, NCSAVA, NIN, NOUT, NRSAVA, NXSAV,
     +                   NXYMAX, NYSAV, NZMAX, NZSAV,
     +                   FNAMEA, FNAMEX, FNAMEY, FNAMEZ,
     +                   NO_DATA, NO_FILE, PAIRXY,
     +                   STOREA, STOREXY, STOREZ,
     +                   TITLEA, TITLEX, TITLEY, TITLEZ)
         ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3: ANOVA
C ==========
C
            CALL SUB003 (NIN, NOUT)
         ELSEIF (ISEND.EQ.4) THEN
C
C ISEND = 4: ANOVAP
C ==========
C
            CALL SUB004 (NIN, NOUT)
         ELSEIF (ISEND.EQ.5) THEN
C
C ISEND = 5: Multivariate
C ==========
C
            CALL SUB005 (MAX_MM, NBMAX, NCSAVB, NC1_MM, NC2_MM, NIN,
     +                   NOUT, NRSAVB, NR1_MM, NR2_MM, NZMAX, NZSAV,
     +                   FNAMEB, FNAMEZ, F1_MM, F2_MM,
     +                   NO_DATA, NO_FILE, STOREB, STOREZ, S_MM,
     +                   TITLEB, TITLEZ, T1_MM, T2_MM)
         ELSEIF (ISEND.EQ.6) THEN
C
C ISEND = 6: Regression
C ==========
C
            CALL SUB006 (NAMAX, NCSAVA, NIN, NOUT, NRSAVA,
     +                   FNAMEA, NO_DATA, NO_FILE, STOREA, TITLEA)
         ELSEIF (ISEND.EQ.7) THEN
C
C ISEND = 7: Generalized linear models
C ==========
C
            CALL SUB007 (NIN, NOUT)
         ELSEIF (ISEND.EQ.8) THEN
C
C ISEND = 8: Time series
C ==========
C
            CALL SUB008 (NAMAX, NCSAVA, NIN, NOUT, NRSAVA, NZMAX, NZSAV,
     +                   FNAMEA, FNAMEZ, NO_DATA, NO_FILE, STOREA,
     +                   STOREZ, TITLEA, TITLEZ)
         ELSEIF (ISEND.EQ.9) THEN
C
C ISEND = 9: Statistical calculations
C ==========
C
            CALL SUB009 (NAMAX, NCSAVA, NIN, NOUT, NRSAVA, NXSAV, 
     +                   NXYMAX, NYSAV, NZMAX, NZSAV,
     +                   FNAMEA, FNAMEX, FNAMEY, FNAMEZ, NO_DATA,
     +                   NO_FILE, PAIRXY, STOREA, STOREXY, STOREZ,
     +                   TITLEA, TITLEX, TITLEY, TITLEZ)
         ELSEIF (ISEND.EQ.10) THEN
C
C ISEND = 10: Numerical analysis
C ===========
C
            CALL SUB010 (MAX_MM, MAX_MV, NAMAX, NB_MV, NC_MV, NCSAVA,
     +                   NC1_MM, NC2_MM, NIN, NOUT, NRSAVA, NR_MV,
     +                   NR1_MM, NR2_MM, NZMAX, NZSAV,
     +                   F1_MM, F1_MV, F2_MM, F2_MV, FNAMEA, FNAMEZ,
     +                   NO_DATA, NO_FILE,
     +                   S_MM, S_MV, STOREA, STOREZ, TITLEA, TITLEZ,
     +                   T1_MM, T1_MV, T2_MM, T2_MV)
         ELSEIF (ISEND.EQ.11) THEN
C
C ISEND = 11: Advice
C ==========
C
            CALL HELP_SIMSTAT ('simstat')
         ELSEIF (ISEND.EQ.12) THEN
C
C ISEND = 12: Review progress so far
C ===========
C
            CALL REVPRO (NOUT)
         ELSEIF (ISEND.EQ.13) THEN
C
C ISEND = 13: Exit from program SIMSTAT
C ===========
C
            REPEET = .FALSE.
         ENDIF
C
C Jump out of the loop if JUMP = .TRUE.
C
         IF (JUMP) REPEET = .FALSE.
      ENDDO
C
C Close the results file and inform the user
C
      CLOSE (UNIT = NOUT)
      ISEND = N2
      CALL FNAMES (ISEND,
     +             LOGFIL)

C
C======================================================================
C The program is finished so we can close down the background window
C

   20 CONTINUE  
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C
      CLOSE (UNIT = NOUT)
C
C Format statements
C
  100 FORMAT (
     +/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : SIMSTAT'
     +/1X,'ACTION  : stats: explore/test/calculate/regress/time series'
     +/1X,'AUTHOR  : W.G.Bardsley, University of Manchester, U.K.')
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE DECIDE (ISEND,
     +                   DVER)
C
C Choose details required
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    ISEND
      CHARACTER  DVER*(*)
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NMENU, NUMDEC, NUMHDR,
     +           NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NMENU = 3,
     +           NUMHDR = 13, NUMOPT = 13)
      INTEGER    NSTART, NTEXT
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(3)*50
      CHARACTER  TEXT(30)*100
      LOGICAL    FIRST
      LOGICAL    FIXED, FULL, HIGH
      PARAMETER (FIXED = .FALSE., FULL = .FALSE., HIGH = .TRUE.)
      EXTERNAL   TITLES, LBOX01
      SAVE       FIRST
      DATA       FIRST / .TRUE. /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      IF (FIRST) THEN
C
C First time show the introductory logo
C
         WRITE (HEADER,100) DVER
         NUMDEC = 1
         CALL TITLES (ICOLOR, NUMBLD, NUMDEC, NUMHDR, NMENU, NUMPOS,
     +                HEADER, OPTION)
         IF (NUMDEC.EQ.1) THEN
            ISEND = 11
            RETURN
         ELSEIF (NUMDEC.EQ.2) THEN
            FIRST = .FALSE.
         ELSEIF (NUMDEC.EQ.3) THEN
            ISEND = NUMOPT
            RETURN
         ENDIF
      ENDIF
C
C Subsequently show the subsidiary menu
C
      FIRST = .FALSE.
      WRITE (TEXT,200)
      NSTART = 3
      NTEXT = NSTART + NUMOPT - 1
      NUMDEC = NUMOPT - 2
      NUMBLD(1) = 1
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             FIXED, FULL, HIGH)
      ISEND = NUMDEC
C
C Format statements
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `SIMSTAT'
     +/'        `      '
     +/'Action  `Data exploration, statistical tests,'
     +/'        `calculations, regression, calibration,'
     +/'        `generalized linear models, and time series.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
  200 FORMAT (
     + 'The SIMSTAT statistical options'
     +/
     +/'Data exploration'
     +/'Standard statistical tests'
     +/'Analysis of variance'
     +/'Analysis of proportions'
     +/'Multivariate statistics'
     +/'Regression and calibration'
     +/'Generalized linear models'
     +/'Smoothing, time-series and survival analysis'
     +/'Statistical calculations'
     +/'Numerical analysis'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit program Simstat')
      END
C
C
      subroutine simstat_required (isend)
c
c action: set mask for the main simstat menu demo files
c author: w.g.bardsley, university of manchester, u.k., 16/08/2020
c      
      implicit none
c
c argument
c      
      integer, intent (in) :: isend
c
c locals
c      
      integer i
      integer nmask
      parameter (nmask = 10)
      integer mask(nmask)
      logical store
      parameter (store = .true.)
      external query_files_required
c
c check isend
c      
      if (isend.lt.1 .or. isend.gt.10) then
         do i = 1, nmask
            mask(i) = 1
         enddo
      else   
         do i = 1, nmask
            if (i.eq.isend) then
               mask(i) = 1
            else   
               mask(i) = 0
            endif   
         enddo    
      endif
      call query_files_required (mask, nmask,
     +                           store)
      end
c
c          