
C
C SIMSTAT2.FOR: Include file for SIMSTAT
C =============
C
C SUB002
C Date of this version 26/02/2009
C
C-----------------------------------------------------------------------
C
      SUBROUTINE SUB002 (NAMAX, NCSAV, NIN, NOUT, NRSAV, NXSAV, NXYMAX,
     +                   NYSAV, NZMAX, NZSAV,
     +                   FNAMEA, FNAMEX, FNAMEY, FNAMEZ, NO_DATA,
     +                   NO_FILE, PAIRXY, STOREA, STOREXY, STOREZ,
     +                   TITLEA, TITLEX, TITLEY, TITLEZ)
C
C Standard tests
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NAMAX, NXYMAX, NZMAX
      INTEGER,             INTENT (IN)    :: NIN, NOUT
      INTEGER,             INTENT (INOUT) :: NCSAV(NAMAX),
     +                                       NRSAV(NAMAX),
     +                                       NXSAV(NXYMAX), 
     +                                       NYSAV(NXYMAX), 
     +                                       NZSAV(NZMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAMEA(NAMAX),
     +                                       FNAMEX(NXYMAX),
     +                                       FNAMEY(NXYMAX), 
     +                                       FNAMEZ(NZMAX),
     +                                       NO_DATA, NO_FILE, 
     +                                       PAIRXY(NXYMAX),
     +                                       STOREA(NAMAX),
     +                                       STOREXY(NXYMAX),
     +                                       STOREZ(NZMAX),
     +                                       TITLEA(NAMAX),
     +                                       TITLEX(NXYMAX), 
     +                                       TITLEY(NXYMAX),
     +                                       TITLEZ(NZMAX)
C
C Locals
C
      INTEGER    IX, IY, NUMDEC, NUMOPT, NTEXT
      PARAMETER (IX = 4, IY = 4, NUMOPT = 21, NTEXT = NUMOPT + 1)
      INTEGER    JSEND, N1
      PARAMETER (JSEND = 2, N1 = 1)
      INTEGER    I, ISEND, NX, NY, NZ
      DOUBLE PRECISION RTOL, X02AMF$, X(N1), Y(N1), Z(N1)
      CHARACTER  TEXT(NTEXT)*100
      CHARACTER  XTITLE*1, YTITLE*1, ZTITLE*1
      LOGICAL    TITLES
      PARAMETER (TITLES = .TRUE.)
      LOGICAL    REPEET
      EXTERNAL   LVIEW2, BINOMT, REVPRO, BINOMP, RUNSIN, TESTFS
      EXTERNAL   M_VECONE, M_VECTWO, M_MATONE, VAREQ0
      EXTERNAL   HELP_SIMSTAT
      EXTERNAL   X02AMF$
      EXTERNAL   STORE_A, STORE_XY, STORE_Z
      REPEET = .TRUE.
      DO WHILE (REPEET)
         CLOSE (UNIT = NIN)
         CALL STORE_A (NAMAX, NCSAV, NRSAV,
     +                 FNAMEA, NO_DATA, NO_FILE, STOREA, TITLEA)
         CALL STORE_XY (NXSAV, NXYMAX, NYSAV,
     +                  FNAMEX, FNAMEY, NO_DATA, NO_FILE, PAIRXY,
     +                  STOREXY, TITLEX, TITLEY)
         CALL STORE_Z (NZMAX, NZSAV,
     +                 FNAMEZ, NO_DATA, NO_FILE, STOREZ, TITLEZ)
         WRITE (TEXT,100) (STOREZ(I), I = 2, 5),
     +                     STOREXY(2), PAIRXY(3), STOREXY(4),
     +                     STOREXY(5), PAIRXY(6), PAIRXY(10),
     +                    (STOREA(I), I = 8, 10)
         NUMDEC = NUMOPT - 1
         CALL LVIEW2 (IX, IY, NUMDEC, NUMOPT,
     +                TEXT, TITLES)
         IF (NUMDEC.EQ.1) THEN
C
C 1-sample t test
C
            ISEND = 2
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         ELSEIF (NUMDEC.EQ.2) THEN
C
C 1-sample Kolmogorov-smirnov test
C
            ISEND = 3
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         ELSEIF (NUMDEC.EQ.3) THEN
C
C 1-sample normal distribution test
C
            ISEND = 4
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         ELSEIF (NUMDEC.EQ.4) THEN
C
C 1-sample poisson test
C
            ISEND = 5
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         ELSEIF (NUMDEC.EQ.5) THEN
C
C 2-sample unpaired t test
C
            ISEND = 2
            CALL M_VECTWO (ISEND, NIN, NOUT, NXSAV(ISEND), NYSAV(ISEND),
     +                     FNAMEX(ISEND), FNAMEY(ISEND), TITLEX(ISEND),
     +                     TITLEY(ISEND))
         ELSEIF (NUMDEC.EQ.6) THEN
C
C 2-sample paired t test
C
            ISEND = 3
            CALL M_VECTWO (ISEND, NIN, NOUT, NXSAV(ISEND), NYSAV(ISEND),
     +                     FNAMEX(ISEND), FNAMEY(ISEND), TITLEX(ISEND),
     +                     TITLEY(ISEND))
         ELSEIF (NUMDEC.EQ.7) THEN
C
C 2-sample Kolmogorov-Smirnov test
C
            ISEND = 4
            CALL M_VECTWO (ISEND, NIN, NOUT, NXSAV(ISEND), NYSAV(ISEND),
     +                     FNAMEX(ISEND), FNAMEY(ISEND), TITLEX(ISEND),
     +                     TITLEY(ISEND))
         ELSEIF (NUMDEC.EQ.8) THEN
C
C 2-sample Mann-Whitney U test
C
            ISEND = 5
            CALL M_VECTWO (ISEND, NIN, NOUT, NXSAV(ISEND), NYSAV(ISEND),
     +                     FNAMEX(ISEND), FNAMEY(ISEND), TITLEX(ISEND),
     +                     TITLEY(ISEND))
         ELSEIF (NUMDEC.EQ.9) THEN
C
C 2-sample Wilcoxon paired-sample signed-rank test
C
            ISEND = 6
            CALL M_VECTWO (ISEND, NIN, NOUT, NXSAV(ISEND), NYSAV(ISEND),
     +                     FNAMEX(ISEND), FNAMEY(ISEND), TITLEX(ISEND),
     +                     TITLEY(ISEND))
        ELSEIF (NUMDEC.EQ.10) THEN
C
C Observed/Expected frequencies
C
            ISEND = 10
            CALL M_VECTWO (ISEND, NIN, NOUT, NXSAV(ISEND), NYSAV(ISEND),
     +                     FNAMEX(ISEND), FNAMEY(ISEND), TITLEX(ISEND),
     +                     TITLEY(ISEND))     
         ELSEIF (NUMDEC.EQ.11) THEN
C
C Contingency table analysis
C
            ISEND = 8
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.12) THEN
C
C MacNemar test
C
            ISEND = 9
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.13) THEN
C
C Cochran Q test
C
            ISEND = 10
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.14) THEN
C
C Binomial test
C
            CALL BINOMT (NOUT)
         ELSEIF (NUMDEC.EQ.15) THEN
C
C Sign test
C
            CALL BINOMP (NOUT)
         ELSEIF (NUMDEC.EQ.16) THEN
C
C Runs and signs tests
C
            CALL RUNSIN (JSEND, NIN, N1, NOUT, NX, NY, NZ,
     +                   X, Y, Z,
     +                   XTITLE, YTITLE, ZTITLE)
         ELSEIF (NUMDEC.EQ.17) THEN
C
C F test
C
            RTOL = 1.0D+09*X02AMF$()
            CALL TESTFS (NOUT, RTOL)
         ELSEIF (NUMDEC.EQ.18) THEN
C
C Variance homogeneity
C            
            CALL VAREQ0 (NIN, NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Help
C
            CALL HELP_SIMSTAT ('simstat')
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF
         CLOSE (UNIT = NIN)
      ENDDO
  100 FORMAT (
     + 'The SIMSTAT standard tests options    `Data format'
     +/'1-sample t test                       `1 vector',1X,A
     +/'1-sample Kolmogorov-Smirnov test      `1 vector',1X,A
     +/'1-sample normal distribution test     `1 vector',1X,A
     +/'1-sample Poisson distribution test    `1 vector',1X,A
     +/'2-sample unpaired t test              `2 vectors',1X,A
     +/'2-sample paired t test                `paired samples',1X,A
     +/'2-sample Kolmogorov-Smirnov test      `2 vectors',1X,A
     +/'2-sample Wilcoxon-Mann-Whitney-U test `2 vectors',1X,A
     +/'2-sample Wilcoxon signed-rank test    `paired samples',1X,A
     +/'Chi-sq. Observed/Expected frequencies `paired samples',1X,A
     +/'Chi-sq./Fisher/GLM contingency table  `1 matrix',1X,A
     +/'McNemar test on paired frequencies    `1 matrix (square)',1X,A
     +/'Cochran Q test (on 0/1 integer matrix)`1 matrix',1X,A
     +/'Binomial test: K successes in N trials`3 numbers'
     +/'Sign test: known number of +/- signs  `2 numbers'
     +/'Runs test: known number of +/- runs   `3 numbers'
     +/'F test for excess variance: two WSSQ  `5 numbers'
     +/'Variance homogeneity tests            `n vectors/n by m matrix'
     +/'Results                               `...'
     +/'Help                                  `...'
     +/'Exit standard tests options           `...')
      END
C
C-----------------------------------------------------------------------
C
