C
C SIMSTAT8.INS: Include file for SIMSTAT
C =============
C
C SUB008
C Date of this version 12/03/2006
C
C-----------------------------------------------------------------------
C
C
      SUBROUTINE SUB008 (NAMAX, NCSAV, NIN, NOUT, NRSAV, NZMAX, NZSAV,
     +                   FNAMEA, FNAMEZ, NO_DATA, NO_FILE, STOREA,
     +                   STOREZ, TITLEA, TITLEZ)
C
C Time series and survival analysis
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NAMAX, NZMAX
      INTEGER    NCSAV(NAMAX), NIN, NOUT, NRSAV(NAMAX), NZSAV(NZMAX)
      CHARACTER  FNAMEA(NAMAX)*(*), FNAMEZ(NZMAX)*(*), NO_DATA*(*),
     +           NO_FILE*(*), STOREA(NAMAX)*(*),
     +           STOREZ(NZMAX)*(*), TITLEA(NAMAX)*(*),
     +           TITLEZ(NZMAX)*(*)
C
C Locals
C
      INTEGER    IX, IY, NUMDEC, NUMOPT, NTEXT
      PARAMETER (IX = 4, IY = 4, NUMOPT = 12, NTEXT = NUMOPT + 1)
      INTEGER    MTYPE
      PARAMETER (MTYPE = 2)
      INTEGER    ISEND
      CHARACTER  TEXT(NTEXT)*100
      LOGICAL    TITLES
      PARAMETER (TITLES = .TRUE.)
      LOGICAL    REPEET
      EXTERNAL   LVIEW2, REVPRO
      EXTERNAL   HELP_SIMSTAT
      EXTERNAL   STORE_A, STORE_Z
      EXTERNAL   M_VECONE, M_MATONE, M_GLMINI, M_SURVIV
      REPEET = .TRUE.
      DO WHILE (REPEET)
         CLOSE (UNIT = NIN)
         CALL STORE_A (NAMAX, NCSAV, NRSAV,
     +                 FNAMEA, NO_DATA, NO_FILE, STOREA, TITLEA)
         CALL STORE_Z (NZMAX, NZSAV,
     +                 FNAMEZ, NO_DATA, NO_FILE, STOREZ, TITLEZ)
         WRITE (TEXT,100) STOREZ(7), STOREA(39), STOREA(40), STOREZ(8),
     +                    STOREA(36), STOREZ(9)
         NUMDEC = NUMOPT - 1
         CALL LVIEW2 (IX, IY, NUMDEC, NUMOPT, TEXT, TITLES)
         IF (NUMDEC.EQ.1) THEN
C
C Data smoothing
C
            ISEND = 7
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Smooth interpolation y = f(x)
C         
            ISEND = 39
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Smooth interpolation x(t), y(t)
C         
            ISEND = 40
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))       
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Lags, ACF, PACF
C
            ISEND = 8
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Auto- and cross-correlation matrices
C         
            ISEND = 36
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))     
         ELSEIF (NUMDEC.EQ.6) THEN
C
C ARIMA
C
            ISEND = 9
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Survival curves
C
            CALL M_SURVIV (NIN, NOUT)
         ELSEIF (NUMDEC.EQ.8) THEN
C
C GLM survival
C
            CALL M_GLMINI (MTYPE, NIN, NOUT)
         ELSEIF (NUMDEC.EQ.9) THEN
C
C Cox regression
C
            ISEND = 11
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Help
C
            CALL HELP_SIMSTAT ('simstat')
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF
         CLOSE (UNIT = NIN)
      ENDDO
  100 FORMAT (
     + 'SIMSTAT smoothing/time series/survival options `Data format'
     +/'Data smoothing                                 `nx1 vector',1X,A
     +/'Smooth interpolation: single valued y = f(x)   `nx2 matrix',1X,A  
     +/'Smooth interpolation: parametric x(t), y(t)    `nx2 matrix',1X,A  
     +/'Lags, ACF and PACF                             `nx1 vector',1X,A
     +/'Auto- and cross-correlation matrices           `nx2 matrix',1X,A
     +/'ARIMA with forecasts                           `nx1 vector',1X,A
     +/'Survival curves (Kaplan-Meier)                 `t,c,f data'
     +/'Survival analysis (GLM techniques)             `',
     +'x1,x2,...,xn,y,t,s data'
     +/'Cox proportional hazard analysis               `',
     +'x1,x2,...,xn,y,t,s data'
     +/'Results                                        `...'
     +/'Help                                           `...'
     +/'Exit smoothing/time series/survival options    `...')
      END
C
C-----------------------------------------------------------------------
C
