
C
C SIMSTAT9.INS: Include file for SIMSTAT
C =============
C
C SUB009
C Date of this version 12/03/2006
C 05/02/2017 added further calls to M_VECONE and calls to M_MATONE and STORE_A
C            needing NAMAX, NCSAV, NRSAV, FNAMEA, TITLE and STOREA to argument list
C
C-----------------------------------------------------------------------
C
      SUBROUTINE SUB009 (NAMAX, NCSAV, NIN, NOUT, NRSAV, NXSAV, NXYMAX,
     +                   NYSAV, NZMAX, NZSAV,
     +                   FNAMEA, FNAMEX, FNAMEY, FNAMEZ, NO_DATA,
     +                   NO_FILE, PAIRXY, STOREA, STOREXY, STOREZ,
     +                   TITLEA, TITLEX, TITLEY, TITLEZ)
C
C Statistical calculations
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NAMAX
      INTEGER    NCSAV(NAMAX), NRSAV(NAMAX) 
      INTEGER    NXYMAX, NZMAX
      INTEGER    NIN, NOUT, NXSAV(NXYMAX), NYSAV(NXYMAX), NZSAV(NZMAX)
      CHARACTER  FNAMEA(NAMAX)*(*), STOREA(NAMAX)*(*), TITLEA(NAMAX)*(*)
      CHARACTER  FNAMEX(NXYMAX)*(*), FNAMEY(NXYMAX)*(*),
     +           FNAMEZ(NZMAX)*(*),
     +           NO_DATA*(*), NO_FILE*(*), PAIRXY(NXYMAX)*(*),
     +           STOREXY(NXYMAX)*(*), STOREZ(NZMAX)*(*),
     +           TITLEX(NXYMAX)*(*), TITLEY(NXYMAX)*(*),
     +           TITLEZ(NZMAX)*(*)
C
C Locals
C
      INTEGER    IX, IY, NUMDEC, NUMOPT, NTEXT
      PARAMETER (IX = 4, IY = 4, NUMOPT = 15, NTEXT = NUMOPT + 1)
      INTEGER    NTYPE
      INTEGER    ISEND
      CHARACTER  TEXT(NTEXT)*100
      LOGICAL    TITLES
      PARAMETER (TITLES = .TRUE.)
      LOGICAL    REPEET
      EXTERNAL   LVIEW2, REVPRO, NONCEN, DSTRBN, M_RANDAT, SPOWER,
     +           CLIM95, M_INDEXD, M_VECONE, M_MATONE,
     +           M_VECTWO, M_POLBIN
      EXTERNAL   STORE_A
      EXTERNAL   STORE_XY, STORE_Z
      EXTERNAL   HELP_SIMSTAT
      DATA       NTYPE / 1 /
      REPEET = .TRUE.
      DO WHILE (REPEET)
         CALL STORE_A (NAMAX, NCSAV, NRSAV,
     +                 FNAMEA, NO_DATA, NO_FILE, STOREA, TITLEA)
         CALL STORE_XY (NXSAV, NXYMAX, NYSAV,
     +                  FNAMEX, FNAMEY, NO_DATA, NO_FILE, PAIRXY,
     +                  STOREXY, TITLEX, TITLEY)
         CALL STORE_Z (NZMAX, NZSAV,
     +                 FNAMEZ, NO_DATA, NO_FILE, STOREZ, TITLEZ)
         CLOSE (UNIT = NIN)
         WRITE (TEXT,100) STOREZ(6), STOREXY(7)
         NUMDEC = NUMOPT - 1
         CALL LVIEW2 (IX, IY, NUMDEC, NUMOPT,
     +                TEXT, TITLES)
         IF (NUMDEC.EQ.1) THEN
C
C Power and sample size
C
            CALL SPOWER (NOUT)
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Confidence limits
C
            CALL CLIM95 (NIN, NOUT)
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Robust 1-sample
C
            ISEND = 6
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(1),
     +                     FNAMEZ(1), TITLEZ(1))
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Robust 2-sample
C
            ISEND = 7
            CALL M_VECTWO (ISEND, NIN, NOUT, NXSAV(ISEND), NYSAV(ISEND),
     +                     FNAMEX(ISEND), FNAMEY(ISEND), TITLEX(ISEND),
     +                     TITLEY(ISEND))
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Diversity indices
C
            CALL M_INDEXD (NIN, NOUT)
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Standard distributions
C
            CALL DSTRBN (NOUT, NTYPE)
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Noncentral distributions
C
            CALL NONCEN (NOUT, NTYPE)
         ELSEIF (NUMDEC.EQ.8) THEN
C
C Cooperativity analysis
C
            CALL M_POLBIN (NIN, NOUT)
         ELSEIF (NUMDEC.EQ.9) THEN
C
C Random numbers, permutations and latin squares
C
            CALL M_RANDAT
        ELSEIF (NUMDEC.EQ.10) THEN
C
C Kernel density estimation (NWMAX >= 3*NRMAX)
C
            ISEND = 11
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
        ELSEIF (NUMDEC.EQ.11) THEN
C
C False discovery rates for a vector
C
            ISEND = 17
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND)) 
         ELSEIF (NUMDEC.EQ.12) THEN
C
C False discovery rates for a matrix
C             
            ISEND = 38
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, 
     +                     NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND)) 
            
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Help
C
            CALL HELP_SIMSTAT ('simstat')
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Quit calculation options
C
            REPEET = .FALSE.
         ENDIF
         CLOSE (UNIT = NIN)
      ENDDO
  100 FORMAT (
     + 'SIMSTAT statistical calculations         `Data format'
     +/'Statistical power and sample size        `mu, sigma, n'
     +/'Estimate parameter confidence limits     `parameter estimates'
     +/'Robust calculations for one sample       `1 vector',1X,A
     +/'Robust calculations for two samples      `2 vectors',1X,A
     +/'Shannon/Brillouin diversity indices      `1 integer vector'
     +/'Plot/evaluate Standard distributions     `parameters'
     +/'Plot/evaluate Non-central distributions  `parameters'
     +/'Quantify ligand binding cooperativity    `constants K(i)'
     +/'Random numbers/permutions/Latin-Squares  `...'
     +/'Kernel density estimation                `1 vector'
     +/'False discovery rates for a vector p(i)  `1 vector' 
     +/'False discovery rates for a matrix p(i,j)`1 matrix' 
     +/'Results                                  `...'
     +/'Help                                     `...'
     +/'Exit statistical calculations options    `...')
      END
C
C
