
C
C SIMSTATX.INS: Include file for SIMSTAT
C =============
C
C STORE_A
C STORE_MM
C STORE_MV
C STORE_XY
C STORE_Z
C
C Date of this version 12/03/2006
C
C
C-----------------------------------------------------------------------
C
      SUBROUTINE STORE_A (NAMAX, NCSAV, NRSAV,
     +                    FNAMEA, NO_DATA, NO_FILE, STOREA, TITLEA)
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NAMAX
      INTEGER    NCSAV(NAMAX), NRSAV(NAMAX)
      CHARACTER  FNAMEA(NAMAX)*(*), NO_DATA*(*), NO_FILE*(*),
     +           STOREA(NAMAX)*(*), TITLEA(NAMAX)*(*)
C
C Locals
C
      INTEGER    I
      CHARACTER  BLANK2*2, STAR2*2
      PARAMETER (BLANK2 = '  ', STAR2 = '**')
C
C Matrix
C
      DO I = 1, NAMAX
         IF (NCSAV(I).GT.0 .AND. NRSAV(I).GT.0) THEN
            STOREA(I) = STAR2
         ELSE
            STOREA(I) = BLANK2
            NCSAV(I) = 0
            NRSAV(I) = 0
            FNAMEA(I) = NO_FILE
            TITLEA(I) = NO_DATA
         ENDIF
      ENDDO
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE STORE_MM (MAX_MM, NC1_MM, NC2_MM, NR1_MM, NR2_MM,
     +                     F1_MM, F2_MM, NO_DATA, NO_FILE, S_MM, T1_MM,
     +                     T2_MM)
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    MAX_MM
      INTEGER    NC1_MM(MAX_MM), NC2_MM(MAX_MM), NR1_MM(MAX_MM),
     +           NR2_MM(MAX_MM)
      CHARACTER  F1_MM(MAX_MM)*(*), F2_MM(MAX_MM)*(*), NO_DATA*(*),
     +           NO_FILE*(*),
     +           S_MM(MAX_MM)*(*), T1_MM(MAX_MM)*(*), T2_MM(MAX_MM)*(*)
C
C Locals
C
      INTEGER    I
      CHARACTER  BLANK5*5, STAR5*5
      PARAMETER (BLANK5 = '     ', STAR5 = '**.**')
C
C Two matrices
C
      DO I = 1, MAX_MM
         IF (NC1_MM(I).GT.0 .AND. NC2_MM(I).GT.0 .AND.
     +       NR1_MM(I).GT.0 .AND. NR2_MM(I).GT.0) THEN
C
C There are two matrices so accept the parameters and set the flag
C
            S_MM(I) = STAR5
         ELSE
C
C Otherwise suppress the parameters
C
            S_MM(I) = BLANK5
            NC1_MM(I) = 0
            NC2_MM(I) = 0
            NR1_MM(I) = 0
            NR2_MM(I) = 0
            F1_MM(I) = NO_FILE
            F2_MM(I) = NO_FILE
            T1_MM(I) = NO_DATA
            T2_MM(I) = NO_DATA
         ENDIF
      ENDDO
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE STORE_MV (MAX_MV, NB_MV, NC_MV, NR_MV,
     +                     F1_MV, F2_MV, NO_DATA, NO_FILE, S_MV, T1_MV,
     +                     T2_MV)
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    MAX_MV
      INTEGER    NB_MV(MAX_MV), NC_MV(MAX_MV), NR_MV(MAX_MV)
      CHARACTER  F1_MV(MAX_MV)*(*), F2_MV(MAX_MV)*(*), NO_DATA*(*),
     +           NO_FILE*(*), S_MV(MAX_MV)*(*), T1_MV(MAX_MV)*(*),
     +           T2_MV(MAX_MV)*(*)
C
C Locals
C
      INTEGER    I
      CHARACTER  BLANK4*4, STAR4*4
      PARAMETER (BLANK4 = '    ', STAR4 = '**.*')
C
C Matrix and vector
C
      DO I = 1, MAX_MV
         IF (NB_MV(I).GT.0 .AND. NC_MV(I).GT.0 .AND.
     +       NR_MV(I).GT.0 .AND. NB_MV(I).EQ.NR_MV(I) .AND.
     +       NR_MV(I).GE.NC_MV(I)) THEN
C
C The length of the vector (NB_MV) equals the number of rows (NR_MV)
C and the matrix is square or over-determined (NR_MV >= NC_MV) so
C accept the parameters and set the flag
C
            S_MV(I) = STAR4
         ELSE
C
C Otherwise suppress the parameters
C
            S_MV(I) = BLANK4
            NB_MV(I) = 0
            NC_MV(I) = 0
            NR_MV(I) = 0
            F1_MV(I) = NO_FILE
            F2_MV(I) = NO_FILE
            T1_MV(I) = NO_DATA
            T2_MV(I) = NO_DATA
         ENDIF
      ENDDO
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE STORE_XY (NXSAV, NXYMAX, NYSAV,
     +                     FNAMEX, FNAMEY, NO_DATA, NO_FILE,
     +                     PAIRXY, STOREXY, TITLEX, TITLEY)
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NXYMAX
      INTEGER    NXSAV(NXYMAX), NYSAV(NXYMAX)
      CHARACTER  FNAMEX(NXYMAX)*(*), FNAMEY(NXYMAX)*(*),
     +           NO_DATA*(*), NO_FILE*(*),
     +           PAIRXY(NXYMAX)*(*), STOREXY(NXYMAX)*(*),
     +           TITLEX(NXYMAX)*(*), TITLEY(NXYMAX)*(*)
C
C Locals
C
      INTEGER    I
      CHARACTER  BLANK3*3, STAR3*3
      PARAMETER (BLANK3 = '   ', STAR3 = '*.*')
C
C Pair of vectors
C
      DO I = 1, NXYMAX
         IF (NXSAV(I).GT.0 .AND. NYSAV(I).GT.0) THEN
            IF (NXSAV(I).EQ.NYSAV(I)) THEN
               PAIRXY(I) = STAR3
            ELSE
              PAIRXY(I) = BLANK3
            ENDIF
            STOREXY(I) = STAR3
         ELSE
            PAIRXY(I) = BLANK3
            STOREXY(I) = BLANK3
         ENDIF
         IF (NXSAV(I).LE.0) THEN
            NXSAV(I) = 0
            FNAMEX(I) = NO_FILE
            TITLEX(I) = NO_DATA
         ENDIF
         IF (NYSAV(I).LE.0) THEN
            NYSAV(I) = 0
            FNAMEY(I) = NO_FILE
            TITLEY(I) = NO_DATA
         ENDIF
      ENDDO
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE STORE_Z (NZMAX, NZSAV,
     +                    FNAMEZ, NO_DATA, NO_FILE, STOREZ, TITLEZ)
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NZMAX
      INTEGER    NZSAV(NZMAX)
      CHARACTER  FNAMEZ(NZMAX)*(*), NO_DATA*(*), NO_FILE*(*),
     +           STOREZ(NZMAX)*(*), TITLEZ(NZMAX)*(*)
C
C Locals
C
      INTEGER    I
      CHARACTER  BLANK1*1, STAR1*1
      PARAMETER (BLANK1 = ' ', STAR1 = '*')
C
C Single vector
C
      DO I = 1, NZMAX
         IF (NZSAV(I).GT.0) THEN
            STOREZ(I) = STAR1
         ELSE
            STOREZ(I) = BLANK1
            NZSAV(I) = 0
            FNAMEZ(I) = NO_FILE
            TITLEZ(I) = NO_DATA
         ENDIF
      ENDDO
      END
C
C
