C
C

C     INCLUDE 'C:\SIMFIT6\WORK\dllchk.for'
      PROGRAM MAIN
C
C PACKAGE : SIMFIT
C PROGRAM : SPLINE
C ACTION  : Evaluate and plot splines from NAG library
C VERSION : details from SIMVER/DLLCHK
C NAG     : E02BAF, E02BBF, E02BCF, E02BDF, E02BEF, G10ABF, G10ZAF 
C AUTHOR  : W. G. Bardsley, University of Manchester, UK, 13/12/92
C           15/09/1993 Modified SPL003 to calculate arc length and curvature
C           13/07/1994 DBOS version
C           22/02/1995 Salamanca Version
C           08/11/1997 win32 version
C           07/08/1998 added dllchk
C           13/09/1999 added calls to WINDOW
C           27/09/2005 new version
C           22/11/2007 edited for Version 6
C
      IMPLICIT   NONE
      INTEGER    NIN, NOUT, N2
      PARAMETER (NIN = 3, NOUT = 4, N2 = 2)
      INTEGER    ISEND, NDEC
      DOUBLE PRECISION XVER, YVER
      CHARACTER  FNAME2*1024, TITLE*80
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_spline.exe')
      CHARACTER  BLANK*1, PNAME*6
      PARAMETER (BLANK = ' ', PNAME = 'SPLINE')
      LOGICAL    ABORT, ACTION, FIRST, REPEET, SHOW
      EXTERNAL   FNAMES, RESFIL, SPL000
      EXTERNAL   ADVISE
      EXTERNAL   DLLCHK, WINDOW, SIMVER

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER, 
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

      FIRST = .TRUE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         CALL ADVISE (NDEC,
     +                DVER)
         IF (NDEC.EQ.N2) THEN
            IF (FIRST) THEN
               FIRST = .FALSE.
               CALL RESFIL (NOUT, 
     +                      FNAME2,
     +                      ABORT)
               IF (ABORT) THEN
                  FNAME2 = BLANK
               ELSE
                  WRITE (NOUT,100)
               ENDIF
            ENDIF
            CALL SPL000 (NIN, NOUT)
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
      CLOSE (UNIT = NOUT)
      IF (.NOT.ABORT) CALL FNAMES (N2,
     +                             FNAME2)

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C

  100 FORMAT (
     +/1X,'PACKAGE: SIMFIT'
     +/1X,'PROGRAM: SPLINE'
     +/1X,'ACTION : Use splines for derivatives, areas, smoothing.'
     +/1X,'AUTHOR : W.G.Bardsley, University of Manchester, U.K.')
      END
C
C--------------------------------------------------------------------------
C
      SUBROUTINE ADVISE (NDEC,
     +                   DVER)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (OUT) :: NDEC
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
C
C Locals
C
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 14, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_SPLINE
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help            ',
     +'Run the program',
     +'Quit  ...  Exit' /
      NDEC = 1
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (HEADER,100) DVER
         CALL TITLES (ICOLOR, NUMBLD, NDEC, NUMHDR, NUMOPT, NUMPOS,
     +                HEADER, OPTION)
         IF (NDEC.EQ.1) THEN
            CALL HELP_SPLINE ('spline')
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `SPLINE'
     +/'        `      '
     +/'Action  `Reads in a spline file (e.g. generated by programs'
     +/'        `COMPARE or CALCURVE) to estimate derivatives, area,'
     +/'        `arc length, curvature, etc. or plot a graph. Also'
     +/'        `fits splines for calibration and data smoothing.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C
