c
c
      subroutine sv_makfil
c
c action: sv version of makfil
c author: w.g.bardsley, University of Manchester, u.k., 10/10/2023
c         17/12/2023 added plotting, viewing, and re-editing   
c       
      implicit none
      integer i, l, m, n, numdec, numopt, numsta, numtxt
      parameter (numopt = 4, numsta = 2, numtxt = numopt + 1)
      integer numbld(numtxt)
      integer imin, isend, itype, ncols, nout, nrmax, nrows
      parameter (imin = 2, itype = 1, ncols = 2, nrmax = 100)
      double precision x(nrmax,ncols), x_data(nrmax), y_data(nrmax)
      character (len = 1024) fname
      character (len = 80  ) text
      character (len = 60  ) opts(numtxt), ptitle 
      character (len = 15  ) a, b, x_show15, xtitle, ytitle
      logical abort, repeet
      logical curve, fixcol, fixrow, label, order, weight
      parameter (curve = .true., fixcol = .true., fixrow = .true., 
     +           label = .true., order = .true., weight = .false.)
      data     numbld / 4, 1, 1, 1, 1 /
      external getim1, getnou, getstr, ofiles, putadv, x_show15
      external gks001, lstbox, w_editor
      ptitle = 'Plot of edited data'
      xtitle = 'x_data'
      ytitle = 'y_data'
      l = 1
      m = 5
      call putadv (
     +' You must now specify the filename for this new Simfit data')
      call getnou (nout)
      i = 1
      call ofiles (i, nout,
     +             fname,
     +             abort)  
      if (.not.abort) then 
         open (unit = nout, file = fname)
         text = ' X in column 1, Y in column 2, to fit or plot y = f(x)'
         call getstr (' Title for this Simfit data file', text)
         call getim1 (imin, nrows, nrmax,
     +                ' 2 =< Number of rows required =< 100')
         isend = 3
         call w_editor (isend, itype, ncols, nrmax, nrows,
     +                  x,
     +                  text,
     +                  curve, fixcol, fixrow, label, order, weight)
         write (nout,'(a)') text
         write (nout,'(2i6)') nrows, ncols 
         n = nrows
         do i = 1, n
            a = x_show15(x(i,1))
            b = x_show15(x(i,2))
            write (nout, '(a15,a1,a15)') a, ' ', b
           
         enddo 
         write (opts,100)
         numdec = 1
         repeet = .true.
         do while (repeet)
            call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                   opts)
            if (numdec.eq.1) then
               do i = 1, n 
                  x_data(i) = x(i,1)
                  y_data(i) = x(i,2) 
               enddo   
               call gks001 (l, m, n,
     +                      x_data, y_data,
     +                      ptitle, xtitle, ytitle)               
            elseif (numdec.eq.2) then
               isend = 1
               call w_editor (isend, itype, ncols, nrmax, nrows,
     +              x,
     +              text,
     +              curve, fixcol, fixrow, label, order, weight)   
            elseif (numdec.eq.3) then
               isend = 2
               call w_editor (isend, itype, ncols, nrmax, nrows,
     +                  x,
     +                  text,
     +                  curve, fixcol, fixrow, label, order, weight)   
            else
               repeet = .false.
            endif
         enddo
         close (unit = nout)
         call putadv ('File requested has now been saved')
      else
         call putadv ('File cannot be opened')    
      endif 
  100 format ('Options to plot/view/edit'
     +/'Plot current data'
     +/'View current data'
     +/'Edit current data'
     +/'Save current data')
      end
c
c----------------------------------------------------------------------
c
      subroutine sv_makmat
c
c action: sv version of makmat
c author: w.g.bardsley, University of Manchester, u.k., 10/10/2023
c               
      implicit none
      integer i, j, k, nout
      integer imin, isend, itype, ncmax, ncols, nrmax, nrows
      parameter (isend = 3, itype = 1, ncmax = 10, nrmax = 100)
      double precision x(nrmax,ncmax)
      character (len = 1024) fname
      character (len = 300 ) line 
      character (len = 80  ) text
      character (len = 15  ) a(10), x_show15
      logical abort
      logical curve, fixcol, fixrow, label, order, weight
      parameter (curve = .false., fixcol = .true., fixrow = .true., 
     +           label = .true., order = .false., weight = .false.)
      external getim1, getnou, getstr, ofiles, putadv, x_show15
      external w_editor
      call putadv (
     +' You must now specify the filename for this new Simfit data')
      call getnou (nout)
      i = 1
      call ofiles (i, nout,
     +             fname,
     +             abort)  
      if (.not.abort) then 
         open (nout, file = fname)
         text = ' A(i,j) matrix values for statistics, etc.'
         call getstr (' Title for this Simfit data file', text)
         imin = 2
         call getim1 (imin, nrows, nrmax,
     +                ' 2 =< Number of rows required =< 100')
         imin = 1
         call getim1 (imin, ncols, ncmax,
     +                ' 1 =< Number of columns required =< 10')
         call w_editor (isend, itype, ncols, nrmax, nrows,
     +                  x,
     +                  text,
     +                  curve, fixcol, fixrow, label, order, weight)
         write (nout,'(a)') text
         write (nout,'(2i6)') nrows, ncols 
         do i = 1, nrows
            do j = 1, ncols
              a(j) = x_show15(x(i,j))
            enddo
            write (line, '(10(a15,a1))') (a(k),' ', k = 1, ncols)
            write (nout,'(a)') line
         enddo   
         close (unit = nout)
         call putadv ('File requested has now been saved')
      else
         call putadv ('File cannot be opened')    
      endif   
      end 
c
c ------------------------------------------------------------------------------
c
      subroutine sv_editmt
c
c action: sv version of editmt
c author: w.g.bardsley, University of Manchester, u.k., 10/10/2023
c note  : input data read on fname1, unit = nin, output data written to fname, unit = nout
c                
      implicit none
      integer i, j, k, nin, nout
      integer n1, n3
      parameter (n1 = 1, n3 = 3)
      integer isend, itype, ncmax, ncols, nrmax, nrows
      parameter (isend = 2, itype = 1, ncmax = 20, nrmax = 200)
      double precision x(nrmax,ncmax)
      character (len = 1024) fname, fname1
      character (len = 300 ) line 
      character (len = 80  ) text
      character (len = 15  ) a(20), x_show15
      logical abort
      logical curve, fixcol, fixrow, label, order, weight
      parameter (curve = .false., fixcol = .true., fixrow = .true., 
     +           label = .true., order = .false., weight = .false.)
      external getnou, getstr, ofiles, putadv, x_show15
      external w_editor, isitmf
c
c open the input data file on unit nout
c      
      call putadv (
     +'Now specify the source file containing the data to be edited')
      call getnou (nin)
      call ofiles (n3, nin,
     +             fname1,
     +             abort)
      close (unit = nin) ! Note: isitmf opens fname1 to check dimensions
      if (.not.abort) then
         call isitmf (ncols, nrows,
     +                fname1)
         if (ncols.lt.1 .or. nrows.lt.1) then
            abort = .true. 
         elseif (ncols.gt.ncmax .or. nrows.gt.nrmax) then
            call putadv (
     +'Maximum size allowed is 200 rows and 20 columns')
            abort = .true.
         else
c
c read data
c           
            open (unit = nin, file = fname1)
            read (nin,'(a)') text
            read (nin,*) nrows, ncols
            do i = 1, nrows
              read (nin,*) (x(i,j), j = 1, ncols)
            enddo 
            close (unit = nin)    
         endif  
      endif   
      if (abort) then
         close (unit = nin)
         call putadv ('This is not a Simfit data file')   
      endif                 
      if (.not.abort) then
c
c open the output file
c        
        call putadv (
     +'Now specify the target file to receive the edited data')
         call getnou (nout)
         call ofiles (n1, nout,
     +                fname,
     +                abort)
      endif
c
c edit the matrix
c 
      if (.not.abort) then   
         call w_editor (isend, itype, ncols, nrmax, nrows,
     +                  x,
     +                  text,
     +                  curve, fixcol, fixrow, label, order, weight)
c
c save the edited data
c     
         text = 'Title for edited data'
         call getstr (text, 'Data matrix after editing')
         write (nout,'(a)') text
         write (nout,'(2i6)') nrows, ncols 
         do i = 1, nrows
            do j = 1, ncols
              a(j) = x_show15(x(i,j))
            enddo
            write (line, '(20(a15,a1))') (a(k),' ', k = 1, ncols)
            write (nout,'(a)') line
         enddo   
         close (unit = nout)
         call putadv ('File requested has now been saved')
      else
         call putadv ('File cannot be opened')
         close (unit = nout)    
      endif
c
c make sure units are closed
c         
      close (unit = nin)
      close (unit = nout)
      end 
c
c
c
c
      subroutine sv_viewer (isend)	
c
c action: simplified test file viewer
c author: w.g.bardsley, university of manchester, u,k,  14/10/2023     
c      
      implicit none
      integer, intent (in) :: isend 
      integer jsend, l
      parameter (jsend = 2)
      character (len = 1024) fname, path
      character (len = 20  ) pattern
      character (len = 1   ) blank, bslash
      parameter (blank = ' ', bslash = '\') 
      logical    first
      data  first / .true. /
      data  fname, path, pattern / blank, blank, blank / 
      external x_demdir, w_viewer
      if (first) then
         first = .false.
         call x_demdir (l,
     +                  path)
         if (path(l:l) .ne. bslash) then
            l = l + 1
            path(l:l) = bslash
         endif   
      endif
      if (isend.eq.1) then
         pattern = 'matrix.tf?'
      elseif (isend.eq.2) then
         pattern = 'simfig?.tfl'
      elseif (isend.eq.3) then  
         pattern = 'usermod1_e.tf?'
      else
         return   
      endif       
      call w_viewer (jsend,
     +               fname, path, pattern)
      end 
c
c            