c
c
      SUBROUTINE SV_SIMSTAT
      
      IMPLICIT   NONE
C
C Parameters used to set array dimensions, etc.
C
      INTEGER    MAX_MM, MAX_MV, NAMAX, NBMAX, NIN, NOUT, NXYMAX, NZMAX
      PARAMETER (MAX_MM =  5, !no. of matrix-matrix files stored....(for m_mattwo)
     +           MAX_MV =  6, !no. of matrix-vector files stored....(for m_matvec)
     +            NAMAX = 40, !no. of matrix files stored...........(for m_matone)
     +            NBMAX = 20, !no. of multivariate matrices stored..(for m_mvstat)
     +              NIN =  3, !unconnected unit for data input
     +             NOUT =  4, !pre-connected unit for results file
     +           NXYMAX = 10, !no. of vector pairs stored...........(for m_vectwo)
     +            NZMAX = 18) !no. of vector files stored...........(for m_vecone)
C
C Arrays holding dimensions and filenames/titles for stored data
C
      INTEGER    NC1_MM(MAX_MM), NC2_MM(MAX_MM),
     +           NR1_MM(MAX_MM), NR2_MM(MAX_MM)
      INTEGER    NB_MV(MAX_MV),  NC_MV(MAX_MV), NR_MV(MAX_MV)
      INTEGER    NCSAVA(NAMAX),  NCSAVB(NBMAX),
     +           NRSAVA(NAMAX),  NRSAVB(NBMAX)
      INTEGER    NXSAV(NXYMAX),  NYSAV(NXYMAX), NZSAV(NZMAX)
      CHARACTER  F1_MM(MAX_MM)*1024,  F1_MV(MAX_MV)*1024,
     +           F2_MM(MAX_MM)*1024,  F2_MV(MAX_MV)*1024,
     +           S_MM(MAX_MM)*5,     S_MV(MAX_MV)*4,
     +           T1_MM(MAX_MM)*80,   T1_MV(MAX_MV)*80,
     +           T2_MM(MAX_MM)*80,   T2_MV(MAX_MV)*80
      CHARACTER  FNAMEA(NAMAX)*1024,  FNAMEB(NBMAX)*1024,
     +           FNAMEX(NXYMAX)*1024, FNAMEY(NXYMAX)*1024,
     +           FNAMEZ(NZMAX)*1024,
     +           PAIRXY(NXYMAX)*3,
     +           STOREA(NAMAX)*2,    STOREB(NBMAX)*2,
     +           STOREXY(NXYMAX)*3,  STOREZ(NZMAX)*1,
     +           TITLEA(NAMAX)*80,   TITLEB(NBMAX)*80,
     +           TITLEX(NXYMAX)*80,  TITLEY(NXYMAX)*80,
     +           TITLEZ(NZMAX)*80
C
C Parameters that must not be changed, edited in any way, or translated
C
      INTEGER    N0, N1, N2, N10
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N10 = 10)
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
c
c Parameters that can be translated if required
c
      CHARACTER  NO_DATA*30, NO_FILE*30
      PARAMETER (NO_DATA = 'No data', NO_FILE = 'No file')
C
C Scalars
C
      INTEGER    I, ISEND
      CHARACTER  LOGFIL*1024, TITLE*80
      LOGICAL    ABORT, ACTION, FIRST, REPEET
C
C Externals
C
      EXTERNAL   HELP_SIMSTAT
      EXTERNAL   RESFIL, FNAMES, REVPRO
      EXTERNAL   SV_DECIDE, SV_SUB001, SV_SUB002, SV_SUB003,
     +           SV_SUB004, SV_SUB005, SV_SUB006,
     +           SV_SUB008, SV_SUB009, SV_SUB010
      EXTERNAL   WINDOW  
      EXTERNAL   SIMSTAT_REQUIRED
C
C Saved variables
C
      SAVE       FIRST

      ABORT = .FALSE.

C
C initialise the variables
C
      LOGFIL = BLANK
      TITLE = NO_DATA
      DO I = N1, MAX_MM
         NC1_MM(I) = N0
         NC2_MM(I) = N0
         NR1_MM(I) = N0
         NR2_MM(I) = N0
         F1_MM(I) = NO_FILE
         F2_MM(I) = NO_FILE
         S_MM(I) = BLANK
         T1_MM(I) = NO_DATA
         T2_MM(I) = NO_DATA
      ENDDO
      DO I = N1, MAX_MV
         NB_MV(I) = N0
         NC_MV(I) = N0
         NR_MV(I) = N0
         F1_MV(I) = NO_FILE
         F2_MV(I) = NO_FILE
         S_MV(I) = BLANK
         T1_MV(I) = NO_DATA
         T2_MV(I) = NO_DATA
      ENDDO
      DO I = N1, NAMAX
         NCSAVA(I) = N0
         NRSAVA(I) = N0
         FNAMEA(I) = NO_FILE
         STOREA(I) = BLANK
         TITLEA(I) = NO_DATA
      ENDDO
      DO I = N1, NBMAX
         NCSAVB(I) = N0
         NRSAVB(I) = N0
         FNAMEB(I) = NO_FILE
         STOREB(I) = BLANK
         TITLEB(I) = NO_DATA
      ENDDO
      DO I = N1, NXYMAX
         NXSAV(I) = N0
         NYSAV(I) = N0
         PAIRXY(I) = BLANK
         STOREXY(I) = BLANK
      ENDDO
      DO I = N1, NZMAX
         NZSAV(I) = N0
         FNAMEZ(I) = NO_FILE
         STOREZ(I) = BLANK
         TITLEZ(I) = NO_DATA
      ENDDO
      ABORT = .TRUE.
      FIRST = .TRUE.
      REPEET = .TRUE.
C
C The main loop
C =============
C
      DO WHILE (REPEET)
C
C Call the main menu 
C
       
         CALL SV_DECIDE (ISEND)
     
         IF (FIRST .AND. ISEND.GE.N0 .AND. ISEND.LE.N10) THEN
C
C Open the results file only on the first time round
C
            FIRST = .FALSE.
            CALL RESFIL (NOUT,
     +                   LOGFIL,
     +                   ABORT)
            WRITE (NOUT,100)
         ENDIF
         CALL SIMSTAT_REQUIRED (ISEND)
         IF (ISEND.EQ.1) THEN
C
C ISEND = 1: Explore
C ==========
C
            CALL SV_SUB001 (NAMAX, NCSAVA, NIN, NOUT, NRSAVA,
     +                      NXSAV, NXYMAX, NYSAV, NZMAX, NZSAV,
     +                      FNAMEA, FNAMEX, FNAMEY, FNAMEZ,
     +                      NO_DATA, NO_FILE, PAIRXY,
     +                      STOREA, STOREXY, STOREZ,
     +                      TITLEA, TITLEX, TITLEY, TITLEZ)
         ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: Tests
C ==========
C
            CALL SV_SUB002 (NAMAX, NCSAVA, NIN, NOUT, NRSAVA, NXSAV,
     +                      NXYMAX, NYSAV, NZMAX, NZSAV,
     +                      FNAMEA, FNAMEX, FNAMEY, FNAMEZ,
     +                      NO_DATA, NO_FILE, PAIRXY,
     +                      STOREA, STOREXY, STOREZ,
     +                      TITLEA, TITLEX, TITLEY, TITLEZ)
         ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3: ANOVA
C ==========
C
            CALL SV_SUB003 (NIN, NOUT)
         ELSEIF (ISEND.EQ.4) THEN
C
C ISEND = 4: ANOVAP
C ==========
C
            CALL SV_SUB004 (NIN, NOUT)
         ELSEIF (ISEND.EQ.5) THEN
C
C ISEND = 5: Multivariate
C ==========
C
            CALL SV_SUB005 (MAX_MM, NBMAX, NCSAVB, NC1_MM, NC2_MM, NIN,
     +                      NOUT, NRSAVB, NR1_MM, NR2_MM, NZMAX, NZSAV,
     +                      FNAMEB, FNAMEZ, F1_MM, F2_MM,
     +                      NO_DATA, NO_FILE, STOREB, STOREZ, S_MM,
     +                      TITLEB, TITLEZ, T1_MM, T2_MM)
         ELSEIF (ISEND.EQ.6) THEN
C
C ISEND = 6: Regression
C ==========
C
            CALL SV_SUB006 (NAMAX, NCSAVA, NIN, NOUT, NRSAVA,
     +                      FNAMEA, NO_DATA, NO_FILE, STOREA, TITLEA)
C         ELSEIF (ISEND.EQ.7) THEN
C
C ISEND = 7: Generalized linear models
C ==========
C
C            CALL SUB007 (NIN, NOUT)
        ELSEIF (ISEND.EQ.7) THEN
C
C ISEND = 7: Time series
C ==========
C
            CALL SV_SUB008 (NAMAX, NCSAVA, NIN, NOUT, NRSAVA, NZMAX,
     +                      NZSAV,
     +                      FNAMEA, FNAMEZ, NO_DATA, NO_FILE, STOREA,
     +                      STOREZ, TITLEA, TITLEZ)
         ELSEIF (ISEND.EQ.8) THEN
C
C ISEND = 8: Statistical calculations
C ==========
C
            CALL SV_SUB009 (NAMAX, NCSAVA, NIN, NOUT, NRSAVA, NXSAV, 
     +                      NXYMAX, NYSAV, NZMAX, NZSAV,
     +                      FNAMEA, FNAMEX, FNAMEY, FNAMEZ, NO_DATA,
     +                      NO_FILE, PAIRXY, STOREA, STOREXY, STOREZ,
     +                      TITLEA, TITLEX, TITLEY, TITLEZ)
         ELSEIF (ISEND.EQ.9) THEN
C
C ISEND = 9: Numerical analysis
C ===========
C
            CALL SV_SUB010 (MAX_MM, MAX_MV, NAMAX, NB_MV, NC_MV, NCSAVA,
     +                      NC1_MM, NC2_MM, NIN, NOUT, NRSAVA, NR_MV,
     +                      NR1_MM, NR2_MM, NZMAX, NZSAV,
     +                      F1_MM, F1_MV, F2_MM, F2_MV, FNAMEA, FNAMEZ,
     +                      NO_DATA, NO_FILE,
     +                      S_MM, S_MV, STOREA, STOREZ, TITLEA, TITLEZ,
     +                      T1_MM, T1_MV, T2_MM, T2_MV)
         ELSEIF (ISEND.EQ.10) THEN
C
C ISEND = 10: Advice
C ==========
C
            CALL HELP_SIMSTAT ('simstat')
         ELSEIF (ISEND.EQ.11) THEN
C
C ISEND = 11: Review progress so far
C ===========
C
            CALL REVPRO (NOUT)
         ELSEIF (ISEND.EQ.12) THEN
C
C ISEND = 12: Exit from program SIMSTAT
C ===========
C
            REPEET = .FALSE.
         ENDIF
C
C Jump out of the loop if JUMP = .TRUE.
C
      ENDDO
C
C Close the results file and inform the user
C
      CLOSE (UNIT = NOUT)
      ISEND = N2
      CALL FNAMES (ISEND,
     +             LOGFIL)

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C
      CLOSE (UNIT = NOUT)
C
C Format statement
C
  100 FORMAT (
     +/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : SV_SIMSTAT'
     +/1X,'ACTION  : stats: explore/test/calculate/regress/time series'
     +/1X,'AUTHOR  : W.G.Bardsley, University of Manchester, U.K.')
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE SV_DECIDE (ISEND)
C
C Choose details required
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    ISEND
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 12)
      INTEGER    NSTART, NTEXT
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      CHARACTER  TEXT(30)*100
      LOGICAL    FIXED, FULL, HIGH
      PARAMETER (FIXED = .FALSE., FULL = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /

C
C show the subsidiary menu
C
      WRITE (TEXT,100)
      NSTART = 3
      NTEXT = NSTART + NUMOPT - 1
      NUMDEC = NUMOPT - 2
      NUMBLD(1) = 1
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             FIXED, FULL, HIGH)
      ISEND = NUMDEC
C
C Format statements
C      
  100 FORMAT (
     + 'The sv_simstat statistical options'
     +/
     +/'Data exploration'
     +/'Standard statistical tests'
     +/'Analysis of variance'
     +/'Analysis of proportions'
     +/'Multivariate statistics'
     +/'Regression'
C     +/'Generalized linear models'
     +/'Smoothing, time-series and survival analysis'
     +/'Statistical calculations'
     +/'Numerical analysis'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit program sv_simstat')
      END
C
C
c      subroutine simstat_required (isend)
c
c action: set mask for the main simstat menu demo files
c author: w.g.bardsley, university of manchester, u.k., 16/08/2020
c      
c      implicit none
c
c argument
c      
c      integer, intent (in) :: isend
c
c locals
c      
c      integer i
c      integer nmask
c      parameter (nmask = 10)
c      integer mask(nmask)
c      logical store
c      parameter (store = .true.)
c      external query_files_required
c
c check isend
c      
c      if (isend.lt.1 .or. isend.gt.10) then
c         do i = 1, nmask
c            mask(i) = 1
c         enddo
c      else   
c         do i = 1, nmask
c            if (i.eq.isend) then
c               mask(i) = 1
c            else   
c               mask(i) = 0
c            endif   
c         enddo    
c      endif
c      call query_files_required (mask, nmask,
c     +                           store)
c      end
c
c 
C**********************************************************************      
C
