
C
C SIMSTAT1.INS: Include file for SIMSTAT
C =============
C
C SUB001
C Date of this version 12/03/2006
C
C-----------------------------------------------------------------------
C
      SUBROUTINE SV_SUB001 (NAMAX, NCSAV, NIN, NOUT, NRSAV, NXSAV,
     +                      NXYMAX, NYSAV, NZMAX, NZSAV,
     +                      FNAMEA, FNAMEX, FNAMEY, FNAMEZ, NO_DATA,
     +                      NO_FILE, PAIRXY, STOREA, STOREXY, STOREZ,
     +                      TITLEA, TITLEX, TITLEY, TITLEZ)
C
C Data exploration
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NAMAX, NXYMAX, NZMAX
      INTEGER    NCSAV(NAMAX), NIN, NOUT, NRSAV(NAMAX),
     +           NXSAV(NXYMAX), NYSAV(NXYMAX),  NZSAV(NZMAX)
      CHARACTER  FNAMEA(NAMAX)*(*), FNAMEX(NXYMAX)*(*),
     +           FNAMEY(NXYMAX)*(*), FNAMEZ(NZMAX)*(*),
     +           NO_DATA*(*), NO_FILE*(*),
     +           PAIRXY(NXYMAX)*(*),
     +           STOREA(NAMAX)*(*), STOREXY(NXYMAX)*(*),
     +           STOREZ(NZMAX)*(*),
     +           TITLEA(NAMAX)*(*), TITLEX(NXYMAX)*(*),
     +           TITLEY(NXYMAX)*(*), TITLEZ(NZMAX)*(*)
C
C Locals
C
      INTEGER    IX, IY, NUMDEC, NUMOPT, NTEXT
      PARAMETER (IX = 4, IY = 4, NUMOPT = 9, NTEXT = NUMOPT + 1)
      INTEGER    ISEND
      CHARACTER  TEXT(NTEXT)*100
      LOGICAL    TITLES
      PARAMETER (TITLES = .TRUE.)
      LOGICAL    REPEET
      EXTERNAL   LVIEW2, REVPRO
      EXTERNAL   M_VECONE, M_VECTWO, M_MATONE, M_VECTST
      EXTERNAL   HELP_SIMSTAT
      EXTERNAL   STORE_A, STORE_XY, STORE_Z
      EXTERNAL   MVPLOT  
      REPEET = .TRUE.
      DO WHILE (REPEET)
         CLOSE (UNIT = NIN)
         CALL STORE_A (NAMAX, NCSAV, NRSAV,
     +                 FNAMEA, NO_DATA, NO_FILE, STOREA, TITLEA)
         CALL STORE_XY (NXSAV, NXYMAX, NYSAV,
     +                  FNAMEX, FNAMEY, NO_DATA, NO_FILE, PAIRXY,
     +                  STOREXY, TITLEX, TITLEY)
         CALL STORE_Z (NZMAX, NZSAV,
     +                 FNAMEZ, NO_DATA, NO_FILE, STOREZ, TITLEZ)
C         WRITE (TEXT,100) STOREZ(1), STOREA(6), STOREA(7), STOREA(34), 
C     +                    STOREA(35), STOREZ(6), STOREXY(7)

         WRITE (TEXT,100) STOREZ(1), STOREA(6),  
     +                    STOREZ(6), STOREXY(7)
         NUMDEC = NUMOPT - 1
         CALL LVIEW2 (IX, IY, NUMDEC, NUMOPT, 
     +                TEXT, TITLES)
         IF (NUMDEC.EQ.1) THEN
C
C Exhaustive analysis of a vector
C
            ISEND = 1
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Exhaustive analysis of a matrix
C
            ISEND = 6
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
C         ELSEIF (NUMDEC.EQ.3) THEN
C
C Exhaustive analysis of a multivariate normal matrix
C
C            ISEND = 7
C            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
C     +                     FNAMEA(ISEND), TITLEA(ISEND))
C         ELSEIF (NUMDEC.EQ.4) THEN
C
C Groups across rows t tests
C
C            ISEND = 34
C            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
C     +                     FNAMEA(ISEND), TITLEA(ISEND))  
C         ELSEIF (NUMDEC.EQ.5) THEN
C
C Groups across rows nonparameteric tests
C
C            ISEND = 35
C            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
C     +                     FNAMEA(ISEND), TITLEA(ISEND))     
         ELSEIF (NUMDEC.EQ.3) THEN
C
C All possible comparisons
C
            CALL M_VECTST (NIN, NOUT)
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Robust analysis of 1 sample
C
            ISEND = 6
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Robust analysis of 2 samples

C
            ISEND = 7
            CALL M_VECTWO (ISEND, NIN, NOUT, NXSAV(ISEND),
     +                     NYSAV(ISEND),
     +                     FNAMEX(ISEND), FNAMEY(ISEND), TITLEX(ISEND),
     +                     TITLEY(ISEND))
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Box-whisker/scatter/percentiles/error-bar plots
C         
            CALL MVPLOT
C         ELSEIF (NUMDEC.EQ.10) THEN
C
C Overlay pdf or cdf on sample
C         
C            ISEND = 18
C            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
C     +                     FNAMEZ(ISEND), TITLEZ(ISEND))    
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C
C Review progress
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Help
C
            CALL HELP_SIMSTAT ('simstat')
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF
         CLOSE (UNIT = NIN)
      ENDDO
  100 FORMAT (
     + 'The SV_SIMSTAT data exploration options`Data format'
     +/'Exhaustive-analysis: arbitrary vector  `1 sample',1X,A
     +/'Exhaustive-analysis: arbitrary matrix  `n samples/1 matrix',1X,A
C     +/'Exhaustive-analysis: MV-normal matrix  `n samples/1 matrix',1X,A
C     +/'All groups across rows t-tests         `n samples/1 matrix',1X,A
C     +/'All groups across rows MW_U/KS_D tests `n samples/1 matrix',1X,A
     +/'All possible pairwise MW_U/KS_D/t tests`n samples'
     +/'Robust analysis: one sample            `1 sample',1X,A
     +/'Robust analysis: two samples           `2 samples',1X,A
     +/'Box-whisker/scatter/error-bar plots    `n samples/1 matrix'
C     +/'Compare data with known distributions  `1 sample'
     +/'Results                                `...'
     +/'Help                                   `...'
     +/'Quit .. Exit data exploration options  `...')
      END
C
C-----------------------------------------------------------------------
C
