
C
C SIMSTAT2.FOR: Include file for SIMSTAT
C =============
C
C SUB002
C Date of this version 26/02/2009
C
C-----------------------------------------------------------------------
C
      SUBROUTINE SV_SUB002 (NAMAX, NCSAV, NIN, NOUT, NRSAV, NXSAV,
     +                      NXYMAX, NYSAV, NZMAX, NZSAV,
     +                      FNAMEA, FNAMEX, FNAMEY, FNAMEZ, NO_DATA,
     +                      NO_FILE, PAIRXY, STOREA, STOREXY, STOREZ,
     +                      TITLEA, TITLEX, TITLEY, TITLEZ)
C
C Standard tests
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NAMAX, NXYMAX, NZMAX
      INTEGER,             INTENT (IN)    :: NIN, NOUT
      INTEGER,             INTENT (INOUT) :: NCSAV(NAMAX),
     +                                       NRSAV(NAMAX),
     +                                       NXSAV(NXYMAX), 
     +                                       NYSAV(NXYMAX), 
     +                                       NZSAV(NZMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAMEA(NAMAX),
     +                                       FNAMEX(NXYMAX),
     +                                       FNAMEY(NXYMAX), 
     +                                       FNAMEZ(NZMAX),
     +                                       NO_DATA, NO_FILE, 
     +                                       PAIRXY(NXYMAX),
     +                                       STOREA(NAMAX),
     +                                       STOREXY(NXYMAX),
     +                                       STOREZ(NZMAX),
     +                                       TITLEA(NAMAX),
     +                                       TITLEX(NXYMAX), 
     +                                       TITLEY(NXYMAX),
     +                                       TITLEZ(NZMAX)
C
C Locals
C
      INTEGER    IX, IY, NUMDEC, NUMOPT, NTEXT
      PARAMETER (IX = 4, IY = 4, NUMOPT = 15, NTEXT = NUMOPT + 1)
C     INTEGER    JSEND, N1
C     PARAMETER (JSEND = 2, N1 = 1)
C      INTEGER    I, ISEND, NX, NY, NZ
      INTEGER    I, ISEND
C      DOUBLE PRECISION RTOL, X02AMF$, X(N1), Y(N1), Z(N1)
      CHARACTER  TEXT(NTEXT)*100
C      CHARACTER  XTITLE*1, YTITLE*1, ZTITLE*1
      LOGICAL    TITLES
      PARAMETER (TITLES = .TRUE.)
      LOGICAL    REPEET
C      EXTERNAL   LVIEW2, BINOMT, REVPRO, BINOMP, RUNSIN, TESTFS
      EXTERNAL   LVIEW2, REVPRO
      EXTERNAL   M_VECONE, M_VECTWO, M_MATONE, VAREQ0
      EXTERNAL   HELP_SIMSTAT
C      EXTERNAL   X02AMF$
      EXTERNAL   STORE_A, STORE_XY, STORE_Z
      REPEET = .TRUE.
      DO WHILE (REPEET)
         CLOSE (UNIT = NIN)
         CALL STORE_A (NAMAX, NCSAV, NRSAV,
     +                 FNAMEA, NO_DATA, NO_FILE, STOREA, TITLEA)
         CALL STORE_XY (NXSAV, NXYMAX, NYSAV,
     +                  FNAMEX, FNAMEY, NO_DATA, NO_FILE, PAIRXY,
     +                  STOREXY, TITLEX, TITLEY)
         CALL STORE_Z (NZMAX, NZSAV,
     +                 FNAMEZ, NO_DATA, NO_FILE, STOREZ, TITLEZ)
C         WRITE (TEXT,100) (STOREZ(I), I = 2, 5),
C     +                     STOREXY(2), PAIRXY(3), STOREXY(4),
C     +                     STOREXY(5), PAIRXY(6), PAIRXY(10),
C     +                    (STOREA(I), I = 8, 10)
         WRITE (TEXT,100) (STOREZ(I), I = 2, 5),
     +                     STOREXY(2), PAIRXY(3), STOREXY(4),
     +                     STOREXY(5), PAIRXY(6), PAIRXY(10),
     +                     STOREA(10)
         NUMDEC = NUMOPT - 1
         CALL LVIEW2 (IX, IY, NUMDEC, NUMOPT,
     +                TEXT, TITLES)
         IF (NUMDEC.EQ.1) THEN
C
C 1-sample t test
C
            ISEND = 2
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         ELSEIF (NUMDEC.EQ.2) THEN
C
C 1-sample Kolmogorov-smirnov test
C
            ISEND = 3
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         ELSEIF (NUMDEC.EQ.3) THEN
C
C 1-sample normal distribution test
C
            ISEND = 4
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         ELSEIF (NUMDEC.EQ.4) THEN
C
C 1-sample poisson test
C
            ISEND = 5
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         ELSEIF (NUMDEC.EQ.5) THEN
C
C 2-sample unpaired t test
C
            ISEND = 2
            CALL M_VECTWO (ISEND, NIN, NOUT, NXSAV(ISEND), NYSAV(ISEND),
     +                     FNAMEX(ISEND), FNAMEY(ISEND), TITLEX(ISEND),
     +                     TITLEY(ISEND))
         ELSEIF (NUMDEC.EQ.6) THEN
C
C 2-sample paired t test
C
            ISEND = 3
            CALL M_VECTWO (ISEND, NIN, NOUT, NXSAV(ISEND), NYSAV(ISEND),
     +                     FNAMEX(ISEND), FNAMEY(ISEND), TITLEX(ISEND),
     +                     TITLEY(ISEND))
         ELSEIF (NUMDEC.EQ.7) THEN
C
C 2-sample Kolmogorov-Smirnov test
C
            ISEND = 4
            CALL M_VECTWO (ISEND, NIN, NOUT, NXSAV(ISEND), NYSAV(ISEND),
     +                     FNAMEX(ISEND), FNAMEY(ISEND), TITLEX(ISEND),
     +                     TITLEY(ISEND))
         ELSEIF (NUMDEC.EQ.8) THEN
C
C 2-sample Mann-Whitney U test
C
            ISEND = 5
            CALL M_VECTWO (ISEND, NIN, NOUT, NXSAV(ISEND), NYSAV(ISEND),
     +                     FNAMEX(ISEND), FNAMEY(ISEND), TITLEX(ISEND),
     +                     TITLEY(ISEND))
         ELSEIF (NUMDEC.EQ.9) THEN
C
C 2-sample Wilcoxon paired-sample signed-rank test
C
            ISEND = 6
            CALL M_VECTWO (ISEND, NIN, NOUT, NXSAV(ISEND), NYSAV(ISEND),
     +                     FNAMEX(ISEND), FNAMEY(ISEND), TITLEX(ISEND),
     +                     TITLEY(ISEND))
        ELSEIF (NUMDEC.EQ.10) THEN
C
C Observed/Expected frequencies
C
            ISEND = 10
            CALL M_VECTWO (ISEND, NIN, NOUT, NXSAV(ISEND), NYSAV(ISEND),
     +                     FNAMEX(ISEND), FNAMEY(ISEND), TITLEX(ISEND),
     +                     TITLEY(ISEND))     
         ELSEIF (NUMDEC.EQ.11) THEN
C
C Contingency table analysis
C
            ISEND = 8
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.12) THEN
C
C Variance homogeneity
C            
            CALL VAREQ0 (NIN, NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Help
C
            CALL HELP_SIMSTAT ('simstat')
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF
         CLOSE (UNIT = NIN)
      ENDDO
  100 FORMAT (
     + 'The SIMSTAT standard tests options    `Data format'
     +/'1-sample t test                       `1 vector',1X,A
     +/'1-sample Kolmogorov-Smirnov test      `1 vector',1X,A
     +/'1-sample normal distribution test     `1 vector',1X,A
     +/'1-sample Poisson distribution test    `1 vector',1X,A
     +/'2-sample unpaired t test              `2 vectors',1X,A
     +/'2-sample paired t test                `paired samples',1X,A
     +/'2-sample Kolmogorov-Smirnov test      `2 vectors',1X,A
     +/'2-sample Wilcoxon-Mann-Whitney-U test `2 vectors',1X,A
     +/'2-sample Wilcoxon signed-rank test    `paired samples',1X,A
     +/'Chi-sq. Observed/Expected frequencies `paired samples',1X,A
     +/'Chi-sq./Fisher/GLM contingency table  `1 matrix',1X,A
c     +/'McNemar test on paired frequencies    `1 matrix (square)',1X,A
c     +/'Cochran Q test (on 0/1 integer matrix)`1 matrix',1X,A
c     +/'Binomial test: K successes in N trials`3 numbers'
c     +/'Sign test: known number of +/- signs  `2 numbers'
c     +/'Runs test: known number of +/- runs   `3 numbers'
c     +/'F test for excess variance: two WSSQ  `5 numbers'
     +/'Variance homogeneity tests            `n vectors/n by m matrix'
     +/'Results                               `...'
     +/'Help                                  `...'
     +/'Quit ... Exit standard tests options  `...')
      END
C
C-----------------------------------------------------------------------
C
