
C
C SIMSTAT5.INS: Include file for SIMSTAT
C =============
C
C SUB005
C 01/08/2006 added arguments for call to M_MVSTAT and M_MATTWO for rotations
C 31/07/2012 Procrustes rotation does not now require NAG so NAG(1) = BLANK5
C 05/01/2013 Orthomax rotation   does not now require NAG so NAG(2) = BLANK5
C
C-----------------------------------------------------------------------
C
      SUBROUTINE SV_SUB005 (MAX_MM, NAMAX, NCSAV, NC1_MM, NC2_MM, NIN,
     +                      NOUT, NRSAV, NR1_MM, NR2_MM, NZMAX, NZSAV,
     +                      FNAMEA, FNAMEZ, F1_MM, F2_MM, 
     +                      NO_DATA, NO_FILE, STOREA, STOREZ, S_MM,
     +                      TITLEA, TITLEZ, T1_MM, T2_MM)
C
C Multivariate: correlation, cluster analysis, principal components, MANOVA
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    MAX_MM, NAMAX, NZMAX
      INTEGER    NCSAV(NAMAX), NC1_MM(MAX_MM), NC2_MM(MAX_MM), NIN,
     +           NOUT, NRSAV(NAMAX), NR1_MM(MAX_MM), NR2_MM(MAX_MM),
     +           NZSAV(NZMAX)
      CHARACTER  FNAMEA(NAMAX)*(*), FNAMEZ(NZMAX)*(*),
     +           F1_MM(MAX_MM)*(*), F2_MM(MAX_MM)*(*), 
     +           NO_DATA*(*), NO_FILE*(*),
     +           STOREA(NAMAX)*(*), STOREZ(NZMAX)*(*), 
     +           S_MM(MAX_MM)*(*),
     +           TITLEA(NAMAX)*(*), TITLEZ(NZMAX)*(*),
     +           T1_MM(MAX_MM)*(*), T2_MM(MAX_MM)*(*)
C
C Locals
C
      INTEGER    IX, IY, NUMDEC, NUMOPT, NTEXT
      PARAMETER (IX = 4, IY = 4, NUMOPT = 13, NTEXT = NUMOPT + 1)
      INTEGER    I, ISEND
      CHARACTER  TEXT(NTEXT)*100
C      CHARACTER  BLANK5*5, NAG(3)*5, PLS*5
C      CHARACTER  BLANK5*5
C      PARAMETER (BLANK5 = '     ')
      LOGICAL    TITLES
      PARAMETER (TITLES = .TRUE.)
      LOGICAL    REPEET
C      LOGICAL    ASAMOD
C      PARAMETER (ASAMOD = .FALSE.)
C      EXTERNAL   LVIEW2, REVPRO, PLSFIT
      EXTERNAL   LVIEW2, REVPRO
      EXTERNAL   M_MVSTAT, M_VECONE, M_MATTWO
      EXTERNAL   STORE_A, STORE_Z, STORE_MM
      EXTERNAL   HELP_SIMSTAT
c      DO I = 1, 3
c         NAG(I) = BLANK5
c      ENDDO 
C      PLS = BLANK5
      REPEET = .TRUE.
      DO WHILE (REPEET)
         CLOSE (UNIT = NIN)
         CALL STORE_A (NAMAX, NCSAV, NRSAV,
     +                 FNAMEA, NO_DATA, NO_FILE, STOREA, TITLEA)
         CALL STORE_MM (MAX_MM, NC1_MM, NC2_MM, NR1_MM, NR2_MM,
     +                  F1_MM, F2_MM, NO_DATA, NO_FILE, S_MM, T1_MM,
     +                  T2_MM)
         CALL STORE_Z (NZMAX, NZSAV,
     +                 FNAMEZ, NO_DATA, NO_FILE, STOREZ, TITLEZ)
C         WRITE (TEXT,100) (STOREA(I), I = 1, 6), STOREZ(12),
C     +                    (STOREA(I), I = 7, 8), NAG(1), NAG(2),
C     +                    (STOREA(I), I = 9, 11), NAG(3),
C     +                     STOREA(14), PLS
         WRITE (TEXT,100) (STOREA(I), I = 1, 6), STOREZ(12),
     +                    (STOREA(I), I = 7, 8)
C     +                     STOREA(9)
C     +                     STOREA(14), PLS
         
         NUMDEC = NUMOPT - 1
         CALL LVIEW2 (IX, IY, NUMDEC, NUMOPT,
     +                TEXT,
     +                TITLES)
         IF (NUMDEC.EQ.1) THEN
C
C Pearson correlation
C
            ISEND = 1
            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Nonparametric correlation
C
            ISEND = 2
            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Partial correlations
C
            ISEND = 3
            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Canonical correlations
C
            ISEND = 4
            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
          ELSEIF (NUMDEC.EQ.5) THEN
C
C Directed correlation
C             
            ISEND = 5 
            CALL M_MATTWO (ISEND, NC1_MM(ISEND), NC2_MM(ISEND), NIN,
     +                     NOUT, NR1_MM(ISEND), NR2_MM(ISEND),
     +                     F1_MM(ISEND), F2_MM(ISEND), T1_MM(ISEND),
     +                     T2_MM(ISEND))
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Dendrogram clustering
C
            ISEND = 5
            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Scaling
C

            ISEND = 6
            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.8) THEN
C
C Distance matrix
C
            ISEND = 12
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         ELSEIF (NUMDEC.EQ.9) THEN
C
C K-means clustering
C
            ISEND = 7
            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.10) THEN
C
C Principal components (NWMAX >= 2*NRMAX)
C
            ISEND = 8
            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
C         ELSEIF (NUMDEC.EQ.11) THEN
C
C Procrustes analysis
C             
C            ISEND = 3 
C            CALL M_MATTWO (ISEND, NC1_MM(ISEND), NC2_MM(ISEND), NIN,
C     +                     NOUT, NR1_MM(ISEND), NR2_MM(ISEND),
C     +                     F1_MM(ISEND), F2_MM(ISEND), T1_MM(ISEND),
C     +                     T2_MM(ISEND))
C            
C         ELSEIF (NUMDEC.EQ.12) THEN
C
C Orthomax/Varimax/Quartimax
C                                  
C            ISEND = 13
C            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
C     +                     FNAMEA(ISEND), TITLEA(ISEND))
C         ELSEIF (NUMDEC.EQ.13) THEN
C
C MANOVA
C
C            ISEND = 9
C            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
C     +                     FNAMEA(ISEND), TITLEA(ISEND))
C         ELSEIF (NUMDEC.EQ.14) THEN
C
C Canonical variates
C
C            ISEND = 10
C            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
C     +                     FNAMEA(ISEND), TITLEA(ISEND))
C         ELSEIF (NUMDEC.EQ.15) THEN
C
C Distances
C
C            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
C     +                     FNAMEA(ISEND), TITLEA(ISEND))
C         ELSEIF (NUMDEC.EQ.16) THEN
C
C Factor analysis
C
C            ISEND = 12
C            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
C     +                     FNAMEA(ISEND), TITLEA(ISEND)) 
C         ELSEIF (NUMDEC.EQ.17) THEN
C
C Biplot
C
C            ISEND = 14
C            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
C     +                     FNAMEA(ISEND), TITLEA(ISEND))
C         ELSEIF (NUMDEC.EQ.18) THEN
C
C PLS
C         
C            CALL PLSFIT (NIN, NOUT,
C     +                   ASAMOD)             
C         ELSEIF (NUMDEC.EQ.19) THEN
C
C MANOVA plotting
C         
C            ISEND = 15
C            CALL M_MVSTAT (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
C     +                     FNAMEA(ISEND), TITLEA(ISEND))                    
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C
C Review progress
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Help
C
            CALL HELP_SIMSTAT ('simstat')
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF
         CLOSE (UNIT = NIN)
      ENDDO
  100 FORMAT (
     + 'The SV_SIMSTAT multivariate options    `Data format'
     +/'Correlation: Pearson Product Moment    `n by m matrix',1X,A 
     +/'Correlation: Spearman and Kendall-tau  `n by m matrix',1X,A 
     +/'Correlation: partial (2 subgroups)     `n by m matrix',1X,A
     +/'Correlation: canonical (2 subgroups)   `n by m matrix',1X,A
     +/'Correlation: directed (matrices A to B)`Two n by m matrices'
     +/'Clusters: distance-matrix/dendrograms  `n by m matrix',1X,A
     +/'Clusters: distance-matrix/MD-scaling   `n by m matrix',1X,A
     +/'Clusters: dendrogram/MD-scaling/nearest`distance-matrix',
     +' as n(n-1)/2 vector',1X,A
     +/'Clusters: K-means                      `n by m matrix',1X,A
     +/'Principal components analysis: PCA     `n by m matrix',1X,A
c     +/'Rotation: Procrustes analysis          `Two n by m matrices',
c     +1X,A
c     +/'Rotation: Varimax or Quartimax         `n by m matrix',1X,A
c     +/'Compare groups: MANOVA/means/profiles  `n by m + 1 matrix',1X,A
c     +/'Compare groups: canonical variates/PCA `n by m + 1 matrix',1X,A
c     +/'Compare groups: distances/allocations  `n by m + 1 matrix',1X,A
c     +/'Factor analysis                        `n by m matrix',1X,A
c     +/'Multivariate 2D and 3D biplots         `n by m matrix',1X,A
c     +/'Partial least squares (PLS)            `X, Y, Z matrices',1X,A
c     +/'Plot groups as symbols and/or labels   `MANOVA type file'
     +/'Results                                `...'
     +/'Help                                   `...'
     +/'Quit ... Exit multivariate options     `...')
      END
C
C-----------------------------------------------------------------------
C
