C
C
C     INCLUDE 'dllchk.for'
      PROGRAM MAIN
C
C VERSION : details from SIMVER/DLLCHK
C FORTRAN : 95, Double precision
C NAG     : G01EBF, G01EDF, G01ECF, G01FBF, G01FCF, G01DDF, S14ABF,
C           X01AAF, X02AMF
C INPUT   : Degrees of freedom, arguments, test statistics
C OUTPUT  : PDF, CDF, ALPHA, Inverses for t distribution
C           Maps t's onto uniform (0, 1) then performs Kolmogorov
C           Smirnov and chi-square tests (? cells) for chi-sq. d'bn.
C           Also performs t and paired t tests on data supplied
C AUTHOR  : W. G. Bardsley, 20/07/90
C           07/07/1992 PDFCDF AND OTHER CHANGES
C           06/03/1993 GET???, PUT??? and compressed
C           16/06/1993 RESFIL
C           15/08/1994 DBOS version
C           22/02/1995 Version for Salamanca
C           16/11/1995 Upgraded for nag mark 16
C           18/12/1996 Transferred TTESTS and NORDIS to SIMFIT.LIB
C           20/12/1996 Altered argument list for TTESTS
C           22/04/1997 win32 version
C           07/08/1998 added dllchk
C           01/09/1998 added spower
C           14/12/1998 replaced TUTORS by TUTOR1
C           13/09/1999 added calls to WINDOW
C           20/12/1999 added call to NONCEN
C           14/02/2000 added SIMVER
C           10/04/2001 revised
C           28/04/2004 added TTEST1 and ISEND to TTESTS
C           02/08/2005 increased DVER to *30 and added to call to ADVISE
C           18/09/2007 revised for version 6
C           01/07/2022 added E_NUMBERS and E_FORMATS and extensive revision and added X_DOFDOT
C
      IMPLICIT   NONE
      INTEGER    NIN, NOUT4, NPAR
      PARAMETER (NIN = 3, NOUT4 = 4, NPAR = 3) 
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12,
     +           N13     
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N8 = 8, N9 = 9, N10 = 10, N11 = 11, N12 = 12,
     +           N13 = 13)
      INTEGER    ISEND, JSEND, NOUT, NTYPE
      INTEGER    N_T, N_TP1, N_TP2, N_TU1, N_TU2, N_T1
      INTEGER    NG_C, NG_R
      DOUBLE PRECISION PAR(NPAR)
      DOUBLE PRECISION DBLE_N, ENEG, EPOS, EXPON, FACTOR, PI, RTOL
      DOUBLE PRECISION DUMMY
      DOUBLE PRECISION XVER, YVER
      DOUBLE PRECISION X01AAF$, X02AMF$
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  FNAME*1024, PTITLE*31
      CHARACTER  FNAME_G*1024, TITLE_G*1024
      CHARACTER  FNAME_T*1024, TITLE_T*80
      CHARACTER  FNAME_TU1*1024, TITLE_TU1*80
      CHARACTER  FNAME_TU2*1024, TITLE_TU2*80
      CHARACTER  FNAME_TP1*1024, TITLE_TP1*80
      CHARACTER  FNAME_TP2*1024, TITLE_TP2*80
      CHARACTER  FNAME_T1*1024, TITLE_T1*80
      CHARACTER  DVER*30, PVER*15, TITLE*80
      PARAMETER (PVER = 'w_ttest.exe')
      CHARACTER  BLANK*1, PNAME*5
      PARAMETER (BLANK = ' ', PNAME = 'TTEST')
      LOGICAL    ABORT, ACTION, AGAIN, FIRST, NOPDF, SHOW
      EXTERNAL   X01AAF$, X02AMF$
      EXTERNAL   RESFIL, PUTADV, FNAMES, REVPRO, SPOWER, NONCEN,
     +           ADVISE, ARGUIN, DETAIL, PDFVAL, CDFVAL, INVERT, 
     +           M_ONEVEC, M_VECONE, M_VECTWO, M_MATONE
      EXTERNAL   DLLCHK, WINDOW, SIMVER
      INTRINSIC  LOG

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C Note ISEND = 2 since may be called from SIMSTAT which has already
C called WINDOW with ISEND = 1
C
      ISEND = N2
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND, 
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER, 
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C


      FIRST = .TRUE.
      CALL ADVISE (DVER,
     +             ABORT, FIRST)
      IF (ABORT) THEN
         AGAIN = .FALSE.
      ELSE
         NOUT = NOUT4
         FNAME = BLANK
         CALL RESFIL (NOUT, FNAME, ABORT)
         IF (ABORT) THEN
            AGAIN = .FALSE.
         ELSE
            AGAIN = .TRUE.
            WRITE (NOUT,100)
            NG_C = N0
            NG_R = N0
            N_T = N0
            N_TP1 = N0
            N_TP2 = N0
            N_TU1 = N0
            N_TU2 = N0
            N_T1 = N0
            FNAME_G = BLANK
            FNAME_T = BLANK
            FNAME_TP1 = BLANK
            FNAME_TP2 = BLANK
            FNAME_TU1 = BLANK
            FNAME_TU2 = BLANK
            FNAME_T1 = BLANK
            TITLE_G = BLANK
            TITLE_T = BLANK
            TITLE_TP1 = BLANK
            TITLE_TP2 = BLANK
            TITLE_TU1 = BLANK
            TITLE_TU2 = BLANK
            TITLE_T1 = BLANK
            RTOL = 1.0D+09*X02AMF$()
            ENEG = LOG(RTOL)
            EPOS = - ENEG
            PI = X01AAF$(DUMMY)
C
C First set N < 1 to make sure N is initialised
C
            DBLE_N = ZERO
         ENDIF
      ENDIF
C
C Main loop
C      
      DO WHILE (AGAIN)
C
C Get the option required
C
         CALL DETAIL (ISEND,
     +                DBLE_N)
         IF (ISEND.EQ.N1) THEN
C
C ISEND = 1: Input degrees of freedom
C
            CALL ARGUIN (NOUT, NPAR,
     +                   DBLE_N, ENEG, EPOS, EXPON, FACTOR, PAR, PI, 
     +                   PTITLE, 
     +                   NOPDF)
         ELSEIF (ISEND.EQ.N2) THEN
C
C ISEND = 2: Get pdf
C
            CALL PDFVAL (NOUT, 
     +                   DBLE_N, EXPON, FACTOR,            
     +                   NOPDF)
         ELSEIF (ISEND.EQ.N3) THEN
C
C ISEND = 3: Get cdf
C
            CALL CDFVAL (NOUT,
     +                   DBLE_N)
         ELSEIF (ISEND.EQ.N4) THEN
C
C ISEND = 4: Get critical values
C
            CALL INVERT (NOUT,
     +                   DBLE_N)
         ELSEIF (ISEND.EQ.N5) THEN
C
C ISEND = 5: Test for t distribution
C
            IF (DBLE_N.LT.ONE) THEN
               CALL PUTADV ('First choose option 1 to input N')
            ELSE
               JSEND = N3 
               CALL M_ONEVEC (JSEND, NIN, NOUT, NPAR, N_T,
     +                        PAR,
     +                        FNAME_T, TITLE_T)                
            ENDIF
         ELSEIF (ISEND.EQ.N6) THEN
C
C ISEND = 6: 1-sample t test
C
            JSEND = N2
            CALL M_VECONE (JSEND, NIN, NOUT, N_T1,
     +                     FNAME_T1, TITLE_T1)        
         ELSEIF (ISEND.EQ.N7) THEN
C
C ISEND = 7: 2-sample unpaired t test
C
            JSEND = N2 
            CALL M_VECTWO (JSEND, NIN, NOUT, N_TU1, N_TU2,
     +                     FNAME_TU1, FNAME_TU2, TITLE_TU1, TITLE_TU2)            
         ELSEIF (ISEND.EQ.N8) THEN
C
C ISEND = 8: 2-sample paired t ttest
C
            JSEND = N3
            CALL M_VECTWO (JSEND, NIN, NOUT, N_TP1, N_TP2,
     +                     FNAME_TP1, FNAME_TP2, TITLE_TP1, TITLE_TP2)  
         ELSEIF (ISEND.EQ.N9) THEN
C
C ISEND = 9: Row-wise t tests
C         
            JSEND = 34
            CALL M_MATONE (JSEND, NG_C, NIN, NOUT, NG_R,
     +                     FNAME_G, TITLE_G)            
         ELSEIF (ISEND.EQ.N10) THEN
C
C ISEND = 10: Power calculations
C
            CALL SPOWER (NOUT)
         ELSEIF (ISEND.EQ.N11) THEN
C
C ISEND = 11: Non-central distributions
C
            NTYPE = N1
            CALL NONCEN (NOUT, NTYPE)
         ELSEIF (ISEND.EQ.N12) THEN
C
C ISEND = 12: Help
C
            FIRST = .FALSE.
            CALL ADVISE (DVER,
     +                   ABORT, FIRST)
         ELSEIF (ISEND.EQ.N13) THEN
C
C ISEND = 13: Results
C
            CALL REVPRO (NOUT)
         ELSE
C
C ISEND = 14: Exit
C           
            AGAIN = .FALSE.
            CLOSE (UNIT = NOUT)
            ISEND = N2
            CALL FNAMES (ISEND,
     +                   FNAME)
         ENDIF
      ENDDO

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = N2
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C
      CLOSE (UNIT = NOUT4)
C
C Format statement
C
  100 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : TTEST'
     +/1X,'ACTION  : t tests/distribution'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (IN)  :: FIRST
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_TTEST
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_TTEST ('ttest')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C
      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `TTEST'
     +/'        `      '
     +/'Action  `t tests and calculations with the t distribution'
     +/'        `Calculate pdf-/cdf-/critical-values, test for a t'
     +/'        `distribution, t tests and power/sample sizes.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ARGUIN (NOUT, NPAR,
     +                   DBLE_N, ENEG, EPOS, EXPON, FACTOR, PAR, PI, 
     +                   PTITLE,
     +                   NOPDF)
C
C Enter degrees of freedom N then calculate constants
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NOUT, NPAR
      DOUBLE PRECISION,    INTENT (IN)    :: ENEG, PI
      DOUBLE PRECISION,    INTENT (INOUT) :: DBLE_N, EPOS, EXPON, 
     +                                       FACTOR, PAR(NPAR)
      CHARACTER (LEN = *), INTENT (INOUT) :: PTITLE 
C
C Locals
C      
      INTEGER    NBIG, NCDF, NPDF, NTYPE
      PARAMETER (NBIG = 1000, NCDF = 100, NPDF = 160, NTYPE = 4)
      INTEGER    ISEND
      PARAMETER (ISEND = 0)
      INTEGER    IFAIL
      DOUBLE PRECISION XCDF(NCDF), XPDF(NPDF), YCDF(NCDF), YPDF(NPDF)
      DOUBLE PRECISION BIGN, RN, RNO2, RNP1O2
      DOUBLE PRECISION ARG, GAMMA1, GAMMA2
      DOUBLE PRECISION TBOT, TTOP
      PARAMETER (TTOP = 1.0D+20, TBOT = - TTOP)
      DOUBLE PRECISION S14ABF$
      DOUBLE PRECISION PNT5, ONE, TEN
      PARAMETER (PNT5 = 0.5D+00, ONE = 1.0D+00, TEN = 10.0D+00)
      CHARACTER (LEN = 1) CIPHER
      PARAMETER (CIPHER = 'L')
      CHARACTER  XTITLE*1, YTITLE*11
      CHARACTER  VALUEN*10
      LOGICAL    NOPDF, YESNO
      EXTERNAL   X_DOFDOT
      EXTERNAL   S14ABF$
      EXTERNAL   GETDM1, PUTIFA, PUTADV, PDFCDF, GETL01
      INTRINSIC  DBLE, EXP, LOG
      IF (DBLE_N.LT.ONE) DBLE_N = TEN
      BIGN = DBLE(NBIG)  
      CALL GETDM1 (ONE, DBLE_N, BIGN,
     +'Number of degrees of freedom required for t distribution')
      RN = DBLE_N
      RNO2 = PNT5*RN
      RNP1O2 = PNT5*(RN + ONE)
      EXPON = - RNP1O2
      IFAIL = 1
      GAMMA1 = S14ABF$(RNP1O2, IFAIL)
      NOPDF = .FALSE.
      IF (IFAIL.NE.0) THEN
         CALL PUTIFA (IFAIL, NOUT, 'S14ABF/ARGUIN')
         GAMMA1 = ONE
         NOPDF = .TRUE.
      ENDIF
      IFAIL = 1
      GAMMA2 = S14ABF$(RNO2, IFAIL)
      IF (IFAIL.NE.0) THEN
         CALL PUTIFA (IFAIL, NOUT, 'S14ABF/ARGUIN')
         GAMMA2 = ONE
         NOPDF = .TRUE.
      ENDIF
      ARG = GAMMA1 - GAMMA2 - PNT5*LOG(RN*PI)
      IF (ARG.LT.ENEG .OR. ARG.GT.EPOS) THEN
         CALL PUTADV ('Overflow ... pdf cannot be calculated')
         ARG = ONE
         NOPDF = .TRUE.
      ENDIF
      FACTOR = EXP(ARG)
      WRITE (VALUEN,'(F10.2)') DBLE_N
      CALL X_DOFDOT (ISEND,
     +               CIPHER, VALUEN) 
      PTITLE = 't distribution: N = '//VALUEN
      PAR(1) = DBLE_N
      PAR(2) = EXPON
      PAR(3) = FACTOR
      IF (NOPDF) THEN
         RETURN
      ELSE 
         YESNO = .FALSE.
         CALL GETL01 ('Plot pdf(t) and cdf(t)',
     +                 YESNO)
         IF (YESNO) THEN
            XTITLE = 't'
            YTITLE = 'cdf and pdf'
            CALL PDFCDF (NCDF, NOUT, NPAR, NPDF, NTYPE,
     +                   PAR, TBOT, XCDF, XPDF, TTOP, YCDF, YPDF,              
     +                   PTITLE, XTITLE, YTITLE)
         ENDIF
      ENDIF
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE CDFVAL (NOUT,
     +                   DBLE_N)
C
C Evaluate CDF
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: DBLE_N
C
C Locals
C      
      INTEGER    I
      INTEGER    NTVALS
      INTEGER    KMAX, KMIN, K1
      PARAMETER (KMAX = 20, KMIN = 0, K1 = 1)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 9)
      INTEGER    NTEMP(3)
      DOUBLE PRECISION ALPHA, BETA, T
      DOUBLE PRECISION CDF_T
      DOUBLE PRECISION XTEMP(3)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 13) D13, SHOWRJ
      CHARACTER (LEN = 90) LINE
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   PUTADV, GETJM1, TABLE4, MIDDLE
      EXTERNAL   PARAMS, CDF_T
      SAVE       NTVALS
      DATA       NTVALS / 1 /
      IF (DBLE_N.LT.ONE) THEN
         CALL PUTADV ('First choose option 1 to input N')
         RETURN
      ENDIF
      CALL GETJM1 (KMIN, NTVALS, KMAX,
     +            'Number of cdf(t) values required (0 = Cancel)')
      IF (NTVALS.LT.K1) RETURN
      E_NUMBERS = E_FORMATS() 
      CALL PARAMS (NOUT,
     +             DBLE_N)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,50)
      WRITE (NOUT,50)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      DO I = K1, NTVALS
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETR01')
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP,
     +               't-value required for cdf(t)')
         T = XTEMP(K1)
         BETA = CDF_T(NOUT,
     +                DBLE_N, T)
         ALPHA = ONE - BETA
         CALL MIDDLE (ZERO, ALPHA, ONE)
         CALL MIDDLE (ZERO, BETA, ONE)
         IF (E_NUMBERS) THEN
            WRITE (LINE,100) T, BETA, ALPHA
            WRITE (NOUT,100) T, BETA, ALPHA
         ELSE
             D13 = SHOWRJ(T)
             WRITE (LINE,150) D13, BETA, ALPHA
             WRITE (NOUT,150) D13, BETA, ALPHA 
         ENDIF    
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statement
C
   50 FORMAT (13X,'t',8X,'cdf(t)',6X,'1-cdf(t)')    
  100 FORMAT (1X,1P,E13.5,2X,0P,F12.6,2X,F12.6)
  150 FORMAT (1X,A13,2X,F12.6,2X,F12.6)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE DETAIL (ISEND,
     +                   DBLE_N)
C
C Decide option required
C
      IMPLICIT   NONE
C
C Arguments
C           
      INTEGER,          INTENT (INOUT) :: ISEND
      DOUBLE PRECISION, INTENT (IN)    :: DBLE_N
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT, N1
      PARAMETER (ICOLOR = 9, IX = 12, IY = 8, LSHADE = 1, NUMOPT = 14,
     +           NSTART = 3, NTEXT = NSTART + NUMOPT, N1 = 1)
      INTEGER    JSEND
      PARAMETER (JSEND = 0)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    ISAV
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER (LEN = 1) CIPHER
      PARAMETER (CIPHER = 'L')
      CHARACTER  TEXT(NTEXT)*100, VALUEN*10
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01, X_DOFDOT
      SAVE       ISAV
      DATA       ISAV / 11/
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      WRITE (TEXT,100)
      IF (DBLE_N.LT.ONE) THEN
         WRITE (TEXT(NTEXT),200)
      ELSE
         WRITE (VALUEN,'(F10.2)') DBLE_N
         CALL X_DOFDOT (JSEND,
     +                  CIPHER, VALUEN)
         WRITE (TEXT(NTEXT),300) VALUEN
      ENDIF
      ISEND = ISAV
      NUMBLD(1) = N1
      NUMBLD(NTEXT) = N1
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, ISEND, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      ISAV = ISEND
C
C Format statements
C     
  100 FORMAT (
     + 'Options available for program TTEST'
     +/
     +/'Input: N, number of degrees of freedom'
     +/'Input: t, calculate pdf(t)'
     +/'Input: t, calculate cdf(t)'
     +/'Input: alpha, calculate t-inverse'
     +/'Input: data, test if t distributed'
     +/'Input: data, 1-sample t test'
     +/'Input: data, 2-sample unpaired t test'
     +/'Input: data, 2-sample paired t test'
     +/'Input: data, groups across rows t tests'
     +/'Calculate: power and sample size'
     +/'Calculate: non-central t values'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit program TTEST'
     +/)
  200 FORMAT ('Degrees of freedom (N) not initialised')
  300 FORMAT ('Current number of degrees of freedom:',1X,A)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE INVERT (NOUT,
     +                   DBLE_N)
C
C Invert t distribution
C 
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: DBLE_N 
C
C Locals
C      
      INTEGER    I, NPVALS
      INTEGER    KMAX, KMIN, K1, K2, K3
      PARAMETER (KMAX = 20, KMIN = 0, K1 = 1, K2 = 2, K3 = 3)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 9)
      INTEGER    NTEMP(3)
      DOUBLE PRECISION ONE, CENT
      PARAMETER (ONE = 1.0D+00, CENT = 100.0D+00)
      DOUBLE PRECISION PCMAX, PCMIN
      PARAMETER (PCMAX = 99.99D+00, PCMIN = 0.01D+00)
      DOUBLE PRECISION ALPHA, BETA, PCENT, TSTAT
      DOUBLE PRECISION CDFINV_T
      DOUBLE PRECISION XTEMP(3)
      CHARACTER (LEN = 13) D13, SHOWRJ
      CHARACTER (LEN = 90) LINE
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   PUTADV, GETJM1, TABLE4
      EXTERNAL   PARAMS, CDFINV_T
      SAVE       NPVALS
      DATA       NPVALS / 1 /
      IF (DBLE_N.LT.ONE) THEN
         CALL PUTADV ('First choose option 1 to input N')
         RETURN
      ENDIF
      CALL GETJM1 (KMIN, NPVALS, KMAX,
     +            'Number of percentage points required (0 = Cancel)')
      IF (NPVALS.LT.K1) RETURN
      E_NUMBERS = E_FORMATS()
      E_NUMBERS = .TRUE.  
      CALL PARAMS (NOUT,
     +             DBLE_N)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,50)
      WRITE (NOUT,50)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      XTEMP(K1) = PCMIN
      XTEMP(K3) = PCMAX
      DO I = K1, NPVALS
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETRL1')
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP,
     +               'Percentage point (i.e. 100*alpha) required')
         PCENT = XTEMP(K2)
         ALPHA = PCENT/CENT
         BETA = ONE - ALPHA
         TSTAT = CDFINV_T (NOUT,
     +                     DBLE_N, BETA)
         IF (E_NUMBERS) THEN 
            WRITE (LINE,100) TSTAT, BETA, ALPHA
            WRITE (NOUT,100) TSTAT, BETA, ALPHA
         ELSE
            D13 = SHOWRJ(TSTAT)
            WRITE (LINE,150) D13, BETA, ALPHA
            WRITE (NOUT,150) D13, BETA, ALPHA
         ENDIF  
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statement
C 
   50 FORMAT (13X,'x',10X,'beta',9X,'alpha')   
  100 FORMAT (1X,1P,E13.5,5X,0P,F9.6,5X,F9.6)
  150 FORMAT (1X,A13,5X,F9.6,5X,F9.6)        
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE PARAMS (NOUT,
     +                   DBLE_N)
C
C Output current parameters to a file
C
      IMPLICIT  NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: DBLE_N
C
C Locals
C     
      INTEGER    ISEND
      PARAMETER (ISEND = 0) 
      CHARACTER (LEN = 10) VALUEN
      CHARACTER (LEN = 1 ) CIPHER
      PARAMETER (CIPHER = 'L')
      EXTERNAL   X_DOFDOT
      WRITE (VALUEN,'(F10.2)') DBLE_N
      CALL X_DOFDOT (ISEND, 
     +               CIPHER, VALUEN)
      WRITE (NOUT,100) VALUEN
C
C Format statement
C      
  100 FORMAT (/1X,
     +'Number of degrees of freedom for current t distribution =',1X,A)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE PDFVAL (NOUT,
     +                   DBLE_N, EXPON, FACTOR, 
     +                   NOPDF)
C
C Calculate PDF(T) given T
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: DBLE_N, EXPON, FACTOR
C
C Locals
C      
      INTEGER    I
      INTEGER    NTVALS
      INTEGER    KMAX, KMIN, K1
      PARAMETER (KMAX = 20, KMIN = 0, K1 = 1)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 9)
      INTEGER    NTEMP(3)
      DOUBLE PRECISION T, VALUE
      DOUBLE PRECISION PDF_T
      DOUBLE PRECISION XTEMP(3)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00) 
      CHARACTER (LEN = 13) D13(2), SHOWRJ
      CHARACTER (LEN = 90) LINE
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    NOPDF
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   PUTADV, GETJM1, TABLE4
      EXTERNAL   PARAMS, PDF_T
      SAVE       NTVALS
      DATA       NTVALS / 1 /
      IF (DBLE_N.LT.ONE) THEN
         CALL PUTADV ('First choose option 1 to input N')
         RETURN
      ENDIF
      IF (NOPDF) THEN
         CALL PUTADV ('pdf cannot be calculated for this value')
         RETURN
      ENDIF
      E_NUMBERS = E_FORMATS()
      CALL GETJM1 (KMIN, NTVALS, KMAX,
     +            'Number of pdf(t) values required (0 = Cancel)')
      IF (NTVALS.LT.K1) RETURN
      CALL PARAMS (NOUT,
     +             DBLE_N)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,50)
      WRITE (NOUT,50)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      DO I = K1, NTVALS
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETR01')
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP,
     +                't-value required for pdf(t)')
         T = XTEMP(K1)
         VALUE = PDF_T (DBLE_N, EXPON, FACTOR, T)
         IF (E_NUMBERS) THEN
            WRITE (LINE,100) T, VALUE
            WRITE (NOUT,100) T, VALUE
         ELSE
            D13(1) = SHOWRJ(T)
            D13(2) = SHOWRJ(VALUE)
            WRITE (LINE,150) D13(1), D13(2)
            WRITE (NOUT,150) D13(1), D13(2)
         ENDIF  
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statement
C      
   50 FORMAT (13X,'t',9X,'pdf(t)')
  100 FORMAT (1X,1P,E13.5,2X,E13.5)
  150 FORMAT (1X,A13,2X,A13)
      END
C
C
     