C
C FTN95 version
C =============
C
C A program to test user supplied models for the SIMFIT package
C
C
C This version must have USERMOD1.INS, USERMOD2.INS, USERMOD3.INS and USERMOD4.INS
C ================================================================================
C
C Note:- this version calls QNUSER
C
C     INCLUDE 'usermod1.ins', NOLIST
C     INCLUDE 'usermod2.ins', NOLIST
C     INCLUDE 'usermod3.ins', NOLIST
C     INCLUDE 'usermod4.ins', NOLIST
C     INCLUDE 'dllchk.for'
C
C

      MODULE MODULE_USERMOD
C
C Shared data
C      
      IMPLICIT   NONE
      INTEGER    NLINES
      INTEGER    NEQN, NPAR, NVAR
      INTEGER    NHIGH, NWIDE
      PARAMETER (NHIGH = 1000, NWIDE = 100)
      INTEGER    NLIMIT
      PARAMETER (NLIMIT = 100)
      INTEGER    N24
      PARAMETER (N24 = 24)
      INTEGER    NPMAX, NX
      PARAMETER (NX = 100, NPMAX = 10*NX)
      DOUBLE PRECISION BLIM(NLIMIT), EPSABS, EPSREL, TLIM(NLIMIT)
      DOUBLE PRECISION A(NPMAX), F(NX), YDE(NX), YJA(NX**2), ZDE(NX)
      CHARACTER (LEN = NWIDE) TEXT(NHIGH)
      CHARACTER (LEN = 1024 ) FILEX, FNAME, TEMP_FILE
      CHARACTER (LEN = 80   ) MODE_OF_ACTION, MODNAM(N24)
      CHARACTER (LEN = 7    ) NO_FILE
      PARAMETER (NO_FILE = 'No File')
      LOGICAL    DEQN
      END MODULE MODULE_USERMOD

      
      PROGRAM USERMD
      USE MODULE_USERMOD, ONLY : MODE_OF_ACTION, NO_FILE, NLINES,
     +                           TEXT, FILEX, FNAME, TEMP_FILE, NLIMIT,
     +                           BLIM, EPSABS, EPSREL, TLIM,
     +                           NEQN, NPAR, NVAR,
     +                           DEQN,
     +                           N24, MODNAM,
     +                           NPMAX, NX, A, F, YDE, YJA, ZDE
C
C ACTION : Check a user defined model
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 29/12/1994
C          Version: details from SIMVER/DLLCHK
C          22/02/1995 Salamanca Version
C          19/09/1995 New version for NSTACK_2 as well as NSTACK_1
C          23/05/1996 Completely revised and added AREA01, ADVISE, DETAIL,
C                   ROOTER to find zeros and areas
C          15/08/1996 Added PLOT01
C          08/07/1997 win32 version ... dimensions as in QNUSER
C          14/10/1997 restored full dimensions
C          07/08/1998 added dllchk
C          14/12/1998 replaced TUTORS by TUTOR1
C          01/03/1999 zeros for n functions of n variables
C          13/09/1999 added calls to WINDOW
C          26/11/1999 added code for editor and viewer
C          14/02/2000 added SIMVER
C          29/09/2000 added PKURVE
C          10/04/2001 revised
C          20/10/2001 complete re-write to call QNUSER directly
C                     and allow more functions and better control
C          08/02/2002 increased dimension to NVAL(12)
C          16/06/2003 revised and added OPTIMA for optimisation and opens
C                     w_usermod.err on unit 6 and iterate.dat on unit 8
C                     for LBFGSB messages if optimization is used
C          17/11/2003 replaced STARTP by RUN_EDITOR
C          02/08/2005 increased DVER to *30 and added to call to ADVISE 
C          10/06/2010 added call to NKLCFG
C          06/02/2016 revison to emphasize begin{expression} ... end{expression} 
C                     and enhanced the procedure for creating model files     
C          06/04/2016 introduced USERMOD4 and MODULE_USERMOD, eliminated COMMON blocks, and
C                     new features using subroutine MODELS in models.dll
C          12/07/2016 introduced ZDE to store starting estimates as follows:
C                     1) ZDE can only be changed by editing 
C                     2) When ZDE is edited then also YDE is set to ZDE
C                     because YDE is the differential equation component value or the 
C                     independent variable when there are more than 3 this was causing
C                     cross-talk with finding zeros of n functions of n variables
C          26/07/2022 added E_NUMBERS and E_FORMATS, etc.    
C
C
      IMPLICIT   NONE
      INTEGER    NIN, NOUT, N0, N1, N2, N3
      PARAMETER (NIN = 3, NOUT = 4, N0 = 0, N1 = 1, N2 = 2, N3 = 3)
      INTEGER    KPAR
      PARAMETER (KPAR = 50)
      INTEGER    I, ICOLOR, IDEC, IOS, ISEND, L_IN, L_OUT, NPTEMP
      INTEGER    JSEND
      PARAMETER (JSEND = 1)
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      DOUBLE PRECISION TEMP(NPMAX,3), W(NPMAX)
      DOUBLE PRECISION QPAR(KPAR)
      DOUBLE PRECISION X, Y, Z
      DOUBLE PRECISION XVER, YVER
      DOUBLE PRECISION ONE, ZERO, TEN
      PARAMETER (ONE = 1.0D+00, ZERO = 0.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION XBOT(NX), XMID(NX), XTOP(NX)
      DOUBLE PRECISION USER_FUNC  
      CHARACTER (LEN = 1024) LOGFIL
      CHARACTER (LEN = 100 ) LINE
      CHARACTER (LEN = 80  ) TITLE
      CHARACTER (LEN = 30  ) DVER
      CHARACTER (LEN = 15  ) PVER
      CHARACTER (LEN = 13  ) D13(5), SHOWLJ
      CHARACTER (LEN = 7   ) PNAME
      CHARACTER (LEN = 1   ) BLANK, BSLASH
      PARAMETER (BLANK = ' ', BSLASH = '/', PNAME = 'USERMOD',
     +           PVER = 'w_usermod.exe')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, ABORT1, ACTION, EDIT, EVAL, MULTI, OPTIMA, 
     +           PLOT, READY, REPEET, SHOW, ZEROS
      LOGICAL    FIXNPT, LABEL
      PARAMETER (FIXNPT = .FALSE., LABEL = .FALSE.)
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL1, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .TRUE.,
     +           LABEL1 = .TRUE., ORDER = .FALSE., WEIGHT = .FALSE.)
      LOGICAL    FIRST, OK, YESNO
      LOGICAL    DO_THIS, STORE
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   GETD01, TABLE1, EDITOR, VIEWER,
     +           GETD02, GETD03, PUTADV, VEC1IN, PKURVE, GETDGE,
     +           FNAMES
      EXTERNAL   ADVISE, AREA01, DETAIL, ROOTER, PLOT01, PLOT02, ZEROSN,
     +           AREA0N, MINIMA, NEWMOD, USENOW
      EXTERNAL   QNUSER, QNFILE
      EXTERNAL   USER_FUNC, USER_SUB
      EXTERNAL   DLLCHK, WINDOW, SIMVER, V7PATH
      EXTERNAL   FNAME_TO_FILEX, MODCHK
      INTRINSIC  MAX, TRIM
C
C Common block required to communicate with functions used for
C root finding and quadrature
C
      SAVE X, Y, Z
      DATA X, Y, Z / ONE, ONE, ONE /
C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      E_NUMBERS = E_FORMATS()
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND, TITLE, ACTION)
      CALL SIMVER (XVER, YVER, DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER, DVER, PVER, ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

C
C Initialise the program then offer advice
C
      FIRST = .TRUE.
      LOGFIL = BLANK
      CALL ADVISE (DVER,
     +             ABORT, FIRST)
      IF (ABORT) THEN
C
C Quit has been selected
C
         REPEET = .FALSE.
      ELSE
C
C Run has been selected so set all defaults
C
         call v7path (l_out,
     +                'tmp', temp_file)
         if (temp_file(l_out:l_out).ne.bslash) then
            l_out = l_out + 1
            temp_file(l_out:l_out) = bslash
         endif 
         l_in = l_out + 1
         l_out = l_out + 12
         temp_file(l_in:l_out) = 'f$parser.tmp'	
         
         MODE_OF_ACTION = 'Waiting for a model'
         REPEET = .TRUE.
         KMAX_A = NPMAX
         KMAX_F = NX
         KMAX_J = NX**2
         KMAX_Y = NX
         DO I = N1, NPMAX
            A(I) = ONE
         ENDDO
         DO I = N1, NX
            XBOT(I) = - TEN
            XMID(I) = ZERO
            XTOP(I) = TEN
            YDE(I) = ONE
            ZDE(I) = ZERO
         ENDDO
         DO I = N1, KPAR
            QPAR(I) = ONE
         ENDDO
         DO I = N1, N24
            MODNAM(I) = BLANK
         ENDDO
         MODNAM(2) = ' There is no current model file'
         EPSABS = 1.0D-06
         EPSREL = 1.0D-03
         DO I = N1, NLIMIT
            BLIM(I) = -TEN
            TLIM(I) = TEN
         ENDDO
         X = ZERO
         Y = ZERO
         Z = ZERO
         NEQN = N1
         NPAR = N1
         NVAR = N1
         IDEC = 0
         DO_THIS = .TRUE.
         DEQN = .FALSE.
         EVAL = .FALSE.
         MULTI = .FALSE.
         OPTIMA = .FALSE.
         PLOT = .FALSE.
         READY = .FALSE.
         ZEROS = .FALSE.
         FNAME = NO_FILE
         FILEX = NO_FILE
      ENDIF
C
C Branch point for main decisions
C
      ABORT = .TRUE.
      DO WHILE (REPEET)
         IF (DO_THIS) CALL DETAIL (IDEC, NOUT, 
     +                             LOGFIL,
     +                             EVAL, MULTI, OPTIMA, PLOT, 
     +                             READY, ZEROS)
         IF (IDEC.EQ.1) THEN
            FNAME = NO_FILE
            FILEX = FNAME
            STORE = .TRUE.
            CALL QNFILE (FNAME,
     +                   STORE)
            DO_THIS = .FALSE.
            MODE_OF_ACTION = 'Waiting for a model'
         ENDIF           
         IF (IDEC.LT.8) THEN
            IF (DO_THIS) THEN
               CALL NEWMOD (IDEC, N2,
     +                      FILEX,
     +                      ABORT1)          
            ENDIF
C
C Call QNUSER and QNFILE
C
            DO I = N1, N24
               MODNAM(I) = BLANK
            ENDDO
            MODNAM(2) = ' There is no current model file'
            ISEND = 1
            CALL QNUSER (ISEND,
     +                   KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                   NEQN, NPAR, NVAR, NX,
     +                   A, F, X, Y, YDE, YJA, Z,
     +                   MODNAM,
     +                   ABORT, DEQN)
            IF (ABORT) THEN
               MODE_OF_ACTION = 'Waiting for a model'
            ELSE
               STORE = .FALSE.
               CALL QNFILE (FNAME,
     +                      STORE)
            ENDIF     
           
C
C Are we ready to evaluate, plot, etc. ?
C
            EVAL = .FALSE.
            READY = .FALSE.
            MULTI = .FALSE.
            PLOT = .FALSE.
            ZEROS = .FALSE.
            IF (ABORT) THEN
C
C The file is faulty
C
               NEQN = - N1
               NPAR = - N1
               NVAR = - N1
               DO I = N1, N24
                  MODNAM(I) = BLANK
               ENDDO
               MODNAM(2) = ' There is no current model file'
               IDEC = 1
            ELSE
               EVAL = .TRUE.
               IDEC = 2
            ENDIF
C
C Are we ready to multi-integrate ?
C
            IF (NVAR.GT.N1) MULTI = .TRUE.
C
C Are we ready to plot ?
C
            IF (NVAR.LE.N2 .AND. .NOT.DEQN) PLOT = .TRUE.
C
C Are we ready to find zeros or integrate ?
C
            IF (NEQN.EQ.N1 .AND. NVAR.EQ.N1 .AND.
     +         .NOT.DEQN) READY = .TRUE.
            IF (NEQN.EQ.NVAR .AND. NEQN.GT.1 .AND.
     +         .NOT.DEQN) ZEROS = .TRUE.
C
C Are we ready to optimise ?
C
            IF (NEQN.GT.N1 .AND. NEQN.EQ.NVAR + N1) OPTIMA = .TRUE.
C
C Initialise J(i) in case J(i) not defined by deqn. file
C
            IF (DEQN) THEN
               DO I = N1, MAX(N1,NEQN*NEQN)
                  YJA(I) = ZERO
               ENDDO
               CALL PUTADV (
     +'If non-autonomous x & y(i,x) must be consistent (i.e. same x)')
            ENDIF
            DO_THIS = .TRUE.
            IDEC = 2
         ELSEIF (IDEC.EQ.8) THEN
C
C IDEC = 8: Evaluate the model
C
            IF (DEQN) THEN
               CALL GETD01 (X,
     + 'x (Note: y and j are independent of x in autonomous systems)')
            ELSEIF (NVAR.EQ.1) THEN
               CALL GETD01 (X, 'Value required for x')
            ELSEIF (NVAR.EQ.2) THEN
               CALL GETD02 (X, Y, 'Values required for x, y')
            ELSEIF (NVAR.EQ.3) THEN
               CALL GETD03 (X, Y, Z, 'Values required for x, y, z')
            ELSE
               CALL PUTADV ('Only y(1) to y(4) will be output in table')
            ENDIF
            ISEND = 4
            CALL QNUSER (ISEND,
     +                   KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                   NEQN, NPAR, NVAR, NX,
     +                   A, F, X, Y, YDE, YJA, Z,
     +                   MODNAM,
     +                   ABORT, DEQN)
            IF (DEQN) THEN
               ISEND = 5
               CALL QNUSER (ISEND,
     +                      KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                      NEQN, NPAR, NVAR, NX,
     +                      A, F, X, Y, YDE, YJA, Z,
     +                      MODNAM,
     +                      ABORT, DEQN)
            ENDIF
            ICOLOR = 4
            CALL TABLE1 (ICOLOR, '  ')
            CALL TABLE1 (ICOLOR, 'Evaluating the model')
            CALL TABLE1 (ICOLOR, '....................')
            ICOLOR = 0
            DO I = N1, NEQN
               IF (DEQN) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,100) I, X, YDE(I), I, F(I)
                  ELSE
                     D13(1) = SHOWLJ(X)
                     D13(2) = SHOWLJ(YDE(I))
                     D13(3) = SHOWLJ(F(I))
                     WRITE (LINE,150) I, TRIM(D13(1)), TRIM(D13(2)), I,
     +                                D13(3)
                  ENDIF  
               ELSEIF (NVAR.EQ.N1) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,200) X, F(I), I
                  ELSE
                     D13(1) = SHOWLJ(X)
                     D13(2) = SHOWLJ(F(I))
                     WRITE (LINE,250) D13(1), D13(2), I
                  ENDIF  
               ELSEIF (NVAR.EQ.2) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,300) X, Y, F(I), I 
                  ELSE
                     D13(1) = SHOWLJ(X)
                     D13(2) = SHOWLJ(Y)
                     D13(3) = SHOWLJ(F(I))
                     WRITE (LINE,350) D13(1), D13(2), D13(3), I 
                  ENDIF  
               ELSEIF (NVAR.EQ.3) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,400) X, Y, Z, F(I), I
                  ELSE
                     D13(1) = SHOWLJ(X)
                     D13(2) = SHOWLJ(Y)
                     D13(3) = SHOWLJ(Z)
                     D13(4) = SHOWLJ(F(I))   
                     WRITE (LINE,450) D13(1), D13(2), D13(3), D13(4), I
                  ENDIF    
               ELSE
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,500) YDE(1), YDE(2), YDE(3), YDE(4),
     +                                F(I), I
                  ELSE
                     D13(1) = SHOWLJ(YDE(1))
                     D13(2) = SHOWLJ(YDE(2))
                     D13(3) = SHOWLJ(YDE(3))
                     D13(4) = SHOWLJ(YDE(4))
                     D13(5) = SHOWLJ(YDE(5))
                     WRITE (LINE,550) D13(1), D13(2), D13(3), D13(4),
     +                                F(I), I                     
                  ENDIF   
               ENDIF
               CALL TABLE1 (ICOLOR, LINE)
            ENDDO
            IF (DEQN) THEN
               DO I = N1, NEQN**2
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,600) I, X, YJA(I)
                  ELSE
                     D13(1) = SHOWLJ(X)
                     D13(2) = SHOWLJ(YJA(I))
                     WRITE (LINE,650) I, TRIM(D13(1)), D13(2) 
                  ENDIF  
                  CALL TABLE1 (ICOLOR, LINE)
               ENDDO
            ENDIF
            CALL TABLE1 (ICOLOR, 'CLOSE')
            IDEC = 2
         ELSEIF (IDEC.EQ.9) THEN
C
C IDEC = 9: Plot
C
            IF (NVAR.EQ.1) THEN
               CALL PLOT01 (KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                      NEQN, NPAR, NVAR, NX,
     +                      A, F, Y, YDE, YJA, Z,
     +                      MODNAM)
            ELSEIF (NVAR.EQ.2) THEN
               CALL PLOT02 (KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                      NEQN, NPAR, NVAR, NX,
     +                      A, F, X, Y, YDE, YJA, Z,
     +                      MODNAM)
            ENDIF
            IDEC = 2
         ELSEIF (IDEC.EQ.10) THEN
C
C IDEC = 10: Find the zero of a function
C
            CALL ROOTER (KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                   NEQN, NOUT, NPAR, NVAR, NX,
     +                   A, F, Y, YDE, YJA, Z,
     +                   MODNAM)
            IDEC = 2
         ELSEIF (IDEC.EQ.11) THEN
C
C IDEC = 11: Find the zero of n functions of n variables 
C
            CALL ZEROSN (NEQN, NOUT,
     +                   EPSREL, ZDE)
            IDEC = 2
         ELSEIF (IDEC.EQ.12) THEN
C
C IDEC = 12: Find the area under a function
C
            CALL AREA01 (KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                   NEQN, NOUT, NPAR, NVAR, NX,
     +                   A, F, USER_FUNC, X, Y, YDE, YJA, Z,
     +                   MODNAM)
            IDEC = 2
         ELSEIF (IDEC.EQ.13) THEN
C
C IDEC = 13: Multiple integration
C
            CALL AREA0N (NEQN, NOUT, NVAR,
     +                   USER_SUB)
            IDEC = 2
         ELSEIF (IDEC.EQ.14) THEN
C
C IDEC = 14: Optimise
C
            CALL MINIMA (NEQN, NIN, NOUT, NPMAX, NVAR,
     +                   TEMP, W, XBOT, XMID, XTOP)
            IDEC = 2
         ELSEIF (IDEC.EQ.15) THEN
C
C IDEC = 15: Change a parameter
C
            NPTEMP = MAX(N1,NPAR)
            DO I = N1, NPTEMP
               TEMP(I,1) = A(I)
            ENDDO
            LINE = 'Edit the current parameters'
            CALL EDITOR (N2, N1, N1, NPMAX, NPTEMP, TEMP, LINE,
     +                   CURVE, FIXCOL, FIXROW, LABEL1, ORDER, WEIGHT)
            DO I = N1, NPTEMP
               A(I) = TEMP(I,1)
            ENDDO
            IF (PLOT) THEN
               IDEC = 3
            ELSEIF (EVAL) THEN
               IDEC = 2
            ELSEIF (READY) THEN
               IDEC = 8
            ENDIF
         ELSEIF (IDEC.EQ.16) THEN
C
C IDEC = 16: Input a set of parameters
C
            I = - N1
            CLOSE (UNIT = NIN)
            CALL VEC1IN (I, NIN, NPMAX, NPTEMP, W, FNAME, LINE, ABORT,
     +                   FIXNPT, LABEL)
            CLOSE (UNIT = NIN)
            IF (.NOT.ABORT .AND. NPTEMP.GT.N0) THEN
               DO I = N1, NPTEMP
                  A(I) = W(I)
               ENDDO
            ENDIF
            IF (PLOT) THEN
               IDEC = 3
            ELSEIF (EVAL) THEN
               IDEC = 2
            ELSEIF (READY) THEN
               IDEC = 8
            ENDIF
         ELSEIF (IDEC.EQ.17) THEN
C
C IDEC = 17: Change a y value
C
            NPTEMP = MAX(N1,NEQN,NVAR)
            DO I = N1, NPTEMP
               TEMP(I,1) = ZDE(I)
            ENDDO
            LINE = 'Edit the current y(i) values'
            CALL EDITOR (N2, N1, N1, NPMAX, NPTEMP, TEMP, LINE,
     +                   CURVE, FIXCOL, FIXROW, LABEL1, ORDER, WEIGHT)
            DO I = N1, NPTEMP
               ZDE(I) = TEMP(I,1)
               YDE(I) = ZDE(I)
            ENDDO
            IDEC = 5
         ELSEIF (IDEC.EQ.18) THEN
C
C IDEC = 18: Input a set of y(i,x)
C
            NPTEMP = MAX(N1,NEQN,NVAR)
            I = - N1
            CLOSE (UNIT = NIN)
            CALL VEC1IN (I, NIN, NX, NPTEMP, W, FNAME, LINE, ABORT,
     +                   FIXNPT, LABEL)
            CLOSE (UNIT = NIN)
            IF (.NOT.ABORT .AND. NPTEMP.GT.N0) THEN
               DO I = N1, NPTEMP
                  ZDE(I) = W(I)
                  YDE(I) = ZDE(I)
               ENDDO
            ENDIF
            IDEC = 5
         ELSEIF (IDEC.EQ.19) THEN
C
C IDEC = 19: Change EPSABS, EPSREL
C
            CALL GETDGE (EPSABS, ZERO,
     +     'Absolute error tolerance required (EPSABS)')
            CALL GETDGE (EPSREL, ZERO,
     +     'Relative error tolerance required (EPSREL)')
            IDEC = 7
         ELSEIF (IDEC.EQ.20) THEN
C
C IDEC = 20: Edit BLIM, TLIM
C
            NPTEMP = MAX(N1,NVAR)
            DO I = N1, NPTEMP
               TEMP(I,1) = BLIM(I)
               TEMP(I,2) = TLIM(I)
            ENDDO
            LINE = 'Edit the current blim(i)/tlim(i) values'
            CALL EDITOR (N2, N1, N2, NPMAX, NPTEMP,
     +                   TEMP, LINE,
     +                   CURVE, FIXCOL, FIXROW, LABEL1, ORDER, WEIGHT)
            DO I = N1, NPTEMP
               IF (TEMP(I,1).LE.TEMP(I,2)) THEN
                  BLIM(I) = TEMP(I,1)
                  TLIM(I) = TEMP(I,2)
               ELSE
                  WRITE (LINE,700) I, I
                  CALL PUTADV (LINE)
               ENDIF
            ENDDO
            IDEC = 7
         ELSEIF (IDEC.EQ.21) THEN
C
C IDEC = 21: Edit/View the current file
C
            STORE = .FALSE.
            CALL QNFILE (FNAME,
     +                   STORE)          
            INQUIRE (FILE = FNAME, EXIST = OK, IOSTAT = IOS)
            IF (IOS.EQ.0 .AND. OK) THEN
               MODE_OF_ACTION = 'Model is being edited'
               OPEN (UNIT = NIN, FILE = FNAME, IOSTAT = IOS)
               I = 0
               DO WHILE (IOS.EQ.0)
                  READ (NIN,'(A)',IOSTAT = IOS) LINE
                  IF (IOS.EQ.0) THEN
                     I = I + 1
                     TEXT(I) = LINE
                  ENDIF
               ENDDO
               CLOSE (NIN)
               IF (I.GE.9) THEN 
                  NLINES = I      
                  CALL FNAME_TO_FILEX (FILEX, FNAME, 
     +                                 ABORT) 
                  EDIT = .TRUE.  
                  CALL MODCHK (ABORT, EDIT)
                  IF (.NOT.ABORT) THEN
                     CALL USENOW (FILEX,
     +                            YESNO)              
                     IF (YESNO) THEN
                        MODE_OF_ACTION = 'The model has been edited' 
                        EVAL = .FALSE.
                        READY = .FALSE.
                        MULTI = .FALSE.
                        PLOT = .FALSE.
                        ZEROS = .FALSE.
                        DO I = N1, N24
                           MODNAM(I) = BLANK
                        ENDDO
                        MODNAM(2) = ' There is no current model file'
                        FNAME = FILEX
                        STORE = .TRUE.
                        CALL QNFILE (FNAME,
     +                               STORE)                 
                        DO_THIS = .FALSE.
                     ENDIF
                  ENDIF       
               ENDIF        
               IDEC = 2
            ELSE
               CALL PUTADV ('There is no current model file')
               IDEC = 1
            ENDIF
         ELSEIF (IDEC.EQ.22) THEN
C
C IDEC = 22: Start a new temporary file
C           
            CALL NEWMOD (IDEC, N1,
     +                   FILEX,
     +                   ABORT1)  
            CALL NEWMOD (IDEC, N2,
     +                   FILEX,
     +                   ABORT1)              
            CALL NEWMOD (IDEC, N3,
     +                   FILEX,
     +                   ABORT1) 
            IF (.NOT.ABORT1) THEN
               CALL USENOW (FILEX,
     +                      YESNO)              
               IF (YESNO) THEN
                  MODE_OF_ACTION = 'Temporary model has been created'
                  EVAL = .FALSE.
                  READY = .FALSE.
                  MULTI = .FALSE.
                  PLOT = .FALSE.
                  ZEROS = .FALSE.
                  DO I = N1, N24
                     MODNAM(I) = BLANK
                  ENDDO
                  MODNAM(2) = ' There is no current model file'
                  FNAME = FILEX
                  STORE = .TRUE.
                  CALL QNFILE (FILEX,
     +                         STORE)                 
                  DO_THIS = .FALSE.
               ENDIF   
            ENDIF     
            IDEC = 2
         ELSEIF (IDEC.EQ.23) THEN
C
C IDEC = 23: Show the current model equation
C
            STORE = .FALSE.
            CALL QNFILE (FNAME,
     +                   STORE)      
            INQUIRE (FILE = FNAME, EXIST = OK, IOSTAT = IOS)
            IF (IOS.EQ.0 .AND. .NOT.OK) THEN
               ICOLOR = 15
               CALL TABLE1 (ICOLOR, 'OPEN')
               ICOLOR = 0
               DO I = N1, N24
                  CALL TABLE1 (ICOLOR, MODNAM(I))
               ENDDO
               CALL TABLE1 (ICOLOR, 'CLOSE')
            ELSE   
               CALL VIEWER (JSEND,
     +                      FNAME, BLANK, BLANK)            
            ENDIF
            IDEC = 2
         ELSEIF (IDEC.EQ.24) THEN
C
C IDEC = 24: Plot parametric curves
C
            CALL PKURVE (KPAR,
     +                   QPAR)
            IDEC = 1
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Before closing down see if a logfile has been created
C
      IF (LOGFIL.NE.BLANK) THEN
         CLOSE (UNIT = NOUT)
         ISEND = 2
         CALL FNAMES (ISEND, LOGFIL)
      ENDIF
C
C======================================================================
C The program is finished so we can close down the background window
C
      CLOSE(UNIT = 6)
      CLOSE(UNIT = 8)
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND, TITLE, ACTION)
C
C======================================================================
C

C
C Format statements
C
  100 FORMAT ('y(',I3,',',1P,E11.3,') =',1P,E11.3,
     +', dy(',I3,')/dx =',E11.3)
  150 FORMAT ('y(',I3,',',1X,A,') =',1X,A,
     +', dy(',I3,')/dx =',1X,A)    
  200 FORMAT ('x, f(x) =',1P,2E11.3,': f(',I3,')')
  250 FORMAT ('x =',1X,A,' f(x) =',1X,A,': f(',I3,')')
  300 FORMAT ('x, y, g(x,y) =',1P,3E11.3,': g(',I3,')')
  350 FORMAT ('x =',1X,A,' y =',1X,A,' g(x,y) =',1X,A,': g(',I3,')')  
  400 FORMAT ('x, y, z, h(x,y,z) =',1P,4E11.3,': h(',I3,')')
  450 FORMAT ('x, y, z, h(x,y,z) =',4(1X,A),': h(',I3,')')
  500 FORMAT ('y(1) to y(4), f(y) =',1P,5E11.3,': f(',I3,')')
  550 FORMAT ('y(1) to y(4), f(y) =',5(1X,A),': f(',I3,')')
  600 FORMAT ('j(',I3,',',1P,E11.3,') =',1P,E11.3)
  650 FORMAT ('j(',I3,',',1X,A,') =',1X,A)  
  700 FORMAT (
     +'Refuse to accept blim(',I2,') > tlim(',I2,') ... Try again')
      END
C
C
