C
C USERMOD1.INS
C ============
C
C ADVISE
C DETAIL
C ISITOK
C NEWMOD
C USENOW
C
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (OUT) :: ABORT
      LOGICAL,             INTENT (IN)  :: FIRST
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 7, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER (LEN = 100) HEADER(NUMHDR)
      CHARACTER (LEN = 50 ) OPTION(NUMOPT)
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_USERMOD
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_USERMOD ('usermod')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `USERMOD'
     +/'        `      '
     +/'Action  `Reads in user-supplied-ascii-text-model-files'
     +/'        `to check syntax, plot, locate zeros, estimate'
     +/'        `integrals, or minimize user defined functions.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C
      SUBROUTINE DETAIL (IDEC, NOUT, 
     +                   LOGFIL,
     +                   EVAL, MULTI, OPTIMA, PLOT, READY, ZEROS)
      USE MODULE_USERMOD, ONLY : MODE_OF_ACTION, NO_FILE, FILEX, FNAME,
     +                           TEMP_FILE,  
     +                           NPMAX, NX, A, YDE, ZDE,
     +                           NEQN, NPAR, NVAR,
     +                           DEQN
C
C Decide  program options
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NOUT
      INTEGER,             INTENT (INOUT) :: IDEC
      CHARACTER (LEN = *), INTENT (INOUT) :: LOGFIL
      LOGICAL,             INTENT (INOUT) :: EVAL, MULTI, OPTIMA,
     +                                       PLOT, READY, ZEROS
C
C Locals
C      
      INTEGER    I
      INTEGER    NUMSTA, NUMTXT
      INTEGER    ISEND, NUMDEC, NUMOPT
      PARAMETER (ISEND = 1)
      INTEGER    NUMBLD(30), NUMPOS(30)
      INTEGER    IDEC_SAV, NUMDEC_SAV
      DOUBLE PRECISION AVAL, YVAL
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 1024) SIM256
      CHARACTER (LEN = 100 ) LINE, OPTS(30), WORD100(2), TRIM100, 
     +                       TEXT(19)
      CHARACTER (LEN = 8   ) NMF, SYMBOL(11)
      CHARACTER (LEN = 1   ) BLANK, PATH, PATTERN
      PARAMETER (BLANK = ' ', NMF = '   (NMF)')
      LOGICAL    ABORT, AGAIN, REPEET, STORE
      LOGICAL    FIRST
      PARAMETER (FIRST = .FALSE.)
      EXTERNAL   ADVISE
      EXTERNAL   PUTADV, GETD01, VIEWER, RESFIL, REVPRO, SIM256, LSTBOX,
     +           QNFILE, TRIM100
      EXTERNAL   SAVE_FILEX, MODEL_PARAMETERS
      SAVE       IDEC_SAV
      SAVE       AVAL, YVAL
      DATA       AVAL, YVAL / ONE, ZERO /
      DATA       NUMPOS / 30*1 /
      DATA       NUMBLD / 30*0 /
      DATA       IDEC_SAV,NUMDEC_SAV / 1, 18 /
C
C Part 1: retrieve the current parameters then set up the main menu
C =======
C
      STORE = .FALSE.
      CALL MODEL_PARAMETERS (NEQN, NPAR, NVAR,
     +                       DEQN, STORE)      
C
C Are we ready to evaluate ?
C
      DO I = 1, 11
         SYMBOL(I) = BLANK
      ENDDO   
      IF (.NOT.EVAL) THEN
         SYMBOL(1) = NMF
         SYMBOL(9) = NMF
         SYMBOL(11) = NMF
      ENDIF
C
C Are we ready to plot ?
C
      IF (.NOT.PLOT) SYMBOL(2) = NMF
C
C Are we ready to find zeros or integrals for 1 function of 1 variable ?
C
      IF (.NOT.READY) THEN
         SYMBOL(3) = NMF
         SYMBOL(5) = NMF
      ENDIF
C
C Are we ready for zeros for n functions of n variables ?
C
      IF (.NOT.ZEROS) SYMBOL(4) = NMF
C
C Are we ready to integrate n functions of m variables (m > 1)
C
      IF (.NOT.MULTI) SYMBOL(6) = NMF
C
C Are we ready to optimise n functions of m variables (m > 1)
C
      IF (.NOT.OPTIMA) SYMBOL(7) = NMF
C
C Part 2: Main branch point for repeated menu
C =======
C
      WRITE (TEXT,700)
      NUMDEC = IDEC
      REPEET = .TRUE.
      DO WHILE (REPEET)
         STORE = .FALSE.
         CALL QNFILE (FNAME,
     +                STORE)  
         IF (FNAME.EQ.BLANK) FNAME = NO_FILE
         WORD100(1) = TRIM100(FNAME)
         WORD100(2) = MODE_OF_ACTION         
         WRITE (OPTS,100) WORD100(1), WORD100(2), (SYMBOL(I), I = 1, 11)
         NUMOPT = 19
         NUMSTA = 8
         NUMTXT = NUMSTA + NUMOPT - 1
         NUMDEC = NUMDEC_SAV
         IF (NUMDEC.LT.1) THEN
            NUMDEC = 1
         ELSEIF (NUMDEC.GT.NUMOPT) THEN
            NUMDEC = NUMOPT
         ENDIF      
         NUMBLD(1) = 4
         NUMBLD(4) = 1
         NUMBLD(6) = 1
         CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                OPTS)
         NUMDEC_SAV = NUMDEC
         MODE_OF_ACTION = TEXT(NUMDEC)(1:80)
         NUMBLD(1) = 0
         NUMBLD(4) = 0
         NUMBLD(6) = 0
         REPEET = .FALSE.
C
C check that option selected is consistent
C         
         IF (NUMDEC.GE.2 .AND. NUMDEC.LT.10) THEN
            LOOP_CHECK: DO I = 2, 12
               IF (SYMBOL(NUMDEC - 1).EQ.NMF) THEN
                  WRITE (LINE,500)
                  CALL PUTADV (LINE)
                  NUMDEC = 0
                  REPEET = .TRUE.
                  EXIT LOOP_CHECK
               ENDIF   
            ENDDO LOOP_CHECK 
         ENDIF   
       
         IF (NUMDEC.EQ.1) THEN
C
C Part 3: NUMDEC = 1: Open a file ?
C =======
C
            FNAME = NO_FILE
            FILEX = NO_FILE
            STORE = .TRUE.
            CALL QNFILE (FNAME,
     +                   STORE)            
            IDEC = 1
            IDEC_SAV = IDEC        
            RETURN
         ELSEIF (NUMDEC.GT.0) THEN
C
C Add 6 to NUMDEC to ensure consistency with calling program
C
            NUMDEC = NUMDEC + 6
         ENDIF
C
C Part 4: Calculation has been requested so open a results log file
C =======
C
C                      4                  8
         IF (NUMDEC.GE.10 .AND. NUMDEC.LE.14) THEN
            IF (LOGFIL.EQ.BLANK) THEN
               CALL RESFIL (NOUT,
     +                      LOGFIL,
     +                      ABORT)
               WRITE (NOUT,300)
            ENDIF
         ENDIF
C                      9         
         IF (NUMDEC.EQ.15) THEN
C
C Part 5: User has requested to edit p, y, epserel, epsabs, bilm, tlim
C =======
C
            WRITE (OPTS,400)
            NUMDEC = 1
            NUMSTA = 10
            NUMOPT = 9
            NUMTXT = NUMSTA + NUMOPT - 1
            NUMBLD(1) = 1
            CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                   OPTS)
            NUMBLD(1) = 0
            IF (NUMDEC.EQ.1) THEN
C
C Return to edit p(i)
C
               NUMDEC = 15
               IDEC = NUMDEC
               RETURN
            ELSEIF (NUMDEC.EQ.2) THEN
C
C Return to read in a set of p(i)
C
               NUMDEC = 16
               IDEC = NUMDEC
               RETURN
            ELSEIF (NUMDEC.EQ.3) THEN
C
C Set all p(i) = constant
C
               REPEET = .TRUE.
               IDEC = 8
               NUMDEC = 0
               CALL GETD01 (AVAL, 'Constant required for all p(i)')
               DO I = 1, NPMAX
                  A(I) = AVAL
               ENDDO
            ELSEIF (NUMDEC.EQ.4) THEN
C
C Return to edit y(i)
C
               NUMDEC = 17
               IDEC = NUMDEC
               RETURN
            ELSEIF (NUMDEC.EQ.5) THEN
C
C Return to read in a set of y(i)
C
               NUMDEC = 18
               IDEC = NUMDEC
               RETURN
            ELSEIF (NUMDEC.EQ.6) THEN
C
C Set all y(i) = constant
C
               REPEET = .TRUE.
               IDEC = 8
               NUMDEC = 0
               CALL GETD01 (YVAL, 'Constant required for all y(i)')
               DO I = 1, NX
                  ZDE(I) = YVAL
                  YDE(I) = ZDE(I)
               ENDDO
            ELSEIF (NUMDEC.EQ.7) THEN
C
C Return to set epsabs and epsrel
C
               NUMDEC = 19
               IDEC = NUMDEC
               RETURN
            ELSEIF (NUMDEC.EQ.8) THEN
C
C Return to edit blim(i), tlim(i)
C
               NUMDEC = 20
               IDEC = NUMDEC
               RETURN
            ELSEIF (NUMDEC.EQ.9) THEN
C
C No action
C
               REPEET = .TRUE.
               IDEC = 8
               NUMDEC = 0
            ENDIF
         ELSEIF (NUMDEC.GT.15) THEN
C
C Part 6: Increment all NUMDEC values for NUMDEC > 15
C =======
C
            NUMDEC = NUMDEC + 5
         ENDIF
C
C Part 7: Create the warning message then check the choices made 
C =======
C
         WRITE (LINE,500)
C                      2: Check
         IF (NUMDEC.EQ.8 .AND. .NOT.EVAL) THEN
            CALL PUTADV (LINE)
            REPEET = .TRUE.
            IDEC = 1
            NUMDEC = 0
         ENDIF
C                      3: Plot         
         IF (NUMDEC.EQ.9 .AND. .NOT.PLOT) THEN
            CALL PUTADV (LINE)
            REPEET = .TRUE.
            IDEC = 1
            NUMDEC = 0
         ENDIF
         
         IF (.NOT.EVAL) THEN
C                          4: Zeros         6: Quadrature           
            IF (NUMDEC.EQ.10 .OR. NUMDEC.EQ.12) THEN
               CALL PUTADV (LINE)
               REPEET = .TRUE.
               IDEC = 1
               NUMDEC = 0
            ENDIF
         ENDIF
C          
c                      5: Multiple zeros         
         IF (NUMDEC.EQ.11 .AND. .NOT.ZEROS) THEN
            CALL PUTADV (LINE)
            REPEET = .TRUE.
            IDEC = 7
            NUMDEC = 0
         ENDIF
C                       7: Multiple quadrature
         IF (NUMDEC.EQ.13 .AND. .NOT.MULTI) THEN
            CALL PUTADV (LINE)
            REPEET = .TRUE.
            IDEC = 7
            NUMDEC = 0
         ENDIF
C                       8: Optimize          
         IF (NUMDEC.EQ.14 .AND. .NOT.OPTIMA) THEN
            CALL PUTADV (LINE)
            REPEET = .TRUE.
            IDEC = 7
            NUMDEC = 0
         ENDIF
C                      10: Edit         
         IF (NUMDEC.EQ.16) THEN
            REPEET = .FALSE.
            IDEC = 21
            NUMDEC = 0
         ENDIF


C                      12: View         
         IF (NUMDEC.EQ.18) THEN
            REPEET = .FALSE.
            IDEC = 23
            NUMDEC = 0
         ENDIF
  
C                         13: Parametric           
          IF (NUMDEC.EQ.19) THEN
             IDEC = 24
             RETURN
          ENDIF   
             
C                      14: Save As...          
         IF (NUMDEC.EQ.25) THEN
            CALL SAVE_FILEX (FILEX,
     +                       ABORT)            
            REPEET = .TRUE.
            IDEC = 8
            NUMDEC = 0
         ENDIF  
C                      15: View f$parser.tmp         
         IF (NUMDEC.EQ.26) THEN
            PATH = ' '
            PATTERN = ' '
            CALL VIEWER (ISEND,
     +                   TEMP_FILE, PATH, PATTERN) 
             REPEET = .TRUE.
            IDEC = 8
            NUMDEC = 0
         ENDIF
C                      16: Commands         
         IF (NUMDEC.EQ.27) THEN
            PATH = ' '
            PATTERN = ' '
            WRITE (OPTS,600)    
            AGAIN = .TRUE.
            DO WHILE (AGAIN)
               NUMOPT = 8
               NUMSTA = 8
               NUMTXT = NUMSTA + NUMOPT - 1
               NUMDEC = NUMOPT - 1
               NUMBLD(1) = 1
               NUMBLD(4) = 1
               NUMBLD(6) = 1
               CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                      OPTS)
               NUMBLD(1) = 0
               NUMBLD(4) = 0
               NUMBLD(6) = 0
               IF (NUMDEC.EQ.1) THEN
                  FNAME = SIM256('w_readme.f5')
               ELSEIF (NUMDEC.EQ.2) THEN
                  FNAME = SIM256('w_readme.f6')
               ELSEIF (NUMDEC.EQ.3) THEN
                  FNAME = SIM256('w_readme.f7')
               ELSEIF (NUMDEC.EQ.4) THEN
                  FNAME = SIM256('w_readme.f8')
               ELSEIF (NUMDEC.EQ.5) THEN
                  FNAME = SIM256('w_readme.f9')
               ELSEIF (NUMDEC.EQ.6) THEN
                  FNAME = SIM256('w_readme.f10')    
               ELSEIF (NUMDEC.EQ.7) THEN
                  FNAME = SIM256('commands.txt')
               ELSE
                  AGAIN = .FALSE.
               ENDIF
               IF (AGAIN) CALL VIEWER (ISEND,
     +                                 FNAME, PATH, PATTERN)
            ENDDO
            REPEET = .TRUE.
            IDEC = 8
            NUMDEC = 0
         ENDIF
C                      17: Results         
         IF (NUMDEC.EQ.28) THEN
            CALL REVPRO (NOUT)
            REPEET = .TRUE.
            IDEC = 8
            NUMDEC = 0
         ENDIF
C                      18: Help         
         IF (NUMDEC.EQ.29) THEN
            CALL ADVISE (BLANK,
     +                   ABORT, FIRST)
            REPEET = .TRUE.
            IDEC = 8
            NUMDEC = 0
         ENDIF
      ENDDO
C
C Part 8: Communicate the decision back to the main calling program
C =======
C
      IDEC = NUMDEC
C
C Format statements
C      
  100 FORMAT (
     + 'USERMOD options (NMF means no consistent model file)'
     +/
     +/'Current user-defined-model file:' 
     +/A
     +/'Current state:'
     +/A
     +/
     +/'Open       `A Simfit test file using [Demo] or your model file'
     +/'Check      `The current model', A
     +/'Plot       `The current model', A
     +/'Zeros for  `1 function of 1 variable', A
     +/'Zeros for  `n functions of n variables', A
     +/'Integrate  `1 function of 1 variable', A
     +/'Integrate  `n functions of m variables', A
     +/'Optimise   `1 function and n derivatives for n variables', A
     +/'Edit       `p, y, epsabs, epsrel, blim, tlim', A
     +/'Edit       `The current user-defined-model', A
     +/'Create     `A new user-defined model', A
     +/'View       `The current user-defined model', A
     +/'Plot       `Parametric equations (needs a special model file)'
     +/'Archive    `Save As .. the current temporary model file'
     +/'View       `Current f$parser.tmp (with expanding expressions)'
     +/'Commands   `Summary'
     +/'Results    `From Zeros/Integrate/Optimise procedures.'
     +/'Help       `Provide a summary of procedures available'
     +/'Quit       `Exit program USERMOD')
  300 FORMAT (
     +/1X,'PACKAGE: SIMFIT'
     +/1X,'PROGRAM: USERMOD'
     +/1X,'ACTION : Prepare/Check/Test/Apply User-defined models'
     +/1X,'AUTHOR : W.G.Bardsley, University of Manchester, U.K.')
  400 FORMAT (
     + 'Options to set p(i), y(i), epsabs, epsrel, blim, and tlim' 
     +/
     +/'p( )     `model parameters as in f(1) = p(1) + p(2)x + p(3)x^2'
     +/'y( )     `initial values (root-finding/differential equations)'
     +/'epsabs   `absolute error tolerance'
     +/'epsrel   `relative error tolerance'
     +/'blim     `bottom limits for integration/optimization'
     +/'tlim     `top limits for integration/optimization'
     +/
     +/'p( ) ... edit'
     +/'p( ) ... input from file'
     +/'p( ) ... set to a chosen value'
     +/'y( ) ... edit'
     +/'y( ) ... input from file'
     +/'y( ) ... set to a chosen value'
     +/'edit epsabs, epsrel'
     +/'edit blim, tlim'
     +/'Cancel ... No changes')
  500 FORMAT (
     +'No/wrong Model File ... First select an appropriate file')
  600 FORMAT (
     + 'Choose the information required'
     +/ 
     +/'A fuller discussion with examples is contained in'
     +/'          user_defined_models.html'
     +/'on the website, and also in the reference manual'
     +/'          w_manual.pdf.'
     +/  
     +/'w_readme.f5:  Summary of syntax'
     +/'w_readme.f6:  Global storage and submodels'
     +/'w_readme.f7:  Special functions'
     +/'w_readme.f8:  Operations with vectors'
     +/'w_readme.f9:  Integers and logicals'
     +/'w_readme.f10: Using standard expressions'
     +/'commands.txt: Summary of commands'
     +/'Cancel')
  700 format (   
     + 'Open a user-defined model file'
     +/'Check the current model'
     +/'Plot the current model'
     +/'Zeros for 1 function of 1 variable'
     +/'Zeros for n functions of n variables'
     +/'Integrate 1 function of 1 variable'
     +/'Integrate n functions of m variables'
     +/'Optimise  n+1 functions of n variables'
     +/'Edit/re-set y, epsabs, epsrel, blim, tlim'
     +/'Edit the current user-defined-model'
     +/'Create a new user-defined model'
     +/'View the current user-defined model'
     +/'Plot parametric equations'
     +/'Archive (i.e., Save As ..) the current temporary model file'
     +/'View the current f$parser.tmp file'
     +/'List and summary of commands'
     +/'Results from Zeros/Integrate/Optimise procedures.'
     +/'Provide a summary of procedures available'
     +/'Quit ... Exit program USERMOD')
      END
C
C
      SUBROUTINE ISITOK (FNAME_IN, 
     +                   OK)
C
C ACTION: See if the user is trying to edit a Simfit model file
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 26/11/99
C         04/06/2003 extended and corrected WORD6 error
C         03/02/2016 added test files with _E
C         09/02/2016 extensive revision to allow for long filenames, improve the
C                    logic, and leave scope for future development with addional filenames
C
C OK is returned as .FALSE. if the file is a Simfit model file and should not
C                           therefore be edited by program USERMOD
C OK is returned as .TRUE.  meaning it is not a model file so
C                           it is OK to edit by program USERMOD
C
C
      IMPLICIT  NONE
C
C Arguments
C      
      CHARACTER (LEN = *), INTENT (IN)  :: FNAME_IN
      LOGICAL,             INTENT (OUT) :: OK
C
C Locals
C          
      INTEGER    L
      CHARACTER (LEN = 1024) FNAME
      CHARACTER (LEN = 14  ) WORD14
      CHARACTER (LEN = 13  ) WORD13
      CHARACTER (LEN = 12  ) WORD12
      CHARACTER (LEN = 11  ) WORD11
      CHARACTER (LEN = 10  ) WORD10
      CHARACTER (LEN = 9   ) WORD9
      CHARACTER (LEN = 8   ) WORD8
      CHARACTER (LEN = 6   ) WORD6
      EXTERNAL  TRIML1, UCASE1
C
C Initialise OK = .true., copy FNAME, TRIM_LEFT and call LCASE1
C      
      OK = .TRUE.
      FNAME = FNAME_IN
      CALL TRIML1 (FNAME)
      CALL UCASE1 (FNAME)
      L = LEN_TRIM(FNAME)
C
C Go systematically through FNAME(K:L) to trap Simfit demonstration model files
C 

C
C WORD6
C
      IF (L.GE.6) THEN
         WORD6 = FNAME(L - 5:L)  
         IF (WORD6.EQ.'IF.MOD') THEN
            OK = .FALSE.
            RETURN
         ENDIF   
      ELSE
         RETURN     
      ENDIF
C
C WORD8
C     
      IF (L.GE.8) THEN
         WORD8 = FNAME(L - 7:L)  
         IF (WORD8.EQ.'ROSE.MOD' .OR. 
     +       WORD8.EQ.'IF_E.MOD') THEN
            OK = .FALSE.
            RETURN
         ENDIF
      ELSE
         RETURN  
      ENDIF
C
C WORD9
C     
      IF (L.GE.9) THEN
         WORD9 = FNAME(L - 8:L)  
         IF (WORD9.EQ.'HELIX.MOD' .OR.
     +       WORD9.EQ.'LINE3.MOD' .OR.
     +       WORD9.EQ.'CHEBY.MOD' .OR.
     +       WORD9.EQ.'CHEBY.DAT' .OR.
     +       WORD9.EQ.'USER1.MOD') THEN
            OK = .FALSE.
            RETURN
         ENDIF
      ELSE
         RETURN   
      ENDIF
C
C WORD10
C     
      IF (L.GE.10) THEN
         WORD10 = FNAME(L - 9:L)  
         IF (WORD10.EQ.'D01FCF.MOD' .OR.
     +       WORD10.EQ.'DEQMAT.TF1' .OR.
     +       WORD10.EQ.'DEQMAT.TF2' .OR.
     +       WORD10.EQ.'UPDOWN.MOD' .OR. 
     +       WORD10.EQ.'ROSE_E.MOD') THEN
            OK = .FALSE.
            RETURN
         ENDIF
      ELSE
         RETURN   
      ENDIF
C
C WORD11
C     
      IF (L.GE.11) THEN
         WORD11 = FNAME(L - 10:L)  
         IF (WORD11.EQ.'DEQMOD1.TF1' .OR.
     +       WORD11.EQ.'DEQMOD1.TF2' .OR.
     +       WORD11.EQ.'DEQMOD1.TF3' .OR.
     +       WORD11.EQ.'DEQMOD1.TF4' .OR.
     +       WORD11.EQ.'DEQMOD1.TF5' .OR.
     +       WORD11.EQ.'DEQMOD1.TF6' .OR.
     +       WORD11.EQ.'DEQMOD2.TF1' .OR.
     +       WORD11.EQ.'DEQMOD2.TF2' .OR.
     +       WORD11.EQ.'DEQMOD2.TF3' .OR.
     +       WORD11.EQ.'DEQMOD4.TF1' .OR.
     +       WORD11.EQ.'DEQPAR1.TF1' .OR.
     +       WORD11.EQ.'DEQPAR1.TF2' .OR.
     +       WORD11.EQ.'DEQPAR1.TF3' .OR.
     +       WORD11.EQ.'DEQPAR1.TF4' .OR.
     +       WORD11.EQ.'DEQPAR1.TF5' .OR.
     +       WORD11.EQ.'DEQPAR1.TF6' .OR.
     +       WORD11.EQ.'DEQPAR2.TF1' .OR.
     +       WORD11.EQ.'DEQPAR2.TF2' .OR.
     +       WORD11.EQ.'DEQPAR2.TF3' .OR.
     +       WORD11.EQ.'DEQPAR4.TF1' .OR.
     +       WORD11.EQ.'ELLIPSE.MOD' .OR.
     +       WORD11.EQ.'OPTIMUM.MOD' .OR.
     +       WORD11.EQ.'TWISTER.MOD' .OR.
     +       WORD11.EQ.'IMPULSE.MOD' .OR.
     +       WORD11.EQ.'HELIX_E.MOD' .OR.
     +       WORD11.EQ.'LINE3_E.MOD' .OR.
     +       WORD11.EQ.'CHEBY_E.MOD' .OR.
     +       WORD11.EQ.'CHEBY_E.DAT' .OR.
     +       WORD11.EQ.'USER1_E.MOD') THEN
            OK = .FALSE.
            RETURN
         ENDIF
      ELSE
         RETURN   
      ENDIF
C
C WORD12
C     
      IF (L.GE.12) THEN
         WORD12 = FNAME(L - 11:L)  
         IF (WORD12.EQ.'CONVOLVE.MOD' .OR.
     +       WORD12.EQ.'CONVOLV3.MOD' .OR.
     +       WORD12.EQ.'FAMILY2D.MOD' .OR.
     +       WORD12.EQ.'FAMILY3D.MOD' .OR.
     +       WORD12.EQ.'PERIODIC.MOD' .OR.
     +       WORD12.EQ.'UPDOWNUP.MOD' .OR.
     +       WORD12.EQ.'USERMOD1.TF1' .OR.
     +       WORD12.EQ.'USERMOD1.TF2' .OR.
     +       WORD12.EQ.'USERMOD1.TF3' .OR.
     +       WORD12.EQ.'USERMOD1.TF4' .OR.
     +       WORD12.EQ.'USERMOD1.TF5' .OR.
     +       WORD12.EQ.'USERMOD1.TF6' .OR.
     +       WORD12.EQ.'USERMOD1.TF7' .OR.
     +       WORD12.EQ.'USERMOD1.TF8' .OR.
     +       WORD12.EQ.'USERMOD1.TF9' .OR.
     +       WORD12.EQ.'USERMOD2.TF1' .OR.
     +       WORD12.EQ.'USERMOD3.TF1' .OR.
     +       WORD12.EQ.'USERMODD.TF1' .OR.
     +       WORD12.EQ.'USERMODN.TF1' .OR.
     +       WORD12.EQ.'USERMODN.TF2' .OR.
     +       WORD12.EQ.'USERMODN.TF3' .OR.
     +       WORD12.EQ.'USERMODN.TF4' .OR.
     +       WORD12.EQ.'USERMODS.TF1' .OR.
     +       WORD12.EQ.'USERMODS.TF2' .OR.
     +       WORD12.EQ.'USERMODS.TF3' .OR.
     +       WORD12.EQ.'USERMODX.TF1' .OR.
     +       WORD12.EQ.'USERMODX.TF2' .OR.
     +       WORD12.EQ.'USERMODX.TF3' .OR.
     +       WORD12.EQ.'USERMODX.TF4' .OR.
     +       WORD12.EQ.'USERMODX.TF5' .OR.
     +       WORD12.EQ.'D01FCF_E.MOD' .OR.
     +       WORD12.EQ.'DEQMAT_E.TF1' .OR.
     +       WORD12.EQ.'DEQMAT_E.TF2' .OR.
     +       WORD12.EQ.'UPDOWN_E.MOD') THEN
            OK = .FALSE.
            RETURN
         ENDIF
      ELSE
         RETURN   
      ENDIF
C
C WORD13
C     
      IF (L.GE.13) THEN
         WORD13 = FNAME(L - 12:L)  
         IF (WORD13.EQ.'DEQMOD1_E.TF1' .OR.
     +       WORD13.EQ.'DEQMOD1_E.TF2' .OR.
     +       WORD13.EQ.'DEQMOD1_E.TF3' .OR.
     +       WORD13.EQ.'DEQMOD1_E.TF4' .OR.
     +       WORD13.EQ.'DEQMOD1_E.TF5' .OR.
     +       WORD13.EQ.'DEQMOD1_E.TF6' .OR.
     +       WORD13.EQ.'DEQMOD2_E.TF1' .OR.
     +       WORD13.EQ.'DEQMOD2_E.TF2' .OR.
     +       WORD13.EQ.'DEQMOD2_E.TF3' .OR.
     +       WORD13.EQ.'DEQMOD4_E.TF1' .OR.
     +       WORD13.EQ.'DEQPAR1_E.TF1' .OR.
     +       WORD13.EQ.'DEQPAR1_E.TF2' .OR.
     +       WORD13.EQ.'DEQPAR1_E.TF3' .OR.
     +       WORD13.EQ.'DEQPAR1_E.TF4' .OR.
     +       WORD13.EQ.'DEQPAR1_E.TF5' .OR.
     +       WORD13.EQ.'DEQPAR1_E.TF6' .OR.
     +       WORD13.EQ.'DEQPAR2_E.TF1' .OR.
     +       WORD13.EQ.'DEQPAR2_E.TF2' .OR.
     +       WORD13.EQ.'DEQPAR2_E.TF3' .OR.
     +       WORD13.EQ.'DEQPAR4_E.TF1' .OR.
     +       WORD13.EQ.'ELLIPSE_E.MOD' .OR.
     +       WORD13.EQ.'OPTIMUM_E.MOD' .OR.
     +       WORD13.EQ.'TWISTER_E.MOD' .OR.
     +       WORD13.EQ.'IMPULSE_E.MOD') THEN
            OK = .FALSE.
            RETURN
         ENDIF
      ELSE
         RETURN   
      ENDIF
C
C WORD14
C     
      IF (L.GE.14) THEN
         WORD14 = FNAME(L - 13:L)
         IF (WORD14.EQ.'CONVOLVE_E.MOD' .OR.
     +       WORD14.EQ.'CONVOLV3_E.MOD' .OR.
     +       WORD14.EQ.'FAMILY2D_E.MOD' .OR.
     +       WORD14.EQ.'FAMILY3D_E.MOD' .OR.
     +       WORD14.EQ.'PERIODIC_E.MOD' .OR.
     +       WORD14.EQ.'UPDOWNUP_E.MOD' .OR.
     +       WORD14.EQ.'USERMOD1_E.TF1' .OR.
     +       WORD14.EQ.'USERMOD1_E.TF2' .OR.
     +       WORD14.EQ.'USERMOD1_E.TF3' .OR.
     +       WORD14.EQ.'USERMOD1_E.TF4' .OR.
     +       WORD14.EQ.'USERMOD1_E.TF5' .OR.
     +       WORD14.EQ.'USERMOD1_E.TF6' .OR.
     +       WORD14.EQ.'USERMOD1_E.TF7' .OR.
     +       WORD14.EQ.'USERMOD1_E.TF8' .OR.
     +       WORD14.EQ.'USERMOD1_E.TF9' .OR.
     +       WORD14.EQ.'USERMOD2_E.TF1' .OR.
     +       WORD14.EQ.'USERMOD3_E.TF1' .OR.
     +       WORD14.EQ.'USERMODD_E.TF1' .OR.
     +       WORD14.EQ.'USERMODN_E.TF1' .OR.
     +       WORD14.EQ.'USERMODN_E.TF2' .OR.
     +       WORD14.EQ.'USERMODN_E.TF3' .OR.
     +       WORD14.EQ.'USERMODN_E.TF4' .OR.
     +       WORD14.EQ.'USERMODS_E.TF1' .OR.
     +       WORD14.EQ.'USERMODS_E.TF2' .OR.
     +       WORD14.EQ.'USERMODS_E.TF3' .OR.
     +       WORD14.EQ.'USERMODX_E.TF1' .OR.
     +       WORD14.EQ.'USERMODX_E.TF2' .OR.
     +       WORD14.EQ.'USERMODX_E.TF3' .OR.
     +       WORD14.EQ.'USERMODX_E.TF4' .OR.
     +       WORD14.EQ.'USERMODX_E.TF5') THEN
            OK = .FALSE.
            RETURN
         ENDIF
      ELSE
         RETURN   
      ENDIF
      END
C
c
      subroutine newmod (idec, isend, 
     +                   filex, 
     +                   abort)
      use module_usermod, only : nhigh, nlines, nwide,
     +                           mode_of_action, text,
     +                           neqn, npar, nvar,
     +                           deqn      
c
c action: develop user-defined-model files in program usermod
c author: w.g.bardsley, university of manchester, u.k., 10/02/2016
c
c isend = 1: return idec = model type and abort = .true. only if Cancel is selected
c isend = 2: use idec from a call with isend = 1 to set the model parameters
c isend = 3: define npar then create a temporary model file after calls with
c            isend = 1 then 2
c 
c The case isend = 1 is when called from either DETAIL or MAIN
c The case isend = 2 is called from MAIN either after a return from DETAIL 
c                    or when creating a temporary model file
c The case isend = 3 is when creating a temporary model file in MAIN. It returns
c                    abort = .true. and filex = blank if a file cannot be created
c     
      implicit none
c
c arguments
c      
      integer, intent (inout)             :: idec  
      integer, intent (in)                :: isend
      character (len = *), intent (inout) :: filex
      logical, intent (out)               :: abort
c
c locals
c
      integer    iadd1, icount, l, nstop
      integer    n0, n1, n2, n3, nx
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, nx = 100)
      integer    i, ios, numdec, numopt, numsta, numtxt
      parameter (numsta = 8, numopt = 9)
      integer    numbld(30)
      integer    nout
      character (len = nwide) lines(4), line_1, lines_15(15)
      character (len = 1024 ) temp_file, usr
      character (len = 12   ) word12
      character (len = 6    ) mod6
      parameter (mod6 = 'model_')
      character (len = 4    ) cipher, tmp4
      parameter (tmp4 = '.tmp')
      character (len = 1    ) blank, bslash
      parameter (blank = ' ', bslash = '\')
      logical    check_equations, check_parameters, check_variables
      logical    first, repeet, there
      logical    edit
      parameter (edit = .true.)
      external   lstbox, patch2, getjm1, edittx, getnou, usrdir, modchk
      save       icount, l 
      save       usr
      save       first
      data       icount, l / 0, 1 /
      data       usr / blank /
      data       first /.true. /  
      data       numbld / 1*1, 29*0 /
c
c initialise abort then check
c
      abort = .false.   
      check_equations = .false.
      check_parameters = .false.
      check_variables = .false.
      if (idec.lt.1 .or. idec.gt.numopt - 2) idec = numopt - 1
      if (neqn.le.0 .or. neqn.gt.nx) neqn = 1
      if (nvar.le.0 .or. nvar.gt.nx) nvar = 1  
      if (npar.lt.0 .or. npar.gt.nx) npar = 0  
      if (deqn) then
         nvar = 1
         cipher = ' Yes'
      else
         cipher = '  No'
      endif    
      
      if (isend.eq.1) then
c
c isend = 1: choose idec
c        
         repeet = .true.
         do while (repeet) 
            write (text,100) neqn, nvar, npar, cipher
            numdec = idec
            numtxt = numsta + numopt - 1
            call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                   text)
            repeet = .false.
            if (numdec.eq.numopt) then
               abort = .true.
            elseif (numdec.eq.numopt - 1) then
               repeet = .true. 
               write (text,200) 
               numtxt = 20 
               call patch2 (numbld, numtxt,
     +                      text)
               numdec = 1               
            else
               idec = numdec
            endif
         enddo   
      elseif (isend.eq.2) then  
c
c isend = 2: define neqn, nvar, deqn
c        
         IF (IDEC.EQ.1) THEN
            NEQN = N1
            NVAR = N1
            DEQN  = .FALSE.
         ELSEIF (IDEC.EQ.2) THEN
            NEQN = N1
            CALL GETJM1 (N1, NEQN, NX,
     +'Number of equations in the file to be supplied')
            NVAR = N1
            DEQN = .FALSE.
         ELSEIF (IDEC.EQ.3) THEN
            NEQN = N1
            NVAR = N2
            DEQN = .FALSE.
         ELSEIF (IDEC.EQ.4) THEN
            NEQN = N1
            NVAR = N3
            DEQN = .FALSE.
         ELSEIF (IDEC.EQ.5) THEN
            NEQN = N1
            NVAR = N1
            DEQN = .TRUE.
         ELSEIF (IDEC.EQ.6) THEN
            NEQN = N1
            CALL GETJM1 (N1, NEQN, NX,
     +'The number of differential equations in the system')
            NVAR = N1
            DEQN = .TRUE.
         ELSEIF (IDEC.EQ.7) THEN
            NEQN = N1
            CALL GETJM1 (N1, NEQN, NX,
     +'Number of equations in the file to be supplied')
            NVAR = N1
            CALL GETJM1 (N1, NVAR, NX,
     +'Number of variables in file to be supplied')
            DEQN = .FALSE. 
         ENDIF 
      elseif (isend.eq.3) then 
c
c isend = 3: create a model file
c
         if (first) then
            first = .false.
            call usrdir (l,
     +                   usr)
            if (usr(l:l).ne.bslash) then
               l = l + 1
               usr(l:l) = bslash             
            endif
             icount = 0
         endif  
         temp_file = usr(1:l)//'current_model_number.tmp'
         inquire (file = temp_file, exist = there, iostat = ios)
         call getnou (nout)
         open (unit = nout, file = temp_file, iostat = ios)
         if (ios.eq.0 .and. there) then
            read (nout,*,iostat=ios) i
            if (ios.eq.0) icount = i 
         else
            if (ios.eq.0) write (nout,'(i3)',iostat=ios) icount
            if (ios.eq.0) write (nout,'(a)',iostat=ios)
     +'Current user temporary model file number k where 0 =< k =< 20'              
         endif
         close (unit = nout)
         
         icount = icount + 1
         if (icount.lt.1 .or. icount.gt.20) icount = 1
         call getnou (nout)
         open (unit = nout, file = temp_file, iostat = ios)
         if (ios.eq.0) write (nout,'(i3)',iostat=ios) icount
         if (ios.eq.0) write (nout,'(a)',iostat=ios)
     +'Current user temporary model file number k where 0 =< k =< 20'
         close (unit = nout)
         
         call getjm1 (n0, npar, nx,
     +'Number of parameters required for this model')   

         if (neqn.eq.1) then
            write (lines(1),'(i1,a)') neqn, ' equation'
         elseif (neqn.lt.10) then
            write (lines(1),'(i1,a)') neqn, ' equations'
         elseif (neqn.lt.100) then      
            write (lines(1),'(i2,a)') neqn, ' equations'
         else   
            write (lines(1),'(i3,a)') neqn, ' equations'
         endif

         if (deqn) then
            write (lines(2),'(a)')'differential equation'
            nvar = 1
         else   
            if (nvar.eq.1) then
               write (lines(2),'(i1,a)') nvar, ' variable'
            elseif (nvar.lt.10) then
               write (lines(2),'(i1,a)') nvar, ' variables'   
            elseif (nvar.lt.100) then      
               write (lines(2),'(i2,a)') nvar, ' variables'
            else   
               write (lines(2),'(i3,a)') nvar, ' variables'
            endif
         endif
         
         if (npar.eq.1) then
            write (lines(3),'(i1,a)') npar, ' parameter'
         elseif (npar.lt.10) then
            write (lines(3),'(i1,a)') npar, ' parameters'   
         elseif (npar.lt.100) then      
            write (lines(3),'(i2,a)') npar, ' parameters'
         else   
            write (lines(3),'(i3,a)') npar, ' parameters'
         endif
      
c         if (deqn .or. nvar.gt.3) then
c            lines(4) = '1.0 + y(1)'
c         elseif (nvar.eq.1) then
c            lines(4) = 'x'
c         elseif (nvar.eq.2) then
c            lines(4) = 'x + y' 
c         elseif (nvar.eq.3) then
c            lines(4) = 'x + y + z'     
c         endif
         lines(4) = 'f(1) =' 
         
         write (lines_15,1000) (lines(i), i = 1, 4)
         
         do i = 1, nhigh
            text(i) = blank
         enddo
            
         iadd1 = 0
         do i = 1, 15
            iadd1 = iadd1 + 1
            text(iadd1) = lines_15(i)
         enddo
         
         if (neqn.gt.1) then
            iadd1 = 13
            do i = 2, neqn 
               iadd1 = iadd1 + 1
               if (i.lt.10) then
                  write (text(iadd1),'(a,i1,a)') 'f(', i, ') ='
               elseif (i.lt.100) then 
                  write (text(iadd1),'(a,i2,a)') 'f(', i, ') =' 
               else
                  write (text(iadd1),'(a,i3,a)') 'f(', i, ') ='
               endif      
            enddo    
            iadd1 = iadd1 + 1
            text(iadd1) = 'end{expression}'
            iadd1 = iadd1 + 1
            text(iadd1) = '%'
         endif
         
         if (neqn.gt.1 .and. check_equations) then
            iadd1 = iadd1 + 1
            text(iadd1) =
     +'! Advice...make sure all equations are defined'
            do i = 2, neqn
               iadd1 = iadd1 + 1
               text(iadd1) = '1.0'
               if (i.lt.10) then
                  write (line_1,'(a,i1,a)') 'f(',i,')'
               elseif (i.lt.100) then
                  write (line_1,'(a,i2,a)') 'f(',i,')'
               else   
                  write (line_1,'(a,i3,a)') 'f(',i,')'  
               endif
               iadd1 = iadd1 + 1
               text(iadd1) = line_1
            enddo  
         endif

         if (npar.gt.0 .and. check_parameters) then
            iadd1 = iadd1 + 1
            text(iadd1) = 
     +'! Advice...make sure all parameters are used'
            do i = 1, npar
               if (i.lt.10) then
                  write (line_1,'(a,i1,a)') 'p(',i,')'
               elseif (i.lt.100) then
                  write (line_1,'(a,i2,a)') 'p(',i,')'
               else   
                  write (line_1,'(a,i3,a)') 'p(',i,')'  
               endif
               iadd1 = iadd1 + 1
               text(iadd1) = line_1
               iadd1 = iadd1 + 1      
               text(iadd1) = 'pop'
            enddo  
         endif
         
         if (nvar.gt.3 .and. check_variables) then
            iadd1 = iadd1 + 1
            text(iadd1) = 
     +'! Advice...make sure all variables are used'
            do i = 2, nvar
               if (i.lt.10) then
                  write (line_1,'(a,i1,a)') 'y(',i,')'
               elseif (i.lt.100) then
                  write (line_1,'(a,i2,a)') 'y(',i,')'
               else   
                  write (line_1,'(a,i3,a)') 'y(',i,')'  
               endif
               iadd1 = iadd1 + 1
               text(iadd1) = line_1
               iadd1 = iadd1 + 1
               text(iadd1) = 'pop'
            enddo  
         endif

         if (deqn .and. neqn.gt.1 .and. check_equations) then
            iadd1 = iadd1 + 1
            text(iadd1) = 
     +'! Advice...make sure all components are used'
            do i = 2, neqn
               if (i.lt.10) then
                  write (line_1,'(a,i1,a)') 'y(',i,')'
               elseif (i.lt.100) then
                  write (line_1,'(a,i2,a)') 'y(',i,')'
               else   
                  write (line_1,'(a,i3,a)') 'y(',i,')'  
               endif
               iadd1 = iadd1 + 1
               text(iadd1) = line_1
               iadd1 = iadd1 + 1
               text(iadd1) = 'pop'
            enddo  
         endif
         
c         iadd1 = iadd1 + 1
c         text(iadd1) = '%'
         
         call edittx (nhigh, nlines, nwide,
     +                text)
         
         call modchk (abort, edit)
     
         if (abort) then
            filex = blank
            return
         endif      
            
         if (icount.lt.10) then
            write (word12,'(a,i1,a)',iostat=ios) mod6, icount, tmp4
         else 
            write (word12,'(a,i2,a)',iostat=ios) mod6, icount, tmp4  
         endif 
         filex = usr(1:l)//word12   
         call getnou (nout)
         open (unit = nout, file = filex, iostat = ios)  
         if (ios.eq.0) then
            abort = .false.    
            do i = nhigh, 1, -1
               if (text(i).ne.blank) then
                  nstop = i
                  exit
               endif
            enddo      
            do i = 1, nstop
               if (text(i).ne.blank) write (nout,'(a)',iostat=ios)
     +                                      text(i)
            enddo
            mode_of_action = 'A temporary model has been created'
         else
            abort = .true.
            filex = blank
         endif      
         close (unit = nout)
      endif
c
c format statements
c      
  100 format (
     + 'Select the type of model file required'
     +/
     +/'Number of equations =',i3
     +/'Number of variables =',i3
     +/'Number of parameters =',i3
     +/'Differential equation:',a
     +/
     +/'1 function of 1 variable'
     +/'n functions of 1 variable'
     +/'1 function of 2 variables'
     +/'1 function of 3 variables'
     +/'1 differential equation'
     +/'n differential equations'
     +/'n functions of m variables'
     +/'Help'
     +/'Cancel ... Accept current values')
  200 format (
     + 'Details of the model type required'
     +/
     +/'In order to check if a user-defined-model file is formatted'
     +/'correctly several parameters now listed must be specified.'
     +/
     +/'NEQN`Either the number of independent functions supplied or the'
     +/'    `number of equations in a system of differential equations.' 
     +/  
     +/'NVAR`The number of variables required which will obviously be'
     +/'    `one by default in a system of differential equations.'
     +/
     +/'NPAR`The number of parameters required. If NPAR = 0 the model'
     +/'    `cannot be used for curve-fitting.'
     +/
     +/'DEQN`model is a system of one or more differential equations.'
     +/
     +/'Once these details have been set a model will not be accepted'
     +/'for checking, plotting, etc. unless the data declared on the'
     +/'second section of the user-supplied-model file are consistent'
     +/'with the values for NEQN, NVAR and DEQN.')   
 1000 format (
     + '%'
     +/'This is a default template for a user-defined-model file.'
     +/'Edit as required then read this file back into program'
     +/'usermod to check, use, or continue with further editing.'
     +/'Finally re-name the file to prevent over-writing or select' 
     +/'the Archive (Save As...) option from the main USERMOD menu.'
     +/'%'
     +/a
     +/a
     +/a
     +/'%'
     +/'begin{expression}'
     +/a
     +/'end{expression}'
     +/'%')
      end
c
c      
      subroutine usenow (fname,
     +                   yesno)
      implicit none
c
c arguments
c      
      character (len = *), intent (in)  :: fname
      logical,             intent (out) :: yesno
c
c locals
c      
      integer    ios
      integer    icolor, ixl, iyl, lshade, numcol, numrow, numtxt
      parameter (icolor = 9, ixl = 0, iyl = 0, lshade = 0,
     +           numtxt = 9) 
      character (len = 100) word100, trim100, text(numtxt) 
      character (len = 80 ) line 
      logical    there
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      external   yesno1, trim100
      inquire (file = fname, exist = there, iostat = ios)
      if (ios.eq.0 .and. there) then
          word100 = trim100(fname)
          if (index(fname,'model_xx.tmp').gt.0) then 
             write (text,100) word100
          else
             write (text,200) word100
          endif      
          write (line,300)
          yesno = .true. 
          CALL YESNO1 (ICOLOR, IXL, IYL, LSHADE, NUMCOL, NUMROW,
     +                 NUMTXT,
     +                 LINE, TEXT,
     +                 BORDER, FLASH, HIGH, YESNO)
      else
         yesno = .false.
      endif
c
c format statements
c   
  100 format (
     + 'The following temporary user-defined-model file is now ready:'
     +/
     +/a
     +/
     +/'This is a default file name reserved for any models that are'
     +/'curently being edited to correct errors or alter functionality.'
     +/'If it proves to be a successful model then you can archive it'
     +/'using the Save As .. option from the main USERMOD menu.' 
     +/)   
  200 format (
     + 'The following temporary user-defined-model file is now ready:'
     +/
     +/a
     +/
     +/'You should take note of this file name if you want to read it'
     +/'in now. If it is what you want you must then archive it, else'
     +/'it will eventually get over-written by one of the subsequent'
     +/'temporary user-defined-model files. (Up to 20 are stored).' 
     +/)
  300 format ('Read this file in to check, etc.')    
      end
c
c     





