C
C
C USERMOD2.INS
C ============
C
C PLOT01
C PLOT02
C
C
      SUBROUTINE PLOT01 (KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                   NEQN, NPAR, NVAR, NX,
     +                   A, F, Y, YDE, YJA, Z,
     +                   MODNAM)
C
C
C ACTION : Plot a user supplied function
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 14/8/96
C          19/08/96 Only changes JSAV, L, M, etc. on request. If a
C                   new model is used with fewer equations, the JSAV is
C                   saved but K is set to I not JSAV(i) for I > NEQN
C          18/10/2001 revised to call QNUSER
C          04/06/2003 revised and increased options for coordinates
C
      IMPLICIT   NONE
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      INTEGER    NEQN, NPAR, NVAR, NX
      INTEGER    ISEND, NMAX
      PARAMETER (ISEND = 2, NMAX = 1000)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NSTART = 16,
     +           NTEXT = 20)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NTEXT)
      INTEGER    I, JSAV(100), K(100), L(12), M(12), NPTS, NPTVAL
      INTEGER    JSEND, JTYPE, NCOLS, NIN
      PARAMETER (JTYPE = 1, NCOLS = 1)
      INTEGER    IBOT, ISTART, ITOP, ITEXT
      INTEGER    L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12,
     +           M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12,
     +           N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12
      DOUBLE PRECISION A(KMAX_A), F(KMAX_F), Y,
     +                 YDE(KMAX_Y), YJA(KMAX_J), Z
      DOUBLE PRECISION XDELTA, XSTART, XSTOP, XTEMP, X1(NMAX),
     +                 Y1(NMAX), Y2(NMAX), Y3(NMAX), Y4(NMAX),
     +                 Y5(NMAX), Y6(NMAX), Y7(NMAX), Y8(NMAX),
     +                 Y9(NMAX), Y10(NMAX), Y11(NMAX), Y12(NMAX)
      DOUBLE PRECISION XVALS(NMAX)
      DOUBLE PRECISION ONE, TEN
      PARAMETER (ONE = 1.0D+00, TEN = 10.0D+00)
      CHARACTER  MODNAM(24)*80
      CHARACTER  PTITLE*31, XTITLE*1, YTITLE*1
      PARAMETER (PTITLE = 'Selected y(i) as functions of x',
     +           XTITLE = 'x', YTITLE = 'y')
      CHARACTER (LEN = 10) D10(2), FORMGR
      CHARACTER (LEN = 12) I12, FORM12
      CHARACTER  LINE*100, SYMBOL(12)*3, TEXT(30)*100
      CHARACTER  LTYPE(0:4)*12, MTYPE(0:16)*14
      CHARACTER  LTYPE1(12)*12, MTYPE1(12)*14
      CHARACTER  FI(12)*3, YI(12)*3
      CHARACTER  FNAME*1024, TITLE*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, DEQN, FIRST, FIXNPT, GSAVE, LABEL
      PARAMETER (DEQN = .FALSE., FIXNPT = .FALSE., GSAVE = .TRUE.,
     +           LABEL = .TRUE.)
      LOGICAL    CURVE, FIXCOL, FIXROW, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .FALSE.,
     +           ORDER = .FALSE., WEIGHT = .FALSE.)
      LOGICAL    PLOT(12), REPEET
      LOGICAL    OK, TAB_ALL
      EXTERNAL   FORMGR, FORM12
      EXTERNAL   QNUSER, GKS012, LBOX01, GETJM1, GETDG2, YESNO2, GETNOU,
     +           VEC1IN, EDITOR, PUTADV, LBOX02
      INTRINSIC  MIN, DBLE, TRIM
      SAVE       JSAV, L, M, NPTS, XSTART, XSTOP, X1, PLOT, LTYPE, MTYPE
      SAVE       FIRST
      DATA       FIRST / .TRUE. /
      DATA       NUMBLD / 2*0, 1*1, 12*0, 5*0 /
      DATA       NUMPOS / NTEXT*1 /
      DATA       LTYPE / '        none',
     +                   '       solid',
     +                   '      dotted',
     +                   '      dashed',
     +                   ' dash-dotted' /
      DATA       MTYPE / '          none',
     +                   '         point',
     +                   '          plus',
     +                   '         cross',
     +                   '      asterisk',
     +                   '        circle',
     +                   '   half-circle',
     +                   '   full-circle',
     +                   '      triangle',
     +                   ' half-triangle',
     +                   ' full-triangle',
     +                   '        square',
     +                   '   half-square',
     +                   '   full-square',
     +                   '       diamond',
     +                   '  half-diamond',
     +                   '  full-diamond' /
C
C First time initialise the plotting parameters
C
      TAB_ALL = .TRUE.
      IF (FIRST) THEN
         FIRST = .FALSE.
         DO I = 1, 100
            JSAV(I) = I
            K(I) = JSAV(I)
         ENDDO
         DO I = 1, 12
            L(I) = 1
            M(I) = 0
            PLOT(I) = .TRUE.
         ENDDO
         NPTS = 100
         XSTART = - TEN
         XSTOP = TEN
         XDELTA = (XSTOP - XSTART)/(DBLE(NPTS) - ONE)
         X1(1) = XSTART
         DO I = 2, NPTS - 1
            X1(I) = X1(I - 1) + XDELTA
         ENDDO
         X1(NPTS) = XSTOP
         IF (NPTS.LT.NMAX) THEN
            DO I = NPTS + 1, NMAX
               X1(I) = XSTOP
            ENDDO
         ENDIF
      ENDIF
C
C Initialise Yi every time
C
      DO I = 1, 2
         Y1(I) = ONE
         Y2(I) = ONE
         Y3(I) = ONE
         Y4(I) = ONE
         Y5(I) = ONE
         Y6(I) = ONE
         Y7(I) = ONE
         Y8(I) = ONE
         Y9(I) = ONE
         Y10(I) = ONE
         Y11(I) = ONE
         Y12(I) = ONE
      ENDDO
C
C Main branch point
C
      NUMDEC = 4
      REPEET = .TRUE.
      DO WHILE (REPEET)
C .....................................................................
C Top of main loop ....................................................
C .....................................................................

C
C Check that K(I) make sense
C
      DO I = 1, 12
         IF (JSAV(I).LE.NEQN) THEN
            K(I) = JSAV(I)
         ELSE
            K(I) = I
         ENDIF
      ENDDO
C
C Assign symbols for menu
C
      DO I = 1, 12
         YI(I) = BLANK
         FI(I) = BLANK
         LTYPE1(I) = BLANK
         MTYPE1(I) = BLANK
         SYMBOL(I) = BLANK
         IF (I.LE.NEQN) THEN
            WRITE (YI(I),'(I3)') I
            IF (PLOT(I)) THEN
               SYMBOL(I) = 'Yes'
               LTYPE1(I) = LTYPE(L(I))
               MTYPE1(I) = MTYPE(M(I))
               WRITE (FI(I),'(I3)') K(I)
             ELSE
               SYMBOL(I) = ' No'
             ENDIF
         ENDIF
      ENDDO
      D10(1) = FORMGR(XSTART)
      D10(2) = FORMGR(XSTOP)
      I12 = FORM12(NPTS)
      WRITE (TEXT,100) TRIM(D10(1)), TRIM(D10(2)), TRIM(I12),
     +                 (YI(I), FI(I), LTYPE1(I), MTYPE1(I), SYMBOL(I),
     +                  I = 1, 12)
      TAB_ALL = .TRUE.
      NUMOPT = 5
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, TEXT,
     +             TAB_ALL, TAB_ALL, TAB_ALL)
      TAB_ALL = .FALSE.
      IF (NUMDEC.EQ.1) THEN
C
C New x-coordinates
C
         WRITE (TEXT,200)
         NUMOPT = 4
         NUMDEC = NUMOPT
         CALL LBOX02 (ICOLOR, IXL, IYL, NUMDEC, NUMOPT, NUMPOS, TEXT)
         IF (NUMDEC.EQ.1) THEN
C
C Assign XSTART, XSTOP, NPTS, X1 interactively
C
            LINE = 'Number of x-coordinates required'
            IBOT = 2
            ITOP = NMAX
            CALL GETJM1 (IBOT, NPTS, ITOP, LINE)
            D10(1) = FORMGR(XSTART)
            D10(2) = FORMGR(XSTOP)
            WRITE (LINE,300) TRIM(D10(1)), TRIM(D10(2))
            CALL GETDG2 (XSTART, XSTOP, LINE)
            XDELTA = (XSTOP - XSTART)/(DBLE(NPTS) - ONE)
            X1(1) = XSTART
            DO I = 2, NPTS - 1
               X1(I) = X1(I - 1) + XDELTA
            ENDDO
            X1(NPTS) = XSTOP
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Read in X1 from a file or terminal
C
            NPTVAL = 0
            CALL GETNOU (NIN)
            CLOSE (UNIT = NIN)
            JSEND = 3
            CALL VEC1IN (JSEND, NIN, NMAX, NPTVAL,
     +                   XVALS,
     +                   FNAME, TITLE,
     +                   ABORT, FIXNPT, LABEL)
            CLOSE (UNIT = NIN)
            IF (ABORT .OR. NPTVAL.LT.2) THEN
               CALL PUTADV (
     +'Insufficient data  ...  x-coordinates will not be changed')
            ELSE
               NPTS = NPTVAL
               OK = .TRUE.
               DO I = 1, NPTS
                  X1(I) = XVALS(I)
                  IF (OK .AND. I.GT.1) THEN
                     IF (X1(I).LT.X1(I - 1)) OK = .FALSE.
                  ENDIF
               ENDDO
               IF (.NOT.OK) CALL PUTADV (
     +'x-coordinates are not all in increasing order')
               XSTART = X1(1)
               XSTOP = X1(1)
               DO I = 2, NPTS
                  IF (X1(I).LT.XSTART) XSTART = X1(I)
                  IF (X1(I).GT.XSTOP) XSTOP = X1(I)
               ENDDO
            ENDIF
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Edit X1
C
            JSEND = 2
            LINE = 'X-coordinates'
            CALL EDITOR (JSEND, JTYPE, NCOLS, NMAX, NPTS,
     +                   X1,
     +                   LINE,
     +                   CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT)
            OK = .TRUE.
            DO I = 2, NPTS
               IF (OK) THEN
                  IF (X1(I).LT.X1(I - 1)) OK = .FALSE.
               ENDIF
            ENDDO
            IF (.NOT.OK) CALL PUTADV (
     +'x-coordinates are not all in increasing order')
         ENDIF
         NUMDEC = 4
      ELSEIF (NUMDEC.EQ.2) THEN
C
C Select indices for mapping
C
          NUMDEC = 4
          IBOT = 0
          I = 0
          ITOP = MIN(12, NEQN)
          CALL GETJM1 (IBOT, I, ITOP,
     +    'index, i.e. the i value for the y(i) selected (O=none)')
          IF (I.NE.0) THEN
             IBOT = 1
             ITOP = NEQN
             WRITE (LINE,400) I
             CALL GETJM1 (IBOT, JSAV(I), ITOP, LINE)
          ENDIF
      ELSEIF (NUMDEC.EQ.3) THEN
C
C Select indices for symbol/line-types
C
          NUMDEC = 4
          IBOT = 0
          I = 0
          ITOP = MIN(12, NEQN)
          CALL GETJM1 (IBOT, I, ITOP,
     +    'index, i.e. the i value for the y(i) selected (O=none)')
          IF (I.NE.0) THEN
             WRITE (TEXT,500)
             IBOT = L(I) + 1
             ITOP = 5
             ISTART = 1
             ITEXT = 5
             CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, IBOT, ITOP,
     +                    NUMPOS, ISTART, ITEXT, TEXT,
     +                 TAB_ALL, TAB_ALL, TAB_ALL)

             L(I) = IBOT - 1
             WRITE (TEXT,600)
             IBOT = M(I) + 1
             ITOP = 17
             ITEXT = 17
             CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, IBOT, ITOP,
     +                    NUMPOS, ISTART, ITEXT, TEXT,
     +                    TAB_ALL, TAB_ALL, TAB_ALL)
             M(I) = IBOT - 1
             CALL YESNO2 (ICOLOR, IXL, IYL,
     +                   'Plot this y(i) component ?', PLOT(I))
         ENDIF
      ELSEIF (NUMDEC.EQ.4) THEN
C
C Evaluate the functions F(i) then assign the Yi
C
         DO I = 1, NPTS
            XTEMP = X1(I)
            CALL QNUSER (ISEND,
     +                   KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                   NEQN, NPAR, NVAR, NX,
     +                   A, F, XTEMP, Y, YDE, YJA, Z,
     +                   MODNAM,
     +                   ABORT, DEQN)
            IF (NEQN.EQ.1) THEN
               Y1(I) = F(K(1))
            ELSEIF (NEQN.EQ.2) THEN
               Y1(I) = F(K(1))
               Y2(I) = F(K(2))
            ELSEIF (NEQN.EQ.3) THEN
               Y1(I) = F(K(1))
               Y2(I) = F(K(2))
               Y3(I) = F(K(3))
            ELSEIF (NEQN.EQ.4) THEN
               Y1(I) = F(K(1))
               Y2(I) = F(K(2))
               Y3(I) = F(K(3))
               Y4(I) = F(K(4))
            ELSEIF (NEQN.EQ.5) THEN
               Y1(I) = F(K(1))
               Y2(I) = F(K(2))
               Y3(I) = F(K(3))
               Y4(I) = F(K(4))
               Y5(I) = F(K(5))
            ELSEIF (NEQN.EQ.6) THEN
               Y1(I) = F(K(1))
               Y2(I) = F(K(2))
               Y3(I) = F(K(3))
               Y4(I) = F(K(4))
               Y5(I) = F(K(5))
               Y6(I) = F(K(6))
            ELSEIF (NEQN.EQ.7) THEN
               Y1(I) = F(K(1))
               Y2(I) = F(K(2))
               Y3(I) = F(K(3))
               Y4(I) = F(K(4))
               Y5(I) = F(K(5))
               Y6(I) = F(K(6))
               Y7(I) = F(K(7))
            ELSEIF (NEQN.EQ.8) THEN
               Y1(I) = F(K(1))
               Y2(I) = F(K(2))
               Y3(I) = F(K(3))
               Y4(I) = F(K(4))
               Y5(I) = F(K(5))
               Y6(I) = F(K(6))
               Y7(I) = F(K(7))
               Y8(I) = F(K(8))
            ELSEIF (NEQN.EQ.9) THEN
               Y1(I) = F(K(1))
               Y2(I) = F(K(2))
               Y3(I) = F(K(3))
               Y4(I) = F(K(4))
               Y5(I) = F(K(5))
               Y6(I) = F(K(6))
               Y7(I) = F(K(7))
               Y8(I) = F(K(8))
               Y9(I) = F(K(9))
            ELSEIF (NEQN.EQ.10) THEN
               Y1(I) = F(K(1))
               Y2(I) = F(K(2))
               Y3(I) = F(K(3))
               Y4(I) = F(K(4))
               Y5(I) = F(K(5))
               Y6(I) = F(K(6))
               Y7(I) = F(K(7))
               Y8(I) = F(K(8))
               Y9(I) = F(K(9))
               Y10(I) = F(K(10))
            ELSEIF (NEQN.EQ.11) THEN
               Y1(I) = F(K(1))
               Y2(I) = F(K(2))
               Y3(I) = F(K(3))
               Y4(I) = F(K(4))
               Y5(I) = F(K(5))
               Y6(I) = F(K(6))
               Y7(I) = F(K(7))
               Y8(I) = F(K(8))
               Y9(I) = F(K(9))
               Y10(I) = F(K(10))
               Y11(I) = F(K(11))
            ELSEIF (NEQN.GE.12) THEN
               Y1(I) = F(K(1))
               Y2(I) = F(K(2))
               Y3(I) = F(K(3))
               Y4(I) = F(K(4))
               Y5(I) = F(K(5))
               Y6(I) = F(K(6))
               Y7(I) = F(K(7))
               Y8(I) = F(K(8))
               Y9(I) = F(K(9))
               Y10(I) = F(K(10))
               Y11(I) = F(K(11))
               Y12(I) = F(K(12))
            ENDIF
         ENDDO
C
C Set all the line/symbol types to zero
C
         L1 = 0
         L2 = 0
         L3 = 0
         L4 = 0
         L5 = 0
         L6 = 0
         L7 = 0
         L8 = 0
         L9 = 0
         L10 = 0
         L11 = 0
         L12 = 0
         M1 = 0
         M2 = 0
         M3 = 0
         M4 = 0
         M5 = 0
         M6 = 0
         M7 = 0
         M8 = 0
         M9 = 0
         M10 = 0
         M11 = 0
         M12 = 0
         N1 = 2
         N2 = 2
         N3 = 2
         N4 = 2
         N5 = 2
         N6 = 2
         N7 = 2
         N8 = 2
         N9 = 2
         N10 = 2
         N11 = 2
         N12 = 2
C
C Assign appropriate line/symbol types
C
         IF (NEQN.EQ.1) THEN
            L1 = L(1)
            M1 = M(1)
            N1 = NPTS
         ELSEIF (NEQN.EQ.2) THEN
            L1 = L(1)
            L2 = L(2)
            M1 = M(1)
            M2 = M(2)
            N1 = NPTS
            N2 = NPTS
         ELSEIF (NEQN.EQ.3) THEN
            L1 = L(1)
            L2 = L(2)
            L3 = L(3)
            M1 = M(1)
            M2 = M(2)
            M3 = M(3)
            N1 = NPTS
            N2 = NPTS
            N3 = NPTS
         ELSEIF (NEQN.EQ.4) THEN
            L1 = L(1)
            L2 = L(2)
            L3 = L(3)
            L4 = L(4)
            M1 = M(1)
            M2 = M(2)
            M3 = M(3)
            M4 = M(4)
            N1 = NPTS
            N2 = NPTS
            N3 = NPTS
            N4 = NPTS
         ELSEIF (NEQN.EQ.5) THEN
            L1 = L(1)
            L2 = L(2)
            L3 = L(3)
            L4 = L(4)
            L5 = L(5)
            M1 = M(1)
            M2 = M(2)
            M3 = M(3)
            M4 = M(4)
            M5 = M(5)
            N1 = NPTS
            N2 = NPTS
            N3 = NPTS
            N4 = NPTS
            N5 = NPTS
         ELSEIF (NEQN.EQ.6) THEN
            L1 = L(1)
            L2 = L(2)
            L3 = L(3)
            L4 = L(4)
            L5 = L(5)
            L6 = L(6)
            M1 = M(1)
            M2 = M(2)
            M3 = M(3)
            M4 = M(4)
            M5 = M(5)
            M6 = M(6)
            N1 = NPTS
            N2 = NPTS
            N3 = NPTS
            N4 = NPTS
            N5 = NPTS
            N6 = NPTS
         ELSEIF (NEQN.EQ.7) THEN
            L1 = L(1)
            L2 = L(2)
            L3 = L(3)
            L4 = L(4)
            L5 = L(5)
            L6 = L(6)
            L7 = L(7)
            M1 = M(1)
            M2 = M(2)
            M3 = M(3)
            M4 = M(4)
            M5 = M(5)
            M6 = M(6)
            M7 = M(7)
            N1 = NPTS
            N2 = NPTS
            N3 = NPTS
            N4 = NPTS
            N5 = NPTS
            N6 = NPTS
            N7 = NPTS
         ELSEIF (NEQN.EQ.8) THEN
            L1 = L(1)
            L2 = L(2)
            L3 = L(3)
            L4 = L(4)
            L5 = L(5)
            L6 = L(6)
            L7 = L(7)
            L8 = L(8)
            M1 = M(1)
            M2 = M(2)
            M3 = M(3)
            M4 = M(4)
            M5 = M(5)
            M6 = M(6)
            M7 = M(7)
            M8 = M(8)
            N1 = NPTS
            N2 = NPTS
            N3 = NPTS
            N4 = NPTS
            N5 = NPTS
            N6 = NPTS
            N7 = NPTS
            N8 = NPTS
         ELSEIF (NEQN.EQ.9) THEN
            L1 = L(1)
            L2 = L(2)
            L3 = L(3)
            L4 = L(4)
            L5 = L(5)
            L6 = L(6)
            L7 = L(7)
            L8 = L(8)
            L9 = L(9)
            M1 = M(1)
            M2 = M(2)
            M3 = M(3)
            M4 = M(4)
            M5 = M(5)
            M6 = M(6)
            M7 = M(7)
            M8 = M(8)
            M9 = M(9)
            N1 = NPTS
            N2 = NPTS
            N3 = NPTS
            N4 = NPTS
            N5 = NPTS
            N6 = NPTS
            N7 = NPTS
            N8 = NPTS
            N9 = NPTS
         ELSEIF (NEQN.EQ.10) THEN
            L1 = L(1)
            L2 = L(2)
            L3 = L(3)
            L4 = L(4)
            L5 = L(5)
            L6 = L(6)
            L7 = L(7)
            L8 = L(8)
            L9 = L(9)
            L10 = L(10)
            M1 = M(1)
            M2 = M(2)
            M3 = M(3)
            M4 = M(4)
            M5 = M(5)
            M6 = M(6)
            M7 = M(7)
            M8 = M(8)
            M9 = M(9)
            M10 = M(10)
            N1 = NPTS
            N2 = NPTS
            N3 = NPTS
            N4 = NPTS
            N5 = NPTS
            N6 = NPTS
            N7 = NPTS
            N8 = NPTS
            N9 = NPTS
            N10 = NPTS
         ELSEIF (NEQN.EQ.11) THEN
            L1 = L(1)
            L2 = L(2)
            L3 = L(3)
            L4 = L(4)
            L5 = L(5)
            L6 = L(6)
            L7 = L(7)
            L8 = L(8)
            L9 = L(9)
            L10 = L(10)
            L11 = L(11)
            M1 = M(1)
            M2 = M(2)
            M3 = M(3)
            M4 = M(4)
            M5 = M(5)
            M6 = M(6)
            M7 = M(7)
            M8 = M(8)
            M9 = M(9)
            M10 = M(10)
            M11 = M(11)
            N1 = NPTS
            N2 = NPTS
            N3 = NPTS
            N4 = NPTS
            N5 = NPTS
            N6 = NPTS
            N7 = NPTS
            N8 = NPTS
            N9 = NPTS
            N10 = NPTS
            N11 = NPTS
         ELSEIF (NEQN.GE.12) THEN
            L1 = L(1)
            L2 = L(2)
            L3 = L(3)
            L4 = L(4)
            L5 = L(5)
            L6 = L(6)
            L7 = L(7)
            L8 = L(8)
            L9 = L(9)
            L10 = L(10)
            L11 = L(11)
            L12 = L(12)
            M1 = M(1)
            M2 = M(2)
            M3 = M(3)
            M4 = M(4)
            M5 = M(5)
            M6 = M(6)
            M7 = M(7)
            M8 = M(8)
            M9 = M(9)
            M10 = M(10)
            M11 = M(11)
            M12 = M(12)
            N1 = NPTS
            N2 = NPTS
            N3 = NPTS
            N4 = NPTS
            N5 = NPTS
            N6 = NPTS
            N7 = NPTS
            N8 = NPTS
            N9 = NPTS
            N10 = NPTS
            N11 = NPTS
            N12 = NPTS
         ENDIF
C
C Suppress if required
C
         IF (.NOT.PLOT(1)) THEN
            L1 = 0
            M1 = 0
            N1 = 2
         ENDIF
         IF (.NOT.PLOT(2)) THEN
            L2 = 0
            M2 = 0
            N2 = 2
         ENDIF
         IF (.NOT.PLOT(3)) THEN
            L3 = 0
            M3 = 0
            N3 = 2
         ENDIF
         IF (.NOT.PLOT(4)) THEN
            L4 = 0
            M4 = 0
            N4 = 2
         ENDIF
         IF (.NOT.PLOT(5)) THEN
            L5 = 0
            M5 = 0
            N5 = 2
         ENDIF
         IF (.NOT.PLOT(6)) THEN
            L6 = 0
            M6 = 0
            N6 = 2
         ENDIF
         IF (.NOT.PLOT(7)) THEN
            L7 = 0
            M7 = 0
            N7 = 2
         ENDIF
         IF (.NOT.PLOT(8)) THEN
            L8 = 0
            M8 = 0
            N8 = 2
         ENDIF
         IF (.NOT.PLOT(9)) THEN
            L9 = 0
            M9 = 0
            N9 = 2
         ENDIF
         IF (.NOT.PLOT(10)) THEN
            L10 = 0
            M10 = 0
            N10 = 2
         ENDIF
         IF (.NOT.PLOT(11)) THEN
            L11 = 0
            M11 = 0
            N11 = 2
         ENDIF
         IF (.NOT.PLOT(12)) THEN
            L12 = 0
            M12 = 0
            N12 = 2
         ENDIF
C
C Call the graphics routine
C
         CALL GKS012 (L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12,
     +                M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12,
     +                N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12,
     +                X1, X1, X1, X1, X1, X1, X1, X1, X1, X1, X1, X1,
     +                Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10, Y11, Y12,
     +                PTITLE, XTITLE, YTITLE, GSAVE, GSAVE)
      ELSE
         REPEET = .FALSE.
      ENDIF
C
C .....................................................................
C Bottom of main loop .................................................
C .....................................................................
C
      ENDDO
  100 FORMAT (
     + 'X_start =',1X,A,', X_stop =',1X,A
     +/'number of points =',1X,A
     +/'y(i) f(i)    line-type    symbol-type plot'
     +/A,'  ',A,'  ',A,' ',A,' ',A
     +/A,'  ',A,'  ',A,' ',A,' ',A
     +/A,'  ',A,'  ',A,' ',A,' ',A
     +/A,'  ',A,'  ',A,' ',A,' ',A
     +/A,'  ',A,'  ',A,' ',A,' ',A
     +/A,'  ',A,'  ',A,' ',A,' ',A
     +/A,'  ',A,'  ',A,' ',A,' ',A
     +/A,'  ',A,'  ',A,' ',A,' ',A
     +/A,'  ',A,'  ',A,' ',A,' ',A
     +/A,'  ',A,'  ',A,' ',A,' ',A
     +/A,'  ',A,'  ',A,' ',A,' ',A
     +/A,'  ',A,'  ',A,' ',A,' ',A
     +/'Change number of points and/or x-coordinates'
     +/'Change mappping from f(i) to y(j)'
     +/'Change line-types, symbol-types'
     +/'Display'
     +/'Cancel')
  200 FORMAT (
     + 'Calculate new x-coordinates'
     +/'Read in new x-coordinates'
     +/'Edit current x-coordinates'
     +/'Cancel')
  300 FORMAT (
     +'X_start, X-stop (current values =',1X,A,',',1X,A,')')
  400 FORMAT ('number of the function to be assiged to y(',I2,')')
  500 FORMAT ('No line plotted'
     +/'Solid (line)'
     +/'Dashed (line)'
     +/'Dotted (line)'
     +/'Dash/Dot (line)')
  600 FORMAT ('no plot symbol'
     +/'point (.)'
     +/'plus sign (+)'
     +/'multiply sign'
     +/'asterisk (*)'
     +/'circle (open)'
     +/'circle (half)'
     +/'circle (full)'
     +/'triangle (open)'
     +/'triangle (half)'
     +/'triangle (full)'
     +/'square (open)'
     +/'square (half)'
     +/'square (full)'
     +/'diamond (open)'
     +/'diamond (half)'
     +/'diamond (full)')
      END
C
C
      SUBROUTINE PLOT02 (KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                   NEQN, NPAR, NVAR, NX,
     +                   A, F, X, Y, YDE, YJA, Z,
     +                   MODNAM)
C
C ACTION : Output of calculated data to screen or file
C          Subroutine required by program USERMOD to plot a surface
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,10/7/97
C          Derived from OUTDAT of program MAKDAT
C          18/10/2001 edited to call QNUSER directly
C          24/06/2003 changed to request values for K20
C
      IMPLICIT   NONE
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      INTEGER    NEQN, NPAR, NVAR, NX
      DOUBLE PRECISION A(KMAX_A), F(KMAX_F), X, Y,
     +                 YDE(KMAX_Y), YJA(KMAX_J), Z
C
C Special data for surface plotting: NMAX must agree with SURD2S$
C
      INTEGER    I, J, K1, K20
      INTEGER    ISEND, JSEND, NMAX, NXX, NYY
      PARAMETER (ISEND = 2, JSEND = 4, K1 = 1, NMAX = 100)
      DOUBLE PRECISION XDELTA, XXMAX, XXMIN
      DOUBLE PRECISION YDELTA, YYMAX, YYMIN
      DOUBLE PRECISION ZZ(NMAX,NMAX)
      DOUBLE PRECISION VECTOR (NMAX*NMAX + 6)
      CHARACTER  MODNAM(24)*80
      LOGICAL    UNUSED(NMAX,NMAX)
      LOGICAL    ABORT, DEQN
      PARAMETER (DEQN = .FALSE.)
      EXTERNAL   QNUSER, GETDG2, GETJM1
      EXTERNAL   SURD2S
      INTRINSIC  DBLE
      SAVE       XXMAX, XXMIN, YYMAX, YYMIN
      SAVE       K20
      DATA       K20 / 20 /
      DATA       XXMIN, XXMAX / -1.5D+00, 1.5D+00 /
      DATA       YYMIN, YYMAX / -1.5D+00, 1.5D+00 /  
C
C
C First of all calculate NXX, NYY, XXMAX, XXMIN, YYMAX, YYMIN
C
      CALL GETDG2 (XXMIN, XXMAX, 'X_start, X_stop values required')
      CALL GETDG2 (YYMIN, YYMAX, 'Y_start, Y_stop values required')
      I = 2
      J = 100
      CALL GETJM1 (I, K20, J,
     +            'Number of subdivisions of the x and y axes required')
      NXX = K20
      NYY = K20
C
C Now fill in ZZ since JSEND = 4
C
      XDELTA = (XXMAX - XXMIN)/DBLE(NXX - K1)
      YDELTA = (YYMAX - YYMIN)/DBLE(NYY - K1)
      Y = YYMIN - YDELTA
      DO J = K1, NYY
         X = XXMIN - XDELTA
         Y = Y + YDELTA
         DO I = K1, NXX
            X = X + XDELTA
            CALL QNUSER (ISEND,
     +                   KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                   NEQN, NPAR, NVAR, NX,
     +                   A, F, X, Y, YDE, YJA, Z,
     +                   MODNAM,
     +                   ABORT, DEQN)
            ZZ(I,J) = F(K1)
         ENDDO
      ENDDO
      CALL SURD2S (JSEND, NMAX, NXX, NYY,
     +             VECTOR, XXMAX, XXMIN, YYMAX, YYMIN, ZZ,
     +             UNUSED)
      END
C
C
