C
C
C USERMOD3.INS
C ============
C
C AREA01
C AREA0N
C ROOTER
C ZEROSN
C MINIMA
C USER_FUNC
C USER_SUB
C ZERFCN
C ESTIMS
C
C
      SUBROUTINE AREA01 (KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                   NEQN, NOUT, NPAR, NVAR, NX,
     +                   A, F, USER_FUNC, X, Y, YDE, YJA, Z,
     +                   MODNAM)
      USE MODULE_USERMOD, ONLY : NLIMIT, BLIM, EPSABS, EPSREL, TLIM
C
C Area by Simpson's rule and adaptive quadrature
C
      IMPLICIT   NONE
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      INTEGER    NEQN, NOUT, NPAR, NVAR, NX
      INTEGER    ISEND, NSIM, N1, N2, N10
      PARAMETER (ISEND = 2, NSIM = 100, N1 = 1, N2 = 2, N10 = 10)
      INTEGER    I, JCOLOR, NMULT, NPTS
      INTEGER    IFAIL, LW, LIW
      PARAMETER (LW = 2000, LIW = LW/4)
      INTEGER    IW(LIW)
      INTEGER    NUMTXT
      PARAMETER (NUMTXT = 10)
      DOUBLE PRECISION A(KMAX_A), F(KMAX_F), USER_FUNC,
     +                 X, Y, YDE(KMAX_Y), YJA(KMAX_J), Z
      DOUBLE PRECISION AREA, DELTA, YVAL(N10*NSIM + N1), X1, XN
      DOUBLE PRECISION AA, ABSERR, BB, RESUL, W(LW)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 13) D13(7), SHOWLJ
      CHARACTER (LEN = 12) I12(2), FORM12
      CHARACTER  MODNAM(24)*80
      CHARACTER  TEXT(NUMTXT)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, DEQN, FIRST
      PARAMETER (DEQN = .FALSE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   GETDG2, TABLE1, SIMSON, PUTADV, GETJM1
      EXTERNAL   USER_FUNC
      EXTERNAL   QNUSER
      EXTERNAL   D01AJF$
      INTRINSIC  DBLE
      SAVE       NMULT, NPTS, X1, XN , FIRST
      DATA       NMULT, NPTS  / 1, 100 /
      DATA       X1, XN / ZERO, ONE /
      DATA       FIRST / .TRUE. /
      E_NUMBERS = E_FORMATS()
      CALL GETDG2 (X1, XN,
     +            'Range (A, B) required for integration (where A < B)')
      IF (FIRST) THEN
         FIRST = .FALSE.
         NMULT = 1
         CALL GETJM1 (N1, NMULT, N10,
     +'N for N*100 Simpson rule divisions during the current run')
         NPTS = NMULT*NSIM + N1
      ENDIF   
      DELTA = (XN - X1)/(DBLE(NPTS - N1))
      X = X1
      CALL QNUSER (ISEND,
     +             KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +             NEQN, NPAR, NVAR, NX,
     +             A, F, X, Y, YDE, YJA, Z,
     +             MODNAM,
     +             ABORT, DEQN)
      YVAL(1) = F(1)
      DO I = N2, NPTS - N1
         X = X + DELTA
         CALL QNUSER (ISEND,
     +                KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                NEQN, NPAR, NVAR, NX,
     +                A, F, X, Y, YDE, YJA, Z,
     +                MODNAM,
     +                ABORT, DEQN)
         YVAL(I) = F(1)
      ENDDO
      X = XN
      CALL QNUSER (ISEND,
     +             KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +             NEQN, NPAR, NVAR, NX,
     +             A, F, X, Y, YDE, YJA, Z,
     +             MODNAM,
     +             ABORT, DEQN)
      YVAL(NPTS) = F(1)
C
C Use Simpson's rule
C
      CALL SIMSON (NPTS, AREA, X1, XN, YVAL)
C
C Use adaptive quadrature
C
      AA = X1
      BB = XN
      IFAIL = 1
      CALL D01AJF$(USER_FUNC, AA, BB, EPSABS, EPSREL, RESUL, ABSERR,
     +             W, LW, IW, LIW, IFAIL)
      IF (IFAIL.NE.0) CALL PUTADV (
     +'IFAIL nonzero  ...  Try new epsabs, epsrel values ?')
      WRITE (NOUT,'(A)') BLANK
      JCOLOR = 15
      IF (E_NUMBERS) THEN
         WRITE (NOUT,100) X1, XN, NPTS - 1, AREA,
     +                    IFAIL, EPSABS, EPSREL, ABSERR, RESUL
         WRITE (TEXT,100) X1, XN, NPTS - 1, AREA,
     +                    IFAIL, EPSABS, EPSREL, ABSERR, RESUL
      ELSE
         I12(1) = FORM12(NPTS - 1)
         I12(2) = FORM12(IFAIL)
         D13(1) = SHOWLJ(X1)
         D13(2) = SHOWLJ(XN)
         D13(3) = SHOWLJ(AREA)
         D13(4) = SHOWLJ(EPSABS)
         D13(5) = SHOWLJ(EPSREL)
         D13(6) = SHOWLJ(ABSERR)
         D13(7) = SHOWLJ(RESUL)
         WRITE (NOUT,150) TRIM(D13(1)), D13(2), I12(1), D13(3),
     +                    I12(2), D13(4), D13(5), D13(6), D13(7)
         WRITE (TEXT,150) TRIM(D13(1)), D13(2), I12(1), D13(3),
     +                    I12(2), D13(4), D13(5), D13(6), D13(7)
      ENDIF  
      CALL TABLE1 (JCOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1) THEN
            JCOLOR = 4
         ELSE
            JCOLOR = 0
         ENDIF
         CALL TABLE1 (JCOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (JCOLOR, 'CLOSE')
C
C format statements
C      
  100 FORMAT (
     + 'Numerical quadrature over the range: ',1P,E11.3,', ',E11.3
     +/
     +/'Number of Simpson divisions  =',I6
     +/'Area by the Simpson rule     =',E15.7
     +/
     +/'IFAIL (from D01AJF)          =',I6
     +/'EPSABS                       =',E11.3
     +/'EPSREL                       =',E11.3
     +/'ABSERR                       =',E11.3
     +/'Area by adaptive integration =',E15.7)
  150 FORMAT (
     + 'Numerical quadrature over the range: ',1X,A,', ',1X,A
     +/
     +/'Number of Simpson divisions  =',1X,A
     +/'Area by the Simpson rule     =',1X,A
     +/
     +/'IFAIL (from D01AJF)          =',1X,A
     +/'EPSABS                       =',1X,A
     +/'EPSREL                       =',1X,A
     +/'ABSERR                       =',1X,A
     +/'Area by adaptive integration =',1X,A)    
      END
C
C
      SUBROUTINE AREA0N (NEQN, NOUT, NVAR,
     +                   USER_SUB)
      USE MODULE_USERMOD, ONLY : NLIMIT, BLIM, EPSABS, EPSREL, TLIM
C
C Area by D01EAF
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN) :: NEQN, NOUT, NVAR
C
C Locals
C      

C
C Specify the maximum possible number of equations and variables
C
      INTEGER    NEMAX, NVMAX
      PARAMETER (NEMAX = 20, NVMAX = 20)
C
C These then define LENWRK
C
      
      INTEGER    LENWRK
      PARAMETER (LENWRK = 10*(6*NVMAX + 9*NEMAX +
     +          (NVMAX + NEMAX + 2)))
      INTEGER    MAXCLS, MINCLS, MULFAC
      INTEGER    I, ICOLOR, IFAIL, NDIM, NFUN
      DOUBLE PRECISION ABSEST(NLIMIT), FINEST(NLIMIT), WRKSTR(LENWRK),
     +                 ABSREQ, RELREQ
      DOUBLE PRECISION ERROR, ERROR_TEST
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00) 
      CHARACTER (LEN = 100) LINE, TEXT(30)
      CHARACTER (LEN = 13 ) D13(3), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 12 ) I12(2), FORM12
      CHARACTER (LEN = 1  ) BLANK, CIPHER(NEMAX), STAR
      PARAMETER (BLANK = ' ', STAR = '*')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    AGAIN, OK
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ, SHOWRJ
      EXTERNAL   USER_SUB, TABLE1, GETL01, PUTADV
      EXTERNAL   D01EAF$
      INTRINSIC  ABS, MAX
      E_NUMBERS = E_FORMATS()
      NDIM = NVAR
      NFUN = NEQN
      ABSREQ = EPSABS
      RELREQ = EPSREL
      MAXCLS = 1 + 8*NDIM + 6*NDIM*(NDIM - 1) + 2**NDIM + 
     +         4*NDIM*(NDIM - 2)/3
      IF (NDIM.LE.10) THEN
         MULFAC = 2**NDIM
      ELSE
         MULFAC = 2*NDIM**3
      ENDIF      
      MINCLS = 0
      MAXCLS = NDIM**2*MAXCLS
c
c Start of loop for reverse communication
c      
   20 CONTINUE
C
C call the integrator
C   
      IFAIL = -1
      CALL D01EAF$(NDIM, BLIM, TLIM, MINCLS, MAXCLS, NFUN, USER_SUB,
     +             ABSREQ, RELREQ, LENWRK, WRKSTR, FINEST, ABSEST,
     +             IFAIL)
C
C Check if IFAIL > 1
C     
      IF (IFAIL.GT.1) THEN
         WRITE (LINE,'(A,I4,A)') 'IFAIL =', IFAIL,
     +'from D01EAF: change: model, limits, EPSABS, EPSREL ?' 
         CALL PUTADV (LINE)
         RETURN
      ENDIF
C
C Check the error estimates
C Note that DCUHRE does the exit test before refining the FINEST and ABSEST estimates
C so it can return IFAIL = 0 even though this fails with the returned values. That is
C why there is an additional test to define CIPHER and re-define IFAIL if necessary.  
C      
      ERROR_TEST = ZERO
      DO I = 1, NFUN
         ERROR = MAX(ABSREQ,RELREQ*ABS(FINEST(I)))
         IF (ERROR.GT.ERROR_TEST) ERROR_TEST = ERROR
      ENDDO 
      OK = .TRUE.
      DO I = 1, NFUN
         IF (ABSEST(I).GT.ERROR_TEST) THEN
            OK = .FALSE.
            CIPHER(I) = STAR
         ELSE   
            CIPHER(I) = BLANK
         ENDIF
         IF (OK) IFAIL = 0
      ENDDO            
C
C Output results
C
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      WRITE (NOUT,'(A)') BLANK
      IF (E_NUMBERS) THEN
         WRITE (NOUT,100) IFAIL, EPSABS, EPSREL, MINCLS, ERROR_TEST
         WRITE (TEXT,100) IFAIL, EPSABS, EPSREL, MINCLS, ERROR_TEST
      ELSE
         I12(1) = FORM12(IFAIL)
         I12(2) = FORM12(MINCLS)
         D13(1) = SHOWLJ(EPSABS)
         D13(2) = SHOWLJ(EPSREL)
         D13(3) = SHOWLJ(ERROR_TEST)
         WRITE (NOUT,150) TRIM(I12(1)), D13(1), D13(2), TRIM(I12(2)), 
     +                    TRIM(D13(3))
         WRITE (TEXT,150) TRIM(I12(1)), D13(1), D13(2), TRIM(I12(2)),
     +                    TRIM(D13(3))
      ENDIF  
      ICOLOR = 0
      DO I = 1, 6
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      WRITE (NOUT,200)
      WRITE (LINE,200)
      ICOLOR = 4
      CALL TABLE1 (ICOLOR, LINE)
      ICOLOR = 0
      DO I = 1, NDIM
         IF (E_NUMBERS) THEN
            WRITE (NOUT,300) I, BLIM(I), TLIM(I)
            WRITE (LINE,300) I, BLIM(I), TLIM(I)
         ELSE
            D13(1) = SHOWRJ(BLIM(I))
            D13(2) = SHOWRJ(TLIM(I))
            WRITE (NOUT,350) I, D13(1), D13(2)
            WRITE (LINE,350) I, D13(1), D13(2)
         ENDIF  
         CALL TABLE1 (ICOLOR, LINE)
      ENDDO
      WRITE (NOUT,400)
      WRITE (LINE,400)
      ICOLOR = 4
      CALL TABLE1 (ICOLOR,LINE)
      ICOLOR = 0
      DO I = 1, NFUN
         IF (E_NUMBERS) THEN
            WRITE (NOUT,500) I, FINEST(I), ABSEST(I), CIPHER(I)
            WRITE (LINE,500) I, FINEST(I), ABSEST(I), CIPHER(I)
         ELSE
            D13(1) = SHOWRJ(FINEST(I))
            D13(2) = SHOWRJ(ABSEST(I))
            WRITE (NOUT,550) I, D13(1), D13(2), CIPHER(I)
            WRITE (LINE,550) I, D13(1), D13(2), CIPHER(I) 
         ENDIF  
         CALL TABLE1 (ICOLOR, LINE)
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
C
C Option to repeat if IFAIL = 1
C
      IF (IFAIL.NE.0) THEN
         AGAIN = .FALSE.
         CALL GETL01 ('IFAIL nonzero ... Continue iteration ?', 
     +                AGAIN)
         IF (AGAIN) THEN
            MAXCLS = MULFAC*MAXCLS
            MINCLS = -1
            GOTO 20
         ENDIF
      ENDIF      
C
C Format statements
C              
  100 FORMAT (
     + 'IFAIL  =',I6,1X,'(from D01EAF)'
     +/'EPSABS =',1P,E10.3
     +/'EPSREL =',   E10.3
     +/'MINCLS =',I6,1X,'(Function evaluations)'
     +/'TESTER =',  E10.3,1X,'(Error threshold: * where exceeded)'
     +/)
  150 FORMAT (
     + 'IFAIL  =',1X,A,1X,'(from D01EAF)'
     +/'EPSABS =',1X,A
     +/'EPSREL =',1X,A
     +/'MINCLS =',1X,A,1X,'(Function evaluations)'
     +/'TESTER =',1X,A,1X,'(Error threshold: * where exceeded)'
     +/)    
  200 FORMAT (' Number          BLIM           TLIM')
  300 FORMAT (I6,1P,2(2X,E13.5))
  350 FORMAT (I6,2(2X,A13)) 
  400 FORMAT (' Number      INTEGRAL         ABSEST')
  500 FORMAT (I6,1P,2(2X,E13.5),1X,A) 
  550 FORMAT (I6,2(2X,A13), 1X,A) 
      END
C
C
      SUBROUTINE ROOTER (KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                   NEQN, NOUT, NPAR, NVAR, NX,
     +                   A, F, Y, YDE, YJA, Z,
     +                   MODNAM)
      USE MODULE_USERMOD, ONLY : NLIMIT, BLIM, EPSABS, EPSREL, TLIM     
C
C Find a root of Y - F(1) = 0
C
      IMPLICIT   NONE
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      INTEGER    NEQN, NOUT, NPAR, NVAR, NX
      INTEGER    ISEND, NREPS
      PARAMETER (ISEND = 2, NREPS = 12)
      INTEGER    I, ICOUNT, IFAIL, IND, IR, NDEC
      INTEGER    COLOUR
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4,  LSHADE = 4, NUMOPT = 2,
     +           NSTART = 6, NTEXT = 7)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION A(KMAX_A), F(KMAX_F), Y,
     +                 YDE(KMAX_Y), YJA(KMAX_J), Z
      DOUBLE PRECISION X1, X2
      DOUBLE PRECISION X1SAV, X2SAV, YSAV
      DOUBLE PRECISION FREPS, ZERO, ONE, ONE_M
      PARAMETER (FREPS = 2.0D+00, ZERO = 0.0D+00, ONE = 1.0D+00,
     +           ONE_M = -ONE)
      DOUBLE PRECISION C(17)
      DOUBLE PRECISION FX, F1, F2, TEMP, TOLX
      CHARACTER (LEN = 13) D13(4), SHOWLJ, SHOWRJ
      CHARACTER  MODNAM(24)*80
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    ABORT, DEQN
      PARAMETER (DEQN = .FALSE.)
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   C05AZF$
      EXTERNAL   PUTWAR, PUTBEL, GETD01, GETDG2, PUTTXT, TABLE1, LBOX01
      EXTERNAL   QNUSER
      SAVE       X1SAV, X2SAV, YSAV
      DATA       X1SAV, X2SAV, YSAV / ONE_M, ONE, ZERO /
      DATA       NUMBLD  / 1*1, 6*0 /
      DATA       NUMPOS / NUMOPT*1 /
      INTRINSIC  TRIM
      E_NUMBERS = E_FORMATS()
      CALL GETD01 (YSAV,
     +'Y-value you want so Y_value = f(X_required) (e.g. 0 for a root)')
      Y = YSAV
      CALL GETDG2 (X1SAV, X2SAV,
     +'Interval A, B (where A < X_required < B, [y-f(A)][y-f(B)] < 0)')
      X1 = X1SAV
      X2 = X2SAV
   10 CONTINUE
      IF (X1.GT.X2) THEN
         TEMP = X2
         X2 = X1
         X1 = TEMP
         CALL PUTWAR ('A > B ... Values reversed')
      ENDIF
      ICOUNT = 0
C
C Open TABLE1
C
      COLOUR = 15
      CALL TABLE1 (COLOUR, 'OPEN')
   20 CONTINUE
      CALL QNUSER (ISEND,
     +             KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +             NEQN, NPAR, NVAR, NX,
     +             A, F, X1, Y, YDE, YJA, Z,
     +             MODNAM,
     +             ABORT, DEQN)
      F1 = F(1) - Y
      CALL QNUSER (ISEND,
     +             KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +             NEQN, NPAR, NVAR, NX,
     +             A, F, X2, Y, YDE, YJA, Z,
     +             MODNAM,
     +             ABORT, DEQN)
      F2 = F(1) - Y
      IF (F1*F2.GT.ZERO) THEN
         CALL PUTBEL
         ICOUNT = ICOUNT + 1
         IF (ICOUNT.EQ.1) THEN
            COLOUR = 0
            WRITE (LINE,100)
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
         IF (E_NUMBERS) THEN
            WRITE (LINE,200) X1, F1, X2, F2
         ELSE
            D13(1) = SHOWRJ(X1)
            D13(2) = SHOWRJ(F1)
            D13(3) = SHOWRJ(X2)
            D13(4) = SHOWRJ(F2) 
            WRITE (LINE,250) D13(1), D13(2), D13(3), D13(4)
         ENDIF   
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
         IF (ICOUNT.LE.NREPS) THEN
            IF (X1.GE.ZERO) THEN
               X1 = X1/FREPS
            ELSE
               X1 = X1*FREPS
            ENDIF
            IF (X2.GE.ZERO) THEN
               X2 = X2*FREPS
            ELSE
               X2 = X2/FREPS
            ENDIF
            GOTO 20
         ELSE
            GOTO 50
         ENDIF
      ENDIF
      IF (ICOUNT.GT.0) THEN
         CALL TABLE1 (COLOUR, 'CLOSE')
         COLOUR = 15
         CALL TABLE1(COLOUR, 'OPEN')
         COLOUR = 0
      ENDIF
      TOLX = EPSREL
      IR = 2
      IND = 1
      IFAIL = 1
   30 CONTINUE
      CALL C05AZF$(X1, X2, FX, TOLX, IR, C, IND, IFAIL)
      IF (IND.EQ.0) GOTO 40
      IF (IND.LT.2 .OR. IND.GT.4) GOTO 50
      CALL QNUSER (ISEND,
     +             KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +             NEQN, NPAR, NVAR, NX,
     +             A, F, X1, Y, YDE, YJA, Z,
     +             MODNAM,
     +             ABORT, DEQN)
      FX = F(1) - Y
      GOTO 30
   40 CONTINUE
      WRITE (NOUT,'(A)') BLANK
      IF (IFAIL.EQ.0) THEN
         CALL TABLE1 (COLOUR, 'CLOSE')
         IF (E_NUMBERS) THEN
            WRITE (NOUT,300) X1, EPSREL
            WRITE (LINE,300) X1, EPSREL
         ELSE
            D13(1) = SHOWLJ(X1)
            D13(2) = SHOWLJ(EPSREL)  
            WRITE (NOUT,350) TRIM(D13(1)), TRIM(D13(2))
            WRITE (LINE,350) TRIM(D13(1)), TRIM(D13(2))  
         ENDIF  
         CALL PUTTXT (LINE)
         RETURN
      ENDIF
      CALL QNUSER (ISEND,
     +             KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +             NEQN, NPAR, NVAR, NX,
     +             A, F, X1, Y, YDE, YJA, Z,
     +             MODNAM,
     +             ABORT, DEQN)
      F1 = F(1) - Y
      CALL QNUSER (ISEND,
     +             KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +             NEQN, NPAR, NVAR, NX,
     +             A, F, X2, Y, YDE, YJA, Z,
     +             MODNAM,
     +             ABORT, DEQN)
      F2 = F(1) - Y
      IF (E_NUMBERS) THEN
         WRITE (NOUT,400) IFAIL, X1, F1, X2, F2
         WRITE (TEXT,400) IFAIL, X1, F1, X2, F2
      ELSE
         D13(1) = SHOWLJ(X1)
         D13(2) = SHOWLJ(F1)
         D13(3) = SHOWLJ(X2)
         D13(4) = SHOWLJ(F2)  
         WRITE (NOUT,450) IFAIL, TRIM(D13(1)), TRIM(D13(2)), 
     +                    TRIM(D13(3)), TRIM(D13(4))
         WRITE (TEXT,450) IFAIL, TRIM(D13(1)), TRIM(D13(2)), 
     +                    TRIM(D13(3)), TRIM(D13(4))
      ENDIF  
      COLOUR = 0
      DO I = 1, 3
         CALL TABLE1 (COLOUR, TEXT(I))
      ENDDO
   50 CONTINUE
C
C Close TABLE1
C
      CALL TABLE1 (COLOUR, 'CLOSE')
      WRITE (TEXT,500)
      CALL PUTBEL
      NDEC = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, TEXT, BORDER, FLASH, HIGH)
      IF (NDEC.EQ.1) THEN
         CALL GETD01 (Y, 'Value you want for Y_input = f(X_required)')
         CALL GETDG2 (X1, X2,
     +  'A, B ... (where A < X_required < B, [y-f(A)][y-f(B)] < 0)')
         GOTO 10
      ENDIF
  100 FORMAT (13X,'A',6X,'y - f(A)',13X,'B',6X,'y - f(B)')
  200 FORMAT (1P,4(1X,E13.5))
  250 FORMAT (4(1X,A13))
  300 FORMAT ('Success : Root =',1P,E13.5,' (EPSREL =',E13.5,')')
  350 FORMAT ('Success : Root =',1X,A,' (EPSREL =',1X,A,')')
  400 FORMAT (
     + 'Warning : IFAIL =',I2,1X,'from C05AZF/ROOTER'
     +/'At x = A, y - f(',1P,1X,E13.5,') =',1X,E13.5
     +/'At x = B, y - f(',1X,E13.5,') =',1X,E13.5)
  450 FORMAT (
     + 'Warning : IFAIL =',I2,1X,'from C05AZF/ROOTER'
     +/'At x = A, y - f(',A,') =',1X,A
     +/'At x = B, y - f(',A,') =',1X,A)   
  500 FORMAT (
     + '*error* `No solution found for A, B, y provided'
     +/'Reason  `Failure to supply sensible start values'
     +/'Advice  `Study mathematical model more carefully'
     +/'        `Display graph in the region of interest'
     +/
     +/'Try again with new A, B, y values'
     +/'Cancel')
      END
C
C
      SUBROUTINE ZEROSN (NEQN, NOUT,
     +                   EPSREL, ZDE)
C
C Find a root of n equations in n unknowns
C
      IMPLICIT   NONE
      INTEGER    NEQN, NOUT
      INTEGER    N, IFAIL
      INTEGER    NMAX
      PARAMETER (NMAX = 100)
      INTEGER    I, ICOLOR
      INTEGER    IUSER(NMAX)
      DOUBLE PRECISION EPSREL, ZDE(NEQN)
      DOUBLE PRECISION FVEC(NMAX),  X(NMAX)
      DOUBLE PRECISION EPSMIN, FNORM, XTOL
      DOUBLE PRECISION X02AJF$
      DOUBLE PRECISION RUSER(NMAX)
      DOUBLE PRECISION EPSMAX, ZERO, BIG
      PARAMETER (EPSMAX = 1.0D-03, ZERO = 0.0D+00, BIG = 100.0D+00)
      CHARACTER  LINE*100
      CHARACTER (LEN = 13) D13(2), SHOWLJ
      CHARACTER (LEN = 12) FORM12, WORD12
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    AGAIN
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   C05QBF$, X02AJF$
      EXTERNAL   ZERFCN
      EXTERNAL   TABLE1, ESTIMS, FORM12
      INTRINSIC  SQRT
      E_NUMBERS = E_FORMATS()
      EPSMIN = 10.0D+00*SQRT(X02AJF$())
      IF (EPSREL.LT.EPSMIN) THEN
         XTOL = EPSMIN
      ELSEIF (EPSREL.GT.EPSMAX) THEN
         XTOL = EPSMAX
      ELSE
         XTOL = EPSREL
      ENDIF
   20 CONTINUE     
      N = NEQN
      DO I = 1, N
         IUSER(I) = 0
         RUSER(I) = ZERO
         X(I) = ZDE(I)
         FVEC(I) = BIG
      ENDDO
      IFAIL = 1
      CALL C05QBF$(ZERFCN, N, X, FVEC, XTOL, IUSER, RUSER, IFAIL)
      FNORM = ZERO
      DO I = 1, N
         FNORM = FNORM + FVEC(I)*FVEC(I)
      ENDDO
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      WRITE (NOUT,'(A)') BLANK
      IF (E_NUMBERS) THEN
         WRITE (NOUT,100) IFAIL, FNORM, XTOL
         WRITE (LINE,100) IFAIL, FNORM, XTOL
      ELSE
         D13(1) = SHOWLJ(FNORM)
         D13(2) = SHOWLJ(XTOL)
         WRITE (NOUT,150) IFAIL, TRIM(D13(1)), D13(2)
         WRITE (LINE,150) IFAIL, TRIM(D13(1)), D13(2)
      ENDIF  
      ICOLOR = 4
      CALL TABLE1 (ICOLOR, LINE)
      WORD12 = FORM12(IUSER(1))
      WRITE (NOUT,200) WORD12
      WRITE (LINE,200) WORD12
      CALL TABLE1 (ICOLOR, LINE)
      ICOLOR = 0
      CALL TABLE1 (ICOLOR, ' ')
      DO I = 1, N
         IF (E_NUMBERS) THEN
            WRITE (NOUT,300) I, X(I), I, FVEC(I)
            WRITE (LINE,300) I, X(I), I, FVEC(I)
         ELSE
            D13(1) = SHOWLJ(X(I))
            D13(2) = SHOWLJ(FVEC(I))
            WRITE (NOUT,350) I, D13(1), I, D13(2)
            WRITE (LINE,350) I, D13(1), I, D13(2)  
         ENDIF  
         CALL TABLE1 (ICOLOR, LINE)
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
      CALL ESTIMS (IFAIL, N, 
     +             X, ZDE, 
     +             'C05QBF',
     +             AGAIN)
      IF (AGAIN) GOTO 20 
  100 FORMAT (
     +'From C05QBF: IFAIL =',I3,', FNORM =',1P,E10.3,', XTOL =',E10.3)
  150 FORMAT (
     +'From C05QBF: IFAIL =',I3,', FNORM =',1X,A,', XTOL =',1X,A)   
  200 FORMAT ('Number of function evaluations =',1X,A)     
  300 FORMAT ('x(',I3,') =',1P,E13.5,' ... fvec(',I3,') =',E13.5)
  350 FORMAT ('x(',I3,') =',1X,A13,' ... fvec(',I3,') =',1X,A)
      END
C
C
      SUBROUTINE MINIMA (NEQN, NIN, NOUT, NPMAX, NVAR,
     +                   TEMP, W, XBOT, XMID, XTOP)
C
C ACTION: optimise using LBFGSB
C AUTHOR: w.g.bardsley, university of manchester, u.k., 18/06/2003
C         24/01/2007 introduced full_path and sim256
C
C         NEQN = no. equations
C         NIN = unit for reading in data
C         NOUT = results UNIT
C         NPMAX = array dimension for TEMP
C         NVAR = no. variables
C         TEMP = workspace
C         W = workspace
C         XBOT, XMID, XTOP = starting estimates and bounds
C
C         Code derived from DRIVER1 of LBFGSB suite
C
      IMPLICIT   NONE
C
C Arguments supplied
C
      INTEGER    NEQN, NIN, NOUT, NPMAX, NVAR
      DOUBLE PRECISION TEMP(NPMAX,3), W(NPMAX), XBOT(NVAR), XMID(NVAR),
     +                 XTOP(NVAR)
C
C LBFGS parameters
C
      integer    nmax, mmax, lenwa
      parameter (nmax  = 1000, mmax = 17)
      parameter (lenwa = 2*mmax*nmax +  4*nmax + 11*mmax*mmax + 8*mmax)

c nmax  is the dimension of the largest problem to be solved.
c mmax  is the maximum number of limited memory corrections.
c lenwa is the corresponding real workspace required.

c Declare the variables needed by the code.
c A description of all these variables is given at the end of
c the driver.
                             
      character        full_path*1024, sim256*1024
      character*60     task, csave
      logical          lsave(4)
      integer          n, m, iprint,
     +                 nbd(nmax), iwa(3*nmax), isave(44)
      double precision f, factr, pgtol,
     +                 x(nmax), l(nmax), u(nmax), g(nmax), dsave(29),
     +                 wa(lenwa)
C
C Local parameters
C
      INTEGER    I, ICOLOR, ICOUNT, ISEND, J, JCOUNT, K, NCMAX, NCOL,
     +           NITER, NROW
      INTEGER    IX, IY, NUMDEC, NUMOPT
      PARAMETER (IX = 4, IY = 4, NUMOPT = 9)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    N0, N1, N2, N3, N4, NBIG
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, NBIG = 101)
      DOUBLE PRECISION VALUES(NMAX)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER (LEN = 13) D13(2), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 12) I12(2), FORM12 
      CHARACTER  CIPHER*20, LINE*100, TEXT(30)*100
      CHARACTER  FNAME*1024, TITLE*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    AGAIN, FIRST, GRADVEC, REPEET
      LOGICAL    ABORT
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL1, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE.,
     +           LABEL1 = .TRUE., ORDER = .FALSE., WEIGHT = .FALSE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ, SHOWRJ
      EXTERNAL   PUTADV, SETULB, TABLE1, LBOX02, GETJM1, GETDGE, EDITOR,
     +           MATTIN, SIM256
      EXTERNAL   USER_SUB
      INTRINSIC  MIN, TRIM
      SAVE       FIRST, GRADVEC
      SAVE       M, NITER, FACTR, PGTOL
      DATA       FIRST, GRADVEC / .TRUE., .TRUE. /
      DATA       M, NITER  / 5, 5 /
      DATA       FACTR, PGTOL / 1.0D+07, 1.0D-05 /
      DATA       NUMPOS / NUMOPT*1 /
C
C check that a model is available
C
      IF (NVAR.LT.N1 .OR. NEQN.NE.NVAR + N1) THEN
         WRITE (LINE,100)
         CALL PUTADV (LINE)
         RETURN
      ENDIF
C
C Main loop
C
      E_NUMBERS = E_FORMATS()
      REPEET = .TRUE.
      DO WHILE (REPEET)
         ICOLOR = 7
         IF (GRADVEC) THEN
            CIPHER = '[Yes]'
         ELSE
            CIPHER = '[No]'
         ENDIF
         IF (E_NUMBERS) THEN
            WRITE (TEXT,200) M, FACTR, PGTOL, NITER, CIPHER
         ELSE
            I12(1) = FORM12(M)
            I12(2) = FORM12(NITER)
            D13(1) = SHOWLJ(FACTR)
            D13(2) = SHOWLJ(PGTOL)
            WRITE (TEXT,250) TRIM(I12(1)), TRIM(D13(1)), TRIM(D13(2)), 
     +                       TRIM(I12(2)), CIPHER
         ENDIF  
         NUMDEC = NUMOPT - N1
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
         IF (NUMDEC.EQ.1) THEN
C
C New m
C
            I = N4
            J = M
            K = MMAX
            WRITE (LINE,300)
            CALL GETJM1 (I, J, K, LINE)
            M = J
         ELSEIF (NUMDEC.EQ.2) THEN
C
C New factr
C
            WRITE (LINE,400)
            CALL GETDGE (FACTR, ZERO, LINE)
         ELSEIF (NUMDEC.EQ.3) THEN
C
C new pgtol
C
            WRITE (LINE,500)
            CALL GETDGE (PGTOL, ZERO, LINE)
         ELSEIF (NUMDEC.EQ.4) THEN
C
C New niter
C
            I = N0
            J = NITER
            K = NBIG
            WRITE (LINE,600)
            CALL GETJM1 (I, J, K, LINE)
            NITER = J
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Gradient vector
C
            GRADVEC = .NOT.GRADVEC
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Edit XBOT, XMID, XTOP
C
            DO I = N1, NVAR
               TEMP(I,N1) = XBOT(I)
               TEMP(I,N2) = XMID(I)
               TEMP(I,N3) = XTOP(I)
            ENDDO
            WRITE (LINE,700)
            FIXROW = .TRUE.
            CALL EDITOR (N2, N1, N3, NPMAX, NVAR, TEMP, LINE,
     +                   CURVE, FIXCOL, FIXROW, LABEL1, ORDER, WEIGHT)
            DO I = N1, NVAR
               IF (TEMP(I,N1).LE.TEMP(I,N2) .AND.
     +             TEMP(I,N2).LE.TEMP(I,N3)) THEN
                  XBOT(I) = TEMP(I,N1)
                  XMID(I) = TEMP(I,N2)
                  XTOP(I) = TEMP(I,N3)
               ELSE
                  WRITE (LINE,800) I
                  CALL PUTADV (LINE)
               ENDIF
            ENDDO
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Read in data
C
            CLOSE (UNIT = NIN)
            ISEND = N3
            NCMAX = N3
            NCOL = N3
            FIXROW = .FALSE.
            CALL MATTIN (ISEND, NCMAX, NCOL, NIN, NPMAX, NROW,
     +                   TEMP, W,
     +                   FNAME, TITLE,
     +                   ABORT, FIXCOL, FIXROW, LABEL1)
            CLOSE (UNIT = NIN)
            IF (.NOT.ABORT .AND. NROW.GE.N1) THEN
               DO I = N1, MIN(NVAR, NROW)
                  IF (TEMP(I,N1).LE.TEMP(I,N2) .AND.
     +                TEMP(I,N2).LE.TEMP(I,N3)) THEN
                     XBOT(I) = TEMP(I,N1)
                     XMID(I) = TEMP(I,N2)
                     XTOP(I) = TEMP(I,N3)
                  ELSE
                     WRITE (LINE,800) I
                     CALL PUTADV (LINE)
                  ENDIF
               ENDDO
            ENDIF
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C Optimisation 1: ... First assign LBFGS parameters
C
            n = nvar
            do i = 1, n
               l(i) = xbot(i)
               x(i) = xmid(i)
               u(i) = xtop(i)
               nbd(i) = 2
            enddo
C
C Optimisation 2: ... Now prepare to call to LBFGSB
C
            ICOUNT = -N1
            JCOUNT = NITER - N2
            WRITE (NOUT,'(A)') BLANK
            WRITE (NOUT,1000)
            WRITE (LINE,1000)
            ICOLOR = 15
            CALL TABLE1 (ICOLOR, 'OPEN')
            ICOLOR = N4
            CALL TABLE1 (ICOLOR, LINE)
            ICOLOR = N0
c
c Optimisation 3: ... We start the iteration by initializing task.
c
            task = 'START'
c
c Optimisation 4: ------- The beginning of the loop ----------
c
            again = .true.
            iprint = niter
            if (first) then
               first = .false.
               full_path = sim256('w_usermod.err') 
               open (unit = 6, file = full_path)
               full_path = sim256('iterate.txt')
               open (unit = 8, file = full_path)
            endif
            do while (again)
c
c This is the call to the L-BFGS-B code.
c
               call setulb(n,m,x,l,u,nbd,f,g,factr,pgtol,wa,iwa,task,
     +                     iprint,csave,lsave,isave,dsave)

               if (task(1:2) .eq. 'FG') then
c
c The minimization routine has returned to request the
c function f and gradient g values at the current x.
c
c Compute function value f and g for the sample problem.
c
                  call user_sub (nvar, x, neqn, values)
                  f = values(1)
                  do i = n1, n
                     g(i) = values(i + n1)
                  enddo
c
c Go back to the minimization routine.
c
                  again = .true.

               elseif (task(1:5) .eq. 'NEW_X') then
c
c The minimization routine has returned with a new iterate,
c and we have opted to continue the iteration.
c
                  icount = icount + n1
                  jcount = jcount + n1
                  if (iprint.gt.100 .or. jcount.eq.niter) then
                     jcount = 0
                     if (e_numbers) then
                        write (nout,1100) icount, f, dsave(13), task
                        write (line,1100) icount, f, dsave(13), task
                     else
                        d13(1) = showrj(f)
                        d13(2) = showrj(dsave(13))
                        write (nout,1150) icount, d13(1), d13(2), task
                        write (line,1150) icount, d13(1), d13(2), task
                     endif  
                     call table1 (icolor, line)
                  endif
                  again = .true.

               else

                  again = .false.
c
c We terminate execution when task is neither FG nor NEW_X.
c We print the information contained in the string task
c if the default output is not used and the execution is
c not stopped intentionally by the user.
c

                  if (e_numbers) then
                     write (nout,1100) icount, f, dsave(13), task
                     write (line,1100) icount, f, dsave(13), task
                  else
                      d13(1) = showrj(f)
                      d13(2) = showrj(dsave(13)) 
                      write (nout,1150) icount, d13(1), d13(2), task
                      write (line,1150) icount, d13(1), d13(2), task

                  endif  
                  icolor = n4
                  call table1 (icolor, line)
                  if (gradvec) then
                     icolor = n1
                     line = blank
                     write (nout,'(a)') line
                     call table1 (icolor,line)
                     do i = n1, nvar
                        if (e_numbers) then
                           write (nout,1200) i, x(i), i, g(i)
                           write (line,1200) i, x(i), i, g(i)
                        else
                           i12(1) = form12(i)
                           d13(1) = showlj(x(i))
                           d13(2) = showlj(g(i))
                           write (nout,1250) trim(i12(1)), d13(1),
     +                                       trim(i12(1)), d13(2)
                           write (line,1250) trim(i12(1)), d13(1),
     +                                       trim(i12(1)), d13(2)
                        endif 
                        call table1 (icolor, line)
                     enddo
                  endif
                  call table1 (icolor, 'CLOSE')
c
c Optimisation 5: ---------- The end of the loop -------------
c
                endif
            enddo
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT ('First install a model with n equations, n - 1 variables')
  200 FORMAT (
     + 'New MHESS (Current =',i3,')'
     +/'New FACTR (Current =',1p,e11.3,')'
     +/'New PGTOL (Current =',1p,e11.3,')'
     +/'New IPRINT (Current =',i3,')'
     +/'Display x and dF/dx',1X,A
     +/'New blim/start/tlim: edit'
     +/'New blim/start/tlim: from file'
     +/'Optimise'
     +/'Cancel')
  250 FORMAT (
     + 'New MHESS (Current =',1X,A,')'
     +/'New FACTR (Current =',1X,A,')'
     +/'New PGTOL (Current =',1X,A,')'
     +/'New IPRINT (Current =',1X,A,')'
     +/'Display x and dF/dx',1X,A
     +/'New blim/start/tlim: edit'
     +/'New blim/start/tlim: from file'
     +/'Optimise'
     +/'Cancel')    
  300 FORMAT ('Number of limited memory corrections required')
  400 FORMAT ('Convergence precision factor required')
  500 FORMAT ('Projected gradient tolerance required')
  600 FORMAT (
     +'Number of iterates per printout (or 101 for full output)')
  700 FORMAT ('Edit so that xbot =< xmid =< xtop')
  800 FORMAT ('blim =< start =< tlim violated at line',I4)
 1000 FORMAT ('Iterate          F(x)    |prj.grd.|   Task')
 1100 FORMAT (I7,1P,2(1X,E13.5),3X,A)
 1150 FORMAT (I7,2(1X,A),3X,A)
 1200 FORMAT ('x(',i4,') =',1p,e13.5,' dF(x)/dx(',i4,') =',e13.5)
 1250 FORMAT ('x(',a,') =',1X,A13,'  dF(x)/dx(',a,') =',1X,A)
      END
C
C
c
c        L-BFGS-B is a code for solving large nonlinear optimization
c        problems with simple bounds on the variables.
c
c        The code can also be used for unconstrained problems and is
c        as efficient for these problems as the earlier limited memory
c        code L-BFGS.
c
c     References:
c
c        [1] R. H. Byrd, P. Lu, J. Nocedal and C. Zhu, ``A limited
c        memory algorithm for bound constrained optimization'',
c        SIAM J. Scientific Computing 16 (1995), no. 5, pp. 1190--1208.
c
c        [2] C. Zhu, R.H. Byrd, P. Lu, J. Nocedal, ``L-BFGS-B: FORTRAN
c        Subroutines for Large Scale Bound Constrained Optimization''
c        Tech. Report, NAM-11, EECS Department, Northwestern University,
c        1994.
c
c        (Postscript files of these papers are available via anonymous
c        ftp to ece.nwu.edu in the directory pub/lbfgs/lbfgs_bcm.)
c
c                              *  *  *
c
c        NEOS, November 1994. (Latest revision April 1997.)
c        Optimization Technology Center.
c        Argonne National Laboratory and Northwestern University.
c        Written by
c                           Ciyou Zhu
c        in collaboration with R.H. Byrd, P. Lu-Chen and J. Nocedal.
c

c     --------------------------------------------------------------
c             DESCRIPTION OF THE VARIABLES IN L-BFGS-B
c     --------------------------------------------------------------
c
c     n is an INTEGER variable that must be set by the user to the
c       number of variables.  It is not altered by the routine.
c
c     m is an INTEGER variable that must be set by the user to the
c       number of corrections used in the limited memory matrix.
c       It is not altered by the routine.  Values of m < 3  are
c       not recommended, and large values of m can result in excessive
c       computing time. The range  3 <= m <= 20 is recommended.
c
c     x is a DOUBLE PRECISION array of length n.  On initial entry
c       it must be set by the user to the values of the initial
c       estimate of the solution vector.  Upon successful exit, it
c       contains the values of the variables at the best point
c       found (usually an approximate solution).
c
c     l is a DOUBLE PRECISION array of length n that must be set by
c       the user to the values of the lower bounds on the variables. If
c       the i-th variable has no lower bound, l(i) need not be defined.
c
c     u is a DOUBLE PRECISION array of length n that must be set by
c       the user to the values of the upper bounds on the variables. If
c       the i-th variable has no upper bound, u(i) need not be defined.
c
c     nbd is an INTEGER array of dimension n that must be set by the
c       user to the type of bounds imposed on the variables:
c       nbd(i)=0 if x(i) is unbounded,
c              1 if x(i) has only a lower bound,
c              2 if x(i) has both lower and upper bounds,
c              3 if x(i) has only an upper bound.
c
c     f is a DOUBLE PRECISION variable.  If the routine setulb returns
c       with task(1:2)= 'FG', then f must be set by the user to
c       contain the value of the function at the point x.
c
c     g is a DOUBLE PRECISION array of length n.  If the routine setulb
c       returns with taskb(1:2)= 'FG', then g must be set by the user to
c       contain the components of the gradient at the point x.
c
c     factr is a DOUBLE PRECISION variable that must be set by the user.
c       It is a tolerance in the termination test for the algorithm.
c       The iteration will stop when
c
c        (f^k - f^{k+1})/max{|f^k|,|f^{k+1}|,1} <= factr*epsmch
c
c       where epsmch is the machine precision which is automatically
c       generated by the code. Typical values for factr on a computer
c       with 15 digits of accuracy in double precision are:
c       factr=1.d+12 for low accuracy;
c             1.d+7  for moderate accuracy;
c             1.d+1  for extremely high accuracy.
c       The user can suppress this termination test by setting factr=0.
c
c     pgtol is a double precision variable.
c       On entry pgtol >= 0 is specified by the user.  The iteration
c         will stop when
c
c                 max{|proj g_i | i = 1, ..., n} <= pgtol
c
c         where pg_i is the ith component of the projected gradient.
c       The user can suppress this termination test by setting pgtol=0.
c
c     wa is a DOUBLE PRECISION  array of length
c       (2mmax + 4)nmax + 11mmax^2 + 8mmax used as workspace.
c       This array must not be altered by the user.
c
c     iwa is an INTEGER  array of length 3nmax used as
c       workspace. This array must not be altered by the user.
c
c     task is a CHARACTER string of length 60.
c       On first entry, it must be set to 'START'.
c       On a return with task(1:2)='FG', the user must evaluate the
c         function f and gradient g at the returned value of x.
c       On a return with task(1:5)='NEW_X', an iteration of the
c         algorithm has concluded, and f and g contain f(x) and g(x)
c         respectively.  The user can decide whether to continue or stop
c         the iteration.
c       When
c         task(1:4)='CONV', the termination test in L-BFGS-B has been
c           satisfied;
c         task(1:4)='ABNO', the routine has terminated abnormally
c           without being able to satisfy the termination conditions,
c           x contains the best approximation found,
c           f and g contain f(x) and g(x) respectively;
c         task(1:5)='ERROR', the routine has detected an error in the
c           input parameters;
c       On exit with task = 'CONV', 'ABNO' or 'ERROR', the variable task
c         contains additional information that the user can print.
c       This array should not be altered unless the user wants to
c          stop the run for some reason.  See driver2 or driver3
c          for a detailed explanation on how to stop the run
c          by assigning task(1:4)='STOP' in the driver.
c
c     iprint is an INTEGER variable that must be set by the user.
c       It controls the frequency and type of output generated:
c        iprint<0    no output is generated;
c        iprint=0    print only one line at the last iteration;
c        0<iprint<99 print also f and |proj g| every iprint iterations;
c        iprint=99   print details of every iteration except n-vectors;
c        iprint=100  print also the changes of active set and final x;
c        iprint>100  print details of every iteration including x and g;
c       When iprint > 0, the file iterate.dat (08/03/2017 renamed iterate.txt)
c                        will be created to summarize the iteration.
c
c     csave  is a CHARACTER working array of length 60.
c
c     lsave is a LOGICAL working array of dimension 4.
c       On exit with task = 'NEW_X', the following information is
c         available:
c       lsave(1) = .true.  the initial x did not satisfy the bounds;
c       lsave(2) = .true.  the problem contains bounds;
c       lsave(3) = .true.  each variable has upper and lower bounds.
c
c     isave is an INTEGER working array of dimension 44.
c       On exit with task = 'NEW_X', it contains information that
c       the user may want to access:
c         isave(30) = the current iteration number;
c         isave(34) = the total number of function and gradient
c                         evaluations;
c         isave(36) = the number of function value or gradient
c                                  evaluations in the current iteration;
c         isave(38) = the number of free variables in the current
c                         iteration;
c         isave(39) = the number of active constraints at the current
c                         iteration;
c
c       See the subroutine setulb.f for a description of other
c       information contained in isave.
c
c     dsave is a DOUBLE PRECISION working array of dimension 29.
c       On exit with task = 'NEW_X', it contains information that
c       the user may want to access:
c         dsave(2) = the value of f at the previous iteration;
c         dsave(5) = the machine precision epsmch generated by the code;
c         dsave(13) = the infinity norm of the projected gradient;
c
c       See the subroutine setulb.f for a description of other
c       information contained in dsave.
c
c     --------------------------------------------------------------
c           END OF THE DESCRIPTION OF THE VARIABLES IN L-BFGS-B
c     --------------------------------------------------------------
c
C
C
      DOUBLE PRECISION FUNCTION USER_FUNC (X)
      USE MODULE_USERMOD, ONLY : NEQN, NPAR, NVAR,
     +                           N24, MODNAM,
     +                           NPMAX, NX, A, F, YDE, YJA  
C
C User function
C
      IMPLICIT   NONE
      INTEGER    ISEND
      PARAMETER (ISEND = 2)
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      DOUBLE PRECISION X, Y, Z
      LOGICAL    ABORT, DEQN
      PARAMETER (DEQN = .FALSE.)
      EXTERNAL  QNUSER
      KMAX_A = NPMAX
      KMAX_F = NX
      KMAX_J = NX**2
      KMAX_Y = NX
      CALL QNUSER (ISEND,
     +             KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +             NEQN, NPAR, NVAR, NX,
     +             A, F, X, Y, YDE, YJA, Z,
     +             MODNAM,
     +             ABORT, DEQN)
      USER_FUNC = F(1)
      END
C
C
      SUBROUTINE USER_SUB (NDIM, ZVEC, NFUN, FVEC)
      USE MODULE_USERMOD, ONLY : NEQN, NPAR, NVAR,
     +                           N24, MODNAM,
     +                           NPMAX, NX, A, F, YDE, YJA
C
C User subroutine
C
      IMPLICIT   NONE
      INTEGER    NDIM, NFUN
      INTEGER    I
      INTEGER    ISEND
      PARAMETER (ISEND = 2)
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      DOUBLE PRECISION ZVEC(NDIM), FVEC(NFUN)
      DOUBLE PRECISION X, Y, Z
      LOGICAL    ABORT, DEQN
      PARAMETER (DEQN = .FALSE.)
      EXTERNAL  QNUSER
      KMAX_A = NPMAX
      KMAX_F = NX
      KMAX_J = NX**2
      KMAX_Y = NX
      IF (NDIM.EQ.1) THEN
         X = ZVEC(1)
      ELSEIF (NDIM.EQ.2) THEN
         X = ZVEC(1)
         Y = ZVEC(2)
      ELSEIF (NDIM.EQ.3) THEN
         X = ZVEC(1)
         Y = ZVEC(2)
         Z = ZVEC(3)
      ELSE
         DO I = 1, NDIM
            YDE(I) = ZVEC(I)
         ENDDO
      ENDIF
      CALL QNUSER (ISEND,
     +             KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +             NEQN, NPAR, NVAR, NX,
     +             A, F, X, Y, YDE, YJA, Z,
     +             MODNAM,
     +             ABORT, DEQN)
      DO I = 1, NFUN
         FVEC(I) = F(I)
      ENDDO
      END
C
C
      SUBROUTINE ZERFCN (N, X, FVEC, IUSER, RUSER, IFLAG)
      USE MODULE_USERMOD, ONLY : NEQN, NPAR, NVAR,
     +                           N24, MODNAM,
     +                           NPMAX, NX, A, F, YDE, YJA  
C
C User function for n equations in n unknowns
C 12/07/2016 added IUSER and RUSER to be consistent with C05QBF
C

      IMPLICIT   NONE
      INTEGER    N, IFLAG
      INTEGER    IUSER(*)
      INTEGER    ISEND
      PARAMETER (ISEND = 2)
      INTEGER    I
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      DOUBLE PRECISION X(N), FVEC(N)
      DOUBLE PRECISION RUSER(*)
      DOUBLE PRECISION X1, Y1, Z1
      DOUBLE PRECISION ONE
      PARAMETER  (ONE = 1.0D+00)
      LOGICAL     ABORT, DEQN
      PARAMETER  (DEQN = .FALSE.)
      EXTERNAL    QNUSER
      I = IFLAG!to stop ftn95 complaining
C
C Increment IUSER and RUSER to register function evaluations
C     
      IUSER(1) = IUSER(1) + 1
      RUSER(1) = RUSER(1) + ONE!to stop ftn95 complaining  
C
C Store the current X values
C
      DO I = 1, N
         YDE(I) = X(I)
      ENDDO
C
C Map into x, y, z if N < 3
C
      IF (N.EQ.1) THEN
         X1 = YDE(1)
      ELSEIF (N.EQ.2) THEN
         X1 = YDE(1)
         Y1 = YDE(2)
      ELSEIF (N.EQ.3) THEN
         X1 = YDE(1)
         Y1 = YDE(2)
         Z1 = YDE(3)
      ENDIF
C
C Evaluate the model
C
      KMAX_A = NPMAX
      KMAX_F = NX
      KMAX_J = NX**2
      KMAX_Y = NX
      CALL QNUSER (ISEND,
     +             KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +             NEQN, NPAR, NVAR, NX,
     +             A, F, X1, Y1, YDE, YJA, Z1,
     +             MODNAM,
     +             ABORT, DEQN)
C
C Store the solution
C
      DO I = 1, N
         FVEC(I) = F(I)
      ENDDO
      END
C
C
c
c
      subroutine estims (ifail, n, 
     +                   x, zde,
     +                   sub,
     +                   again)
c
c action: edit starting estimates for usermod
c author: w.g.bardsley, university of manchester, u.k, 12/07/2016
c     
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: ifail
      integer,             intent (in)    :: n
      double precision,    intent (in)    :: x(n) 
      double precision,    intent (inout) :: zde(n)
      character (len = *), intent (in)    :: sub
      logical,             intent (out)   :: again
c
c locals
c      
      integer    i, numdec, numopt, numsta, numtxt 
      parameter (numopt = 7, numsta = 8, numtxt = numsta + numopt - 1)
      integer    isend, ncols, nrmax, nrows
      parameter (isend = 2, ncols = 1, nrmax = 100)  
      integer    numbld(numtxt)
      double precision a(nrmax,ncols), d
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character (len = 100) text(numtxt)
      character (len = 20 ) title
      parameter (title = 'Starting estimates')
      external   lstbox, getd01, editd1
      data       numbld / numtxt*0 /
      if (ifail.eq.0) then
         again = .false.
         return
      else
         again = .true.   
      endif 
      d = zero
      write (text,100) ifail, sub
      numdec = numopt
      numbld(1) = 4
      call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +             text) 
      if (numdec.eq.1) then
         do i = 1, n
            zde(i) = -one
         enddo
      elseif (numdec.eq.2) then
         do i = 1, n
            zde(i) = zero
         enddo
      elseif (numdec.eq.3) then   
         do i = 1, n
            zde(i) = one
         enddo  
      elseif (numdec.eq.4) then
         call getd01 (d, 'Value required')  
         do i = 1, n
            zde(i) = d
         enddo  
      elseif (numdec.eq.5) then 
         nrows = n
         do i = 1, n
            a(i,1) = zde(i)
         enddo   
         call editd1 (isend, ncols, nrmax, nrows, 
     +                a,         
     +                title)
         do i = 1, n
            zde(i) = a(i,1)
         enddo        
      elseif (numdec.eq.6) then 
          do i = 1, n
            zde(i) = x(i)
         enddo         
      else
         again = .false.
      endif 
c
c format statement
c             
  100 format (
     + 'Options to edit starting estimates'
     +/
     +/'IFAIL =',i4,' from',1x,a
     +/
     +/'A good solution point has not been located so you'
     +/'can edit the starting estimates then try again or exit.'
     +/
     +/'Set all estimates to -1'
     +/'Set all estimates to 0'
     +/'Set all estimates to 1'
     +/'Set all estimates to a chosen value'
     +/'Edit the current starting estimates'
     +/'Re-enter from the current position'
     +/'Cancel ... No more calculations')
      end
c
c                

