c
c modchk
c fname_to_filex
c save_filex
c
c
c 
      subroutine modchk (abort, edit)
      use module_usermod, only : nhigh, nlines, nwide,
     +                           text,
     +                           neqn, npar, nvar,
     +                           deqn
c
c action: preliminary checking for a user-defined model
c author: w.g.bardsley, university of manchester, u.k. 03/04/2016
c         17/06/2016 introduced subroutine model_variables to improve checking for x, y, and z 
c
c This subroutine only does very simple checking to prevent a user-defined
c file being submitted for further analysis from program usermod and hence 
c more rigorous checking when there are obvious elementary errors.
c
c  nhigh: length of text array	
c nlines: number of lines in the model file
c  nwide: width of text array
c   text: (len = nwide) 
c  abort: returned .true. if model is inconsistent
c   edit: allows editing if .true.
c

      implicit none
c
c arguments
c      
      logical,                 intent (out)   :: abort 
      logical,                 intent (in)    :: edit  
c
c locals
c      
      integer    i, icount, ios, j, jcount, k, kcount, nstart, nstop
      integer    npar_temp
      integer    n_title, n_head, n_body
      integer    iadd1, jadd1, kadd1
      integer    ncheck
      parameter (ncheck = 100)
      integer    n1, n2, n3
      parameter (n1 = 1, n2 = 2, n3 = 3)
      integer    ipcent, npcent(ncheck)
      integer    icolor, ix, iy,lshade, numcol, numrow, numtxt
      parameter (icolor = 7, ix = 0, iy = 0, lshade = 0, numcol = 0, 
     +           numrow = 0)
      integer    nwide1
      parameter (nwide1 = 100)
      character (len = nwide1) line, x_line 
      character (len = 100) mssage(100)
      character (len = 6  ) cipher, error(0:7), f(ncheck), p(ncheck),
     +                      y(ncheck)
      character (len = 1  ) blank, pcent
      parameter (blank = ' ', pcent = '%') 
      logical    ok_eqn(ncheck), ok_par(ncheck), ok_var(ncheck)
      logical    found, pcent_error
      logical    fixed, flash, high, yes
      parameter (fixed = .false., flash = .false., high = .true.)  
      external   lcase1, edittx, yesno1
      external   model_variables
      intrinsic  adjustl, index, trim
c
c LABEL 20: start of checking sequence
c      
   20 continue
      jcount = 0
      kcount = 0
      do i = 1, nhigh
         if (text(i).ne. blank) then
            jcount = jcount + 1
            line = text(i)
            line = adjustl(line)
            if (line(1:1).eq.pcent) kcount = kcount + 1 
            if (kcount.ge.2) call lcase1 (line)
            text(jcount) = line
         endif
      enddo
      do i = jcount + 1, nhigh
         text(i) = blank
      enddo     
c
c initialise
c    
      abort = .true.
      deqn = .false.
      iadd1 = 0
      jadd1 = 0
      kadd1 = 0
      neqn = -1
      npar = -1
      npar_temp = -1
      nstart = -1
      nvar = -1
      ipcent = 0
      n_title = 0
      n_head = 0
      n_body = 0
      x_line = 'Summary of items declared and numbers counted'
      do i = 1, ncheck
         npcent(i) = -1
         ok_eqn(i) = .false.
         ok_par(i) = .false.
         ok_var(i) = .false.  
         if (i.lt.10) then
            write (p(i),'(a,i1,a)',iostat=ios) 'p(',i,')'
            write (y(i),'(a,i1,a)',iostat=ios) 'y(',i,')'
            write (f(i),'(a,i1,a)',iostat=ios) 'f(',i,')' 
         elseif (i.lt.100) then  
            write (p(i),'(a,i2,a)',iostat=ios) 'p(',i,')'
            write (y(i),'(a,i2,a)',iostat=ios) 'y(',i,')'
            write (f(i),'(a,i2,a)',iostat=ios) 'f(',i,')'     
         else   
            write (p(i),'(a,i3,a)',iostat=ios) 'p(',i,')'
            write (y(i),'(a,i3,a)',iostat=ios) 'y(',i,')'
            write (f(i),'(a,i3,a)',iostat=ios) 'f(',i,')'
         endif
c
c make sure they are left justified as trim will be used with call to index 
c         
         p(i) = adjustl(p(i))
         y(i) = adjustl(y(i))
         f(i) = adjustl(f(i))
      enddo            
c
c find escape characters: npcent(j) is the line number for the j'th % if > 0
c
      do i = 1, nhigh
         cipher = text(i)(1:6)
         cipher = adjustl(cipher)
         if (cipher(1:1).eq.pcent) then
            ipcent = ipcent + 1
            npcent(ipcent) = i
         endif 
      enddo
      do i = nhigh, 1, -1
         if (text(i).ne.blank) then
            nlines = i
            exit
         endif
      enddo      
      pcent_error = .false.
      if (ipcent.lt.4) then
         x_line = '% COUNT ERROR: Must be >= 4 lines starting with a %'
         goto 40
      else
         if (npcent(2).ge.3) then
            n_title = npcent(2) - npcent(1) - 1  
            if (npcent(3).eq.npcent(2) + 4) then
               n_head = npcent(3) - npcent(2) - 1
               if (npcent(4).gt.npcent(3) + 1) then
                  n_body = npcent(4) - npcent(3) - 1
               endif
            endif
         endif         
      endif 
      if (n_title.le.0 .or. n_head.ne.3 .or. n_body.le.0 .or.
     +    nlines.lt.9) then
         pcent_error = .true.
         if (n_title.le.0) then
            x_line = 'TITLE ERROR: Model has not been given a title' 
         elseif (n_head.ne.3) then
            x_line = 'HEADER ERROR: Must have a 3-line header statement'
         else
            x_line = 'MODEL ERROR: Model must have at least one line'
         endif        
         goto 40
      endif   
c
c define nstart and nstop then find npar, nvar, neqn
c     
      nstart = npcent(2) + 1
      nstop = npcent(3) - 1
      icount = 0
      loop_1 : do i = nstart, nstop
         icount = icount + 1
         line = text(i)
         call lcase1 (line)
         if (icount.eq.1) then
            j = index(line,'equation')
            if (j.gt.1 .and. j.lt.6) then 
               j = j - 1
               read (line(1:j),*,iostat=ios) k
               if (ios.eq.0) neqn = k
            endif
         elseif (icount.eq.2) then  
            j = index(line,'differential equation') 
            if (j.gt.0) then 
               deqn = .true.
               nvar = 1
            else   
               j = index(line,'variable')
               if (j.gt.1 .and. j.lt.6) then
                  j = j - 1
                  read (line(1:j),*,iostat=ios) k
                  if (ios.eq.0) nvar = k
               endif
            endif        
         elseif (icount.eq.3) then   
            j = index(line,'parameter')
            if (j.gt.1 .and. j.lt.6) then
               j = j - 1
               read (line(1:j),*,iostat=ios) k
               if (ios.eq.0) npar = k
            endif
         endif
      enddo loop_1
      if (npar.lt.0 .or. nvar.lt.0 .or. neqn.le.0)then
         if (npar.lt.0) then
            x_line = 'HEADER ERROR: Number of parameters must be >= 0'
         elseif (nvar.lt.0) then   
            x_line = 'HEADER ERROR: Number of variables must be >= 0'
         else   
            x_line = 'HEADER ERROR: Number of equations must be > 0'
         endif   
         goto 40
      endif  
     
c
c re-define nstart and nstop then check for parameters
c     
      nstart = npcent(3) + 1
      nstop = npcent(4) - 1
      
      iadd1 = 0
      if (deqn) then
         npar_temp = npar - neqn
      else
         npar_temp = npar
      endif      
      if (npar.gt.0) then
         loop_2 : do i = nstart, nstop
            line = text(i)
            do j = 1, npar_temp
               if (.not.ok_par(j)) then
                  if (index(line,trim(p(j))).gt.0) then
                    ok_par(j) = .true.
                    iadd1 = iadd1 + 1
                  endif 
                  if (iadd1.eq.npar) exit loop_2 
               endif     
            enddo 
         enddo loop_2
      endif
c
c-----------------------------------------------------
c start of check for variables
c      
      jadd1 = 0
      if (nvar.ge.1 .and. nvar.le.3) then
         loop_3 : do i = nstart, nstop
            line = text(i)
            if (nvar.ge.1 .and. .not.ok_var(1)) then
               k = index(line,'x')
               if (k.gt.0) then
                  call model_variables (n1,
     +                                  line,
     +                                  found)                 
                  if (found) then
                     ok_var(1) = .true.
                     jadd1 = jadd1 + 1
                     if (nvar.eq.1) exit loop_3
                  endif 
               endif 
            endif
            if (nvar.ge.2 .and. .not.ok_var(2)) then
               k = index(line,'y')
               if (k.gt.0) then
                  call model_variables (n2,
     +                                  line,
     +                                  found)
                  if (found) then
                     ok_var(2) = .true.
                     jadd1 = jadd1 + 1
                     if (ok_var(1) .and. nvar.eq.2) exit loop_3
                  endif     
               endif
            endif
            if (nvar.eq.3 .and. .not.ok_var(3)) then
               k = index(line,'z')
               if (k.gt.0) then
                  call model_variables (n3,
     +                                  line,
     +                                  found)
                  if (found) then
                     ok_var(3) = .true.
                     jadd1 = jadd1 + 1
                     if (ok_var(1) .and. ok_var(2) .and. 
     +                   nvar.eq.3) exit loop_3
                  endif     
               endif
            endif
         enddo loop_3
      elseif (nvar.gt.3) then
         loop_4 : do i = nstart, nstop
            line = text(i)
            do j = 1, nvar
               if (.not.ok_var(j)) then
                 if (index(line,trim(y(j))).gt.0) then
                    ok_var(j) = .true.
                    jadd1 = jadd1 + 1 
                    if (jadd1.eq.nvar) exit loop_4
                 endif    
               endif    
            enddo 
          enddo loop_4           
      endif
      if (deqn) then
         if (jadd1.le.0) then 
            nvar = 0
         elseif (jadd1.gt.0) then
            nvar = 1
         endif
      endif 
c
c end of check for variables
c---------------------------------------------------------
c
c check for equations
c      
      kadd1 = 0
      loop_5 : do i = nstart, nstop
         line = text(i)
         do j = 1, neqn
            if (.not.ok_eqn(j)) then 
               if (index(line,trim(f(j))).gt.0) then
                  ok_eqn(j) = .true.
                  kadd1 = kadd1 + 1
                  if (kadd1.eq.neqn) exit loop_5    
               endif   
            endif 
         enddo  
      enddo loop_5    
      if (.not.pcent_error .and. npar_temp.eq.iadd1 .and. nvar.eq.jadd1 
     +    .and. neqn.eq.kadd1) then
         abort = .false.
         return
      endif     
c
c LABEL 40: here if errors already found
c        
   40 continue    
      if (deqn .and. npar_temp.ne.iadd1) x_line = 
     +'DEQN ERROR: NEQN parameters also needed for inital conditions' 
      if (edit) then 
         do i = 0, 7
            error(i) = blank
         enddo   
         if (ipcent.lt.4)   error(0) = '*ERROR'
         if (npar_temp.ne.iadd1) error(1) = '*ERROR'
         if (nvar.ne.jadd1) error(2) = '*ERROR'
         if (neqn.ne.kadd1) error(3) = '*ERROR'
         if (n_title.lt.1)  error(4) = '*ERROR'
         if (n_head.ne.3)   error(5) = '*ERROR'
         if (n_body.lt.1)   error(6) = '*ERROR' 
         if (nlines.le.0)   error(7) = '*ERROR'       
         write (mssage,100) ipcent,      error(0),
     +                      npar, iadd1, error(1), 
     +                      nvar, jadd1, error(2), 
     +                      neqn, kadd1, error(3), 
     +                      n_title,     error(4),
     +                      n_head,      error(5), 
     +                      n_body,      error (6), 
     +                      nlines,      error(7)
         mssage(3) = x_line
         numtxt = 18
         if (.not.deqn) mssage(numtxt) = blank
         line = 'Do you want to edit the model now'
         yes = .true.
         call yesno1 (icolor, ix, iy, lshade, numcol, numrow, numtxt,
     +                line, mssage,
     +                fixed, flash, high, yes)           
         if (yes) then
            call edittx (nhigh, nlines, nwide,
     +                   text)
            goto 20
         endif   
      endif     
c
c format statement
c      
  100 format (
     + 'Results from preliminary checking'
     +/
     +/
     +/
     +/'N_ESC =',I4,'` Number of % escape character lines',4x,a
     +/'N_PAR =',i4,'` Number of parameters used =',i4,4x,a
     +/'N_VAR =',i4,'` Number of variables used =',i4,4x,a         
     +/'N_EQN =',i4,'` Number of equations defined =',i4,4x,a
     +/'N_NAM =',i4,'` Number of model name lines (title)',4x,a
     +/'N_DES =',i4,'` Number of description lines (header)',4x,a
     +/'N_MOD =',i4,'` Number of model defining lines (body)',4x,a
     +/'N_COM =',i4,'` Number of lines in file (commands, etc.)',4x,a
     +/
     +/'A model can only be used when the number of parameters'
     +/'required (NPAR), the number of variables declared (NVAR)'
     +/'and the number of equations (NEQN) defined are all consistent.'
     +/
     +/'NVAR can be 0 or 1 for systems of differential equations.')         
      end    
c
c 
      subroutine fname_to_filex (filex, fname,
     +                           abort)
      use module_usermod, only : nhigh, nlines, nwide,
     +                           text        
c
c action: check then copy fname to filex if OK
c author: w.g.bardsley, university of manchester, u.k., 06/04/2016
c
      implicit none 
c
c arguments
c    
      character (len = *), intent (in)    :: fname
      character (len = *), intent (inout) :: filex              
      logical,             intent (out)   :: abort
c
c locals
c
       integer    i, ios, ipcent, l, nin, nout, npcent(3), nstop
       character (len = nwide) line   
       character (len = 1024 ) usr 
       character (len = 6    ) word6
       character (len = 1    ) blank, bslash, pcent
       parameter (blank = ' ', bslash = '\', pcent = '%')
       logical    edit
       parameter (edit = .true.)
       external   getnou, putadv, lcase1, modchk, edittx, usrdir
       intrinsic  adjustl
c
c initialise abort then read the file
c       
       abort = .true.
       do i = 1, nhigh
          text(i) = blank
       enddo   	
       call getnou (nin)
       open (unit = nin, file = fname, iostat = ios)
       nlines = 0
       do while (ios.eq.0)
          read (nin,'(a)',iostat=ios) line
          if (ios.eq.0) then
             nlines = nlines + 1
             text(nlines) = line
          endif   
       enddo
       close (unit = nin)
c
c make a preliminary examination
c       
       ios = 0   
       do i = 1, 3
          npcent(i) = 0
       enddo
       ipcent = 0
       do i = 1, nlines
          word6 = text(i)(1:6)
          word6 = adjustl(word6) 
          if (word6(1:1).eq.pcent) then
             ipcent = ipcent + 1
             npcent(ipcent) = i
          endif
          if (ipcent.eq.3) exit
       enddo 
       if (npcent(1).ne.1) then
          call putadv ('model files must start with a %')
          return
       endif   
       if (npcent(2) - npcent(1) .lt. 2) then
          call putadv ('model files must have a title')
          return
       endif     
       if (npcent(3) - npcent(2) .ne. 4) then
          call putadv ('model files must have a 3 line header')
          return
       endif   
       i = npcent(2) + 1
       line = text(i)
       call lcase1 (line)
       if (index(line,'equation') .lt.3) then
          call putadv ('Header line 1 must be the number of equations')  
          return
       endif
       i = i + 1
       line = text(i) 
       call lcase1 (line)
       if (index(line,'variable').lt.3 .and. 
     +     index(line,'differential equation').eq.0) then
          call putadv (
     +'Header line 2 must be variables or differential equation')  
          return
       endif  
       I = I + 1
       line = text(i)
       call lcase1 (line)
       if (index(line,'parameter') .lt. 3) then
          call putadv ('Header line 3 must be the number of parameters')
          return
       endif
c
c first edit the data
c       
       call edittx (nhigh, nlines, nwide,
     +              text)
c
c now use modchk
c 
      call modchk (abort, edit)   
      if (.not.abort) then
         call usrdir (l,
     +                usr)
         if (usr(l:l).ne.bslash) then
            l = l + 1
            usr(l:l) = bslash             
         endif
         filex = usr(1:l)//'model_xx.tmp'
         call getnou (nout)
         open (unit = nout, file = filex, iostat = ios)
         do i = nhigh, 1, -1
            if (text(i).ne.blank) then
               nstop = i
               exit
            endif
         enddo       
         do i = 1, nstop
            if (ios.eq.0) write (nout,'(a)',iostat=ios) text(i)
         enddo
         close (unit = nout)      
      endif  
      end
c
c     
c
c              
      subroutine save_filex (filex, 
     +                       abort) 
      use module_usermod, only : no_file  
c
c action: save the temporary model file filex
c author: w.g.bardsley, university of manchester, u.k., 07/04/2016              
c
      implicit none
c
c arguments
c
      character (len = *), intent (in)  :: filex
      logical,             intent (out) :: abort
c
c locals
c      
      integer    isend
      parameter (isend = 2) 
      integer    icount, ios, nin, nout
      character (len = 1024) fname
      character (len = 256 ) line
      character (len = 35  ) type1
      character (len = 3   ) ext
      character (len = 1   ) blank
      parameter (blank = ' ',
     +           ext = 'tmp',
     +           type1 = 'Simfit user-defined model')     
      logical    there
      external   getfil, getnou, putadv, infofl
      intrinsic  trim
      abort = .true.
      if (filex.eq.no_file .or. filex.eq.blank) then
         call putadv ('Temporary file does not exist')
         return
      endif   
      inquire (file = filex, exist = there, iostat = ios)
      if (ios.eq.0 .and. .not.there) then
         call putadv ('Temporary file does not exist')
         return
      endif   
      if (ios.ne.0) return  
      call getfil (isend,
     +             ext, fname, type1,
     +             abort)
      if (abort) return
      call getnou (nin)
      open (unit = nin, file = filex, iostat = ios)  
      if (ios.ne.0) then
         abort = .true.
         close (unit = nin)
         return
      endif 
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      if (ios.ne.0) then
         abort = .true.
         close (unit = nout)
         return
      endif
      icount = 0
      do while (ios.eq.0)
         read (nin,'(a)',iostat=ios) line
         if (ios.eq.0) write (nout,'(a)', iostat=ios) trim(line)
         if (ios.eq.0) then
            icount = icount + 1
         else
            exit
         endif        
      enddo
      close (unit = nin)
      close (unit = nout)
      if (icount.lt.9) then
         call putadv ('Saved file cannot be a model file (< 9 lines)') 
         abort = .true.
         return
      else
         call infofl (isend,
     +                fname)         
         abort = .false.
      endif
      end
c
c                         
      
      
        
             
          
           